"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesOrderLine = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PhysicalFlowsData = require("@sage/x3-physical-flows-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const joins = {
    referenceJoins: {
        salesOrder: {
            id: 'salesOrder',
        },
        company: {
            code: 'company',
        },
        soldToCustomer: {
            code: 'soldToCustomer',
        },
        shipToCustomerAddress: {
            customer: 'soldToCustomer',
            shipToAddress: 'shipToCustomerAddress',
        },
        shipToCustomerContact: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'soldToCustomer',
            code: 'shipToCustomerContact',
        },
        billToCustomer: {
            code: 'billToCustomer',
        },
        shippingSite: {
            code: 'shippingSite',
        },
        salesSite: {
            code: 'salesSite',
        },
        product: {
            code: 'product',
        },
        salesRep1: {
            code: 'salesRep1',
        },
        salesRep2: {
            code: 'salesRep2',
        },
        priceReason: {
            code: 'priceReason',
        },
        discountOrCharge1Reason: {
            code: 'discountOrCharge1Reason',
        },
        discountOrCharge2Reason: {
            code: 'discountOrCharge2Reason',
        },
        discountOrCharge3Reason: {
            code: 'discountOrCharge3Reason',
        },
        discountOrCharge4Reason: {
            code: 'discountOrCharge4Reason',
        },
        discountOrCharge5Reason: {
            code: 'discountOrCharge5Reason',
        },
        discountOrCharge6Reason: {
            code: 'discountOrCharge6Reason',
        },
        discountOrCharge7Reason: {
            code: 'discountOrCharge7Reason',
        },
        discountOrCharge8Reason: {
            code: 'discountOrCharge8Reason',
        },
        discountOrCharge9Reason: {
            code: 'discountOrCharge9Reason',
        },
        salesUnit: {
            code: 'salesUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        freeProductLineSource: {
            salesOrder: 'salesOrder',
            lineNumber: 'freeProductLineSource',
            sequenceNumber: 'freeProductLineSource',
        },
        salesQuote: {
            id: 'salesQuote',
        },
        salesQuoteLineNumber: {
            salesQuote: 'salesQuote',
            lineNumber: 'salesQuoteLineNumber',
        },
        sageSalesTax: {
            glossaryId() {
                return 203;
            },
            code: 'sageSalesTax',
        },
        invoicingTerm: {
            code: 'invoicingTerm',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        salesOrderQuantityLine: {
            salesOrder: 'salesOrder',
            lineNumber: 'lineNumber',
            sequenceNumber: 'sequenceNumber',
        },
        orderLineTextRef: {
            async code() {
                return (await this.salesOrderQuantityLine).orderLineTextKey;
            },
        },
        salesOrderLineDimension: {
            abbreviation() {
                return 'SOP';
            },
            typ() {
                return null;
            },
            salesOrder: 'salesOrder',
            salesOrderLine: 'lineNumber',
            sequenceNumber: 'sequenceNumber',
            keyComplement() {
                return null;
            },
            sortValue() {
                return 1;
            },
        },
    },
};
const compositeReferences = {
    salesOrderQuantityLine: {
        allocationType: 'allocationType',
        backToBackOrderLineNumber: 'backToBackOrderLineNumber',
        backToBackOrderNumber: 'backToBackOrderNumber',
        backToBackOrderSequenceNumber: 'backToBackOrderSequenceNumber',
        carrier: 'carrier',
        closingDate: 'closingDate',
        closingReason: 'closingReason',
        completeDeliveryPriority: 'completeDeliveryPriority',
        deliveryLeadTime: 'deliveryLeadTime',
        deliveryMode: 'deliveryMode',
        deliveryPriority: 'deliveryPriority',
        distributedInvoicingElements: 'distributedInvoicingElements',
        exclusiveLotFilter: 'exclusiveLotFilter',
        exclusiveStockStatusFilter: 'exclusiveStockStatusFilter',
        expectedDeliveryDate: 'expectedDeliveryDate',
        geographicCode: 'geographicCode',
        importLineNumber: 'importLineNumber',
        insideCityLimits: 'insideCityLimits',
        invoicedAmount: 'invoicedAmount',
        isComponentPrintedOnAcknowledgement: 'isComponentPrintedOnAcknowledgement',
        isComponentPrintedOnInvoice: 'isComponentPrintedOnInvoice',
        isComponentPrintedOnPackingSlip: 'isComponentPrintedOnPackingSlip',
        isDeliverable: 'isDeliverable',
        isInvoiced: 'isInvoiced',
        isLineWithDistributedInvoicingElement: 'isLineWithDistributedInvoicingElement',
        isRecordedTax: 'isRecordedTax',
        isTaxable: 'isTaxable',
        isTaxedGeographically: 'isTaxedGeographically',
        latestDeliveryDate: 'latestDeliveryDate',
        latestDeliveryTime: 'latestDeliveryTime',
        locationReference: 'locationReference',
        majorProductVersion: 'majorProductVersion',
        minorProductVersion: 'minorProductVersion',
        orderDate: 'orderDate',
        orderLineTextKey: 'orderLineTextKey',
        packaging: 'packaging',
        packagingCapacity: 'packagingCapacity',
        preferentialStockLocationFilter: 'preferentialStockLocationFilter',
        preparationCode: 'preparationCode',
        productSource: 'productSource',
        productStockManagement: 'productStockManagement',
        project: 'project',
        quantityInSalesUnitAllocated: 'quantityInSalesUnitAllocated',
        quantityInSalesUnitDelivered: 'quantityInSalesUnitDelivered',
        quantityInSalesUnitInPreparation: 'quantityInSalesUnitInPreparation',
        quantityInSalesUnitInitiallyOrdered: 'quantityInSalesUnitInitiallyOrdered',
        quantityInSalesUnitInvoiced: 'quantityInSalesUnitInvoiced',
        quantityInSalesUnitOnDeliveryOrScheduledInvoice: 'quantityInSalesUnitOnDeliveryOrScheduledInvoice',
        quantityInSalesUnitOnPickList: 'quantityInSalesUnitOnPickList',
        quantityInSalesUnitOrdered: 'quantityInSalesUnitOrdered',
        quantityInSalesUnitPrepared: 'quantityInSalesUnitPrepared',
        quantityInSalesUnitShortage: 'quantityInSalesUnitShortage',
        quantityInSalesUnitToDeliverForProductsNotManagedInStock: 'quantityInSalesUnitToDeliverForProductsNotManagedInStock',
        quantityInStockUnitAllocated: 'quantityInStockUnitAllocated',
        quantityInStockUnitDelivered: 'quantityInStockUnitDelivered',
        quantityInStockUnitInPreparation: 'quantityInStockUnitInPreparation',
        quantityInStockUnitInvoiced: 'quantityInStockUnitInvoiced',
        quantityInStockUnitOnDeliveryOrScheduledInvoice: 'quantityInStockUnitOnDeliveryOrScheduledInvoice',
        quantityInStockUnitOnPickList: 'quantityInStockUnitOnPickList',
        quantityInStockUnitOrdered: 'quantityInStockUnitOrdered',
        quantityInStockUnitPrepared: 'quantityInStockUnitPrepared',
        quantityInStockUnitShortage: 'quantityInStockUnitShortage',
        quantityInStockUnitToDeliverForProductsNotManagedInStock: 'quantityInStockUnitToDeliverForProductsNotManagedInStock',
        requestedDeliveryDate: 'requestedDeliveryDate',
        requestedDeliveryReference: 'requestedDeliveryReference',
        requestedDeliveryTime: 'requestedDeliveryTime',
        routeNumber: 'routeNumber',
        salesDelivery: 'salesDelivery',
        salesDeliveryLineNumber: 'salesDeliveryLineNumber',
        shipmentDate: 'shipmentDate',
        shipmentTime: 'shipmentTime',
        taxRate: 'taxRate',
        taxableAmount: 'taxableAmount',
        tokenManagement: 'tokenManagement',
        useByDate: 'useByDate',
        volumeDistributedOnLine: 'volumeDistributedOnLine',
        volumeUnitForDistributionOnLines: 'volumeUnitForDistributionOnLines',
        weightDistributedOnLine: 'weightDistributedOnLine',
        weightUnitForDistributionOnLines: 'weightUnitForDistributionOnLines',
        workInProgressOrderNumber: 'workInProgressOrderNumber',
        workInProgressStatus: 'workInProgressStatus',
    },
    salesOrderLineDimension: {
        dimensions: 'dimensions',
    },
    orderLineTextRef: {
        orderLineText: 'text',
    },
};
let SalesOrderLine = class SalesOrderLine extends xtrem_core_1.Node {
};
exports.SalesOrderLine = SalesOrderLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesOrder,
    })
], SalesOrderLine.prototype, "salesOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOPLIN',
    })
], SalesOrderLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOPSEQ',
    })
], SalesOrderLine.prototype, "sequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], SalesOrderLine.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOHCAT',
        dataType: () => sageX3SalesData.enums.orderCategoryDatatype,
    })
], SalesOrderLine.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCORD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesOrderLine.prototype, "soldToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ShipToCustomerAddress,
    })
], SalesOrderLine.prototype, "shipToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNDNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerContact,
    })
], SalesOrderLine.prototype, "shipToCustomerContact", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesOrderLine.prototype, "billToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesOrderLine.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SALFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesOrderLine.prototype, "salesSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], SalesOrderLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "productDescriptionInUserLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "productDescriptionInCustomerLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREFBPC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "customerProduct", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REP1',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesOrderLine.prototype, "salesRep1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REP2',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesOrderLine.prototype, "salesRep2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPRAT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesOrderLine.prototype, "salesRep1CommissionRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPRAT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesOrderLine.prototype, "salesRep2CommissionRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "salesRepCommissionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GROPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "grossPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIREN',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
    })
], SalesOrderLine.prototype, "priceReason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "netPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRINOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "netPriceExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRIATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "netPriceIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PFM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "margin", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "costPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp1ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp2ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp3ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp4ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp5ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge5", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp6ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge6", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp7ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge7", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp8ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge8", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp9ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge9", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN1',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp1ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge1Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN2',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp2ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge2Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN3',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp3ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge3Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN4',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp4ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge4Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN5',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp5ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge5Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN6',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp6ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge6Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN7',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp7ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge7Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN8',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp8ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge8Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN9',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp9ActivityCode],
    })
], SalesOrderLine.prototype, "discountOrCharge9Reason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "calculatedTaxableBase1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "calculatedTaxableBase2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesOrderLine.prototype, "salesUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesOrderLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SAUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "salesUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOQSTA',
        dataType: () => sageX3MasterData.enums.lineStatusDatatype,
    })
], SalesOrderLine.prototype, "lineStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINTYP',
        dataType: () => sageX3SalesData.enums.lineTypeDatatype,
    })
], SalesOrderLine.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FOCFLG',
        dataType: () => sageX3SalesData.enums.freeDatatype,
    })
], SalesOrderLine.prototype, "freeProduct", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORILIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesOrderLine,
    })
], SalesOrderLine.prototype, "freeProductLineSource", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SQHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesQuote,
    })
], SalesOrderLine.prototype, "salesQuote", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SQDLIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesQuoteLine,
    })
], SalesOrderLine.prototype, "salesQuoteLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINREVNUM',
    })
], SalesOrderLine.prototype, "lineRevisionNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SSTCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 203,
            },
            control: {
                glossaryId: 203,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], SalesOrderLine.prototype, "sageSalesTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCSALPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Edix3ActivityCode],
    })
], SalesOrderLine.prototype, "consumerSalesPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVCND',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.InvoicingTerm,
    })
], SalesOrderLine.prototype, "invoicingTerm", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesOrderQuantityLine,
    })
], SalesOrderLine.prototype, "salesOrderQuantityLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesOrderLine.prototype, "orderLineTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        columnType: 'integer',
        filters: {
            lookup: {
                abbreviation: 'SOP',
                typ: null,
                keyComplement: null,
                sortValue: 1,
            },
            control: {
                abbreviation: 'SOP',
                typ: null,
                keyComplement: null,
                sortValue: 1,
            },
        },
        node: () => sageX3Sales.nodes.SalesOrderLineDimension,
    })
], SalesOrderLine.prototype, "salesOrderLineDimension", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLTYP',
        dataType: () => sageX3MasterData.enums.allocationTypeDatatype,
    })
], SalesOrderLine.prototype, "allocationType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FMILIN',
    })
], SalesOrderLine.prototype, "backToBackOrderLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FMINUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "backToBackOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FMISEQ',
    })
], SalesOrderLine.prototype, "backToBackOrderSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPTNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], SalesOrderLine.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrderLine.prototype, "closingDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCLREN',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesOrderLine.prototype, "closingReason", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVPIOCMP',
    })
], SalesOrderLine.prototype, "completeDeliveryPriority", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DAYLTI',
    })
], SalesOrderLine.prototype, "deliveryLeadTime", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MDL',
        columnType: 'string',
        node: () => sageX3PurchasingData.nodes.DeliveryMode,
    })
], SalesOrderLine.prototype, "deliveryMode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVPIO',
        dataType: () => sageX3SalesData.enums.deliveryPriorityDatatype,
    })
], SalesOrderLine.prototype, "deliveryPriority", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Sales.nodes.SalesOrderLineDimensionDimensions,
        isMutable: true,
    })
], SalesOrderLine.prototype, "dimensions", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Sales.nodes.SalesOrderQuantityLineDistributedInvoicingElements,
        isMutable: true,
    })
], SalesOrderLine.prototype, "distributedInvoicingElements", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "exclusiveLotFilter", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "exclusiveStockStatusFilter", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTDLVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrderLine.prototype, "expectedDeliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GEOCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrderLine.prototype, "geographicCode", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IMPNUMLIG',
    })
], SalesOrderLine.prototype, "importLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSCTYFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrderLine.prototype, "insideCityLimits", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "invoicedAmount", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OCNPRNBOM',
    })
], SalesOrderLine.prototype, "isComponentPrintedOnAcknowledgement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVPRNBOM',
    })
], SalesOrderLine.prototype, "isComponentPrintedOnInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NDEPRNBOM',
    })
], SalesOrderLine.prototype, "isComponentPrintedOnPackingSlip", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVFLG',
    })
], SalesOrderLine.prototype, "isDeliverable", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVFLG',
    })
], SalesOrderLine.prototype, "isInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSPLINFLG',
    })
], SalesOrderLine.prototype, "isLineWithDistributedInvoicingElement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXREGFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrderLine.prototype, "isRecordedTax", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrderLine.prototype, "isTaxable", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXGEOFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrderLine.prototype, "isTaxedGeographically", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MAXDLVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.Edix3ActivityCode],
    })
], SalesOrderLine.prototype, "latestDeliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MAXDLVHOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Edix3ActivityCode],
    })
], SalesOrderLine.prototype, "latestDeliveryTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USEPLC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "locationReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SalesOrderLine.prototype, "majorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SalesOrderLine.prototype, "minorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrderLine.prototype, "orderDate", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesOrderLine.prototype, "orderLineText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SOQTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "orderLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCK',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.Packaging,
    })
], SalesOrderLine.prototype, "packaging", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCKCAP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "packagingCapacity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOC',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], SalesOrderLine.prototype, "preferentialStockLocationFilter", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRECOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "preparationCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FMI',
        dataType: () => sageX3SalesData.enums.sourceOfShipmentDatatype,
    })
], SalesOrderLine.prototype, "productSource", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOMGTCOD',
        dataType: () => sageX3MasterData.enums.stockManagementDatatype,
    })
], SalesOrderLine.prototype, "productStockManagement", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], SalesOrderLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitAllocated", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitDelivered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPRQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitInPreparation", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitInitiallyOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ODLQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitOnDeliveryOrScheduledInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LPRQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitOnPickList", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PREQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitPrepared", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitShortage", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TDLQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInSalesUnitToDeliverForProductsNotManagedInStock", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitAllocated", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitDelivered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPRQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitInPreparation", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ODLQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitOnDeliveryOrScheduledInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LPRQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitOnPickList", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PREQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitPrepared", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHTQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitShortage", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TDLQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "quantityInStockUnitToDeliverForProductsNotManagedInStock", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMDLVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrderLine.prototype, "requestedDeliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEMDLVREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "requestedDeliveryReference", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEMDLVHOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "requestedDeliveryTime", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DRN',
        dataType: () => sageX3SalesData.enums.routeCodeDatatype,
    })
], SalesOrderLine.prototype, "routeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesDelivery,
    })
], SalesOrderLine.prototype, "salesDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDDLIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesDeliveryLine,
    })
], SalesOrderLine.prototype, "salesDeliveryLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrderLine.prototype, "shipmentDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHIHOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "shipmentTime", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATTAXLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrderLine.prototype, "taxRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAXLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrderLine.prototype, "taxableAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PITFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "tokenManagement", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USELIMDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.Edix3ActivityCode],
    })
], SalesOrderLine.prototype, "useByDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPLINVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "volumeDistributedOnLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesOrderLine.prototype, "volumeUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPLINWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrderLine.prototype, "weightDistributedOnLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesOrderLine.prototype, "weightUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEMNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrderLine.prototype, "workInProgressOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMSTA',
        dataType: () => sageX3ManufacturingData.enums.statusInProgressDatatype,
    })
], SalesOrderLine.prototype, "workInProgressStatus", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderLineProductStatisticalGroups,
    })
], SalesOrderLine.prototype, "productStatisticalGroups", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderLineTaxes,
    })
], SalesOrderLine.prototype, "taxes", void 0);
exports.SalesOrderLine = SalesOrderLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SORDERP',
        keyPropertyNames: ['salesOrder', 'lineNumber', 'sequenceNumber'],
        indexes: [
            {
                orderBy: {
                    salesOrder: 1,
                    lineNumber: 1,
                    sequenceNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['lineNumber', 'sequenceNumber'],
        }),
        getFilters() {
            return [{ category: { _nin: ['openOrder'] } }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SalesOrderLine);
//# sourceMappingURL=sales-order-line.js.map