import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, date, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesOrderLine extends Node {
    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder>;
    readonly lineNumber: Promise<integer | null>;
    readonly sequenceNumber: Promise<integer | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly category: Promise<sageX3SalesData.enums.OrderCategory>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly shippingSite: Reference<sageX3System.nodes.Site>;
    readonly salesSite: Reference<sageX3System.nodes.Site>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly productDescriptionInUserLanguage: Promise<string>;
    readonly productDescriptionInCustomerLanguage: Promise<string>;
    readonly customerProduct: Promise<string>;
    readonly salesRep1: Reference<sageX3MasterData.nodes.SalesRep | null>;
    readonly salesRep2: Reference<sageX3MasterData.nodes.SalesRep | null>;
    readonly salesRep1CommissionRate: Promise<decimal | null>;
    readonly salesRep2CommissionRate: Promise<decimal | null>;
    readonly salesRepCommissionFactor: Promise<decimal | null>;
    readonly grossPrice: Promise<decimal | null>;
    readonly priceReason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly netPrice: Promise<decimal | null>;
    readonly netPriceExcludingTax: Promise<decimal | null>;
    readonly netPriceIncludingTax: Promise<decimal | null>;
    readonly margin: Promise<decimal | null>;
    readonly costPrice: Promise<decimal | null>;
    readonly discountOrCharge1: Promise<decimal | null>;
    readonly discountOrCharge2: Promise<decimal | null>;
    readonly discountOrCharge3: Promise<decimal | null>;
    readonly discountOrCharge4: Promise<decimal | null>;
    readonly discountOrCharge5: Promise<decimal | null>;
    readonly discountOrCharge6: Promise<decimal | null>;
    readonly discountOrCharge7: Promise<decimal | null>;
    readonly discountOrCharge8: Promise<decimal | null>;
    readonly discountOrCharge9: Promise<decimal | null>;
    readonly discountOrCharge1Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge2Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge3Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge4Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge5Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge6Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge7Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge8Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly discountOrCharge9Reason: Reference<sageX3SalesData.nodes.SalesPriceReason | null>;
    readonly calculatedTaxableBase1: Promise<decimal | null>;
    readonly calculatedTaxableBase2: Promise<decimal | null>;
    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly salesUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly lineStatus: Promise<sageX3MasterData.enums.LineStatus>;
    readonly lineType: Promise<sageX3SalesData.enums.LineType | null>;
    readonly freeProduct: Promise<sageX3SalesData.enums.Free | null>;
    readonly freeProductLineSource: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
    readonly salesQuote: Reference<sageX3Sales.nodes.SalesQuote | null>;
    readonly salesQuoteLineNumber: Reference<sageX3Sales.nodes.SalesQuoteLine | null>;
    readonly lineRevisionNumber: Promise<integer | null>;
    readonly sageSalesTax: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly consumerSalesPrice: Promise<decimal | null>;
    readonly invoicingTerm: Reference<sageX3InvoicingData.nodes.InvoicingTerm | null>;
    readonly salesOrderQuantityLine: Reference<sageX3Sales.nodes.SalesOrderQuantityLine>;
    readonly orderLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly salesOrderLineDimension: Reference<sageX3Sales.nodes.SalesOrderLineDimension>;
    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType | null>;
    readonly backToBackOrderLineNumber: Promise<integer | null>;
    readonly backToBackOrderNumber: Promise<string>;
    readonly backToBackOrderSequenceNumber: Promise<integer | null>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly closingDate: Promise<date | null>;
    readonly closingReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly completeDeliveryPriority: Promise<integer | null>;
    readonly deliveryLeadTime: Promise<integer | null>;
    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
    readonly deliveryPriority: Promise<sageX3SalesData.enums.DeliveryPriority | null>;
    readonly dimensions: Collection<sageX3Sales.nodes.SalesOrderLineDimensionDimensions>;
    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesOrderQuantityLineDistributedInvoicingElements>;
    readonly exclusiveLotFilter: Promise<string>;
    readonly exclusiveStockStatusFilter: Promise<string>;
    readonly expectedDeliveryDate: Promise<date | null>;
    readonly geographicCode: Promise<string>;
    readonly importLineNumber: Promise<integer | null>;
    readonly insideCityLimits: Promise<string>;
    readonly invoicedAmount: Promise<decimal | null>;
    readonly isComponentPrintedOnAcknowledgement: Promise<boolean>;
    readonly isComponentPrintedOnInvoice: Promise<boolean>;
    readonly isComponentPrintedOnPackingSlip: Promise<boolean>;
    readonly isDeliverable: Promise<boolean>;
    readonly isInvoiced: Promise<boolean>;
    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
    readonly isRecordedTax: Promise<boolean>;
    readonly isTaxable: Promise<boolean>;
    readonly isTaxedGeographically: Promise<string>;
    readonly latestDeliveryDate: Promise<date | null>;
    readonly latestDeliveryTime: Promise<string>;
    readonly locationReference: Promise<string>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Promise<string>;
    readonly orderDate: Promise<date | null>;
    readonly orderLineText: Promise<TextStream>;
    readonly orderLineTextKey: Promise<string>;
    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
    readonly packagingCapacity: Promise<decimal | null>;
    readonly preferentialStockLocationFilter: Reference<sageX3StockData.nodes.Location | null>;
    readonly preparationCode: Promise<string>;
    readonly productSource: Promise<sageX3SalesData.enums.SourceOfShipment | null>;
    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly quantityInSalesUnitAllocated: Promise<decimal | null>;
    readonly quantityInSalesUnitDelivered: Promise<decimal | null>;
    readonly quantityInSalesUnitInPreparation: Promise<decimal | null>;
    readonly quantityInSalesUnitInitiallyOrdered: Promise<decimal | null>;
    readonly quantityInSalesUnitInvoiced: Promise<decimal | null>;
    readonly quantityInSalesUnitOnDeliveryOrScheduledInvoice: Promise<decimal | null>;
    readonly quantityInSalesUnitOnPickList: Promise<decimal | null>;
    readonly quantityInSalesUnitOrdered: Promise<decimal>;
    readonly quantityInSalesUnitPrepared: Promise<decimal | null>;
    readonly quantityInSalesUnitShortage: Promise<decimal | null>;
    readonly quantityInSalesUnitToDeliverForProductsNotManagedInStock: Promise<decimal | null>;
    readonly quantityInStockUnitAllocated: Promise<decimal | null>;
    readonly quantityInStockUnitDelivered: Promise<decimal | null>;
    readonly quantityInStockUnitInPreparation: Promise<decimal | null>;
    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
    readonly quantityInStockUnitOnDeliveryOrScheduledInvoice: Promise<decimal | null>;
    readonly quantityInStockUnitOnPickList: Promise<decimal | null>;
    readonly quantityInStockUnitOrdered: Promise<decimal>;
    readonly quantityInStockUnitPrepared: Promise<decimal | null>;
    readonly quantityInStockUnitShortage: Promise<decimal | null>;
    readonly quantityInStockUnitToDeliverForProductsNotManagedInStock: Promise<decimal | null>;
    readonly requestedDeliveryDate: Promise<date | null>;
    readonly requestedDeliveryReference: Promise<string>;
    readonly requestedDeliveryTime: Promise<string>;
    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
    readonly salesDeliveryLineNumber: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
    readonly shipmentDate: Promise<date | null>;
    readonly shipmentTime: Promise<string>;
    readonly taxRate: Promise<decimal | null>;
    readonly taxableAmount: Promise<decimal | null>;
    readonly tokenManagement: Promise<decimal | null>;
    readonly useByDate: Promise<date | null>;
    readonly volumeDistributedOnLine: Promise<decimal | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly weightDistributedOnLine: Promise<decimal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly workInProgressOrderNumber: Promise<string>;
    readonly workInProgressStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
    readonly productStatisticalGroups: Collection<sageX3Sales.nodes.SalesOrderLineProductStatisticalGroups>;
    readonly taxes: Collection<sageX3Sales.nodes.SalesOrderLineTaxes>;
}
//# sourceMappingURL=sales-order-line.d.ts.map