"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesInvoice = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PhysicalFlowsData = require("@sage/x3-physical-flows-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const joins = {
    referenceJoins: {
        id: {
            id: 'id',
        },
        company: {
            code: 'company',
        },
        salesSite: {
            code: 'salesSite',
        },
        shippingSite: {
            code: 'shippingSite',
        },
        billToCustomer: {
            code: 'billToCustomer',
        },
        soldToCustomer: {
            code: 'soldToCustomer',
        },
        groupCustomer: {
            code: 'groupCustomer',
        },
        shipToCustomerAddress: {
            customer: 'soldToCustomer',
            shipToAddress: 'shipToCustomerAddress',
        },
        billToCustomerContact: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'billToCustomer',
            code: 'billToCustomerContact',
        },
        shipToCustomerCountry: {
            code: 'shipToCustomerCountry',
        },
        shipToCustomerContact: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'soldToCustomer',
            code: 'shipToCustomerContact',
        },
        payByBusinessPartner: {
            code: 'payByBusinessPartner',
        },
        factor: {
            code: 'factor',
        },
        invoiceType: {
            code: 'invoiceType',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        currency: {
            code: 'currency',
        },
        project: {
            id: 'project',
        },
        creditMemoReason: {
            glossaryId() {
                return 8;
            },
            code: 'creditMemoReason',
        },
        earlyDiscountOrLateCharge: {
            code: 'earlyDiscountOrLateCharge',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        billToCustomerLanguage: {
            code: 'billToCustomerLanguage',
        },
        sourceSite: {
            code: 'sourceSite',
        },
        stockMovementCode: {
            glossaryId() {
                return 14;
            },
            code: 'stockMovementCode',
        },
        stockAutomaticJournal: {
            code: 'stockAutomaticJournal',
        },
        dockLocation: {
            stockSite: 'shippingSite',
            code: 'dockLocation',
        },
        intrastatTransactionNature: {
            code: 'intrastatTransactionNature',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        intrastatAdjustmentTransactionNature: {
            code: 'intrastatAdjustmentTransactionNature',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        intrastatStatisticalRule: {
            code: 'intrastatStatisticalRule',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        intrastatAdjustmentStatisticalRule: {
            code: 'intrastatAdjustmentStatisticalRule',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        incoterm: {
            code: 'incoterm',
        },
        forwardingAgent: {
            code: 'forwardingAgent',
        },
        forwardingAgentAddress: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'forwardingAgent',
            code: 'forwardingAgentAddress',
        },
        priceStructure: {
            customerOrSupplier() {
                return 'customer';
            },
            code: 'priceStructure',
        },
        weightUnitForDistributionOnLines: {
            code: 'weightUnitForDistributionOnLines',
        },
        volumeUnitForDistributionOnLines: {
            code: 'volumeUnitForDistributionOnLines',
        },
        finalSequenceNumber: {
            id: 'finalSequenceNumber',
        },
        customerInvoiceHeader: {
            id: 'id',
        },
        invoiceHeaderTextRef: {
            code: 'invoiceHeaderTextKey',
        },
        invoiceFooterTextRef: {
            code: 'invoiceFooterTextKey',
        },
    },
    collectionJoins: {
        salesInvoiceLines: {
            salesInvoice: 'id',
        },
    },
};
const compositeReferences = {
    customerInvoiceHeader: {
        accountingDate: 'accountingDate',
        billToCustomerAddress: 'billToCustomerAddress',
        billToCustomerAddressLines: 'billToCustomerAddressLines',
        billToCustomerCity: 'billToCustomerCity',
        billToCustomerCountry: 'billToCustomerCountry',
        billToCustomerCountryName: 'billToCustomerCountryName',
        billToCustomerPostalCode: 'billToCustomerPostalCode',
        billToCustomerState: 'billToCustomerState',
        businessProcessType: 'businessProcessType',
        cancellationStatus: 'cancellationStatus',
        cashVatTaxRule: 'cashVatTaxRule',
        comments: 'comments',
        control: 'control',
        correctionMethod: 'correctionMethod',
        creditMemoReferenceEndDate: 'creditMemoReferenceEndDate',
        creditMemoReferenceStartDate: 'creditMemoReferenceStartDate',
        currencyRates: 'currencyRates',
        customerSourceDocument: 'sourceDocument',
        customerSourceDocumentDate: 'sourceDocumentDate',
        debitOrCredit: 'debitOrCredit',
        derCode: 'derCode',
        dimensions: 'dimensions',
        dueDateCalculationStartDate: 'dueDateCalculationStartDate',
        earlyDiscountOrLateChargeBasis: 'earlyDiscountOrLateChargeBasis',
        earlyDiscountOrLateChargeRate: 'earlyDiscountOrLateChargeRate',
        entityUserCode: 'entityUserCode',
        entryType: 'entryType',
        field40Reason: 'field40Reason',
        field41Reason: 'field41Reason',
        fiscalYear: 'fiscalYear',
        inPaymentSlipWithReferenceNumber: 'inPaymentSlipWithReferenceNumber',
        internalNumber: 'internalNumber',
        intrastatProcessingNumber: 'intrastatProcessingNumber',
        isDirectInvoice: 'isDirectInvoice',
        isExternalDocument: 'isExternalDocument',
        journal: 'journal',
        lastServiceAccountedDate: 'lastServiceAccountedDate',
        mandate: 'mandate',
        numberOfTaxes: 'numberOfTaxes',
        originalDocumentNumber: 'originalDocumentNumber',
        originalInvoiceNumber: 'originalInvoiceNumber',
        payByBusinessPartnerAddress: 'payByBusinessPartnerAddress',
        payByBusinessPartnerAddressLines: 'payByBusinessPartnerAddressLines',
        payByBusinessPartnerCity: 'payByBusinessPartnerCity',
        payByBusinessPartnerCompanyNames: 'payByBusinessPartnerCompanyNames',
        payByBusinessPartnerCountry: 'payByBusinessPartnerCountry',
        payByBusinessPartnerCountryName: 'payByBusinessPartnerCountryName',
        payByBusinessPartnerPostalCode: 'payByBusinessPartnerPostalCode',
        payByBusinessPartnerState: 'payByBusinessPartnerState',
        paymentBank: 'paymentBank',
        paymentTerm: 'paymentTerm',
        period: 'period',
        rateDate: 'rateDate',
        rateType: 'rateType',
        serviceEndDate: 'serviceEndDate',
        serviceStartDate: 'serviceStartDate',
        siteIdentificationNumber: 'siteIdentificationNumber',
        sourceModule: 'sourceModule',
        spanishInvoiceType: 'spanishInvoiceType',
        stockMovementGroup: 'stockMovementGroup',
        taxReferenceDate: 'taxReferenceDate',
        taxes: 'taxes',
        totalAmountExcludingTax: 'totalAmountExcludingTax',
        totalAmountExcludingTaxInCompanyCurrency: 'totalAmountExcludingTaxInCompanyCurrency',
        totalAmountIncludingTax: 'totalAmountIncludingTax',
        totalAmountIncludingTaxInCompanyCurrency: 'totalAmountIncludingTaxInCompanyCurrency',
        vatDeclarationNumber: 'vatDeclarationNumber',
        versionControlSystemNumber: 'versionControlSystemNumber',
        warehouse: 'warehouse',
    },
    invoiceFooterTextRef: {
        invoiceFooterText: 'text',
    },
    invoiceHeaderTextRef: {
        invoiceHeaderText: 'text',
    },
};
let SalesInvoice = class SalesInvoice extends xtrem_core_1.Node {
};
exports.SalesInvoice = SalesInvoice;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NUM',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeader,
    })
], SalesInvoice.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], SalesInvoice.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SALFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesInvoice.prototype, "salesSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesInvoice.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesInvoice.prototype, "billToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCORD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesInvoice.prototype, "soldToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCGRU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesInvoice.prototype, "groupCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ShipToCustomerAddress,
    })
], SalesInvoice.prototype, "shipToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPIEECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoice.prototype, "billToCustomerEuropeanUnionVatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNINAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerContact,
    })
], SalesInvoice.prototype, "billToCustomerContact", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "shipToCustomerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "shipToCustomerCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "shipToCustomerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPDCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SalesInvoice.prototype, "shipToCustomerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "shipToCustomerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNDNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerContact,
    })
], SalesInvoice.prototype, "shipToCustomerContact", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRPAY',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], SalesInvoice.prototype, "payByBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRFCT',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Factor,
        serviceOptions: () => [sageX3System.serviceOptions.FctActivityCode],
    })
], SalesInvoice.prototype, "factor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIVTYP',
        columnType: 'string',
        node: () => sageX3SalesData.nodes.SalesInvoiceType,
    })
], SalesInvoice.prototype, "invoiceType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVTYP',
        dataType: () => sageX3InvoicingData.enums.invoiceTypeDatatype,
    })
], SalesInvoice.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIHORI',
        dataType: () => sageX3Sales.enums.salesInvoiceSourceDatatype,
    })
], SalesInvoice.prototype, "sourceDocumentCategory", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SIHORINUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "sourceDocumentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIHORIDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoice.prototype, "sourceDocumentDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoice.prototype, "invoiceDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], SalesInvoice.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVSTA',
        dataType: () => sageX3MasterData.enums.invoiceStatusDatatype,
    })
], SalesInvoice.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVCNOSTA',
    })
], SalesInvoice.prototype, "isOnCreditMemo", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOMVTFLG',
    })
], SalesInvoice.prototype, "hasStockTransaction", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "internalReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], SalesInvoice.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRITYP',
        dataType: () => sageX3MasterData.enums.priceAmountTaxTaxDatatype,
    })
], SalesInvoice.prototype, "priceIncludingOrExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNOREN',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 8,
            },
            control: {
                glossaryId: 8,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesInvoice.prototype, "creditMemoReason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.EarlyDiscountLateCharge,
    })
], SalesInvoice.prototype, "earlyDiscountOrLateCharge", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], SalesInvoice.prototype, "billToCustomerLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SIHTEX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "invoiceHeaderTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SIHTEX2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "invoiceFooterTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETFCY',
    })
], SalesInvoice.prototype, "isIntersite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETCPY',
    })
], SalesInvoice.prototype, "isIntercompany", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesInvoice.prototype, "sourceSite", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINNBR',
    })
], SalesInvoice.prototype, "numberOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COPNBR',
    })
], SalesInvoice.prototype, "numberOfInvoiceCopies", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COPNBE',
    })
], SalesInvoice.prototype, "numberOfCreditMemoCopies", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 14,
            },
            control: {
                glossaryId: 14,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesInvoice.prototype, "stockMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENTCOD',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.AutomaticJournal,
    })
], SalesInvoice.prototype, "stockAutomaticJournal", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SRGLOCDEF',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], SalesInvoice.prototype, "dockLocation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECNAT',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoice.prototype, "intrastatTransactionNature", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECNATR',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoice.prototype, "intrastatAdjustmentTransactionNature", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECSCH',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoice.prototype, "intrastatStatisticalRule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECSCHR',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoice.prototype, "intrastatAdjustmentStatisticalRule", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECLOC',
        dataType: () => sageX3MasterData.enums.countryLocationDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoice.prototype, "intrastatTransportLocation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECTRN',
        dataType: () => sageX3MasterData.enums.intrastatTransportModeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoice.prototype, "intrastatTransportMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECICT',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Incoterm,
    })
], SalesInvoice.prototype, "incoterm", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ICTCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "incotermTown", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], SalesInvoice.prototype, "forwardingAgent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], SalesInvoice.prototype, "forwardingAgentAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GEOCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesInvoice.prototype, "geographicCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSCTYFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesInvoice.prototype, "insideCityLimits", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CMGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "marketingCampaign", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLISTC',
        columnType: 'string',
        filters: {
            lookup: {
                customerOrSupplier: 'customer',
            },
            control: {
                customerOrSupplier: 'customer',
            },
        },
        node: () => sageX3InvoicingData.nodes.PriceStructure,
    })
], SalesInvoice.prototype, "priceStructure", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPTOTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoice.prototype, "totalQuantityDistributedOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPTOTWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoice.prototype, "totalWeightDistributedOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPTOTVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoice.prototype, "totalVolumeDistributedOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesInvoice.prototype, "weightUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesInvoice.prototype, "volumeUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STARPT',
    })
], SalesInvoice.prototype, "isPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADRVAL',
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], SalesInvoice.prototype, "isValidatedAddress", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DPEDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoice.prototype, "departureDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ARVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoice.prototype, "arrivalDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ETD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "departureTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ETA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "arrivalTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LICPLATE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "vehicleLicensePlate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRLLICPLATE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "trailerLicensePlate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIHORITYP',
        dataType: () => sageX3SalesData.enums.salesDocumentTypeDatatype,
    })
], SalesInvoice.prototype, "sourceDocumentType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIHNUMEND',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoice,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesInvoice.prototype, "finalSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SIHCFMFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesInvoice.prototype, "hasElectronicSignature", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Sales.nodes.SalesInvoiceLine,
        isMutable: true,
        dependsOn: ['id'],
    })
], SalesInvoice.prototype, "salesInvoiceLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeader,
    })
], SalesInvoice.prototype, "customerInvoiceHeader", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesInvoice.prototype, "invoiceHeaderTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesInvoice.prototype, "invoiceFooterTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoice.prototype, "accountingDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], SalesInvoice.prototype, "billToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderBillToCustomerAddressLines,
        isMutable: true,
    })
], SalesInvoice.prototype, "billToCustomerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "billToCustomerCity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SalesInvoice.prototype, "billToCustomerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "billToCustomerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "billToCustomerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "billToCustomerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BUSPROTYP',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesInvoice.prototype, "businessProcessType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REVCANSTA',
        serviceOptions: () => [sageX3System.serviceOptions.InvcaActivityCode],
    })
], SalesInvoice.prototype, "cancellationStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSHVAT',
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], SalesInvoice.prototype, "cashVatTaxRule", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderComments,
        isMutable: true,
    })
], SalesInvoice.prototype, "comments", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRSAC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "control", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'METCOR',
        dataType: () => sageX3InvoicingData.enums.correctionMethodDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], SalesInvoice.prototype, "correctionMethod", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERFIN',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesInvoice.prototype, "creditMemoReferenceEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERDEB',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesInvoice.prototype, "creditMemoReferenceStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3FinanceData.nodes.CustomerInvoiceHeaderCurrencyRates,
        isMutable: true,
    })
], SalesInvoice.prototype, "currencyRates", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRVCR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "customerSourceDocument", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoice.prototype, "customerSourceDocumentDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNS',
    })
], SalesInvoice.prototype, "debitOrCredit", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPADERNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], SalesInvoice.prototype, "derCode", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3FinanceData.nodes.CustomerInvoiceHeaderDimensions,
        isMutable: true,
    })
], SalesInvoice.prototype, "dimensions", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDUDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoice.prototype, "dueDateCalculationStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASDEP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoice.prototype, "earlyDiscountOrLateChargeBasis", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEPRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoice.prototype, "earlyDiscountOrLateChargeRate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SSTENTCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], SalesInvoice.prototype, "entityUserCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GTE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.EntryType,
    })
], SalesInvoice.prototype, "entryType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLD40REN',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesInvoice.prototype, "field40Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLD41REN',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesInvoice.prototype, "field41Reason", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIY',
    })
], SalesInvoice.prototype, "fiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BVRREFNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KswActivityCode],
    })
], SalesInvoice.prototype, "inPaymentSlipWithReferenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCNUM',
    })
], SalesInvoice.prototype, "internalNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECNUMDEB',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoice.prototype, "intrastatProcessingNumber", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesInvoice.prototype, "invoiceFooterText", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesInvoice.prototype, "invoiceHeaderText", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DIRINVFLG',
    })
], SalesInvoice.prototype, "isDirectInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ISEXTDOC',
        serviceOptions: () => [sageX3System.serviceOptions.DksActivityCode],
    })
], SalesInvoice.prototype, "isExternalDocument", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'JOU',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Journal,
    })
], SalesInvoice.prototype, "journal", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], SalesInvoice.prototype, "lastServiceAccountedDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UMRNUM',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Mandate,
        serviceOptions: () => [sageX3System.serviceOptions.SddActivityCode],
    })
], SalesInvoice.prototype, "mandate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBRTAX',
    })
], SalesInvoice.prototype, "numberOfTaxes", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORIDOCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesInvoice.prototype, "originalDocumentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "originalInvoiceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAPAY',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], SalesInvoice.prototype, "payByBusinessPartnerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerAddressLines,
        isMutable: true,
    })
], SalesInvoice.prototype, "payByBusinessPartnerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "payByBusinessPartnerCity", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames,
        isMutable: true,
    })
], SalesInvoice.prototype, "payByBusinessPartnerCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPYCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SalesInvoice.prototype, "payByBusinessPartnerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "payByBusinessPartnerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "payByBusinessPartnerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "payByBusinessPartnerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAYBAN',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.BankAccount,
        serviceOptions: () => [sageX3System.serviceOptions.KswActivityCode],
    })
], SalesInvoice.prototype, "paymentBank", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTE',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.PaymentTerm,
    })
], SalesInvoice.prototype, "paymentTerm", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PER',
    })
], SalesInvoice.prototype, "period", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoice.prototype, "rateDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CURTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], SalesInvoice.prototype, "rateType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], SalesInvoice.prototype, "serviceEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], SalesInvoice.prototype, "serviceStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoice.prototype, "siteIdentificationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIMOD',
        dataType: () => sageX3System.enums.moduleTableDatatype,
    })
], SalesInvoice.prototype, "sourceModule", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVTYPSPA',
        dataType: () => sageX3MasterData.enums.spanishInvoiceTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], SalesInvoice.prototype, "spanishInvoiceType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSFAM',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesInvoice.prototype, "stockMovementGroup", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VATDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoice.prototype, "taxReferenceDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.CustomerInvoiceHeaderTaxes,
    })
], SalesInvoice.prototype, "taxes", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoice.prototype, "totalAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOTL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoice.prototype, "totalAmountExcludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoice.prototype, "totalAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATIL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoice.prototype, "totalAmountIncludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DCLEECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.VattnActivityCode],
    })
], SalesInvoice.prototype, "vatDeclarationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BELVCS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KbeActivityCode],
    })
], SalesInvoice.prototype, "versionControlSystemNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRHE',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], SalesInvoice.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceBillToCustomerCompanyNames,
    })
], SalesInvoice.prototype, "billToCustomerCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceCustomerStatisticalGroups,
    })
], SalesInvoice.prototype, "customerStatisticalGroups", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceDiscountOrChargeCalculationRules,
    })
], SalesInvoice.prototype, "discountOrChargeCalculationRules", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceInvoicingElements,
    })
], SalesInvoice.prototype, "invoicingElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceSalesOrderOfPrepayments,
    })
], SalesInvoice.prototype, "salesOrderOfPrepayments", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceSalesReps,
    })
], SalesInvoice.prototype, "salesReps", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceShipToCustomerAddressLines,
    })
], SalesInvoice.prototype, "shipToCustomerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceShipToCustomerCompanyNames,
    })
], SalesInvoice.prototype, "shipToCustomerCompanyNames", void 0);
exports.SalesInvoice = SalesInvoice = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SINVOICEV',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SalesInvoice);
//# sourceMappingURL=sales-invoice.js.map