import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, decimal, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesInvoice extends Node {
    readonly id: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly salesSite: Reference<sageX3System.nodes.Site>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress | null>;
    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
    readonly billToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly shipToCustomerPostalCode: Promise<string>;
    readonly shipToCustomerCity: Promise<string>;
    readonly shipToCustomerState: Promise<string>;
    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly shipToCustomerCountryName: Promise<string>;
    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly factor: Reference<sageX3FinanceData.nodes.Factor | null>;
    readonly invoiceType: Reference<sageX3SalesData.nodes.SalesInvoiceType | null>;
    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
    readonly sourceDocumentCategory: Promise<sageX3Sales.enums.SalesInvoiceSource | null>;
    readonly sourceDocumentNumber: Promise<string>;
    readonly sourceDocumentDate: Promise<date | null>;
    readonly invoiceDate: Promise<date | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly status: Promise<sageX3MasterData.enums.InvoiceStatus | null>;
    readonly isOnCreditMemo: Promise<boolean>;
    readonly hasStockTransaction: Promise<boolean>;
    readonly internalReference: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly creditMemoReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly billToCustomerLanguage: Reference<sageX3System.nodes.Language | null>;
    readonly invoiceHeaderTextKey: Promise<string>;
    readonly invoiceFooterTextKey: Promise<string>;
    readonly isIntersite: Promise<boolean>;
    readonly isIntercompany: Promise<boolean>;
    readonly sourceSite: Reference<sageX3System.nodes.Site | null>;
    readonly numberOfLines: Promise<integer | null>;
    readonly numberOfInvoiceCopies: Promise<integer | null>;
    readonly numberOfCreditMemoCopies: Promise<integer | null>;
    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
    readonly dockLocation: Reference<sageX3StockData.nodes.Location | null>;
    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
    readonly intrastatAdjustmentTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
    readonly intrastatStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
    readonly intrastatAdjustmentStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly incotermTown: Promise<string>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly geographicCode: Promise<string>;
    readonly insideCityLimits: Promise<string>;
    readonly marketingCampaign: Promise<string>;
    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
    readonly totalQuantityDistributedOnLines: Promise<decimal | null>;
    readonly totalWeightDistributedOnLines: Promise<decimal | null>;
    readonly totalVolumeDistributedOnLines: Promise<decimal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly isPrinted: Promise<boolean>;
    readonly isValidatedAddress: Promise<boolean>;
    readonly departureDate: Promise<date | null>;
    readonly arrivalDate: Promise<date | null>;
    readonly departureTime: Promise<string>;
    readonly arrivalTime: Promise<string>;
    readonly vehicleLicensePlate: Promise<string>;
    readonly trailerLicensePlate: Promise<string>;
    readonly sourceDocumentType: Promise<sageX3SalesData.enums.SalesDocumentType | null>;
    readonly finalSequenceNumber: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly hasElectronicSignature: Promise<boolean>;
    readonly salesInvoiceLines: Collection<sageX3Sales.nodes.SalesInvoiceLine>;
    readonly customerInvoiceHeader: Reference<sageX3InvoicingData.nodes.CustomerInvoiceHeader>;
    readonly invoiceHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly invoiceFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly accountingDate: Promise<date | null>;
    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly billToCustomerAddressLines: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderBillToCustomerAddressLines>;
    readonly billToCustomerCity: Promise<string>;
    readonly billToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly billToCustomerCountryName: Promise<string>;
    readonly billToCustomerPostalCode: Promise<string>;
    readonly billToCustomerState: Promise<string>;
    readonly businessProcessType: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly cancellationStatus: Promise<integer | null>;
    readonly cashVatTaxRule: Promise<boolean>;
    readonly comments: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderComments>;
    readonly control: Promise<string>;
    readonly correctionMethod: Promise<sageX3InvoicingData.enums.CorrectionMethod | null>;
    readonly creditMemoReferenceEndDate: Promise<date | null>;
    readonly creditMemoReferenceStartDate: Promise<date | null>;
    readonly currencyRates: Collection<sageX3FinanceData.nodes.CustomerInvoiceHeaderCurrencyRates>;
    readonly customerSourceDocument: Promise<string>;
    readonly customerSourceDocumentDate: Promise<date | null>;
    readonly debitOrCredit: Promise<integer | null>;
    readonly derCode: Promise<string>;
    readonly dimensions: Collection<sageX3FinanceData.nodes.CustomerInvoiceHeaderDimensions>;
    readonly dueDateCalculationStartDate: Promise<date | null>;
    readonly earlyDiscountOrLateChargeBasis: Promise<decimal | null>;
    readonly earlyDiscountOrLateChargeRate: Promise<decimal | null>;
    readonly entityUserCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly entryType: Reference<sageX3FinanceData.nodes.EntryType | null>;
    readonly field40Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly field41Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly fiscalYear: Promise<integer | null>;
    readonly inPaymentSlipWithReferenceNumber: Promise<string>;
    readonly internalNumber: Promise<integer | null>;
    readonly intrastatProcessingNumber: Promise<integer | null>;
    readonly invoiceFooterText: Promise<TextStream>;
    readonly invoiceHeaderText: Promise<TextStream>;
    readonly isDirectInvoice: Promise<boolean>;
    readonly isExternalDocument: Promise<boolean>;
    readonly journal: Reference<sageX3FinanceData.nodes.Journal | null>;
    readonly lastServiceAccountedDate: Promise<date | null>;
    readonly mandate: Reference<sageX3InvoicingData.nodes.Mandate | null>;
    readonly numberOfTaxes: Promise<integer | null>;
    readonly originalDocumentNumber: Promise<string>;
    readonly originalInvoiceNumber: Promise<string>;
    readonly payByBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly payByBusinessPartnerAddressLines: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
    readonly payByBusinessPartnerCity: Promise<string>;
    readonly payByBusinessPartnerCompanyNames: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
    readonly payByBusinessPartnerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly payByBusinessPartnerCountryName: Promise<string>;
    readonly payByBusinessPartnerPostalCode: Promise<string>;
    readonly payByBusinessPartnerState: Promise<string>;
    readonly paymentBank: Reference<sageX3FinanceData.nodes.BankAccount | null>;
    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
    readonly period: Promise<integer | null>;
    readonly rateDate: Promise<date | null>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly serviceEndDate: Promise<date | null>;
    readonly serviceStartDate: Promise<date | null>;
    readonly siteIdentificationNumber: Promise<string>;
    readonly sourceModule: Promise<sageX3System.enums.ModuleTable | null>;
    readonly spanishInvoiceType: Promise<sageX3MasterData.enums.SpanishInvoiceType | null>;
    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly taxReferenceDate: Promise<date | null>;
    readonly taxes: Collection<sageX3InvoicingData.nodes.CustomerInvoiceHeaderTaxes>;
    readonly totalAmountExcludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountIncludingTax: Promise<decimal | null>;
    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly vatDeclarationNumber: Promise<string>;
    readonly versionControlSystemNumber: Promise<string>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly billToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesInvoiceBillToCustomerCompanyNames>;
    readonly customerStatisticalGroups: Collection<sageX3Sales.nodes.SalesInvoiceCustomerStatisticalGroups>;
    readonly discountOrChargeCalculationRules: Collection<sageX3Sales.nodes.SalesInvoiceDiscountOrChargeCalculationRules>;
    readonly invoicingElements: Collection<sageX3Sales.nodes.SalesInvoiceInvoicingElements>;
    readonly salesOrderOfPrepayments: Collection<sageX3Sales.nodes.SalesInvoiceSalesOrderOfPrepayments>;
    readonly salesReps: Collection<sageX3Sales.nodes.SalesInvoiceSalesReps>;
    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesInvoiceShipToCustomerAddressLines>;
    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesInvoiceShipToCustomerCompanyNames>;
}
//# sourceMappingURL=sales-invoice.d.ts.map