"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesInvoiceLine = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const joins = {
    referenceJoins: {
        salesInvoice: {
            id: 'salesInvoice',
        },
        company: {
            code: 'company',
        },
        salesOrderNumber: {
            id: 'salesOrderNumber',
        },
        salesOrderLine: {
            salesOrder: 'salesOrderNumber',
            lineNumber: 'salesOrderLineNumber',
            sequenceNumber: 'salesOrderLine',
        },
        salesDelivery: {
            id: 'salesDelivery',
        },
        salesDeliveryLine: {
            salesDelivery: 'salesDelivery',
            lineNumber: 'salesDeliveryLine',
        },
        sourceSalesInvoice: {
            id: 'sourceSalesInvoice',
        },
        sourceSalesInvoiceLine: {
            salesInvoice: 'sourceSalesInvoice',
            lineNumber: 'sourceSalesInvoiceLine',
        },
        salesReturn: {
            id: 'salesReturn',
        },
        salesReturnLine: {
            salesReturn: 'salesReturn',
            lineNumber: 'salesReturnLine',
        },
        billToCustomer: {
            code: 'billToCustomer',
        },
        product: {
            code: 'product',
        },
        majorProductVersion: {
            product: 'product',
            code: 'majorProductVersion',
        },
        salesRep1: {
            code: 'salesRep1',
        },
        salesRep2: {
            code: 'salesRep2',
        },
        priceReason: {
            code: 'priceReason',
        },
        discountOrCharge1Reason: {
            code: 'discountOrCharge1Reason',
        },
        discountOrCharge2Reason: {
            code: 'discountOrCharge2Reason',
        },
        discountOrCharge3Reason: {
            code: 'discountOrCharge3Reason',
        },
        discountOrCharge4Reason: {
            code: 'discountOrCharge4Reason',
        },
        discountOrCharge5Reason: {
            code: 'discountOrCharge5Reason',
        },
        discountOrCharge6Reason: {
            code: 'discountOrCharge6Reason',
        },
        discountOrCharge7Reason: {
            code: 'discountOrCharge7Reason',
        },
        discountOrCharge8Reason: {
            code: 'discountOrCharge8Reason',
        },
        discountOrCharge9Reason: {
            code: 'discountOrCharge9Reason',
        },
        salesUnit: {
            code: 'salesUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        shippingSite: {
            code: 'shippingSite',
        },
        preferentialStockLocationFilter: {
            stockSite: 'shippingSite',
            code: 'preferentialStockLocationFilter',
        },
        salesSite: {
            code: 'salesSite',
        },
        freeProductLineSource: {
            salesInvoice: 'salesInvoice',
            lineNumber: 'freeProductLineSource',
        },
        weightUnitForDistributionOnLines: {
            code: 'weightUnitForDistributionOnLines',
        },
        volumeUnitForDistributionOnLines: {
            code: 'volumeUnitForDistributionOnLines',
        },
        warehouse: {
            code: 'warehouse',
        },
        project: {
            id: 'project',
        },
        invoiceLineTextRef: {
            code: 'invoiceLineTextKey',
        },
    },
};
const compositeReferences = {
    invoiceLineTextRef: {
        invoiceLineText: 'text',
    },
};
let SalesInvoiceLine = class SalesInvoiceLine extends xtrem_core_1.Node {
};
exports.SalesInvoiceLine = SalesInvoiceLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoice,
    })
], SalesInvoiceLine.prototype, "salesInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIDLIN',
    })
], SalesInvoiceLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], SalesInvoiceLine.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesOrder,
    })
], SalesInvoiceLine.prototype, "salesOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOPLIN',
    })
], SalesInvoiceLine.prototype, "salesOrderLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOQSEQ',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesOrderLine,
    })
], SalesInvoiceLine.prototype, "salesOrderLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesDelivery,
    })
], SalesInvoiceLine.prototype, "salesDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDDLIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesDeliveryLine,
    })
], SalesInvoiceLine.prototype, "salesDeliveryLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIHORINUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoice,
    })
], SalesInvoiceLine.prototype, "sourceSalesInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIDORILIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesInvoiceLine,
    })
], SalesInvoiceLine.prototype, "sourceSalesInvoiceLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SRHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesReturn,
    })
], SalesInvoiceLine.prototype, "salesReturn", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SRDLIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesReturnLine,
    })
], SalesInvoiceLine.prototype, "salesReturnLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesInvoiceLine.prototype, "billToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], SalesInvoiceLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SalesInvoiceLine.prototype, "majorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SalesInvoiceLine.prototype, "minorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoiceLine.prototype, "productDescriptionInUserLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoiceLine.prototype, "productDescriptionInCustomerLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REP1',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesInvoiceLine.prototype, "salesRep1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REP2',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesInvoiceLine.prototype, "salesRep2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPRAT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesInvoiceLine.prototype, "salesRep1CommissionRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPRAT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesInvoiceLine.prototype, "salesRep2CommissionRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPBAS1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesInvoiceLine.prototype, "salesRep1CommissionBase", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPBAS2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesInvoiceLine.prototype, "salesRep2CommissionBase", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesInvoiceLine.prototype, "salesRep1CommissionAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesInvoiceLine.prototype, "salesRep2CommissionAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "salesRepCommissionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GROPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "grossPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIREN',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
    })
], SalesInvoiceLine.prototype, "priceReason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "netPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRINOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "netPriceExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRIATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "netPriceIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PFM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "margin", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "costPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp1ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp2ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp3ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp4ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp5ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge5", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp6ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge6", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp7ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge7", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp8ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge8", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp9ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge9", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN1',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp1ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge1Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN2',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp2ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge2Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN3',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp3ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge3Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN4',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp4ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge4Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN5',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp5ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge5Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN6',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp6ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge6Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN7',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp7ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge7Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN8',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp8ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge8Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN9',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp9ActivityCode],
    })
], SalesInvoiceLine.prototype, "discountOrCharge9Reason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "lineAmountEnteredManually", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOTLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "lineAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTDEPLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "discountLineAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "calculatedTaxableBase1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "calculatedTaxableBase2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATTAXLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "taxRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATILIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "lineAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSPLINFLG',
    })
], SalesInvoiceLine.prototype, "isLineWithDistributedInvoicingElement", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "quantityInSalesUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "quantityInStockUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesInvoiceLine.prototype, "salesUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesInvoiceLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SAUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "salesUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesInvoiceLine.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOMGTCOD',
        dataType: () => sageX3MasterData.enums.stockManagementDatatype,
    })
], SalesInvoiceLine.prototype, "productStockManagement", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoiceLine.prototype, "exclusiveLotFilter", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoiceLine.prototype, "exclusiveStockStatusFilter", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOC',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], SalesInvoiceLine.prototype, "preferentialStockLocationFilter", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIORD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "stockPriceInCreditMemoWithStockMovement", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLTYP',
        dataType: () => sageX3MasterData.enums.typeOfAllocationDatatype,
    })
], SalesInvoiceLine.prototype, "allocationType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SALFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesInvoiceLine.prototype, "salesSite", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoiceLine.prototype, "invoiceDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINTYP',
        dataType: () => sageX3SalesData.enums.lineTypeDatatype,
    })
], SalesInvoiceLine.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FOCFLG',
        dataType: () => sageX3SalesData.enums.freeDatatype,
    })
], SalesInvoiceLine.prototype, "freeProduct", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORILIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesInvoiceLine,
    })
], SalesInvoiceLine.prototype, "freeProductLineSource", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SIDTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesInvoiceLine.prototype, "invoiceLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINEECFLG',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoiceLine.prototype, "isExtractedIntrastatLine", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECFLOPHY',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesInvoiceLine.prototype, "isIntrastatPhysicalFlow", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GEOCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesInvoiceLine.prototype, "geographicCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSCTYFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesInvoiceLine.prototype, "insideCityLimits", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXGEOFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesInvoiceLine.prototype, "isTaxedGeographically", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesInvoiceLine.prototype, "isTaxable", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXREGFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesInvoiceLine.prototype, "isRecordedTax", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVPRNBOM',
    })
], SalesInvoiceLine.prototype, "isPrintedOnInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoiceLine.prototype, "serviceStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesInvoiceLine.prototype, "serviceEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERNBR',
    })
], SalesInvoiceLine.prototype, "servicePeriodNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERTYP',
        dataType: () => sageX3InvoicingData.enums.periodicityTypeDatatype,
    })
], SalesInvoiceLine.prototype, "servicePeriodType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PITFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "tokenManagement", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPLINWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "weightDistributedOnLine", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPLINVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "volumeDistributedOnLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesInvoiceLine.prototype, "weightUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesInvoiceLine.prototype, "volumeUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRH',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], SalesInvoiceLine.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], SalesInvoiceLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IMPNUMLIG',
    })
], SalesInvoiceLine.prototype, "importLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIDORI',
        dataType: () => sageX3Sales.enums.salesInvoiceSourceDatatype,
    })
], SalesInvoiceLine.prototype, "sourceDocumentType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVPRC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesInvoiceLine.prototype, "invoicePercentageForScheduledInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRINVCNDLIN',
    })
], SalesInvoiceLine.prototype, "scheduledInvoiceLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRINVCNDTYP',
        dataType: () => sageX3SalesData.enums.salesDocumentTypeDatatype,
    })
], SalesInvoiceLine.prototype, "scheduledinvoiceSource", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesInvoiceLine.prototype, "invoiceLineTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesInvoiceLine.prototype, "invoiceLineText", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceLineDistributedInvoicingElements,
    })
], SalesInvoiceLine.prototype, "distributedInvoicingElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceLineProductStatisticalGroups,
    })
], SalesInvoiceLine.prototype, "productStatisticalGroups", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceLineTaxBasisAmounts,
    })
], SalesInvoiceLine.prototype, "taxBasisAmounts", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesInvoiceLineTaxes,
    })
], SalesInvoiceLine.prototype, "taxes", void 0);
exports.SalesInvoiceLine = SalesInvoiceLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SINVOICED',
        keyPropertyNames: ['salesInvoice', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    salesInvoice: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['lineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SalesInvoiceLine);
//# sourceMappingURL=sales-invoice-line.js.map