import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesDelivery extends Node {
    readonly id: Promise<string>;
    readonly shippingSite: Reference<sageX3System.nodes.Site>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly category: Promise<sageX3SalesData.enums.DeliveryCategory | null>;
    readonly isLoanDelivery: Promise<boolean>;
    readonly salesSite: Reference<sageX3System.nodes.Site>;
    readonly salesInvoice: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly sequenceInSalesInvoice: Promise<integer | null>;
    readonly salesInvoiceToBeIssued: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly salesInvoiceToBeIssuedReversalDate: Promise<date | null>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly shipmentDate: Promise<date>;
    readonly shipmentTime: Promise<string>;
    readonly deliveryDate: Promise<date | null>;
    readonly deliveryTime: Promise<string>;
    readonly deliveryLeadTimeInDays: Promise<integer | null>;
    readonly deliveryLeadTimeInHours: Promise<integer | null>;
    readonly loanReturnDate: Promise<date | null>;
    readonly shipToCustomerPostalCode: Promise<string>;
    readonly shipToCustomerCity: Promise<string>;
    readonly shipToCustomerState: Promise<string>;
    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly shipToCustomerCountryName: Promise<string>;
    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly billToCustomerPostalCode: Promise<string>;
    readonly billToCustomerCity: Promise<string>;
    readonly billToCustomerState: Promise<string>;
    readonly billToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly billToCustomerCountryName: Promise<string>;
    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
    readonly billToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly currencyRateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly inverseRate: Promise<decimal | null>;
    readonly billToCustomerLanguage: Reference<sageX3System.nodes.Language | null>;
    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
    readonly entityUse: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
    readonly invoicingFrequency: Promise<sageX3SalesData.enums.InvoicingFrequency | null>;
    readonly dueDateCalculationOrigin: Promise<sageX3SalesData.enums.DueDateCalculationSource | null>;
    readonly invoicingMode: Promise<sageX3SalesData.enums.InvoicingMode | null>;
    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder | null>;
    readonly mustPrintTransportNote: Promise<boolean>;
    readonly mustPrintPickTicket: Promise<boolean>;
    readonly mustPrintPackingSlip: Promise<boolean>;
    readonly isPickTicketPrinted: Promise<boolean>;
    readonly isPackingSlipPrinted: Promise<boolean>;
    readonly numberOfPackingSlipCopies: Promise<integer | null>;
    readonly isValidated: Promise<boolean>;
    readonly isInvoiced: Promise<boolean>;
    readonly salesProforma: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly isIntersite: Promise<boolean>;
    readonly isIntercompany: Promise<boolean>;
    readonly sourceSite: Reference<sageX3System.nodes.Site | null>;
    readonly receivingSite: Reference<sageX3System.nodes.Site | null>;
    readonly pickingHeaderTextKey: Promise<string>;
    readonly pickingFooterTextKey: Promise<string>;
    readonly deliveryHeaderTextKey: Promise<string>;
    readonly deliveryFooterTextKey: Promise<string>;
    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly linesAmountExcludingTax: Promise<decimal | null>;
    readonly linesAmountIncludingTax: Promise<decimal | null>;
    readonly linesAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly linesAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountExcludingTax: Promise<decimal | null>;
    readonly totalAmountIncludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly numberOfLines: Promise<integer | null>;
    readonly numberOfReturnedLines: Promise<integer | null>;
    readonly returnStatus: Promise<sageX3SalesData.enums.ReturnStatus | null>;
    readonly customerLocation: Reference<sageX3StockData.nodes.Location | null>;
    readonly labelNumber: Promise<string>;
    readonly numberOfPackages: Promise<integer | null>;
    readonly isPacked: Promise<boolean>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly netWeight: Promise<decimal | null>;
    readonly grossWeight: Promise<decimal | null>;
    readonly volume: Promise<decimal | null>;
    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
    readonly intrastatStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
    readonly intrastatProcessingNumber: Promise<integer | null>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly incotermTown: Promise<string>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly geographicCode: Promise<string>;
    readonly insideCityLimits: Promise<string>;
    readonly vertexTransactionType: Promise<string>;
    readonly taxAmount: Promise<decimal | null>;
    readonly taxableAmount: Promise<decimal | null>;
    readonly vehicleLicensePlate: Promise<string>;
    readonly trailerLicensePlate: Promise<string>;
    readonly departureDate: Promise<date | null>;
    readonly arrivalDate: Promise<date | null>;
    readonly departureTime: Promise<string>;
    readonly arrivalTime: Promise<string>;
    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
    readonly totalQuantityDistributedOnLines: Promise<decimal | null>;
    readonly totalWeightDistributedOnLines: Promise<decimal | null>;
    readonly totalVolumeDistributedOnLines: Promise<decimal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly isForSubconractDelivery: Promise<boolean>;
    readonly deliveryType: Reference<sageX3SalesData.nodes.SalesDeliveryType | null>;
    readonly initialDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
    readonly isValidatedAddress: Promise<boolean>;
    readonly billOfLading: Promise<string>;
    readonly salesDeliveryLines: Collection<sageX3Sales.nodes.SalesDeliveryLine>;
    readonly pickingHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly pickingFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly deliveryHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly deliveryFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly deliveryFooterText: Promise<TextStream>;
    readonly deliveryHeaderText: Promise<TextStream>;
    readonly pickingFooterText: Promise<TextStream>;
    readonly pickingHeaderText: Promise<TextStream>;
    readonly billToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesDeliveryBillToCustomerAddressLines>;
    readonly billToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesDeliveryBillToCustomerCompanyNames>;
    readonly customerStatisticalGroups: Collection<sageX3Sales.nodes.SalesDeliveryCustomerStatisticalGroups>;
    readonly dimensions: Collection<sageX3Sales.nodes.SalesDeliveryDimensions>;
    readonly discountOrChargeCalculationRules: Collection<sageX3Sales.nodes.SalesDeliveryDiscountOrChargeCalculationRules>;
    readonly invoicingElements: Collection<sageX3Sales.nodes.SalesDeliveryInvoicingElements>;
    readonly salesReps: Collection<sageX3Sales.nodes.SalesDeliverySalesReps>;
    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesDeliveryShipToCustomerAddressLines>;
    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesDeliveryShipToCustomerCompanyNames>;
}
//# sourceMappingURL=sales-delivery.d.ts.map