import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3SalesProjectManagement from '..';
export declare class SalesDocument extends Node {
    readonly id: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
    readonly revisionNumber: Promise<integer | null>;
    readonly documentType: Promise<sageX3ProjectManagementData.enums.SoldProductsDocumentType>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly date: Promise<date>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly customerReference: Promise<string>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType>;
    readonly reverse: Promise<decimal>;
    readonly divisor: Promise<decimal>;
    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm | null>;
    readonly documentNumber: Promise<string>;
    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType | null>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.Address | null>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly requestedDeliveryDate: Promise<date | null>;
    readonly shipmentDate: Promise<date | null>;
    readonly salesInvoiceType: Reference<sageX3SalesData.nodes.SalesInvoiceType | null>;
    readonly salesOrderType: Reference<sageX3SalesData.nodes.SalesOrderType | null>;
    readonly salesQuoteType: Reference<sageX3SalesData.nodes.SalesQuoteType | null>;
    readonly dueDateCalculationStartDate: Promise<date | null>;
    readonly validityDate: Promise<date | null>;
    readonly lines: Collection<sageX3SalesProjectManagement.nodes.SalesDocumentLine>;
}
//# sourceMappingURL=sales-document.d.ts.map