"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectBillingPlan = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagement = require("@sage/x3-project-management");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3Sales = require("@sage/x3-sales");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3SalesProjectManagement = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        project: {
            id: 'project',
        },
        salesOrderNumber: {
            id: 'salesOrderNumber',
        },
        currency: {
            code: 'currency',
        },
        unit: {
            code: 'unit',
        },
        projectLink: {
            id: 'projectLink',
        },
        task: {
            project: 'project',
            code: 'task',
        },
        budget: {
            project: 'project',
            code: 'budget',
        },
    },
    collectionJoins: {
        lines: {
            billingPlan: 'id',
        },
    },
};
let ProjectBillingPlan = class ProjectBillingPlan extends xtrem_core_1.Node {
};
exports.ProjectBillingPlan = ProjectBillingPlan;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PRGBILNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProjectBillingPlan.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'DESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], ProjectBillingPlan.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], ProjectBillingPlan.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PROBIL',
        dataType: () => sageX3ProjectManagementData.enums.billingModeDatatype,
    })
], ProjectBillingPlan.prototype, "billingMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], ProjectBillingPlan.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesOrder,
    })
], ProjectBillingPlan.prototype, "salesOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOPLIN',
    })
], ProjectBillingPlan.prototype, "salesOrderLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOPSEQ',
    })
], ProjectBillingPlan.prototype, "salesOrderSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], ProjectBillingPlan.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], ProjectBillingPlan.prototype, "unit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRJLNK',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], ProjectBillingPlan.prototype, "projectLink", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
    })
], ProjectBillingPlan.prototype, "task", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Budget,
    })
], ProjectBillingPlan.prototype, "budget", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERSTRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlan.prototype, "periodStart", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlan.prototype, "periodEnd", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3SalesProjectManagement.nodes.ProjectBillingPlanLine,
        isMutable: true,
        dependsOn: ['id'],
    })
], ProjectBillingPlan.prototype, "lines", void 0);
exports.ProjectBillingPlan = ProjectBillingPlan = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMPRGBILH',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ProjectBillingPlan);
//# sourceMappingURL=project-billing-plan.js.map