import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagement from '@sage/x3-project-management';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3Sales from '@sage/x3-sales';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, Collection } from '@sage/xtrem-core';
import * as sageX3SalesProjectManagement from '..';
export declare class ProjectBillingPlan extends Node {
    readonly id: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
    readonly salesOrderNumber: Reference<sageX3Sales.nodes.SalesOrder>;
    readonly salesOrderLineNumber: Promise<integer>;
    readonly salesOrderSequenceNumber: Promise<integer>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
    readonly task: Reference<sageX3ProjectManagement.nodes.Task | null>;
    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
    readonly periodStart: Promise<date | null>;
    readonly periodEnd: Promise<date | null>;
    readonly lines: Collection<sageX3SalesProjectManagement.nodes.ProjectBillingPlanLine>;
}
//# sourceMappingURL=project-billing-plan.d.ts.map