declare module '@sage/x3-sales-project-management-api-partial' {
    import type { EntryType, Journal, Package as SageX3FinanceData$Package } from '@sage/x3-finance-data-api';
    import type {
        InvoicingTerm,
        Package as SageX3InvoicingData$Package,
        PaymentTerm,
        TaxRule,
    } from '@sage/x3-invoicing-data-api';
    import type { Package as SageX3ManufacturingData$Package } from '@sage/x3-manufacturing-data-api';
    import type {
        Address,
        BusinessPartner,
        Carrier,
        Currency,
        Customer,
        CustomerAddress,
        CustomerContact,
        Package as SageX3MasterData$Package,
        Product,
        ProductVersion,
        SalesRep,
        ShipToCustomerAddress,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type { Package as SageX3PhysicalFlowsData$Package, Packaging } from '@sage/x3-physical-flows-data-api';
    import type {
        Budget,
        BudgetLine,
        Operation,
        OperationAssignment,
        Package as SageX3ProjectManagement$Package,
        Project,
        ProjectUser,
        SaleableProductInput,
        Task,
        TaskProduct,
        TimeCategory,
        TimeEntryLineCurrencyRates,
        TimeEntryLineCurrencyRatesBinding,
        TimeEntryLineCurrencyRatesInput,
        TimeEntryLineDimensions,
        TimeEntryLineDimensionsBinding,
        TimeEntryLineDimensionsInput,
        TimeEntryLineInput,
    } from '@sage/x3-project-management-api';
    import type {
        CostType,
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type { DeliveryMode, Package as SageX3PurchasingData$Package } from '@sage/x3-purchasing-data-api';
    import type {
        Package as SageX3Sales$Package,
        SalesDelivery,
        SalesDeliveryLine,
        SalesInvoice,
        SalesInvoiceLine,
        SalesInvoiceLineDistributedInvoicingElements,
        SalesInvoiceLineDistributedInvoicingElementsBinding,
        SalesInvoiceLineDistributedInvoicingElementsInput,
        SalesInvoiceLineInput,
        SalesInvoiceLineProductStatisticalGroups,
        SalesInvoiceLineProductStatisticalGroupsBinding,
        SalesInvoiceLineProductStatisticalGroupsInput,
        SalesInvoiceLineTaxBasisAmounts,
        SalesInvoiceLineTaxBasisAmountsBinding,
        SalesInvoiceLineTaxBasisAmountsInput,
        SalesInvoiceLineTaxes,
        SalesInvoiceLineTaxesBinding,
        SalesInvoiceLineTaxesInput,
        SalesOrder,
        SalesOrderLine,
        SalesOrderLineDimensionDimensions,
        SalesOrderLineDimensionDimensionsInput,
        SalesOrderLineInput,
        SalesOrderLineProductStatisticalGroups,
        SalesOrderLineProductStatisticalGroupsBinding,
        SalesOrderLineProductStatisticalGroupsInput,
        SalesOrderLineTaxes,
        SalesOrderLineTaxesBinding,
        SalesOrderLineTaxesInput,
        SalesOrderQuantityLineDistributedInvoicingElements,
        SalesOrderQuantityLineDistributedInvoicingElementsInput,
        SalesQuote,
        SalesQuoteLine,
        SalesQuoteLineDistributedInvoicingElements,
        SalesQuoteLineDistributedInvoicingElementsBinding,
        SalesQuoteLineDistributedInvoicingElementsInput,
        SalesQuoteLineInput,
        SalesQuoteLineTaxes,
        SalesQuoteLineTaxesBinding,
        SalesQuoteLineTaxesInput,
        SalesReturn,
        SalesReturnLine,
    } from '@sage/x3-sales-api';
    import type {
        Package as SageX3SalesData$Package,
        SalesInvoiceType,
        SalesOrderType,
        SalesPriceReason,
        SalesQuoteType,
    } from '@sage/x3-sales-data-api';
    import type { Package as SageX3Stock$Package } from '@sage/x3-stock-api';
    import type {
        Location,
        MajorVersionStatus,
        Package as SageX3StockData$Package,
        Warehouse,
    } from '@sage/x3-stock-data-api';
    import type { Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type { Company, MiscellaneousTable, Package as SageX3System$Package, Site, User } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface ProjectBillingPlanLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        billingPlan: ProjectBillingPlan;
        lineNumber: integer;
        documentType: Origin;
        status: ProgressBillingLineStatus;
        isValidated: boolean;
        isRefreshRequested: boolean;
        localizedDescription: string;
        periodStart: string;
        periodEnd: string;
        nextInvoiceDate: string;
        currency: Currency;
        unit: UnitOfMeasure;
        estimationDate: string;
        estimatedProgress: string;
        estimatedQuantity: string;
        estimatedAmount: string;
        billedProgress: string;
        billedQuantity: string;
        billedAmount: string;
        cumulatedQuantity: string;
        cumulatedAmount: string;
        remainingQuantity: string;
        remainingAmount: string;
        createdOn: string;
        createdBy: User;
        updatedOn: string;
        updatedBy: User;
        validatedOn: string;
        validatedBy: User;
        adjustedOn: string;
        adjustedBy: User;
        adjustedValue: AdjustedValue;
        salesInvoice: SalesInvoice;
        salesInvoiceLine: SalesInvoiceLine;
    }
    export interface ProjectBillingPlanLineInput extends ClientNodeInput {
        billingPlan?: string;
        lineNumber?: integer | string;
        documentType?: Origin;
        status?: ProgressBillingLineStatus;
        isValidated?: boolean | string;
        isRefreshRequested?: boolean | string;
        localizedDescription?: string;
        periodStart?: string;
        periodEnd?: string;
        nextInvoiceDate?: string;
        currency?: string;
        unit?: string;
        estimationDate?: string;
        estimatedProgress?: decimal | string;
        estimatedQuantity?: decimal | string;
        estimatedAmount?: decimal | string;
        billedProgress?: decimal | string;
        billedQuantity?: decimal | string;
        billedAmount?: decimal | string;
        cumulatedQuantity?: decimal | string;
        cumulatedAmount?: decimal | string;
        remainingQuantity?: decimal | string;
        remainingAmount?: decimal | string;
        createdOn?: string;
        createdBy?: string;
        updatedOn?: string;
        updatedBy?: string;
        validatedOn?: string;
        validatedBy?: string;
        adjustedOn?: string;
        adjustedBy?: string;
        adjustedValue?: AdjustedValue;
        salesInvoice?: string;
        salesInvoiceLine?: integer | string;
    }
    export interface ProjectBillingPlanLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        billingPlan: ProjectBillingPlan;
        lineNumber: integer;
        documentType: Origin;
        status: ProgressBillingLineStatus;
        isValidated: boolean;
        isRefreshRequested: boolean;
        localizedDescription: string;
        periodStart: string;
        periodEnd: string;
        nextInvoiceDate: string;
        currency: Currency;
        unit: UnitOfMeasure;
        estimationDate: string;
        estimatedProgress: string;
        estimatedQuantity: string;
        estimatedAmount: string;
        billedProgress: string;
        billedQuantity: string;
        billedAmount: string;
        cumulatedQuantity: string;
        cumulatedAmount: string;
        remainingQuantity: string;
        remainingAmount: string;
        createdOn: string;
        createdBy: User;
        updatedOn: string;
        updatedBy: User;
        validatedOn: string;
        validatedBy: User;
        adjustedOn: string;
        adjustedBy: User;
        adjustedValue: AdjustedValue;
        salesInvoice: SalesInvoice;
        salesInvoiceLine: SalesInvoiceLine;
    }
    export interface ProjectBillingPlanLine$Lookups {
        billingPlan: QueryOperation<ProjectBillingPlan>;
        currency: QueryOperation<Currency>;
        unit: QueryOperation<UnitOfMeasure>;
        createdBy: QueryOperation<User>;
        updatedBy: QueryOperation<User>;
        validatedBy: QueryOperation<User>;
        adjustedBy: QueryOperation<User>;
        salesInvoice: QueryOperation<SalesInvoice>;
        salesInvoiceLine: QueryOperation<SalesInvoiceLine>;
    }
    export interface ProjectBillingPlanLine$Operations {
        query: QueryOperation<ProjectBillingPlanLine>;
        read: ReadOperation<ProjectBillingPlanLine>;
        aggregate: {
            read: AggregateReadOperation<ProjectBillingPlanLine>;
            query: AggregateQueryOperation<ProjectBillingPlanLine>;
        };
        lookups(dataOrId: string | { data: ProjectBillingPlanLineInput }): ProjectBillingPlanLine$Lookups;
        getDefaults: GetDefaultsOperation<ProjectBillingPlanLine>;
    }
    export interface ProjectBillingPlan extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        localizedDescription: string;
        site: Site;
        billingMode: BillingMode;
        project: ProjectLink;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderSequenceNumber: integer;
        currency: Currency;
        unit: UnitOfMeasure;
        projectLink: ProjectLink;
        task: Task;
        budget: Budget;
        periodStart: string;
        periodEnd: string;
        lines: ClientCollection<ProjectBillingPlanLine>;
    }
    export interface ProjectBillingPlanInput extends ClientNodeInput {
        id?: string;
        localizedDescription?: string;
        site?: string;
        billingMode?: BillingMode;
        project?: string;
        salesOrderNumber?: string;
        salesOrderLineNumber?: integer | string;
        salesOrderSequenceNumber?: integer | string;
        currency?: string;
        unit?: string;
        projectLink?: string;
        task?: string;
        budget?: string;
        periodStart?: string;
        periodEnd?: string;
        lines?: Partial<ProjectBillingPlanLineInput>[];
    }
    export interface ProjectBillingPlanBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        localizedDescription: string;
        site: Site;
        billingMode: BillingMode;
        project: ProjectLink;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderSequenceNumber: integer;
        currency: Currency;
        unit: UnitOfMeasure;
        projectLink: ProjectLink;
        task: Task;
        budget: Budget;
        periodStart: string;
        periodEnd: string;
        lines: ClientCollection<ProjectBillingPlanLine>;
    }
    export interface ProjectBillingPlan$Lookups {
        site: QueryOperation<Site>;
        project: QueryOperation<ProjectLink>;
        salesOrderNumber: QueryOperation<SalesOrder>;
        currency: QueryOperation<Currency>;
        unit: QueryOperation<UnitOfMeasure>;
        projectLink: QueryOperation<ProjectLink>;
        task: QueryOperation<Task>;
        budget: QueryOperation<Budget>;
    }
    export interface ProjectBillingPlan$Operations {
        query: QueryOperation<ProjectBillingPlan>;
        read: ReadOperation<ProjectBillingPlan>;
        aggregate: {
            read: AggregateReadOperation<ProjectBillingPlan>;
            query: AggregateQueryOperation<ProjectBillingPlan>;
        };
        lookups(dataOrId: string | { data: ProjectBillingPlanInput }): ProjectBillingPlan$Lookups;
        getDefaults: GetDefaultsOperation<ProjectBillingPlan>;
    }
    export interface SalesDocumentLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        projectDocument: string;
        lineNumber: integer;
        documentLineNumber: integer;
        project: ProjectLink;
        revisionNumber: integer;
        budget: string;
        product: Product;
        productDescription: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        plannedQuantity: string;
        plannedUnit: UnitOfMeasure;
        documentQuantity: string;
        salesUnit: UnitOfMeasure;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        currency: Currency;
        basePrice: string;
        doApplyBasePrice: boolean;
        task: Task;
        customer: BusinessPartner;
        documentType: SoldProductsDocumentType;
        documentNumber: string;
        projectLink: ProjectLink;
    }
    export interface SalesDocumentLineInput extends ClientNodeInput {
        projectDocument?: string;
        lineNumber?: integer | string;
        documentLineNumber?: integer | string;
        project?: string;
        revisionNumber?: integer | string;
        budget?: string;
        product?: string;
        productDescription?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        plannedQuantity?: decimal | string;
        plannedUnit?: string;
        documentQuantity?: decimal | string;
        salesUnit?: string;
        quantityInStockUnit?: decimal | string;
        stockUnit?: string;
        currency?: string;
        basePrice?: decimal | string;
        doApplyBasePrice?: boolean | string;
        task?: string;
        customer?: string;
        documentType?: SoldProductsDocumentType;
        documentNumber?: string;
        projectLink?: string;
    }
    export interface SalesDocumentLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        projectDocument: string;
        lineNumber: integer;
        documentLineNumber: integer;
        project: ProjectLink;
        revisionNumber: integer;
        budget: string;
        product: Product;
        productDescription: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        plannedQuantity: string;
        plannedUnit: UnitOfMeasure;
        documentQuantity: string;
        salesUnit: UnitOfMeasure;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        currency: Currency;
        basePrice: string;
        doApplyBasePrice: boolean;
        task: Task;
        customer: BusinessPartner;
        documentType: SoldProductsDocumentType;
        documentNumber: string;
        projectLink: ProjectLink;
    }
    export interface SalesDocumentLine$Lookups {
        project: QueryOperation<ProjectLink>;
        product: QueryOperation<Product>;
        majorProductVersion: QueryOperation<MajorVersionStatus>;
        plannedUnit: QueryOperation<UnitOfMeasure>;
        salesUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
        task: QueryOperation<Task>;
        customer: QueryOperation<BusinessPartner>;
        projectLink: QueryOperation<ProjectLink>;
    }
    export interface SalesDocumentLine$Operations {
        query: QueryOperation<SalesDocumentLine>;
        read: ReadOperation<SalesDocumentLine>;
        aggregate: {
            read: AggregateReadOperation<SalesDocumentLine>;
            query: AggregateQueryOperation<SalesDocumentLine>;
        };
        lookups(dataOrId: string | { data: SalesDocumentLineInput }): SalesDocumentLine$Lookups;
        getDefaults: GetDefaultsOperation<SalesDocumentLine>;
    }
    export interface SalesDocument extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        project: ProjectLink;
        revisionNumber: integer;
        documentType: SoldProductsDocumentType;
        soldToCustomer: Customer;
        date: string;
        site: Site;
        customerReference: string;
        currency: Currency;
        rateType: ExchangeRateType;
        reverse: string;
        divisor: string;
        taxRule: TaxRule;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        shippingSite: Site;
        paymentTerm: PaymentTerm;
        documentNumber: string;
        allocationType: AllocationType;
        shipToCustomerAddress: Address;
        billToCustomer: BusinessPartner;
        payByBusinessPartner: BusinessPartner;
        requestedDeliveryDate: string;
        shipmentDate: string;
        salesInvoiceType: SalesInvoiceType;
        salesOrderType: SalesOrderType;
        salesQuoteType: SalesQuoteType;
        dueDateCalculationStartDate: string;
        validityDate: string;
        lines: ClientCollection<SalesDocumentLine>;
    }
    export interface SalesDocumentInput extends ClientNodeInput {
        id?: string;
        project?: string;
        revisionNumber?: integer | string;
        documentType?: SoldProductsDocumentType;
        soldToCustomer?: string;
        date?: string;
        site?: string;
        customerReference?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        reverse?: decimal | string;
        divisor?: decimal | string;
        taxRule?: string;
        priceIncludingOrExcludingTax?: PriceAmountTaxTax;
        shippingSite?: string;
        paymentTerm?: string;
        documentNumber?: string;
        allocationType?: AllocationType;
        shipToCustomerAddress?: string;
        billToCustomer?: string;
        payByBusinessPartner?: string;
        requestedDeliveryDate?: string;
        shipmentDate?: string;
        salesInvoiceType?: string;
        salesOrderType?: string;
        salesQuoteType?: string;
        dueDateCalculationStartDate?: string;
        validityDate?: string;
        lines?: Partial<SalesDocumentLineInput>[];
    }
    export interface SalesDocumentBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        project: ProjectLink;
        revisionNumber: integer;
        documentType: SoldProductsDocumentType;
        soldToCustomer: Customer;
        date: string;
        site: Site;
        customerReference: string;
        currency: Currency;
        rateType: ExchangeRateType;
        reverse: string;
        divisor: string;
        taxRule: TaxRule;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        shippingSite: Site;
        paymentTerm: PaymentTerm;
        documentNumber: string;
        allocationType: AllocationType;
        shipToCustomerAddress: Address;
        billToCustomer: BusinessPartner;
        payByBusinessPartner: BusinessPartner;
        requestedDeliveryDate: string;
        shipmentDate: string;
        salesInvoiceType: SalesInvoiceType;
        salesOrderType: SalesOrderType;
        salesQuoteType: SalesQuoteType;
        dueDateCalculationStartDate: string;
        validityDate: string;
        lines: ClientCollection<SalesDocumentLine>;
    }
    export interface SalesDocument$Lookups {
        project: QueryOperation<ProjectLink>;
        soldToCustomer: QueryOperation<Customer>;
        site: QueryOperation<Site>;
        currency: QueryOperation<Currency>;
        taxRule: QueryOperation<TaxRule>;
        shippingSite: QueryOperation<Site>;
        paymentTerm: QueryOperation<PaymentTerm>;
        shipToCustomerAddress: QueryOperation<Address>;
        billToCustomer: QueryOperation<BusinessPartner>;
        payByBusinessPartner: QueryOperation<BusinessPartner>;
        salesInvoiceType: QueryOperation<SalesInvoiceType>;
        salesOrderType: QueryOperation<SalesOrderType>;
        salesQuoteType: QueryOperation<SalesQuoteType>;
    }
    export interface SalesDocument$Operations {
        query: QueryOperation<SalesDocument>;
        read: ReadOperation<SalesDocument>;
        aggregate: {
            read: AggregateReadOperation<SalesDocument>;
            query: AggregateQueryOperation<SalesDocument>;
        };
        lookups(dataOrId: string | { data: SalesDocumentInput }): SalesDocument$Lookups;
        getDefaults: GetDefaultsOperation<SalesDocument>;
    }
    export interface SaleableProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: ProjectLink;
        budget: Budget;
        task: Task;
        lineNumber: integer;
        product: Product;
        description: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        plannedQuantity: string;
        plannedUnit: UnitOfMeasure;
        quantity: string;
        salesUnit: UnitOfMeasure;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        currency: Currency;
        basePrice: string;
        origin: SaleablePrdLineOrigin;
        initialGrouping: SoldProductsLinePrdGrpLvl;
        productGroupingLevel: SoldProductsLinePrdGrpLvl;
        sourceOperation: Operation;
        sourceProductLine: TaskProduct;
        sourceBudgetLine: BudgetLine;
        lineOrigin: string;
        salesDocument: SalesDocument;
        salesDocumentLine: SalesDocumentLine;
    }
    export interface SaleableProductInputExtension {
        project?: string;
        budget?: string;
        task?: string;
        lineNumber?: integer | string;
        product?: string;
        description?: string;
        majorVersion?: string;
        minorVersion?: string;
        plannedQuantity?: decimal | string;
        plannedUnit?: string;
        quantity?: decimal | string;
        salesUnit?: string;
        quantityInStockUnit?: decimal | string;
        stockUnit?: string;
        currency?: string;
        basePrice?: decimal | string;
        origin?: SaleablePrdLineOrigin;
        initialGrouping?: SoldProductsLinePrdGrpLvl;
        productGroupingLevel?: SoldProductsLinePrdGrpLvl;
        sourceOperation?: integer | string;
        sourceProductLine?: integer | string;
        sourceBudgetLine?: integer | string;
        lineOrigin?: string;
        salesDocument?: string;
        salesDocumentLine?: integer | string;
    }
    export interface SaleableProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        project: ProjectLink;
        budget: Budget;
        task: Task;
        lineNumber: integer;
        product: Product;
        description: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        plannedQuantity: string;
        plannedUnit: UnitOfMeasure;
        quantity: string;
        salesUnit: UnitOfMeasure;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        currency: Currency;
        basePrice: string;
        origin: SaleablePrdLineOrigin;
        initialGrouping: SoldProductsLinePrdGrpLvl;
        productGroupingLevel: SoldProductsLinePrdGrpLvl;
        sourceOperation: Operation;
        sourceProductLine: TaskProduct;
        sourceBudgetLine: BudgetLine;
        lineOrigin: string;
        salesDocument: SalesDocument;
        salesDocumentLine: SalesDocumentLine;
    }
    export interface SaleableProductExtension$Lookups {
        salesDocument: QueryOperation<SalesDocument>;
        salesDocumentLine: QueryOperation<SalesDocumentLine>;
    }
    export interface SaleableProductExtension$Operations {
        lookups(dataOrId: string | { data: SaleableProductInput }): SaleableProductExtension$Lookups;
    }
    export interface SalesInvoiceLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesInvoice: SalesInvoice;
        lineNumber: integer;
        company: Company;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderLine: SalesOrderLine;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
        sourceSalesInvoice: SalesInvoice;
        sourceSalesInvoiceLine: SalesInvoiceLine;
        salesReturn: SalesReturn;
        salesReturnLine: SalesReturnLine;
        billToCustomer: Customer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRep1CommissionBase: string;
        salesRep2CommissionBase: string;
        salesRep1CommissionAmount: string;
        salesRep2CommissionAmount: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        lineAmountEnteredManually: string;
        lineAmountExcludingTax: string;
        discountLineAmount: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        taxRate: string;
        lineAmountIncludingTax: string;
        isLineWithDistributedInvoicingElement: boolean;
        quantityInSalesUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shippingSite: Site;
        productStockManagement: StockManagement;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        preferentialStockLocationFilter: Location;
        stockPriceInCreditMemoWithStockMovement: string;
        allocationType: TypeOfAllocation;
        salesSite: Site;
        invoiceDate: string;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesInvoiceLine;
        isExtractedIntrastatLine: boolean;
        isIntrastatPhysicalFlow: boolean;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        isPrintedOnInvoice: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        tokenManagement: string;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        project: ProjectLink;
        importLineNumber: integer;
        sourceDocumentType: SalesInvoiceSource;
        invoicePercentageForScheduledInvoice: string;
        scheduledInvoiceLineNumber: integer;
        scheduledinvoiceSource: SalesDocumentType;
        invoiceLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesInvoiceLineDistributedInvoicingElements>;
        productStatisticalGroups: ClientCollection<SalesInvoiceLineProductStatisticalGroups>;
        taxBasisAmounts: ClientCollection<SalesInvoiceLineTaxBasisAmounts>;
        taxes: ClientCollection<SalesInvoiceLineTaxes>;
        projectSalesDocument: SalesDocument;
        projectSalesDocumentLine: SalesDocumentLine;
    }
    export interface SalesInvoiceLineInputExtension {
        salesInvoice?: string;
        lineNumber?: integer | string;
        company?: string;
        salesOrderNumber?: string;
        salesOrderLineNumber?: integer | string;
        salesOrderLine?: integer | string;
        salesDelivery?: string;
        salesDeliveryLine?: integer | string;
        sourceSalesInvoice?: string;
        sourceSalesInvoiceLine?: integer | string;
        salesReturn?: string;
        salesReturnLine?: integer | string;
        billToCustomer?: string;
        product?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        salesRep1?: string;
        salesRep2?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2CommissionRate?: decimal | string;
        salesRep1CommissionBase?: decimal | string;
        salesRep2CommissionBase?: decimal | string;
        salesRep1CommissionAmount?: decimal | string;
        salesRep2CommissionAmount?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        margin?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        lineAmountEnteredManually?: decimal | string;
        lineAmountExcludingTax?: decimal | string;
        discountLineAmount?: decimal | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        taxRate?: decimal | string;
        lineAmountIncludingTax?: decimal | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        quantityInSalesUnitInvoiced?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        shippingSite?: string;
        productStockManagement?: StockManagement;
        exclusiveLotFilter?: string;
        exclusiveStockStatusFilter?: string;
        preferentialStockLocationFilter?: string;
        stockPriceInCreditMemoWithStockMovement?: decimal | string;
        allocationType?: TypeOfAllocation;
        salesSite?: string;
        invoiceDate?: string;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        isExtractedIntrastatLine?: boolean | string;
        isIntrastatPhysicalFlow?: boolean | string;
        geographicCode?: string;
        insideCityLimits?: string;
        isTaxedGeographically?: string;
        isTaxable?: boolean | string;
        isRecordedTax?: boolean | string;
        isPrintedOnInvoice?: boolean | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        servicePeriodNumber?: integer | string;
        servicePeriodType?: PeriodicityType;
        tokenManagement?: decimal | string;
        weightDistributedOnLine?: decimal | string;
        volumeDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        warehouse?: string;
        project?: string;
        importLineNumber?: integer | string;
        sourceDocumentType?: SalesInvoiceSource;
        invoicePercentageForScheduledInvoice?: decimal | string;
        scheduledInvoiceLineNumber?: integer | string;
        scheduledinvoiceSource?: SalesDocumentType;
        invoiceLineText?: TextStream;
        distributedInvoicingElements?: Partial<SalesInvoiceLineDistributedInvoicingElementsInput>[];
        productStatisticalGroups?: Partial<SalesInvoiceLineProductStatisticalGroupsInput>[];
        taxBasisAmounts?: Partial<SalesInvoiceLineTaxBasisAmountsInput>[];
        taxes?: Partial<SalesInvoiceLineTaxesInput>[];
        projectSalesDocument?: string;
        projectSalesDocumentLine?: integer | string;
    }
    export interface SalesInvoiceLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesInvoice: SalesInvoice;
        lineNumber: integer;
        company: Company;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderLine: SalesOrderLine;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
        sourceSalesInvoice: SalesInvoice;
        sourceSalesInvoiceLine: SalesInvoiceLine;
        salesReturn: SalesReturn;
        salesReturnLine: SalesReturnLine;
        billToCustomer: Customer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRep1CommissionBase: string;
        salesRep2CommissionBase: string;
        salesRep1CommissionAmount: string;
        salesRep2CommissionAmount: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        lineAmountEnteredManually: string;
        lineAmountExcludingTax: string;
        discountLineAmount: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        taxRate: string;
        lineAmountIncludingTax: string;
        isLineWithDistributedInvoicingElement: boolean;
        quantityInSalesUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shippingSite: Site;
        productStockManagement: StockManagement;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        preferentialStockLocationFilter: Location;
        stockPriceInCreditMemoWithStockMovement: string;
        allocationType: TypeOfAllocation;
        salesSite: Site;
        invoiceDate: string;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesInvoiceLine;
        isExtractedIntrastatLine: boolean;
        isIntrastatPhysicalFlow: boolean;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        isPrintedOnInvoice: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        tokenManagement: string;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        project: ProjectLink;
        importLineNumber: integer;
        sourceDocumentType: SalesInvoiceSource;
        invoicePercentageForScheduledInvoice: string;
        scheduledInvoiceLineNumber: integer;
        scheduledinvoiceSource: SalesDocumentType;
        invoiceLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesInvoiceLineDistributedInvoicingElementsBinding>;
        productStatisticalGroups: ClientCollection<SalesInvoiceLineProductStatisticalGroupsBinding>;
        taxBasisAmounts: ClientCollection<SalesInvoiceLineTaxBasisAmountsBinding>;
        taxes: ClientCollection<SalesInvoiceLineTaxesBinding>;
        projectSalesDocument: SalesDocument;
        projectSalesDocumentLine: SalesDocumentLine;
    }
    export interface SalesInvoiceLineExtension$Lookups {
        projectSalesDocument: QueryOperation<SalesDocument>;
        projectSalesDocumentLine: QueryOperation<SalesDocumentLine>;
    }
    export interface SalesInvoiceLineExtension$Operations {
        lookups(dataOrId: string | { data: SalesInvoiceLineInput }): SalesInvoiceLineExtension$Lookups;
    }
    export interface SalesOrderLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        category: OrderCategory;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        shipToCustomerContact: CustomerContact;
        billToCustomer: Customer;
        shippingSite: Site;
        salesSite: Site;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        customerProduct: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        lineStatus: LineStatus;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesOrderLine;
        salesQuote: SalesQuote;
        salesQuoteLineNumber: SalesQuoteLine;
        lineRevisionNumber: integer;
        sageSalesTax: MiscellaneousTable;
        consumerSalesPrice: string;
        invoicingTerm: InvoicingTerm;
        allocationType: AllocationType;
        backToBackOrderLineNumber: integer;
        backToBackOrderNumber: string;
        backToBackOrderSequenceNumber: integer;
        carrier: Carrier;
        closingDate: string;
        closingReason: MiscellaneousTable;
        completeDeliveryPriority: integer;
        deliveryLeadTime: integer;
        deliveryMode: DeliveryMode;
        deliveryPriority: DeliveryPriority;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensions>;
        distributedInvoicingElements: ClientCollection<SalesOrderQuantityLineDistributedInvoicingElements>;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        expectedDeliveryDate: string;
        geographicCode: string;
        importLineNumber: integer;
        insideCityLimits: string;
        invoicedAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnInvoice: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isDeliverable: boolean;
        isInvoiced: boolean;
        isLineWithDistributedInvoicingElement: boolean;
        isRecordedTax: boolean;
        isTaxable: boolean;
        isTaxedGeographically: string;
        latestDeliveryDate: string;
        latestDeliveryTime: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        orderDate: string;
        orderLineText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
        preferentialStockLocationFilter: Location;
        preparationCode: string;
        productSource: SourceOfShipment;
        productStockManagement: StockManagement;
        project: ProjectLink;
        quantityInSalesUnitAllocated: string;
        quantityInSalesUnitDelivered: string;
        quantityInSalesUnitInPreparation: string;
        quantityInSalesUnitInitiallyOrdered: string;
        quantityInSalesUnitInvoiced: string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice: string;
        quantityInSalesUnitOnPickList: string;
        quantityInSalesUnitOrdered: string;
        quantityInSalesUnitPrepared: string;
        quantityInSalesUnitShortage: string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock: string;
        quantityInStockUnitAllocated: string;
        quantityInStockUnitDelivered: string;
        quantityInStockUnitInPreparation: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice: string;
        quantityInStockUnitOnPickList: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitPrepared: string;
        quantityInStockUnitShortage: string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock: string;
        requestedDeliveryDate: string;
        requestedDeliveryReference: string;
        requestedDeliveryTime: string;
        routeNumber: RouteCode;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        shipmentDate: string;
        shipmentTime: string;
        taxRate: string;
        taxableAmount: string;
        tokenManagement: string;
        useByDate: string;
        volumeDistributedOnLine: string;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        weightDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workInProgressStatus: StatusInProgress;
        productStatisticalGroups: ClientCollection<SalesOrderLineProductStatisticalGroups>;
        taxes: ClientCollection<SalesOrderLineTaxes>;
        projectBillingPlan: ProjectBillingPlan;
        projectSalesDocument: SalesDocument;
        projectSalesDocumentLine: SalesDocumentLine;
    }
    export interface SalesOrderLineInputExtension {
        salesOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        company?: string;
        category?: OrderCategory;
        soldToCustomer?: string;
        shipToCustomerAddress?: string;
        shipToCustomerContact?: string;
        billToCustomer?: string;
        shippingSite?: string;
        salesSite?: string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        customerProduct?: string;
        salesRep1?: string;
        salesRep2?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2CommissionRate?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        margin?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        lineStatus?: LineStatus;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        salesQuote?: string;
        salesQuoteLineNumber?: integer | string;
        lineRevisionNumber?: integer | string;
        sageSalesTax?: string;
        consumerSalesPrice?: decimal | string;
        invoicingTerm?: string;
        allocationType?: AllocationType;
        backToBackOrderLineNumber?: integer | string;
        backToBackOrderNumber?: string;
        backToBackOrderSequenceNumber?: integer | string;
        carrier?: string;
        closingDate?: string;
        closingReason?: string;
        completeDeliveryPriority?: integer | string;
        deliveryLeadTime?: integer | string;
        deliveryMode?: string;
        deliveryPriority?: DeliveryPriority;
        dimensions?: Partial<SalesOrderLineDimensionDimensionsInput>[];
        distributedInvoicingElements?: Partial<SalesOrderQuantityLineDistributedInvoicingElementsInput>[];
        exclusiveLotFilter?: string;
        exclusiveStockStatusFilter?: string;
        expectedDeliveryDate?: string;
        geographicCode?: string;
        importLineNumber?: integer | string;
        insideCityLimits?: string;
        invoicedAmount?: decimal | string;
        isComponentPrintedOnAcknowledgement?: boolean | string;
        isComponentPrintedOnInvoice?: boolean | string;
        isComponentPrintedOnPackingSlip?: boolean | string;
        isDeliverable?: boolean | string;
        isInvoiced?: boolean | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        isRecordedTax?: boolean | string;
        isTaxable?: boolean | string;
        isTaxedGeographically?: string;
        latestDeliveryDate?: string;
        latestDeliveryTime?: string;
        locationReference?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        orderDate?: string;
        orderLineText?: TextStream;
        packaging?: string;
        packagingCapacity?: decimal | string;
        preferentialStockLocationFilter?: string;
        preparationCode?: string;
        productSource?: SourceOfShipment;
        productStockManagement?: StockManagement;
        project?: string;
        quantityInSalesUnitAllocated?: decimal | string;
        quantityInSalesUnitDelivered?: decimal | string;
        quantityInSalesUnitInPreparation?: decimal | string;
        quantityInSalesUnitInitiallyOrdered?: decimal | string;
        quantityInSalesUnitInvoiced?: decimal | string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice?: decimal | string;
        quantityInSalesUnitOnPickList?: decimal | string;
        quantityInSalesUnitOrdered?: decimal | string;
        quantityInSalesUnitPrepared?: decimal | string;
        quantityInSalesUnitShortage?: decimal | string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock?: decimal | string;
        quantityInStockUnitAllocated?: decimal | string;
        quantityInStockUnitDelivered?: decimal | string;
        quantityInStockUnitInPreparation?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice?: decimal | string;
        quantityInStockUnitOnPickList?: decimal | string;
        quantityInStockUnitOrdered?: decimal | string;
        quantityInStockUnitPrepared?: decimal | string;
        quantityInStockUnitShortage?: decimal | string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock?: decimal | string;
        requestedDeliveryDate?: string;
        requestedDeliveryReference?: string;
        requestedDeliveryTime?: string;
        routeNumber?: RouteCode;
        salesDelivery?: string;
        salesDeliveryLineNumber?: integer | string;
        shipmentDate?: string;
        shipmentTime?: string;
        taxRate?: decimal | string;
        taxableAmount?: decimal | string;
        tokenManagement?: decimal | string;
        useByDate?: string;
        volumeDistributedOnLine?: decimal | string;
        volumeUnitForDistributionOnLines?: string;
        weightDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        workInProgressOrderNumber?: string;
        workInProgressStatus?: StatusInProgress;
        productStatisticalGroups?: Partial<SalesOrderLineProductStatisticalGroupsInput>[];
        taxes?: Partial<SalesOrderLineTaxesInput>[];
        projectBillingPlan?: string;
        projectSalesDocument?: string;
        projectSalesDocumentLine?: integer | string;
    }
    export interface SalesOrderLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        category: OrderCategory;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        shipToCustomerContact: CustomerContact;
        billToCustomer: Customer;
        shippingSite: Site;
        salesSite: Site;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        customerProduct: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        lineStatus: LineStatus;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesOrderLine;
        salesQuote: SalesQuote;
        salesQuoteLineNumber: SalesQuoteLine;
        lineRevisionNumber: integer;
        sageSalesTax: MiscellaneousTable;
        consumerSalesPrice: string;
        invoicingTerm: InvoicingTerm;
        allocationType: AllocationType;
        backToBackOrderLineNumber: integer;
        backToBackOrderNumber: string;
        backToBackOrderSequenceNumber: integer;
        carrier: Carrier;
        closingDate: string;
        closingReason: MiscellaneousTable;
        completeDeliveryPriority: integer;
        deliveryLeadTime: integer;
        deliveryMode: DeliveryMode;
        deliveryPriority: DeliveryPriority;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensions>;
        distributedInvoicingElements: ClientCollection<SalesOrderQuantityLineDistributedInvoicingElements>;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        expectedDeliveryDate: string;
        geographicCode: string;
        importLineNumber: integer;
        insideCityLimits: string;
        invoicedAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnInvoice: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isDeliverable: boolean;
        isInvoiced: boolean;
        isLineWithDistributedInvoicingElement: boolean;
        isRecordedTax: boolean;
        isTaxable: boolean;
        isTaxedGeographically: string;
        latestDeliveryDate: string;
        latestDeliveryTime: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        orderDate: string;
        orderLineText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
        preferentialStockLocationFilter: Location;
        preparationCode: string;
        productSource: SourceOfShipment;
        productStockManagement: StockManagement;
        project: ProjectLink;
        quantityInSalesUnitAllocated: string;
        quantityInSalesUnitDelivered: string;
        quantityInSalesUnitInPreparation: string;
        quantityInSalesUnitInitiallyOrdered: string;
        quantityInSalesUnitInvoiced: string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice: string;
        quantityInSalesUnitOnPickList: string;
        quantityInSalesUnitOrdered: string;
        quantityInSalesUnitPrepared: string;
        quantityInSalesUnitShortage: string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock: string;
        quantityInStockUnitAllocated: string;
        quantityInStockUnitDelivered: string;
        quantityInStockUnitInPreparation: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice: string;
        quantityInStockUnitOnPickList: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitPrepared: string;
        quantityInStockUnitShortage: string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock: string;
        requestedDeliveryDate: string;
        requestedDeliveryReference: string;
        requestedDeliveryTime: string;
        routeNumber: RouteCode;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        shipmentDate: string;
        shipmentTime: string;
        taxRate: string;
        taxableAmount: string;
        tokenManagement: string;
        useByDate: string;
        volumeDistributedOnLine: string;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        weightDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workInProgressStatus: StatusInProgress;
        productStatisticalGroups: ClientCollection<SalesOrderLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<SalesOrderLineTaxesBinding>;
        projectBillingPlan: ProjectBillingPlan;
        projectSalesDocument: SalesDocument;
        projectSalesDocumentLine: SalesDocumentLine;
    }
    export interface SalesOrderLineExtension$Lookups {
        projectBillingPlan: QueryOperation<ProjectBillingPlan>;
        projectSalesDocument: QueryOperation<SalesDocument>;
        projectSalesDocumentLine: QueryOperation<SalesDocumentLine>;
    }
    export interface SalesOrderLineExtension$Operations {
        lookups(dataOrId: string | { data: SalesOrderLineInput }): SalesOrderLineExtension$Lookups;
    }
    export interface SalesQuoteLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesQuote: SalesQuote;
        lineNumber: integer;
        company: Company;
        salesSite: Site;
        soldToCustomer: Customer;
        quoteDate: string;
        deliveryLeadTime: integer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: ProductVersion;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2: SalesRep;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        margin: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        isLineWithDistributedInvoicingElement: boolean;
        quoteQuantity: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shipToCustomerAddress: CustomerAddress;
        shippingSite: Site;
        shipToCustomerContact: CustomerContact;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: integer;
        salesOrder: SalesOrder;
        salesOrderLine: SalesOrderLine;
        isOrdered: boolean;
        orderedQuantity: string;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        taxRate: string;
        taxableAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isComponentPrintedOnInvoice: boolean;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        project: ProjectLink;
        importLineNumber: integer;
        sageSalesTax: MiscellaneousTable;
        isDeliverable: boolean;
        lineRevisionNumber: integer;
        quoteLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesQuoteLineDistributedInvoicingElements>;
        taxes: ClientCollection<SalesQuoteLineTaxes>;
        projectSalesDocument: SalesDocument;
        projectSalesDocumentLine: SalesDocumentLine;
    }
    export interface SalesQuoteLineInputExtension {
        salesQuote?: string;
        lineNumber?: integer | string;
        company?: string;
        salesSite?: string;
        soldToCustomer?: string;
        quoteDate?: string;
        deliveryLeadTime?: integer | string;
        product?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        salesRep1?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2?: string;
        salesRep2CommissionRate?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        margin?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        quoteQuantity?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        shipToCustomerAddress?: string;
        shippingSite?: string;
        shipToCustomerContact?: string;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        salesOrder?: string;
        salesOrderLine?: integer | string;
        isOrdered?: boolean | string;
        orderedQuantity?: decimal | string;
        geographicCode?: string;
        insideCityLimits?: string;
        isTaxedGeographically?: string;
        isTaxable?: boolean | string;
        isRecordedTax?: boolean | string;
        taxRate?: decimal | string;
        taxableAmount?: decimal | string;
        isComponentPrintedOnAcknowledgement?: boolean | string;
        isComponentPrintedOnPackingSlip?: boolean | string;
        isComponentPrintedOnInvoice?: boolean | string;
        weightDistributedOnLine?: decimal | string;
        volumeDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        project?: string;
        importLineNumber?: integer | string;
        sageSalesTax?: string;
        isDeliverable?: boolean | string;
        lineRevisionNumber?: integer | string;
        quoteLineText?: TextStream;
        distributedInvoicingElements?: Partial<SalesQuoteLineDistributedInvoicingElementsInput>[];
        taxes?: Partial<SalesQuoteLineTaxesInput>[];
        projectSalesDocument?: string;
        projectSalesDocumentLine?: integer | string;
    }
    export interface SalesQuoteLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesQuote: SalesQuote;
        lineNumber: integer;
        company: Company;
        salesSite: Site;
        soldToCustomer: Customer;
        quoteDate: string;
        deliveryLeadTime: integer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: ProductVersion;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2: SalesRep;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        margin: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        isLineWithDistributedInvoicingElement: boolean;
        quoteQuantity: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shipToCustomerAddress: CustomerAddress;
        shippingSite: Site;
        shipToCustomerContact: CustomerContact;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: integer;
        salesOrder: SalesOrder;
        salesOrderLine: SalesOrderLine;
        isOrdered: boolean;
        orderedQuantity: string;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        taxRate: string;
        taxableAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isComponentPrintedOnInvoice: boolean;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        project: ProjectLink;
        importLineNumber: integer;
        sageSalesTax: MiscellaneousTable;
        isDeliverable: boolean;
        lineRevisionNumber: integer;
        quoteLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesQuoteLineDistributedInvoicingElementsBinding>;
        taxes: ClientCollection<SalesQuoteLineTaxesBinding>;
        projectSalesDocument: SalesDocument;
        projectSalesDocumentLine: SalesDocumentLine;
    }
    export interface SalesQuoteLineExtension$Lookups {
        projectSalesDocument: QueryOperation<SalesDocument>;
        projectSalesDocumentLine: QueryOperation<SalesDocumentLine>;
    }
    export interface SalesQuoteLineExtension$Operations {
        lookups(dataOrId: string | { data: SalesQuoteLineInput }): SalesQuoteLineExtension$Lookups;
    }
    export interface TimeEntryLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        employee: ProjectUser;
        lineNumber: integer;
        date: string;
        taskLink: ProjectLink;
        budgetLink: ProjectLink;
        project: Project;
        task: Task;
        operation: Operation;
        firstOperationSplit: integer;
        assignmentLine: OperationAssignment;
        budget: Budget;
        financialSite: Site;
        currency: Currency;
        rateType: ExchangeRateType;
        projectCostType: CostType;
        employeeCostType: CostType;
        projectLaborRate: string;
        employeeLaborRate: string;
        timeSpent: string;
        unit: UnitOfMeasure;
        timeCategory: TimeCategory;
        rateMultiplier: string;
        localizedDescription: string;
        isValidated: boolean;
        status: TimeEntryStatus;
        origin: TimeEntryOrigin;
        validatedBy: User;
        controlledBy: User;
        approvedBy: User;
        entryType: EntryType;
        rejectedBy: User;
        journal: Journal;
        postedBy: User;
        journalNumber: string;
        isBillable: boolean;
        billableFrom: string;
        billedQuantity: string;
        longComment: TextStream;
        longDescription: TextStream;
        connectedEmployee: ProjectUser;
        defaultTimeCategory: TimeCategory;
        defaultUnit: UnitOfMeasure;
        isNegativeTimeSpentAllowed: boolean;
        isTimeEntryAdministrator: boolean;
        isTimeEntryEmployee: boolean;
        isValidatedDefault: boolean;
        currencyRates: ClientCollection<TimeEntryLineCurrencyRates>;
        dimensions: ClientCollection<TimeEntryLineDimensions>;
        billingPlan: ProjectBillingPlan;
        billingPlanLine: ProjectBillingPlanLine;
    }
    export interface TimeEntryLineInputExtension {
        employee?: string;
        lineNumber?: integer | string;
        date?: string;
        taskLink?: string;
        budgetLink?: string;
        project?: string;
        task?: string;
        operation?: integer | string;
        firstOperationSplit?: integer | string;
        assignmentLine?: integer | string;
        budget?: string;
        financialSite?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        projectCostType?: string;
        employeeCostType?: string;
        projectLaborRate?: decimal | string;
        employeeLaborRate?: decimal | string;
        timeSpent?: decimal | string;
        unit?: string;
        timeCategory?: string;
        rateMultiplier?: decimal | string;
        localizedDescription?: string;
        isValidated?: boolean | string;
        status?: TimeEntryStatus;
        origin?: TimeEntryOrigin;
        validatedBy?: string;
        controlledBy?: string;
        approvedBy?: string;
        entryType?: string;
        rejectedBy?: string;
        journal?: string;
        postedBy?: string;
        journalNumber?: string;
        isBillable?: boolean | string;
        billableFrom?: string;
        billedQuantity?: decimal | string;
        longComment?: TextStream;
        longDescription?: TextStream;
        currencyRates?: Partial<TimeEntryLineCurrencyRatesInput>[];
        dimensions?: Partial<TimeEntryLineDimensionsInput>[];
        billingPlan?: string;
        billingPlanLine?: integer | string;
    }
    export interface TimeEntryLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        employee: ProjectUser;
        lineNumber: integer;
        date: string;
        taskLink: ProjectLink;
        budgetLink: ProjectLink;
        project: Project;
        task: Task;
        operation: Operation;
        firstOperationSplit: integer;
        assignmentLine: OperationAssignment;
        budget: Budget;
        financialSite: Site;
        currency: Currency;
        rateType: ExchangeRateType;
        projectCostType: CostType;
        employeeCostType: CostType;
        projectLaborRate: string;
        employeeLaborRate: string;
        timeSpent: string;
        unit: UnitOfMeasure;
        timeCategory: TimeCategory;
        rateMultiplier: string;
        localizedDescription: string;
        isValidated: boolean;
        status: TimeEntryStatus;
        origin: TimeEntryOrigin;
        validatedBy: User;
        controlledBy: User;
        approvedBy: User;
        entryType: EntryType;
        rejectedBy: User;
        journal: Journal;
        postedBy: User;
        journalNumber: string;
        isBillable: boolean;
        billableFrom: string;
        billedQuantity: string;
        longComment: TextStream;
        longDescription: TextStream;
        connectedEmployee: ProjectUser;
        defaultTimeCategory: TimeCategory;
        defaultUnit: UnitOfMeasure;
        isNegativeTimeSpentAllowed: boolean;
        isTimeEntryAdministrator: boolean;
        isTimeEntryEmployee: boolean;
        isValidatedDefault: boolean;
        currencyRates: ClientCollection<TimeEntryLineCurrencyRatesBinding>;
        dimensions: ClientCollection<TimeEntryLineDimensionsBinding>;
        billingPlan: ProjectBillingPlan;
        billingPlanLine: ProjectBillingPlanLine;
    }
    export interface TimeEntryLineExtension$Lookups {
        billingPlan: QueryOperation<ProjectBillingPlan>;
        billingPlanLine: QueryOperation<ProjectBillingPlanLine>;
    }
    export interface TimeEntryLineExtension$Operations {
        lookups(dataOrId: string | { data: TimeEntryLineInput }): TimeEntryLineExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-sales-project-management/ProjectBillingPlanLine': ProjectBillingPlanLine$Operations;
        '@sage/x3-sales-project-management/ProjectBillingPlan': ProjectBillingPlan$Operations;
        '@sage/x3-sales-project-management/SalesDocumentLine': SalesDocumentLine$Operations;
        '@sage/x3-sales-project-management/SalesDocument': SalesDocument$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3FinanceData$Package,
            SageX3InvoicingData$Package,
            SageX3ManufacturingData$Package,
            SageX3MasterData$Package,
            SageX3PhysicalFlowsData$Package,
            SageX3ProjectManagement$Package,
            SageX3ProjectManagementData$Package,
            SageX3PurchasingData$Package,
            SageX3Sales$Package,
            SageX3SalesData$Package,
            SageX3Stock$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-sales-project-management-api' {
    export type * from '@sage/x3-sales-project-management-api-partial';
}
declare module '@sage/x3-finance-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-physical-flows-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-sales-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-sales-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-project-management-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-api-partial' {
    import type {
        SaleableProductBindingExtension,
        SaleableProductExtension,
        SaleableProductExtension$Lookups,
        SaleableProductExtension$Operations,
        SaleableProductInputExtension,
        TimeEntryLineBindingExtension,
        TimeEntryLineExtension,
        TimeEntryLineExtension$Lookups,
        TimeEntryLineExtension$Operations,
        TimeEntryLineInputExtension,
    } from '@sage/x3-sales-project-management-api';
    export interface SaleableProduct extends SaleableProductExtension {}
    export interface SaleableProductBinding extends SaleableProductBindingExtension {}
    export interface SaleableProductInput extends SaleableProductInputExtension {}
    export interface SaleableProduct$Lookups extends SaleableProductExtension$Lookups {}
    export interface SaleableProduct$Operations extends SaleableProductExtension$Operations {}
    export interface TimeEntryLine extends TimeEntryLineExtension {}
    export interface TimeEntryLineBinding extends TimeEntryLineBindingExtension {}
    export interface TimeEntryLineInput extends TimeEntryLineInputExtension {}
    export interface TimeEntryLine$Lookups extends TimeEntryLineExtension$Lookups {}
    export interface TimeEntryLine$Operations extends TimeEntryLineExtension$Operations {}
}
declare module '@sage/x3-sales-api-partial' {
    import type {
        SalesInvoiceLineBindingExtension,
        SalesInvoiceLineExtension,
        SalesInvoiceLineExtension$Lookups,
        SalesInvoiceLineExtension$Operations,
        SalesInvoiceLineInputExtension,
        SalesOrderLineBindingExtension,
        SalesOrderLineExtension,
        SalesOrderLineExtension$Lookups,
        SalesOrderLineExtension$Operations,
        SalesOrderLineInputExtension,
        SalesQuoteLineBindingExtension,
        SalesQuoteLineExtension,
        SalesQuoteLineExtension$Lookups,
        SalesQuoteLineExtension$Operations,
        SalesQuoteLineInputExtension,
    } from '@sage/x3-sales-project-management-api';
    export interface SalesInvoiceLine extends SalesInvoiceLineExtension {}
    export interface SalesInvoiceLineBinding extends SalesInvoiceLineBindingExtension {}
    export interface SalesInvoiceLineInput extends SalesInvoiceLineInputExtension {}
    export interface SalesInvoiceLine$Lookups extends SalesInvoiceLineExtension$Lookups {}
    export interface SalesInvoiceLine$Operations extends SalesInvoiceLineExtension$Operations {}
    export interface SalesOrderLine extends SalesOrderLineExtension {}
    export interface SalesOrderLineBinding extends SalesOrderLineBindingExtension {}
    export interface SalesOrderLineInput extends SalesOrderLineInputExtension {}
    export interface SalesOrderLine$Lookups extends SalesOrderLineExtension$Lookups {}
    export interface SalesOrderLine$Operations extends SalesOrderLineExtension$Operations {}
    export interface SalesQuoteLine extends SalesQuoteLineExtension {}
    export interface SalesQuoteLineBinding extends SalesQuoteLineBindingExtension {}
    export interface SalesQuoteLineInput extends SalesQuoteLineInputExtension {}
    export interface SalesQuoteLine$Lookups extends SalesQuoteLineExtension$Lookups {}
    export interface SalesQuoteLine$Operations extends SalesQuoteLineExtension$Operations {}
}
