declare module '@sage/x3-sales-finance-api-partial' {
    import type { Package as SageX3Finance$Package, PrepaymentInvoice } from '@sage/x3-finance-api';
    import type { Package as SageX3FinanceData$Package } from '@sage/x3-finance-data-api';
    import type { InvoicingTerm, Package as SageX3InvoicingData$Package } from '@sage/x3-invoicing-data-api';
    import type { Package as SageX3ManufacturingData$Package } from '@sage/x3-manufacturing-data-api';
    import type {
        Carrier,
        Customer,
        CustomerContact,
        Package as SageX3MasterData$Package,
        Product,
        SalesRep,
        ShipToCustomerAddress,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type { Package as SageX3PhysicalFlowsData$Package, Packaging } from '@sage/x3-physical-flows-data-api';
    import type {
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type { DeliveryMode, Package as SageX3PurchasingData$Package } from '@sage/x3-purchasing-data-api';
    import type {
        Package as SageX3Sales$Package,
        SalesDelivery,
        SalesDeliveryLine,
        SalesOrder,
        SalesOrderLine,
        SalesOrderLineDimensionDimensions,
        SalesOrderLineDimensionDimensionsInput,
        SalesOrderLineInput,
        SalesOrderLineProductStatisticalGroups,
        SalesOrderLineProductStatisticalGroupsBinding,
        SalesOrderLineProductStatisticalGroupsInput,
        SalesOrderLineTaxes,
        SalesOrderLineTaxesBinding,
        SalesOrderLineTaxesInput,
        SalesOrderQuantityLineDistributedInvoicingElements,
        SalesOrderQuantityLineDistributedInvoicingElementsInput,
        SalesQuote,
        SalesQuoteLine,
    } from '@sage/x3-sales-api';
    import type { Package as SageX3SalesData$Package, SalesPriceReason } from '@sage/x3-sales-data-api';
    import type { Package as SageX3Stock$Package } from '@sage/x3-stock-api';
    import type { Location, MajorVersionStatus, Package as SageX3StockData$Package } from '@sage/x3-stock-data-api';
    import type { Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type { Company, MiscellaneousTable, Package as SageX3System$Package, Site } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type { ClientCollection, QueryOperation, TextStream, decimal, integer } from '@sage/xtrem-client';
    export interface SalesOrderLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        category: OrderCategory;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        shipToCustomerContact: CustomerContact;
        billToCustomer: Customer;
        shippingSite: Site;
        salesSite: Site;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        customerProduct: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        lineStatus: LineStatus;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesOrderLine;
        salesQuote: SalesQuote;
        salesQuoteLineNumber: SalesQuoteLine;
        lineRevisionNumber: integer;
        sageSalesTax: MiscellaneousTable;
        consumerSalesPrice: string;
        invoicingTerm: InvoicingTerm;
        allocationType: AllocationType;
        backToBackOrderLineNumber: integer;
        backToBackOrderNumber: string;
        backToBackOrderSequenceNumber: integer;
        carrier: Carrier;
        closingDate: string;
        closingReason: MiscellaneousTable;
        completeDeliveryPriority: integer;
        deliveryLeadTime: integer;
        deliveryMode: DeliveryMode;
        deliveryPriority: DeliveryPriority;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensions>;
        distributedInvoicingElements: ClientCollection<SalesOrderQuantityLineDistributedInvoicingElements>;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        expectedDeliveryDate: string;
        geographicCode: string;
        importLineNumber: integer;
        insideCityLimits: string;
        invoicedAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnInvoice: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isDeliverable: boolean;
        isInvoiced: boolean;
        isLineWithDistributedInvoicingElement: boolean;
        isRecordedTax: boolean;
        isTaxable: boolean;
        isTaxedGeographically: string;
        latestDeliveryDate: string;
        latestDeliveryTime: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        orderDate: string;
        orderLineText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
        preferentialStockLocationFilter: Location;
        preparationCode: string;
        productSource: SourceOfShipment;
        productStockManagement: StockManagement;
        project: ProjectLink;
        quantityInSalesUnitAllocated: string;
        quantityInSalesUnitDelivered: string;
        quantityInSalesUnitInPreparation: string;
        quantityInSalesUnitInitiallyOrdered: string;
        quantityInSalesUnitInvoiced: string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice: string;
        quantityInSalesUnitOnPickList: string;
        quantityInSalesUnitOrdered: string;
        quantityInSalesUnitPrepared: string;
        quantityInSalesUnitShortage: string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock: string;
        quantityInStockUnitAllocated: string;
        quantityInStockUnitDelivered: string;
        quantityInStockUnitInPreparation: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice: string;
        quantityInStockUnitOnPickList: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitPrepared: string;
        quantityInStockUnitShortage: string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock: string;
        requestedDeliveryDate: string;
        requestedDeliveryReference: string;
        requestedDeliveryTime: string;
        routeNumber: RouteCode;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        shipmentDate: string;
        shipmentTime: string;
        taxRate: string;
        taxableAmount: string;
        tokenManagement: string;
        useByDate: string;
        volumeDistributedOnLine: string;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        weightDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workInProgressStatus: StatusInProgress;
        productStatisticalGroups: ClientCollection<SalesOrderLineProductStatisticalGroups>;
        taxes: ClientCollection<SalesOrderLineTaxes>;
        prepaymentContract: PrepaymentInvoice;
    }
    export interface SalesOrderLineInputExtension {
        salesOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        company?: string;
        category?: OrderCategory;
        soldToCustomer?: string;
        shipToCustomerAddress?: string;
        shipToCustomerContact?: string;
        billToCustomer?: string;
        shippingSite?: string;
        salesSite?: string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        customerProduct?: string;
        salesRep1?: string;
        salesRep2?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2CommissionRate?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        margin?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        lineStatus?: LineStatus;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        salesQuote?: string;
        salesQuoteLineNumber?: integer | string;
        lineRevisionNumber?: integer | string;
        sageSalesTax?: string;
        consumerSalesPrice?: decimal | string;
        invoicingTerm?: string;
        allocationType?: AllocationType;
        backToBackOrderLineNumber?: integer | string;
        backToBackOrderNumber?: string;
        backToBackOrderSequenceNumber?: integer | string;
        carrier?: string;
        closingDate?: string;
        closingReason?: string;
        completeDeliveryPriority?: integer | string;
        deliveryLeadTime?: integer | string;
        deliveryMode?: string;
        deliveryPriority?: DeliveryPriority;
        dimensions?: Partial<SalesOrderLineDimensionDimensionsInput>[];
        distributedInvoicingElements?: Partial<SalesOrderQuantityLineDistributedInvoicingElementsInput>[];
        exclusiveLotFilter?: string;
        exclusiveStockStatusFilter?: string;
        expectedDeliveryDate?: string;
        geographicCode?: string;
        importLineNumber?: integer | string;
        insideCityLimits?: string;
        invoicedAmount?: decimal | string;
        isComponentPrintedOnAcknowledgement?: boolean | string;
        isComponentPrintedOnInvoice?: boolean | string;
        isComponentPrintedOnPackingSlip?: boolean | string;
        isDeliverable?: boolean | string;
        isInvoiced?: boolean | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        isRecordedTax?: boolean | string;
        isTaxable?: boolean | string;
        isTaxedGeographically?: string;
        latestDeliveryDate?: string;
        latestDeliveryTime?: string;
        locationReference?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        orderDate?: string;
        orderLineText?: TextStream;
        packaging?: string;
        packagingCapacity?: decimal | string;
        preferentialStockLocationFilter?: string;
        preparationCode?: string;
        productSource?: SourceOfShipment;
        productStockManagement?: StockManagement;
        project?: string;
        quantityInSalesUnitAllocated?: decimal | string;
        quantityInSalesUnitDelivered?: decimal | string;
        quantityInSalesUnitInPreparation?: decimal | string;
        quantityInSalesUnitInitiallyOrdered?: decimal | string;
        quantityInSalesUnitInvoiced?: decimal | string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice?: decimal | string;
        quantityInSalesUnitOnPickList?: decimal | string;
        quantityInSalesUnitOrdered?: decimal | string;
        quantityInSalesUnitPrepared?: decimal | string;
        quantityInSalesUnitShortage?: decimal | string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock?: decimal | string;
        quantityInStockUnitAllocated?: decimal | string;
        quantityInStockUnitDelivered?: decimal | string;
        quantityInStockUnitInPreparation?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice?: decimal | string;
        quantityInStockUnitOnPickList?: decimal | string;
        quantityInStockUnitOrdered?: decimal | string;
        quantityInStockUnitPrepared?: decimal | string;
        quantityInStockUnitShortage?: decimal | string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock?: decimal | string;
        requestedDeliveryDate?: string;
        requestedDeliveryReference?: string;
        requestedDeliveryTime?: string;
        routeNumber?: RouteCode;
        salesDelivery?: string;
        salesDeliveryLineNumber?: integer | string;
        shipmentDate?: string;
        shipmentTime?: string;
        taxRate?: decimal | string;
        taxableAmount?: decimal | string;
        tokenManagement?: decimal | string;
        useByDate?: string;
        volumeDistributedOnLine?: decimal | string;
        volumeUnitForDistributionOnLines?: string;
        weightDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        workInProgressOrderNumber?: string;
        workInProgressStatus?: StatusInProgress;
        productStatisticalGroups?: Partial<SalesOrderLineProductStatisticalGroupsInput>[];
        taxes?: Partial<SalesOrderLineTaxesInput>[];
        prepaymentContract?: string;
    }
    export interface SalesOrderLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        category: OrderCategory;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        shipToCustomerContact: CustomerContact;
        billToCustomer: Customer;
        shippingSite: Site;
        salesSite: Site;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        customerProduct: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        lineStatus: LineStatus;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesOrderLine;
        salesQuote: SalesQuote;
        salesQuoteLineNumber: SalesQuoteLine;
        lineRevisionNumber: integer;
        sageSalesTax: MiscellaneousTable;
        consumerSalesPrice: string;
        invoicingTerm: InvoicingTerm;
        allocationType: AllocationType;
        backToBackOrderLineNumber: integer;
        backToBackOrderNumber: string;
        backToBackOrderSequenceNumber: integer;
        carrier: Carrier;
        closingDate: string;
        closingReason: MiscellaneousTable;
        completeDeliveryPriority: integer;
        deliveryLeadTime: integer;
        deliveryMode: DeliveryMode;
        deliveryPriority: DeliveryPriority;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensions>;
        distributedInvoicingElements: ClientCollection<SalesOrderQuantityLineDistributedInvoicingElements>;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        expectedDeliveryDate: string;
        geographicCode: string;
        importLineNumber: integer;
        insideCityLimits: string;
        invoicedAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnInvoice: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isDeliverable: boolean;
        isInvoiced: boolean;
        isLineWithDistributedInvoicingElement: boolean;
        isRecordedTax: boolean;
        isTaxable: boolean;
        isTaxedGeographically: string;
        latestDeliveryDate: string;
        latestDeliveryTime: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        orderDate: string;
        orderLineText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
        preferentialStockLocationFilter: Location;
        preparationCode: string;
        productSource: SourceOfShipment;
        productStockManagement: StockManagement;
        project: ProjectLink;
        quantityInSalesUnitAllocated: string;
        quantityInSalesUnitDelivered: string;
        quantityInSalesUnitInPreparation: string;
        quantityInSalesUnitInitiallyOrdered: string;
        quantityInSalesUnitInvoiced: string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice: string;
        quantityInSalesUnitOnPickList: string;
        quantityInSalesUnitOrdered: string;
        quantityInSalesUnitPrepared: string;
        quantityInSalesUnitShortage: string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock: string;
        quantityInStockUnitAllocated: string;
        quantityInStockUnitDelivered: string;
        quantityInStockUnitInPreparation: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice: string;
        quantityInStockUnitOnPickList: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitPrepared: string;
        quantityInStockUnitShortage: string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock: string;
        requestedDeliveryDate: string;
        requestedDeliveryReference: string;
        requestedDeliveryTime: string;
        routeNumber: RouteCode;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        shipmentDate: string;
        shipmentTime: string;
        taxRate: string;
        taxableAmount: string;
        tokenManagement: string;
        useByDate: string;
        volumeDistributedOnLine: string;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        weightDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workInProgressStatus: StatusInProgress;
        productStatisticalGroups: ClientCollection<SalesOrderLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<SalesOrderLineTaxesBinding>;
        prepaymentContract: PrepaymentInvoice;
    }
    export interface SalesOrderLineExtension$Lookups {
        prepaymentContract: QueryOperation<PrepaymentInvoice>;
    }
    export interface SalesOrderLineExtension$Operations {
        lookups(dataOrId: string | { data: SalesOrderLineInput }): SalesOrderLineExtension$Lookups;
    }
    export interface Package {}
    export interface GraphApi
        extends Package,
            SageX3Finance$Package,
            SageX3FinanceData$Package,
            SageX3InvoicingData$Package,
            SageX3ManufacturingData$Package,
            SageX3MasterData$Package,
            SageX3PhysicalFlowsData$Package,
            SageX3ProjectManagementData$Package,
            SageX3PurchasingData$Package,
            SageX3Sales$Package,
            SageX3SalesData$Package,
            SageX3Stock$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-sales-finance-api' {
    export type * from '@sage/x3-sales-finance-api-partial';
}
declare module '@sage/x3-finance-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-finance-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-physical-flows-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-sales-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-sales-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-sales-api-partial' {
    import type {
        SalesOrderLineBindingExtension,
        SalesOrderLineExtension,
        SalesOrderLineExtension$Lookups,
        SalesOrderLineExtension$Operations,
        SalesOrderLineInputExtension,
    } from '@sage/x3-sales-finance-api';
    export interface SalesOrderLine extends SalesOrderLineExtension {}
    export interface SalesOrderLineBinding extends SalesOrderLineBindingExtension {}
    export interface SalesOrderLineInput extends SalesOrderLineInputExtension {}
    export interface SalesOrderLine$Lookups extends SalesOrderLineExtension$Lookups {}
    export interface SalesOrderLine$Operations extends SalesOrderLineExtension$Operations {}
}
