"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesDeliveryType = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        legislation: {
            glossaryId() {
                return 909;
            },
            code: 'legislation',
        },
    },
};
let SalesDeliveryType = class SalesDeliveryType extends xtrem_core_1.Node {
};
exports.SalesDeliveryType = SalesDeliveryType;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'SDHTYP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesDeliveryType.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LEG',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 909,
            },
            control: {
                glossaryId: 909,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesDeliveryType.prototype, "legislation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SalesDeliveryType.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SalesDeliveryType.prototype, "localizedShortDescription", void 0);
exports.SalesDeliveryType = SalesDeliveryType = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'TABSDHTYP',
        keyPropertyNames: ['code', 'legislation'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                    legislation: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['legislation'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SalesDeliveryType);
//# sourceMappingURL=sales-delivery-type.js.map