"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductExtension = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PhysicalFlowsData = require("@sage/x3-physical-flows-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3SalesData = require("..");
const joins = {
    referenceJoins: {
        productSalesRef: {
            product: 'code',
        },
    },
};
const compositeReferences = {
    productSalesRef: {
        basePrice: 'basePrice',
        packaging: 'packaging',
        packagingCapacity: 'packagingCapacity',
        productPickingText: 'productPickingTextRef.text',
        productSalesText: 'productSalesTextRef.text',
        substitutionDate: 'substitutionDate',
        substitutionProduct: 'substitutionProduct',
    },
};
let ProductExtension = class ProductExtension extends xtrem_core_1.NodeExtension {
};
exports.ProductExtension = ProductExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3SalesData.nodes.ProductSales,
    })
], ProductExtension.prototype, "productSalesRef", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProductExtension.prototype, "basePrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCK',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.Packaging,
    })
], ProductExtension.prototype, "packaging", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCKCAP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProductExtension.prototype, "packagingCapacity", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], ProductExtension.prototype, "productPickingText", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], ProductExtension.prototype, "productSalesText", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SBSDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProductExtension.prototype, "substitutionDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SBSITM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], ProductExtension.prototype, "substitutionProduct", void 0);
exports.ProductExtension = ProductExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3MasterData.nodes.Product,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
            compositeReferences,
        }),
    })
], ProductExtension);
//# sourceMappingURL=product-extension.js.map