// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/index.d.ts
declare module '@sage/x3-purchasing/index' {
	export * from '@sage/x3-purchasing/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/index.d.ts
declare module '@sage/x3-purchasing/lib/index' {
	export * as enums from '@sage/x3-purchasing/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-purchasing/lib/node-extensions/index';
	export * as nodeFunctions from '@sage/x3-purchasing/lib/node-functions/index';
	export * as nodes from '@sage/x3-purchasing/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-purchasing/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/service-options/index.d.ts
declare module '@sage/x3-purchasing/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/transport.d.ts
declare module '@sage/x3-purchasing/lib/nodes/transport' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import { Node, Reference, date } from '@sage/xtrem-core';
	export class Transport extends Node {
	    readonly id: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly transportMode: Promise<sageX3PurchasingData.enums.TransportMode>;
	    readonly transportIdentification: Promise<string>;
	    readonly departurePlace: Reference<sageX3MasterData.nodes.TransitArea | null>;
	    readonly arrivalPlace: Reference<sageX3MasterData.nodes.TransitArea | null>;
	    readonly departureDate: Promise<date>;
	    readonly expectedArrivalDate: Promise<date>;
	    readonly arrivalDate: Promise<date | null>;
	}
	//# sourceMappingURL=transport.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-shipment.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-shipment' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, date, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseShipment extends Node {
	    readonly id: Promise<string>;
	    readonly shipmentId: Promise<string>;
	    readonly shipDate: Promise<date | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly countryOfOrigin: Reference<sageX3Structure.nodes.Country | null>;
	    readonly destinationCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly transportNumber: Reference<sageX3Purchasing.nodes.Transport | null>;
	    readonly shipmentRecordType: Promise<sageX3PurchasingData.enums.ShipmentRecordType>;
	    readonly expectedArrivalDate: Promise<date | null>;
	    readonly transitStart: Reference<sageX3MasterData.nodes.TransitArea | null>;
	    readonly transitArrival: Reference<sageX3MasterData.nodes.TransitArea | null>;
	    readonly departureDate: Promise<date | null>;
	    readonly arrivalDate: Promise<date | null>;
	    readonly transportMode: Promise<sageX3PurchasingData.enums.TransportMode | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly company: Reference<sageX3System.nodes.Company | null>;
	    readonly dateShift: Promise<integer | null>;
	    readonly shipmentManagement: Promise<sageX3PurchasingData.enums.ShipmentManagement | null>;
	    readonly container: Reference<sageX3MasterData.nodes.Container | null>;
	    readonly quantityOfContainers: Promise<integer | null>;
	    readonly maximumWeight: Promise<decimal | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly maximumVolume: Promise<decimal | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly shipmentTotalWeight: Promise<decimal | null>;
	    readonly shipmentTotalVolume: Promise<decimal | null>;
	    readonly availableWeight: Promise<decimal | null>;
	    readonly availableVolume: Promise<decimal | null>;
	    readonly shipmentStatus: Promise<sageX3PurchasingData.enums.ShipmentStatus | null>;
	    readonly isShipped: Promise<boolean>;
	}
	//# sourceMappingURL=purchase-shipment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-shipment-line.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-shipment-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseShipmentLine extends Node {
	    readonly purchaseShipment: Reference<sageX3Purchasing.nodes.PurchaseShipment>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly purchaseOrderNumber: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly purchaseOrderLineNumber: Promise<integer | null>;
	    readonly purchaseOrderSequenceNumber: Reference<sageX3Purchasing.nodes.PurchaseOrderLine | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly quantityInOrderUnitShipped: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitShipped: Promise<decimal | null>;
	    readonly quantityInStockUnitShipped: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitReceived: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitPreReceived: Promise<decimal | null>;
	    readonly orderUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly orderUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
	    readonly isClosed: Promise<boolean>;
	    readonly isPreReceived: Promise<boolean>;
	    readonly quantityInPurchaseUnitExpected: Promise<decimal | null>;
	}
	//# sourceMappingURL=purchase-shipment-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-return.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-return' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, TextStream } from '@sage/xtrem-core';
	export class PurchaseReturn extends Node {
	    readonly id: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly returnSite: Reference<sageX3System.nodes.Site>;
	    readonly returnDate: Promise<date | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly returnHeaderTextKey: Promise<string>;
	    readonly returnFooterTextKey: Promise<string>;
	    readonly returnHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly returnFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly returnFooterText: Promise<TextStream>;
	    readonly returnHeaderText: Promise<TextStream>;
	}
	//# sourceMappingURL=purchase-return.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-return-line.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-return-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, TextStream, Collection } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReturnLine extends Node {
	    readonly purchaseReturn: Reference<sageX3Purchasing.nodes.PurchaseReturn | null>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly returnSite: Reference<sageX3System.nodes.Site>;
	    readonly returnDate: Promise<date | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly returnLineTextKey: Promise<string>;
	    readonly returnLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly returnLineText: Promise<TextStream>;
	    readonly taxes: Collection<sageX3Purchasing.nodes.PurchaseReturnLineTaxes>;
	}
	//# sourceMappingURL=purchase-return-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-return-line-taxes.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-return-line-taxes' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReturnLineTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly purchaseReturn: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseReturnLine>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-return-line-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, decimal, integer, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceipt extends Node {
	    readonly id: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly receiptSite: Reference<sageX3System.nodes.Site>;
	    readonly supplierPackingSlip: Promise<string>;
	    readonly supplierPackingSlipDate: Promise<date | null>;
	    readonly receiptDate: Promise<date | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly address: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly shipFromAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly shipFromZipCode: Promise<string>;
	    readonly shipFromCity: Promise<string>;
	    readonly shipFromState: Promise<string>;
	    readonly shipFromCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly shipFromCountryName: Promise<string>;
	    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly rate: Promise<decimal | null>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
	    readonly taxRuleType: Promise<integer | null>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
	    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
	    readonly intrastatStatiscalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
	    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly incotermTown: Promise<string>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly europeanUnionIdentification: Promise<string>;
	    readonly intrastatProcessingNumber: Promise<integer | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly groupingCode: Promise<string>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly grossWeight: Promise<decimal | null>;
	    readonly netWeight: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly numberOfLinesFullyInvoiced: Promise<integer | null>;
	    readonly numberOfInvoicedLines: Promise<integer | null>;
	    readonly numberOfPostedLines: Promise<integer | null>;
	    readonly isPrinted: Promise<boolean>;
	    readonly invoicedStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
	    readonly isPosted: Promise<boolean>;
	    readonly reversalDate: Promise<date | null>;
	    readonly isIntersite: Promise<boolean>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly receiptHeaderTextKey: Promise<string>;
	    readonly receiptFooterTextKey: Promise<string>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly amountOfLinesExcludingTax: Promise<decimal | null>;
	    readonly totalQuantityOfLines: Promise<decimal | null>;
	    readonly totalWeightOfLines: Promise<decimal | null>;
	    readonly totalVolumeOfLines: Promise<decimal | null>;
	    readonly totalAmountExcludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalTaxAmount: Promise<decimal | null>;
	    readonly totalAmountIncludingTax: Promise<decimal | null>;
	    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly vehicleLicensePlate: Promise<string>;
	    readonly trailerLicensePlate: Promise<string>;
	    readonly departureDate: Promise<date | null>;
	    readonly arrivalDate: Promise<date | null>;
	    readonly departureTime: Promise<string>;
	    readonly arrivalTime: Promise<string>;
	    readonly lines: Collection<sageX3Purchasing.nodes.PurchaseReceiptLine>;
	    readonly receiptHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly receiptFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly receiptFooterText: Promise<TextStream>;
	    readonly receiptHeaderText: Promise<TextStream>;
	    readonly destination: Promise<string>;
	    readonly document: Promise<string>;
	    readonly transaction: Promise<string>;
	    readonly addressLines: Collection<sageX3Purchasing.nodes.PurchaseReceiptAddressLines>;
	    readonly companyNames: Collection<sageX3Purchasing.nodes.PurchaseReceiptCompanyNames>;
	    readonly dimensions: Collection<sageX3Purchasing.nodes.PurchaseReceiptDimensions>;
	    readonly headerInvoiceLineAllocationElements: Collection<sageX3Purchasing.nodes.PurchaseReceiptHeaderInvoiceLineAllocationElements>;
	    readonly headerInvoiceLineElements: Collection<sageX3Purchasing.nodes.PurchaseReceiptHeaderInvoiceLineElements>;
	    readonly statisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseReceiptStatisticalGroups>;
	}
	//# sourceMappingURL=purchase-receipt.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt-statistical-groups.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceiptStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseReceipt>;
	    readonly statisticalGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=purchase-receipt-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt-line.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt-line' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceiptLine extends Node {
	    readonly purchaseReceipt: Reference<sageX3Purchasing.nodes.PurchaseReceipt>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly receiptSite: Reference<sageX3System.nodes.Site>;
	    readonly receiptDate: Promise<date | null>;
	    readonly purchaseSite: Reference<sageX3System.nodes.Site>;
	    readonly purchaseOrder: Reference<sageX3Purchasing.nodes.PurchaseOrder | null>;
	    readonly purchaseOrderLineNumber: Promise<integer | null>;
	    readonly purchaseOrderLine: Reference<sageX3Purchasing.nodes.PurchaseOrderLine | null>;
	    readonly orderType: Promise<sageX3Purchasing.enums.PurchaseOrderType | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescriptionInUserLanguage: Promise<string>;
	    readonly productDescriptionInSupplierLanguage: Promise<string>;
	    readonly grossPrice: Promise<decimal | null>;
	    readonly priceReason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountCharge1: Promise<decimal | null>;
	    readonly discountCharge2: Promise<decimal | null>;
	    readonly discountCharge3: Promise<decimal | null>;
	    readonly discountCharge4: Promise<decimal | null>;
	    readonly discountCharge5: Promise<decimal | null>;
	    readonly discountCharge6: Promise<decimal | null>;
	    readonly discountCharge7: Promise<decimal | null>;
	    readonly discountCharge8: Promise<decimal | null>;
	    readonly discountCharge9: Promise<decimal | null>;
	    readonly discountCharge1Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountCharge2Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountCharge3Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountCharge4Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountCharge5Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountCharge6Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountCharge7Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountCharge8Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountCharge9Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly netPrice: Promise<decimal | null>;
	    readonly netPriceInPurchaseUnit: Promise<decimal | null>;
	    readonly lineAmountExcludingTax: Promise<decimal | null>;
	    readonly lineCostPriceInCompanyCurrency: Promise<decimal | null>;
	    readonly linePurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly lineAmountIncludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement1AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement2AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement3AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement4AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement5AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement6AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement7AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement8AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement9AmountExcludingTax: Promise<decimal | null>;
	    readonly calculatedTaxableBase1: Promise<decimal | null>;
	    readonly calculatedTaxableBase2: Promise<decimal | null>;
	    readonly calculatedTaxableBase3: Promise<decimal | null>;
	    readonly calculatedTaxableBase4: Promise<decimal | null>;
	    readonly calculatedTaxableBase5: Promise<decimal | null>;
	    readonly calculatedTaxableBase6: Promise<decimal | null>;
	    readonly calculatedTaxableBase7: Promise<decimal | null>;
	    readonly rebateOnTax1Amount: Promise<decimal | null>;
	    readonly taxableBase1Amount: Promise<decimal | null>;
	    readonly tax1Amount: Promise<decimal | null>;
	    readonly tax2Amount: Promise<decimal | null>;
	    readonly tax3Amount: Promise<decimal | null>;
	    readonly receiptTaxAmount: Promise<decimal | null>;
	    readonly issueTaxAmount: Promise<decimal | null>;
	    readonly otherTax1Amount: Promise<decimal | null>;
	    readonly otherTax2Amount: Promise<decimal | null>;
	    readonly tax1DeductibleAmount: Promise<decimal | null>;
	    readonly tax2DeductibleAmount: Promise<decimal | null>;
	    readonly tax3DeductibleAmount: Promise<decimal | null>;
	    readonly receiptTaxDeductibleAmount: Promise<decimal | null>;
	    readonly issueTaxDeductibleAmount: Promise<decimal | null>;
	    readonly otherTax1DeductibleAmount: Promise<decimal | null>;
	    readonly otherTax2DeductibleAmount: Promise<decimal | null>;
	    readonly netPriceIncludingInvoicingElementInCompanyCurrency: Promise<decimal | null>;
	    readonly costPriceInCompanyCurrency: Promise<decimal | null>;
	    readonly theoreticalStockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly purchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly landedCostCoefficient: Promise<decimal | null>;
	    readonly fixedLandedCostPerUnitInCompanyCurrency: Promise<decimal | null>;
	    readonly costStructure: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly companyCurrency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly totalPurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly totalStockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly totalPostedStockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly quantityInReceiptUnitReceived: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitReceived: Promise<decimal | null>;
	    readonly quantityInStockUnitReceived: Promise<decimal | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly receiptUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly receiptUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
	    readonly receiptUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitRejected: Promise<decimal | null>;
	    readonly quantityInStockUnitRejected: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitReturned: Promise<decimal | null>;
	    readonly quantityInStockUnitReturned: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitInvoiced: Promise<decimal | null>;
	    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
	    readonly isPrinted: Promise<boolean>;
	    readonly isInvoiced: Promise<boolean>;
	    readonly isExtractedIntrastatLine: Promise<boolean>;
	    readonly isPosted: Promise<boolean>;
	    readonly reversalDate: Promise<date | null>;
	    readonly qualityControlManagementMode: Promise<sageX3MasterData.enums.SubjectToControl | null>;
	    readonly isControlledByQuality: Promise<boolean>;
	    readonly purchaseType: Promise<sageX3InvoicingData.enums.PurchaseType | null>;
	    readonly intrastatIncreaseCoefficient: Promise<decimal | null>;
	    readonly countryOfOrigin: Reference<sageX3Structure.nodes.Country | null>;
	    readonly shipFromCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly issueState: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly receiptTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly issueTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly otherTax1: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly otherTax2: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly receiptLineTextKey: Promise<string>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly releasedProduct: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly sourceDocument: Promise<string>;
	    readonly sourceDocumentLineNumber: Promise<integer | null>;
	    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
	    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
	    readonly billableIntercompanyStatus: Promise<integer | null>;
	    readonly lineType: Promise<sageX3PurchasingData.enums.OrderLineType | null>;
	    readonly movementCategory: Promise<sageX3PurchasingData.enums.MovementCategory | null>;
	    readonly linkCoefficientForSubcontract: Promise<decimal | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly matchingTolerance: Reference<sageX3PurchasingData.nodes.MatchingTolerance | null>;
	    readonly postedSubcontractCost: Promise<decimal | null>;
	    readonly purchaseShipment: Reference<sageX3Purchasing.nodes.PurchaseShipment | null>;
	    readonly purchaseShipmentLine: Reference<sageX3Purchasing.nodes.PurchaseShipmentLine | null>;
	    readonly productType: Promise<sageX3Purchasing.enums.PurchasingProductType | null>;
	    readonly stockDetails: Collection<sageX3StockData.nodes.StockJournal>;
	    readonly receiptLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly receiptLineText: Promise<TextStream>;
	    readonly balance: Promise<string>;
	    readonly container: Promise<string>;
	    readonly productStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseReceiptLineProductStatisticalGroups>;
	    readonly taxes: Collection<sageX3Purchasing.nodes.PurchaseReceiptLineTaxes>;
	}
	//# sourceMappingURL=purchase-receipt-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt-line-taxes.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt-line-taxes' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceiptLineTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly purchaseReceipt: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseReceiptLine>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-receipt-line-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt-line-product-statistical-groups.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt-line-product-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceiptLineProductStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly purchaseReceipt: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseReceiptLine>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=purchase-receipt-line-product-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt-header-invoice-line-elements.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt-header-invoice-line-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceiptHeaderInvoiceLineElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseReceipt>;
	    readonly invoiceLineElement: Reference<sageX3InvoicingData.nodes.PurchaseInvoicingElement | null>;
	    readonly priceLineTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-receipt-header-invoice-line-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt-header-invoice-line-allocation-elements.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt-header-invoice-line-allocation-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceiptHeaderInvoiceLineAllocationElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseReceipt>;
	    readonly invoiceLineAllocationElement: Reference<sageX3InvoicingData.nodes.PurchaseInvoicingElement | null>;
	    readonly distributionLineTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-receipt-header-invoice-line-allocation-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt-dimensions.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceiptDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseReceipt>;
	    readonly dimensionTypeCode: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=purchase-receipt-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt-company-names.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceiptCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseReceipt>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=purchase-receipt-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-receipt-address-lines.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-receipt-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseReceiptAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseReceipt>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=purchase-receipt-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrder extends Node {
	    readonly id: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly purchaseSite: Reference<sageX3System.nodes.Site>;
	    readonly orderType: Promise<sageX3Purchasing.enums.PurchaseOrderType | null>;
	    readonly revisionNumber: Promise<integer | null>;
	    readonly orderDate: Promise<date | null>;
	    readonly internalOrderReference: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly orderFromSupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly orderFromSupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly orderFromSupplierAddressZipCode: Promise<string>;
	    readonly orderFromSupplierAddressCity: Promise<string>;
	    readonly orderFromSupplierAddressState: Promise<string>;
	    readonly orderFromSupplierAddressCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly orderFromSupplierAddressCountryName: Promise<string>;
	    readonly shipFromSupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly shipFromSupplierAddressZipCode: Promise<string>;
	    readonly shipFromSupplierAddressCity: Promise<string>;
	    readonly shipFromSupplierAddressState: Promise<string>;
	    readonly shipFromSupplierAddressCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly shipFromSupplierAddressCountryName: Promise<string>;
	    readonly invoiceSite: Reference<sageX3System.nodes.Site | null>;
	    readonly receiptSite: Reference<sageX3System.nodes.Site | null>;
	    readonly expectedReceiptDate: Promise<date | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly incotermTown: Promise<string>;
	    readonly groupingCode: Promise<string>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly europeanUnionIdentification: Promise<string>;
	    readonly buyer: Reference<sageX3System.nodes.User | null>;
	    readonly orderFromSupplierLanguage: Reference<sageX3System.nodes.Language>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly currencyRateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly currencyRate: Promise<decimal | null>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
	    readonly taxRuleType: Promise<integer | null>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly numberOfBudgetOverrunLines: Promise<integer | null>;
	    readonly numberOfReceivedLines: Promise<integer | null>;
	    readonly numberOfClosedLines: Promise<integer | null>;
	    readonly numberOfInvoicedLines: Promise<integer | null>;
	    readonly numberOfReceipts: Promise<integer | null>;
	    readonly numberOfInvoices: Promise<integer | null>;
	    readonly signatureStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
	    readonly isClosed: Promise<boolean>;
	    readonly receiptStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
	    readonly invoicedStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
	    readonly isPrinted: Promise<boolean>;
	    readonly numberOfCopies: Promise<integer | null>;
	    readonly orderHeaderTextKey: Promise<string>;
	    readonly orderFooterTextKey: Promise<string>;
	    readonly acknowledgmentDate: Promise<date | null>;
	    readonly acknowledgmentNumber: Promise<string>;
	    readonly acknowledgmentNote: Promise<string>;
	    readonly isPrintedAcknowledgmentReminder: Promise<boolean>;
	    readonly mustSendDeliveryReminder: Promise<boolean>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly isIntersite: Promise<boolean>;
	    readonly purchaseSiteForIntersite: Reference<sageX3System.nodes.Site | null>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly salesSite: Reference<sageX3System.nodes.Site | null>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly amountOfLinesIncludingTax: Promise<decimal | null>;
	    readonly amountOfLinesExcludingTax: Promise<decimal | null>;
	    readonly totalQuantityOfLines: Promise<decimal | null>;
	    readonly totalWeightOfLines: Promise<decimal | null>;
	    readonly totalVolumeOfLines: Promise<decimal | null>;
	    readonly totalTaxAmount: Promise<decimal | null>;
	    readonly totalAmountExcludingTax: Promise<decimal | null>;
	    readonly totalAmountIncludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly expectedTotalAmountExcludingTax: Promise<decimal | null>;
	    readonly serviceStartDate: Promise<date | null>;
	    readonly serviceEndDate: Promise<date | null>;
	    readonly container: Reference<sageX3MasterData.nodes.Container | null>;
	    readonly numberOfContainers: Promise<integer | null>;
	    readonly maximumAmountExcludingTax: Promise<decimal | null>;
	    readonly availableWeightOfContainer: Promise<decimal | null>;
	    readonly availableVolumeOfContainer: Promise<decimal | null>;
	    readonly purchaseOrderLines: Collection<sageX3Purchasing.nodes.PurchaseOrderLine>;
	    readonly orderHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly orderFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly orderFooterText: Promise<TextStream>;
	    readonly orderHeaderText: Promise<TextStream>;
	    readonly companyNames: Collection<sageX3Purchasing.nodes.PurchaseOrderCompanyNames>;
	    readonly dimensions: Collection<sageX3Purchasing.nodes.PurchaseOrderDimensions>;
	    readonly discountOrChargeCalculationRules: Collection<sageX3Purchasing.nodes.PurchaseOrderDiscountOrChargeCalculationRules>;
	    readonly fromSupplierAddressLines: Collection<sageX3Purchasing.nodes.PurchaseOrderFromSupplierAddressLines>;
	    readonly fromSupplierCompanyNames: Collection<sageX3Purchasing.nodes.PurchaseOrderFromSupplierCompanyNames>;
	    readonly headerInvoiceLineAllocationElements: Collection<sageX3Purchasing.nodes.PurchaseOrderHeaderInvoiceLineAllocationElements>;
	    readonly shipFromSupplierAddressLines: Collection<sageX3Purchasing.nodes.PurchaseOrderShipFromSupplierAddressLines>;
	    readonly supplierStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseOrderSupplierStatisticalGroups>;
	}
	//# sourceMappingURL=purchase-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-supplier-statistical-groups.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-supplier-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderSupplierStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=purchase-order-supplier-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-ship-from-supplier-address-lines.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-ship-from-supplier-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderShipFromSupplierAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=purchase-order-ship-from-supplier-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-quantity-lines-supplier-view.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-quantity-lines-supplier-view' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import { Node, integer, decimal } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderQuantityLinesSupplierView extends Node {
	    readonly receiptSite: Promise<string>;
	    readonly supplier: Promise<string>;
	    readonly product: Promise<string>;
	    readonly purchaseOrder: Promise<string>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly sequenceNumber: Promise<integer | null>;
	    readonly isClosed: Promise<boolean>;
	    readonly sourceRequest: Promise<sageX3PurchasingData.enums.RequestSource | null>;
	    readonly lineType: Promise<sageX3PurchasingData.enums.OrderLineType | null>;
	    readonly purchaseUnitToStockUnitConversionFactor: Promise<integer | null>;
	    readonly workInProgressStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
	    readonly productType: Promise<sageX3Purchasing.enums.PurchasingProductType | null>;
	    readonly description1: Promise<string>;
	    readonly quantityInPurchaseUnitOrdered: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitReceived: Promise<decimal | null>;
	    readonly purchaseUnit: Promise<string>;
	    readonly upc: Promise<string>;
	    readonly globalTradeItemNumber: Promise<string>;
	    readonly productStatus: Promise<sageX3MasterData.enums.ProductStatus | null>;
	    readonly isReceived: Promise<boolean>;
	    readonly isManufactured: Promise<boolean>;
	    readonly isPhantom: Promise<boolean>;
	    readonly isIntersite: Promise<boolean>;
	    readonly supplierProduct: Promise<string>;
	    readonly supplierProductDescription: Promise<string>;
	    readonly supplierUpc: Promise<string>;
	}
	//# sourceMappingURL=purchase-order-quantity-lines-supplier-view.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-quantity-line.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-quantity-line' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderQuantityLine extends Node {
	    readonly purchaseOrder: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly sequenceNumber: Reference<sageX3Purchasing.nodes.PurchaseOrderLine | null>;
	    readonly lineAndSequenceIndex: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly purchaseSite: Reference<sageX3System.nodes.Site>;
	    readonly orderType: Promise<sageX3Purchasing.enums.PurchaseOrderType | null>;
	    readonly orderDate: Promise<date | null>;
	    readonly orderFromSupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly lineRevisionNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly supplierProduct: Reference<sageX3MasterData.nodes.SupplierProduct | null>;
	    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly orderUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly isInOrderUnit: Promise<boolean>;
	    readonly orderUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
	    readonly linkCoefficientForSubcontract: Promise<decimal | null>;
	    readonly quantityInOrderUnitOrdered: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitOrdered: Promise<decimal | null>;
	    readonly quantityInStockUnitOrdered: Promise<decimal | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPurchaseUnitRequired: Promise<decimal | null>;
	    readonly quantityInStockUnitRequired: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitReceived: Promise<decimal | null>;
	    readonly quantityInStockUnitReceived: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitInvoiced: Promise<decimal | null>;
	    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
	    readonly requirementDate: Promise<date | null>;
	    readonly expectedReceiptDate: Promise<date | null>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly receiptSite: Reference<sageX3System.nodes.Site>;
	    readonly receiptAddress: Reference<sageX3MasterData.nodes.SiteAddress | null>;
	    readonly reorderLeadTime: Promise<decimal | null>;
	    readonly locationReference: Promise<string>;
	    readonly subcontractAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly workOrderInProgressType: Promise<sageX3ManufacturingData.enums.WorkOrderType | null>;
	    readonly workOrderInProgressStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
	    readonly workInProgressOrderNumber: Promise<string>;
	    readonly purchaseType: Promise<sageX3InvoicingData.enums.PurchaseType | null>;
	    readonly lastReceiptDate: Promise<date | null>;
	    readonly lastSalesInvoiceDate: Promise<date | null>;
	    readonly numberOfInvoicedReceipts: Promise<integer | null>;
	    readonly numberOfReceipts: Promise<integer | null>;
	    readonly numberOfInvoices: Promise<integer | null>;
	    readonly orderLineTextKey: Promise<string>;
	    readonly isClosedByReceipt: Promise<boolean>;
	    readonly isClosed: Promise<boolean>;
	    readonly isInvoiced: Promise<boolean>;
	    readonly isPrinted: Promise<boolean>;
	    readonly commitmentType: Promise<sageX3PurchasingData.enums.CommitmentType | null>;
	    readonly commitmentGenerated: Promise<integer | null>;
	    readonly isBudgetOverrun: Promise<boolean>;
	    readonly sourceRequest: Promise<sageX3PurchasingData.enums.RequestSource | null>;
	    readonly acknowledgementDate: Promise<date | null>;
	    readonly acknowledgementNumber: Promise<string>;
	    readonly acknowledgementUpdate: Promise<integer | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly landedCostCoefficient: Promise<decimal | null>;
	    readonly fixedLandedCostPerUnitInCompanyCurrency: Promise<decimal | null>;
	    readonly costStructure: Reference<sageX3PurchasingData.nodes.FreightCostStructure | null>;
	    readonly purchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly stockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly companyCurrency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly costPriceWithoutLandedCost: Promise<decimal | null>;
	    readonly totalPurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly totalStockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly taxExcludedLineAmount: Promise<decimal | null>;
	    readonly lineStockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly linePurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly actualPurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly lineOrderAmountIncludingTax: Promise<decimal | null>;
	    readonly lineAmountIncludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement1AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement2AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement3AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement4AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement5AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement6AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement7AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement8AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement9AmountExcludingTax: Promise<decimal | null>;
	    readonly calculatedTaxBasis1: Promise<decimal | null>;
	    readonly calculatedTaxBasis2: Promise<decimal | null>;
	    readonly calculatedBasisForTax3: Promise<decimal | null>;
	    readonly calculationBasisForReceiptTax: Promise<decimal | null>;
	    readonly calculationBasisForIssueTax: Promise<decimal | null>;
	    readonly calculationBasisForOtherTax1: Promise<decimal | null>;
	    readonly calculationBasisForOtherTax2: Promise<decimal | null>;
	    readonly rebateOnTax1Amount: Promise<decimal | null>;
	    readonly tax1BasisAmount: Promise<decimal | null>;
	    readonly tax1amount: Promise<decimal | null>;
	    readonly tax2amount: Promise<decimal | null>;
	    readonly tax3amount: Promise<decimal | null>;
	    readonly receiptTaxAmount: Promise<decimal | null>;
	    readonly issueTaxAmount: Promise<decimal | null>;
	    readonly otherTax1Amount: Promise<decimal | null>;
	    readonly otherTax2Amount: Promise<decimal | null>;
	    readonly tax1DeductibleAmount: Promise<decimal | null>;
	    readonly tax2DeductibleAmount: Promise<decimal | null>;
	    readonly tax3DeductibleAmount: Promise<decimal | null>;
	    readonly receiptTaxDeductibleAmount: Promise<decimal | null>;
	    readonly issueTaxDeductibleAmount: Promise<decimal | null>;
	    readonly otherTax1DeductibleAmount: Promise<decimal | null>;
	    readonly otherTax2DeductibleAmount: Promise<decimal | null>;
	    readonly requestForQuotation: Promise<string>;
	    readonly requestForQuotationResponseLineNumber: Promise<integer | null>;
	    readonly requestedDeliverySequencing: Promise<sageX3MasterData.enums.Timing | null>;
	    readonly requestedDeliveryYear: Promise<integer | null>;
	    readonly requestedDeliveryMonth: Promise<integer | null>;
	    readonly requestedDeliveryWeek: Promise<integer | null>;
	    readonly lineStatus: Promise<sageX3MasterData.enums.LineStatus | null>;
	    readonly lineType: Promise<sageX3PurchasingData.enums.OrderLineType | null>;
	    readonly requestedDeliveryStartDate: Promise<date | null>;
	    readonly requestedDeliveryStartTime: Promise<integer | null>;
	    readonly requestedDeliveryEndDate: Promise<date | null>;
	    readonly requestedDeliveryEndTime: Promise<integer | null>;
	    readonly releasedProduct: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly sourceDocumentNumber: Promise<string>;
	    readonly sourceDocumentLineNumber: Promise<integer | null>;
	    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
	    readonly purchaseReceipt: Reference<sageX3Purchasing.nodes.PurchaseReceipt | null>;
	    readonly purchaseReceiptLine: Reference<sageX3Purchasing.nodes.PurchaseReceiptLine | null>;
	    readonly interCompanySalesOrderLineNumber: Promise<integer | null>;
	    readonly interCompanySalesOrderSequenceNumber: Promise<integer | null>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Promise<string>;
	    readonly quantityInStockUnitShippedNotReceived: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitShippedNotReceived: Promise<decimal | null>;
	    readonly productType: Promise<sageX3Purchasing.enums.PurchasingProductType | null>;
	}
	//# sourceMappingURL=purchase-order-quantity-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-line.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-line' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, date, TextStream, Collection } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderLine extends Node {
	    readonly purchaseOrder: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly sequenceNumber: Promise<integer | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly orderType: Promise<sageX3Purchasing.enums.PurchaseOrderType | null>;
	    readonly revisionNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescriptionInUserLanguage: Promise<string>;
	    readonly productDescriptionInSupplierLanguage: Promise<string>;
	    readonly grossPrice: Promise<decimal | null>;
	    readonly priceReason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge1: Promise<decimal | null>;
	    readonly discountOrCharge2: Promise<decimal | null>;
	    readonly discountOrCharge3: Promise<decimal | null>;
	    readonly discountOrCharge4: Promise<decimal | null>;
	    readonly discountOrCharge5: Promise<decimal | null>;
	    readonly discountOrCharge6: Promise<decimal | null>;
	    readonly discountOrCharge7: Promise<decimal | null>;
	    readonly discountOrCharge8: Promise<decimal | null>;
	    readonly discountOrCharge9: Promise<decimal | null>;
	    readonly discountOrCharge1Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge2Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge3Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge4Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge5Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge6Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge7Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge8Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge9Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly netPrice: Promise<decimal | null>;
	    readonly buyer: Reference<sageX3System.nodes.User | null>;
	    readonly receiptSite: Reference<sageX3System.nodes.Site>;
	    readonly receiptAddress: Reference<sageX3MasterData.nodes.SiteAddress | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly intrastatIncreaseCoefficient: Promise<decimal | null>;
	    readonly countryOfOrigin: Reference<sageX3Structure.nodes.Country | null>;
	    readonly hasQualityControlManagement: Promise<boolean>;
	    readonly receiptTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly issueTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly otherTax1: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly otherTax2: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly matchingTolerance: Reference<sageX3PurchasingData.nodes.MatchingTolerance | null>;
	    readonly purchaseOrderQuantityLine: Reference<sageX3Purchasing.nodes.PurchaseOrderQuantityLine>;
	    readonly orderLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly acknowledgementDate: Promise<date | null>;
	    readonly acknowledgementNumber: Promise<string>;
	    readonly acknowledgementUpdate: Promise<integer | null>;
	    readonly actualPurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly calculatedBasisForTax3: Promise<decimal | null>;
	    readonly calculatedTaxBasis1: Promise<decimal | null>;
	    readonly calculatedTaxBasis2: Promise<decimal | null>;
	    readonly calculationBasisForIssueTax: Promise<decimal | null>;
	    readonly calculationBasisForOtherTax1: Promise<decimal | null>;
	    readonly calculationBasisForOtherTax2: Promise<decimal | null>;
	    readonly calculationBasisForReceiptTax: Promise<decimal | null>;
	    readonly commitmentGenerated: Promise<integer | null>;
	    readonly commitmentType: Promise<sageX3PurchasingData.enums.CommitmentType | null>;
	    readonly companyCurrency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly costPriceWithoutLandedCost: Promise<decimal | null>;
	    readonly costStructure: Reference<sageX3PurchasingData.nodes.FreightCostStructure | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly distributedInvoicingElement1AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement2AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement3AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement4AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement5AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement6AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement7AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement8AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement9AmountExcludingTax: Promise<decimal | null>;
	    readonly expectedReceiptDate: Promise<date | null>;
	    readonly fixedLandedCostPerUnitInCompanyCurrency: Promise<decimal | null>;
	    readonly interCompanySalesOrderLineNumber: Promise<integer | null>;
	    readonly interCompanySalesOrderSequenceNumber: Promise<integer | null>;
	    readonly isBudgetOverrun: Promise<boolean>;
	    readonly isClosed: Promise<boolean>;
	    readonly isClosedByReceipt: Promise<boolean>;
	    readonly isInOrderUnit: Promise<boolean>;
	    readonly isInvoiced: Promise<boolean>;
	    readonly isPrinted: Promise<boolean>;
	    readonly issueTaxAmount: Promise<decimal | null>;
	    readonly issueTaxDeductibleAmount: Promise<decimal | null>;
	    readonly landedCostCoefficient: Promise<decimal | null>;
	    readonly lastReceiptDate: Promise<date | null>;
	    readonly lastSalesInvoiceDate: Promise<date | null>;
	    readonly lineAmountIncludingTax: Promise<decimal | null>;
	    readonly lineAndSequenceIndex: Promise<string>;
	    readonly lineOrderAmountIncludingTax: Promise<decimal | null>;
	    readonly linePurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly lineStatus: Promise<sageX3MasterData.enums.LineStatus | null>;
	    readonly lineStockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly lineType: Promise<sageX3PurchasingData.enums.OrderLineType | null>;
	    readonly linkCoefficientForSubcontract: Promise<decimal | null>;
	    readonly locationReference: Promise<string>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Promise<string>;
	    readonly numberOfInvoicedReceipts: Promise<integer | null>;
	    readonly numberOfInvoices: Promise<integer | null>;
	    readonly numberOfReceipts: Promise<integer | null>;
	    readonly orderDate: Promise<date | null>;
	    readonly orderFromSupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly orderLineText: Promise<TextStream>;
	    readonly orderLineTextKey: Promise<string>;
	    readonly orderUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly orderUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
	    readonly otherTax1Amount: Promise<decimal | null>;
	    readonly otherTax1DeductibleAmount: Promise<decimal | null>;
	    readonly otherTax2Amount: Promise<decimal | null>;
	    readonly otherTax2DeductibleAmount: Promise<decimal | null>;
	    readonly productType: Promise<sageX3Purchasing.enums.PurchasingProductType | null>;
	    readonly purchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly purchaseReceipt: Reference<sageX3Purchasing.nodes.PurchaseReceipt | null>;
	    readonly purchaseReceiptLine: Reference<sageX3Purchasing.nodes.PurchaseReceiptLine | null>;
	    readonly purchaseSite: Reference<sageX3System.nodes.Site>;
	    readonly purchaseType: Promise<sageX3InvoicingData.enums.PurchaseType | null>;
	    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly quantityInOrderUnitOrdered: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitInvoiced: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitOrdered: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitReceived: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitRequired: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitShippedNotReceived: Promise<decimal | null>;
	    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
	    readonly quantityInStockUnitOrdered: Promise<decimal | null>;
	    readonly quantityInStockUnitReceived: Promise<decimal | null>;
	    readonly quantityInStockUnitRequired: Promise<decimal | null>;
	    readonly quantityInStockUnitShippedNotReceived: Promise<decimal | null>;
	    readonly rebateOnTax1Amount: Promise<decimal | null>;
	    readonly receiptTaxAmount: Promise<decimal | null>;
	    readonly receiptTaxDeductibleAmount: Promise<decimal | null>;
	    readonly releasedProduct: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly reorderLeadTime: Promise<decimal | null>;
	    readonly requestForQuotation: Promise<string>;
	    readonly requestForQuotationResponseLineNumber: Promise<integer | null>;
	    readonly requestedDeliveryEndDate: Promise<date | null>;
	    readonly requestedDeliveryEndTime: Promise<integer | null>;
	    readonly requestedDeliveryStartDate: Promise<date | null>;
	    readonly requestedDeliveryStartTime: Promise<integer | null>;
	    readonly requirementDate: Promise<date | null>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly sourceDocumentLineNumber: Promise<integer | null>;
	    readonly sourceDocumentNumber: Promise<string>;
	    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
	    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly sourceRequest: Promise<sageX3PurchasingData.enums.RequestSource | null>;
	    readonly stockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly subcontractAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly supplierProduct: Reference<sageX3MasterData.nodes.SupplierProduct | null>;
	    readonly tax1BasisAmount: Promise<decimal | null>;
	    readonly tax1DeductibleAmount: Promise<decimal | null>;
	    readonly tax1amount: Promise<decimal | null>;
	    readonly tax2DeductibleAmount: Promise<decimal | null>;
	    readonly tax2amount: Promise<decimal | null>;
	    readonly tax3DeductibleAmount: Promise<decimal | null>;
	    readonly tax3amount: Promise<decimal | null>;
	    readonly taxExcludedLineAmount: Promise<decimal | null>;
	    readonly totalPurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly totalStockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly workInProgressOrderNumber: Promise<string>;
	    readonly workOrderInProgressStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
	    readonly workOrderInProgressType: Promise<sageX3ManufacturingData.enums.WorkOrderType | null>;
	    readonly productStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseOrderLineProductStatisticalGroups>;
	    readonly taxes: Collection<sageX3Purchasing.nodes.PurchaseOrderLineTaxes>;
	}
	//# sourceMappingURL=purchase-order-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-line-taxes.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-line-taxes' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderLineTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly purchaseOrder: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly sequenceNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrderLine>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-order-line-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-line-product-statistical-groups.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-line-product-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderLineProductStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly purchaseOrder: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly sequenceNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrderLine>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=purchase-order-line-product-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-header-invoice-line-allocation-elements.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-header-invoice-line-allocation-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderHeaderInvoiceLineAllocationElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly invoiceLineAllocationElement: Reference<sageX3InvoicingData.nodes.PurchaseInvoicingElement | null>;
	    readonly distributionLineTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-order-header-invoice-line-allocation-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-from-supplier-company-names.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-from-supplier-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderFromSupplierCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=purchase-order-from-supplier-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-from-supplier-address-lines.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-from-supplier-address-lines' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderFromSupplierAddressLines extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly addressLine: Promise<string>;
	}
	//# sourceMappingURL=purchase-order-from-supplier-address-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-discount-or-charge-calculation-rules.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-discount-or-charge-calculation-rules' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderDiscountOrChargeCalculationRules extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly type: Promise<sageX3MasterData.enums.DiscountCalculationRules | null>;
	    readonly invoiceLineElement: Reference<sageX3InvoicingData.nodes.PurchaseInvoicingElement | null>;
	    readonly priceLineTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-order-discount-or-charge-calculation-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-dimensions.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=purchase-order-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-order-company-names.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-order-company-names' {
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseOrderCompanyNames extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
	    readonly companyName: Promise<string>;
	}
	//# sourceMappingURL=purchase-order-company-names.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-invoice.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-invoice' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, Collection, date, TextStream } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseInvoice extends Node {
	    readonly id: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
	    readonly invoiceType: Reference<sageX3PurchasingData.nodes.PurchaseInvoiceType | null>;
	    readonly purchaseInvoiceCategory: Promise<sageX3MasterData.enums.PurchaseInvoiceCategory | null>;
	    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly numberOfLinesWithDifferentQuantity: Promise<integer | null>;
	    readonly numberOfLinesWithDifferentPrice: Promise<integer | null>;
	    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly totalWeightOfLines: Promise<decimal | null>;
	    readonly totalVolumeOfLines: Promise<decimal | null>;
	    readonly totalQuantityOfLines: Promise<decimal | null>;
	    readonly amountOfLinesExcludingTax: Promise<decimal | null>;
	    readonly calculatedLineAmountExcludingTax: Promise<decimal | null>;
	    readonly totalTaxAmount: Promise<decimal | null>;
	    readonly billBySupplierLanguage: Reference<sageX3System.nodes.Language>;
	    readonly companyLanguage: Reference<sageX3System.nodes.Language>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
	    readonly invoiceHeaderTextKey: Promise<string>;
	    readonly invoiceFooterTextKey: Promise<string>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly purchaseInvoiceLines: Collection<sageX3Purchasing.nodes.PurchaseInvoiceLine>;
	    readonly supplierInvoiceHeader: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly invoiceHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly invoiceFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly accountingDate: Promise<date | null>;
	    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly billBySupplierAddressLines: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierAddressLines>;
	    readonly billBySupplierCity: Promise<string>;
	    readonly billBySupplierCompanyNames: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierCompanyNames>;
	    readonly billBySupplierCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly billBySupplierCountryName: Promise<string>;
	    readonly billBySupplierPostalCode: Promise<string>;
	    readonly billBySupplierState: Promise<string>;
	    readonly cashVatTaxRule: Promise<boolean>;
	    readonly comments: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderComments>;
	    readonly control: Promise<string>;
	    readonly currencyRates: Collection<sageX3FinanceData.nodes.SupplierInvoiceHeaderCurrencyRates>;
	    readonly debitOrCredit: Promise<integer | null>;
	    readonly derCode: Promise<string>;
	    readonly dimensions: Collection<sageX3FinanceData.nodes.SupplierInvoiceHeaderDimensions>;
	    readonly dueDateCalculationStartDate: Promise<date | null>;
	    readonly earlyDiscountOrLateChargeBasis: Promise<decimal | null>;
	    readonly earlyDiscountOrLateChargeRate: Promise<decimal | null>;
	    readonly entryType: Reference<sageX3FinanceData.nodes.EntryType | null>;
	    readonly europeanUnionIdentification: Promise<string>;
	    readonly field40Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly field41Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly fiscalYear: Promise<integer | null>;
	    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
	    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
	    readonly incotermTown: Promise<string>;
	    readonly internalNumber: Promise<integer | null>;
	    readonly internalReference: Promise<string>;
	    readonly intrastatProcessingNumber: Promise<integer | null>;
	    readonly intrastatStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
	    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
	    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
	    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
	    readonly invoiceFooterText: Promise<TextStream>;
	    readonly invoiceHeaderText: Promise<TextStream>;
	    readonly isDas2Submitted: Promise<boolean>;
	    readonly isEuropeanUnionInvoice: Promise<boolean>;
	    readonly journal: Reference<sageX3FinanceData.nodes.Journal | null>;
	    readonly lastServiceAccountedDate: Promise<date | null>;
	    readonly matchStatus: Promise<sageX3InvoicingData.enums.MatchStatusEnum | null>;
	    readonly numberOfTaxes: Promise<integer | null>;
	    readonly originalDocumentNumber: Promise<string>;
	    readonly originalInvoiceNumber: Promise<string>;
	    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
	    readonly payToBusinessPartnerAddressLines: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
	    readonly payToBusinessPartnerCity: Promise<string>;
	    readonly payToBusinessPartnerCompanyNames: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
	    readonly payToBusinessPartnerCountry: Reference<sageX3Structure.nodes.Country | null>;
	    readonly payToBusinessPartnerCountryName: Promise<string>;
	    readonly payToBusinessPartnerPostalCode: Promise<string>;
	    readonly payToBusinessPartnerState: Promise<string>;
	    readonly paymentApproval: Promise<sageX3MasterData.enums.PaymentApprovalType | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
	    readonly period: Promise<integer | null>;
	    readonly priceOrAmountType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly rateDate: Promise<date | null>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
	    readonly serviceEndDate: Promise<date | null>;
	    readonly serviceStartDate: Promise<date | null>;
	    readonly singleCustomsDocumentBusinessPartnerCode: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly singleCustomsDocumentDate: Promise<date | null>;
	    readonly singleCustomsDocumentReference: Promise<string>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly sourceDocumentDate: Promise<date | null>;
	    readonly sourceModule: Promise<sageX3System.enums.ModuleTable | null>;
	    readonly status: Promise<sageX3InvoicingData.enums.PurchasingInvoiceStatus | null>;
	    readonly supplierSourceDocument: Promise<string>;
	    readonly taxReferenceDate: Promise<date | null>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
	    readonly taxes: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderTaxes>;
	    readonly totalAmountExcludingTax: Promise<decimal | null>;
	    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly totalAmountIncludingTax: Promise<decimal | null>;
	    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
	    readonly versionControlSystemNumber: Promise<string>;
	    readonly headerInvoiceLineAllocationElements: Collection<sageX3Purchasing.nodes.PurchaseInvoiceHeaderInvoiceLineAllocationElements>;
	    readonly headerInvoiceLineElements: Collection<sageX3Purchasing.nodes.PurchaseInvoiceHeaderInvoiceLineElements>;
	    readonly supplierStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseInvoiceSupplierStatisticalGroups>;
	}
	//# sourceMappingURL=purchase-invoice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-invoice-supplier-statistical-groups.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-invoice-supplier-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseInvoiceSupplierStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseInvoice>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=purchase-invoice-supplier-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-invoice-line.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-invoice-line' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, TextStream, Collection } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseInvoiceLine extends Node {
	    readonly purchaseInvoice: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
	    readonly invoiceType: Reference<sageX3PurchasingData.nodes.PurchaseInvoiceType | null>;
	    readonly purchaseInvoiceCategory: Promise<sageX3MasterData.enums.PurchaseInvoiceCategory | null>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly accountingDate: Promise<date | null>;
	    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly lineSite: Reference<sageX3System.nodes.Site>;
	    readonly sourceLine: Promise<sageX3Purchasing.enums.PurchaseInvoiceSource | null>;
	    readonly sourceDocument: Promise<string>;
	    readonly sourceDocumentLineNumber: Promise<integer | null>;
	    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly productDescriptionInUserLanguage: Promise<string>;
	    readonly productDescriptionInSupplierLanguage: Promise<string>;
	    readonly invoicingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly stockUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
	    readonly quantityInInvoiceUnitInvoiced: Promise<decimal | null>;
	    readonly quantityInPurchaseUnitInvoiced: Promise<decimal | null>;
	    readonly sourceQuantity: Promise<decimal | null>;
	    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly sourceWeight: Promise<decimal | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly sourceVolume: Promise<decimal | null>;
	    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly grossPrice: Promise<decimal | null>;
	    readonly priceReason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge1: Promise<decimal | null>;
	    readonly discountOrCharge2: Promise<decimal | null>;
	    readonly discountOrCharge3: Promise<decimal | null>;
	    readonly discountOrCharge4: Promise<decimal | null>;
	    readonly discountOrCharge5: Promise<decimal | null>;
	    readonly discountOrCharge6: Promise<decimal | null>;
	    readonly discountOrCharge7: Promise<decimal | null>;
	    readonly discountOrCharge8: Promise<decimal | null>;
	    readonly discountOrCharge9: Promise<decimal | null>;
	    readonly discountOrCharge1Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge2Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge3Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge4Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge5Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge6Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge7Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge8Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly discountOrCharge9Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
	    readonly netPrice: Promise<decimal | null>;
	    readonly sourceNetPrice: Promise<decimal | null>;
	    readonly purchaseType: Promise<sageX3InvoicingData.enums.PurchaseType | null>;
	    readonly distributedInvoicingElement1AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement2AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement3AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement4AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement5AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement6AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement7AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement8AmountExcludingTax: Promise<decimal | null>;
	    readonly distributedInvoicingElement9AmountExcludingTax: Promise<decimal | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly purchaseOrder: Reference<sageX3Purchasing.nodes.PurchaseOrder | null>;
	    readonly purchaseOrderLine: Reference<sageX3Purchasing.nodes.PurchaseOrderLine | null>;
	    readonly purchaseOrderSequenceNumber: Promise<integer | null>;
	    readonly purchaseReceipt: Reference<sageX3Purchasing.nodes.PurchaseReceipt | null>;
	    readonly purchaseReceiptLine: Reference<sageX3Purchasing.nodes.PurchaseReceiptLine | null>;
	    readonly purchaseReturn: Reference<sageX3Purchasing.nodes.PurchaseReturn | null>;
	    readonly purchaseReturnLine: Reference<sageX3Purchasing.nodes.PurchaseReturnLine | null>;
	    readonly purchaseShipment: Reference<sageX3Purchasing.nodes.PurchaseShipment | null>;
	    readonly purchaseShipmentLine: Reference<sageX3Purchasing.nodes.PurchaseShipmentLine | null>;
	    readonly sourcePurchaseInvoice: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader | null>;
	    readonly sourcePurchaseInvoiceLine: Reference<sageX3Purchasing.nodes.PurchaseInvoiceLine | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier>;
	    readonly receiptDate: Promise<date | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly issueRegion: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly receiptRegion: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly lineAmountExcludingTax: Promise<decimal | null>;
	    readonly lineAmountIncludingTax: Promise<decimal | null>;
	    readonly discountAmount: Promise<decimal | null>;
	    readonly distributedInvoicingElementEarlyDiscountAmount1: Promise<decimal | null>;
	    readonly distributedInvoicingElementEarlyDiscountAmount2: Promise<decimal | null>;
	    readonly distributedInvoicingElementEarlyDiscountAmount3: Promise<decimal | null>;
	    readonly distributedInvoicingElementEarlyDiscountAmount4: Promise<decimal | null>;
	    readonly distributedInvoicingElementEarlyDiscountAmount5: Promise<decimal | null>;
	    readonly distributedInvoicingElementEarlyDiscountAmount6: Promise<decimal | null>;
	    readonly distributedInvoicingElementEarlyDiscountAmount7: Promise<decimal | null>;
	    readonly distributedInvoicingElementEarlyDiscountAmount8: Promise<decimal | null>;
	    readonly distributedInvoicingElementEarlyDiscountAmount9: Promise<decimal | null>;
	    readonly quantityUncommitted: Promise<decimal | null>;
	    readonly quantityActualCommitted: Promise<decimal | null>;
	    readonly nonFinancialUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly calculatedTaxableBase1: Promise<decimal | null>;
	    readonly calculatedTaxableBase2: Promise<decimal | null>;
	    readonly calculatedTaxableBase3: Promise<decimal | null>;
	    readonly calculationBasisForReceiptTax: Promise<decimal | null>;
	    readonly calculationBasisForIssueTax: Promise<decimal | null>;
	    readonly calculationBasisForOtherTax1: Promise<decimal | null>;
	    readonly calculationBasisForOtherTax2: Promise<decimal | null>;
	    readonly rebateOnTax1Amount: Promise<decimal | null>;
	    readonly taxableBase1Amount: Promise<decimal | null>;
	    readonly tax1amount: Promise<decimal | null>;
	    readonly tax2amount: Promise<decimal | null>;
	    readonly tax3amount: Promise<decimal | null>;
	    readonly receiptTaxAmount: Promise<decimal | null>;
	    readonly issueTaxAmount: Promise<decimal | null>;
	    readonly otherTax1Amount: Promise<decimal | null>;
	    readonly otherTax2Amount: Promise<decimal | null>;
	    readonly tax1DeductibleAmount: Promise<decimal | null>;
	    readonly tax2DeductibleAmount: Promise<decimal | null>;
	    readonly tax3DeductibleAmount: Promise<decimal | null>;
	    readonly receiptTaxDeductibleAmount: Promise<decimal | null>;
	    readonly issueTaxDeductibleAmount: Promise<decimal | null>;
	    readonly otherTax1DeductibleAmount: Promise<decimal | null>;
	    readonly otherTax2DeductibleAmount: Promise<decimal | null>;
	    readonly landedCostCoefficient: Promise<decimal | null>;
	    readonly fixedLandedCostPerUnitInCompanyCurrency: Promise<decimal | null>;
	    readonly costPriceInCompanyCurrency: Promise<decimal | null>;
	    readonly purchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly lineStockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly linePurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly costStructure: Promise<string>;
	    readonly companyCurrency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly totalStockCostInCompanyCurrency: Promise<decimal | null>;
	    readonly totalPurchaseCostInCompanyCurrency: Promise<decimal | null>;
	    readonly isPartiallyInvoiced: Promise<boolean>;
	    readonly invoiceLineTextKey: Promise<string>;
	    readonly isExtractedLineFromIntrastat: Promise<boolean>;
	    readonly isIntrastatPhysicalFlow: Promise<boolean>;
	    readonly serviceStartDate: Promise<date | null>;
	    readonly serviceEndDate: Promise<date | null>;
	    readonly servicePeriodNumber: Promise<integer | null>;
	    readonly servicePeriodType: Promise<sageX3InvoicingData.enums.PeriodicityType | null>;
	    readonly lineType: Promise<sageX3PurchasingData.enums.OrderLineType | null>;
	    readonly linkQuantityCoefficientForSubcontract: Promise<decimal | null>;
	    readonly calculatedTaxExcludedLineAmount: Promise<decimal | null>;
	    readonly vatDeclarationNumber: Promise<string>;
	    readonly costUpdatedIfAdditionalInvoice: Promise<boolean>;
	    readonly cost: Reference<sageX3Purchasing.nodes.Cost | null>;
	    readonly isReconciled: Promise<boolean>;
	    readonly productType: Promise<sageX3Purchasing.enums.PurchasingProductType | null>;
	    readonly invoiceLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly invoiceLineText: Promise<TextStream>;
	    readonly productStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseInvoiceLineProductStatisticalGroups>;
	    readonly taxes: Collection<sageX3Purchasing.nodes.PurchaseInvoiceLineTaxes>;
	}
	//# sourceMappingURL=purchase-invoice-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-invoice-line-taxes.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-invoice-line-taxes' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseInvoiceLineTaxes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly purchaseInvoice: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseInvoiceLine>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-invoice-line-taxes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-invoice-line-product-statistical-groups.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-invoice-line-product-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseInvoiceLineProductStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly purchaseInvoice: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseInvoiceLine>;
	    readonly value: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=purchase-invoice-line-product-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-invoice-header-invoice-line-elements.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-invoice-header-invoice-line-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseInvoiceHeaderInvoiceLineElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseInvoice>;
	    readonly invoiceLineElement: Reference<sageX3InvoicingData.nodes.PurchaseInvoicingElement | null>;
	    readonly priceLineTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-invoice-header-invoice-line-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-invoice-header-invoice-line-allocation-elements.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-invoice-header-invoice-line-allocation-elements' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Purchasing from '@sage/x3-purchasing/lib/index';
	export class PurchaseInvoiceHeaderInvoiceLineAllocationElements extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Purchasing.nodes.PurchaseInvoice>;
	    readonly invoiceLineAllocationElement: Reference<sageX3InvoicingData.nodes.PurchaseInvoicingElement | null>;
	    readonly distributionLineTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	}
	//# sourceMappingURL=purchase-invoice-header-invoice-line-allocation-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/purchase-entry-transaction.d.ts
declare module '@sage/x3-purchasing/lib/nodes/purchase-entry-transaction' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class PurchaseEntryTransaction extends Node {
	    readonly entryTransactionType: Promise<sageX3PurchasingData.enums.PurchaseDocumentType | null>;
	    readonly code: Promise<string>;
	    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly isActive: Promise<boolean>;
	    readonly identifier1Entry: Promise<sageX3System.enums.EntryMode | null>;
	    readonly identifier2Entry: Promise<sageX3System.enums.EntryMode | null>;
	    readonly identifier1Detail: Promise<sageX3System.enums.EntryMode | null>;
	    readonly identifier2Detail: Promise<sageX3System.enums.EntryMode | null>;
	    readonly isLotExpirationDateAllowed: Promise<boolean>;
	    readonly isLotPotencyAllowed: Promise<boolean>;
	    readonly isLotCustomField1Allowed: Promise<boolean>;
	    readonly isLotCustomField2Allowed: Promise<boolean>;
	    readonly isLotCustomField3Allowed: Promise<boolean>;
	    readonly isLotCustomField4Allowed: Promise<boolean>;
	    readonly defaultStockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=purchase-entry-transaction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/product-supplier-view.d.ts
declare module '@sage/x3-purchasing/lib/nodes/product-supplier-view' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node } from '@sage/xtrem-core';
	export class ProductSupplierView extends Node {
	    readonly stockSite: Promise<string>;
	    readonly supplier: Promise<string>;
	    readonly product: Promise<string>;
	    readonly description1: Promise<string>;
	    readonly upc: Promise<string>;
	    readonly globalTradeItemNumber: Promise<string>;
	    readonly productStatus: Promise<sageX3MasterData.enums.ProductStatus | null>;
	    readonly isReceived: Promise<boolean>;
	    readonly isPurchased: Promise<boolean>;
	    readonly isPhantom: Promise<boolean>;
	    readonly isDeliverable: Promise<boolean>;
	    readonly isSold: Promise<boolean>;
	    readonly isSubcontracted: Promise<boolean>;
	    readonly isService: Promise<boolean>;
	    readonly productCategory: Promise<string>;
	    readonly supplierProduct: Promise<string>;
	    readonly supplierProductDescription: Promise<string>;
	    readonly supplierUpc: Promise<string>;
	}
	//# sourceMappingURL=product-supplier-view.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/index.d.ts
declare module '@sage/x3-purchasing/lib/nodes/index' {
	export * from '@sage/x3-purchasing/lib/nodes/cost';
	export * from '@sage/x3-purchasing/lib/nodes/product-supplier-view';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-entry-transaction';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-invoice-header-invoice-line-allocation-elements';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-invoice-header-invoice-line-elements';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-invoice-line-product-statistical-groups';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-invoice-line-taxes';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-invoice-line';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-invoice-supplier-statistical-groups';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-invoice';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-company-names';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-dimensions';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-discount-or-charge-calculation-rules';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-from-supplier-address-lines';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-from-supplier-company-names';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-header-invoice-line-allocation-elements';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-line-product-statistical-groups';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-line-taxes';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-line';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-quantity-line';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-quantity-lines-supplier-view';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-ship-from-supplier-address-lines';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order-supplier-statistical-groups';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-order';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt-address-lines';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt-company-names';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt-dimensions';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt-header-invoice-line-allocation-elements';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt-header-invoice-line-elements';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt-line-product-statistical-groups';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt-line-taxes';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt-line';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt-statistical-groups';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-receipt';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-return-line-taxes';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-return-line';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-return';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-shipment-line';
	export * from '@sage/x3-purchasing/lib/nodes/purchase-shipment';
	export * from '@sage/x3-purchasing/lib/nodes/transport';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/nodes/cost.d.ts
declare module '@sage/x3-purchasing/lib/nodes/cost' {
	import { Node } from '@sage/xtrem-core';
	export class Cost extends Node {
	    readonly code: Promise<string>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=cost.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/node-functions/purchase-shipment-line-functions.d.ts
declare module '@sage/x3-purchasing/lib/node-functions/purchase-shipment-line-functions' {
	import { decimal, ExtensionMembers } from '@sage/xtrem-core';
	import * as x3Purchasing from '@sage/x3-purchasing/lib/index';
	export function getQuantityInPurchaseUnitExpected(purchaseShipmentLine: ExtensionMembers<x3Purchasing.nodes.PurchaseShipmentLine>): Promise<decimal>;
	//# sourceMappingURL=purchase-shipment-line-functions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/node-functions/index.d.ts
declare module '@sage/x3-purchasing/lib/node-functions/index' {
	export * from '@sage/x3-purchasing/lib/node-functions/purchase-shipment-line-functions';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-purchasing/lib/node-extensions/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/enums/purchasing-product-type.d.ts
declare module '@sage/x3-purchasing/lib/enums/purchasing-product-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchasingProductTypeEnum {
	    standard = 1,
	    subcontract = 2,
	    service = 3
	}
	export interface PurchasingProductType$EnumInterface {
	    standard: 1;
	    subcontract: 2;
	    service: 3;
	}
	export type PurchasingProductType = keyof PurchasingProductType$EnumInterface;
	export const purchasingProductTypeDatatype: X3EnumDataType<keyof PurchasingProductType$EnumInterface, unknown>;
	//# sourceMappingURL=purchasing-product-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/enums/purchase-order-type.d.ts
declare module '@sage/x3-purchasing/lib/enums/purchase-order-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseOrderTypeEnum {
	    order = 1,
	    contract = 2
	}
	export interface PurchaseOrderType$EnumInterface {
	    order: 1;
	    contract: 2;
	}
	export type PurchaseOrderType = keyof PurchaseOrderType$EnumInterface;
	export const purchaseOrderTypeDatatype: X3EnumDataType<keyof PurchaseOrderType$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-order-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/enums/purchase-invoice-source.d.ts
declare module '@sage/x3-purchasing/lib/enums/purchase-invoice-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseInvoiceSourceEnum {
	    order = 1,
	    receipt = 2,
	    return = 3,
	    invoice = 4,
	    miscellaneous = 5,
	    shipment = 6
	}
	export interface PurchaseInvoiceSource$EnumInterface {
	    order: 1;
	    receipt: 2;
	    return: 3;
	    invoice: 4;
	    miscellaneous: 5;
	    shipment: 6;
	}
	export type PurchaseInvoiceSource = keyof PurchaseInvoiceSource$EnumInterface;
	export const purchaseInvoiceSourceDatatype: X3EnumDataType<keyof PurchaseInvoiceSource$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-invoice-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-purchasing/build/lib/enums/index.d.ts
declare module '@sage/x3-purchasing/lib/enums/index' {
	export * from '@sage/x3-purchasing/lib/enums/purchase-invoice-source';
	export * from '@sage/x3-purchasing/lib/enums/purchase-order-type';
	export * from '@sage/x3-purchasing/lib/enums/purchasing-product-type';
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/x3-purchasing' {
	export * from '@sage/x3-purchasing/index';
}
