/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/purchase-receipt-details-control.ts":
/*!******************************************************************!*\
  !*** ./lib/client-functions/purchase-receipt-details-control.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.PurchaseReceiptDetailsRecordManager = exports.controlLotReceipt = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst xtrem_ui_1 = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function validate(page) {\n    // (X3-201046, X3-203885) TODO Issue: Have better validation error messages that specifically tell which fields have issues\n    const errors = await page.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    page.$.showToast(`${(0, xtrem_ui_1.localize)('@sage/x3-purchasing/dialog-error-title', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validate = validate;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock-data/StockJournal')\n        .query(xtrem_ui_1.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast((0, xtrem_ui_1.localize)('@sage/x3-purchasing/notification-error-receipt-lot', 'the lot number {{ lot }} already exists for this product', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\nvar YesNoEnum;\n(function (YesNoEnum) {\n    YesNoEnum[YesNoEnum[\"no\"] = 1] = \"no\";\n    YesNoEnum[YesNoEnum[\"yes\"] = 2] = \"yes\";\n})(YesNoEnum || (YesNoEnum = {}));\nclass PurchaseReceiptDetailsRecordManager {\n    constructor(page, cleanupIncompleteSessionLines = false) {\n        this.page = page;\n        this._stockDetails = [];\n        this._receiptUnit = [];\n        this._unitIsSame = true;\n        // An incomplete purchase receipt line can be added to the session when user is transitioning from main page to enter detail page\n        if (cleanupIncompleteSessionLines)\n            this._cleanupSession();\n    }\n    static { this.PURCHASE_RECEIPT_KEY = 'purchaseReceipt'; }\n    get purchaseSession() {\n        if (this._purchaseSession) {\n            return this._purchaseSession;\n        }\n        const storedSession = this.page.$.storage.get(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY);\n        if (storedSession) {\n            const parsedSession = JSON.parse(storedSession);\n            if (this._checkStorage(parsedSession)) {\n                this._purchaseSession = parsedSession;\n            }\n            else {\n                // purchase receipt in the session storage is corrupted/malformed\n                this.clearSession();\n            }\n        }\n        return this._purchaseSession;\n    }\n    set purchaseSession(purchaseSession) {\n        if (!purchaseSession) {\n            return;\n        }\n        if (!this._checkStorage(purchaseSession)) {\n            throw new Error('Invalid Purchase Receipt session');\n        }\n        this.page.$.storage.set(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY, JSON.stringify(purchaseSession));\n        this._purchaseSession = purchaseSession;\n    }\n    _checkStorage(sessionData) {\n        // check if sessionData contains at least one purchase receipt line that has at least one stock detail line\n        if (!sessionData ||\n            !sessionData.purchaseEntryTransaction.code ||\n            !sessionData.purchaseReceipt.receiptDate ||\n            !sessionData.purchaseReceipt.lines || typesLib.strictEq(sessionData.purchaseReceipt.lines.length, 0) ||\n            !sessionData.purchaseReceipt.receiptSite ||\n            !sessionData.purchaseReceipt.supplier) {\n            return false;\n        }\n        return !sessionData.purchaseReceipt.lines.some((line) => {\n            // skip most recent line that is pending to be completed in detail page\n            if (!line.stockDetails) {\n                return false;\n            }\n            // check for each line, the receipt unit & quantity are defined\n            if (!line.receiptUnit || typesLib.strictEq(line.quantityInReceiptUnitReceived, null) || typesLib.strictEq(line.quantityInReceiptUnitReceived, undefined)) {\n                return true;\n            }\n            return line.stockDetails.some((detail) => {\n                // check for each stock detail on this line, the packing unit & quantity are defined\n                return (!detail.packingUnit || typesLib.strictEq(detail.quantityInPackingUnit, null) || typesLib.strictEq(detail.quantityInPackingUnit, undefined));\n            });\n        });\n    }\n    _cleanupSession() {\n        this._purchaseSession = this.purchaseSession; // get the latest from session\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        // remove any incomplete purchase receipt lines (ex. a line without stockDetails)\n        const prevLineCount = this._purchaseSession.purchaseReceipt.lines?.length;\n        this._purchaseSession.purchaseReceipt.lines = this._purchaseSession.purchaseReceipt.lines.filter((line) => {\n            if (!line.receiptUnit || typesLib.strictEq(line.quantityInReceiptUnitReceived, null) || typesLib.strictEq(line.quantityInReceiptUnitReceived, undefined) ||\n                !line.stockDetails) {\n                return false;\n            }\n            return !line.stockDetails.some((detail) => {\n                // check for each stock detail on this line, the packing unit & quantity are defined\n                return (!detail.packingUnit || typesLib.strictEq(detail.quantityInPackingUnit, null) || typesLib.strictEq(detail.quantityInPackingUnit, undefined));\n            });\n        });\n        // if all lines have been removed, clear the session\n        if (typesLib.strictEq(this._purchaseSession.purchaseReceipt.lines?.length, 0)) {\n            this.clearSession();\n        }\n        else if (typesLib.strictNe(prevLineCount, this._purchaseSession.purchaseReceipt.lines.length)) {\n            // otherwise if any line got removed, overwrite the session\n            this.purchaseSession = this._purchaseSession;\n        }\n    }\n    clearSession() {\n        this.page.$.storage.remove(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY);\n        this._purchaseSession = null;\n    }\n    createLine(page, product) {\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        const currentLineNumber = typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1);\n        const currentLine = this._purchaseSession.purchaseReceipt.lines[currentLineNumber];\n        currentLine.stockDetails = this._stockDetails;\n        // If all receipt units are the same, use that unit for the line. If there are multiple receipt units,\n        // use stock unit for the line.\n        if (this._unitIsSame) {\n            currentLine.quantityInReceiptUnitReceived = this._receiptUnit.reduce((totalQty, line) => {\n                return typesLib.add(totalQty, line.quantityInReceiptUnit);\n            }, 0);\n            currentLine.receiptUnit = this._receiptUnit[0].code;\n            currentLine.receiptUnitToStockUnitConversionFactor = Number(page.packingUnitToStockUnitConversionFactor.value);\n        }\n        else {\n            currentLine.quantityInReceiptUnitReceived = this._receiptUnit.reduce((totalQty, line) => {\n                return typesLib.add(totalQty, typesLib.mul(Number(line.quantityInReceiptUnit), Number(line.stockUnitConversionFactor)));\n            }, 0);\n            currentLine.receiptUnit = product.stockUnit.code;\n            currentLine.receiptUnitToStockUnitConversionFactor = Number(page.packingUnitToStockUnitConversionFactor.value);\n        }\n        //Set receipt line number\n        currentLine.lineNumber = typesLib.mul((typesLib.add(currentLineNumber, 1)), 1000);\n        /*  if (\n            currentLine.purchaseOrderNumber &&\n            currentLine.purchaseOrderLineNumber &&\n            currentLine.purchaseOrderLine\n        ) {\n            currentLine._forMutationOnlyDoClosePurchaseOrderLine =\n                page.closePoLine.options.indexOf(page.closePoLine.value) === 0 ? YesNoEnum.yes : YesNoEnum.no;\n        } _forMutationOnlyDoClosePurchaseOrderLine missing */\n        currentLine.balance = (typesLib.strictEq(page.closePoLine.value, ui.localize('@sage/x3-purchasing/Yes', 'Yes')) ? YesNoEnum.yes : YesNoEnum.no).toString();\n        currentLine.warehouse = page.warehouse.value ?? undefined;\n        currentLine.container = page.container?.value?.code;\n        this.purchaseSession = {\n            purchaseEntryTransaction: this._purchaseSession.purchaseEntryTransaction,\n            purchaseReceipt: this._purchaseSession.purchaseReceipt,\n            orderUnitToPurchaseUnitConversionFactor: page.packingUnitToStockUnitConversionFactor.value ?? 0,\n        };\n    }\n    loadStockDetails(page, product) {\n        const quantityReceivedInStockUnit = typesLib.mul((page.quantityToReceive.value ?? 0), (page.packingUnitToStockUnitConversionFactor.value ?? 1));\n        // Saving receipt units is separate array because only stock and packing units are saved at stock details level.\n        this._receiptUnit.push({\n            code: page.receiptUnitCode.value ?? '',\n            quantityInReceiptUnit: page.quantityToReceive.value ?? 0,\n            stockUnitConversionFactor: page.packingUnitToStockUnitConversionFactor.value ?? 1,\n        });\n        // Check if unit is different from previous line\n        if (typesLib.gt(this._receiptUnit.length, 1) && this._unitIsSame) {\n            if (typesLib.strictNe(page.receiptUnitCode.value, this._receiptUnit[typesLib.sub(this._receiptUnit.length, 2)].code)) {\n                this._unitIsSame = false;\n            }\n        }\n        const detailLine = {\n            packingUnit: page.isPackingUnit ? (page.receiptUnitCode.value ?? '') : product.stockUnit.code,\n            quantityInPackingUnit: page.isPackingUnit\n                ? (page.quantityToReceive.value ?? 0)\n                : quantityReceivedInStockUnit,\n            packingUnitToStockUnitConversionFactor: page.isPackingUnit\n                ? (page.packingUnitToStockUnitConversionFactor.value ?? 1)\n                : 1,\n            lot: page.lot.value ?? undefined, // using undefined, omits the property entirely from JSON when stringified\n            sublot: page.sublot.value ?? undefined,\n            supplierLot: page.supplierLot.value ?? undefined,\n            potency: page.potency.value ?? undefined,\n            location: page.location.value?.code,\n            serialNumber: page.serialNumber.value ?? undefined,\n            status: page.status.value ?? undefined, // this is always required\n            majorVersion: page.majorVersion.value?.code,\n            minorVersion: page.minorVersion.value?.minorVersion,\n            licensePlateNumber: page.licensePlateNumber.value?.code,\n            expirationDate: (page.expirationDate.isDisabled ? page.calculatedExpirationDate.value : page.expirationDate.value) ??\n                undefined,\n            useByDate: page.useByDate.value ?? undefined,\n            lotCustomField1: page.lotCustomField1.value ?? undefined,\n            lotCustomField2: page.lotCustomField2.value ?? undefined,\n            lotCustomField3: page.lotCustomField3.value ?? undefined,\n            lotCustomField4: page.lotCustomField4.value ?? undefined,\n            identifier1: page.identifier1.value ?? undefined,\n            identifier2: page.identifier2.value ?? undefined,\n        };\n        this._stockDetails.push(detailLine);\n        // Initialize detail page for next detail line.  Most field values will default to previous detail line values.\n        page.location.isDisabled = false;\n        page.licensePlateNumber.value = { code: '' };\n        page.sublot.value = '';\n        page.serialNumber.value = '';\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        const currLine = this._purchaseSession.purchaseReceipt.lines[typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1)];\n        if (!currLine.purchaseOrder) {\n            // Set remaining quantity to 0 for direct receipts\n            page.quantityToReceive.value = 0;\n        }\n        else {\n            // Calculate remaining quantity for PO receipt lines (not direct receipt)\n            // remainingQuantity and quantityToReceive will always be the same unit and that unit will be the default\n            // for the next detail line.  Value can never be negative\n            page.remainingQuantityInStockUnit.value = typesLib.sub((page.remainingQuantityInStockUnit.value ?? 0), typesLib.mul((page.quantityToReceive.value ?? 0), (page.packingUnitToStockUnitConversionFactor.value ?? 1)));\n            if (typesLib.strictNe(page.packingUnitToStockUnitConversionFactor.value, 0))\n                page.remainingQuantityInPackingUnit.value = typesLib.div(page.remainingQuantityInStockUnit.value, (page.packingUnitToStockUnitConversionFactor.value ?? 1));\n            page.quantityToReceive.value = typesLib.max(0, page.remainingQuantityInPackingUnit.value ?? 0);\n            page.quantityToReceiveNoRounded = page.quantityToReceive.value;\n        }\n    }\n}\nexports.PurchaseReceiptDetailsRecordManager = PurchaseReceiptDetailsRecordManager;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/purchase-receipt-details-control.ts\n");

/***/ }),

/***/ "./lib/client-functions/read-parameter.ts":
/*!************************************************!*\
  !*** ./lib/client-functions/read-parameter.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.readParameterValue = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function readParameterValue(parameter, user, stockSite, pageInstance) {\n    try {\n        let resp;\n        const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n            .node('@sage/x3-system/GeneralParameter')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            definitionLevel: true,\n            folderValue: true,\n            valueType: true,\n        }, {\n            filter: {\n                code: parameter,\n            },\n        }))\n            .execute());\n        // Call appropriate function depending on parameter level\n        if (typesLib.strictEq(response[0].definitionLevel, 'user') && typesLib.strictEq(response[0].folderValue, false)) {\n            if (typesLib.strictEq(response[0].valueType, 'alphanumeric')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/UserParameterValue')\n                    .mutations.readParameterValueString({ value: true }, {\n                    parameters: {\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'numeric') || typesLib.strictEq(response[0].valueType, 'localMenu')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/UserParameterValue')\n                    .mutations.readParameterValueInteger({ value: true }, {\n                    parameters: {\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'date')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/UserParameterValue')\n                    .mutations.readParameterValueDate({ value: true }, {\n                    parameters: {\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n        }\n        else {\n            if (typesLib.strictEq(response[0].valueType, 'alphanumeric')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/GeneralParametersData')\n                    .mutations.readParameterValueString({ value: true }, {\n                    parameters: {\n                        company: '',\n                        site: stockSite,\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'numeric') || typesLib.strictEq(response[0].valueType, 'localMenu')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/GeneralParametersData')\n                    .mutations.readParameterValueInteger({ value: true }, {\n                    parameters: {\n                        company: '',\n                        site: stockSite,\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'date')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/GeneralParametersData')\n                    .mutations.readParameterValueDate({ value: true }, {\n                    parameters: {\n                        company: '',\n                        site: stockSite,\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            return '';\n        }\n    }\n    catch (e) {\n        await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing/utils-error-reading-parameter-value', 'Error reading parameter value: {{ param }}', { param: parameter }));\n        return '';\n    }\n}\nexports.readParameterValue = readParameterValue;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/read-parameter.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-purchase-receipt.ts":
/*!**********************************************!*\
  !*** ./lib/pages/mobile-purchase-receipt.ts ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobilePurchaseReceipt = exports.mobileApplicationGs1Key = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_selected_stock_site_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-selected-stock-site */ \"../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\");\nconst on_goto_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/on-goto */ \"../../shared/x3-master-data/lib/client-functions/on-goto.ts\");\nconst receipt_1 = __webpack_require__(/*! @sage/x3-stock-data/build/lib/menu-items/receipt */ \"../../shared/x3-stock-data/build/lib/menu-items/receipt.js\");\nconst support_service_management_gs_1_page_1 = __webpack_require__(/*! @sage/x3-system/lib/client-functions/support-service-management-gs-1-page */ \"../../shared/x3-system/lib/client-functions/support-service-management-gs-1-page.ts\");\nconst parsed_element_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/parsed-element */ \"../../shared/x3-system/lib/shared-functions/parsed-element.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst purchase_receipt_details_control_1 = __webpack_require__(/*! ../client-functions/purchase-receipt-details-control */ \"./lib/client-functions/purchase-receipt-details-control.ts\");\nconst read_parameter_1 = __webpack_require__(/*! ../client-functions/read-parameter */ \"./lib/client-functions/read-parameter.ts\");\n// Key to use with Composite Data Gs1 for this application\nexports.mobileApplicationGs1Key = 'MobilePurchaseReceiptGs1Key';\nconst QTY_DECIMAL_PLACES = 8;\nconst CONVERSION_RATE_DECIMAL_PLACES = 6;\nlet MobilePurchaseReceipt = class MobilePurchaseReceipt extends support_service_management_gs_1_page_1.SupportServiceManagementGs1Page {\n    constructor() {\n        super(...arguments);\n        this._shipmentLines = [];\n        this._purchaseShipmentIds = [];\n        /* @internal */\n        this._globalTradeItemNumber = null;\n        /** @internal */\n        this._postDoneDetailPage = () => {\n            this.$.removeToasts();\n            this.$.setPageClean();\n            if (typesLib.gt(this._purchaseShipmentIds?.length, 1)) {\n                this.$.router.goTo('@sage/x3-purchasing/MobilePurchaseReceiptSelectAShipment', {\n                    purchaseOrderId: `${this.purchaseOrder?.value?.id}`,\n                    purchaseOrderLineNumber: `${this.purchaseOrderLinesSupplier?.value?.lineNumber}`,\n                    globalTradeItemNumber: `${this._globalTradeItemNumber ?? ''}`,\n                    shipmentToLoad: `${JSON.stringify(this._purchaseShipmentIds)}`,\n                    isLocationPreloaded: `${this._isLocationPreloaded ? '1' : '0'}`,\n                });\n            }\n            else {\n                this.$.router.goTo('@sage/x3-purchasing/MobilePurchaseReceiptEnterReceiptDetail', {\n                    globalTradeItemNumber: `${this._globalTradeItemNumber ?? ''}`,\n                    isLocationPreloaded: `${this._isLocationPreloaded ? '1' : '0'}`,\n                });\n            }\n        };\n        /**\n         * OnChange readonly process\n         *\n         * Used both decorator and bar code manager.\n         * @returns Promise<void>\n         */\n        /** @internal */\n        this._onChange_productSupplier = async () => {\n            this._globalTradeItemNumber = null;\n            if (!this.productSupplier.value)\n                return; // if user closes the lookup instead of selecting a record\n            if (!(await (0, purchase_receipt_details_control_1.validate)(this))) {\n                this.productSupplier.value = null;\n                return;\n            }\n            this._purchaseShipment = undefined;\n            this._purchaseShipmentLine = undefined;\n            const response = await this.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .query(ui.queryUtils.edgesSelector({\n                isBeingCounted: true,\n            }, {\n                filter: {\n                    product: {\n                        code: this.productSupplier?.value?.product,\n                    },\n                    stockSite: {\n                        code: this.stockSite.value ?? undefined,\n                    },\n                },\n            }))\n                .execute();\n            if (typesLib.strictNe(response.edges.length, 0) && typesLib.strictEq(response.edges[0].node.isBeingCounted, true)) {\n                if (!(await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-purchasing/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-purchasing/product-blocked-by-count-continue', 'Product blocked by count. Do you want to continue?'), {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-accept-yes', 'Yes'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-cancel-no', 'No'),\n                    },\n                }))) {\n                    //cancel button clicked - promise rejected\n                    this.productSupplier.value = null;\n                    this.productSupplier.focus();\n                    return;\n                }\n            }\n            this.goToDetailsPage({ product: this.productSupplier?.value?.product }, this.productSupplier?.value?.globalTradeItemNumber ?? null);\n        };\n        /** @internal */\n        this._onChange_purchaseOrderLinesSupplier = async () => {\n            this._globalTradeItemNumber = null;\n            this._purchaseShipment = undefined;\n            this._purchaseShipmentLine = undefined;\n            // if user closes the lookup instead of selecting a record\n            if (!this.purchaseOrderLinesSupplier.value)\n                return;\n            if (!(await (0, purchase_receipt_details_control_1.validate)(this))) {\n                this.purchaseOrderLinesSupplier.value = null;\n                return;\n            }\n            this._shipmentLines = await this._readShipmentLines();\n            this._cleanShipmentLines();\n            if (typesLib.strictEq(this._shipmentLines?.length, 1)) {\n                this._purchaseShipment = this._shipmentLines[0].purchaseShipment?.id;\n                this._purchaseShipmentLine = this._shipmentLines[0].lineNumber?.toString();\n            }\n            const response = await this.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .query(ui.queryUtils.edgesSelector({\n                isBeingCounted: true,\n            }, {\n                filter: {\n                    product: {\n                        code: this.purchaseOrderLinesSupplier.value.product,\n                    },\n                    stockSite: {\n                        code: this.stockSite.value ?? undefined,\n                    },\n                },\n            }))\n                .execute();\n            if (typesLib.strictNe(response.edges.length, 0) && typesLib.strictEq(response.edges[0].node.isBeingCounted, true)) {\n                if (!(await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-purchasing/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-purchasing/product-blocked-by-count-continue', 'Product blocked by count. Do you want to continue?'), {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-accept-yes', 'Yes'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-cancel-no', 'No'),\n                    },\n                }))) {\n                    //cancel button clicked - promise rejected\n                    this.purchaseOrderLinesSupplier.value = null;\n                    this.purchaseOrderLinesSupplier.focus();\n                    return;\n                }\n            }\n            this.goToDetailsPage({\n                product: this.purchaseOrderLinesSupplier?.value?.product,\n                purchaseOrder: this.purchaseOrder?.value?.id,\n                purchaseOrderLineNumber: this.purchaseOrderLinesSupplier?.value?.lineNumber,\n                purchaseOrderLine: this.purchaseOrderLinesSupplier?.value?.sequenceNumber,\n            }, this.purchaseOrderLinesSupplier?.value?.globalTradeItemNumber ?? null);\n        };\n    }\n    /**\n     *\n     * Methods section\n     *\n     *\n     */\n    _showWorkflowLayout(isPOWorkflow = true) {\n        this.purchaseOrderLinesSupplier.isHidden = !isPOWorkflow;\n        this.purchaseOrderLinesSupplier.isDisabled = !isPOWorkflow || !this.purchaseOrder.value;\n        this.productSupplier.isHidden = isPOWorkflow;\n        this.productSupplier.isDisabled =\n            isPOWorkflow || !this.supplier.value || !this._purchaseSession?.purchaseReceipt?.supplier;\n        this.supplier.isReadOnly = isPOWorkflow;\n        // product is to be disabled, if it is hidden or supplier field is empty\n        // Logic for whether supplier field should be readonly or not. If it becomes readonly, then auto-populate it based on selected PO\n        if (!this._purchaseSession?.purchaseReceipt?.supplier) {\n            // supplier field is only modifiable when there is no purchase receipt session yet\n            this.supplier.isReadOnly = isPOWorkflow;\n            if (this.supplier.isReadOnly) {\n                // this.supplier.value = this.purchaseOrder.value.orderFromSupplier._id;\n                this.supplier.value = this.purchaseOrder.value?.orderFromSupplier;\n            }\n            //Supplier will be disabled if current user is not authorized to process direct receipts.\n            //So clear supplier value when clearing the PO value.\n            if (!isPOWorkflow)\n                this.supplier.value = null;\n        }\n        if (this.supplier.isDisabled && !isPOWorkflow)\n            this.productSupplier.isDisabled = true;\n        if (isPOWorkflow)\n            this.purchaseOrderLinesSupplier.focus();\n        this.supplierPackingSlip.isHidden = true;\n        // this.$.commitValueAndPropertyChanges();\n    }\n    /**\n     * Initialize the page\n     * @returns false when page must be disabled\n     */\n    /** @internal */\n    async _init() {\n        //Populate the receipt so far if provided in the session data\n        this._purchaseReceiptRecordManager = new purchase_receipt_details_control_1.PurchaseReceiptDetailsRecordManager(this, true);\n        this._purchaseSession = this._purchaseReceiptRecordManager.purchaseSession;\n        const purchaseOrderId = this.$.queryParameters.purchaseOrderId;\n        const supplierCode = this.$.queryParameters.supplierCode;\n        let fromInquiries = false;\n        // if this is the first time user is on the main page of Purchase Receipt\n        if (!this._purchaseSession) {\n            // Initialize Receipt Date to the current date\n            this.receiptDate.value = xtrem_date_time_1.DateValue.today().toString();\n            try {\n                // Populate Default Site & Legal company & Entry Transaction fields\n                this.stockSite.value = await (0, get_selected_stock_site_1.getSelectedStockSite)(this, ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));\n                if (!this.stockSite.value) {\n                    return false;\n                }\n                await this._getProductSearch();\n                await this._initTransaction();\n            }\n            catch (error) {\n                this.$.showToast(error.message, { type: 'error' });\n                return false;\n            }\n            // Preloading purchaseOrderId and supplierCode into the purchaseOrder and supplier code fields\n            if (purchaseOrderId && supplierCode) {\n                fromInquiries = true;\n                this.purchaseOrder.value = {\n                    id: purchaseOrderId,\n                    orderFromSupplier: {\n                        code: { code: supplierCode },\n                    },\n                };\n                this._showWorkflowLayout(true);\n                await this.$.commitValueAndPropertyChanges();\n            }\n        }\n        else {\n            // else display user's selected entry transaction & date (both as disabled) & selected products to add stored from session storage\n            const purchaseReceipt = this._purchaseSession.purchaseReceipt;\n            // Populate Default Site\n            this.stockSite.value = purchaseReceipt.receiptSite ?? null; // TODO: Issue: User can change site via sticker. This can a runtime error because Enter Detail page always use the site from the sticker. (To reproduce error, add a PO line from site FR022 and then change site to NA021, refresh the main page, and notice the site is still set to FR022. When selecting a product from FR022, a runtime error during loading Enter Detail page will occur because it is using the wrong site NA021 from the sticker to retrieve a product that is from FR022)\n            await this._getProductSearch();\n            // Populate Entry Transaction, Receipt Date, Receipt lines to create, and Supplier fields based on session storage\n            try {\n                await this._initTransaction();\n            }\n            catch (e) {\n                ui.console.error(e);\n            }\n            this.transaction.options = [this._purchaseSession?.purchaseEntryTransaction?.code ?? ''];\n            this.transaction.value = this._purchaseSession.purchaseEntryTransaction.code ?? null;\n            // not allowed to be changed unless user creates successfully or remove all receipt lines\n            this.receiptDate.value = purchaseReceipt.receiptDate ?? null;\n            this.supplierPackingSlip.value = purchaseReceipt.supplierPackingSlip ?? null;\n            if (this.supplierPackingSlip.value) {\n                this.supplierPackingSlip.isHidden = false;\n                this.supplierPackingSlipLink.isHidden = true;\n            }\n            this.receiptToCreate.value = await this._mapPurchaseReceipt(purchaseReceipt.lines ?? []);\n            this.receiptBlock.isHidden = false;\n            this.supplier.value = { code: { code: purchaseReceipt.supplier } };\n            this.supplier.isReadOnly = true;\n            this.productSupplier.isDisabled = false; // because supplier is now poulated & cannot be changed til the entire session is cleared out\n            // auto-populate PO lookup with most recently selected PO or empty if most recently is a direct receipt line (i.e. Supplier->product workflow)\n            if (purchaseReceipt.lines && purchaseReceipt.lines[typesLib.sub(purchaseReceipt.lines.length, 1)].purchaseOrder) {\n                this.purchaseOrder.value = {\n                    id: purchaseReceipt.lines[typesLib.sub(purchaseReceipt.lines.length, 1)].purchaseOrder,\n                }; // TODO: Verify: Is this bad practice of auto-populating reference field\n                this.purchaseOrderLinesSupplier.isDisabled = this.purchaseOrderLinesSupplier.isHidden = false;\n                this.productSupplier.isDisabled = this.productSupplier.isHidden = true;\n                this.purchaseOrderLinesSupplier.focus();\n            }\n            this.createButton.isDisabled = false;\n        }\n        // required for Purchase Order lookup (TODO: Verify if legalCompany can be stored in session to avoid a GraphQL call)\n        this.legalCompany.value = await this._getLegalCompany(this.stockSite.value ?? '');\n        // Disallow direct receipts based on PTHDIR setting. Storing value in local storage so only need to read once.\n        const valPTHDIR = await (0, read_parameter_1.readParameterValue)('PTHDIR', this.$.userCode ?? '', this.stockSite.value ?? '', this);\n        this.supplier.isDisabled = typesLib.strictNe(valPTHDIR, 2);\n        if (fromInquiries) {\n            this.purchaseOrder.focus();\n            this.purchaseOrderLinesSupplier.focus();\n        }\n        // perform screen initialization for current workFlow enabled\n        if (!(await this._initControlManagerGs1(this.stockSite.value ?? ''))) {\n            return false;\n        }\n        return true;\n    }\n    /**\n     * Initialize ControlManagerGs1\n     * @returns true when ControlManagerGs1 has usable\n     */\n    async _initControlManagerGs1(site) {\n        const isPOWorkflow = !!this.purchaseOrder.value;\n        return await this.createAndInitServiceGs1(site, exports.mobileApplicationGs1Key, {\n            [parsed_element_1.DataTitle.gtin]: {\n                mainField: isPOWorkflow ? this.purchaseOrderLinesSupplier : this.productSupplier,\n                onChangeMainField: isPOWorkflow\n                    ? this._onChange_purchaseOrderLinesSupplier\n                    : this._onChange_productSupplier,\n            },\n        });\n    }\n    /**\n     * Update fields mappings\n     * @returns true when ControlManagerGs1 has usable\n     */\n    /** @internal */\n    async _updateControlManagerGs1() {\n        const isPOWorkflow = !!this.purchaseOrder.value;\n        return await this.setScreenFieldSupported({\n            [parsed_element_1.DataTitle.gtin]: {\n                mainField: isPOWorkflow ? this.purchaseOrderLinesSupplier : this.productSupplier,\n                onChangeMainField: isPOWorkflow\n                    ? this._onChange_purchaseOrderLinesSupplier\n                    : this._onChange_productSupplier,\n            },\n        });\n    }\n    goToDetailsPage(line, globalTradeItemNumber) {\n        const purchaseReceiptLine = {\n            receiptSite: this.stockSite.value ?? undefined,\n            ...line,\n        };\n        // Store globalTradeItemNumber for postDone action\n        this._globalTradeItemNumber = globalTradeItemNumber;\n        if (!this._purchaseSession) {\n            // if no session, create a new session object\n            const selectedEntryTransaction = this._entryTransactionMap.get(this.transaction.value ?? '');\n            this._purchaseReceiptRecordManager.purchaseSession = {\n                purchaseReceipt: {\n                    receiptSite: this.stockSite.value ?? undefined,\n                    receiptDate: this.receiptDate.value ?? undefined,\n                    supplier: this.supplier.value?.code.code,\n                    stockAutomaticJournal: selectedEntryTransaction?.stockAutomaticJournal,\n                    stockMovementCode: selectedEntryTransaction?.stockMovementCode ?? '',\n                    transaction: selectedEntryTransaction?.code,\n                    destination: this.$.storage.get('mobile-label-destination')?.toString() ?? '',\n                    document: this.$.storage.get('mobile-document-destination')?.toString() ?? '',\n                    supplierPackingSlip: this.supplierPackingSlip.value ?? undefined,\n                    supplierPackingSlipDate: xtrem_date_time_1.DateValue.today().toString(),\n                    lines: [\n                        {\n                            ...purchaseReceiptLine,\n                            stockMovementGroup: selectedEntryTransaction?.defaultStockMovementGroup ?? '',\n                            purchaseShipment: this._purchaseShipment,\n                            purchaseShipmentLine: this._purchaseShipmentLine,\n                        },\n                    ],\n                },\n                purchaseEntryTransaction: {\n                    code: this.transaction.value ?? undefined,\n                    isLotCustomField1Allowed: selectedEntryTransaction?.isLotCustomField1Allowed,\n                    isLotCustomField2Allowed: selectedEntryTransaction?.isLotCustomField2Allowed,\n                    isLotCustomField3Allowed: selectedEntryTransaction?.isLotCustomField3Allowed,\n                    isLotCustomField4Allowed: selectedEntryTransaction?.isLotCustomField4Allowed,\n                    identifier1Entry: selectedEntryTransaction?.identifier1Entry,\n                    identifier1Detail: selectedEntryTransaction?.identifier1Detail,\n                    identifier2Entry: selectedEntryTransaction?.identifier2Entry,\n                    identifier2Detail: selectedEntryTransaction?.identifier2Detail,\n                    isLotPotencyAllowed: selectedEntryTransaction?.isLotPotencyAllowed,\n                    isLotExpirationDateAllowed: selectedEntryTransaction?.isLotExpirationDateAllowed,\n                    stockMovementCode: selectedEntryTransaction?.stockMovementCode,\n                },\n                orderUnitToPurchaseUnitConversionFactor: 1,\n            };\n        }\n        else {\n            this._purchaseSession.purchaseReceipt.lines?.push({\n                ...purchaseReceiptLine,\n                stockMovementGroup: this._purchaseSession.purchaseReceipt.lines[typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1)]\n                    .stockMovementGroup, // copy stockMovementGroup from the previous most line\n                purchaseShipment: this._purchaseShipment,\n                purchaseShipmentLine: this._purchaseShipmentLine,\n            });\n            this._purchaseReceiptRecordManager.purchaseSession = {\n                purchaseReceipt: this._purchaseSession.purchaseReceipt,\n                purchaseEntryTransaction: this._purchaseSession.purchaseEntryTransaction,\n                orderUnitToPurchaseUnitConversionFactor: 1,\n            };\n        }\n        // saving data and aborting dispatch is not enough :\n        // the page has changed before dispatching has aborted !\n        this.saveCompositeData();\n        // If we are in the process of dispatching, we must delay the change of page\n        if (this.controlManagerGs1.isDispatchInProgress) {\n            this.controlManagerGs1.abortDispatch(this._postDoneDetailPage);\n        }\n        else if (!this.controlManagerGs1.isInitializationInProgress) {\n            this._postDoneDetailPage();\n        }\n    }\n    async _getLegalCompany(defaultSite) {\n        const response = await this.$.graph\n            .node('@sage/x3-system/Site')\n            .read({\n            _id: true, // TODO: Remove unneeded property\n            legalCompany: { code: true },\n        }, defaultSite)\n            .execute();\n        if (!response) {\n            // This should never occur as long as the user function profile has a valid site set up\n            throw new Error(ui.localize('@sage/x3-purchasing/error-purchase-receipt-no-legal-company', 'The invalid site {{site}} has no legal company.', {\n                site: defaultSite,\n            }));\n        }\n        return response.legalCompany.code;\n    }\n    async _getEntryTransactionOptions() {\n        const response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            // with 'provides' property defined in accessCode of this node, should automatically return only transactions that are accessible for the current user\n            .node('@sage/x3-purchasing/PurchaseEntryTransaction')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n            stockMovementCode: {\n                code: true,\n            },\n            defaultStockMovementGroup: {\n                code: true,\n            },\n            stockAutomaticJournal: {\n                code: true,\n            },\n            isLotCustomField1Allowed: true,\n            isLotCustomField2Allowed: true,\n            isLotCustomField3Allowed: true,\n            isLotCustomField4Allowed: true,\n            identifier1Entry: true,\n            identifier1Detail: true,\n            identifier2Entry: true,\n            identifier2Detail: true,\n            isLotPotencyAllowed: true,\n            isLotExpirationDateAllowed: true,\n        }, {\n            filter: {\n                entryTransactionType: 'receipt',\n                isActive: true,\n            },\n        }))\n            .execute());\n        this._entryTransactionMap = new Map(); // TODO: Put this in a better place\n        // transform Entry Transaction response into a string array\n        return response.map((entryTransaction) => {\n            this._entryTransactionMap.set(entryTransaction.code, {\n                code: entryTransaction.code,\n                _id: entryTransaction._id,\n                stockAutomaticJournal: entryTransaction.stockAutomaticJournal?.code,\n                stockMovementCode: entryTransaction.stockMovementCode?.code,\n                defaultStockMovementGroup: entryTransaction.defaultStockMovementGroup?.code,\n                isLotCustomField1Allowed: entryTransaction.isLotCustomField1Allowed,\n                isLotCustomField2Allowed: entryTransaction.isLotCustomField2Allowed,\n                isLotCustomField3Allowed: entryTransaction.isLotCustomField3Allowed,\n                isLotCustomField4Allowed: entryTransaction.isLotCustomField4Allowed,\n                identifier1Entry: entryTransaction.identifier1Entry,\n                identifier1Detail: entryTransaction.identifier1Detail,\n                identifier2Entry: entryTransaction.identifier2Entry,\n                identifier2Detail: entryTransaction.identifier2Detail,\n                isLotPotencyAllowed: entryTransaction.isLotPotencyAllowed,\n                isLotExpirationDateAllowed: entryTransaction.isLotExpirationDateAllowed,\n            });\n            return entryTransaction.code;\n        });\n    }\n    async _callCreationAPI() {\n        const _purchaseReceiptArgs = this._purchaseSession?.purchaseReceipt ?? {};\n        let result;\n        try {\n            result = await this.$.graph\n                .node('@sage/x3-purchasing/PurchaseReceipt')\n                .create({\n                id: true,\n            }, {\n                data: _purchaseReceiptArgs,\n            })\n                .execute();\n            if (!result) {\n                throw new xtrem_shared_1.BusinessRuleError(ui.localize('@sage/x3-purchasing/dialog-error-purchase-receipt-no-create-results', 'No results for the created purchase receipt'));\n            }\n        }\n        catch (error) {\n            return error;\n        }\n        return result;\n    }\n    async _getReceiptUnits(units) {\n        const response = await this.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n            numberOfDecimals: true,\n        }, {\n            filter: {\n                code: { _in: units },\n            },\n        }))\n            .execute();\n        return response.edges.map(edge => {\n            return {\n                code: edge.node.code,\n                numberOfDecimals: edge.node.numberOfDecimals,\n            };\n        });\n    }\n    async _mapPurchaseReceipt(receipt) {\n        let rowCount = 0;\n        const receiptUnits = await this._getReceiptUnits(receipt.map((line) => line.receiptUnit));\n        return receipt.map((line) => {\n            var _v;\n            return {\n                _id: String((_v = rowCount, rowCount = typesLib.add(rowCount, 1), _v)), // this defines the rowId parameter in dropdownActions onClick() event\n                purchaseOrderLineNumber: line.purchaseOrder && line.purchaseOrderLineNumber\n                    ? `${line.purchaseOrder} ${line.purchaseOrderLineNumber}`\n                    : '',\n                product: line.product,\n                quantityAndStockUnit: `${Number(line.quantityInReceiptUnitReceived).toFixed(receiptUnits.find(unit => typesLib.strictEq(unit.code, line.receiptUnit))?.numberOfDecimals ?? 0)} ${line.receiptUnit}`,\n                purchaseShipment: line.purchaseShipment && line.purchaseShipmentLine\n                    ? `${line.purchaseShipment} ${line.purchaseShipmentLine}`\n                    : '',\n            };\n        });\n    }\n    _disablePage() {\n        this.purchaseOrder.isDisabled = true;\n        this.supplier.isDisabled = true;\n        this.receiptDate.isDisabled = true;\n        this.transaction.isDisabled = true;\n        this.supplierPackingSlip.isDisabled = true;\n    }\n    async _getProductSearch() {\n        const responseSite = await this.$.graph\n            .node('@sage/x3-master-data/MobileAutomationSetup')\n            .query(ui.queryUtils.edgesSelector({\n            criteria1: true,\n            criteria2: true,\n            isLocationPreloaded: true,\n        }, {\n            filter: {\n                site: { code: this.stockSite.value },\n            },\n        }))\n            .execute();\n        if (typesLib.strictNe(responseSite.edges.length, 0)) {\n            responseSite.edges.some(edge => {\n                this._productSearchCriteria1 = edge.node.criteria1;\n                this._productSearchCriteria2 = edge.node.criteria2;\n                this._isLocationPreloaded = edge.node.isLocationPreloaded;\n            });\n        }\n        else {\n            const response = await this.$.graph\n                .node('@sage/x3-master-data/MobileAutomationSetup')\n                .query(ui.queryUtils.edgesSelector({\n                criteria1: true,\n                criteria2: true,\n                isLocationPreloaded: true,\n            }, {\n                filter: {\n                    site: null,\n                },\n            }))\n                .execute();\n            if (typesLib.strictNe(response.edges.length, 0)) {\n                response.edges.some(edge => {\n                    this._productSearchCriteria1 = edge.node.criteria1;\n                    this._productSearchCriteria2 = edge.node.criteria2;\n                    this._isLocationPreloaded = edge.node.isLocationPreloaded;\n                });\n            }\n            else {\n                this._productSearchCriteria1 = 'none';\n                this._productSearchCriteria2 = 'none';\n                this._isLocationPreloaded = true;\n            }\n        }\n    }\n    async _initTransaction() {\n        this.transaction.options = await this._getEntryTransactionOptions();\n        switch (this.transaction.options.length) {\n            case 0:\n                this._disablePage();\n                throw new Error('No transaction, cannot continue');\n            case 1:\n                this.transaction.value = this.transaction.options[0];\n                this.transaction.isHidden = true;\n                break;\n            default:\n                this.transaction.value = this.transaction.options[0];\n                if (this._purchaseSession) {\n                    this.transaction.isDisabled = true;\n                }\n                break;\n        }\n    }\n    async _readShipmentLines() {\n        return (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-purchasing/PurchaseShipmentLine')\n            .query(ui.queryUtils.edgesSelector({\n            purchaseShipment: { id: true },\n            lineNumber: true,\n            product: { code: true },\n            purchaseOrderNumber: { id: true },\n            purchaseOrderLineNumber: true,\n            quantityInPurchaseUnitShipped: true,\n            quantityInPurchaseUnitReceived: true,\n            quantityInPurchaseUnitPreReceived: true,\n            quantityInOrderUnitShipped: true,\n            quantityInStockUnitShipped: true,\n            isClosed: true,\n            isPreReceived: true,\n        }, {\n            filter: {\n                purchaseOrderNumber: { id: this.purchaseOrder.value?.id },\n                purchaseOrderLineNumber: this.purchaseOrderLinesSupplier?.value?.lineNumber,\n                purchaseShipment: {\n                    shipmentStatus: {\n                        _nin: ['received', 'closed'],\n                    },\n                },\n                isClosed: { _eq: false },\n            },\n        }))\n            .execute());\n    }\n    _cleanShipmentLines() {\n        this._shipmentLines.forEach((element) => {\n            if ((element.isPreReceived && typesLib.gt(Number(element.quantityInPurchaseUnitPreReceived), Number(element.quantityInPurchaseUnitReceived))) ||\n                (!element.isPreReceived && typesLib.gt(Number(element.quantityInPurchaseUnitShipped), Number(element.quantityInPurchaseUnitReceived)))) {\n                this._purchaseShipmentIds.push(element?.purchaseShipment?.id);\n            }\n            else {\n                const resultIndex = this._shipmentLines.indexOf(element);\n                this._shipmentLines.splice(resultIndex, 1);\n            }\n        });\n        if (this._purchaseSession?.purchaseReceipt?.lines) {\n            this._shipmentLines.forEach(lineShip => {\n                if (typesLib.strictEq(lineShip.purchaseOrderNumber, this.purchaseOrder.value?.id) && typesLib.strictEq(lineShip.purchaseOrderLineNumber, this.purchaseOrderLinesSupplier?.value?.lineNumber)) {\n                    let QuantityInStockUnitReceived = 0;\n                    let quantityInStockUnitExpected = Number(lineShip.quantityInStockUnitShipped);\n                    this._purchaseSession?.purchaseReceipt?.lines?.forEach(line => {\n                        if (line.purchaseShipment) {\n                            if (typesLib.strictEq(line.purchaseShipment, lineShip.purchaseShipment?.id) && typesLib.strictEq(Number(line.purchaseShipmentLine), Number(lineShip.lineNumber))) {\n                                QuantityInStockUnitReceived = typesLib.add(QuantityInStockUnitReceived, typesLib.mul(Number(line.quantityInReceiptUnitReceived), Number(line.receiptUnitToStockUnitConversionFactor)));\n                            }\n                        }\n                    });\n                    if (typesLib.lte(typesLib.sub(Number(quantityInStockUnitExpected), Number(QuantityInStockUnitReceived)), 0)) {\n                        let resultIndex = this._purchaseShipmentIds.indexOf(lineShip.purchaseShipment?.id);\n                        this._purchaseShipmentIds.splice(resultIndex, 1);\n                        resultIndex = this._shipmentLines.indexOf(lineShip);\n                        this._shipmentLines.splice(resultIndex, 1);\n                    }\n                }\n            });\n        }\n    }\n};\nexports.MobilePurchaseReceipt = MobilePurchaseReceipt;\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"stockSite\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__createButton____title\", \"Create\"),\n        buttonType: 'primary',\n        shortcut: ['f2'],\n        isDisabled: true,\n        async onClick() {\n            // Check if the purchase receipt to create contains at least one valid line\n            if (!this._purchaseSession) {\n                this.$.showToast(ui.localize('@sage/x3-purchasing/notification-error-purchase-receipt-no-products', `Enter at least one product.`), { type: 'error', timeout: 5000 });\n                return;\n            }\n            // Only validate receipt date is populated\n            const validateError = (await this.receiptDate.validate()) || (await this.supplierPackingSlip.validate());\n            if (validateError) {\n                this.$.removeToasts();\n                this.$.showToast(`${ui.localize('@sage/x3-purchasing/notification-error-purchase-receipt-error', 'Error')}: ${validateError}`, { type: 'error', timeout: 30000 });\n                return;\n            }\n            this.createButton.isDisabled = true; // to prevent extreme case of duplicate receipts by rapidly clicking on create button multiple times\n            this.$.loader.isHidden = false;\n            const result = await this._callCreationAPI();\n            this.$.loader.isHidden = true;\n            // Special case unable to connect check type of error\n            this.supplierPackingSlip.isDirty = false;\n            if (!result || result instanceof Error) {\n                this.$.loader.isHidden = true;\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-goback', 'Go back'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-cancel', 'Cancel'),\n                    },\n                    size: 'small',\n                    mdContent: true,\n                };\n                let message = '';\n                if (!result?.message) {\n                    message = `${ui.localize('@sage/x3-purchasing/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.')}`;\n                }\n                else {\n                    const _messages = [];\n                    const _results = result;\n                    let _diagnoses = _results?.diagnoses;\n                    if (typesLib.gt(_diagnoses?.length, 1)) {\n                        _diagnoses = _diagnoses.splice(0, typesLib.sub(_diagnoses.length, 1));\n                    }\n                    ((_results?.errors\n                        ? _results.errors[0]?.extensions?.diagnoses\n                        : (_results?.innerError?.errors[0]?.extensions?.diagnoses ??\n                            _results.extensions?.diagnoses ??\n                            _diagnoses)) ?? [])\n                        .filter((d) => typesLib.gt(d.severity, 2) && d.message)\n                        .forEach((d) => {\n                        const _message = d.message.split(`\\n`);\n                        _messages.push(..._message);\n                    });\n                    const _result = _messages.length ? _messages : result.message.split(`\\n`);\n                    message = `**${ui.localize('@sage/x3-purchasing/dialog-error-purchase-receipt-creation', 'An error has occurred')}**\\n\\n`;\n                    if (typesLib.strictEq(_result.length, 1)) {\n                        message = typesLib.add(message, `${_result[0]}`);\n                    }\n                    else {\n                        message = typesLib.add(message, _result.map(item => `* ${item}`).join('\\n'));\n                    }\n                }\n                await this.$.sound.error();\n                if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), message, options)) {\n                    await this.$.router.refresh();\n                }\n                else {\n                    this._purchaseReceiptRecordManager.clearSession();\n                    await this.$.router.emptyPage();\n                }\n            }\n            else {\n                this._purchaseReceiptRecordManager.clearSession();\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-accept-ok', 'OK'),\n                    },\n                    fullScreen: true,\n                };\n                await this.$.sound.success();\n                await (0, dialogs_1.dialogMessage)(this, 'success', ui.localize('@sage/x3-purchasing/dialog-success-title', 'Success'), ui.localize('@sage/x3-purchasing/dialog-success-purchase-receipt-creation', 'Document no. {{receiptId}} created.', { receiptId: result.id }), options);\n                await this.$.router.emptyPage();\n            }\n        },\n    })\n], MobilePurchaseReceipt.prototype, \"createButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"productBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptBlock____title\", \"Receipt to create\"),\n        isHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"receiptBlock\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptDate____title\", \"Receipt date\"),\n        isTransient: true,\n        isMandatory: true,\n        maxDate: xtrem_date_time_1.DateValue.today().toString(), // restricts to current date or earlier\n        onChange() {\n            if (this._purchaseSession && this.receiptDate.value) {\n                this._purchaseSession.purchaseReceipt.receiptDate = this.receiptDate.value;\n                this._purchaseReceiptRecordManager.purchaseSession = this._purchaseSession; // trigger session manager's setter to save receipt date into session\n            }\n        },\n    })\n], MobilePurchaseReceipt.prototype, \"receiptDate\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__transaction____title\", \"Transaction\"),\n        isMandatory: true,\n        isTransient: true,\n    })\n], MobilePurchaseReceipt.prototype, \"transaction\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        isTransient: true,\n        isHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"legalCompany\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____title\", \"Purchase order\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-purchasing/PurchaseOrder',\n        valueField: 'id',\n        helperTextField: { orderFromSupplier: { code: { code: true } } },\n        isHelperTextHidden: true,\n        canFilter: false,\n        filter() {\n            const filter = {\n                isClosed: { _eq: false },\n                isIntersite: { _eq: false },\n                // (X3-227355) TODO: Issue: Cannot use the less verbose _in operator instead of individual _or filter criterion\n                _and: [\n                    {\n                        _or: [\n                            {\n                                signatureStatus: 'inFull',\n                            },\n                            {\n                                signatureStatus: 'notManaged',\n                            },\n                            {\n                                signatureStatus: 'automatic',\n                            },\n                        ],\n                    },\n                    {\n                        _or: [\n                            {\n                                receiptStatus: 'no',\n                            },\n                            {\n                                receiptStatus: 'inPart',\n                            },\n                        ],\n                    },\n                ],\n                // (X3-227172) TODO: Issue: Using _id instead of code in order to properly filter for 'null' values, however removed because this will break lookup Search bar\n                // receiptSite: { _id: { _in: [this.stockSite.value, null] } },\n                purchaseSite: { legalCompany: { code: this.legalCompany.value ?? undefined } },\n                // filtering on PO's lines to exclude PO that have nothing to receive\n                purchaseOrderLines: {\n                    _atLeast: 1,\n                    //(X3-191778) TODO: Issue: Not possible to filter on a collection's reference property\n                    // product: {\n                    //     productStatus: { _eq: 'active' },\n                    //     isReceived: true as any,\n                    // },\n                    // _or: [\n                    //     { purchaseOrder: { isIntersite: { _eq: true as any } } },\n                    //     {\n                    //         purchaseOrder: { isIntersite: { _eq: false as any } },\n                    //         product: {\n                    //             _or: [{ isManufactured: false as any }, { isPhantom: false as any }],\n                    //         },\n                    //     },\n                    // ],\n                    isClosed: { _eq: false },\n                    receiptSite: { code: this.stockSite.value ?? undefined },\n                    sourceRequest: { _ne: 'directOrder' },\n                    productType: { _ne: 'subcontract' },\n                    lineType: { _eq: 'normal' },\n                },\n            };\n            if (this.supplier.value) {\n                filter.orderFromSupplier = { code: this.supplier.value.code };\n            }\n            return filter;\n        },\n        async onChange() {\n            this._showWorkflowLayout(!!this.purchaseOrder.value);\n            // perform another screen initialization for current workFlow enabled\n            // TODO: This operation deletes the composite data, see if you want to transfer them here\n            if (!(await this._updateControlManagerGs1())) {\n                // TODO: What action should be taken in the event of a fatal error ?\n            }\n            this.supplierPackingSlipLink.isHidden = false;\n        },\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'id',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____columns__title__id\", \"Order no.\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'purchaseSite',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____columns__title__purchaseSite__code\", \"Order site\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Supplier',\n                bind: 'orderFromSupplier',\n                valueField: { code: { code: true } },\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____columns__title__orderFromSupplier__code__code\", \"Supplier\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'internalOrderReference',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____columns__title__internalOrderReference\", \"Internal or order reference\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.checkbox({\n                bind: 'isClosed',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'signatureStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'receiptStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'receiptSite',\n                valueField: '_id',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'purchaseSite',\n                valueField: { legalCompany: { code: true } },\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"purchaseOrder\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____title\", \"Supplier\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-master-data/Supplier',\n        valueField: { code: { code: true } },\n        canFilter: false,\n        filter: {\n            isActive: { _eq: true },\n        },\n        onChange() {\n            this.productSupplier.isDisabled = !this.supplier.value;\n            if (this.supplier.value) {\n                this.productSupplier.focus();\n            }\n        },\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        columns: [\n            ui.nestedFields.reference({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____columns__title__code__code\", \"Supplier\"),\n                isReadOnly: true,\n                node: '@sage/x3-master-data/BusinessPartner',\n                valueField: 'code',\n            }),\n            ui.nestedFields.text({\n                bind: 'shortCompanyName',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____columns__title__shortCompanyName\", \"Short Description\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'companyName1',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____columns__title__companyName1\", \"Company name\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.checkbox({\n                bind: 'isActive',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"supplier\", void 0);\n__decorate([\n    ui.decorators.linkField({\n        parent() {\n            return this.productBlock;\n        },\n        isTransient: true,\n        isTitleHidden: true,\n        size: 'small',\n        isFullWidth: true,\n        width: 'small',\n        map() {\n            return ui.localize('@sage/x3-purchasing/select-supplier-packing-slip', 'Add a supplier packing slip');\n        },\n        async onClick() {\n            this.supplierPackingSlip.isHidden = false;\n            this.supplierPackingSlipLink.isHidden = true;\n            this.supplierPackingSlip.focus();\n        },\n    })\n], MobilePurchaseReceipt.prototype, \"supplierPackingSlipLink\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplierPackingSlip____title\", \"Supplier packing slip\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplierPackingSlip____placeholder\", \"Scan or enter...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n        maxLength: 20,\n        isHidden: true,\n        onChange() {\n            if (this.supplierPackingSlip.value)\n                this.supplierPackingSlip.getNextField(true)?.focus();\n            if (this._purchaseSession) {\n                this._purchaseSession.purchaseReceipt.supplierPackingSlip = this.supplierPackingSlip.value ?? undefined;\n                this._purchaseReceiptRecordManager.purchaseSession = this._purchaseSession;\n            }\n        },\n    })\n], MobilePurchaseReceipt.prototype, \"supplierPackingSlip\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____title\", \"Product\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-purchasing/ProductSupplierView',\n        valueField: { product: true },\n        helperTextField: 'upc',\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: this.stockSite.value ?? undefined,\n                supplier: this.supplier.value?.code.code ?? undefined,\n                productStatus: 'active',\n                isReceived: { _eq: true },\n                _or: [\n                    { isPurchased: { _eq: true } },\n                    { isSubcontracted: { _eq: true } },\n                    { isService: { _eq: true } },\n                    { isPhantom: { _eq: true } },\n                    { isDeliverable: { _eq: true } },\n                    { isSold: { _eq: true } },\n                ],\n            };\n        },\n        onError(error, originScreenId, originElementId) {\n            ui.console.warn(`Error on ${originScreenId} ${originElementId}: ${error.message || error}`);\n        },\n        async onInputValueChange(rawData) {\n            await this.scanBarCode(this.productSupplier, rawData);\n        },\n        async onChange() {\n            await this._onChange_productSupplier();\n        },\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: true,\n        isDisabled: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__product\", \"Product\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'upc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__upc\", \"UPC\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'globalTradeItemNumber',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__globalTradeItemNumber\", \"GTIN\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'description1',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__description1\", \"Description\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierUpc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__supplierUpc\", \"Supplier UPC\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierProduct',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__supplierProduct\", \"Supplier product\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierProductDescription',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__supplierProductDescription\", \"Supplier product description\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productCategory',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__productCategory\", \"Product category\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isReceived',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isPurchased',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSubcontracted',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isService',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isPhantom',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isDeliverable',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSold',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"productSupplier\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____title\", \"Product\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-purchasing/PurchaseOrderQuantityLinesSupplierView',\n        valueField: { product: true },\n        helperTextField: { upc: true },\n        canFilter: false,\n        filter() {\n            return {\n                productStatus: 'active',\n                isReceived: { _eq: true },\n                _or: [\n                    { isIntersite: { _eq: true } },\n                    { isIntersite: { _eq: false }, isManufactured: { _eq: false } },\n                    { isIntersite: { _eq: false }, isPhantom: { _eq: false } },\n                ],\n                isClosed: { _eq: false },\n                sourceRequest: { _ne: 'directOrder' },\n                productType: { _ne: 'subcontract' },\n                lineType: 'normal',\n                receiptSite: this.stockSite.value ?? undefined,\n                purchaseOrder: this.purchaseOrder.value?.id,\n            };\n        },\n        onError(error, originScreenId, originElementId) {\n            console.warn(`Error on ${originScreenId} ${originElementId}: ${error.message || error}`);\n        },\n        async onInputValueChange(rawData) {\n            await this.scanBarCode(this.purchaseOrderLinesSupplier, rawData);\n        },\n        async onChange() {\n            await this._onChange_purchaseOrderLinesSupplier();\n        },\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: true,\n        isHidden: true,\n        isDisabled: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__product\", \"Product\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lineNumber',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__lineNumber\", \"Order line\"),\n                prefix: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__prefix__lineNumber\", \"Line no.\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierUpc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__supplierUpc\", \"Supplier upc\"),\n                isReadOnly: true,\n                canFilter: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria1, 'supplierUpcCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierProduct',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__supplierProduct\", \"Supplier product\"),\n                isReadOnly: true,\n                canFilter: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria1, 'supplierProductCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'upc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__upc\", \"UPC\"),\n                isReadOnly: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria1, 'x3UpcCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'globalTradeItemNumber',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__globalTradeItemNumber\", \"GTIN\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'description1',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__description1\", \"Description\"),\n                isReadOnly: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria1, 'x3ProductDescription');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierUpc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__supplierUpc__2\", \"Supplier upc\"),\n                isReadOnly: true,\n                canFilter: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria2, 'supplierUpcCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierProduct',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__supplierProduct__2\", \"Supplier product\"),\n                isReadOnly: true,\n                canFilter: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria2, 'supplierProductCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'upc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__upc__2\", \"UPC\"),\n                isReadOnly: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria2, 'x3UpcCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'description1',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__description1__2\", \"Description\"),\n                isReadOnly: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria2, 'x3ProductDescription');\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'purchaseUnitToStockUnitConversionFactor',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPurchaseUnitOrdered',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__quantityInPurchaseUnitOrdered\", \"Ordered qty\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPurchaseUnitReceived',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__quantityInPurchaseUnitReceived\", \"Received qty\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.label({\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title___id\", \"Ordered\"),\n                prefix: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__prefix___id\", \"Ordered\"),\n                isFullWidth: false,\n                postfix(value, rowData) {\n                    return rowData?.purchaseUnit;\n                },\n                isTitleHidden: false,\n                isTransient: true,\n                bind: '_id',\n                map(value, rowData) {\n                    return rowData.quantityInPurchaseUnitOrdered.toString();\n                },\n            }),\n            ui.nestedFields.label({\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title___id__2\", \"Expected\"),\n                prefix: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__prefix___id__2\", \"Expected\"),\n                isFullWidth: false,\n                postfix(value, rowData) {\n                    return rowData?.purchaseUnit;\n                },\n                isTitleHidden: false,\n                isTransient: true,\n                bind: '_id',\n                isHidden: false,\n                map(value, rowData) {\n                    let quantityInPurchaseUnitReceived = 0;\n                    let quantityInPurchaseUnitToReceive = typesLib.max(typesLib.sub(Number(rowData.quantityInPurchaseUnitOrdered), Number(rowData.quantityInPurchaseUnitReceived)), 0);\n                    if (this._purchaseSession?.purchaseReceipt?.lines) {\n                        this._purchaseSession?.purchaseReceipt?.lines\n                            .filter((line) => typesLib.strictEq(line.purchaseOrder, rowData.purchaseOrder) && typesLib.strictEq(Number(line.purchaseOrderLineNumber), Number(rowData.lineNumber)) && typesLib.strictEq(line.product, rowData.product))\n                            .map((line) => (quantityInPurchaseUnitReceived = typesLib.add(quantityInPurchaseUnitReceived, typesLib.div((typesLib.mul(Number(line.quantityInReceiptUnitReceived), Number(line.receiptUnitToStockUnitConversionFactor))), rowData.purchaseUnitToStockUnitConversionFactor))));\n                        if (typesLib.gt(quantityInPurchaseUnitReceived, 0)) {\n                            quantityInPurchaseUnitToReceive = typesLib.max(typesLib.sub(typesLib.sub(Number(rowData.quantityInPurchaseUnitOrdered), Number(rowData.quantityInPurchaseUnitReceived)), Number(quantityInPurchaseUnitReceived)), 0);\n                        }\n                    }\n                    return Number.isInteger(Number(quantityInPurchaseUnitToReceive))\n                        ? quantityInPurchaseUnitToReceive.toString()\n                        : quantityInPurchaseUnitToReceive.toFixed(QTY_DECIMAL_PLACES);\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'sequenceNumber',\n                isTitleHidden: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'purchaseUnit',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isReceived',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isIntersite',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isManufactured',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isPhantom',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isClosed',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sourceRequest',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'workInProgressStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productType',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lineType',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'receiptSite',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'purchaseOrder',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"purchaseOrderLinesSupplier\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.receiptBlock;\n        },\n        //title: 'Product(s)',\n        isTitleHidden: true,\n        isTransient: true,\n        canSelect: false,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____columns__title__product\", \"Product\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'quantityAndStockUnit',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____columns__title__quantityAndStockUnit\", \"Quantity\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'purchaseOrderLineNumber',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____columns__title__purchaseOrderLineNumber\", \"Line No.\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'purchaseShipment',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____columns__title__purchaseShipment\", \"Shipment\"),\n                isReadOnly: true,\n            }),\n        ],\n        dropdownActions: [\n            {\n                icon: 'delete',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____dropdownActions__title\", \"Delete\"),\n                async onClick(rowId, data) {\n                    this._purchaseSession?.purchaseReceipt?.lines?.splice(rowId, 1);\n                    if (!this._purchaseSession?.purchaseReceipt?.lines?.length) {\n                        this._purchaseReceiptRecordManager.clearSession();\n                        this.createButton.isDisabled = true;\n                        (0, on_goto_1.onGoto)(this, `@sage/x3-purchasing/${this.$.page.id}`);\n                    }\n                    else {\n                        this.receiptToCreate.value = await this._mapPurchaseReceipt(this._purchaseSession.purchaseReceipt.lines ?? []);\n                        // don't forget to update session storage or deleted lines will reappear if user refreshes the page\n                        this._purchaseReceiptRecordManager.purchaseSession = {\n                            purchaseEntryTransaction: this._purchaseSession.purchaseEntryTransaction,\n                            purchaseReceipt: this._purchaseSession.purchaseReceipt,\n                            orderUnitToPurchaseUnitConversionFactor: 1,\n                        };\n                    }\n                },\n            },\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"receiptToCreate\", void 0);\nexports.MobilePurchaseReceipt = MobilePurchaseReceipt = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt____title\", \"Purchase receipt\"),\n        module: 'x3-purchasing',\n        mode: 'default',\n        menuItem: receipt_1.receipt,\n        priority: 100,\n        isTransient: true,\n        isTitleHidden: true,\n        authorizationCode: 'CWSPTH',\n        access: { node: '@sage/x3-purchasing/PurchaseReceipt' },\n        async onLoad() {\n            if (!(await this._init())) {\n                this._disablePage();\n            }\n        },\n        businessActions() {\n            return [this.createButton];\n        },\n    })\n], MobilePurchaseReceipt);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-purchase-receipt.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts":
/*!***********************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getSelectedStockSite = void 0;\nconst dialogs_1 = __webpack_require__(/*! ./dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\n/**\n * Return selected stock site for current application\n * @param pageInstance Current page instance\n * @param errorTitle error title when no default site exist\n * @param errorMessage error message when no default site exist\n * @returns default site or null\n */\nasync function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {\n    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');\n    if (!selectedSite) {\n        // Please note that there asynchronous processing is not prefixed by an await on purpose\n        // so that it can be processed in parallel and not block the main process.\n        // Be careful not to leave the current page before the user has closed this dialog box.\n        pageInstance.$.sound.error();\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);\n        return null;\n    }\n    else {\n        return selectedSite.toString();\n    }\n}\nexports.getSelectedStockSite = getSelectedStockSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/on-goto.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/on-goto.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.onGoto = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * This allow to change page delayed\n * @param pageInstance current page instance\n * @param address page url\n * @param parameters optional parameters\n *\n */\n/** @internal */\nfunction onGoto(pageInstance, address, parameters) {\n    setTimeout(() => {\n        try {\n            pageInstance.$.removeToasts();\n            pageInstance.$.setPageClean();\n            pageInstance.$.router.goTo(address, parameters);\n        }\n        catch (error) {\n            ui.console.error(`Router goto failure :\\n${JSON.stringify(error) ?? ''}`);\n        }\n    }, 100);\n}\nexports.onGoto = onGoto;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL29uLWdvdG8udHMiLCJtYXBwaW5ncyI6Ijs7O0FBQUEsdUVBQXFDO0FBRXJDOzs7Ozs7R0FNRztBQUNILGdCQUFnQjtBQUNoQixTQUFnQixNQUFNLENBQUMsWUFBcUIsRUFBRSxPQUFlLEVBQUUsVUFBZ0I7SUFDM0UsVUFBVSxDQUFDLEdBQUcsRUFBRTtRQUNaLElBQUksQ0FBQztZQUNELFlBQVksQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDOUIsWUFBWSxDQUFDLENBQUMsQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUM5QixZQUFZLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQ3BELENBQUM7UUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1lBQ2IsRUFBRSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsMEJBQTBCLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM5RSxDQUFDO0lBQ0wsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0FBQ1osQ0FBQztBQVZELHdCQVVDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvb24tZ290by50cz8zYzdmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcblxuLyoqXG4gKiBUaGlzIGFsbG93IHRvIGNoYW5nZSBwYWdlIGRlbGF5ZWRcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcGFyYW0gYWRkcmVzcyBwYWdlIHVybFxuICogQHBhcmFtIHBhcmFtZXRlcnMgb3B0aW9uYWwgcGFyYW1ldGVyc1xuICpcbiAqL1xuLyoqIEBpbnRlcm5hbCAqL1xuZXhwb3J0IGZ1bmN0aW9uIG9uR290byhwYWdlSW5zdGFuY2U6IHVpLlBhZ2UsIGFkZHJlc3M6IHN0cmluZywgcGFyYW1ldGVycz86IGFueSk6IHZvaWQge1xuICAgIHNldFRpbWVvdXQoKCkgPT4ge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgcGFnZUluc3RhbmNlLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgICAgICBwYWdlSW5zdGFuY2UuJC5zZXRQYWdlQ2xlYW4oKTtcbiAgICAgICAgICAgIHBhZ2VJbnN0YW5jZS4kLnJvdXRlci5nb1RvKGFkZHJlc3MsIHBhcmFtZXRlcnMpO1xuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgUm91dGVyIGdvdG8gZmFpbHVyZSA6XFxuJHtKU09OLnN0cmluZ2lmeShlcnJvcikgPz8gJyd9YCk7XG4gICAgICAgIH1cbiAgICB9LCAxMDApO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/on-goto.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/management-service-gs-1.ts":
/*!******************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/management-service-gs-1.ts ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ManagementServiceGs1 = exports.errorMessageError = exports.errorMessageCheckYourEntry = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst barcode_parser_1 = __webpack_require__(/*! ../shared-functions/barcode-parser */ \"../../shared/x3-system/lib/shared-functions/barcode-parser.ts\");\nconst screen_management_gs_1_1 = __webpack_require__(/*! ./screen-management-gs-1 */ \"../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts\");\nexports.errorMessageCheckYourEntry = `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`;\nexports.errorMessageError = 'Error';\nclass ManagementServiceGs1 {\n    /**\n     * Initialize permanent data for page\n     * @param _storageKey       : storage key used for this page\n     */\n    constructor(_storageKey) {\n        this._storageKey = _storageKey;\n        // Private data area\n        /**\n         *  Store all codes GS 1 supported by access code (for speedup decoding)\n         */\n        /** @internal */\n        this._screenFieldsSupported = [];\n        /** @internal */\n        this._dictionarySegment = {};\n        /** @internal */\n        this._screenFieldsMapped = [];\n        /** @internal */\n        this._dictionaryDataComposites = {};\n        /** @internal */\n        this._abortDispatch = false;\n        /** @internal */\n        this._dispatchInProgress = false;\n        /** @internal */\n        this._initializationInProgress = false;\n        this._parseBarCode = new barcode_parser_1.ParseBarCode();\n    }\n    /**\n     * This Method build instance with retrieving all data\n     * @param pageInstance : current page\n     * @param dictionaryFieldSupported : page fields supported\n     * @param dictionaryDataComposites : extracted composite data, may be send to storage\n     * @param checkCompositeDataAllowed? : optional client callback to check composite data code before to dispatch them\n     */\n    async initialize(pageInstance, dictionaryFieldSupported = {}, dictionaryDataComposites = {}, checkCompositeDataAllowed) {\n        if (!pageInstance || !this._storageKey) {\n            throw new xtrem_shared_1.SystemError('Invalid arguments');\n        }\n        try {\n            this._dispatchInProgress = false;\n            this._initializationInProgress = true;\n            this._checkCompositeDataAllowed = checkCompositeDataAllowed;\n            // ui.console.warn(`Field(s) supported :\\n${JSON.stringify(dictionaryFieldSupported)}`);\n            // ui.console.warn(`Composite data :\\n${JSON.stringify(dictionaryDataComposites)}`);\n            // Process composite data before to continue\n            if (typesLib.gt(Object.keys(dictionaryDataComposites ?? {}).length, 0)) {\n                this.clearCompositeData();\n                // Erase storage\n                this._removeCompositeDataStorage(pageInstance);\n                this._dictionaryDataComposites = dictionaryDataComposites ?? {};\n            }\n            else {\n                this.loadCompositeData(pageInstance);\n            }\n            if (typesLib.gt(Object.keys(dictionaryFieldSupported ?? {}).length, 0)) {\n                await this.setScreenFieldSupported(pageInstance, dictionaryFieldSupported ?? {});\n                // mapped data has not deleted after dispatching\n                if (this.isExistsDataComposite && this.isExistsFieldsMapped) {\n                    if (this._beginDispatching()) {\n                        try {\n                            // use existing first segment field, temporary ignoring result\n                            const results = (await this._dispatchDataToFields(pageInstance, this._screenFieldsMapped[0].mainField, false).catch(() => false));\n                        }\n                        catch (error) {\n                            ui.console.error(`Error dispatching initial data :\\n${error}`);\n                        }\n                        finally {\n                            this._endingDispatching();\n                        }\n                    }\n                }\n            }\n        }\n        catch (error) {\n            ui.console.error(`Unexpected initialization error :\\n${error}`);\n        }\n        finally {\n            this._initializationInProgress = false;\n        }\n        return true;\n    }\n    /**\n     * Return if dispatch session is in progress\n     */\n    get isDispatchInProgress() {\n        return this._dispatchInProgress;\n    }\n    /**\n     * Return if initialization is in progress\n     */\n    get isInitializationInProgress() {\n        return this._initializationInProgress;\n    }\n    /**\n     * This function start dispatching\n     * @returns true when a new session has started, false when already in progress\n     */\n    /** @internal */\n    _beginDispatching() {\n        const oldDispatchInProgress = this._dispatchInProgress;\n        this._dispatchInProgress = true;\n        this._abortDispatch = false;\n        this._postActionAbortDispatch = undefined;\n        return !oldDispatchInProgress;\n    }\n    /**\n     * Terminate current dispatch session\n     * @returns true when session has been terminated, false when non session exist\n     */\n    /** @internal */\n    _endingDispatching() {\n        const oldDispatchInProgress = this._dispatchInProgress;\n        this._dispatchInProgress = false;\n        this._abortDispatch = false;\n        this._postActionAbortDispatch = undefined;\n        return oldDispatchInProgress;\n    }\n    /**\n     * Request to abort dispatch without error (end of scan) :\n     * This is used only when onChange() has performed some operations,\n     * ie : switching page... except when initialization is in progress\n     * @param {function}    optional callback to be executed approx. 100ms after end of dispatching.\n     * @returns {boolean}   true when request has be set\n     */\n    abortDispatch(postActionAbortDispatch) {\n        this._abortDispatch = false;\n        this._postActionAbortDispatch = undefined;\n        if (this._dispatchInProgress) {\n            this._abortDispatch = true;\n            if (!this.isInitializationInProgress) {\n                this._postActionAbortDispatch = postActionAbortDispatch;\n            }\n        }\n        return this.isAbortDispatchInProgress;\n    }\n    /**\n     * Return if abort dispatch session is requested\n     */\n    get isAbortDispatchInProgress() {\n        return this._abortDispatch;\n    }\n    /**\n     * Called when field update is in progress\n     * @param pageInstance current page\n     * @param currentField reference of field to updating\n     * @param rawData received raw data\n     * @param appendCompositeData true when is necessary to appending current date to previous set\n     * @return true when is not necessary to continue and affect a value : composite value has been processed\n     */\n    async scan(pageInstance, currentField, rawData, appendCompositeData = false) {\n        if (this._beginDispatching()) {\n            try {\n                let result = true;\n                // when is not a composite data, is not necessary to process\n                if (!rawData || typesLib.strictNe(typeof rawData, 'string') || typesLib.lt(rawData.length, 4) ||\n                    !Number(rawData.match(screen_management_gs_1_1.compositeCodePrefix)?.length) ||\n                    !(await this._decodeCompositeData(rawData, appendCompositeData))) {\n                    this._endingDispatching();\n                    return false;\n                }\n                // When composite data have skipped, nothing to do, report no errors\n                if (this.isExistsDataComposite) {\n                    let _postActionToDo;\n                    const _soundOriginalValue = await this._setSoundField(pageInstance, currentField, true);\n                    try {\n                        result = (await this._dispatchDataToFields(pageInstance, currentField).catch(() => false));\n                        // Special action to do after exiting a function\n                        if (result && this.isAbortDispatchInProgress && this._postActionAbortDispatch) {\n                            _postActionToDo = this._postActionAbortDispatch;\n                        }\n                    }\n                    finally {\n                        setTimeout(async () => {\n                            try {\n                                await this._setSoundField(pageInstance, currentField, _soundOriginalValue);\n                                if (_postActionToDo)\n                                    await _postActionToDo();\n                            }\n                            catch (error) {\n                                ui.console.error(`Dispatching post done action error :\\n${error}`);\n                            }\n                        }, 100);\n                    }\n                }\n                else {\n                    await this._clearField(pageInstance, currentField);\n                }\n                return result;\n            }\n            catch (error) {\n                ui.console.error(`Dispatching error :${error}`);\n            }\n            finally {\n                this._endingDispatching();\n            }\n        }\n        ui.console.error(`Dispatching not available`);\n        return false;\n    }\n    /**\n     * returns if the field support sound management\n     * @param originalField\n     * @returns\n     */\n    /** @internal */\n    _getIsSupportedSoundField(currentField) {\n        return currentField instanceof ui.fields.Reference || currentField instanceof ui.fields.FilterSelect;\n    }\n    /**\n     * When possible, changes the sound mode activation state and returns the old value\n     * @param currentField current field or undefined\n     * @param disableSound true for disable sound for this field\n     * @returns old value\n     */\n    /** @internal */\n    async _setSoundField(pageInstance, currentField, disableSound, refreshField = true) {\n        const originalIsSoundDisabled = currentField?.isSoundDisabled ?? false;\n        if (currentField && typesLib.strictNe(disableSound, originalIsSoundDisabled) && this._getIsSupportedSoundField(currentField)) {\n            currentField.isSoundDisabled = disableSound;\n            if (refreshField) {\n                await pageInstance.$.commitValueAndPropertyChanges();\n            }\n        }\n        return originalIsSoundDisabled;\n    }\n    /**\n     * Clear current UI field with null value and update page.\n     * @param pageInstance current page\n     * @param currentField current field to clear\n     * @param setFocus optional value must be true when focus must be performed in reInitializing\n     */\n    /** @internal */\n    async _clearField(pageInstance, currentField, setFocus = true) {\n        currentField.value = null;\n        // Request all changes to page (optional field and unit) before any action\n        await pageInstance.$.commitValueAndPropertyChanges();\n        if (setFocus) {\n            currentField.focus();\n        }\n        // Force validation\n        await currentField.validate().catch(() => false);\n    }\n    /**\n     * Decode raw data to one or more data fields\n     * @param rawData raw composite data before decoding\n     * @param appendCompositeData may apply only when valid received data must be replace or append\n     * @returns true when data has valid and operation fully performed\n     */\n    /** @internal */\n    async _decodeCompositeData(rawData, appendCompositeData = false) {\n        const extractedComposite = {};\n        ui.console.debug(`initial data raw : ${JSON.stringify(rawData)}, size : ${rawData.length}`);\n        let parsedBarcode;\n        try {\n            parsedBarcode = this._parseBarCode.parseBarcode(rawData);\n            ui.console.debug(`RawData :\\n${rawData}\\nParsed code(s) :\\n${JSON.stringify(parsedBarcode)}`);\n        }\n        catch (error) {\n            ui.console.debug(`ERROR in parseBarcode :\\n${error}`);\n            return false;\n        }\n        /**\n         * When the block does not include a prefix or when it is not recognized by the parser,\n         * the GS1 composite code block requires in this case more than one AI code to be considered,\n         * as a single value could be incorrectly considered composite.\n         */\n        if (!parsedBarcode.parsedCodeItems.length ||\n            (typesLib.lt(parsedBarcode.parsedCodeItems.length, 2) && typesLib.strictEq(parsedBarcode.codeName, ''))) {\n            return false;\n        }\n        // Store data into composite data storage\n        for (const parsedCodeItem of parsedBarcode.parsedCodeItems) {\n            // Add a new data entry\n            extractedComposite[parsedCodeItem.elementDataTitle] = {\n                DataTitle: parsedCodeItem.elementDataTitle,\n                data: parsedCodeItem.data,\n                unit: parsedCodeItem.unit,\n            };\n        }\n        // ui.console.warn(`composite data existing : ${JSON.stringify(this._dictionaryDataComposites)}`);\n        // ui.console.warn(`composite data loaded : ${JSON.stringify(extractedComposite)}`);\n        // Dictionary update\n        if (!appendCompositeData) {\n            this.clearCompositeData();\n            this._dictionaryDataComposites = extractedComposite;\n        }\n        else {\n            for (const [key, value] of Object.entries(extractedComposite)) {\n                this._dictionaryDataComposites[key] = value;\n            }\n        }\n        // ui.console.debug(`composite data updated : ${JSON.stringify(this._dictionaryDataComposites)}`);\n        // before to map, check if allowed\n        if (!(await this._isDataCompositeAllowed())) {\n            this.clearCompositeData();\n            return true;\n        }\n        // mapping composite data to dataField without checking error condition\n        this._mappingFields();\n        // Sometimes no data is stored due to inactive code, this is not an error\n        return true;\n    }\n    /**\n     * Check if exists some fields loaded into service\n     */\n    get isExistsFieldsSupported() {\n        return typesLib.gt(Object.keys(this._screenFieldsSupported).length, 0);\n    }\n    /**\n     * Check if exists some fields mapped into service,\n     * ready to dispatch\n     */\n    get isExistsFieldsMapped() {\n        return typesLib.gt(this._screenFieldsMapped.length, 0);\n    }\n    /**\n     *\n     * @returns true when some composite data have been stored.\n     */\n    get isExistsDataComposite() {\n        return typesLib.gt(Object.keys(this._dictionaryDataComposites).length, 0);\n    }\n    /**\n     *\n     * @param field check current field is available\n     * @returns true if not available\n     */\n    /** @internal */\n    _isFieldNotAvailable(field) {\n        return (field?.isHidden || field?.isDisabled || field?.isReadOnly) ?? true;\n    }\n    /**\n     * @returns cloned dictionary data composite (must be empty)\n     */\n    /** @internal */\n    _cloneDictionaryDataComposite() {\n        const dictionaryDataComposite = {};\n        for (const [key, value] of Object.entries(this._dictionaryDataComposites)) {\n            dictionaryDataComposite[key] = value;\n        }\n        return dictionaryDataComposite;\n    }\n    /**\n     * Process client callback when exists to check data\n     * @returns Checks if the composite dataset can be processed\n     */\n    /** @internal */\n    async _isDataCompositeAllowed() {\n        // If any error occurs, the composite data block will be processed\n        try {\n            if (this._checkCompositeDataAllowed &&\n                this.isExistsDataComposite &&\n                !(await this._checkCompositeDataAllowed(this._cloneDictionaryDataComposite()))) {\n                return false;\n            }\n        }\n        catch (error) {\n            ui.console.error(`Error when evaluating data composite condition is allowed :\\n${error}`);\n        }\n        return true;\n    }\n    /**\n     * Update screen fields supported.\n     * field mapping was done after\n     * @param pageInstance current page\n     * @param dictionaryFieldSupported dictionary of page fields submitted\n     * @returns true when done, false when no any field to process with data\n     */\n    async setScreenFieldSupported(pageInstance, dictionaryFieldSupported) {\n        // Get only fields matching with active parameters\n        let index = 0;\n        const lastInitializationInProgress = this.isInitializationInProgress;\n        try {\n            this._initializationInProgress = true;\n            this._screenFieldsSupported =\n                this._existingFields(pageInstance, dictionaryFieldSupported).map(field => {\n                    const segmentsSupported = [];\n                    // Create segments allowed\n                    field.segments.forEach(segment => {\n                        const currentField = segment.currentField;\n                        segmentsSupported.push({\n                            currentField: currentField,\n                            onChange: segment.onChange,\n                        });\n                    });\n                    return {\n                        DataTitle: field.DataTitle,\n                        sequence: (index = typesLib.add(index, 1)),\n                        segments: segmentsSupported,\n                    };\n                }) ?? [];\n            // ui.console.debug(`Fields supported into page : ${JSON.stringify(this._screenFieldsSupported)}`);\n            // Map fields with existing composite data\n            return this._mappingFields();\n        }\n        catch (error) {\n            ui.console.error(`Error in setScreenFieldSupported :\\n${error}`);\n            return false;\n        }\n        finally {\n            this._initializationInProgress = lastInitializationInProgress;\n        }\n    }\n    /**\n     * This function map current fields with set of data\n     * @returns true when exists some fields with data mapped\n     */\n    /** @internal */\n    _mappingFields() {\n        // ui.console.debug(`Starting mapping, composite data : ${JSON.stringify(this._dictionaryDataComposites)}`);\n        // ui.console.debug(`Screen field(s) supported : ${JSON.stringify(this._screenFieldsSupported)}`);\n        // Extract active field\n        this._screenFieldsMapped = [];\n        let index = 0;\n        const mappingFields = [];\n        // No process only hidden fields\n        this._screenFieldsSupported\n            .filter(field => this._dictionaryDataComposites[field.DataTitle] &&\n            !field.segments.some(segment => segment.currentField.isHidden))\n            .sort((field1, field2) => typesLib.sub(field1.sequence, field2.sequence))\n            .forEach(item => {\n            const dataFieldMapped = {\n                DataTitle: item.DataTitle,\n                sequence: (index = typesLib.add(index, 1)),\n                mainField: item.segments[0].currentField,\n                onChangeMainField: item.segments[0].onChange,\n                data: this._dictionaryDataComposites[item.DataTitle]?.data,\n            };\n            // Add optional part\n            if (typesLib.gt(item.segments.length, 1) && item.segments[1]?.currentField) {\n                dataFieldMapped.unitField = item.segments[1].currentField;\n                dataFieldMapped.onChangeUnitField = item.segments[1].onChange;\n                dataFieldMapped.unit = this._dictionaryDataComposites[item.DataTitle]?.unit;\n            }\n            mappingFields.push(dataFieldMapped);\n        });\n        this._screenFieldsMapped = mappingFields;\n        // ui.console.debug(`Field(s) Mapped : ${JSON.stringify(this._screenFieldsMapped)}`);\n        return typesLib.gt(this._screenFieldsMapped.length, 0);\n    }\n    /**\n     * Remove fields definition\n     * @param removeCompositeData  : optionally remove composite data too\n     */\n    clearScreenFields(removeCompositeData = false) {\n        this._screenFieldsSupported = [];\n        this._screenFieldsMapped = [];\n        if (removeCompositeData) {\n            this.clearCompositeData();\n        }\n    }\n    /**\n     * Remove composite data\n     */\n    clearCompositeData() {\n        this._dictionaryDataComposites = {};\n    }\n    /**\n     * Remove composite data from storage\n     * @param pageInstance current page\n     * @param storageKey optional, for overriding current service key (use with caution)\n     */\n    clearCompositeDataStorage(pageInstance, storageKey) {\n        this._removeCompositeDataStorage(pageInstance, storageKey);\n    }\n    /**\n     * Remove all composite and storage data\n     * @param pageInstance current page\n     * @param storageKey optional, for overriding current service key (use with caution)\n     */\n    clearAllCompositeDataAndStorage(pageInstance, storageKey) {\n        this.clearCompositeData();\n        this.clearCompositeDataStorage(pageInstance, storageKey);\n    }\n    /**\n     * Load composite data from storage and then delete it there.\n     * @returns true when some data has been loaded\n     */\n    loadCompositeData(pageInstance) {\n        this.clearCompositeData();\n        try {\n            const dictionaryDataComposites = JSON.parse((pageInstance.$.storage.get(this._storageKey) ?? '{}'));\n            // ui.console.warn(`Composite data loaded :\\n${JSON.stringify(dictionaryDataComposites)}`);\n            // Erase storage\n            this._removeCompositeDataStorage(pageInstance);\n            if (typesLib.gt(Object.keys(dictionaryDataComposites).length, 0)) {\n                this._dictionaryDataComposites = dictionaryDataComposites;\n                // ui.console.warn(`Assigned :\\n${JSON.stringify(this._dictionaryDataComposites)}`);\n                return true;\n            }\n        }\n        catch (error) {\n            this.clearCompositeData();\n            this._removeCompositeDataStorage(pageInstance);\n            ui.console.error(`Error loading composite data from storage :\\n${error}`);\n        }\n        // ui.console.error(`No composite data`);\n        return this.isExistsDataComposite;\n    }\n    /**\n     * Save composite data, zero elements allowed\n     * @param pageInstance current page\n     * @returns true when operation has performed\n     */\n    saveCompositeData(pageInstance) {\n        if (pageInstance && this._storageKey && this.isExistsDataComposite) {\n            const dictionaryDataComposites = this._dictionaryDataComposites;\n            pageInstance.$.storage.set(this._storageKey, JSON.stringify(dictionaryDataComposites));\n            return true;\n        }\n        if (pageInstance) {\n            this._removeCompositeDataStorage(pageInstance);\n        }\n        return false;\n    }\n    /**\n     * Remove data from the storage\n     * @param pageInstance current page\n     */\n    /** @internal */\n    _removeCompositeDataStorage(pageInstance, storageKey) {\n        const isDataStorage = !!pageInstance && (!!this._storageKey || !!storageKey);\n        if (isDataStorage) {\n            pageInstance.$.storage.remove(storageKey ?? this._storageKey);\n        }\n        return isDataStorage;\n    }\n    /**\n     * assign date to page fields when existing and available\n     * @param pageInstance current page\n     * @param originalField original field (reserved)\n     * @param setFocus optional value must be true when focus must be performed in reInitializing\n     * @returns false when dispatching failure occurs\n     */\n    /** @internal */\n    async _dispatchDataToFields(pageInstance, originalField, setFocus = false) {\n        const $items = pageInstance?._pageMetadata.layout.$items ?? [];\n        let isFailure = false;\n        let isOneFieldProcessed = false;\n        // ui.console.debug('Starting dispatching all fields');\n        if (typesLib.gt($items?.length, 0) && this.isExistsDataComposite) {\n            for (const field of this._screenFieldsMapped) {\n                if (field?.data) {\n                    if ((isFailure = !(await this._processField(pageInstance, field, setFocus).catch(() => false)))) {\n                        // ui.console.error(`Dispatching error, composite data has cleared`);\n                        this.clearCompositeData();\n                        break;\n                    }\n                    else {\n                        isOneFieldProcessed = true;\n                    }\n                }\n            }\n        }\n        // If no composite data could be assigned, it is an error\n        if (!isFailure && !isOneFieldProcessed) {\n            isFailure = true;\n            this.clearCompositeData();\n            this._clearField(pageInstance, originalField, setFocus);\n            ui.console.error(`Composite data was removed because none could be assigned, and field ${originalField?.id} was reset`);\n        }\n        // ui.console.debug(`Ending dispatching all fields : ${!isFailure}`);\n        return !isFailure;\n    }\n    /**\n     *\n     * @param pageInstance current page\n     * @param field current field already evaluated\n     * @param setFocus optional value must be true when focus must be performed in reInitializing\n     * @returns true when item has found, but updated only when available\n     */\n    /** @internal */\n    async _processField(pageInstance, field, setFocus = false) {\n        const fieldsToRevalidate = [];\n        const onChangeCallbacks = [];\n        const mainField = field?.mainField;\n        const mainFieldId = mainField?.id ?? '';\n        const unitField = field?.unitField;\n        const unitFieldId = unitField?.id ?? '';\n        let validation = true;\n        let mainSoundOriginalValue = false;\n        let unitSoundOriginalValue = undefined;\n        try {\n            // process all subFields (segments) requested (main and optional unit)\n            // ui.console.debug(`_ProcessField (mapped fields) :\\n${JSON.stringify(field)}`);\n            // current field not currently available : don't process this field\n            if (!mainField || this._isFieldNotAvailable(mainField)) {\n                // ui.console.error(`Field ${mainFieldId} has unavailable`);\n                return true;\n            }\n            if (field?.data) {\n                if (unitField && field?.unit && this._isFieldNotAvailable(unitField)) {\n                    // ui.console.error(`Unit field ${unitFieldId} has unavailable`);\n                    return true;\n                }\n                mainSoundOriginalValue = await this._setSoundField(pageInstance, mainField, true);\n                // If not possible to change a value, composite block is invalid\n                switch (await this._setFieldValue(pageInstance, mainField, field?.data, setFocus)) {\n                    case null:\n                        // ui.console.warn(`Field ${mainFieldId} has no data available`);\n                        return false;\n                    case true:\n                        fieldsToRevalidate.push(mainField);\n                        if (field?.onChangeMainField) {\n                            onChangeCallbacks.push([mainFieldId, field.onChangeMainField]);\n                        }\n                        break;\n                }\n                // Process optional unit available with data\n                if (unitField && field?.unit && !this._isFieldNotAvailable(unitField)) {\n                    unitSoundOriginalValue = await this._setSoundField(pageInstance, unitField, true);\n                    switch (await this._setFieldValue(pageInstance, unitField, field.unit)) {\n                        case null:\n                            // ui.console.warn(`Unit field ${unitFieldId} has no data available`);\n                            return false;\n                        case true:\n                            fieldsToRevalidate.push(unitField);\n                            if (field?.onChangeUnitField) {\n                                onChangeCallbacks.push([unitFieldId, field.onChangeUnitField]);\n                            }\n                            break;\n                    }\n                }\n                // Request all changes to page (optional field and unit) before any action\n                await pageInstance.$.commitValueAndPropertyChanges();\n                // We only process with the case of modified fields\n                if (fieldsToRevalidate.length) {\n                    // Now process change / validation field segments\n                    for (const onChangeCallback of onChangeCallbacks) {\n                        const fieldId = onChangeCallback[0];\n                        const onChange = onChangeCallback[1];\n                        try {\n                            await onChange();\n                        }\n                        catch (error) {\n                            throw new xtrem_shared_1.SystemError(`onChange failure on field ${fieldId} :\\n${JSON.stringify(error)}`, error);\n                        }\n                        if (this.isAbortDispatchInProgress) {\n                            // ui.console.warn(`Aborting dispatching in progress for field ${fieldId}`);\n                            break;\n                        }\n                    }\n                    // CAUTION: when aborting is in progress, context may be invalid :\n                    // This behavior is taken into account by the possibility of abandoning dispatching,\n                    // and possibly executing a postDone action at the end. If possible, this action should\n                    // avoid being asynchronous for this reason.\n                    if (!this.isAbortDispatchInProgress) {\n                        // If we have performed at least one change action, we redo a commit of the page\n                        if (onChangeCallbacks.length) {\n                            await pageInstance.$.commitValueAndPropertyChanges();\n                        }\n                        // ui.console.debug(`Starting Validation`);\n                        for (const fieldToValidate of fieldsToRevalidate) {\n                            validation &&= (await fieldToValidate\n                                .validate()\n                                .then(data => typesLib.strictEq(data, undefined))\n                                .catch(() => false));\n                            if (!validation) {\n                                ui.console.warn(`Validation failure on field : ${fieldToValidate.id}`);\n                                break;\n                            }\n                        }\n                    }\n                }\n            }\n        }\n        catch (error) {\n            ui.console.error(`Error dispatching ${mainFieldId} :\\n${error?.message}`);\n            return false;\n        }\n        finally {\n            let isChanged = typesLib.strictNe((await this._setSoundField(pageInstance, mainField, mainSoundOriginalValue, false)), mainSoundOriginalValue);\n            if (typesLib.strictNe(unitSoundOriginalValue, undefined)) {\n                isChanged ||= typesLib.strictNe((await this._setSoundField(pageInstance, unitField, unitSoundOriginalValue, false)), unitSoundOriginalValue);\n            }\n            if (isChanged) {\n                await pageInstance.$.commitValueAndPropertyChanges();\n            }\n        }\n        return validation;\n    }\n    /**\n     * Assign value to field\n     * @param field current field\n     * @param value value to assign in the field\n     * @param setFocus optional value must be true when focus must be performed in reInitializing\n     * @return false if field has reinitialized, null when no change has performed (to more results)\n     */\n    /** @internal */\n    async _setFieldValue(pageInstance, field, value, setFocus = true) {\n        const originalValue = field.value;\n        let newValue;\n        if (field instanceof ui.fields.Reference) {\n            const result = await field.fetchSuggestions(value);\n            // We only update if there is a result otherwise the value will remain unchanged\n            if (!result.length) {\n                await pageInstance.$.sound.error();\n                await this._clearField(pageInstance, field, setFocus);\n                return false;\n            }\n            else {\n                newValue = result[0];\n                await pageInstance.$.sound.success();\n                if (typesLib.strictEq(result.length, 1)) {\n                    await pageInstance.$.sound.success();\n                }\n                else {\n                    /* Duplicate not supported, keep first result */\n                    await pageInstance.$.sound.success();\n                }\n            }\n        }\n        else if (field instanceof ui.fields.FilterSelect) {\n            newValue = value;\n        }\n        else if (field instanceof ui.fields.Text) {\n            newValue = String(value);\n        }\n        else if (field instanceof ui.fields.Numeric) {\n            newValue = Number(value);\n        }\n        else if (field instanceof ui.fields.Date) {\n            newValue = value instanceof xtrem_date_time_1.DateValue ? value.toString() : value;\n        }\n        else {\n            newValue = value;\n        }\n        field.value = newValue;\n        const isChanged = typesLib.strictNe(originalValue, newValue);\n        if (isChanged && !field.isDirty) {\n            field.isDirty = true;\n        }\n        return isChanged;\n    }\n    /**\n     * Convert a user field submitted by full segment reference before evaluation.\n     * @param dictionaryFieldsToPrepare fields to check to put in dictionary\n     * @returns Screen fields supported for internal use\n     */\n    /** @internal */\n    _prepareSegment(dictionaryFieldsToPrepare) {\n        // Reset internal dictionary\n        this._dictionarySegment = {};\n        const screenFieldsSupported = [];\n        for (const [key, field] of Object.entries(dictionaryFieldsToPrepare)) {\n            if (field) {\n                const screenFieldSupported = {\n                    DataTitle: key,\n                    sequence: -1,\n                    segments: [],\n                };\n                const mainField = field.mainField;\n                // Create directory entry now\n                screenFieldSupported.segments.push((this._dictionarySegment[mainField.id] = {\n                    currentField: mainField,\n                    onChange: field.onChangeMainField,\n                    sequence: -2,\n                }));\n                // Add unit too\n                const unitField = field.unitField;\n                if (unitField) {\n                    screenFieldSupported.segments.push((this._dictionarySegment[unitField.id] = {\n                        currentField: unitField,\n                        onChange: field.onChangeUnitField,\n                        sequence: -3,\n                    }));\n                }\n                screenFieldsSupported.push(screenFieldSupported);\n            }\n        }\n        return screenFieldsSupported;\n    }\n    /**\n     *  Analyze all fields existing\n     * @param pageInstance current page\n     * @param dictionaryFieldToCheck\n     * @returns\n     */\n    /** @internal */\n    _existingFields(pageInstance, dictionaryFieldToCheck) {\n        const $items = pageInstance?._pageMetadata.layout.$items ?? [];\n        const preparedFields = this._prepareSegment(dictionaryFieldToCheck);\n        const selectedFields = [];\n        const dictionarySegment = this._dictionarySegment;\n        let sequence = 0;\n        // ui.console.warn(`Dictionary prepared :\\n${JSON.stringify(dictionarySegment)}`);\n        // ui.console.warn(`Field prepared :\\n${JSON.stringify(preparedFields)}`);\n        // For now, the check does not test if the current field is available or not\n        if (typesLib.gt($items.length, 0) && typesLib.gt(preparedFields.length, 0)) {\n            // Start analysis\n            this._existFields(pageInstance, $items, dictionarySegment, (segments, field) => true, (segments, field) => {\n                field.sequence = (sequence = typesLib.add(sequence, 1));\n                return !Object.entries(segments).some(([key, value]) => typesLib.lte(value.sequence, 0));\n            });\n            // Remove invalid dictionary entries : Each field must be have all segments available\n            for (const [key, value] of Object.entries(dictionarySegment)) {\n                if (typesLib.lte(value.sequence, 0)) {\n                    delete dictionarySegment[key];\n                }\n            }\n        }\n        // Update internal dictionary now\n        this._dictionarySegment = dictionarySegment;\n        // Retain entry only with full segments\n        for (const key in preparedFields) {\n            const fields = preparedFields[key];\n            if (fields.segments.every(thisSegment => typesLib.strictEq(dictionarySegment[thisSegment.currentField.id]?.currentField.id, thisSegment.currentField.id))) {\n                selectedFields.push(fields);\n            }\n            else {\n                // Remove partial entries\n                for (const segment of fields.segments) {\n                    delete this._dictionarySegment[segment.currentField.id];\n                }\n            }\n        }\n        // ui.console.debug(`Dictionary updated :\\n${JSON.stringify(this._dictionarySegment)}`);\n        // ui.console.debug(`Prepared fields :\\n${JSON.stringify(preparedFields)}`);\n        // ui.console.debug(`Selected fields :\\n${JSON.stringify(selectedFields)}`);\n        return selectedFields;\n    }\n    /**\n     * Analyze list of fields submitted (recursive)\n     * @param pageInstance current page\n     * @param $items\n     * @param segments current segments list for field\n     * @param check verify is possible to use the field for action\n     * @param action perform action\n     * @returns\n     */\n    /** @internal */\n    _existFields(pageInstance, $items, segments, check, action) {\n        // Index from array\n        for (let i in $items) {\n            let $bind = undefined;\n            let pageField = undefined;\n            let field = undefined;\n            if (($bind = $items[i].$bind) && (pageField = pageInstance[$bind]) && (field = segments[pageField?.id])) {\n                // ui.console.debug(`Bind field : ${JSON.stringify($bind)}`);\n                if (check(segments, field) && action(segments, field)) {\n                    return true;\n                }\n                continue;\n            }\n            else {\n                // ui.console.debug(`Skipping binded field : ${JSON.stringify($bind)}`);\n                const $items2 = $items[i].$layout?.$items ?? [];\n                // recursively search for 'binded' components inside the layout's containers like section & blocks\n                if (typesLib.gt($items2.length, 0) && this._existFields(pageInstance, $items2, segments, check, action)) {\n                    return true;\n                }\n            }\n        }\n        return false;\n    }\n    /**\n     * Section page validation\n     * */\n    /**\n     * Perform validation of all segments managed\n     * @param pageInstance current page\n     * @param errorMessage translated message error errorMessageCheckYourEntry\n     * @returns\n     */\n    async validate(pageInstance, errorMessage = exports.errorMessageCheckYourEntry) {\n        const fieldErrors = new Array();\n        const isPageValid = await pageInstance.$.page.isValid;\n        let areAllFieldsValid = true;\n        for (const field of this._screenFieldsSupported) {\n            for (const segment of field.segments) {\n                if (!(await this._validateField(segment.currentField))) {\n                    areAllFieldsValid = false;\n                    fieldErrors.push(segment.currentField.id);\n                }\n            }\n        }\n        if (typesLib.gt(fieldErrors.length, 0)) {\n            this._notifyFieldNotValid(pageInstance, fieldErrors, errorMessage);\n        }\n        return isPageValid && areAllFieldsValid;\n    }\n    /**\n     * Perform field validation\n     * @param field current field\n     * @returns true when field is validated\n     */\n    /** @internal */\n    async _validateField(field) {\n        return !(await field.validate());\n    }\n    /**\n     * Notify all fields invalids\n     * @param pageInstance current page\n     * @param errorMessage translated message error errorMessageCheckYourEntry\n     * @param fields\n     */\n    /** @internal */\n    async _notifyFieldNotValid(pageInstance, fields, errorMessage = exports.errorMessageCheckYourEntry) {\n        pageInstance.$.removeToasts();\n        pageInstance.$.showToast((0, xtrem_shared_1.format)(errorMessage, 'base', {\n            fieldNames: fields.map(field => pageInstance[field]?.title),\n        }), { type: 'error', timeout: 5000 });\n    }\n    /**\n     * Validate current page\n     * @param pageInstance current page\n     * @param errorMessage translated message error errorMessageError\n     * @returns false when error occur\n     */\n    async validatePage(pageInstance, errorMessage = exports.errorMessageError) {\n        const errors = await pageInstance.$.page.validate();\n        if (!errors.length) {\n            return true;\n        }\n        const zz = pageInstance.$.removeToasts();\n        pageInstance.$.showToast(`${(0, xtrem_shared_1.format)(errorMessage, 'base')}: ${errors[0]}`, {\n            type: 'error',\n            timeout: 30000,\n        });\n        return false;\n    }\n    /**\n     * perform fields validation with detailed errors lists.\n     * @param pageInstance current page\n     * @param errorMessage errorMessageCheckYourEntry\n     * @returns false when error occur\n     */\n    async validateWithDetails(pageInstance, errorMessage = exports.errorMessageCheckYourEntry) {\n        // Request change to page\n        // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n        await pageInstance.$.commitValueAndPropertyChanges();\n        const errors = await pageInstance.$.page.validateWithDetails();\n        if (!errors.length) {\n            return true;\n        }\n        pageInstance.$.removeToasts();\n        pageInstance.$.showToast((0, xtrem_shared_1.format)(errorMessage, 'base', {\n            fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n        }), { type: 'error', timeout: 5000 });\n        return false;\n    }\n}\nexports.ManagementServiceGs1 = ManagementServiceGs1;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN5c3RlbS9saWIvY2xpZW50LWZ1bmN0aW9ucy9tYW5hZ2VtZW50LXNlcnZpY2UtZ3MtMS50cyIsIm1hcHBpbmdzIjoiOzs7O0FBRUEsb0dBQWtEO0FBQ2xELDJGQUFrRjtBQUNsRix1RUFBcUM7QUFDckMsd0pBQWlGO0FBRWpGLDhKQWNrQztBQUVyQixrQ0FBMEIsR0FBRyxpRUFBaUUsQ0FBQztBQUMvRix5QkFBaUIsR0FBRyxPQUFPLENBQUM7QUFFekMsTUFBYSxvQkFBb0I7SUFxQzdCOzs7T0FHRztJQUNILFlBQTZCLFdBQW1CO1FBQW5CLGdCQUFXLEdBQVgsV0FBVyxDQUFRO1FBeENoRCxvQkFBb0I7UUFFcEI7O1dBRUc7UUFFSCxnQkFBZ0I7UUFDUiwyQkFBc0IsR0FBMkIsRUFBRSxDQUFDO1FBRTVELGdCQUFnQjtRQUNSLHVCQUFrQixHQUFzQixFQUF1QixDQUFDO1FBRXhFLGdCQUFnQjtRQUNSLHdCQUFtQixHQUFzQixFQUFFLENBQUM7UUFFcEQsZ0JBQWdCO1FBQ1IsOEJBQXlCLEdBQTRCLEVBQTZCLENBQUM7UUFFM0YsZ0JBQWdCO1FBQ1IsbUJBQWMsR0FBWSxLQUFLLENBQUM7UUFFeEMsZ0JBQWdCO1FBQ1Isd0JBQW1CLEdBQVksS0FBSyxDQUFDO1FBRTdDLGdCQUFnQjtRQUNSLDhCQUF5QixHQUFZLEtBQUssQ0FBQztRQWdCL0MsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLDZCQUFZLEVBQUUsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBRUksS0FBSyxDQUFDLFVBQVUsQ0FDbkIsWUFBK0IsRUFDL0IsMkJBQXFELEVBQThCLEVBQ25GLDJCQUFvRCxFQUE2QixFQUNqRix5QkFBaUQ7UUFFakQsSUFBSSxDQUFDLFlBQVksSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUNyQyxNQUFNLElBQUksMEJBQVcsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1FBQy9DLENBQUM7UUFFRCxJQUFJLENBQUM7WUFDRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO1lBQ2pDLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxJQUFJLENBQUM7WUFDdEMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLHlCQUF5QixDQUFDO1lBRTVELHdGQUF3RjtZQUN4RixvRkFBb0Y7WUFFcEYsNENBQTRDO1lBQzVDLGdCQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsd0JBQXdCLElBQUssRUFBOEIsQ0FBQyxDQUFDLE1BQU0sRUFBRyxDQUFDLEdBQUUsQ0FBQztnQkFDdEYsSUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUM7Z0JBQzFCLGdCQUFnQjtnQkFDaEIsSUFBSSxDQUFDLDJCQUEyQixDQUFDLFlBQVksQ0FBQyxDQUFDO2dCQUMvQyxJQUFJLENBQUMseUJBQXlCLEdBQUcsd0JBQXdCLElBQUssRUFBOEIsQ0FBQztZQUNqRyxDQUFDO2lCQUFNLENBQUM7Z0JBQ0osSUFBSSxDQUFDLGlCQUFpQixDQUFDLFlBQVksQ0FBQyxDQUFDO1lBQ3pDLENBQUM7WUFFRCxnQkFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLHdCQUF3QixJQUFLLEVBQStCLENBQUMsQ0FBQyxNQUFNLEVBQUcsQ0FBQyxHQUFFLENBQUM7Z0JBQ3ZGLE1BQU0sSUFBSSxDQUFDLHVCQUF1QixDQUM5QixZQUFZLEVBQ1osd0JBQXdCLElBQUssRUFBK0IsQ0FDL0QsQ0FBQztnQkFFRixnREFBZ0Q7Z0JBQ2hELElBQUksSUFBSSxDQUFDLHFCQUFxQixJQUFJLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO29CQUMxRCxJQUFJLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxFQUFFLENBQUM7d0JBQzNCLElBQUksQ0FBQzs0QkFDRCw4REFBOEQ7NEJBQzlELE1BQU0sT0FBTyxHQUFHLENBQUMsTUFBTSxJQUFJLENBQUMscUJBQXFCLENBQzdDLFlBQVksRUFDWixJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBMEMsRUFDdEUsS0FBSyxDQUNSLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFZLENBQUM7d0JBQ3JDLENBQUM7d0JBQUMsT0FBTyxLQUFLLEVBQUUsQ0FBQzs0QkFDYixFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxxQ0FBcUMsS0FBSyxFQUFFLENBQUMsQ0FBQzt3QkFDbkUsQ0FBQztnQ0FBUyxDQUFDOzRCQUNQLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO3dCQUM5QixDQUFDO29CQUNMLENBQUM7Z0JBQ0wsQ0FBQztZQUNMLENBQUM7UUFDTCxDQUFDO1FBQUMsT0FBTyxLQUFLLEVBQUUsQ0FBQztZQUNiLEVBQUUsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLHNDQUFzQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ3BFLENBQUM7Z0JBQVMsQ0FBQztZQUNQLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxLQUFLLENBQUM7UUFDM0MsQ0FBQztRQUVELE9BQU8sSUFBSSxDQUFDO0lBQ2hCLENBQUM7SUFFRDs7T0FFRztJQUNILElBQVcsb0JBQW9CO1FBQzNCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ3BDLENBQUM7SUFFRDs7T0FFRztJQUNILElBQVcsMEJBQTBCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLHlCQUF5QixDQUFDO0lBQzFDLENBQUM7SUFFRDs7O09BR0c7SUFDSCxnQkFBZ0I7SUFDUixpQkFBaUI7UUFDckIsTUFBTSxxQkFBcUIsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUM7UUFDdkQsSUFBSSxDQUFDLG1CQUFtQixHQUFHLElBQUksQ0FBQztRQUNoQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztRQUM1QixJQUFJLENBQUMsd0JBQXdCLEdBQUcsU0FBUyxDQUFDO1FBQzFDLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7OztPQUdHO0lBQ0gsZ0JBQWdCO0lBQ1Isa0JBQWtCO1FBQ3RCLE1BQU0scUJBQXFCLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7UUFDakMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7UUFDNUIsSUFBSSxDQUFDLHdCQUF3QixHQUFHLFNBQVMsQ0FBQztRQUMxQyxPQUFPLHFCQUFxQixDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhLENBQUMsdUJBQThDO1FBQy9ELElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO1FBQzVCLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxTQUFTLENBQUM7UUFDMUMsSUFBSSxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztZQUMzQixJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQztZQUMzQixJQUFJLENBQUMsSUFBSSxDQUFDLDBCQUEwQixFQUFFLENBQUM7Z0JBQ25DLElBQUksQ0FBQyx3QkFBd0IsR0FBRyx1QkFBdUIsQ0FBQztZQUM1RCxDQUFDO1FBQ0wsQ0FBQztRQUVELE9BQU8sSUFBSSxDQUFDLHlCQUF5QixDQUFDO0lBQzFDLENBQUM7SUFFRDs7T0FFRztJQUNILElBQVcseUJBQXlCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUMvQixDQUFDO0lBRUQ7Ozs7Ozs7T0FPRztJQUNJLEtBQUssQ0FBQyxJQUFJLENBQ2IsWUFBK0IsRUFDL0IsWUFBMkMsRUFDM0MsT0FBWSxFQUNaLHNCQUErQixLQUFLO1FBRXBDLElBQUksSUFBSSxDQUFDLGlCQUFpQixFQUFFLEVBQUUsQ0FBQztZQUMzQixJQUFJLENBQUM7Z0JBQ0QsSUFBSSxNQUFNLEdBQUcsSUFBSSxDQUFDO2dCQUNsQiw0REFBNEQ7Z0JBQzVELElBQ0ksQ0FBQyxPQUFPLHNCQUNSLE9BQU8sT0FBTyxFQUFLLFFBQVEsaUJBQzNCLE9BQU8sQ0FBQyxNQUFNLEVBQUcsQ0FBQztvQkFDbEIsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyw0Q0FBbUIsQ0FBQyxFQUFFLE1BQU0sQ0FBQztvQkFDbkQsQ0FBQyxDQUFDLE1BQU0sSUFBSSxDQUFDLG9CQUFvQixDQUFDLE9BQU8sRUFBRSxtQkFBbUIsQ0FBQyxDQUFDLEVBQ2xFLENBQUM7b0JBQ0MsSUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUM7b0JBQzFCLE9BQU8sS0FBSyxDQUFDO2dCQUNqQixDQUFDO2dCQUVELG9FQUFvRTtnQkFDcEUsSUFBSSxJQUFJLENBQUMscUJBQXFCLEVBQUUsQ0FBQztvQkFDN0IsSUFBSSxlQUFxQyxDQUFDO29CQUMxQyxNQUFNLG1CQUFtQixHQUFHLE1BQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLElBQUksQ0FBQyxDQUFDO29CQUN4RixJQUFJLENBQUM7d0JBQ0QsTUFBTSxHQUFHLENBQUMsTUFBTSxJQUFJLENBQUMscUJBQXFCLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDLEtBQUssQ0FDeEUsR0FBRyxFQUFFLENBQUMsS0FBSyxDQUNkLENBQVksQ0FBQzt3QkFFZCxnREFBZ0Q7d0JBQ2hELElBQUksTUFBTSxJQUFJLElBQUksQ0FBQyx5QkFBeUIsSUFBSSxJQUFJLENBQUMsd0JBQXdCLEVBQUUsQ0FBQzs0QkFDNUUsZUFBZSxHQUFHLElBQUksQ0FBQyx3QkFBd0IsQ0FBQzt3QkFDcEQsQ0FBQztvQkFDTCxDQUFDOzRCQUFTLENBQUM7d0JBQ1AsVUFBVSxDQUFDLEtBQUssSUFBSSxFQUFFOzRCQUNsQixJQUFJLENBQUM7Z0NBQ0QsTUFBTSxJQUFJLENBQUMsY0FBYyxDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztnQ0FDM0UsSUFBSSxlQUFlO29DQUFFLE1BQU0sZUFBZSxFQUFFLENBQUM7NEJBQ2pELENBQUM7NEJBQUMsT0FBTyxLQUFLLEVBQUUsQ0FBQztnQ0FDYixFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyx5Q0FBeUMsS0FBSyxFQUFFLENBQUMsQ0FBQzs0QkFDdkUsQ0FBQzt3QkFDTCxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7b0JBQ1osQ0FBQztnQkFDTCxDQUFDO3FCQUFNLENBQUM7b0JBQ0osTUFBTSxJQUFJLENBQUMsV0FBVyxDQUFDLFlBQVksRUFBRSxZQUFZLENBQUMsQ0FBQztnQkFDdkQsQ0FBQztnQkFDRCxPQUFPLE1BQU0sQ0FBQztZQUNsQixDQUFDO1lBQUMsT0FBTyxLQUFLLEVBQUUsQ0FBQztnQkFDYixFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxzQkFBc0IsS0FBSyxFQUFFLENBQUMsQ0FBQztZQUNwRCxDQUFDO29CQUFTLENBQUM7Z0JBQ1AsSUFBSSxDQUFDLGtCQUFrQixFQUFFLENBQUM7WUFDOUIsQ0FBQztRQUNMLENBQUM7UUFDRCxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQzlDLE9BQU8sS0FBSyxDQUFDO0lBQ2pCLENBQUM7SUFFRDs7OztPQUlHO0lBQ0gsZ0JBQWdCO0lBQ1IseUJBQXlCLENBQUMsWUFBdUQ7UUFDckYsT0FBTyxZQUFZLFlBQVksRUFBRSxDQUFDLE1BQU0sQ0FBQyxTQUFTLElBQUksWUFBWSxZQUFZLEVBQUUsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDO0lBQ3pHLENBQUM7SUFFRDs7Ozs7T0FLRztJQUNILGdCQUFnQjtJQUNSLEtBQUssQ0FBQyxjQUFjLENBQ3hCLFlBQStCLEVBQy9CLFlBQTZCLEVBQzdCLFlBQXFCLEVBQ3JCLFlBQVksR0FBRyxJQUFJO1FBRW5CLE1BQU0sdUJBQXVCLEdBQUcsWUFBWSxFQUFFLGVBQWUsSUFBSSxLQUFLLENBQUM7UUFDdkUsSUFBSSxZQUFZLHNCQUFJLFlBQVksRUFBSyx1QkFBdUIsS0FBSSxJQUFJLENBQUMseUJBQXlCLENBQUMsWUFBWSxDQUFDLEVBQUUsQ0FBQztZQUMzRyxZQUFZLENBQUMsZUFBZSxHQUFHLFlBQVksQ0FBQztZQUM1QyxJQUFJLFlBQVksRUFBRSxDQUFDO2dCQUNmLE1BQU0sWUFBWSxDQUFDLENBQUMsQ0FBQyw2QkFBNkIsRUFBRSxDQUFDO1lBQ3pELENBQUM7UUFDTCxDQUFDO1FBQ0QsT0FBTyx1QkFBdUIsQ0FBQztJQUNuQyxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSCxnQkFBZ0I7SUFDUixLQUFLLENBQUMsV0FBVyxDQUNyQixZQUFvQyxFQUNwQyxZQUEyQyxFQUMzQyxXQUFvQixJQUFJO1FBRXhCLFlBQVksQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDO1FBQzFCLDBFQUEwRTtRQUMxRSxNQUFNLFlBQVksQ0FBQyxDQUFDLENBQUMsNkJBQTZCLEVBQUUsQ0FBQztRQUVyRCxJQUFJLFFBQVEsRUFBRSxDQUFDO1lBQ1gsWUFBWSxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ3pCLENBQUM7UUFDRCxtQkFBbUI7UUFDbkIsTUFBTSxZQUFZLENBQUMsUUFBUSxFQUFFLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFFRDs7Ozs7T0FLRztJQUNILGdCQUFnQjtJQUNSLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxPQUFlLEVBQUUsc0JBQStCLEtBQUs7UUFDcEYsTUFBTSxrQkFBa0IsR0FBNEIsRUFBNkIsQ0FBQztRQUVsRixFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxzQkFBc0IsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsWUFBWSxPQUFPLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQztRQUU1RixJQUFJLGFBQTRCLENBQUM7UUFDakMsSUFBSSxDQUFDO1lBQ0QsYUFBYSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQ3pELEVBQUUsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLGNBQWMsT0FBTyx1QkFBdUIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUMsRUFBRSxDQUFDLENBQUM7UUFDbEcsQ0FBQztRQUFDLE9BQU8sS0FBSyxFQUFFLENBQUM7WUFDYixFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyw0QkFBNEIsS0FBSyxFQUFFLENBQUMsQ0FBQztZQUN0RCxPQUFPLEtBQUssQ0FBQztRQUNqQixDQUFDO1FBRUQ7Ozs7V0FJRztRQUNILElBQ0ksQ0FBQyxhQUFhLENBQUMsZUFBZSxDQUFDLE1BQU07WUFDckMsQ0FBQyx5QkFBYSxDQUFDLGVBQWUsQ0FBQyxNQUFNLEVBQUcsQ0FBQyx1QkFBSSxhQUFhLENBQUMsUUFBUSxFQUFLLEVBQUUsRUFBQyxFQUM3RSxDQUFDO1lBQ0MsT0FBTyxLQUFLLENBQUM7UUFDakIsQ0FBQztRQUVELHlDQUF5QztRQUN6QyxLQUFLLE1BQU0sY0FBYyxJQUFJLGFBQWEsQ0FBQyxlQUFlLEVBQUUsQ0FBQztZQUN6RCx1QkFBdUI7WUFDdkIsa0JBQWtCLENBQUMsY0FBYyxDQUFDLGdCQUFnQixDQUFDLEdBQUc7Z0JBQ2xELFNBQVMsRUFBRSxjQUFjLENBQUMsZ0JBQWdCO2dCQUMxQyxJQUFJLEVBQUUsY0FBYyxDQUFDLElBQUk7Z0JBQ3pCLElBQUksRUFBRSxjQUFjLENBQUMsSUFBSTthQUM1QixDQUFDO1FBQ04sQ0FBQztRQUVELGtHQUFrRztRQUNsRyxvRkFBb0Y7UUFFcEYsb0JBQW9CO1FBQ3BCLElBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1lBQzFCLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxrQkFBa0IsQ0FBQztRQUN4RCxDQUFDO2FBQU0sQ0FBQztZQUNKLEtBQUssTUFBTSxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLGtCQUFrQixDQUFDLEVBQUUsQ0FBQztnQkFDNUQsSUFBSSxDQUFDLHlCQUF5QixDQUFDLEdBQWdCLENBQUMsR0FBRyxLQUFLLENBQUM7WUFDN0QsQ0FBQztRQUNMLENBQUM7UUFFRCxrR0FBa0c7UUFFbEcsa0NBQWtDO1FBRWxDLElBQUksQ0FBQyxDQUFDLE1BQU0sSUFBSSxDQUFDLHVCQUF1QixFQUFFLENBQUMsRUFBRSxDQUFDO1lBQzFDLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1lBQzFCLE9BQU8sSUFBSSxDQUFDO1FBQ2hCLENBQUM7UUFFRCx1RUFBdUU7UUFDdkUsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1FBRXRCLHlFQUF5RTtRQUN6RSxPQUFPLElBQUksQ0FBQztJQUNoQixDQUFDO0lBRUQ7O09BRUc7SUFDSCxJQUFJLHVCQUF1QjtRQUN2QixtQkFBTyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLE1BQU0sRUFBRyxDQUFDLEVBQUM7SUFDL0QsQ0FBQztJQUVEOzs7T0FHRztJQUNILElBQUksb0JBQW9CO1FBQ3BCLG1CQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxNQUFNLEVBQUcsQ0FBQyxFQUFDO0lBQy9DLENBQUM7SUFFRDs7O09BR0c7SUFDSCxJQUFJLHFCQUFxQjtRQUNyQixtQkFBTyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLE1BQU0sRUFBRyxDQUFDLEVBQUM7SUFDbEUsQ0FBQztJQUVEOzs7O09BSUc7SUFDSCxnQkFBZ0I7SUFDUixvQkFBb0IsQ0FBQyxLQUEyQztRQUNwRSxPQUFPLENBQUMsS0FBSyxFQUFFLFFBQVEsSUFBSSxLQUFLLEVBQUUsVUFBVSxJQUFJLEtBQUssRUFBRSxVQUFVLENBQUMsSUFBSSxJQUFJLENBQUM7SUFDL0UsQ0FBQztJQUVEOztPQUVHO0lBQ0gsZ0JBQWdCO0lBQ1IsNkJBQTZCO1FBQ2pDLE1BQU0sdUJBQXVCLEdBQUcsRUFBNkIsQ0FBQztRQUM5RCxLQUFLLE1BQU0sQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMseUJBQXlCLENBQUMsRUFBRSxDQUFDO1lBQ3hFLHVCQUF1QixDQUFDLEdBQWdCLENBQUMsR0FBRyxLQUFLLENBQUM7UUFDdEQsQ0FBQztRQUNELE9BQU8sdUJBQXVCLENBQUM7SUFDbkMsQ0FBQztJQUVEOzs7T0FHRztJQUNILGdCQUFnQjtJQUNSLEtBQUssQ0FBQyx1QkFBdUI7UUFDakMsa0VBQWtFO1FBQ2xFLElBQUksQ0FBQztZQUNELElBQ0ksSUFBSSxDQUFDLDBCQUEwQjtnQkFDL0IsSUFBSSxDQUFDLHFCQUFxQjtnQkFDMUIsQ0FBQyxDQUFDLE1BQU0sSUFBSSxDQUFDLDBCQUEwQixDQUFDLElBQUksQ0FBQyw2QkFBNkIsRUFBRSxDQUFDLENBQUMsRUFDaEYsQ0FBQztnQkFDQyxPQUFPLEtBQUssQ0FBQztZQUNqQixDQUFDO1FBQ0wsQ0FBQztRQUFDLE9BQU8sS0FBSyxFQUFFLENBQUM7WUFDYixFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxnRUFBZ0UsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUM5RixDQUFDO1FBQ0QsT0FBTyxJQUFJLENBQUM7SUFDaEIsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLEtBQUssQ0FBQyx1QkFBdUIsQ0FDaEMsWUFBK0IsRUFDL0Isd0JBQWtEO1FBRWxELGtEQUFrRDtRQUNsRCxJQUFJLEtBQUssR0FBWSxDQUFDLENBQUM7UUFDdkIsTUFBTSw0QkFBNEIsR0FBRyxJQUFJLENBQUMsMEJBQTBCLENBQUM7UUFDckUsSUFBSSxDQUFDO1lBQ0QsSUFBSSxDQUFDLHlCQUF5QixHQUFHLElBQUksQ0FBQztZQUN0QyxJQUFJLENBQUMsc0JBQXNCO2dCQUN2QixJQUFJLENBQUMsZUFBZSxDQUFDLFlBQVksRUFBRSx3QkFBd0IsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRTtvQkFDckUsTUFBTSxpQkFBaUIsR0FBbUIsRUFBRSxDQUFDO29CQUU3QywwQkFBMEI7b0JBQzFCLEtBQUssQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUFFO3dCQUM3QixNQUFNLFlBQVksR0FBRyxPQUFPLENBQUMsWUFBWSxDQUFDO3dCQUMxQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUM7NEJBQ25CLFlBQVksRUFBRSxZQUFZOzRCQUMxQixRQUFRLEVBQUUsT0FBTyxDQUFDLFFBQVE7eUJBQzdCLENBQUMsQ0FBQztvQkFDUCxDQUFDLENBQUMsQ0FBQztvQkFFSCxPQUFPO3dCQUNILFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUzt3QkFDMUIsUUFBUSx3QkFBSSxLQUFLO3dCQUNqQixRQUFRLEVBQUUsaUJBQWlCO3FCQUNOLENBQUM7Z0JBQzlCLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUViLG1HQUFtRztZQUVuRywwQ0FBMEM7WUFDMUMsT0FBTyxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7UUFDakMsQ0FBQztRQUFDLE9BQU8sS0FBSyxFQUFFLENBQUM7WUFDYixFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyx1Q0FBdUMsS0FBSyxFQUFFLENBQUMsQ0FBQztZQUNqRSxPQUFPLEtBQUssQ0FBQztRQUNqQixDQUFDO2dCQUFTLENBQUM7WUFDUCxJQUFJLENBQUMseUJBQXlCLEdBQUcsNEJBQTRCLENBQUM7UUFDbEUsQ0FBQztJQUNMLENBQUM7SUFFRDs7O09BR0c7SUFDSCxnQkFBZ0I7SUFDUixjQUFjO1FBQ2xCLDRHQUE0RztRQUM1RyxrR0FBa0c7UUFFbEcsdUJBQXVCO1FBRXZCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxFQUFFLENBQUM7UUFDOUIsSUFBSSxLQUFLLEdBQVcsQ0FBQyxDQUFDO1FBQ3RCLE1BQU0sYUFBYSxHQUFzQixFQUFFLENBQUM7UUFFNUMsZ0NBQWdDO1FBQ2hDLElBQUksQ0FBQyxzQkFBc0I7YUFDdEIsTUFBTSxDQUNILEtBQUssQ0FBQyxFQUFFLENBQ0osSUFBSSxDQUFDLHlCQUF5QixDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUM7WUFDL0MsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLENBQ3JFO2FBQ0EsSUFBSSxDQUFDLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxFQUFFLGNBQUMsTUFBTSxDQUFDLFFBQVEsRUFBRyxNQUFNLENBQUMsUUFBUSxFQUFDO2FBQzNELE9BQU8sQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUNaLE1BQU0sZUFBZSxHQUFHO2dCQUNwQixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7Z0JBQ3pCLFFBQVEsd0JBQUksS0FBSztnQkFDakIsU0FBUyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsWUFBWTtnQkFDeEMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxRQUFRO2dCQUM1QyxJQUFJLEVBQUUsSUFBSSxDQUFDLHlCQUF5QixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsRUFBRSxJQUFJO2FBQzFDLENBQUM7WUFFckIsb0JBQW9CO1lBQ3BCLElBQUksZ0JBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxFQUFHLENBQUMsS0FBSSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxFQUFFLFlBQVksRUFBRSxDQUFDO2dCQUM3RCxlQUFlLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsWUFBWSxDQUFDO2dCQUMxRCxlQUFlLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxRQUFRLENBQUM7Z0JBQzlELGVBQWUsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLHlCQUF5QixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsRUFBRSxJQUFJLENBQUM7WUFDaEYsQ0FBQztZQUVELGFBQWEsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7UUFDeEMsQ0FBQyxDQUFDLENBQUM7UUFFUCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsYUFBYSxDQUFDO1FBRXpDLHFGQUFxRjtRQUNyRixtQkFBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsTUFBTSxFQUFHLENBQUMsRUFBQztJQUMvQyxDQUFDO0lBRUQ7OztPQUdHO0lBQ0ksaUJBQWlCLENBQUMsc0JBQStCLEtBQUs7UUFDekQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEVBQUUsQ0FBQztRQUNqQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsRUFBRSxDQUFDO1FBQzlCLElBQUksbUJBQW1CLEVBQUUsQ0FBQztZQUN0QixJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztRQUM5QixDQUFDO0lBQ0wsQ0FBQztJQUVEOztPQUVHO0lBQ0ksa0JBQWtCO1FBQ3JCLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxFQUE2QixDQUFDO0lBQ25FLENBQUM7SUFFRDs7OztPQUlHO0lBQ0kseUJBQXlCLENBQUMsWUFBK0IsRUFBRSxVQUFtQjtRQUNqRixJQUFJLENBQUMsMkJBQTJCLENBQUMsWUFBWSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0lBQy9ELENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksK0JBQStCLENBQUMsWUFBK0IsRUFBRSxVQUFtQjtRQUN2RixJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztRQUMxQixJQUFJLENBQUMseUJBQXlCLENBQUMsWUFBWSxFQUFFLFVBQVUsQ0FBQyxDQUFDO0lBQzdELENBQUM7SUFFRDs7O09BR0c7SUFDSSxpQkFBaUIsQ0FBQyxZQUErQjtRQUNwRCxJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztRQUMxQixJQUFJLENBQUM7WUFDRCxNQUFNLHdCQUF3QixHQUE0QixJQUFJLENBQUMsS0FBSyxDQUNoRSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksSUFBSSxDQUFXLENBQ3hDLENBQUM7WUFDN0IsMkZBQTJGO1lBQzNGLGdCQUFnQjtZQUNoQixJQUFJLENBQUMsMkJBQTJCLENBQUMsWUFBWSxDQUFDLENBQUM7WUFDL0MsZ0JBQUksTUFBTSxDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLE1BQU0sRUFBRyxDQUFDLEdBQUUsQ0FBQztnQkFDbkQsSUFBSSxDQUFDLHlCQUF5QixHQUFHLHdCQUF3QixDQUFDO2dCQUMxRCxvRkFBb0Y7Z0JBQ3BGLE9BQU8sSUFBSSxDQUFDO1lBQ2hCLENBQUM7UUFDTCxDQUFDO1FBQUMsT0FBTyxLQUFLLEVBQUUsQ0FBQztZQUNiLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1lBQzFCLElBQUksQ0FBQywyQkFBMkIsQ0FBQyxZQUFZLENBQUMsQ0FBQztZQUMvQyxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxnREFBZ0QsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUM5RSxDQUFDO1FBQ0QseUNBQXlDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3RDLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksaUJBQWlCLENBQUMsWUFBK0I7UUFDcEQsSUFBSSxZQUFZLElBQUksSUFBSSxDQUFDLFdBQVcsSUFBSSxJQUFJLENBQUMscUJBQXFCLEVBQUUsQ0FBQztZQUNqRSxNQUFNLHdCQUF3QixHQUE0QixJQUFJLENBQUMseUJBQXlCLENBQUM7WUFDekYsWUFBWSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUM7WUFDdkYsT0FBTyxJQUFJLENBQUM7UUFDaEIsQ0FBQztRQUNELElBQUksWUFBWSxFQUFFLENBQUM7WUFDZixJQUFJLENBQUMsMkJBQTJCLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDbkQsQ0FBQztRQUNELE9BQU8sS0FBSyxDQUFDO0lBQ2pCLENBQUM7SUFFRDs7O09BR0c7SUFDSCxnQkFBZ0I7SUFDUiwyQkFBMkIsQ0FBQyxZQUErQixFQUFFLFVBQW1CO1FBQ3BGLE1BQU0sYUFBYSxHQUFHLENBQUMsQ0FBQyxZQUFZLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFdBQVcsSUFBSSxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDN0UsSUFBSSxhQUFhLEVBQUUsQ0FBQztZQUNoQixZQUFZLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUNsRSxDQUFDO1FBRUQsT0FBTyxhQUFhLENBQUM7SUFDekIsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNILGdCQUFnQjtJQUNSLEtBQUssQ0FBQyxxQkFBcUIsQ0FDL0IsWUFBK0IsRUFDL0IsYUFBNEMsRUFDNUMsV0FBb0IsS0FBSztRQUV6QixNQUFNLE1BQU0sR0FBRyxZQUFZLEVBQUUsYUFBYSxDQUFDLE1BQU0sQ0FBQyxNQUFNLElBQUksRUFBRSxDQUFDO1FBQy9ELElBQUksU0FBUyxHQUFZLEtBQUssQ0FBQztRQUMvQixJQUFJLG1CQUFtQixHQUFZLEtBQUssQ0FBQztRQUV6Qyx1REFBdUQ7UUFDdkQsSUFBSSxrQkFBTSxFQUFFLE1BQU0sRUFBRyxDQUFDLEtBQUksSUFBSSxDQUFDLHFCQUFxQixFQUFFLENBQUM7WUFDbkQsS0FBSyxNQUFNLEtBQUssSUFBSSxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztnQkFDM0MsSUFBSSxLQUFLLEVBQUUsSUFBSSxFQUFFLENBQUM7b0JBQ2QsSUFDSSxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUMsTUFBTSxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksRUFBRSxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUMsS0FBSyxDQUN4RSxHQUFHLEVBQUUsQ0FBQyxLQUFLLENBQ2QsQ0FBWSxDQUFDLEVBQ2hCLENBQUM7d0JBQ0MscUVBQXFFO3dCQUNyRSxJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQzt3QkFDMUIsTUFBTTtvQkFDVixDQUFDO3lCQUFNLENBQUM7d0JBQ0osbUJBQW1CLEdBQUcsSUFBSSxDQUFDO29CQUMvQixDQUFDO2dCQUNMLENBQUM7WUFDTCxDQUFDO1FBQ0wsQ0FBQztRQUVELHlEQUF5RDtRQUN6RCxJQUFJLENBQUMsU0FBUyxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztZQUNyQyxTQUFTLEdBQUcsSUFBSSxDQUFDO1lBQ2pCLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1lBQzFCLElBQUksQ0FBQyxXQUFXLENBQUMsWUFBWSxFQUFFLGFBQWEsRUFBRSxRQUFRLENBQUMsQ0FBQztZQUN4RCxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FDWix3RUFBd0UsYUFBYSxFQUFFLEVBQUUsWUFBWSxDQUN4RyxDQUFDO1FBQ04sQ0FBQztRQUVELHFFQUFxRTtRQUNyRSxPQUFPLENBQUMsU0FBUyxDQUFDO0lBQ3RCLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSCxnQkFBZ0I7SUFDUixLQUFLLENBQUMsYUFBYSxDQUN2QixZQUFpQixFQUNqQixLQUFzQixFQUN0QixXQUFvQixLQUFLO1FBRXpCLE1BQU0sa0JBQWtCLEdBQW9DLEVBQUUsQ0FBQztRQUMvRCxNQUFNLGlCQUFpQixHQUF1QyxFQUFFLENBQUM7UUFDakUsTUFBTSxTQUFTLEdBQUcsS0FBSyxFQUFFLFNBQVMsQ0FBQztRQUNuQyxNQUFNLFdBQVcsR0FBRyxTQUFTLEVBQUUsRUFBRSxJQUFJLEVBQUUsQ0FBQztRQUN4QyxNQUFNLFNBQVMsR0FBRyxLQUFLLEVBQUUsU0FBUyxDQUFDO1FBQ25DLE1BQU0sV0FBVyxHQUFHLFNBQVMsRUFBRSxFQUFFLElBQUksRUFBRSxDQUFDO1FBQ3hDLElBQUksVUFBVSxHQUFHLElBQUksQ0FBQztRQUN0QixJQUFJLHNCQUFzQixHQUFHLEtBQUssQ0FBQztRQUNuQyxJQUFJLHNCQUFzQixHQUF3QixTQUFTLENBQUM7UUFFNUQsSUFBSSxDQUFDO1lBQ0Qsc0VBQXNFO1lBQ3RFLGlGQUFpRjtZQUVqRixtRUFBbUU7WUFDbkUsSUFBSSxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsb0JBQW9CLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQztnQkFDckQsNERBQTREO2dCQUM1RCxPQUFPLElBQUksQ0FBQztZQUNoQixDQUFDO1lBRUQsSUFBSSxLQUFLLEVBQUUsSUFBSSxFQUFFLENBQUM7Z0JBQ2QsSUFBSSxTQUFTLElBQUksS0FBSyxFQUFFLElBQUksSUFBSSxJQUFJLENBQUMsb0JBQW9CLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQztvQkFDbkUsaUVBQWlFO29CQUNqRSxPQUFPLElBQUksQ0FBQztnQkFDaEIsQ0FBQztnQkFFRCxzQkFBc0IsR0FBRyxNQUFNLElBQUksQ0FBQyxjQUFjLENBQUMsWUFBWSxFQUFFLFNBQVMsRUFBRSxJQUFJLENBQUMsQ0FBQztnQkFFbEYsZ0VBQWdFO2dCQUNoRSxRQUFRLE1BQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxZQUFZLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBRSxJQUFJLEVBQUUsUUFBUSxDQUFDLEVBQUUsQ0FBQztvQkFDaEYsS0FBSyxJQUFJO3dCQUNMLGlFQUFpRTt3QkFDakUsT0FBTyxLQUFLLENBQUM7b0JBRWpCLEtBQUssSUFBSTt3QkFDTCxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7d0JBQ25DLElBQUksS0FBSyxFQUFFLGlCQUFpQixFQUFFLENBQUM7NEJBQzNCLGlCQUFpQixDQUFDLElBQUksQ0FBQyxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO3dCQUNuRSxDQUFDO3dCQUNELE1BQU07Z0JBQ2QsQ0FBQztnQkFFRCw0Q0FBNEM7Z0JBQzVDLElBQUksU0FBUyxJQUFJLEtBQUssRUFBRSxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQztvQkFDcEUsc0JBQXNCLEdBQUcsTUFBTSxJQUFJLENBQUMsY0FBYyxDQUFDLFlBQVksRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUM7b0JBQ2xGLFFBQVEsTUFBTSxJQUFJLENBQUMsY0FBYyxDQUFDLFlBQVksRUFBRSxTQUFTLEVBQUUsS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7d0JBQ3JFLEtBQUssSUFBSTs0QkFDTCxzRUFBc0U7NEJBQ3RFLE9BQU8sS0FBSyxDQUFDO3dCQUVqQixLQUFLLElBQUk7NEJBQ0wsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDOzRCQUNuQyxJQUFJLEtBQUssRUFBRSxpQkFBaUIsRUFBRSxDQUFDO2dDQUMzQixpQkFBaUIsQ0FBQyxJQUFJLENBQUMsQ0FBQyxXQUFXLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQzs0QkFDbkUsQ0FBQzs0QkFDRCxNQUFNO29CQUNkLENBQUM7Z0JBQ0wsQ0FBQztnQkFFRCwwRUFBMEU7Z0JBQzFFLE1BQU0sWUFBWSxDQUFDLENBQUMsQ0FBQyw2QkFBNkIsRUFBRSxDQUFDO2dCQUVyRCxtREFBbUQ7Z0JBQ25ELElBQUksa0JBQWtCLENBQUMsTUFBTSxFQUFFLENBQUM7b0JBQzVCLGlEQUFpRDtvQkFFakQsS0FBSyxNQUFNLGdCQUFnQixJQUFJLGlCQUFpQixFQUFFLENBQUM7d0JBQy9DLE1BQU0sT0FBTyxHQUFHLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDO3dCQUNwQyxNQUFNLFFBQVEsR0FBRyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQzt3QkFDckMsSUFBSSxDQUFDOzRCQUNELE1BQU0sUUFBUSxFQUFFLENBQUM7d0JBQ3JCLENBQUM7d0JBQUMsT0FBTyxLQUFLLEVBQUUsQ0FBQzs0QkFDYixNQUFNLElBQUksMEJBQVcsQ0FDakIsNkJBQTZCLE9BQU8sT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxFQUFFLEVBQ2xFLEtBQUssQ0FDUixDQUFDO3dCQUNOLENBQUM7d0JBQ0QsSUFBSSxJQUFJLENBQUMseUJBQXlCLEVBQUUsQ0FBQzs0QkFDakMsNEVBQTRFOzRCQUM1RSxNQUFNO3dCQUNWLENBQUM7b0JBQ0wsQ0FBQztvQkFFRCxrRUFBa0U7b0JBQ2xFLG9GQUFvRjtvQkFDcEYsdUZBQXVGO29CQUN2Riw0Q0FBNEM7b0JBQzVDLElBQUksQ0FBQyxJQUFJLENBQUMseUJBQXlCLEVBQUUsQ0FBQzt3QkFDbEMsZ0ZBQWdGO3dCQUNoRixJQUFJLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxDQUFDOzRCQUMzQixNQUFNLFlBQVksQ0FBQyxDQUFDLENBQUMsNkJBQTZCLEVBQUUsQ0FBQzt3QkFDekQsQ0FBQzt3QkFFRCwyQ0FBMkM7d0JBQzNDLEtBQUssTUFBTSxlQUFlLElBQUksa0JBQWtCLEVBQUUsQ0FBQzs0QkFDL0MsVUFBVSxLQUFLLENBQUMsTUFBTSxlQUFlO2lDQUNoQyxRQUFRLEVBQUU7aUNBQ1YsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFLG1CQUFDLElBQUksRUFBSyxTQUFTLEVBQUM7aUNBQ2hDLEtBQUssQ0FBQyxHQUFHLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBWSxDQUFDOzRCQUNwQyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7Z0NBQ2QsRUFBRSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsaUNBQWlDLGVBQWUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dDQUN2RSxNQUFNOzRCQUNWLENBQUM7d0JBQ0wsQ0FBQztvQkFDTCxDQUFDO2dCQUNMLENBQUM7WUFDTCxDQUFDO1FBQ0wsQ0FBQztRQUFDLE9BQU8sS0FBSyxFQUFFLENBQUM7WUFDYixFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsV0FBVyxPQUFPLEtBQUssRUFBRSxPQUFPLEVBQUUsQ0FBQyxDQUFDO1lBQzFFLE9BQU8sS0FBSyxDQUFDO1FBQ2pCLENBQUM7Z0JBQVMsQ0FBQztZQUNQLElBQUksU0FBUyxxQkFDVCxDQUFDLE1BQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxZQUFZLEVBQUUsU0FBUyxFQUFFLHNCQUFzQixFQUFFLEtBQUssQ0FBQyxDQUFDLEVBQ25GLHNCQUFzQixFQUFDO1lBQzNCLHNCQUFJLHNCQUFzQixFQUFLLFNBQVMsR0FBRSxDQUFDO2dCQUN2QyxTQUFTLHVCQUNMLENBQUMsTUFBTSxJQUFJLENBQUMsY0FBYyxDQUFDLFlBQVksRUFBRSxTQUFTLEVBQUUsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLENBQUMsRUFDbkYsc0JBQXNCLEVBQUM7WUFDL0IsQ0FBQztZQUNELElBQUksU0FBUyxFQUFFLENBQUM7Z0JBQ1osTUFBTSxZQUFZLENBQUMsQ0FBQyxDQUFDLDZCQUE2QixFQUFFLENBQUM7WUFDekQsQ0FBQztRQUNMLENBQUM7UUFFRCxPQUFPLFVBQVUsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0gsZ0JBQWdCO0lBQ1IsS0FBSyxDQUFDLGNBQWMsQ0FDeEIsWUFBaUIsRUFDakIsS0FBb0MsRUFDcEMsS0FBMkIsRUFDM0IsV0FBb0IsSUFBSTtRQUV4QixNQUFNLGFBQWEsR0FBUSxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3ZDLElBQUksUUFBYSxDQUFDO1FBQ2xCLElBQUksS0FBSyxZQUFZLEVBQUUsQ0FBQyxNQUFNLENBQUMsU0FBUyxFQUFFLENBQUM7WUFDdkMsTUFBTSxNQUFNLEdBQUcsTUFBTSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsS0FBZSxDQUFDLENBQUM7WUFFN0QsZ0ZBQWdGO1lBQ2hGLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxFQUFFLENBQUM7Z0JBQ2pCLE1BQU0sWUFBWSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ25DLE1BQU0sSUFBSSxDQUFDLFdBQVcsQ0FBQyxZQUFZLEVBQUUsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDO2dCQUN0RCxPQUFPLEtBQUssQ0FBQztZQUNqQixDQUFDO2lCQUFNLENBQUM7Z0JBQ0osUUFBUSxHQUFHLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDckIsTUFBTSxZQUFZLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQztnQkFDckMsc0JBQUksTUFBTSxDQUFDLE1BQU0sRUFBSyxDQUFDLEdBQUUsQ0FBQztvQkFDdEIsTUFBTSxZQUFZLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQztnQkFDekMsQ0FBQztxQkFBTSxDQUFDO29CQUNKLGdEQUFnRDtvQkFDaEQsTUFBTSxZQUFZLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQztnQkFDekMsQ0FBQztZQUNMLENBQUM7UUFDTCxDQUFDO2FBQU0sSUFBSSxLQUFLLFlBQVksRUFBRSxDQUFDLE1BQU0sQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUNqRCxRQUFRLEdBQUcsS0FBWSxDQUFDO1FBQzVCLENBQUM7YUFBTSxJQUFJLEtBQUssWUFBWSxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ3pDLFFBQVEsR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDN0IsQ0FBQzthQUFNLElBQUksS0FBSyxZQUFZLEVBQUUsQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDNUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM3QixDQUFDO2FBQU0sSUFBSSxLQUFLLFlBQVksRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUN6QyxRQUFRLEdBQUcsS0FBSyxZQUFZLDJCQUFTLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDLENBQUUsS0FBYSxDQUFDO1FBQzlFLENBQUM7YUFBTSxDQUFDO1lBQ0osUUFBUSxHQUFHLEtBQVksQ0FBQztRQUM1QixDQUFDO1FBQ0QsS0FBSyxDQUFDLEtBQUssR0FBRyxRQUFRLENBQUM7UUFFdkIsTUFBTSxTQUFTLHFCQUFHLGFBQWEsRUFBSyxRQUFRLEVBQUM7UUFFN0MsSUFBSSxTQUFTLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDOUIsS0FBSyxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7UUFDekIsQ0FBQztRQUNELE9BQU8sU0FBUyxDQUFDO0lBQ3JCLENBQUM7SUFFRDs7OztPQUlHO0lBQ0gsZ0JBQWdCO0lBQ1IsZUFBZSxDQUFDLHlCQUFtRDtRQUN2RSw0QkFBNEI7UUFDNUIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEVBQXVCLENBQUM7UUFDbEQsTUFBTSxxQkFBcUIsR0FBMkIsRUFBRSxDQUFDO1FBRXpELEtBQUssTUFBTSxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLHlCQUF5QixDQUFDLEVBQUUsQ0FBQztZQUNuRSxJQUFJLEtBQUssRUFBRSxDQUFDO2dCQUNSLE1BQU0sb0JBQW9CLEdBQXlCO29CQUMvQyxTQUFTLEVBQUUsR0FBRztvQkFDZCxRQUFRLEVBQUUsQ0FBQyxDQUFDO29CQUNaLFFBQVEsRUFBRSxFQUFFO2lCQUNTLENBQUM7Z0JBRTFCLE1BQU0sU0FBUyxHQUFpQixLQUFLLENBQUMsU0FBUyxDQUFDO2dCQUVoRCw2QkFBNkI7Z0JBQzdCLG9CQUFvQixDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQzlCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUMsR0FBRztvQkFDckMsWUFBWSxFQUFFLFNBQVM7b0JBQ3ZCLFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCO29CQUNqQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO2lCQUNTLENBQUMsQ0FDN0IsQ0FBQztnQkFFRixlQUFlO2dCQUNmLE1BQU0sU0FBUyxHQUFpQixLQUFLLENBQUMsU0FBUyxDQUFDO2dCQUVoRCxJQUFJLFNBQVMsRUFBRSxDQUFDO29CQUNaLG9CQUFvQixDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQzlCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxFQUFFLENBQUMsR0FBRzt3QkFDckMsWUFBWSxFQUFFLFNBQVM7d0JBQ3ZCLFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCO3dCQUNqQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO3FCQUNTLENBQUMsQ0FDN0IsQ0FBQztnQkFDTixDQUFDO2dCQUVELHFCQUFxQixDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1lBQ3JELENBQUM7UUFDTCxDQUFDO1FBQ0QsT0FBTyxxQkFBcUIsQ0FBQztJQUNqQyxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSCxnQkFBZ0I7SUFDUixlQUFlLENBQ25CLFlBQStCLEVBQy9CLHNCQUFnRDtRQUVoRCxNQUFNLE1BQU0sR0FBRyxZQUFZLEVBQUUsYUFBYSxDQUFDLE1BQU0sQ0FBQyxNQUFNLElBQUksRUFBRSxDQUFDO1FBQy9ELE1BQU0sY0FBYyxHQUEyQixJQUFJLENBQUMsZUFBZSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDNUYsTUFBTSxjQUFjLEdBQTJCLEVBQUUsQ0FBQztRQUNsRCxNQUFNLGlCQUFpQixHQUFzQixJQUFJLENBQUMsa0JBQWtCLENBQUM7UUFDckUsSUFBSSxRQUFRLEdBQVksQ0FBQyxDQUFDO1FBRTFCLGtGQUFrRjtRQUNsRiwwRUFBMEU7UUFFMUUsNEVBQTRFO1FBQzVFLElBQUksa0JBQU0sQ0FBQyxNQUFNLEVBQUcsQ0FBQyxpQkFBSSxjQUFjLENBQUMsTUFBTSxFQUFHLENBQUMsR0FBRSxDQUFDO1lBQ2pELGlCQUFpQjtZQUNqQixJQUFJLENBQUMsWUFBWSxDQUNiLFlBQVksRUFDWixNQUFNLEVBQ04saUJBQWlCLEVBQ2pCLENBQUMsUUFBUSxFQUFFLEtBQUssRUFBRSxFQUFFLENBQUMsSUFBSSxFQUN6QixDQUFDLFFBQVEsRUFBRSxLQUFLLEVBQUUsRUFBRTtnQkFDaEIsS0FBSyxDQUFDLFFBQVEsNEJBQUssUUFBUSxNQUFDO2dCQUM1QixPQUFPLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsRUFBRSxFQUFFLGNBQUMsS0FBSyxDQUFDLFFBQVEsRUFBSSxDQUFDLEVBQUMsQ0FBQztZQUNqRixDQUFDLENBQ0osQ0FBQztZQUVGLHFGQUFxRjtZQUNyRixLQUFLLE1BQU0sQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFLENBQUM7Z0JBQzNELGlCQUFJLEtBQUssQ0FBQyxRQUFRLEVBQUksQ0FBQyxHQUFFLENBQUM7b0JBQ3RCLE9BQU8saUJBQWlCLENBQUMsR0FBRyxDQUFDLENBQUM7Z0JBQ2xDLENBQUM7WUFDTCxDQUFDO1FBQ0wsQ0FBQztRQUVELGlDQUFpQztRQUNqQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsaUJBQWlCLENBQUM7UUFFNUMsdUNBQXVDO1FBQ3ZDLEtBQUssTUFBTSxHQUFHLElBQUksY0FBYyxFQUFFLENBQUM7WUFDL0IsTUFBTSxNQUFNLEdBQUcsY0FBYyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ25DLElBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQ2pCLFdBQVcsQ0FBQyxFQUFFLG1CQUNWLGlCQUFpQixDQUFDLFdBQVcsQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDLEVBQUUsWUFBWSxDQUFDLEVBQUUsRUFBSyxXQUFXLENBQUMsWUFBWSxDQUFDLEVBQUUsRUFDdEcsRUFDSCxDQUFDO2dCQUNDLGNBQWMsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDaEMsQ0FBQztpQkFBTSxDQUFDO2dCQUNKLHlCQUF5QjtnQkFDekIsS0FBSyxNQUFNLE9BQU8sSUFBSSxNQUFNLENBQUMsUUFBUSxFQUFFLENBQUM7b0JBQ3BDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQzVELENBQUM7WUFDTCxDQUFDO1FBQ0wsQ0FBQztRQUVELHdGQUF3RjtRQUN4Riw0RUFBNEU7UUFDNUUsNEVBQTRFO1FBRTVFLE9BQU8sY0FBYyxDQUFDO0lBQzFCLENBQUM7SUFFRDs7Ozs7Ozs7T0FRRztJQUNILGdCQUFnQjtJQUNSLFlBQVksQ0FDaEIsWUFBaUIsRUFDakIsTUFBcUMsRUFDckMsUUFBMkIsRUFDM0IsS0FBNEUsRUFDNUUsTUFBNkU7UUFFN0UsbUJBQW1CO1FBQ25CLEtBQUssSUFBSSxDQUFDLElBQUksTUFBTSxFQUFFLENBQUM7WUFDbkIsSUFBSSxLQUFLLEdBQVEsU0FBUyxDQUFDO1lBQzNCLElBQUksU0FBUyxHQUFRLFNBQVMsQ0FBQztZQUMvQixJQUFJLEtBQUssR0FBcUMsU0FBUyxDQUFDO1lBRXhELElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsU0FBUyxHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxHQUFHLFFBQVEsQ0FBQyxTQUFTLEVBQUUsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDO2dCQUN0Ryw2REFBNkQ7Z0JBQzdELElBQUksS0FBSyxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsSUFBSSxNQUFNLENBQUMsUUFBUSxFQUFFLEtBQUssQ0FBQyxFQUFFLENBQUM7b0JBQ3BELE9BQU8sSUFBSSxDQUFDO2dCQUNoQixDQUFDO2dCQUNELFNBQVM7WUFDYixDQUFDO2lCQUFNLENBQUM7Z0JBQ0osd0VBQXdFO2dCQUN4RSxNQUFNLE9BQU8sR0FBRyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsT0FBTyxFQUFFLE1BQU0sSUFBSSxFQUFFLENBQUM7Z0JBQ2hELGtHQUFrRztnQkFDbEcsSUFBSSxtQkFBTyxDQUFDLE1BQU0sRUFBRyxDQUFDLEtBQUksSUFBSSxDQUFDLFlBQVksQ0FBQyxZQUFZLEVBQU8sT0FBTyxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsTUFBTSxDQUFDLEVBQUUsQ0FBQztvQkFDL0YsT0FBTyxJQUFJLENBQUM7Z0JBQ2hCLENBQUM7WUFDTCxDQUFDO1FBQ0wsQ0FBQztRQUNELE9BQU8sS0FBSyxDQUFDO0lBQ2pCLENBQUM7SUFFRDs7U0FFSztJQUVMOzs7OztPQUtHO0lBQ0ksS0FBSyxDQUFDLFFBQVEsQ0FBQyxZQUFxQixFQUFFLGVBQXVCLGtDQUEwQjtRQUMxRixNQUFNLFdBQVcsR0FBRyxJQUFJLEtBQUssRUFBVSxDQUFDO1FBQ3hDLE1BQU0sV0FBVyxHQUFZLE1BQU0sWUFBWSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO1FBQy9ELElBQUksaUJBQWlCLEdBQUcsSUFBSSxDQUFDO1FBRTdCLEtBQUssTUFBTSxLQUFLLElBQUksSUFBSSxDQUFDLHNCQUFzQixFQUFFLENBQUM7WUFDOUMsS0FBSyxNQUFNLE9BQU8sSUFBSSxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUM7Z0JBQ25DLElBQUksQ0FBQyxDQUFDLE1BQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUMsRUFBRSxDQUFDO29CQUNyRCxpQkFBaUIsR0FBRyxLQUFLLENBQUM7b0JBQzFCLFdBQVcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDOUMsQ0FBQztZQUNMLENBQUM7UUFDTCxDQUFDO1FBRUQsZ0JBQUksV0FBVyxDQUFDLE1BQU0sRUFBRyxDQUFDLEdBQUUsQ0FBQztZQUN6QixJQUFJLENBQUMsb0JBQW9CLENBQUMsWUFBWSxFQUFFLFdBQVcsRUFBRSxZQUFZLENBQUMsQ0FBQztRQUN2RSxDQUFDO1FBRUQsT0FBTyxXQUFXLElBQUksaUJBQWlCLENBQUM7SUFDNUMsQ0FBQztJQUVEOzs7O09BSUc7SUFDSCxnQkFBZ0I7SUFDUixLQUFLLENBQUMsY0FBYyxDQUFDLEtBQW9DO1FBQzdELE9BQU8sQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7OztPQUtHO0lBQ0gsZ0JBQWdCO0lBQ1IsS0FBSyxDQUFDLG9CQUFvQixDQUM5QixZQUFxQixFQUNyQixNQUFnQixFQUNoQixlQUF1QixrQ0FBMEI7UUFFakQsWUFBWSxDQUFDLENBQUMsQ0FBQyxZQUFZLEVBQUUsQ0FBQztRQUM5QixZQUFZLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FDcEIseUJBQVksRUFBQyxZQUFZLEVBQUUsTUFBTSxFQUFFO1lBQy9CLFVBQVUsRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUUsWUFBb0IsQ0FBQyxLQUFLLENBQUMsRUFBRSxLQUFLLENBQUM7U0FDdkUsQ0FBQyxFQUNGLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQ25DLENBQUM7SUFDTixDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQXFCLEVBQUUsZUFBdUIseUJBQWlCO1FBQ3JGLE1BQU0sTUFBTSxHQUFHLE1BQU0sWUFBWSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDcEQsSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUNqQixPQUFPLElBQUksQ0FBQztRQUNoQixDQUFDO1FBRUQsTUFBTSxFQUFFLEdBQUcsWUFBWSxDQUFDLENBQUMsQ0FBQyxZQUFZLEVBQUUsQ0FBQztRQUN6QyxZQUFZLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxHQUFHLHlCQUFZLEVBQUMsWUFBWSxFQUFFLE1BQU0sQ0FBQyxLQUFLLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFO1lBQzVFLElBQUksRUFBRSxPQUFPO1lBQ2IsT0FBTyxFQUFFLEtBQUs7U0FDakIsQ0FBQyxDQUFDO1FBRUgsT0FBTyxLQUFLLENBQUM7SUFDakIsQ0FBQztJQUVEOzs7OztPQUtHO0lBQ0ksS0FBSyxDQUFDLG1CQUFtQixDQUM1QixZQUFxQixFQUNyQixlQUF1QixrQ0FBMEI7UUFFakQseUJBQXlCO1FBQ3pCLHNJQUFzSTtRQUN0SSxNQUFNLFlBQVksQ0FBQyxDQUFDLENBQUMsNkJBQTZCLEVBQUUsQ0FBQztRQUVyRCxNQUFNLE1BQU0sR0FBMEIsTUFBTSxZQUFZLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO1FBQ3RGLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDakIsT0FBTyxJQUFJLENBQUM7UUFDaEIsQ0FBQztRQUVELFlBQVksQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFLENBQUM7UUFDOUIsWUFBWSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQ3BCLHlCQUFZLEVBQUMsWUFBWSxFQUFFLE1BQU0sRUFBRTtZQUMvQixVQUFVLEVBQUUsTUFBTSxDQUFDLEdBQUcsQ0FDbEIsQ0FBQyxLQUEwQixFQUFFLEVBQUUsQ0FDM0IsR0FBSSxZQUFvQixDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsRUFBRSxLQUFLLElBQUksS0FBSyxDQUFDLFNBQVMsRUFBRSxDQUM1RTtTQUNKLENBQUMsRUFDRixFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxDQUNuQyxDQUFDO1FBRUYsT0FBTyxLQUFLLENBQUM7SUFDakIsQ0FBQztDQUNKO0FBam9DRCxvREFpb0NDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtc3lzdGVtL2xpYi9jbGllbnQtZnVuY3Rpb25zL21hbmFnZW1lbnQtc2VydmljZS1ncy0xLnRzPzkwMWIiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqIFNlcnZpY2Ugb2YgbWFuYWdlbWVudCBjb2RlIEdTIDEgKi9cbmltcG9ydCB7IEdyYXBoQXBpIH0gZnJvbSAnQHNhZ2UveDMtc3lzdGVtLWFwaSc7XG5pbXBvcnQgeyBEYXRlVmFsdWUgfSBmcm9tICdAc2FnZS94dHJlbS1kYXRlLXRpbWUnO1xuaW1wb3J0IHsgZm9ybWF0IGFzIGZvcm1hdFN0cmluZywgaW50ZWdlciwgU3lzdGVtRXJyb3IgfSBmcm9tICdAc2FnZS94dHJlbS1zaGFyZWQnO1xuaW1wb3J0ICogYXMgdWkgZnJvbSAnQHNhZ2UveHRyZW0tdWknO1xuaW1wb3J0IHsgUGFyc2VCYXJDb2RlLCBQYXJzZWRCYXJjb2RlIH0gZnJvbSAnLi4vc2hhcmVkLWZ1bmN0aW9ucy9iYXJjb2RlLXBhcnNlcic7XG5pbXBvcnQgeyBEYXRhVGl0bGUgfSBmcm9tICcuLi9zaGFyZWQtZnVuY3Rpb25zL3BhcnNlZC1lbGVtZW50JztcbmltcG9ydCB7XG4gICAgQXN5bmNBbmRWb2lkRnVuY3Rpb24sXG4gICAgQXN5bmNDb21wb3NpdGVBbGxvd2VkLFxuICAgIEFzeW5jVm9pZEZ1bmN0aW9uLFxuICAgIEJhcmNvZGVNYW5hZ2VyU3VwcG9ydGVkRmllbGRzLFxuICAgIGNvbXBvc2l0ZUNvZGVQcmVmaXgsXG4gICAgRGF0YUZpZWxkTWFwcGVkLFxuICAgIERpY3Rpb25hcnlEYXRhQ29tcG9zaXRlLFxuICAgIERpY3Rpb25hcnlGaWVsZFN1cHBvcnRlZCxcbiAgICBEaWN0aW9uYXJ5U2VnbWVudCxcbiAgICBFbGVtZW50VHlwZVN1cHBvcnRlZCxcbiAgICBGaWVsZFNlZ21lbnQsXG4gICAgU2NyZWVuRmllbGRTdXBwb3J0ZWQsXG4gICAgU2VnbWVudEZvckRpY3Rpb25hcnksXG59IGZyb20gJy4vc2NyZWVuLW1hbmFnZW1lbnQtZ3MtMSc7XG5cbmV4cG9ydCBjb25zdCBlcnJvck1lc3NhZ2VDaGVja1lvdXJFbnRyeSA9IGBDaGVjayB5b3VyIGVudHJ5IGZvciB7eyNlYWNoIGZpZWxkTmFtZXN9fVxcbiAtIHt7dGhpc319e3svZWFjaH19YDtcbmV4cG9ydCBjb25zdCBlcnJvck1lc3NhZ2VFcnJvciA9ICdFcnJvcic7XG5cbmV4cG9ydCBjbGFzcyBNYW5hZ2VtZW50U2VydmljZUdzMSB7XG4gICAgLy8gUHJpdmF0ZSBkYXRhIGFyZWFcblxuICAgIC8qKlxuICAgICAqICBTdG9yZSBhbGwgY29kZXMgR1MgMSBzdXBwb3J0ZWQgYnkgYWNjZXNzIGNvZGUgKGZvciBzcGVlZHVwIGRlY29kaW5nKVxuICAgICAqL1xuXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX3NjcmVlbkZpZWxkc1N1cHBvcnRlZDogU2NyZWVuRmllbGRTdXBwb3J0ZWRbXSA9IFtdO1xuXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX2RpY3Rpb25hcnlTZWdtZW50OiBEaWN0aW9uYXJ5U2VnbWVudCA9IHt9IGFzIERpY3Rpb25hcnlTZWdtZW50O1xuXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX3NjcmVlbkZpZWxkc01hcHBlZDogRGF0YUZpZWxkTWFwcGVkW10gPSBbXTtcblxuICAgIC8qKiBAaW50ZXJuYWwgKi9cbiAgICBwcml2YXRlIF9kaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZXM6IERpY3Rpb25hcnlEYXRhQ29tcG9zaXRlID0ge30gYXMgRGljdGlvbmFyeURhdGFDb21wb3NpdGU7XG5cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBfYWJvcnREaXNwYXRjaDogYm9vbGVhbiA9IGZhbHNlO1xuXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX2Rpc3BhdGNoSW5Qcm9ncmVzczogYm9vbGVhbiA9IGZhbHNlO1xuXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX2luaXRpYWxpemF0aW9uSW5Qcm9ncmVzczogYm9vbGVhbiA9IGZhbHNlO1xuXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX3Bvc3RBY3Rpb25BYm9ydERpc3BhdGNoPzogQXN5bmNBbmRWb2lkRnVuY3Rpb247XG5cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBfY2hlY2tDb21wb3NpdGVEYXRhQWxsb3dlZD86IEFzeW5jQ29tcG9zaXRlQWxsb3dlZDtcblxuICAgIC8qKiBAaW50ZXJuYWwgKi9cbiAgICBwcml2YXRlIF9wYXJzZUJhckNvZGU6IFBhcnNlQmFyQ29kZTtcblxuICAgIC8qKlxuICAgICAqIEluaXRpYWxpemUgcGVybWFuZW50IGRhdGEgZm9yIHBhZ2VcbiAgICAgKiBAcGFyYW0gX3N0b3JhZ2VLZXkgICAgICAgOiBzdG9yYWdlIGtleSB1c2VkIGZvciB0aGlzIHBhZ2VcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IF9zdG9yYWdlS2V5OiBzdHJpbmcpIHtcbiAgICAgICAgdGhpcy5fcGFyc2VCYXJDb2RlID0gbmV3IFBhcnNlQmFyQ29kZSgpO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoaXMgTWV0aG9kIGJ1aWxkIGluc3RhbmNlIHdpdGggcmV0cmlldmluZyBhbGwgZGF0YVxuICAgICAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgOiBjdXJyZW50IHBhZ2VcbiAgICAgKiBAcGFyYW0gZGljdGlvbmFyeUZpZWxkU3VwcG9ydGVkIDogcGFnZSBmaWVsZHMgc3VwcG9ydGVkXG4gICAgICogQHBhcmFtIGRpY3Rpb25hcnlEYXRhQ29tcG9zaXRlcyA6IGV4dHJhY3RlZCBjb21wb3NpdGUgZGF0YSwgbWF5IGJlIHNlbmQgdG8gc3RvcmFnZVxuICAgICAqIEBwYXJhbSBjaGVja0NvbXBvc2l0ZURhdGFBbGxvd2VkPyA6IG9wdGlvbmFsIGNsaWVudCBjYWxsYmFjayB0byBjaGVjayBjb21wb3NpdGUgZGF0YSBjb2RlIGJlZm9yZSB0byBkaXNwYXRjaCB0aGVtXG4gICAgICovXG5cbiAgICBwdWJsaWMgYXN5bmMgaW5pdGlhbGl6ZShcbiAgICAgICAgcGFnZUluc3RhbmNlOiB1aS5QYWdlPEdyYXBoQXBpPixcbiAgICAgICAgZGljdGlvbmFyeUZpZWxkU3VwcG9ydGVkOiBEaWN0aW9uYXJ5RmllbGRTdXBwb3J0ZWQgPSB7fSBhcyBEaWN0aW9uYXJ5RmllbGRTdXBwb3J0ZWQsXG4gICAgICAgIGRpY3Rpb25hcnlEYXRhQ29tcG9zaXRlczogRGljdGlvbmFyeURhdGFDb21wb3NpdGUgPSB7fSBhcyBEaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZSxcbiAgICAgICAgY2hlY2tDb21wb3NpdGVEYXRhQWxsb3dlZD86IEFzeW5jQ29tcG9zaXRlQWxsb3dlZCxcbiAgICApOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgICAgICAgaWYgKCFwYWdlSW5zdGFuY2UgfHwgIXRoaXMuX3N0b3JhZ2VLZXkpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBTeXN0ZW1FcnJvcignSW52YWxpZCBhcmd1bWVudHMnKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHRyeSB7XG4gICAgICAgICAgICB0aGlzLl9kaXNwYXRjaEluUHJvZ3Jlc3MgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMuX2luaXRpYWxpemF0aW9uSW5Qcm9ncmVzcyA9IHRydWU7XG4gICAgICAgICAgICB0aGlzLl9jaGVja0NvbXBvc2l0ZURhdGFBbGxvd2VkID0gY2hlY2tDb21wb3NpdGVEYXRhQWxsb3dlZDtcblxuICAgICAgICAgICAgLy8gdWkuY29uc29sZS53YXJuKGBGaWVsZChzKSBzdXBwb3J0ZWQgOlxcbiR7SlNPTi5zdHJpbmdpZnkoZGljdGlvbmFyeUZpZWxkU3VwcG9ydGVkKX1gKTtcbiAgICAgICAgICAgIC8vIHVpLmNvbnNvbGUud2FybihgQ29tcG9zaXRlIGRhdGEgOlxcbiR7SlNPTi5zdHJpbmdpZnkoZGljdGlvbmFyeURhdGFDb21wb3NpdGVzKX1gKTtcblxuICAgICAgICAgICAgLy8gUHJvY2VzcyBjb21wb3NpdGUgZGF0YSBiZWZvcmUgdG8gY29udGludWVcbiAgICAgICAgICAgIGlmIChPYmplY3Qua2V5cyhkaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZXMgPz8gKHt9IGFzIERpY3Rpb25hcnlEYXRhQ29tcG9zaXRlKSkubGVuZ3RoID4gMCkge1xuICAgICAgICAgICAgICAgIHRoaXMuY2xlYXJDb21wb3NpdGVEYXRhKCk7XG4gICAgICAgICAgICAgICAgLy8gRXJhc2Ugc3RvcmFnZVxuICAgICAgICAgICAgICAgIHRoaXMuX3JlbW92ZUNvbXBvc2l0ZURhdGFTdG9yYWdlKHBhZ2VJbnN0YW5jZSk7XG4gICAgICAgICAgICAgICAgdGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzID0gZGljdGlvbmFyeURhdGFDb21wb3NpdGVzID8/ICh7fSBhcyBEaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZSk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIHRoaXMubG9hZENvbXBvc2l0ZURhdGEocGFnZUluc3RhbmNlKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKE9iamVjdC5rZXlzKGRpY3Rpb25hcnlGaWVsZFN1cHBvcnRlZCA/PyAoe30gYXMgRGljdGlvbmFyeUZpZWxkU3VwcG9ydGVkKSkubGVuZ3RoID4gMCkge1xuICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuc2V0U2NyZWVuRmllbGRTdXBwb3J0ZWQoXG4gICAgICAgICAgICAgICAgICAgIHBhZ2VJbnN0YW5jZSxcbiAgICAgICAgICAgICAgICAgICAgZGljdGlvbmFyeUZpZWxkU3VwcG9ydGVkID8/ICh7fSBhcyBEaWN0aW9uYXJ5RmllbGRTdXBwb3J0ZWQpLFxuICAgICAgICAgICAgICAgICk7XG5cbiAgICAgICAgICAgICAgICAvLyBtYXBwZWQgZGF0YSBoYXMgbm90IGRlbGV0ZWQgYWZ0ZXIgZGlzcGF0Y2hpbmdcbiAgICAgICAgICAgICAgICBpZiAodGhpcy5pc0V4aXN0c0RhdGFDb21wb3NpdGUgJiYgdGhpcy5pc0V4aXN0c0ZpZWxkc01hcHBlZCkge1xuICAgICAgICAgICAgICAgICAgICBpZiAodGhpcy5fYmVnaW5EaXNwYXRjaGluZygpKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIC8vIHVzZSBleGlzdGluZyBmaXJzdCBzZWdtZW50IGZpZWxkLCB0ZW1wb3JhcnkgaWdub3JpbmcgcmVzdWx0XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29uc3QgcmVzdWx0cyA9IChhd2FpdCB0aGlzLl9kaXNwYXRjaERhdGFUb0ZpZWxkcyhcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcGFnZUluc3RhbmNlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLl9zY3JlZW5GaWVsZHNNYXBwZWRbMF0ubWFpbkZpZWxkIGFzIEJhcmNvZGVNYW5hZ2VyU3VwcG9ydGVkRmllbGRzLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICApLmNhdGNoKCgpID0+IGZhbHNlKSkgYXMgYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgRXJyb3IgZGlzcGF0Y2hpbmcgaW5pdGlhbCBkYXRhIDpcXG4ke2Vycm9yfWApO1xuICAgICAgICAgICAgICAgICAgICAgICAgfSBmaW5hbGx5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLl9lbmRpbmdEaXNwYXRjaGluZygpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgVW5leHBlY3RlZCBpbml0aWFsaXphdGlvbiBlcnJvciA6XFxuJHtlcnJvcn1gKTtcbiAgICAgICAgfSBmaW5hbGx5IHtcbiAgICAgICAgICAgIHRoaXMuX2luaXRpYWxpemF0aW9uSW5Qcm9ncmVzcyA9IGZhbHNlO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogUmV0dXJuIGlmIGRpc3BhdGNoIHNlc3Npb24gaXMgaW4gcHJvZ3Jlc3NcbiAgICAgKi9cbiAgICBwdWJsaWMgZ2V0IGlzRGlzcGF0Y2hJblByb2dyZXNzKCk6IGJvb2xlYW4ge1xuICAgICAgICByZXR1cm4gdGhpcy5fZGlzcGF0Y2hJblByb2dyZXNzO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFJldHVybiBpZiBpbml0aWFsaXphdGlvbiBpcyBpbiBwcm9ncmVzc1xuICAgICAqL1xuICAgIHB1YmxpYyBnZXQgaXNJbml0aWFsaXphdGlvbkluUHJvZ3Jlc3MoKTogYm9vbGVhbiB7XG4gICAgICAgIHJldHVybiB0aGlzLl9pbml0aWFsaXphdGlvbkluUHJvZ3Jlc3M7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogVGhpcyBmdW5jdGlvbiBzdGFydCBkaXNwYXRjaGluZ1xuICAgICAqIEByZXR1cm5zIHRydWUgd2hlbiBhIG5ldyBzZXNzaW9uIGhhcyBzdGFydGVkLCBmYWxzZSB3aGVuIGFscmVhZHkgaW4gcHJvZ3Jlc3NcbiAgICAgKi9cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBfYmVnaW5EaXNwYXRjaGluZygpOiBib29sZWFuIHtcbiAgICAgICAgY29uc3Qgb2xkRGlzcGF0Y2hJblByb2dyZXNzID0gdGhpcy5fZGlzcGF0Y2hJblByb2dyZXNzO1xuICAgICAgICB0aGlzLl9kaXNwYXRjaEluUHJvZ3Jlc3MgPSB0cnVlO1xuICAgICAgICB0aGlzLl9hYm9ydERpc3BhdGNoID0gZmFsc2U7XG4gICAgICAgIHRoaXMuX3Bvc3RBY3Rpb25BYm9ydERpc3BhdGNoID0gdW5kZWZpbmVkO1xuICAgICAgICByZXR1cm4gIW9sZERpc3BhdGNoSW5Qcm9ncmVzcztcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUZXJtaW5hdGUgY3VycmVudCBkaXNwYXRjaCBzZXNzaW9uXG4gICAgICogQHJldHVybnMgdHJ1ZSB3aGVuIHNlc3Npb24gaGFzIGJlZW4gdGVybWluYXRlZCwgZmFsc2Ugd2hlbiBub24gc2Vzc2lvbiBleGlzdFxuICAgICAqL1xuICAgIC8qKiBAaW50ZXJuYWwgKi9cbiAgICBwcml2YXRlIF9lbmRpbmdEaXNwYXRjaGluZygpOiBib29sZWFuIHtcbiAgICAgICAgY29uc3Qgb2xkRGlzcGF0Y2hJblByb2dyZXNzID0gdGhpcy5fZGlzcGF0Y2hJblByb2dyZXNzO1xuICAgICAgICB0aGlzLl9kaXNwYXRjaEluUHJvZ3Jlc3MgPSBmYWxzZTtcbiAgICAgICAgdGhpcy5fYWJvcnREaXNwYXRjaCA9IGZhbHNlO1xuICAgICAgICB0aGlzLl9wb3N0QWN0aW9uQWJvcnREaXNwYXRjaCA9IHVuZGVmaW5lZDtcbiAgICAgICAgcmV0dXJuIG9sZERpc3BhdGNoSW5Qcm9ncmVzcztcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBSZXF1ZXN0IHRvIGFib3J0IGRpc3BhdGNoIHdpdGhvdXQgZXJyb3IgKGVuZCBvZiBzY2FuKSA6XG4gICAgICogVGhpcyBpcyB1c2VkIG9ubHkgd2hlbiBvbkNoYW5nZSgpIGhhcyBwZXJmb3JtZWQgc29tZSBvcGVyYXRpb25zLFxuICAgICAqIGllIDogc3dpdGNoaW5nIHBhZ2UuLi4gZXhjZXB0IHdoZW4gaW5pdGlhbGl6YXRpb24gaXMgaW4gcHJvZ3Jlc3NcbiAgICAgKiBAcGFyYW0ge2Z1bmN0aW9ufSAgICBvcHRpb25hbCBjYWxsYmFjayB0byBiZSBleGVjdXRlZCBhcHByb3guIDEwMG1zIGFmdGVyIGVuZCBvZiBkaXNwYXRjaGluZy5cbiAgICAgKiBAcmV0dXJucyB7Ym9vbGVhbn0gICB0cnVlIHdoZW4gcmVxdWVzdCBoYXMgYmUgc2V0XG4gICAgICovXG4gICAgcHVibGljIGFib3J0RGlzcGF0Y2gocG9zdEFjdGlvbkFib3J0RGlzcGF0Y2g/OiBBc3luY0FuZFZvaWRGdW5jdGlvbik6IGJvb2xlYW4ge1xuICAgICAgICB0aGlzLl9hYm9ydERpc3BhdGNoID0gZmFsc2U7XG4gICAgICAgIHRoaXMuX3Bvc3RBY3Rpb25BYm9ydERpc3BhdGNoID0gdW5kZWZpbmVkO1xuICAgICAgICBpZiAodGhpcy5fZGlzcGF0Y2hJblByb2dyZXNzKSB7XG4gICAgICAgICAgICB0aGlzLl9hYm9ydERpc3BhdGNoID0gdHJ1ZTtcbiAgICAgICAgICAgIGlmICghdGhpcy5pc0luaXRpYWxpemF0aW9uSW5Qcm9ncmVzcykge1xuICAgICAgICAgICAgICAgIHRoaXMuX3Bvc3RBY3Rpb25BYm9ydERpc3BhdGNoID0gcG9zdEFjdGlvbkFib3J0RGlzcGF0Y2g7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gdGhpcy5pc0Fib3J0RGlzcGF0Y2hJblByb2dyZXNzO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFJldHVybiBpZiBhYm9ydCBkaXNwYXRjaCBzZXNzaW9uIGlzIHJlcXVlc3RlZFxuICAgICAqL1xuICAgIHB1YmxpYyBnZXQgaXNBYm9ydERpc3BhdGNoSW5Qcm9ncmVzcygpOiBib29sZWFuIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuX2Fib3J0RGlzcGF0Y2g7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQ2FsbGVkIHdoZW4gZmllbGQgdXBkYXRlIGlzIGluIHByb2dyZXNzXG4gICAgICogQHBhcmFtIHBhZ2VJbnN0YW5jZSBjdXJyZW50IHBhZ2VcbiAgICAgKiBAcGFyYW0gY3VycmVudEZpZWxkIHJlZmVyZW5jZSBvZiBmaWVsZCB0byB1cGRhdGluZ1xuICAgICAqIEBwYXJhbSByYXdEYXRhIHJlY2VpdmVkIHJhdyBkYXRhXG4gICAgICogQHBhcmFtIGFwcGVuZENvbXBvc2l0ZURhdGEgdHJ1ZSB3aGVuIGlzIG5lY2Vzc2FyeSB0byBhcHBlbmRpbmcgY3VycmVudCBkYXRlIHRvIHByZXZpb3VzIHNldFxuICAgICAqIEByZXR1cm4gdHJ1ZSB3aGVuIGlzIG5vdCBuZWNlc3NhcnkgdG8gY29udGludWUgYW5kIGFmZmVjdCBhIHZhbHVlIDogY29tcG9zaXRlIHZhbHVlIGhhcyBiZWVuIHByb2Nlc3NlZFxuICAgICAqL1xuICAgIHB1YmxpYyBhc3luYyBzY2FuKFxuICAgICAgICBwYWdlSW5zdGFuY2U6IHVpLlBhZ2U8R3JhcGhBcGk+LFxuICAgICAgICBjdXJyZW50RmllbGQ6IEJhcmNvZGVNYW5hZ2VyU3VwcG9ydGVkRmllbGRzLFxuICAgICAgICByYXdEYXRhOiBhbnksXG4gICAgICAgIGFwcGVuZENvbXBvc2l0ZURhdGE6IGJvb2xlYW4gPSBmYWxzZSxcbiAgICApOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgICAgICAgaWYgKHRoaXMuX2JlZ2luRGlzcGF0Y2hpbmcoKSkge1xuICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICBsZXQgcmVzdWx0ID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICAvLyB3aGVuIGlzIG5vdCBhIGNvbXBvc2l0ZSBkYXRhLCBpcyBub3QgbmVjZXNzYXJ5IHRvIHByb2Nlc3NcbiAgICAgICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgICAgICFyYXdEYXRhIHx8XG4gICAgICAgICAgICAgICAgICAgIHR5cGVvZiByYXdEYXRhICE9PSAnc3RyaW5nJyB8fFxuICAgICAgICAgICAgICAgICAgICByYXdEYXRhLmxlbmd0aCA8IDQgfHxcbiAgICAgICAgICAgICAgICAgICAgIU51bWJlcihyYXdEYXRhLm1hdGNoKGNvbXBvc2l0ZUNvZGVQcmVmaXgpPy5sZW5ndGgpIHx8XG4gICAgICAgICAgICAgICAgICAgICEoYXdhaXQgdGhpcy5fZGVjb2RlQ29tcG9zaXRlRGF0YShyYXdEYXRhLCBhcHBlbmRDb21wb3NpdGVEYXRhKSlcbiAgICAgICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5fZW5kaW5nRGlzcGF0Y2hpbmcoKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIC8vIFdoZW4gY29tcG9zaXRlIGRhdGEgaGF2ZSBza2lwcGVkLCBub3RoaW5nIHRvIGRvLCByZXBvcnQgbm8gZXJyb3JzXG4gICAgICAgICAgICAgICAgaWYgKHRoaXMuaXNFeGlzdHNEYXRhQ29tcG9zaXRlKSB7XG4gICAgICAgICAgICAgICAgICAgIGxldCBfcG9zdEFjdGlvblRvRG86IEFzeW5jQW5kVm9pZEZ1bmN0aW9uO1xuICAgICAgICAgICAgICAgICAgICBjb25zdCBfc291bmRPcmlnaW5hbFZhbHVlID0gYXdhaXQgdGhpcy5fc2V0U291bmRGaWVsZChwYWdlSW5zdGFuY2UsIGN1cnJlbnRGaWVsZCwgdHJ1ZSk7XG4gICAgICAgICAgICAgICAgICAgIHRyeSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXN1bHQgPSAoYXdhaXQgdGhpcy5fZGlzcGF0Y2hEYXRhVG9GaWVsZHMocGFnZUluc3RhbmNlLCBjdXJyZW50RmllbGQpLmNhdGNoKFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICgpID0+IGZhbHNlLFxuICAgICAgICAgICAgICAgICAgICAgICAgKSkgYXMgYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgLy8gU3BlY2lhbCBhY3Rpb24gdG8gZG8gYWZ0ZXIgZXhpdGluZyBhIGZ1bmN0aW9uXG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAocmVzdWx0ICYmIHRoaXMuaXNBYm9ydERpc3BhdGNoSW5Qcm9ncmVzcyAmJiB0aGlzLl9wb3N0QWN0aW9uQWJvcnREaXNwYXRjaCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIF9wb3N0QWN0aW9uVG9EbyA9IHRoaXMuX3Bvc3RBY3Rpb25BYm9ydERpc3BhdGNoO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9IGZpbmFsbHkge1xuICAgICAgICAgICAgICAgICAgICAgICAgc2V0VGltZW91dChhc3luYyAoKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYXdhaXQgdGhpcy5fc2V0U291bmRGaWVsZChwYWdlSW5zdGFuY2UsIGN1cnJlbnRGaWVsZCwgX3NvdW5kT3JpZ2luYWxWYWx1ZSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlmIChfcG9zdEFjdGlvblRvRG8pIGF3YWl0IF9wb3N0QWN0aW9uVG9EbygpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHVpLmNvbnNvbGUuZXJyb3IoYERpc3BhdGNoaW5nIHBvc3QgZG9uZSBhY3Rpb24gZXJyb3IgOlxcbiR7ZXJyb3J9YCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgfSwgMTAwKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuX2NsZWFyRmllbGQocGFnZUluc3RhbmNlLCBjdXJyZW50RmllbGQpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICByZXR1cm4gcmVzdWx0O1xuICAgICAgICAgICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgICAgICAgICB1aS5jb25zb2xlLmVycm9yKGBEaXNwYXRjaGluZyBlcnJvciA6JHtlcnJvcn1gKTtcbiAgICAgICAgICAgIH0gZmluYWxseSB7XG4gICAgICAgICAgICAgICAgdGhpcy5fZW5kaW5nRGlzcGF0Y2hpbmcoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICB1aS5jb25zb2xlLmVycm9yKGBEaXNwYXRjaGluZyBub3QgYXZhaWxhYmxlYCk7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiByZXR1cm5zIGlmIHRoZSBmaWVsZCBzdXBwb3J0IHNvdW5kIG1hbmFnZW1lbnRcbiAgICAgKiBAcGFyYW0gb3JpZ2luYWxGaWVsZFxuICAgICAqIEByZXR1cm5zXG4gICAgICovXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX2dldElzU3VwcG9ydGVkU291bmRGaWVsZChjdXJyZW50RmllbGQ6IEJhcmNvZGVNYW5hZ2VyU3VwcG9ydGVkRmllbGRzIHwgdW5kZWZpbmVkKTogYm9vbGVhbiB7XG4gICAgICAgIHJldHVybiBjdXJyZW50RmllbGQgaW5zdGFuY2VvZiB1aS5maWVsZHMuUmVmZXJlbmNlIHx8IGN1cnJlbnRGaWVsZCBpbnN0YW5jZW9mIHVpLmZpZWxkcy5GaWx0ZXJTZWxlY3Q7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogV2hlbiBwb3NzaWJsZSwgY2hhbmdlcyB0aGUgc291bmQgbW9kZSBhY3RpdmF0aW9uIHN0YXRlIGFuZCByZXR1cm5zIHRoZSBvbGQgdmFsdWVcbiAgICAgKiBAcGFyYW0gY3VycmVudEZpZWxkIGN1cnJlbnQgZmllbGQgb3IgdW5kZWZpbmVkXG4gICAgICogQHBhcmFtIGRpc2FibGVTb3VuZCB0cnVlIGZvciBkaXNhYmxlIHNvdW5kIGZvciB0aGlzIGZpZWxkXG4gICAgICogQHJldHVybnMgb2xkIHZhbHVlXG4gICAgICovXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgYXN5bmMgX3NldFNvdW5kRmllbGQoXG4gICAgICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZTxHcmFwaEFwaT4sXG4gICAgICAgIGN1cnJlbnRGaWVsZDogYW55IHwgdW5kZWZpbmVkLFxuICAgICAgICBkaXNhYmxlU291bmQ6IGJvb2xlYW4sXG4gICAgICAgIHJlZnJlc2hGaWVsZCA9IHRydWUsXG4gICAgKTogUHJvbWlzZTxib29sZWFuPiB7XG4gICAgICAgIGNvbnN0IG9yaWdpbmFsSXNTb3VuZERpc2FibGVkID0gY3VycmVudEZpZWxkPy5pc1NvdW5kRGlzYWJsZWQgPz8gZmFsc2U7XG4gICAgICAgIGlmIChjdXJyZW50RmllbGQgJiYgZGlzYWJsZVNvdW5kICE9PSBvcmlnaW5hbElzU291bmREaXNhYmxlZCAmJiB0aGlzLl9nZXRJc1N1cHBvcnRlZFNvdW5kRmllbGQoY3VycmVudEZpZWxkKSkge1xuICAgICAgICAgICAgY3VycmVudEZpZWxkLmlzU291bmREaXNhYmxlZCA9IGRpc2FibGVTb3VuZDtcbiAgICAgICAgICAgIGlmIChyZWZyZXNoRmllbGQpIHtcbiAgICAgICAgICAgICAgICBhd2FpdCBwYWdlSW5zdGFuY2UuJC5jb21taXRWYWx1ZUFuZFByb3BlcnR5Q2hhbmdlcygpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBvcmlnaW5hbElzU291bmREaXNhYmxlZDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBDbGVhciBjdXJyZW50IFVJIGZpZWxkIHdpdGggbnVsbCB2YWx1ZSBhbmQgdXBkYXRlIHBhZ2UuXG4gICAgICogQHBhcmFtIHBhZ2VJbnN0YW5jZSBjdXJyZW50IHBhZ2VcbiAgICAgKiBAcGFyYW0gY3VycmVudEZpZWxkIGN1cnJlbnQgZmllbGQgdG8gY2xlYXJcbiAgICAgKiBAcGFyYW0gc2V0Rm9jdXMgb3B0aW9uYWwgdmFsdWUgbXVzdCBiZSB0cnVlIHdoZW4gZm9jdXMgbXVzdCBiZSBwZXJmb3JtZWQgaW4gcmVJbml0aWFsaXppbmdcbiAgICAgKi9cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBhc3luYyBfY2xlYXJGaWVsZChcbiAgICAgICAgcGFnZUluc3RhbmNlOiB1aS5QYWdlPEdyYXBoQXBpLCBhbnk+LFxuICAgICAgICBjdXJyZW50RmllbGQ6IEJhcmNvZGVNYW5hZ2VyU3VwcG9ydGVkRmllbGRzLFxuICAgICAgICBzZXRGb2N1czogYm9vbGVhbiA9IHRydWUsXG4gICAgKSB7XG4gICAgICAgIGN1cnJlbnRGaWVsZC52YWx1ZSA9IG51bGw7XG4gICAgICAgIC8vIFJlcXVlc3QgYWxsIGNoYW5nZXMgdG8gcGFnZSAob3B0aW9uYWwgZmllbGQgYW5kIHVuaXQpIGJlZm9yZSBhbnkgYWN0aW9uXG4gICAgICAgIGF3YWl0IHBhZ2VJbnN0YW5jZS4kLmNvbW1pdFZhbHVlQW5kUHJvcGVydHlDaGFuZ2VzKCk7XG5cbiAgICAgICAgaWYgKHNldEZvY3VzKSB7XG4gICAgICAgICAgICBjdXJyZW50RmllbGQuZm9jdXMoKTtcbiAgICAgICAgfVxuICAgICAgICAvLyBGb3JjZSB2YWxpZGF0aW9uXG4gICAgICAgIGF3YWl0IGN1cnJlbnRGaWVsZC52YWxpZGF0ZSgpLmNhdGNoKCgpID0+IGZhbHNlKTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBEZWNvZGUgcmF3IGRhdGEgdG8gb25lIG9yIG1vcmUgZGF0YSBmaWVsZHNcbiAgICAgKiBAcGFyYW0gcmF3RGF0YSByYXcgY29tcG9zaXRlIGRhdGEgYmVmb3JlIGRlY29kaW5nXG4gICAgICogQHBhcmFtIGFwcGVuZENvbXBvc2l0ZURhdGEgbWF5IGFwcGx5IG9ubHkgd2hlbiB2YWxpZCByZWNlaXZlZCBkYXRhIG11c3QgYmUgcmVwbGFjZSBvciBhcHBlbmRcbiAgICAgKiBAcmV0dXJucyB0cnVlIHdoZW4gZGF0YSBoYXMgdmFsaWQgYW5kIG9wZXJhdGlvbiBmdWxseSBwZXJmb3JtZWRcbiAgICAgKi9cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBhc3luYyBfZGVjb2RlQ29tcG9zaXRlRGF0YShyYXdEYXRhOiBzdHJpbmcsIGFwcGVuZENvbXBvc2l0ZURhdGE6IGJvb2xlYW4gPSBmYWxzZSk6IFByb21pc2U8Ym9vbGVhbj4ge1xuICAgICAgICBjb25zdCBleHRyYWN0ZWRDb21wb3NpdGU6IERpY3Rpb25hcnlEYXRhQ29tcG9zaXRlID0ge30gYXMgRGljdGlvbmFyeURhdGFDb21wb3NpdGU7XG5cbiAgICAgICAgdWkuY29uc29sZS5kZWJ1ZyhgaW5pdGlhbCBkYXRhIHJhdyA6ICR7SlNPTi5zdHJpbmdpZnkocmF3RGF0YSl9LCBzaXplIDogJHtyYXdEYXRhLmxlbmd0aH1gKTtcblxuICAgICAgICBsZXQgcGFyc2VkQmFyY29kZTogUGFyc2VkQmFyY29kZTtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIHBhcnNlZEJhcmNvZGUgPSB0aGlzLl9wYXJzZUJhckNvZGUucGFyc2VCYXJjb2RlKHJhd0RhdGEpO1xuICAgICAgICAgICAgdWkuY29uc29sZS5kZWJ1ZyhgUmF3RGF0YSA6XFxuJHtyYXdEYXRhfVxcblBhcnNlZCBjb2RlKHMpIDpcXG4ke0pTT04uc3RyaW5naWZ5KHBhcnNlZEJhcmNvZGUpfWApO1xuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5kZWJ1ZyhgRVJST1IgaW4gcGFyc2VCYXJjb2RlIDpcXG4ke2Vycm9yfWApO1xuICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG5cbiAgICAgICAgLyoqXG4gICAgICAgICAqIFdoZW4gdGhlIGJsb2NrIGRvZXMgbm90IGluY2x1ZGUgYSBwcmVmaXggb3Igd2hlbiBpdCBpcyBub3QgcmVjb2duaXplZCBieSB0aGUgcGFyc2VyLFxuICAgICAgICAgKiB0aGUgR1MxIGNvbXBvc2l0ZSBjb2RlIGJsb2NrIHJlcXVpcmVzIGluIHRoaXMgY2FzZSBtb3JlIHRoYW4gb25lIEFJIGNvZGUgdG8gYmUgY29uc2lkZXJlZCxcbiAgICAgICAgICogYXMgYSBzaW5nbGUgdmFsdWUgY291bGQgYmUgaW5jb3JyZWN0bHkgY29uc2lkZXJlZCBjb21wb3NpdGUuXG4gICAgICAgICAqL1xuICAgICAgICBpZiAoXG4gICAgICAgICAgICAhcGFyc2VkQmFyY29kZS5wYXJzZWRDb2RlSXRlbXMubGVuZ3RoIHx8XG4gICAgICAgICAgICAocGFyc2VkQmFyY29kZS5wYXJzZWRDb2RlSXRlbXMubGVuZ3RoIDwgMiAmJiBwYXJzZWRCYXJjb2RlLmNvZGVOYW1lID09PSAnJylcbiAgICAgICAgKSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cblxuICAgICAgICAvLyBTdG9yZSBkYXRhIGludG8gY29tcG9zaXRlIGRhdGEgc3RvcmFnZVxuICAgICAgICBmb3IgKGNvbnN0IHBhcnNlZENvZGVJdGVtIG9mIHBhcnNlZEJhcmNvZGUucGFyc2VkQ29kZUl0ZW1zKSB7XG4gICAgICAgICAgICAvLyBBZGQgYSBuZXcgZGF0YSBlbnRyeVxuICAgICAgICAgICAgZXh0cmFjdGVkQ29tcG9zaXRlW3BhcnNlZENvZGVJdGVtLmVsZW1lbnREYXRhVGl0bGVdID0ge1xuICAgICAgICAgICAgICAgIERhdGFUaXRsZTogcGFyc2VkQ29kZUl0ZW0uZWxlbWVudERhdGFUaXRsZSxcbiAgICAgICAgICAgICAgICBkYXRhOiBwYXJzZWRDb2RlSXRlbS5kYXRhLFxuICAgICAgICAgICAgICAgIHVuaXQ6IHBhcnNlZENvZGVJdGVtLnVuaXQsXG4gICAgICAgICAgICB9O1xuICAgICAgICB9XG5cbiAgICAgICAgLy8gdWkuY29uc29sZS53YXJuKGBjb21wb3NpdGUgZGF0YSBleGlzdGluZyA6ICR7SlNPTi5zdHJpbmdpZnkodGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzKX1gKTtcbiAgICAgICAgLy8gdWkuY29uc29sZS53YXJuKGBjb21wb3NpdGUgZGF0YSBsb2FkZWQgOiAke0pTT04uc3RyaW5naWZ5KGV4dHJhY3RlZENvbXBvc2l0ZSl9YCk7XG5cbiAgICAgICAgLy8gRGljdGlvbmFyeSB1cGRhdGVcbiAgICAgICAgaWYgKCFhcHBlbmRDb21wb3NpdGVEYXRhKSB7XG4gICAgICAgICAgICB0aGlzLmNsZWFyQ29tcG9zaXRlRGF0YSgpO1xuICAgICAgICAgICAgdGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzID0gZXh0cmFjdGVkQ29tcG9zaXRlO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgZm9yIChjb25zdCBba2V5LCB2YWx1ZV0gb2YgT2JqZWN0LmVudHJpZXMoZXh0cmFjdGVkQ29tcG9zaXRlKSkge1xuICAgICAgICAgICAgICAgIHRoaXMuX2RpY3Rpb25hcnlEYXRhQ29tcG9zaXRlc1trZXkgYXMgRGF0YVRpdGxlXSA9IHZhbHVlO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgLy8gdWkuY29uc29sZS5kZWJ1ZyhgY29tcG9zaXRlIGRhdGEgdXBkYXRlZCA6ICR7SlNPTi5zdHJpbmdpZnkodGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzKX1gKTtcblxuICAgICAgICAvLyBiZWZvcmUgdG8gbWFwLCBjaGVjayBpZiBhbGxvd2VkXG5cbiAgICAgICAgaWYgKCEoYXdhaXQgdGhpcy5faXNEYXRhQ29tcG9zaXRlQWxsb3dlZCgpKSkge1xuICAgICAgICAgICAgdGhpcy5jbGVhckNvbXBvc2l0ZURhdGEoKTtcbiAgICAgICAgICAgIHJldHVybiB0cnVlO1xuICAgICAgICB9XG5cbiAgICAgICAgLy8gbWFwcGluZyBjb21wb3NpdGUgZGF0YSB0byBkYXRhRmllbGQgd2l0aG91dCBjaGVja2luZyBlcnJvciBjb25kaXRpb25cbiAgICAgICAgdGhpcy5fbWFwcGluZ0ZpZWxkcygpO1xuXG4gICAgICAgIC8vIFNvbWV0aW1lcyBubyBkYXRhIGlzIHN0b3JlZCBkdWUgdG8gaW5hY3RpdmUgY29kZSwgdGhpcyBpcyBub3QgYW4gZXJyb3JcbiAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQ2hlY2sgaWYgZXhpc3RzIHNvbWUgZmllbGRzIGxvYWRlZCBpbnRvIHNlcnZpY2VcbiAgICAgKi9cbiAgICBnZXQgaXNFeGlzdHNGaWVsZHNTdXBwb3J0ZWQoKTogYm9vbGVhbiB7XG4gICAgICAgIHJldHVybiBPYmplY3Qua2V5cyh0aGlzLl9zY3JlZW5GaWVsZHNTdXBwb3J0ZWQpLmxlbmd0aCA+IDA7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQ2hlY2sgaWYgZXhpc3RzIHNvbWUgZmllbGRzIG1hcHBlZCBpbnRvIHNlcnZpY2UsXG4gICAgICogcmVhZHkgdG8gZGlzcGF0Y2hcbiAgICAgKi9cbiAgICBnZXQgaXNFeGlzdHNGaWVsZHNNYXBwZWQoKTogYm9vbGVhbiB7XG4gICAgICAgIHJldHVybiB0aGlzLl9zY3JlZW5GaWVsZHNNYXBwZWQubGVuZ3RoID4gMDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKlxuICAgICAqIEByZXR1cm5zIHRydWUgd2hlbiBzb21lIGNvbXBvc2l0ZSBkYXRhIGhhdmUgYmVlbiBzdG9yZWQuXG4gICAgICovXG4gICAgZ2V0IGlzRXhpc3RzRGF0YUNvbXBvc2l0ZSgpOiBib29sZWFuIHtcbiAgICAgICAgcmV0dXJuIE9iamVjdC5rZXlzKHRoaXMuX2RpY3Rpb25hcnlEYXRhQ29tcG9zaXRlcykubGVuZ3RoID4gMDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKlxuICAgICAqIEBwYXJhbSBmaWVsZCBjaGVjayBjdXJyZW50IGZpZWxkIGlzIGF2YWlsYWJsZVxuICAgICAqIEByZXR1cm5zIHRydWUgaWYgbm90IGF2YWlsYWJsZVxuICAgICAqL1xuICAgIC8qKiBAaW50ZXJuYWwgKi9cbiAgICBwcml2YXRlIF9pc0ZpZWxkTm90QXZhaWxhYmxlKGZpZWxkOiBCYXJjb2RlTWFuYWdlclN1cHBvcnRlZEZpZWxkcyB8IG51bGwpOiBib29sZWFuIHtcbiAgICAgICAgcmV0dXJuIChmaWVsZD8uaXNIaWRkZW4gfHwgZmllbGQ/LmlzRGlzYWJsZWQgfHwgZmllbGQ/LmlzUmVhZE9ubHkpID8/IHRydWU7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQHJldHVybnMgY2xvbmVkIGRpY3Rpb25hcnkgZGF0YSBjb21wb3NpdGUgKG11c3QgYmUgZW1wdHkpXG4gICAgICovXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX2Nsb25lRGljdGlvbmFyeURhdGFDb21wb3NpdGUoKTogRGljdGlvbmFyeURhdGFDb21wb3NpdGUge1xuICAgICAgICBjb25zdCBkaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZSA9IHt9IGFzIERpY3Rpb25hcnlEYXRhQ29tcG9zaXRlO1xuICAgICAgICBmb3IgKGNvbnN0IFtrZXksIHZhbHVlXSBvZiBPYmplY3QuZW50cmllcyh0aGlzLl9kaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZXMpKSB7XG4gICAgICAgICAgICBkaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZVtrZXkgYXMgRGF0YVRpdGxlXSA9IHZhbHVlO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBkaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBQcm9jZXNzIGNsaWVudCBjYWxsYmFjayB3aGVuIGV4aXN0cyB0byBjaGVjayBkYXRhXG4gICAgICogQHJldHVybnMgQ2hlY2tzIGlmIHRoZSBjb21wb3NpdGUgZGF0YXNldCBjYW4gYmUgcHJvY2Vzc2VkXG4gICAgICovXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgYXN5bmMgX2lzRGF0YUNvbXBvc2l0ZUFsbG93ZWQoKTogUHJvbWlzZTxib29sZWFuPiB7XG4gICAgICAgIC8vIElmIGFueSBlcnJvciBvY2N1cnMsIHRoZSBjb21wb3NpdGUgZGF0YSBibG9jayB3aWxsIGJlIHByb2Nlc3NlZFxuICAgICAgICB0cnkge1xuICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgIHRoaXMuX2NoZWNrQ29tcG9zaXRlRGF0YUFsbG93ZWQgJiZcbiAgICAgICAgICAgICAgICB0aGlzLmlzRXhpc3RzRGF0YUNvbXBvc2l0ZSAmJlxuICAgICAgICAgICAgICAgICEoYXdhaXQgdGhpcy5fY2hlY2tDb21wb3NpdGVEYXRhQWxsb3dlZCh0aGlzLl9jbG9uZURpY3Rpb25hcnlEYXRhQ29tcG9zaXRlKCkpKVxuICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICAgICAgfVxuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgRXJyb3Igd2hlbiBldmFsdWF0aW5nIGRhdGEgY29tcG9zaXRlIGNvbmRpdGlvbiBpcyBhbGxvd2VkIDpcXG4ke2Vycm9yfWApO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB0cnVlO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFVwZGF0ZSBzY3JlZW4gZmllbGRzIHN1cHBvcnRlZC5cbiAgICAgKiBmaWVsZCBtYXBwaW5nIHdhcyBkb25lIGFmdGVyXG4gICAgICogQHBhcmFtIHBhZ2VJbnN0YW5jZSBjdXJyZW50IHBhZ2VcbiAgICAgKiBAcGFyYW0gZGljdGlvbmFyeUZpZWxkU3VwcG9ydGVkIGRpY3Rpb25hcnkgb2YgcGFnZSBmaWVsZHMgc3VibWl0dGVkXG4gICAgICogQHJldHVybnMgdHJ1ZSB3aGVuIGRvbmUsIGZhbHNlIHdoZW4gbm8gYW55IGZpZWxkIHRvIHByb2Nlc3Mgd2l0aCBkYXRhXG4gICAgICovXG4gICAgcHVibGljIGFzeW5jIHNldFNjcmVlbkZpZWxkU3VwcG9ydGVkKFxuICAgICAgICBwYWdlSW5zdGFuY2U6IHVpLlBhZ2U8R3JhcGhBcGk+LFxuICAgICAgICBkaWN0aW9uYXJ5RmllbGRTdXBwb3J0ZWQ6IERpY3Rpb25hcnlGaWVsZFN1cHBvcnRlZCxcbiAgICApOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgICAgICAgLy8gR2V0IG9ubHkgZmllbGRzIG1hdGNoaW5nIHdpdGggYWN0aXZlIHBhcmFtZXRlcnNcbiAgICAgICAgbGV0IGluZGV4OiBpbnRlZ2VyID0gMDtcbiAgICAgICAgY29uc3QgbGFzdEluaXRpYWxpemF0aW9uSW5Qcm9ncmVzcyA9IHRoaXMuaXNJbml0aWFsaXphdGlvbkluUHJvZ3Jlc3M7XG4gICAgICAgIHRyeSB7XG4gICAgICAgICAgICB0aGlzLl9pbml0aWFsaXphdGlvbkluUHJvZ3Jlc3MgPSB0cnVlO1xuICAgICAgICAgICAgdGhpcy5fc2NyZWVuRmllbGRzU3VwcG9ydGVkID1cbiAgICAgICAgICAgICAgICB0aGlzLl9leGlzdGluZ0ZpZWxkcyhwYWdlSW5zdGFuY2UsIGRpY3Rpb25hcnlGaWVsZFN1cHBvcnRlZCkubWFwKGZpZWxkID0+IHtcbiAgICAgICAgICAgICAgICAgICAgY29uc3Qgc2VnbWVudHNTdXBwb3J0ZWQ6IEZpZWxkU2VnbWVudFtdID0gW107XG5cbiAgICAgICAgICAgICAgICAgICAgLy8gQ3JlYXRlIHNlZ21lbnRzIGFsbG93ZWRcbiAgICAgICAgICAgICAgICAgICAgZmllbGQuc2VnbWVudHMuZm9yRWFjaChzZWdtZW50ID0+IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnN0IGN1cnJlbnRGaWVsZCA9IHNlZ21lbnQuY3VycmVudEZpZWxkO1xuICAgICAgICAgICAgICAgICAgICAgICAgc2VnbWVudHNTdXBwb3J0ZWQucHVzaCh7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY3VycmVudEZpZWxkOiBjdXJyZW50RmllbGQsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgb25DaGFuZ2U6IHNlZ21lbnQub25DaGFuZ2UsXG4gICAgICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICAgICAgfSk7XG5cbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIERhdGFUaXRsZTogZmllbGQuRGF0YVRpdGxlLFxuICAgICAgICAgICAgICAgICAgICAgICAgc2VxdWVuY2U6ICsraW5kZXgsXG4gICAgICAgICAgICAgICAgICAgICAgICBzZWdtZW50czogc2VnbWVudHNTdXBwb3J0ZWQsXG4gICAgICAgICAgICAgICAgICAgIH0gYXMgU2NyZWVuRmllbGRTdXBwb3J0ZWQ7XG4gICAgICAgICAgICAgICAgfSkgPz8gW107XG5cbiAgICAgICAgICAgIC8vIHVpLmNvbnNvbGUuZGVidWcoYEZpZWxkcyBzdXBwb3J0ZWQgaW50byBwYWdlIDogJHtKU09OLnN0cmluZ2lmeSh0aGlzLl9zY3JlZW5GaWVsZHNTdXBwb3J0ZWQpfWApO1xuXG4gICAgICAgICAgICAvLyBNYXAgZmllbGRzIHdpdGggZXhpc3RpbmcgY29tcG9zaXRlIGRhdGFcbiAgICAgICAgICAgIHJldHVybiB0aGlzLl9tYXBwaW5nRmllbGRzKCk7XG4gICAgICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICAgICAgICB1aS5jb25zb2xlLmVycm9yKGBFcnJvciBpbiBzZXRTY3JlZW5GaWVsZFN1cHBvcnRlZCA6XFxuJHtlcnJvcn1gKTtcbiAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgfSBmaW5hbGx5IHtcbiAgICAgICAgICAgIHRoaXMuX2luaXRpYWxpemF0aW9uSW5Qcm9ncmVzcyA9IGxhc3RJbml0aWFsaXphdGlvbkluUHJvZ3Jlc3M7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGlzIGZ1bmN0aW9uIG1hcCBjdXJyZW50IGZpZWxkcyB3aXRoIHNldCBvZiBkYXRhXG4gICAgICogQHJldHVybnMgdHJ1ZSB3aGVuIGV4aXN0cyBzb21lIGZpZWxkcyB3aXRoIGRhdGEgbWFwcGVkXG4gICAgICovXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX21hcHBpbmdGaWVsZHMoKTogYm9vbGVhbiB7XG4gICAgICAgIC8vIHVpLmNvbnNvbGUuZGVidWcoYFN0YXJ0aW5nIG1hcHBpbmcsIGNvbXBvc2l0ZSBkYXRhIDogJHtKU09OLnN0cmluZ2lmeSh0aGlzLl9kaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZXMpfWApO1xuICAgICAgICAvLyB1aS5jb25zb2xlLmRlYnVnKGBTY3JlZW4gZmllbGQocykgc3VwcG9ydGVkIDogJHtKU09OLnN0cmluZ2lmeSh0aGlzLl9zY3JlZW5GaWVsZHNTdXBwb3J0ZWQpfWApO1xuXG4gICAgICAgIC8vIEV4dHJhY3QgYWN0aXZlIGZpZWxkXG5cbiAgICAgICAgdGhpcy5fc2NyZWVuRmllbGRzTWFwcGVkID0gW107XG4gICAgICAgIGxldCBpbmRleDogbnVtYmVyID0gMDtcbiAgICAgICAgY29uc3QgbWFwcGluZ0ZpZWxkczogRGF0YUZpZWxkTWFwcGVkW10gPSBbXTtcblxuICAgICAgICAvLyBObyBwcm9jZXNzIG9ubHkgaGlkZGVuIGZpZWxkc1xuICAgICAgICB0aGlzLl9zY3JlZW5GaWVsZHNTdXBwb3J0ZWRcbiAgICAgICAgICAgIC5maWx0ZXIoXG4gICAgICAgICAgICAgICAgZmllbGQgPT5cbiAgICAgICAgICAgICAgICAgICAgdGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzW2ZpZWxkLkRhdGFUaXRsZV0gJiZcbiAgICAgICAgICAgICAgICAgICAgIWZpZWxkLnNlZ21lbnRzLnNvbWUoc2VnbWVudCA9PiBzZWdtZW50LmN1cnJlbnRGaWVsZC5pc0hpZGRlbiksXG4gICAgICAgICAgICApXG4gICAgICAgICAgICAuc29ydCgoZmllbGQxLCBmaWVsZDIpID0+IGZpZWxkMS5zZXF1ZW5jZSAtIGZpZWxkMi5zZXF1ZW5jZSlcbiAgICAgICAgICAgIC5mb3JFYWNoKGl0ZW0gPT4ge1xuICAgICAgICAgICAgICAgIGNvbnN0IGRhdGFGaWVsZE1hcHBlZCA9IHtcbiAgICAgICAgICAgICAgICAgICAgRGF0YVRpdGxlOiBpdGVtLkRhdGFUaXRsZSxcbiAgICAgICAgICAgICAgICAgICAgc2VxdWVuY2U6ICsraW5kZXgsXG4gICAgICAgICAgICAgICAgICAgIG1haW5GaWVsZDogaXRlbS5zZWdtZW50c1swXS5jdXJyZW50RmllbGQsXG4gICAgICAgICAgICAgICAgICAgIG9uQ2hhbmdlTWFpbkZpZWxkOiBpdGVtLnNlZ21lbnRzWzBdLm9uQ2hhbmdlLFxuICAgICAgICAgICAgICAgICAgICBkYXRhOiB0aGlzLl9kaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZXNbaXRlbS5EYXRhVGl0bGVdPy5kYXRhLFxuICAgICAgICAgICAgICAgIH0gYXMgRGF0YUZpZWxkTWFwcGVkO1xuXG4gICAgICAgICAgICAgICAgLy8gQWRkIG9wdGlvbmFsIHBhcnRcbiAgICAgICAgICAgICAgICBpZiAoaXRlbS5zZWdtZW50cy5sZW5ndGggPiAxICYmIGl0ZW0uc2VnbWVudHNbMV0/LmN1cnJlbnRGaWVsZCkge1xuICAgICAgICAgICAgICAgICAgICBkYXRhRmllbGRNYXBwZWQudW5pdEZpZWxkID0gaXRlbS5zZWdtZW50c1sxXS5jdXJyZW50RmllbGQ7XG4gICAgICAgICAgICAgICAgICAgIGRhdGFGaWVsZE1hcHBlZC5vbkNoYW5nZVVuaXRGaWVsZCA9IGl0ZW0uc2VnbWVudHNbMV0ub25DaGFuZ2U7XG4gICAgICAgICAgICAgICAgICAgIGRhdGFGaWVsZE1hcHBlZC51bml0ID0gdGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzW2l0ZW0uRGF0YVRpdGxlXT8udW5pdDtcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICBtYXBwaW5nRmllbGRzLnB1c2goZGF0YUZpZWxkTWFwcGVkKTtcbiAgICAgICAgICAgIH0pO1xuXG4gICAgICAgIHRoaXMuX3NjcmVlbkZpZWxkc01hcHBlZCA9IG1hcHBpbmdGaWVsZHM7XG5cbiAgICAgICAgLy8gdWkuY29uc29sZS5kZWJ1ZyhgRmllbGQocykgTWFwcGVkIDogJHtKU09OLnN0cmluZ2lmeSh0aGlzLl9zY3JlZW5GaWVsZHNNYXBwZWQpfWApO1xuICAgICAgICByZXR1cm4gdGhpcy5fc2NyZWVuRmllbGRzTWFwcGVkLmxlbmd0aCA+IDA7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogUmVtb3ZlIGZpZWxkcyBkZWZpbml0aW9uXG4gICAgICogQHBhcmFtIHJlbW92ZUNvbXBvc2l0ZURhdGEgIDogb3B0aW9uYWxseSByZW1vdmUgY29tcG9zaXRlIGRhdGEgdG9vXG4gICAgICovXG4gICAgcHVibGljIGNsZWFyU2NyZWVuRmllbGRzKHJlbW92ZUNvbXBvc2l0ZURhdGE6IGJvb2xlYW4gPSBmYWxzZSk6IHZvaWQge1xuICAgICAgICB0aGlzLl9zY3JlZW5GaWVsZHNTdXBwb3J0ZWQgPSBbXTtcbiAgICAgICAgdGhpcy5fc2NyZWVuRmllbGRzTWFwcGVkID0gW107XG4gICAgICAgIGlmIChyZW1vdmVDb21wb3NpdGVEYXRhKSB7XG4gICAgICAgICAgICB0aGlzLmNsZWFyQ29tcG9zaXRlRGF0YSgpO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogUmVtb3ZlIGNvbXBvc2l0ZSBkYXRhXG4gICAgICovXG4gICAgcHVibGljIGNsZWFyQ29tcG9zaXRlRGF0YSgpOiB2b2lkIHtcbiAgICAgICAgdGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzID0ge30gYXMgRGljdGlvbmFyeURhdGFDb21wb3NpdGU7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogUmVtb3ZlIGNvbXBvc2l0ZSBkYXRhIGZyb20gc3RvcmFnZVxuICAgICAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlXG4gICAgICogQHBhcmFtIHN0b3JhZ2VLZXkgb3B0aW9uYWwsIGZvciBvdmVycmlkaW5nIGN1cnJlbnQgc2VydmljZSBrZXkgKHVzZSB3aXRoIGNhdXRpb24pXG4gICAgICovXG4gICAgcHVibGljIGNsZWFyQ29tcG9zaXRlRGF0YVN0b3JhZ2UocGFnZUluc3RhbmNlOiB1aS5QYWdlPEdyYXBoQXBpPiwgc3RvcmFnZUtleT86IHN0cmluZyk6IHZvaWQge1xuICAgICAgICB0aGlzLl9yZW1vdmVDb21wb3NpdGVEYXRhU3RvcmFnZShwYWdlSW5zdGFuY2UsIHN0b3JhZ2VLZXkpO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFJlbW92ZSBhbGwgY29tcG9zaXRlIGFuZCBzdG9yYWdlIGRhdGFcbiAgICAgKiBAcGFyYW0gcGFnZUluc3RhbmNlIGN1cnJlbnQgcGFnZVxuICAgICAqIEBwYXJhbSBzdG9yYWdlS2V5IG9wdGlvbmFsLCBmb3Igb3ZlcnJpZGluZyBjdXJyZW50IHNlcnZpY2Uga2V5ICh1c2Ugd2l0aCBjYXV0aW9uKVxuICAgICAqL1xuICAgIHB1YmxpYyBjbGVhckFsbENvbXBvc2l0ZURhdGFBbmRTdG9yYWdlKHBhZ2VJbnN0YW5jZTogdWkuUGFnZTxHcmFwaEFwaT4sIHN0b3JhZ2VLZXk/OiBzdHJpbmcpOiB2b2lkIHtcbiAgICAgICAgdGhpcy5jbGVhckNvbXBvc2l0ZURhdGEoKTtcbiAgICAgICAgdGhpcy5jbGVhckNvbXBvc2l0ZURhdGFTdG9yYWdlKHBhZ2VJbnN0YW5jZSwgc3RvcmFnZUtleSk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogTG9hZCBjb21wb3NpdGUgZGF0YSBmcm9tIHN0b3JhZ2UgYW5kIHRoZW4gZGVsZXRlIGl0IHRoZXJlLlxuICAgICAqIEByZXR1cm5zIHRydWUgd2hlbiBzb21lIGRhdGEgaGFzIGJlZW4gbG9hZGVkXG4gICAgICovXG4gICAgcHVibGljIGxvYWRDb21wb3NpdGVEYXRhKHBhZ2VJbnN0YW5jZTogdWkuUGFnZTxHcmFwaEFwaT4pOiBib29sZWFuIHtcbiAgICAgICAgdGhpcy5jbGVhckNvbXBvc2l0ZURhdGEoKTtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIGNvbnN0IGRpY3Rpb25hcnlEYXRhQ29tcG9zaXRlczogRGljdGlvbmFyeURhdGFDb21wb3NpdGUgPSBKU09OLnBhcnNlKFxuICAgICAgICAgICAgICAgIChwYWdlSW5zdGFuY2UuJC5zdG9yYWdlLmdldCh0aGlzLl9zdG9yYWdlS2V5KSA/PyAne30nKSBhcyBzdHJpbmcsXG4gICAgICAgICAgICApIGFzIERpY3Rpb25hcnlEYXRhQ29tcG9zaXRlO1xuICAgICAgICAgICAgLy8gdWkuY29uc29sZS53YXJuKGBDb21wb3NpdGUgZGF0YSBsb2FkZWQgOlxcbiR7SlNPTi5zdHJpbmdpZnkoZGljdGlvbmFyeURhdGFDb21wb3NpdGVzKX1gKTtcbiAgICAgICAgICAgIC8vIEVyYXNlIHN0b3JhZ2VcbiAgICAgICAgICAgIHRoaXMuX3JlbW92ZUNvbXBvc2l0ZURhdGFTdG9yYWdlKHBhZ2VJbnN0YW5jZSk7XG4gICAgICAgICAgICBpZiAoT2JqZWN0LmtleXMoZGljdGlvbmFyeURhdGFDb21wb3NpdGVzKS5sZW5ndGggPiAwKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzID0gZGljdGlvbmFyeURhdGFDb21wb3NpdGVzO1xuICAgICAgICAgICAgICAgIC8vIHVpLmNvbnNvbGUud2FybihgQXNzaWduZWQgOlxcbiR7SlNPTi5zdHJpbmdpZnkodGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzKX1gKTtcbiAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgICAgIHRoaXMuY2xlYXJDb21wb3NpdGVEYXRhKCk7XG4gICAgICAgICAgICB0aGlzLl9yZW1vdmVDb21wb3NpdGVEYXRhU3RvcmFnZShwYWdlSW5zdGFuY2UpO1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgRXJyb3IgbG9hZGluZyBjb21wb3NpdGUgZGF0YSBmcm9tIHN0b3JhZ2UgOlxcbiR7ZXJyb3J9YCk7XG4gICAgICAgIH1cbiAgICAgICAgLy8gdWkuY29uc29sZS5lcnJvcihgTm8gY29tcG9zaXRlIGRhdGFgKTtcbiAgICAgICAgcmV0dXJuIHRoaXMuaXNFeGlzdHNEYXRhQ29tcG9zaXRlO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFNhdmUgY29tcG9zaXRlIGRhdGEsIHplcm8gZWxlbWVudHMgYWxsb3dlZFxuICAgICAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlXG4gICAgICogQHJldHVybnMgdHJ1ZSB3aGVuIG9wZXJhdGlvbiBoYXMgcGVyZm9ybWVkXG4gICAgICovXG4gICAgcHVibGljIHNhdmVDb21wb3NpdGVEYXRhKHBhZ2VJbnN0YW5jZTogdWkuUGFnZTxHcmFwaEFwaT4pOiBib29sZWFuIHtcbiAgICAgICAgaWYgKHBhZ2VJbnN0YW5jZSAmJiB0aGlzLl9zdG9yYWdlS2V5ICYmIHRoaXMuaXNFeGlzdHNEYXRhQ29tcG9zaXRlKSB7XG4gICAgICAgICAgICBjb25zdCBkaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZXM6IERpY3Rpb25hcnlEYXRhQ29tcG9zaXRlID0gdGhpcy5fZGljdGlvbmFyeURhdGFDb21wb3NpdGVzO1xuICAgICAgICAgICAgcGFnZUluc3RhbmNlLiQuc3RvcmFnZS5zZXQodGhpcy5fc3RvcmFnZUtleSwgSlNPTi5zdHJpbmdpZnkoZGljdGlvbmFyeURhdGFDb21wb3NpdGVzKSk7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuICAgICAgICBpZiAocGFnZUluc3RhbmNlKSB7XG4gICAgICAgICAgICB0aGlzLl9yZW1vdmVDb21wb3NpdGVEYXRhU3RvcmFnZShwYWdlSW5zdGFuY2UpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBSZW1vdmUgZGF0YSBmcm9tIHRoZSBzdG9yYWdlXG4gICAgICogQHBhcmFtIHBhZ2VJbnN0YW5jZSBjdXJyZW50IHBhZ2VcbiAgICAgKi9cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBfcmVtb3ZlQ29tcG9zaXRlRGF0YVN0b3JhZ2UocGFnZUluc3RhbmNlOiB1aS5QYWdlPEdyYXBoQXBpPiwgc3RvcmFnZUtleT86IHN0cmluZyk6IGJvb2xlYW4ge1xuICAgICAgICBjb25zdCBpc0RhdGFTdG9yYWdlID0gISFwYWdlSW5zdGFuY2UgJiYgKCEhdGhpcy5fc3RvcmFnZUtleSB8fCAhIXN0b3JhZ2VLZXkpO1xuICAgICAgICBpZiAoaXNEYXRhU3RvcmFnZSkge1xuICAgICAgICAgICAgcGFnZUluc3RhbmNlLiQuc3RvcmFnZS5yZW1vdmUoc3RvcmFnZUtleSA/PyB0aGlzLl9zdG9yYWdlS2V5KTtcbiAgICAgICAgfVxuXG4gICAgICAgIHJldHVybiBpc0RhdGFTdG9yYWdlO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIGFzc2lnbiBkYXRlIHRvIHBhZ2UgZmllbGRzIHdoZW4gZXhpc3RpbmcgYW5kIGF2YWlsYWJsZVxuICAgICAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlXG4gICAgICogQHBhcmFtIG9yaWdpbmFsRmllbGQgb3JpZ2luYWwgZmllbGQgKHJlc2VydmVkKVxuICAgICAqIEBwYXJhbSBzZXRGb2N1cyBvcHRpb25hbCB2YWx1ZSBtdXN0IGJlIHRydWUgd2hlbiBmb2N1cyBtdXN0IGJlIHBlcmZvcm1lZCBpbiByZUluaXRpYWxpemluZ1xuICAgICAqIEByZXR1cm5zIGZhbHNlIHdoZW4gZGlzcGF0Y2hpbmcgZmFpbHVyZSBvY2N1cnNcbiAgICAgKi9cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBhc3luYyBfZGlzcGF0Y2hEYXRhVG9GaWVsZHMoXG4gICAgICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZTxHcmFwaEFwaT4sXG4gICAgICAgIG9yaWdpbmFsRmllbGQ6IEJhcmNvZGVNYW5hZ2VyU3VwcG9ydGVkRmllbGRzLFxuICAgICAgICBzZXRGb2N1czogYm9vbGVhbiA9IGZhbHNlLFxuICAgICk6IFByb21pc2U8Ym9vbGVhbj4ge1xuICAgICAgICBjb25zdCAkaXRlbXMgPSBwYWdlSW5zdGFuY2U/Ll9wYWdlTWV0YWRhdGEubGF5b3V0LiRpdGVtcyA/PyBbXTtcbiAgICAgICAgbGV0IGlzRmFpbHVyZTogYm9vbGVhbiA9IGZhbHNlO1xuICAgICAgICBsZXQgaXNPbmVGaWVsZFByb2Nlc3NlZDogYm9vbGVhbiA9IGZhbHNlO1xuXG4gICAgICAgIC8vIHVpLmNvbnNvbGUuZGVidWcoJ1N0YXJ0aW5nIGRpc3BhdGNoaW5nIGFsbCBmaWVsZHMnKTtcbiAgICAgICAgaWYgKCRpdGVtcz8ubGVuZ3RoID4gMCAmJiB0aGlzLmlzRXhpc3RzRGF0YUNvbXBvc2l0ZSkge1xuICAgICAgICAgICAgZm9yIChjb25zdCBmaWVsZCBvZiB0aGlzLl9zY3JlZW5GaWVsZHNNYXBwZWQpIHtcbiAgICAgICAgICAgICAgICBpZiAoZmllbGQ/LmRhdGEpIHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgICAgICAgICAgKGlzRmFpbHVyZSA9ICEoYXdhaXQgdGhpcy5fcHJvY2Vzc0ZpZWxkKHBhZ2VJbnN0YW5jZSwgZmllbGQsIHNldEZvY3VzKS5jYXRjaChcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAoKSA9PiBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICkpIGFzIGJvb2xlYW4pXG4gICAgICAgICAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICAgICAgICAgICAgLy8gdWkuY29uc29sZS5lcnJvcihgRGlzcGF0Y2hpbmcgZXJyb3IsIGNvbXBvc2l0ZSBkYXRhIGhhcyBjbGVhcmVkYCk7XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLmNsZWFyQ29tcG9zaXRlRGF0YSgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBpc09uZUZpZWxkUHJvY2Vzc2VkID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIC8vIElmIG5vIGNvbXBvc2l0ZSBkYXRhIGNvdWxkIGJlIGFzc2lnbmVkLCBpdCBpcyBhbiBlcnJvclxuICAgICAgICBpZiAoIWlzRmFpbHVyZSAmJiAhaXNPbmVGaWVsZFByb2Nlc3NlZCkge1xuICAgICAgICAgICAgaXNGYWlsdXJlID0gdHJ1ZTtcbiAgICAgICAgICAgIHRoaXMuY2xlYXJDb21wb3NpdGVEYXRhKCk7XG4gICAgICAgICAgICB0aGlzLl9jbGVhckZpZWxkKHBhZ2VJbnN0YW5jZSwgb3JpZ2luYWxGaWVsZCwgc2V0Rm9jdXMpO1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihcbiAgICAgICAgICAgICAgICBgQ29tcG9zaXRlIGRhdGEgd2FzIHJlbW92ZWQgYmVjYXVzZSBub25lIGNvdWxkIGJlIGFzc2lnbmVkLCBhbmQgZmllbGQgJHtvcmlnaW5hbEZpZWxkPy5pZH0gd2FzIHJlc2V0YCxcbiAgICAgICAgICAgICk7XG4gICAgICAgIH1cblxuICAgICAgICAvLyB1aS5jb25zb2xlLmRlYnVnKGBFbmRpbmcgZGlzcGF0Y2hpbmcgYWxsIGZpZWxkcyA6ICR7IWlzRmFpbHVyZX1gKTtcbiAgICAgICAgcmV0dXJuICFpc0ZhaWx1cmU7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICpcbiAgICAgKiBAcGFyYW0gcGFnZUluc3RhbmNlIGN1cnJlbnQgcGFnZVxuICAgICAqIEBwYXJhbSBmaWVsZCBjdXJyZW50IGZpZWxkIGFscmVhZHkgZXZhbHVhdGVkXG4gICAgICogQHBhcmFtIHNldEZvY3VzIG9wdGlvbmFsIHZhbHVlIG11c3QgYmUgdHJ1ZSB3aGVuIGZvY3VzIG11c3QgYmUgcGVyZm9ybWVkIGluIHJlSW5pdGlhbGl6aW5nXG4gICAgICogQHJldHVybnMgdHJ1ZSB3aGVuIGl0ZW0gaGFzIGZvdW5kLCBidXQgdXBkYXRlZCBvbmx5IHdoZW4gYXZhaWxhYmxlXG4gICAgICovXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgYXN5bmMgX3Byb2Nlc3NGaWVsZChcbiAgICAgICAgcGFnZUluc3RhbmNlOiBhbnksXG4gICAgICAgIGZpZWxkOiBEYXRhRmllbGRNYXBwZWQsXG4gICAgICAgIHNldEZvY3VzOiBib29sZWFuID0gZmFsc2UsXG4gICAgKTogUHJvbWlzZTxib29sZWFuPiB7XG4gICAgICAgIGNvbnN0IGZpZWxkc1RvUmV2YWxpZGF0ZTogQmFyY29kZU1hbmFnZXJTdXBwb3J0ZWRGaWVsZHNbXSA9IFtdO1xuICAgICAgICBjb25zdCBvbkNoYW5nZUNhbGxiYWNrczogQXJyYXk8W3N0cmluZywgQXN5bmNWb2lkRnVuY3Rpb25dPiA9IFtdO1xuICAgICAgICBjb25zdCBtYWluRmllbGQgPSBmaWVsZD8ubWFpbkZpZWxkO1xuICAgICAgICBjb25zdCBtYWluRmllbGRJZCA9IG1haW5GaWVsZD8uaWQgPz8gJyc7XG4gICAgICAgIGNvbnN0IHVuaXRGaWVsZCA9IGZpZWxkPy51bml0RmllbGQ7XG4gICAgICAgIGNvbnN0IHVuaXRGaWVsZElkID0gdW5pdEZpZWxkPy5pZCA/PyAnJztcbiAgICAgICAgbGV0IHZhbGlkYXRpb24gPSB0cnVlO1xuICAgICAgICBsZXQgbWFpblNvdW5kT3JpZ2luYWxWYWx1ZSA9IGZhbHNlO1xuICAgICAgICBsZXQgdW5pdFNvdW5kT3JpZ2luYWxWYWx1ZTogYm9vbGVhbiB8IHVuZGVmaW5lZCA9IHVuZGVmaW5lZDtcblxuICAgICAgICB0cnkge1xuICAgICAgICAgICAgLy8gcHJvY2VzcyBhbGwgc3ViRmllbGRzIChzZWdtZW50cykgcmVxdWVzdGVkIChtYWluIGFuZCBvcHRpb25hbCB1bml0KVxuICAgICAgICAgICAgLy8gdWkuY29uc29sZS5kZWJ1ZyhgX1Byb2Nlc3NGaWVsZCAobWFwcGVkIGZpZWxkcykgOlxcbiR7SlNPTi5zdHJpbmdpZnkoZmllbGQpfWApO1xuXG4gICAgICAgICAgICAvLyBjdXJyZW50IGZpZWxkIG5vdCBjdXJyZW50bHkgYXZhaWxhYmxlIDogZG9uJ3QgcHJvY2VzcyB0aGlzIGZpZWxkXG4gICAgICAgICAgICBpZiAoIW1haW5GaWVsZCB8fCB0aGlzLl9pc0ZpZWxkTm90QXZhaWxhYmxlKG1haW5GaWVsZCkpIHtcbiAgICAgICAgICAgICAgICAvLyB1aS5jb25zb2xlLmVycm9yKGBGaWVsZCAke21haW5GaWVsZElkfSBoYXMgdW5hdmFpbGFibGVgKTtcbiAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKGZpZWxkPy5kYXRhKSB7XG4gICAgICAgICAgICAgICAgaWYgKHVuaXRGaWVsZCAmJiBmaWVsZD8udW5pdCAmJiB0aGlzLl9pc0ZpZWxkTm90QXZhaWxhYmxlKHVuaXRGaWVsZCkpIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gdWkuY29uc29sZS5lcnJvcihgVW5pdCBmaWVsZCAke3VuaXRGaWVsZElkfSBoYXMgdW5hdmFpbGFibGVgKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgbWFpblNvdW5kT3JpZ2luYWxWYWx1ZSA9IGF3YWl0IHRoaXMuX3NldFNvdW5kRmllbGQocGFnZUluc3RhbmNlLCBtYWluRmllbGQsIHRydWUpO1xuXG4gICAgICAgICAgICAgICAgLy8gSWYgbm90IHBvc3NpYmxlIHRvIGNoYW5nZSBhIHZhbHVlLCBjb21wb3NpdGUgYmxvY2sgaXMgaW52YWxpZFxuICAgICAgICAgICAgICAgIHN3aXRjaCAoYXdhaXQgdGhpcy5fc2V0RmllbGRWYWx1ZShwYWdlSW5zdGFuY2UsIG1haW5GaWVsZCwgZmllbGQ/LmRhdGEsIHNldEZvY3VzKSkge1xuICAgICAgICAgICAgICAgICAgICBjYXNlIG51bGw6XG4gICAgICAgICAgICAgICAgICAgICAgICAvLyB1aS5jb25zb2xlLndhcm4oYEZpZWxkICR7bWFpbkZpZWxkSWR9IGhhcyBubyBkYXRhIGF2YWlsYWJsZWApO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuXG4gICAgICAgICAgICAgICAgICAgIGNhc2UgdHJ1ZTpcbiAgICAgICAgICAgICAgICAgICAgICAgIGZpZWxkc1RvUmV2YWxpZGF0ZS5wdXNoKG1haW5GaWVsZCk7XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoZmllbGQ/Lm9uQ2hhbmdlTWFpbkZpZWxkKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgb25DaGFuZ2VDYWxsYmFja3MucHVzaChbbWFpbkZpZWxkSWQsIGZpZWxkLm9uQ2hhbmdlTWFpbkZpZWxkXSk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAvLyBQcm9jZXNzIG9wdGlvbmFsIHVuaXQgYXZhaWxhYmxlIHdpdGggZGF0YVxuICAgICAgICAgICAgICAgIGlmICh1bml0RmllbGQgJiYgZmllbGQ/LnVuaXQgJiYgIXRoaXMuX2lzRmllbGROb3RBdmFpbGFibGUodW5pdEZpZWxkKSkge1xuICAgICAgICAgICAgICAgICAgICB1bml0U291bmRPcmlnaW5hbFZhbHVlID0gYXdhaXQgdGhpcy5fc2V0U291bmRGaWVsZChwYWdlSW5zdGFuY2UsIHVuaXRGaWVsZCwgdHJ1ZSk7XG4gICAgICAgICAgICAgICAgICAgIHN3aXRjaCAoYXdhaXQgdGhpcy5fc2V0RmllbGRWYWx1ZShwYWdlSW5zdGFuY2UsIHVuaXRGaWVsZCwgZmllbGQudW5pdCkpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgbnVsbDpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAvLyB1aS5jb25zb2xlLndhcm4oYFVuaXQgZmllbGQgJHt1bml0RmllbGRJZH0gaGFzIG5vIGRhdGEgYXZhaWxhYmxlYCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICBjYXNlIHRydWU6XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZmllbGRzVG9SZXZhbGlkYXRlLnB1c2godW5pdEZpZWxkKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAoZmllbGQ/Lm9uQ2hhbmdlVW5pdEZpZWxkKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG9uQ2hhbmdlQ2FsbGJhY2tzLnB1c2goW3VuaXRGaWVsZElkLCBmaWVsZC5vbkNoYW5nZVVuaXRGaWVsZF0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIC8vIFJlcXVlc3QgYWxsIGNoYW5nZXMgdG8gcGFnZSAob3B0aW9uYWwgZmllbGQgYW5kIHVuaXQpIGJlZm9yZSBhbnkgYWN0aW9uXG4gICAgICAgICAgICAgICAgYXdhaXQgcGFnZUluc3RhbmNlLiQuY29tbWl0VmFsdWVBbmRQcm9wZXJ0eUNoYW5nZXMoKTtcblxuICAgICAgICAgICAgICAgIC8vIFdlIG9ubHkgcHJvY2VzcyB3aXRoIHRoZSBjYXNlIG9mIG1vZGlmaWVkIGZpZWxkc1xuICAgICAgICAgICAgICAgIGlmIChmaWVsZHNUb1JldmFsaWRhdGUubGVuZ3RoKSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIE5vdyBwcm9jZXNzIGNoYW5nZSAvIHZhbGlkYXRpb24gZmllbGQgc2VnbWVudHNcblxuICAgICAgICAgICAgICAgICAgICBmb3IgKGNvbnN0IG9uQ2hhbmdlQ2FsbGJhY2sgb2Ygb25DaGFuZ2VDYWxsYmFja3MpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnN0IGZpZWxkSWQgPSBvbkNoYW5nZUNhbGxiYWNrWzBdO1xuICAgICAgICAgICAgICAgICAgICAgICAgY29uc3Qgb25DaGFuZ2UgPSBvbkNoYW5nZUNhbGxiYWNrWzFdO1xuICAgICAgICAgICAgICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBhd2FpdCBvbkNoYW5nZSgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aHJvdyBuZXcgU3lzdGVtRXJyb3IoXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGBvbkNoYW5nZSBmYWlsdXJlIG9uIGZpZWxkICR7ZmllbGRJZH0gOlxcbiR7SlNPTi5zdHJpbmdpZnkoZXJyb3IpfWAsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVycm9yLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAodGhpcy5pc0Fib3J0RGlzcGF0Y2hJblByb2dyZXNzKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gdWkuY29uc29sZS53YXJuKGBBYm9ydGluZyBkaXNwYXRjaGluZyBpbiBwcm9ncmVzcyBmb3IgZmllbGQgJHtmaWVsZElkfWApO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgLy8gQ0FVVElPTjogd2hlbiBhYm9ydGluZyBpcyBpbiBwcm9ncmVzcywgY29udGV4dCBtYXkgYmUgaW52YWxpZCA6XG4gICAgICAgICAgICAgICAgICAgIC8vIFRoaXMgYmVoYXZpb3IgaXMgdGFrZW4gaW50byBhY2NvdW50IGJ5IHRoZSBwb3NzaWJpbGl0eSBvZiBhYmFuZG9uaW5nIGRpc3BhdGNoaW5nLFxuICAgICAgICAgICAgICAgICAgICAvLyBhbmQgcG9zc2libHkgZXhlY3V0aW5nIGEgcG9zdERvbmUgYWN0aW9uIGF0IHRoZSBlbmQuIElmIHBvc3NpYmxlLCB0aGlzIGFjdGlvbiBzaG91bGRcbiAgICAgICAgICAgICAgICAgICAgLy8gYXZvaWQgYmVpbmcgYXN5bmNocm9ub3VzIGZvciB0aGlzIHJlYXNvbi5cbiAgICAgICAgICAgICAgICAgICAgaWYgKCF0aGlzLmlzQWJvcnREaXNwYXRjaEluUHJvZ3Jlc3MpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIC8vIElmIHdlIGhhdmUgcGVyZm9ybWVkIGF0IGxlYXN0IG9uZSBjaGFuZ2UgYWN0aW9uLCB3ZSByZWRvIGEgY29tbWl0IG9mIHRoZSBwYWdlXG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAob25DaGFuZ2VDYWxsYmFja3MubGVuZ3RoKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYXdhaXQgcGFnZUluc3RhbmNlLiQuY29tbWl0VmFsdWVBbmRQcm9wZXJ0eUNoYW5nZXMoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgLy8gdWkuY29uc29sZS5kZWJ1ZyhgU3RhcnRpbmcgVmFsaWRhdGlvbmApO1xuICAgICAgICAgICAgICAgICAgICAgICAgZm9yIChjb25zdCBmaWVsZFRvVmFsaWRhdGUgb2YgZmllbGRzVG9SZXZhbGlkYXRlKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdmFsaWRhdGlvbiAmJj0gKGF3YWl0IGZpZWxkVG9WYWxpZGF0ZVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAudmFsaWRhdGUoKVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAudGhlbihkYXRhID0+IGRhdGEgPT09IHVuZGVmaW5lZClcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLmNhdGNoKCgpID0+IGZhbHNlKSkgYXMgYm9vbGVhbjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAoIXZhbGlkYXRpb24pIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdWkuY29uc29sZS53YXJuKGBWYWxpZGF0aW9uIGZhaWx1cmUgb24gZmllbGQgOiAke2ZpZWxkVG9WYWxpZGF0ZS5pZH1gKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgRXJyb3IgZGlzcGF0Y2hpbmcgJHttYWluRmllbGRJZH0gOlxcbiR7ZXJyb3I/Lm1lc3NhZ2V9YCk7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH0gZmluYWxseSB7XG4gICAgICAgICAgICBsZXQgaXNDaGFuZ2VkID1cbiAgICAgICAgICAgICAgICAoYXdhaXQgdGhpcy5fc2V0U291bmRGaWVsZChwYWdlSW5zdGFuY2UsIG1haW5GaWVsZCwgbWFpblNvdW5kT3JpZ2luYWxWYWx1ZSwgZmFsc2UpKSAhPT1cbiAgICAgICAgICAgICAgICBtYWluU291bmRPcmlnaW5hbFZhbHVlO1xuICAgICAgICAgICAgaWYgKHVuaXRTb3VuZE9yaWdpbmFsVmFsdWUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgICAgICAgICAgIGlzQ2hhbmdlZCB8fD1cbiAgICAgICAgICAgICAgICAgICAgKGF3YWl0IHRoaXMuX3NldFNvdW5kRmllbGQocGFnZUluc3RhbmNlLCB1bml0RmllbGQsIHVuaXRTb3VuZE9yaWdpbmFsVmFsdWUsIGZhbHNlKSkgIT09XG4gICAgICAgICAgICAgICAgICAgIHVuaXRTb3VuZE9yaWdpbmFsVmFsdWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoaXNDaGFuZ2VkKSB7XG4gICAgICAgICAgICAgICAgYXdhaXQgcGFnZUluc3RhbmNlLiQuY29tbWl0VmFsdWVBbmRQcm9wZXJ0eUNoYW5nZXMoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIHJldHVybiB2YWxpZGF0aW9uO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEFzc2lnbiB2YWx1ZSB0byBmaWVsZFxuICAgICAqIEBwYXJhbSBmaWVsZCBjdXJyZW50IGZpZWxkXG4gICAgICogQHBhcmFtIHZhbHVlIHZhbHVlIHRvIGFzc2lnbiBpbiB0aGUgZmllbGRcbiAgICAgKiBAcGFyYW0gc2V0Rm9jdXMgb3B0aW9uYWwgdmFsdWUgbXVzdCBiZSB0cnVlIHdoZW4gZm9jdXMgbXVzdCBiZSBwZXJmb3JtZWQgaW4gcmVJbml0aWFsaXppbmdcbiAgICAgKiBAcmV0dXJuIGZhbHNlIGlmIGZpZWxkIGhhcyByZWluaXRpYWxpemVkLCBudWxsIHdoZW4gbm8gY2hhbmdlIGhhcyBwZXJmb3JtZWQgKHRvIG1vcmUgcmVzdWx0cylcbiAgICAgKi9cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBhc3luYyBfc2V0RmllbGRWYWx1ZShcbiAgICAgICAgcGFnZUluc3RhbmNlOiBhbnksXG4gICAgICAgIGZpZWxkOiBCYXJjb2RlTWFuYWdlclN1cHBvcnRlZEZpZWxkcyxcbiAgICAgICAgdmFsdWU6IEVsZW1lbnRUeXBlU3VwcG9ydGVkLFxuICAgICAgICBzZXRGb2N1czogYm9vbGVhbiA9IHRydWUsXG4gICAgKTogUHJvbWlzZTxib29sZWFuIHwgbnVsbD4ge1xuICAgICAgICBjb25zdCBvcmlnaW5hbFZhbHVlOiBhbnkgPSBmaWVsZC52YWx1ZTtcbiAgICAgICAgbGV0IG5ld1ZhbHVlOiBhbnk7XG4gICAgICAgIGlmIChmaWVsZCBpbnN0YW5jZW9mIHVpLmZpZWxkcy5SZWZlcmVuY2UpIHtcbiAgICAgICAgICAgIGNvbnN0IHJlc3VsdCA9IGF3YWl0IGZpZWxkLmZldGNoU3VnZ2VzdGlvbnModmFsdWUgYXMgc3RyaW5nKTtcblxuICAgICAgICAgICAgLy8gV2Ugb25seSB1cGRhdGUgaWYgdGhlcmUgaXMgYSByZXN1bHQgb3RoZXJ3aXNlIHRoZSB2YWx1ZSB3aWxsIHJlbWFpbiB1bmNoYW5nZWRcbiAgICAgICAgICAgIGlmICghcmVzdWx0Lmxlbmd0aCkge1xuICAgICAgICAgICAgICAgIGF3YWl0IHBhZ2VJbnN0YW5jZS4kLnNvdW5kLmVycm9yKCk7XG4gICAgICAgICAgICAgICAgYXdhaXQgdGhpcy5fY2xlYXJGaWVsZChwYWdlSW5zdGFuY2UsIGZpZWxkLCBzZXRGb2N1cyk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICBuZXdWYWx1ZSA9IHJlc3VsdFswXTtcbiAgICAgICAgICAgICAgICBhd2FpdCBwYWdlSW5zdGFuY2UuJC5zb3VuZC5zdWNjZXNzKCk7XG4gICAgICAgICAgICAgICAgaWYgKHJlc3VsdC5sZW5ndGggPT09IDEpIHtcbiAgICAgICAgICAgICAgICAgICAgYXdhaXQgcGFnZUluc3RhbmNlLiQuc291bmQuc3VjY2VzcygpO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIC8qIER1cGxpY2F0ZSBub3Qgc3VwcG9ydGVkLCBrZWVwIGZpcnN0IHJlc3VsdCAqL1xuICAgICAgICAgICAgICAgICAgICBhd2FpdCBwYWdlSW5zdGFuY2UuJC5zb3VuZC5zdWNjZXNzKCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9IGVsc2UgaWYgKGZpZWxkIGluc3RhbmNlb2YgdWkuZmllbGRzLkZpbHRlclNlbGVjdCkge1xuICAgICAgICAgICAgbmV3VmFsdWUgPSB2YWx1ZSBhcyBhbnk7XG4gICAgICAgIH0gZWxzZSBpZiAoZmllbGQgaW5zdGFuY2VvZiB1aS5maWVsZHMuVGV4dCkge1xuICAgICAgICAgICAgbmV3VmFsdWUgPSBTdHJpbmcodmFsdWUpO1xuICAgICAgICB9IGVsc2UgaWYgKGZpZWxkIGluc3RhbmNlb2YgdWkuZmllbGRzLk51bWVyaWMpIHtcbiAgICAgICAgICAgIG5ld1ZhbHVlID0gTnVtYmVyKHZhbHVlKTtcbiAgICAgICAgfSBlbHNlIGlmIChmaWVsZCBpbnN0YW5jZW9mIHVpLmZpZWxkcy5EYXRlKSB7XG4gICAgICAgICAgICBuZXdWYWx1ZSA9IHZhbHVlIGluc3RhbmNlb2YgRGF0ZVZhbHVlID8gdmFsdWUudG9TdHJpbmcoKSA6ICh2YWx1ZSBhcyBhbnkpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgbmV3VmFsdWUgPSB2YWx1ZSBhcyBhbnk7XG4gICAgICAgIH1cbiAgICAgICAgZmllbGQudmFsdWUgPSBuZXdWYWx1ZTtcblxuICAgICAgICBjb25zdCBpc0NoYW5nZWQgPSBvcmlnaW5hbFZhbHVlICE9PSBuZXdWYWx1ZTtcblxuICAgICAgICBpZiAoaXNDaGFuZ2VkICYmICFmaWVsZC5pc0RpcnR5KSB7XG4gICAgICAgICAgICBmaWVsZC5pc0RpcnR5ID0gdHJ1ZTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gaXNDaGFuZ2VkO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIENvbnZlcnQgYSB1c2VyIGZpZWxkIHN1Ym1pdHRlZCBieSBmdWxsIHNlZ21lbnQgcmVmZXJlbmNlIGJlZm9yZSBldmFsdWF0aW9uLlxuICAgICAqIEBwYXJhbSBkaWN0aW9uYXJ5RmllbGRzVG9QcmVwYXJlIGZpZWxkcyB0byBjaGVjayB0byBwdXQgaW4gZGljdGlvbmFyeVxuICAgICAqIEByZXR1cm5zIFNjcmVlbiBmaWVsZHMgc3VwcG9ydGVkIGZvciBpbnRlcm5hbCB1c2VcbiAgICAgKi9cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBfcHJlcGFyZVNlZ21lbnQoZGljdGlvbmFyeUZpZWxkc1RvUHJlcGFyZTogRGljdGlvbmFyeUZpZWxkU3VwcG9ydGVkKTogU2NyZWVuRmllbGRTdXBwb3J0ZWRbXSB7XG4gICAgICAgIC8vIFJlc2V0IGludGVybmFsIGRpY3Rpb25hcnlcbiAgICAgICAgdGhpcy5fZGljdGlvbmFyeVNlZ21lbnQgPSB7fSBhcyBEaWN0aW9uYXJ5U2VnbWVudDtcbiAgICAgICAgY29uc3Qgc2NyZWVuRmllbGRzU3VwcG9ydGVkOiBTY3JlZW5GaWVsZFN1cHBvcnRlZFtdID0gW107XG5cbiAgICAgICAgZm9yIChjb25zdCBba2V5LCBmaWVsZF0gb2YgT2JqZWN0LmVudHJpZXMoZGljdGlvbmFyeUZpZWxkc1RvUHJlcGFyZSkpIHtcbiAgICAgICAgICAgIGlmIChmaWVsZCkge1xuICAgICAgICAgICAgICAgIGNvbnN0IHNjcmVlbkZpZWxkU3VwcG9ydGVkOiBTY3JlZW5GaWVsZFN1cHBvcnRlZCA9IHtcbiAgICAgICAgICAgICAgICAgICAgRGF0YVRpdGxlOiBrZXksXG4gICAgICAgICAgICAgICAgICAgIHNlcXVlbmNlOiAtMSxcbiAgICAgICAgICAgICAgICAgICAgc2VnbWVudHM6IFtdLFxuICAgICAgICAgICAgICAgIH0gYXMgU2NyZWVuRmllbGRTdXBwb3J0ZWQ7XG5cbiAgICAgICAgICAgICAgICBjb25zdCBtYWluRmllbGQgPSA8UGFydGlhbDxhbnk+PmZpZWxkLm1haW5GaWVsZDtcblxuICAgICAgICAgICAgICAgIC8vIENyZWF0ZSBkaXJlY3RvcnkgZW50cnkgbm93XG4gICAgICAgICAgICAgICAgc2NyZWVuRmllbGRTdXBwb3J0ZWQuc2VnbWVudHMucHVzaChcbiAgICAgICAgICAgICAgICAgICAgKHRoaXMuX2RpY3Rpb25hcnlTZWdtZW50W21haW5GaWVsZC5pZF0gPSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBjdXJyZW50RmllbGQ6IG1haW5GaWVsZCxcbiAgICAgICAgICAgICAgICAgICAgICAgIG9uQ2hhbmdlOiBmaWVsZC5vbkNoYW5nZU1haW5GaWVsZCxcbiAgICAgICAgICAgICAgICAgICAgICAgIHNlcXVlbmNlOiAtMixcbiAgICAgICAgICAgICAgICAgICAgfSBhcyBTZWdtZW50Rm9yRGljdGlvbmFyeSksXG4gICAgICAgICAgICAgICAgKTtcblxuICAgICAgICAgICAgICAgIC8vIEFkZCB1bml0IHRvb1xuICAgICAgICAgICAgICAgIGNvbnN0IHVuaXRGaWVsZCA9IDxQYXJ0aWFsPGFueT4+ZmllbGQudW5pdEZpZWxkO1xuXG4gICAgICAgICAgICAgICAgaWYgKHVuaXRGaWVsZCkge1xuICAgICAgICAgICAgICAgICAgICBzY3JlZW5GaWVsZFN1cHBvcnRlZC5zZWdtZW50cy5wdXNoKFxuICAgICAgICAgICAgICAgICAgICAgICAgKHRoaXMuX2RpY3Rpb25hcnlTZWdtZW50W3VuaXRGaWVsZC5pZF0gPSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY3VycmVudEZpZWxkOiB1bml0RmllbGQsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgb25DaGFuZ2U6IGZpZWxkLm9uQ2hhbmdlVW5pdEZpZWxkLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHNlcXVlbmNlOiAtMyxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0gYXMgU2VnbWVudEZvckRpY3Rpb25hcnkpLFxuICAgICAgICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIHNjcmVlbkZpZWxkc1N1cHBvcnRlZC5wdXNoKHNjcmVlbkZpZWxkU3VwcG9ydGVkKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gc2NyZWVuRmllbGRzU3VwcG9ydGVkO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqICBBbmFseXplIGFsbCBmaWVsZHMgZXhpc3RpbmdcbiAgICAgKiBAcGFyYW0gcGFnZUluc3RhbmNlIGN1cnJlbnQgcGFnZVxuICAgICAqIEBwYXJhbSBkaWN0aW9uYXJ5RmllbGRUb0NoZWNrXG4gICAgICogQHJldHVybnNcbiAgICAgKi9cbiAgICAvKiogQGludGVybmFsICovXG4gICAgcHJpdmF0ZSBfZXhpc3RpbmdGaWVsZHMoXG4gICAgICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZTxHcmFwaEFwaT4sXG4gICAgICAgIGRpY3Rpb25hcnlGaWVsZFRvQ2hlY2s6IERpY3Rpb25hcnlGaWVsZFN1cHBvcnRlZCxcbiAgICApOiBTY3JlZW5GaWVsZFN1cHBvcnRlZFtdIHtcbiAgICAgICAgY29uc3QgJGl0ZW1zID0gcGFnZUluc3RhbmNlPy5fcGFnZU1ldGFkYXRhLmxheW91dC4kaXRlbXMgPz8gW107XG4gICAgICAgIGNvbnN0IHByZXBhcmVkRmllbGRzOiBTY3JlZW5GaWVsZFN1cHBvcnRlZFtdID0gdGhpcy5fcHJlcGFyZVNlZ21lbnQoZGljdGlvbmFyeUZpZWxkVG9DaGVjayk7XG4gICAgICAgIGNvbnN0IHNlbGVjdGVkRmllbGRzOiBTY3JlZW5GaWVsZFN1cHBvcnRlZFtdID0gW107XG4gICAgICAgIGNvbnN0IGRpY3Rpb25hcnlTZWdtZW50OiBEaWN0aW9uYXJ5U2VnbWVudCA9IHRoaXMuX2RpY3Rpb25hcnlTZWdtZW50O1xuICAgICAgICBsZXQgc2VxdWVuY2U6IGludGVnZXIgPSAwO1xuXG4gICAgICAgIC8vIHVpLmNvbnNvbGUud2FybihgRGljdGlvbmFyeSBwcmVwYXJlZCA6XFxuJHtKU09OLnN0cmluZ2lmeShkaWN0aW9uYXJ5U2VnbWVudCl9YCk7XG4gICAgICAgIC8vIHVpLmNvbnNvbGUud2FybihgRmllbGQgcHJlcGFyZWQgOlxcbiR7SlNPTi5zdHJpbmdpZnkocHJlcGFyZWRGaWVsZHMpfWApO1xuXG4gICAgICAgIC8vIEZvciBub3csIHRoZSBjaGVjayBkb2VzIG5vdCB0ZXN0IGlmIHRoZSBjdXJyZW50IGZpZWxkIGlzIGF2YWlsYWJsZSBvciBub3RcbiAgICAgICAgaWYgKCRpdGVtcy5sZW5ndGggPiAwICYmIHByZXBhcmVkRmllbGRzLmxlbmd0aCA+IDApIHtcbiAgICAgICAgICAgIC8vIFN0YXJ0IGFuYWx5c2lzXG4gICAgICAgICAgICB0aGlzLl9leGlzdEZpZWxkcyhcbiAgICAgICAgICAgICAgICBwYWdlSW5zdGFuY2UsXG4gICAgICAgICAgICAgICAgJGl0ZW1zLFxuICAgICAgICAgICAgICAgIGRpY3Rpb25hcnlTZWdtZW50LFxuICAgICAgICAgICAgICAgIChzZWdtZW50cywgZmllbGQpID0+IHRydWUsXG4gICAgICAgICAgICAgICAgKHNlZ21lbnRzLCBmaWVsZCkgPT4ge1xuICAgICAgICAgICAgICAgICAgICBmaWVsZC5zZXF1ZW5jZSA9ICsrc2VxdWVuY2U7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiAhT2JqZWN0LmVudHJpZXMoc2VnbWVudHMpLnNvbWUoKFtrZXksIHZhbHVlXSkgPT4gdmFsdWUuc2VxdWVuY2UgPD0gMCk7XG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICk7XG5cbiAgICAgICAgICAgIC8vIFJlbW92ZSBpbnZhbGlkIGRpY3Rpb25hcnkgZW50cmllcyA6IEVhY2ggZmllbGQgbXVzdCBiZSBoYXZlIGFsbCBzZWdtZW50cyBhdmFpbGFibGVcbiAgICAgICAgICAgIGZvciAoY29uc3QgW2tleSwgdmFsdWVdIG9mIE9iamVjdC5lbnRyaWVzKGRpY3Rpb25hcnlTZWdtZW50KSkge1xuICAgICAgICAgICAgICAgIGlmICh2YWx1ZS5zZXF1ZW5jZSA8PSAwKSB7XG4gICAgICAgICAgICAgICAgICAgIGRlbGV0ZSBkaWN0aW9uYXJ5U2VnbWVudFtrZXldO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIC8vIFVwZGF0ZSBpbnRlcm5hbCBkaWN0aW9uYXJ5IG5vd1xuICAgICAgICB0aGlzLl9kaWN0aW9uYXJ5U2VnbWVudCA9IGRpY3Rpb25hcnlTZWdtZW50O1xuXG4gICAgICAgIC8vIFJldGFpbiBlbnRyeSBvbmx5IHdpdGggZnVsbCBzZWdtZW50c1xuICAgICAgICBmb3IgKGNvbnN0IGtleSBpbiBwcmVwYXJlZEZpZWxkcykge1xuICAgICAgICAgICAgY29uc3QgZmllbGRzID0gcHJlcGFyZWRGaWVsZHNba2V5XTtcbiAgICAgICAgICAgIGlmIChcbiAgICAgICAgICAgICAgICBmaWVsZHMuc2VnbWVudHMuZXZlcnkoXG4gICAgICAgICAgICAgICAgICAgIHRoaXNTZWdtZW50ID0+XG4gICAgICAgICAgICAgICAgICAgICAgICBkaWN0aW9uYXJ5U2VnbWVudFt0aGlzU2VnbWVudC5jdXJyZW50RmllbGQuaWRdPy5jdXJyZW50RmllbGQuaWQgPT09IHRoaXNTZWdtZW50LmN1cnJlbnRGaWVsZC5pZCxcbiAgICAgICAgICAgICAgICApXG4gICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICBzZWxlY3RlZEZpZWxkcy5wdXNoKGZpZWxkcyk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIC8vIFJlbW92ZSBwYXJ0aWFsIGVudHJpZXNcbiAgICAgICAgICAgICAgICBmb3IgKGNvbnN0IHNlZ21lbnQgb2YgZmllbGRzLnNlZ21lbnRzKSB7XG4gICAgICAgICAgICAgICAgICAgIGRlbGV0ZSB0aGlzLl9kaWN0aW9uYXJ5U2VnbWVudFtzZWdtZW50LmN1cnJlbnRGaWVsZC5pZF07XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgLy8gdWkuY29uc29sZS5kZWJ1ZyhgRGljdGlvbmFyeSB1cGRhdGVkIDpcXG4ke0pTT04uc3RyaW5naWZ5KHRoaXMuX2RpY3Rpb25hcnlTZWdtZW50KX1gKTtcbiAgICAgICAgLy8gdWkuY29uc29sZS5kZWJ1ZyhgUHJlcGFyZWQgZmllbGRzIDpcXG4ke0pTT04uc3RyaW5naWZ5KHByZXBhcmVkRmllbGRzKX1gKTtcbiAgICAgICAgLy8gdWkuY29uc29sZS5kZWJ1ZyhgU2VsZWN0ZWQgZmllbGRzIDpcXG4ke0pTT04uc3RyaW5naWZ5KHNlbGVjdGVkRmllbGRzKX1gKTtcblxuICAgICAgICByZXR1cm4gc2VsZWN0ZWRGaWVsZHM7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQW5hbHl6ZSBsaXN0IG9mIGZpZWxkcyBzdWJtaXR0ZWQgKHJlY3Vyc2l2ZSlcbiAgICAgKiBAcGFyYW0gcGFnZUluc3RhbmNlIGN1cnJlbnQgcGFnZVxuICAgICAqIEBwYXJhbSAkaXRlbXNcbiAgICAgKiBAcGFyYW0gc2VnbWVudHMgY3VycmVudCBzZWdtZW50cyBsaXN0IGZvciBmaWVsZFxuICAgICAqIEBwYXJhbSBjaGVjayB2ZXJpZnkgaXMgcG9zc2libGUgdG8gdXNlIHRoZSBmaWVsZCBmb3IgYWN0aW9uXG4gICAgICogQHBhcmFtIGFjdGlvbiBwZXJmb3JtIGFjdGlvblxuICAgICAqIEByZXR1cm5zXG4gICAgICovXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgX2V4aXN0RmllbGRzKFxuICAgICAgICBwYWdlSW5zdGFuY2U6IGFueSxcbiAgICAgICAgJGl0ZW1zOiBQYXJ0aWFsPHVpLlBhZ2VBcnRpY2xlSXRlbT5bXSxcbiAgICAgICAgc2VnbWVudHM6IERpY3Rpb25hcnlTZWdtZW50LFxuICAgICAgICBjaGVjazogKHNlZ21lbnRzOiBEaWN0aW9uYXJ5U2VnbWVudCwgZmllbGQ6IFNlZ21lbnRGb3JEaWN0aW9uYXJ5KSA9PiBib29sZWFuLFxuICAgICAgICBhY3Rpb246IChzZWdtZW50czogRGljdGlvbmFyeVNlZ21lbnQsIGZpZWxkOiBTZWdtZW50Rm9yRGljdGlvbmFyeSkgPT4gYm9vbGVhbixcbiAgICApIHtcbiAgICAgICAgLy8gSW5kZXggZnJvbSBhcnJheVxuICAgICAgICBmb3IgKGxldCBpIGluICRpdGVtcykge1xuICAgICAgICAgICAgbGV0ICRiaW5kOiBhbnkgPSB1bmRlZmluZWQ7XG4gICAgICAgICAgICBsZXQgcGFnZUZpZWxkOiBhbnkgPSB1bmRlZmluZWQ7XG4gICAgICAgICAgICBsZXQgZmllbGQ6IFNlZ21lbnRGb3JEaWN0aW9uYXJ5IHwgdW5kZWZpbmVkID0gdW5kZWZpbmVkO1xuXG4gICAgICAgICAgICBpZiAoKCRiaW5kID0gJGl0ZW1zW2ldLiRiaW5kKSAmJiAocGFnZUZpZWxkID0gcGFnZUluc3RhbmNlWyRiaW5kXSkgJiYgKGZpZWxkID0gc2VnbWVudHNbcGFnZUZpZWxkPy5pZF0pKSB7XG4gICAgICAgICAgICAgICAgLy8gdWkuY29uc29sZS5kZWJ1ZyhgQmluZCBmaWVsZCA6ICR7SlNPTi5zdHJpbmdpZnkoJGJpbmQpfWApO1xuICAgICAgICAgICAgICAgIGlmIChjaGVjayhzZWdtZW50cywgZmllbGQpICYmIGFjdGlvbihzZWdtZW50cywgZmllbGQpKSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiB0cnVlO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBjb250aW51ZTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgLy8gdWkuY29uc29sZS5kZWJ1ZyhgU2tpcHBpbmcgYmluZGVkIGZpZWxkIDogJHtKU09OLnN0cmluZ2lmeSgkYmluZCl9YCk7XG4gICAgICAgICAgICAgICAgY29uc3QgJGl0ZW1zMiA9ICRpdGVtc1tpXS4kbGF5b3V0Py4kaXRlbXMgPz8gW107XG4gICAgICAgICAgICAgICAgLy8gcmVjdXJzaXZlbHkgc2VhcmNoIGZvciAnYmluZGVkJyBjb21wb25lbnRzIGluc2lkZSB0aGUgbGF5b3V0J3MgY29udGFpbmVycyBsaWtlIHNlY3Rpb24gJiBibG9ja3NcbiAgICAgICAgICAgICAgICBpZiAoJGl0ZW1zMi5sZW5ndGggPiAwICYmIHRoaXMuX2V4aXN0RmllbGRzKHBhZ2VJbnN0YW5jZSwgPGFueT4kaXRlbXMyLCBzZWdtZW50cywgY2hlY2ssIGFjdGlvbikpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBTZWN0aW9uIHBhZ2UgdmFsaWRhdGlvblxuICAgICAqICovXG5cbiAgICAvKipcbiAgICAgKiBQZXJmb3JtIHZhbGlkYXRpb24gb2YgYWxsIHNlZ21lbnRzIG1hbmFnZWRcbiAgICAgKiBAcGFyYW0gcGFnZUluc3RhbmNlIGN1cnJlbnQgcGFnZVxuICAgICAqIEBwYXJhbSBlcnJvck1lc3NhZ2UgdHJhbnNsYXRlZCBtZXNzYWdlIGVycm9yIGVycm9yTWVzc2FnZUNoZWNrWW91ckVudHJ5XG4gICAgICogQHJldHVybnNcbiAgICAgKi9cbiAgICBwdWJsaWMgYXN5bmMgdmFsaWRhdGUocGFnZUluc3RhbmNlOiB1aS5QYWdlLCBlcnJvck1lc3NhZ2U6IHN0cmluZyA9IGVycm9yTWVzc2FnZUNoZWNrWW91ckVudHJ5KTogUHJvbWlzZTxib29sZWFuPiB7XG4gICAgICAgIGNvbnN0IGZpZWxkRXJyb3JzID0gbmV3IEFycmF5PHN0cmluZz4oKTtcbiAgICAgICAgY29uc3QgaXNQYWdlVmFsaWQ6IGJvb2xlYW4gPSBhd2FpdCBwYWdlSW5zdGFuY2UuJC5wYWdlLmlzVmFsaWQ7XG4gICAgICAgIGxldCBhcmVBbGxGaWVsZHNWYWxpZCA9IHRydWU7XG5cbiAgICAgICAgZm9yIChjb25zdCBmaWVsZCBvZiB0aGlzLl9zY3JlZW5GaWVsZHNTdXBwb3J0ZWQpIHtcbiAgICAgICAgICAgIGZvciAoY29uc3Qgc2VnbWVudCBvZiBmaWVsZC5zZWdtZW50cykge1xuICAgICAgICAgICAgICAgIGlmICghKGF3YWl0IHRoaXMuX3ZhbGlkYXRlRmllbGQoc2VnbWVudC5jdXJyZW50RmllbGQpKSkge1xuICAgICAgICAgICAgICAgICAgICBhcmVBbGxGaWVsZHNWYWxpZCA9IGZhbHNlO1xuICAgICAgICAgICAgICAgICAgICBmaWVsZEVycm9ycy5wdXNoKHNlZ21lbnQuY3VycmVudEZpZWxkLmlkKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoZmllbGRFcnJvcnMubGVuZ3RoID4gMCkge1xuICAgICAgICAgICAgdGhpcy5fbm90aWZ5RmllbGROb3RWYWxpZChwYWdlSW5zdGFuY2UsIGZpZWxkRXJyb3JzLCBlcnJvck1lc3NhZ2UpO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIGlzUGFnZVZhbGlkICYmIGFyZUFsbEZpZWxkc1ZhbGlkO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFBlcmZvcm0gZmllbGQgdmFsaWRhdGlvblxuICAgICAqIEBwYXJhbSBmaWVsZCBjdXJyZW50IGZpZWxkXG4gICAgICogQHJldHVybnMgdHJ1ZSB3aGVuIGZpZWxkIGlzIHZhbGlkYXRlZFxuICAgICAqL1xuICAgIC8qKiBAaW50ZXJuYWwgKi9cbiAgICBwcml2YXRlIGFzeW5jIF92YWxpZGF0ZUZpZWxkKGZpZWxkOiBCYXJjb2RlTWFuYWdlclN1cHBvcnRlZEZpZWxkcyk6IFByb21pc2U8Ym9vbGVhbj4ge1xuICAgICAgICByZXR1cm4gIShhd2FpdCBmaWVsZC52YWxpZGF0ZSgpKTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBOb3RpZnkgYWxsIGZpZWxkcyBpbnZhbGlkc1xuICAgICAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlXG4gICAgICogQHBhcmFtIGVycm9yTWVzc2FnZSB0cmFuc2xhdGVkIG1lc3NhZ2UgZXJyb3IgZXJyb3JNZXNzYWdlQ2hlY2tZb3VyRW50cnlcbiAgICAgKiBAcGFyYW0gZmllbGRzXG4gICAgICovXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgYXN5bmMgX25vdGlmeUZpZWxkTm90VmFsaWQoXG4gICAgICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZSxcbiAgICAgICAgZmllbGRzOiBzdHJpbmdbXSxcbiAgICAgICAgZXJyb3JNZXNzYWdlOiBzdHJpbmcgPSBlcnJvck1lc3NhZ2VDaGVja1lvdXJFbnRyeSxcbiAgICApOiBQcm9taXNlPHZvaWQ+IHtcbiAgICAgICAgcGFnZUluc3RhbmNlLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgIHBhZ2VJbnN0YW5jZS4kLnNob3dUb2FzdChcbiAgICAgICAgICAgIGZvcm1hdFN0cmluZyhlcnJvck1lc3NhZ2UsICdiYXNlJywge1xuICAgICAgICAgICAgICAgIGZpZWxkTmFtZXM6IGZpZWxkcy5tYXAoZmllbGQgPT4gKHBhZ2VJbnN0YW5jZSBhcyBhbnkpW2ZpZWxkXT8udGl0bGUpLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICB7IHR5cGU6ICdlcnJvcicsIHRpbWVvdXQ6IDUwMDAgfSxcbiAgICAgICAgKTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBWYWxpZGF0ZSBjdXJyZW50IHBhZ2VcbiAgICAgKiBAcGFyYW0gcGFnZUluc3RhbmNlIGN1cnJlbnQgcGFnZVxuICAgICAqIEBwYXJhbSBlcnJvck1lc3NhZ2UgdHJhbnNsYXRlZCBtZXNzYWdlIGVycm9yIGVycm9yTWVzc2FnZUVycm9yXG4gICAgICogQHJldHVybnMgZmFsc2Ugd2hlbiBlcnJvciBvY2N1clxuICAgICAqL1xuICAgIHB1YmxpYyBhc3luYyB2YWxpZGF0ZVBhZ2UocGFnZUluc3RhbmNlOiB1aS5QYWdlLCBlcnJvck1lc3NhZ2U6IHN0cmluZyA9IGVycm9yTWVzc2FnZUVycm9yKTogUHJvbWlzZTxib29sZWFuPiB7XG4gICAgICAgIGNvbnN0IGVycm9ycyA9IGF3YWl0IHBhZ2VJbnN0YW5jZS4kLnBhZ2UudmFsaWRhdGUoKTtcbiAgICAgICAgaWYgKCFlcnJvcnMubGVuZ3RoKSB7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IHp6ID0gcGFnZUluc3RhbmNlLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgIHBhZ2VJbnN0YW5jZS4kLnNob3dUb2FzdChgJHtmb3JtYXRTdHJpbmcoZXJyb3JNZXNzYWdlLCAnYmFzZScpfTogJHtlcnJvcnNbMF19YCwge1xuICAgICAgICAgICAgdHlwZTogJ2Vycm9yJyxcbiAgICAgICAgICAgIHRpbWVvdXQ6IDMwMDAwLFxuICAgICAgICB9KTtcblxuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogcGVyZm9ybSBmaWVsZHMgdmFsaWRhdGlvbiB3aXRoIGRldGFpbGVkIGVycm9ycyBsaXN0cy5cbiAgICAgKiBAcGFyYW0gcGFnZUluc3RhbmNlIGN1cnJlbnQgcGFnZVxuICAgICAqIEBwYXJhbSBlcnJvck1lc3NhZ2UgZXJyb3JNZXNzYWdlQ2hlY2tZb3VyRW50cnlcbiAgICAgKiBAcmV0dXJucyBmYWxzZSB3aGVuIGVycm9yIG9jY3VyXG4gICAgICovXG4gICAgcHVibGljIGFzeW5jIHZhbGlkYXRlV2l0aERldGFpbHMoXG4gICAgICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZSxcbiAgICAgICAgZXJyb3JNZXNzYWdlOiBzdHJpbmcgPSBlcnJvck1lc3NhZ2VDaGVja1lvdXJFbnRyeSxcbiAgICApOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgICAgICAgLy8gUmVxdWVzdCBjaGFuZ2UgdG8gcGFnZVxuICAgICAgICAvLyB0byBoYW5kbGUgc3VjaCBlZGd5IGNhc2VzIGFzIHVzZXIgY2xlYXJpbmcgYW4gaW5wdXQgZnJvbSBhIGZpZWxkIGFuZCB0aGVuIGRpcmVjdGx5IGNsaWNraW5nIG9uIGEgYnV0dG9uIHdpdGhvdXQgYmx1cnJpbmcgdGhhdCBmaWVsZFxuICAgICAgICBhd2FpdCBwYWdlSW5zdGFuY2UuJC5jb21taXRWYWx1ZUFuZFByb3BlcnR5Q2hhbmdlcygpO1xuXG4gICAgICAgIGNvbnN0IGVycm9yczogdWkuVmFsaWRhdGlvblJlc3VsdFtdID0gYXdhaXQgcGFnZUluc3RhbmNlLiQucGFnZS52YWxpZGF0ZVdpdGhEZXRhaWxzKCk7XG4gICAgICAgIGlmICghZXJyb3JzLmxlbmd0aCkge1xuICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgIH1cblxuICAgICAgICBwYWdlSW5zdGFuY2UuJC5yZW1vdmVUb2FzdHMoKTtcbiAgICAgICAgcGFnZUluc3RhbmNlLiQuc2hvd1RvYXN0KFxuICAgICAgICAgICAgZm9ybWF0U3RyaW5nKGVycm9yTWVzc2FnZSwgJ2Jhc2UnLCB7XG4gICAgICAgICAgICAgICAgZmllbGROYW1lczogZXJyb3JzLm1hcChcbiAgICAgICAgICAgICAgICAgICAgKGVycm9yOiB1aS5WYWxpZGF0aW9uUmVzdWx0KSA9PlxuICAgICAgICAgICAgICAgICAgICAgICAgYCR7KHBhZ2VJbnN0YW5jZSBhcyBhbnkpW2Vycm9yLmVsZW1lbnRJZF0/LnRpdGxlID8/IGVycm9yLmVsZW1lbnRJZH1gLFxuICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHsgdHlwZTogJ2Vycm9yJywgdGltZW91dDogNTAwMCB9LFxuICAgICAgICApO1xuXG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/management-service-gs-1.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts":
/*!*****************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\n/** Interfaces and types for management code GS 1 */\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.compositeCodePrefix = void 0;\nexports.compositeCodePrefix = /^(\\d{2,4}|\\][A-Za-z]\\d{3,5}|\\x1d\\d{2,4})/;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN5c3RlbS9saWIvY2xpZW50LWZ1bmN0aW9ucy9zY3JlZW4tbWFuYWdlbWVudC1ncy0xLnRzIiwibWFwcGluZ3MiOiI7QUFBQSxvREFBb0Q7OztBQU92QywyQkFBbUIsR0FBRywwQ0FBMEMsQ0FBQyIsInNvdXJjZXMiOlsid2VicGFjazovL3h0cmVtQXJ0aWZhY3QvLi4vLi4vc2hhcmVkL3gzLXN5c3RlbS9saWIvY2xpZW50LWZ1bmN0aW9ucy9zY3JlZW4tbWFuYWdlbWVudC1ncy0xLnRzPzhhZTciXSwic291cmNlc0NvbnRlbnQiOlsiLyoqIEludGVyZmFjZXMgYW5kIHR5cGVzIGZvciBtYW5hZ2VtZW50IGNvZGUgR1MgMSAqL1xuXG5pbXBvcnQgeyBEYXRlVmFsdWUgfSBmcm9tICdAc2FnZS94dHJlbS1kYXRlLXRpbWUnO1xuaW1wb3J0IHsgaW50ZWdlciB9IGZyb20gJ0BzYWdlL3h0cmVtLXNoYXJlZCc7XG5pbXBvcnQgeyBmaWVsZHMgfSBmcm9tICdAc2FnZS94dHJlbS11aSc7XG5pbXBvcnQgeyBEYXRhVGl0bGUgfSBmcm9tICcuLi9zaGFyZWQtZnVuY3Rpb25zL2luZGV4JztcblxuZXhwb3J0IGNvbnN0IGNvbXBvc2l0ZUNvZGVQcmVmaXggPSAvXihcXGR7Miw0fXxcXF1bQS1aYS16XVxcZHszLDV9fFxceDFkXFxkezIsNH0pLztcblxuLy8gSW5jb21pbmcgcGFnZSBmaWVsZHMgZGVmaW5pdGlvblxuXG5leHBvcnQgdHlwZSBCYXJjb2RlTWFuYWdlclN1cHBvcnRlZEZpZWxkcyA9XG4gICAgfCBmaWVsZHMuUmVmZXJlbmNlXG4gICAgfCBmaWVsZHMuRGF0ZVxuICAgIHwgZmllbGRzLlRleHRcbiAgICB8IGZpZWxkcy5OdW1lcmljXG4gICAgfCBmaWVsZHMuRmlsdGVyU2VsZWN0O1xuXG5leHBvcnQgdHlwZSBFbGVtZW50VHlwZVN1cHBvcnRlZCA9IHN0cmluZyB8IERhdGVWYWx1ZSB8IG51bWJlciB8IHVuZGVmaW5lZDtcblxuZXhwb3J0IHR5cGUgQXN5bmNWb2lkRnVuY3Rpb24gPSAoKSA9PiBQcm9taXNlPHZvaWQ+O1xuXG5leHBvcnQgdHlwZSBWb2lkRnVuY3Rpb24gPSAoKSA9PiB2b2lkO1xuXG5leHBvcnQgdHlwZSBBc3luY0FuZFZvaWRGdW5jdGlvbiA9IEFzeW5jVm9pZEZ1bmN0aW9uIHwgVm9pZEZ1bmN0aW9uO1xuXG5leHBvcnQgaW50ZXJmYWNlIEZpZWxkU3VwcG9ydGVkIHtcbiAgICBtYWluRmllbGQ6IEJhcmNvZGVNYW5hZ2VyU3VwcG9ydGVkRmllbGRzO1xuICAgIG9uQ2hhbmdlTWFpbkZpZWxkPzogQXN5bmNWb2lkRnVuY3Rpb247XG4gICAgdW5pdEZpZWxkPzogQmFyY29kZU1hbmFnZXJTdXBwb3J0ZWRGaWVsZHM7XG4gICAgb25DaGFuZ2VVbml0RmllbGQ/OiBBc3luY1ZvaWRGdW5jdGlvbjtcbn1cblxuZXhwb3J0IHR5cGUgRGljdGlvbmFyeUZpZWxkU3VwcG9ydGVkID0gUmVjb3JkPERhdGFUaXRsZSwgRmllbGRTdXBwb3J0ZWQ+O1xuXG4vLyBJbnRlcm5hbCBwYWdlIGZpZWxkcyBkZWZpbml0aW9uXG5cbi8qKiBAaW50ZXJuYWwgKi9cbmV4cG9ydCBpbnRlcmZhY2UgRmllbGRTZWdtZW50IHtcbiAgICBjdXJyZW50RmllbGQ6IEJhcmNvZGVNYW5hZ2VyU3VwcG9ydGVkRmllbGRzO1xuICAgIG9uQ2hhbmdlPzogQXN5bmNWb2lkRnVuY3Rpb247XG59XG5cbi8qKlxuICogVGhpcyBhdHRyaWJ1dGUgaXMgdXNlZCBmb3IgdmVyeSBvcmRlciBvZiBzZWdtZW50IGludG8gcGFnZS4uLlxuICogd2hlbiB0aGUgdmFsdWUgaGFzIG5vdCBjaGFuZ2VkLCB0aGlzIHNlZ21lbnQgaGFzIHVudXNlZFxuICovXG4vKiogQGludGVybmFsICovXG5leHBvcnQgaW50ZXJmYWNlIFNlZ21lbnRGb3JEaWN0aW9uYXJ5IGV4dGVuZHMgRmllbGRTZWdtZW50IHtcbiAgICBzZXF1ZW5jZTogaW50ZWdlcjtcbn1cblxuLyoqIEBpbnRlcm5hbCAqL1xuZXhwb3J0IHR5cGUgRGljdGlvbmFyeVNlZ21lbnQgPSBSZWNvcmQ8c3RyaW5nLCBTZWdtZW50Rm9yRGljdGlvbmFyeT47XG5cbi8vIFRoaXMgZXhwb3NlIG9ubHkgZGF0YSBkdXJpbmcgbWFwcGluZyBvcGVyYXRpb25zXG4vKiogQGludGVybmFsICovXG5leHBvcnQgaW50ZXJmYWNlIERhdGFTZWdtZW50TWFwcGVkIGV4dGVuZHMgRmllbGRTZWdtZW50IHtcbiAgICBkYXRhOiBhbnk7XG59XG5cbi8vIFRoaXMgZXhwb3NlIG9ubHkgZGF0YSBkdXJpbmcgbWFwcGluZyBvcGVyYXRpb25zXG5cbi8qKiBAaW50ZXJuYWwgKi9cbmV4cG9ydCBpbnRlcmZhY2UgRmllbGREYXRhVHlwZSB7XG4gICAgRGF0YVRpdGxlOiBEYXRhVGl0bGU7XG59XG5cbi8qKlxuICogVGhpcyBhdHRyaWJ1dGUgaXMgdXNlZCBmb3IgdmVyeSBvcmRlciBvZiBmaWVsZCBpbnRvIHBhZ2UuLi5cbiAqIHdoZW4gdGhlIHZhbHVlIGhhcyBub3QgY2hhbmdlZCwgdGhpcyBmaWVsZCBoYXMgdW51c2VkXG4gKiBUaGlzIGludGVyZmFjZSBzdG9yZSBvbmx5IG1pbmltdW0gZGF0YS4uXG4gKi9cbi8qKiBAaW50ZXJuYWwgKi9cbmV4cG9ydCBpbnRlcmZhY2UgRGF0YUZpZWxkTWFwcGVkIGV4dGVuZHMgRmllbGREYXRhVHlwZSwgRmllbGRTdXBwb3J0ZWQge1xuICAgIHNlcXVlbmNlOiBudW1iZXI7XG4gICAgZGF0YT86IEVsZW1lbnRUeXBlU3VwcG9ydGVkO1xuICAgIHVuaXQ/OiBFbGVtZW50VHlwZVN1cHBvcnRlZDtcbn1cblxuLy8gU3VwcG9ydGVkIHBhZ2UgZmllbGRzIGRlZmluaXRpb24gd2l0aG91dCBkYXRhXG5cbi8qKlxuICogVGhpcyBhdHRyaWJ1dGUgaXMgdXNlZCBmb3IgdmVyeSBvcmRlciBvZiBmaWVsZCBpbnRvIHBhZ2UuLi5cbiAqIHdoZW4gdGhlIHZhbHVlIGhhcyBub3QgY2hhbmdlZCwgdGhpcyBmaWVsZCBoYXMgdW51c2VkXG4gKi9cbi8qKiBAaW50ZXJuYWwgKi9cbmV4cG9ydCBpbnRlcmZhY2UgU2NyZWVuRmllbGRTdXBwb3J0ZWQgZXh0ZW5kcyBGaWVsZERhdGFUeXBlIHtcbiAgICBzZXF1ZW5jZTogbnVtYmVyO1xuICAgIHNlZ21lbnRzOiBGaWVsZFNlZ21lbnRbXTtcbn1cblxuLy8gRGF0YSBjb21wb3NpdGVcblxuLyoqXG4gKiBUaGlzIGNvbXBvc2l0ZSBpdGVtIGlzIHVzZWQgaW4gc3RvcmFnZSBhbmQgc2VydmljZVxuICovXG5leHBvcnQgdHlwZSBEYXRhQ29tcG9zaXRlID0ge1xuICAgIERhdGFUaXRsZTogRGF0YVRpdGxlO1xuICAgIGRhdGE6IEVsZW1lbnRUeXBlU3VwcG9ydGVkO1xuICAgIHVuaXQ/OiBFbGVtZW50VHlwZVN1cHBvcnRlZDtcbn07XG5cbi8qKlxuICogQWxsIGNvbXBvc2l0ZSBkYXRhIGhhdmUgc3RvcmVkIGluIGRpY3Rpb25hcnkuXG4gKi9cbmV4cG9ydCB0eXBlIERpY3Rpb25hcnlEYXRhQ29tcG9zaXRlID0gUmVjb3JkPERhdGFUaXRsZSwgRGF0YUNvbXBvc2l0ZT47XG5cbi8qKlxuICogVGhpcyBhc3luY2hyb25vdXMgZnVuY3Rpb24gc2lnbmF0dXJlIGlzIHVzZWQgb25seSBmb3Igc3BlY2lmeWluZ1xuICogYSBjYWxsIGJhY2sgdG8gY2hlY2sgY29tcG9zaXRlIGRhdGEgYmVmb3JlIGNvbnRpbnVvdXNcbiAqIEBwYXJhbSBkaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZSA6IGN1cnJlbnQgZGljdGlvbmFyeSAgKG1heSBiZSBlbXB0eSlcbiAqIEByZXR1cm4gdHJ1ZSB3aGVuIGRpc3BhdGNoaW5nIGlzIGFsbG93aW5nIHRvIGNvbnRpbnVlIGFjdGlvblxuICogICAgICAgICBmYWxzZSB3aGVuIGRpc3BhdGNoaW5nIG11c3QgY2xlYXIgYWxsIGNvbXBvc2l0ZXMgYW5kIGV4aXRpbmdcbiAqL1xuZXhwb3J0IHR5cGUgQXN5bmNDb21wb3NpdGVBbGxvd2VkID0gKGRpY3Rpb25hcnlEYXRhQ29tcG9zaXRlOiBEaWN0aW9uYXJ5RGF0YUNvbXBvc2l0ZSkgPT4gUHJvbWlzZTxib29sZWFuPjtcbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/support-service-management-gs-1-page.ts":
/*!*******************************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/support-service-management-gs-1-page.ts ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.SupportServiceManagementGs1Page = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst screen_management_gs_1_1 = __webpack_require__(/*! ./screen-management-gs-1 */ \"../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts\");\nconst management_service_gs_1_1 = __webpack_require__(/*! ./management-service-gs-1 */ \"../../shared/x3-system/lib/client-functions/management-service-gs-1.ts\");\nconst defaultManagementServiceKey = 'DEFAULT_MOBILE_COMPOSITE_GS_1_DATA_KEY';\nclass SupportServiceManagementGs1Page extends ui.Page {\n    /**\n     * Internal only\n     */\n    constructor() {\n        super();\n        /**\n         * Used only for disable scan operation (service must stay active)\n         */\n        /** @internal */\n        this._disableServiceGs1 = false;\n        this._controlManagerGs1 = new management_service_gs_1_1.ManagementServiceGs1(defaultManagementServiceKey);\n    }\n    /**\n     * Initialize ControlManagerGs1\n     *\n     * @param site current site\n     * @param compositePageKey key for storage operation\n     * @param dictionaryFieldSupported fields screen to manage and control\n     * @param dictionaryDataComposites? optional composite data\n     * @param checkCompositeDataAllowed? optional client callback to check composite data code before to dispatch them\n     * @returns true when ControlManagerGs1 has usable\n     */\n    /** @internal */\n    async _createAndInitControlManagerGs1(site, compositePageKey, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed) {\n        this._controlManagerGs1 = new management_service_gs_1_1.ManagementServiceGs1(compositePageKey);\n        // Including erroneous field misspelled dateTestFake instead dateTest\n        if (site && compositePageKey) {\n            if ((await this._controlManagerGs1\n                .initialize(this, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed)\n                .catch(() => false))) {\n                return true;\n            }\n            else {\n                // Error detected, abort controller\n                ui.console.error(`Service initialization failure for site ${site}`);\n            }\n        }\n        // Initialization failure : reset to default instance\n        this._controlManagerGs1 = new management_service_gs_1_1.ManagementServiceGs1(defaultManagementServiceKey);\n        return false;\n    }\n    /**\n     * Protected only\n     */\n    /**\n     * Return current state of service\n     */\n    /** @protected */\n    get isServiceGs1Disabled() {\n        return this._disableServiceGs1;\n    }\n    /**\n     * Disable or enable service (default : enable) :\n     * Disabling clearing all composite data\n     */\n    /** @protected */\n    set disableServiceGs1(disableServiceGs1) {\n        this._disableServiceGs1 = disableServiceGs1;\n        if (this._disableServiceGs1) {\n            this._controlManagerGs1.clearCompositeData();\n        }\n    }\n    /**\n     * Get current control manager instance\n     */\n    /** @protected */\n    get controlManagerGs1() {\n        return this._controlManagerGs1;\n    }\n    /**\n     * Remove composite data\n     */\n    /** @protected */\n    clearCompositeData() {\n        this._controlManagerGs1.clearCompositeData();\n    }\n    /**\n     * Remove composite data from storage\n     * @param storageKey optional, for overriding current service key (use with caution)\n     */\n    /** @protected */\n    clearCompositeDataStorage(storageKey) {\n        this._controlManagerGs1.clearCompositeDataStorage(this, storageKey);\n    }\n    /**\n     * Remove all composite and storage data\n     * @param storageKey optional, for overriding current service key (use with caution)\n     */\n    /** @protected */\n    clearAllCompositeDataAndStorage(storageKey) {\n        this._controlManagerGs1.clearAllCompositeDataAndStorage(this, storageKey);\n    }\n    /**\n     * Create and initialize manager for a given service :\n     * manager stay available only when site has defined and initialization is done.\n     *\n     * @param site current site\n     * @param compositePageKey key for storage operation\n     * @param dictionaryFieldSupported fields screen to manage and control\n     * @param dictionaryDataComposites? optional composite data\n     * @param checkCompositeDataAllowed? optional client callback to check composite data code before to dispatch them\n     * @return false when service has not properly initialized (unavailable)\n     */\n    /** @protected */\n    async createAndInitServiceGs1(site, compositePageKey, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed) {\n        if (!site ||\n            !(await this._createAndInitControlManagerGs1(site, compositePageKey, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed))) {\n            ui.console.error(`Unable to initialize service control manager Gs 1 for site ${site}`);\n            return false;\n        }\n        return true;\n    }\n    /**\n     * Load composite data from storage and erase them\n     * @returns true when some data has been loaded\n     */\n    /** @protected */\n    loadCompositeData() {\n        return this._controlManagerGs1.loadCompositeData(this);\n    }\n    /**\n     * Save composite data, zero elements allowed\n     * @returns true when operation has performed\n     */\n    /** @protected */\n    saveCompositeData() {\n        return this._controlManagerGs1.saveCompositeData(this);\n    }\n    /**\n     * call scan evaluator only when manager available and rawData has minimum requirement\n     * @param mainField current screen field reference\n     * @param rawData data to parse\n     * @return false when is not a bar code composite\n     */\n    /** @protected */\n    async scanBarCode(mainField, rawData) {\n        // class must be created, initialized and not busy, data must be started by a numeric value,\n        // minimum size 2 to 4 numerics or prefix ]<alphabetic><numeric>\n        if (!(this._disableServiceGs1 ?? false) && typesLib.gt(rawData.length, 4) &&\n            Number(rawData.match(screen_management_gs_1_1.compositeCodePrefix)?.length)) {\n            return (await this._controlManagerGs1\n                .scan(this, mainField, rawData)\n                .catch(() => false));\n        }\n        return false;\n    }\n    /**\n     * Update screen fields supported (only when exists Gs1 parameters).\n     * mapping field has been performed after\n     * @param dictionaryFieldSupported dictionary of page fields submitted\n     * @returns true when done, false when no any field to process with data\n     */\n    async setScreenFieldSupported(dictionaryFieldSupported) {\n        return await this._controlManagerGs1.setScreenFieldSupported(this, dictionaryFieldSupported);\n    }\n}\nexports.SupportServiceManagementGs1Page = SupportServiceManagementGs1Page;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/support-service-management-gs-1-page.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/shared-functions/barcode-parser.ts":
/*!*********************************************************************!*\
  !*** ../../shared/x3-system/lib/shared-functions/barcode-parser.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.parseBarcode = exports.ParseBarCode = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\n/**\n * P. Brockfeld, 2014-02-05\n *\n * JavaScript for parsing GS1 barCodes, see\n *\n * https://github.com/hprange/BarcodeParser (active fork)\n *\n * https://github.com/PeterBrockfeld/BarcodeParser (original repo)\n *\n * for details.\n */\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst parsed_element_1 = __webpack_require__(/*! ./parsed-element */ \"../../shared/x3-system/lib/shared-functions/parsed-element.ts\");\n/**\n * This section store internal errors\n */\nvar ErrorMessages;\n(function (ErrorMessages) {\n    ErrorMessages[\"invalidAIAfter0\"] = \"invalid AI after '0'\";\n    ErrorMessages[\"invalidAIAfter1\"] = \"invalid AI after '1'\";\n    ErrorMessages[\"invalidAIAfter24\"] = \"invalid AI after '24'\";\n    ErrorMessages[\"invalidAIAfter25\"] = \"invalid AI after '25'\";\n    ErrorMessages[\"invalidAIAfter2\"] = \"invalid AI after '2'\";\n    ErrorMessages[\"invalidAIAfter31\"] = \"invalid AI after '31'\";\n    ErrorMessages[\"invalidAIAfter32\"] = \"invalid AI after '32'\";\n    ErrorMessages[\"invalidAIAfter33\"] = \"invalid AI after '33'\";\n    ErrorMessages[\"invalidAIAfter34\"] = \"invalid AI after '34'\";\n    ErrorMessages[\"invalidAIAfter35\"] = \"invalid AI after '35'\";\n    ErrorMessages[\"invalidAIAfter36\"] = \"invalid AI after '36'\";\n    ErrorMessages[\"invalidAIAfter39\"] = \"invalid AI after '39'\";\n    ErrorMessages[\"invalidAIAfter3\"] = \"invalid AI after '3'\";\n    ErrorMessages[\"invalidAIAfter40\"] = \"invalid AI after '40'\";\n    ErrorMessages[\"invalidAIAfter41\"] = \"invalid AI after '41'\";\n    ErrorMessages[\"invalidAIAfter42\"] = \"invalid AI after '42'\";\n    ErrorMessages[\"invalidAIAfter4\"] = \"invalid AI after '4'\";\n    ErrorMessages[\"invalidAIAfter700\"] = \"invalid AI after '700'\";\n    ErrorMessages[\"invalidAIAfter70\"] = \"invalid AI after '70'\";\n    ErrorMessages[\"invalidAIAfter71\"] = \"invalid AI after '71'\";\n    ErrorMessages[\"invalidAIAfter7\"] = \"invalid AI after '7'\";\n    ErrorMessages[\"invalidAIAfter800\"] = \"invalid AI after '800'\";\n    ErrorMessages[\"invalidAIAfter801\"] = \"invalid AI after '801'\";\n    ErrorMessages[\"invalidAIAfter802\"] = \"invalid AI after '802'\";\n    ErrorMessages[\"invalidAIAfter80\"] = \"invalid AI after '80'\";\n    ErrorMessages[\"invalidAIAfter810\"] = \"invalid AI after '810'\";\n    ErrorMessages[\"invalidAIAfter811\"] = \"invalid AI after '811'\";\n    ErrorMessages[\"invalidAIAfter81\"] = \"invalid AI after '81'\";\n    ErrorMessages[\"invalidAIAfter82\"] = \"invalid AI after '82'\";\n    ErrorMessages[\"invalidAIAfter8\"] = \"invalid AI after '8'\";\n    ErrorMessages[\"invalidAIAfter9\"] = \"invalid AI after '9'\";\n    ErrorMessages[\"noValidAI\"] = \"no valid AI\";\n    ErrorMessages[\"invalidNumber\"] = \"invalid number\";\n    ErrorMessages[\"invalidFixedSizeInParse\"] = \"invalid fixed size in parse\";\n    ErrorMessages[\"invalidVariableSizeInParse\"] = \"invalid variable size in parse\";\n    ErrorMessages[\"invalidFixedSizeMeasureInParse\"] = \"invalid fixed size measure in parse\";\n    ErrorMessages[\"invalidVariableSizeMeasureInParse\"] = \"invalid variable size measure in parse\";\n    ErrorMessages[\"invalidVariableSizeWithISONumbersInParse\"] = \"invalid variable size with ISO numbers in parse\";\n    ErrorMessages[\"invalidVariableSizeWithISOCharsInParse\"] = \"invalid variable size with ISO chars in parse\";\n    ErrorMessages[\"invalidDateSizeInParse\"] = \"invalid date size in parse\";\n})(ErrorMessages || (ErrorMessages = {}));\nclass ParseBarCode {\n    constructor(codeString = '') {\n        // Main function\n        /* @internal */\n        this._codeString = '';\n        /* @internal */\n        this._codeStringLength = this.codeString.length;\n        this._codeString = codeString;\n        this._fncChar = String.fromCharCode(29); // the ASCII \"group separator\"\n    }\n    /**\n     * Special separator of variable record\n     */\n    get fncChar() {\n        return this._fncChar;\n    }\n    /**\n     * String before change\n     */\n    get codeString() {\n        return this._codeString;\n    }\n    set codeString(codeString) {\n        this._codeString = codeString;\n        this._codeStringLength = codeString.length;\n    }\n    /**\n     * String length before change\n     */\n    get codeStringLength() {\n        return this._codeStringLength;\n    }\n    /** Evaluate barcode received */\n    parseBarcode(barcode) {\n        const barCodeLength = barcode.length;\n        const answer = {}; // the object to return\n        let restOfBarcode = ''; // the rest of the barcode, when first\n        // elements are spliced away\n        const symbologyIdentifier = barcode.slice(0, 3);\n        let firstElement = {};\n        /**\n         * =========== BEGIN of main routine ===================\n         */\n        /**\n         *\n         * ==== First step: ====\n         *\n         * IF there is any symbology identifier\n         *   chop it off;\n         *   put as \"codeName\" into the answer;\n         *   fill restOfBarcode with the rest\n         *   after the symbology identifier;\n         * ELSE\n         *   leave \"codeName\" empty;\n         *   put the whole barcode into restOfBarcode;\n         */\n        if (barcode.startsWith(this.fncChar)) {\n            answer.codeName = 'GS1-128';\n            restOfBarcode = barcode.slice(1, barCodeLength);\n        }\n        else {\n            switch (symbologyIdentifier) {\n                case ']C1':\n                    answer.codeName = 'GS1-128';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                case ']e0':\n                    answer.codeName = 'GS1 DataBar';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                case ']e1':\n                case ']e2':\n                    answer.codeName = 'GS1 Composite';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                case ']d2':\n                    answer.codeName = 'GS1 DataMatrix';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                case ']Q3':\n                    answer.codeName = 'GS1 QR Code';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                default:\n                    answer.codeName = '';\n                    restOfBarcode = barcode;\n                    break;\n            }\n        }\n        /**\n         * we have chopped off any symbology identifier. Now we can\n         * try to parse the rest. It should give us an array of\n         * ParsedElements.\n         */\n        /**\n         * ===== Second step: ====\n         *\n         * Parse \"barcode\" data element by data element using\n         * identifyAI.\n         *\n         */\n        answer.parsedCodeItems = [];\n        /**\n         * The following part calls \"identifyAI\" in a loop, until\n         * the whole barcode is parsed (or an error occurs).\n         *\n         * It uses the following strategy:\n         *\n         *   try to parse the part after the symbology identifier:\n         *   - identify the first AI;\n         *   - make a parsed element from the part after the AI;\n         *   - append the parsed element to answer;\n         *   - chop off the parsed part;\n         *  do so while there is left something to parse;\n         */\n        while (typesLib.gt(restOfBarcode.length, 0)) {\n            try {\n                firstElement = this._identifyAI(restOfBarcode);\n                restOfBarcode = firstElement.codeString;\n                answer.parsedCodeItems.push(firstElement.element);\n            }\n            catch (e) {\n                throw new xtrem_shared_1.SystemError(e.message, e);\n            }\n        }\n        /**\n         * ==== Third and last step: =====\n         *\n         */\n        return answer;\n    }\n    // auxillary functions\n    /**\n     * \"ParsedElement\" is the\n     *\n     * @constructor for ParsedElements, the components of the array returned by parseBarcode\n     * @param {String} elementAI        the AI of the recognized element\n     * @param {String} elementDataTitle the title of the element, i.e. its short description\n     * @param {String} elementType      a one-letter string describing the type of the element.\n     *                                  allowed values are\n     *                                  \"string\" for strings,\n     *                                  \"numeric\" for numbers and\n     *                                  \"date\" for dates\n     */\n    /**\n     *\n     * ================== BEGIN of identifyAI =======================\n     *\n     * does the main work:\n     *   what AI is in the beginning of the restOfBarcode?\n     *     If identified:\n     *       which function to call with\n     *       which parameters to parse the element?[Description]]\n     * @param   {String} codeString a string; the function tries to\n     *                   identify an AI in the beginning of this string\n     * @returns {Object} if it succeeds in identifying an AI the\n     *                   ParsedElement is returned with, together with the\n     *                   still unparsed rest of codeString.\n     */\n    _identifyAI(codeString) {\n        // find first identifier. AIs have a minimum length of 2\n        // digits, some have 3, some even 4.\n        const firstNumber = codeString.slice(0, 1);\n        const secondNumber = codeString.slice(1, 2);\n        let parsedElementAndCode;\n        this.codeString = codeString;\n        /**\n         *\n         * ======= BEGIN of the big switch =======================\n         *\n         * and now a very big \"switch\", which tries to find a valid\n         * AI within the first digits of the codeString.\n         *\n         * See the documentation for an explanation why it is made\n         * this way (and not by some configuration file).\n         */\n        switch (firstNumber) {\n            case '0':\n                parsedElementAndCode = this._evaluateCodeStartWith0(secondNumber);\n                break;\n            case '1':\n                parsedElementAndCode = this._evaluateCodeStartWith1(secondNumber);\n                break;\n            case '2':\n                parsedElementAndCode = this._evaluateCodeStartWith2(secondNumber);\n                break;\n            case '3':\n                parsedElementAndCode = this._evaluateCodeStartWith3(secondNumber);\n                break;\n            case '4':\n                parsedElementAndCode = this._evaluateCodeStartWith4(secondNumber);\n                break;\n            // first digits 5 and 6 are not used\n            case '7':\n                parsedElementAndCode = this._evaluateCodeStartWith7(secondNumber);\n                break;\n            case '8':\n                parsedElementAndCode = this._evaluateCodeStartWith8(secondNumber);\n                break;\n            case '9':\n                parsedElementAndCode = this._evaluateCodeStartWith9(secondNumber);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.noValidAI);\n        }\n        /**\n         *\n         * ======= END of the big switch =======================\n         *\n         * now identifyAI has just to return the new\n         * ParsedElement (create by one of the parsing\n         * functions) and the (cleaned) rest of codeString.\n         */\n        return {\n            element: parsedElementAndCode.element,\n            codeString: this._cleanCodeString(parsedElementAndCode.codeString),\n        };\n    }\n    _evaluateCodeStartWith0(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // SSCC (Serial Shipping Container Code)\n                parsedElementAndCode = this._parseFixedLength('00', parsed_element_1.DataTitle.sscc, 18);\n                break;\n            case '1':\n                // Global Trade Item Number (GTIN)\n                parsedElementAndCode = this._parseFixedLength('01', parsed_element_1.DataTitle.gtin, 14);\n                break;\n            case '2':\n                // GTIN of Contained Trade Items\n                parsedElementAndCode = this._parseFixedLength('02', parsed_element_1.DataTitle.content, 14);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter0);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith1(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // Batch or Lot Number\n                parsedElementAndCode = this._parseVariableLength('10', parsed_element_1.DataTitle.batchLot, 20);\n                break;\n            case '1':\n                // Production Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('11', parsed_element_1.DataTitle.prodDate);\n                break;\n            case '2':\n                // Due Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('12', parsed_element_1.DataTitle.dueDate);\n                break;\n            case '3':\n                // Packaging Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('13', parsed_element_1.DataTitle.packDate);\n                break;\n            // AI \"14\" isn't defined\n            case '5':\n                // Best Before Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('15', parsed_element_1.DataTitle.bestBefore);\n                break;\n            case '6':\n                // Sell By Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('16', parsed_element_1.DataTitle.sellBy);\n                break;\n            case '7':\n                // Expiration Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('17', parsed_element_1.DataTitle.expiryDate);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter1);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith2(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // Variant Number\n                parsedElementAndCode = this._parseFixedLength('20', parsed_element_1.DataTitle.variant, 2);\n                break;\n            case '1':\n                // Serial Number\n                parsedElementAndCode = this._parseVariableLength('21', parsed_element_1.DataTitle.serial, 20);\n                break;\n            case '2':\n                // Consumer product variant\n                parsedElementAndCode = this._parseVariableLength('22', parsed_element_1.DataTitle.cpv, 20);\n                break;\n            // AI 23 is not defined\n            case '4':\n                // from now, the third number matters:\n                parsedElementAndCode = this._evaluateCodeStartWith24(this.codeString.slice(2, 3));\n                break;\n            case '5':\n                // from now, the third number matters:\n                parsedElementAndCode = this._evaluateCodeStartWith25(this.codeString.slice(2, 3));\n                break;\n            // AI \"26\" to \"29\" aren't defined\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter2);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith24(thirdNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Additional Item Identification\n                parsedElementAndCode = this._parseVariableLength('240', parsed_element_1.DataTitle.additionalId, 30);\n                break;\n            case '1':\n                // Customer Part Number\n                parsedElementAndCode = this._parseVariableLength('241', parsed_element_1.DataTitle.customPartNumber, 30);\n                break;\n            case '2':\n                // Made-to-Order Variation Number\n                parsedElementAndCode = this._parseVariableLength('242', parsed_element_1.DataTitle.mtoVariant, 6);\n                break;\n            case '3':\n                // Packaging Component Number\n                parsedElementAndCode = this._parseVariableLength('243', parsed_element_1.DataTitle.pcn, 20);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter24);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith25(thirdNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Secondary Serial Number\n                parsedElementAndCode = this._parseVariableLength('250', 'SECONDARY SERIAL', 30);\n                break;\n            case '1':\n                // Reference to Source Entity\n                parsedElementAndCode = this._parseVariableLength('251', 'REF. TO SOURCE', 30);\n                break;\n            // AI \"252\" isn't defined\n            case '3':\n                // Global Document Type Identifier (GDTI)\n                parsedElementAndCode = this._parseVariableLength('253', 'GDTI', typesLib.add(13, 17));\n                break;\n            case '4':\n                // GLN Extension Component\n                parsedElementAndCode = this._parseVariableLength('254', 'GLN EXTENSION COMPONENT', 20);\n                break;\n            case '5':\n                // Global Coupon Number (GCN)\n                parsedElementAndCode = this._parseVariableLength('255', 'GCN', typesLib.add(13, 12));\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter25);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith3(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // Count of Items (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseVariableLength('30', parsed_element_1.DataTitle.varCount, 8);\n                break;\n            case '1':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith31(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '2':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith32(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '3':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith33(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '4':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith34(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '5':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith35(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '6':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith36(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '7':\n                // Count of Trade Items\n                parsedElementAndCode = this._parseVariableLength('37', 'COUNT', 8);\n                break;\n            // AI \"38\" isn't defined\n            case '9':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith39(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter3);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith31(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Net weight, kilograms (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('310', fourthNumber, parsed_element_1.DataTitle.netWeight, parsed_element_1.UnitOfMeasure.KILOGRAM);\n                break;\n            case '1':\n            // 1 - Length or first dimension, metres (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '2':\n            // 2 - Width, diameter, or second dimension, metres (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '3':\n                // 3 - Depth, thickness, height, or third dimension, metres (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure(`31${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.METER);\n                break;\n            case '4':\n                // Area, square metres (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('314', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_METER);\n                break;\n            case '5':\n                // Net volume, litres (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('315', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.LITER);\n                break;\n            case '6':\n                // Net volume, cubic metres (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('316', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.CUBIC_METER);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter31);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith32(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Net weight, pounds (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('320', fourthNumber, parsed_element_1.DataTitle.netWeight, parsed_element_1.UnitOfMeasure.POUND);\n                break;\n            case '1':\n            // 1 - Length or first dimension, inches (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '4':\n            // 4 - Width, diameter, or second dimension, inches (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '7':\n                // 7 - Depth, thickness, height, or third dimension, inches (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure(`32${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.width, parsed_element_1.UnitOfMeasure.INCH);\n                break;\n            case '2':\n            // 2 - Length or first dimension, feet (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '5':\n            // 5 - Width, diameter, or second dimension, feet (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '8':\n                // 8 - Depth, thickness, height, or third dimension, feet (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure(`32${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.FOOT);\n                break;\n            case '3':\n            // 3 - Length or first dimension, yards (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '6':\n            // 6 - Width, diameter, or second dimension, yards (Variable Measure Trade Item\n            // eslint-disable-next-line no-fallthrough\n            case '9':\n                // 9 - Depth, thickness, height, or third dimension, yards (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure(`32${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.YARD);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter32);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith33(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Logistic weight, kilograms\n                parsedElementAndCode = this._parseFixedLengthMeasure('330', fourthNumber, parsed_element_1.DataTitle.grossWeight, parsed_element_1.UnitOfMeasure.KILOGRAM);\n                break;\n            case '1':\n                // Length or first dimension, metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('331', fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.METER);\n                break;\n            case '2':\n                // Width, diameter, or second dimension, metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('332', fourthNumber, parsed_element_1.DataTitle.width, parsed_element_1.UnitOfMeasure.METER);\n                break;\n            case '3':\n                // Depth, thickness, height, or third dimension, metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('333', fourthNumber, parsed_element_1.DataTitle.height, parsed_element_1.UnitOfMeasure.METER);\n                break;\n            case '4':\n                // Area, square metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('334', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_METER);\n                break;\n            case '5':\n                // Logistic volume, litres\n                parsedElementAndCode = this._parseFixedLengthMeasure('335', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.LITER);\n                break;\n            case '6':\n                // Logistic volume, cubic metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('336', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_METER);\n                break;\n            case '7':\n                // Kilograms per square metre, yes, the ISO code for this _is_ \"28\".\n                parsedElementAndCode = this._parseFixedLengthMeasure('337', fourthNumber, parsed_element_1.DataTitle.kgPerSquareMeter, parsed_element_1.UnitOfMeasure._28);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter33);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith34(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // 340 - Logistic weight, pounds\n                parsedElementAndCode = this._parseFixedLengthMeasure('340', fourthNumber, parsed_element_1.DataTitle.grossWeight, parsed_element_1.UnitOfMeasure.POUND);\n                break;\n            case '1':\n            // 341 - Length or first dimension, inches\n            // eslint-disable-next-line no-fallthrough\n            case '4':\n            // 344 - Width, diameter, or second dimension, inches\n            // eslint-disable-next-line no-fallthrough\n            case '7':\n                // 347 - Depth, thickness, height, or third dimension, inches\n                parsedElementAndCode = this._parseFixedLengthMeasure(`34${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.INCH);\n                break;\n            case '2':\n            // 342 - Length or first dimension, feet\n            // eslint-disable-next-line no-fallthrough\n            case '5':\n            // 345 - Width, diameter, or second dimension, feet\n            // eslint-disable-next-line no-fallthrough\n            case '8':\n                // 348 - Depth, thickness, height, or third dimension, feet\n                parsedElementAndCode = this._parseFixedLengthMeasure(`34${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.FOOT);\n                break;\n            case '3':\n            // 343 - Length or first dimension, yards\n            // eslint-disable-next-line no-fallthrough\n            case '6':\n            // 346 - Width, diameter, or second dimension, yard\n            // eslint-disable-next-line no-fallthrough\n            case '9':\n                // 349 - Depth, thickness, height, or third dimension, yards\n                parsedElementAndCode = this._parseFixedLengthMeasure(`34${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.YARD);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter34);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith35(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Area, square inches (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('350', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_INCH);\n                break;\n            case '1':\n                // Area, square feet (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('351', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_FOOT);\n                break;\n            case '2':\n                // Area, square yards (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('352', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_YARD);\n                break;\n            case '3':\n                // Area, square inches\n                parsedElementAndCode = this._parseFixedLengthMeasure('353', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_INCH);\n                break;\n            case '4':\n                // Area, square feet\n                parsedElementAndCode = this._parseFixedLengthMeasure('354', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_FOOT);\n                break;\n            case '5':\n                // Area, square yards\n                parsedElementAndCode = this._parseFixedLengthMeasure('355', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_YARD);\n                break;\n            case '6':\n                // Net weight, troy ounces (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('356', fourthNumber, parsed_element_1.DataTitle.netWeight, parsed_element_1.UnitOfMeasure.TROY_OUNCES);\n                break;\n            case '7':\n                // Net weight (or volume), ounces (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('357', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.OUNCE);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter35);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith36(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Net volume, quarts (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('360', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.QUART);\n                break;\n            case '1':\n                // Net volume, gallons U.S. (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('361', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.GALLON);\n                break;\n            case '2':\n                // Logistic volume, quarts\n                parsedElementAndCode = this._parseFixedLengthMeasure('362', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.QUART);\n                break;\n            case '3':\n                // Logistic volume, gallons U.S.\n                parsedElementAndCode = this._parseFixedLengthMeasure('363', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.GALLON);\n                break;\n            case '4':\n                // Net volume, cubic inches (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('364', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_INCH);\n                break;\n            case '5':\n                // Net volume, cubic feet (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('365', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_FOOT);\n                break;\n            case '6':\n                // Net volume, cubic yards (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('366', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_YARD);\n                break;\n            case '7':\n                // Logistic volume, cubic inches\n                parsedElementAndCode = this._parseFixedLengthMeasure('367', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_INCH);\n                break;\n            case '8':\n                // Logistic volume, cubic feet\n                parsedElementAndCode = this._parseFixedLengthMeasure('368', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_FOOT);\n                break;\n            case '9':\n                // Logistic volume, cubic yards\n                parsedElementAndCode = this._parseFixedLengthMeasure('369', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_YARD);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter36);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith39(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Applicable Amount Payable, local currency\n                parsedElementAndCode = this._parseVariableLengthMeasure('390', fourthNumber, parsed_element_1.DataTitle.amount, 15);\n                break;\n            case '1':\n                // Applicable Amount Payable with ISO Currency Code\n                parsedElementAndCode = this._parseVariableLengthWithISONumbers('391', fourthNumber, parsed_element_1.DataTitle.amount, 15);\n                break;\n            case '2':\n                // Applicable Amount Payable, single monetary area (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseVariableLengthMeasure('392', fourthNumber, parsed_element_1.DataTitle.price, 15);\n                break;\n            case '3':\n                // Applicable Amount Payable with ISO Currency Code (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseVariableLengthWithISONumbers('393', fourthNumber, parsed_element_1.DataTitle.price, 15);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter39);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith4(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // third number matters:\n                parsedElementAndCode = this._evaluateCodeStartWith40(this.codeString.slice(2, 3));\n                break;\n            case '1':\n                // third number matters:\n                parsedElementAndCode = this._evaluateCodeStartWith41(this.codeString.slice(2, 3));\n                break;\n            case '2':\n                // third number matters:\n                parsedElementAndCode = this._evaluateCodeStartWith42(this.codeString.slice(2, 3));\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter4);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith40(thirdNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Customer's Purchase Order Number\n                parsedElementAndCode = this._parseVariableLength('400', parsed_element_1.DataTitle.orderNumber, 30);\n                break;\n            case '1':\n                // Global Identification Number for Consignment (GINC)\n                parsedElementAndCode = this._parseVariableLength('401', parsed_element_1.DataTitle.ginc, 30);\n                break;\n            case '2':\n                // Global Shipment Identification Number (GSIN)\n                parsedElementAndCode = this._parseVariableLength('402', parsed_element_1.DataTitle.gsin, 17); // should be 17 digits long\n                break;\n            case '3':\n                // Routing Code\n                parsedElementAndCode = this._parseVariableLength('403', parsed_element_1.DataTitle.route, 30);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter40);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith41(thirdNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Ship to - Deliver to Global Location Number\n                parsedElementAndCode = this._parseFixedLength('410', parsed_element_1.DataTitle.shipToLoc, 13);\n                break;\n            case '1':\n                // Bill to - Invoice to Global Location Number\n                parsedElementAndCode = this._parseFixedLength('411', parsed_element_1.DataTitle.billTo, 13);\n                break;\n            case '2':\n                // Purchased from Global Location Number\n                parsedElementAndCode = this._parseFixedLength('412', parsed_element_1.DataTitle.purchaseFrom, 13);\n                break;\n            case '3':\n                // Ship for - Deliver for - Forward to Global Location Number\n                parsedElementAndCode = this._parseFixedLength('413', parsed_element_1.DataTitle.shipForLoc, 13);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter41);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith42(thirdNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Ship to - Deliver to Postal Code Within a Single Postal Authority\n                parsedElementAndCode = this._parseVariableLength('420', parsed_element_1.DataTitle.shipToPost, 20);\n                break;\n            case '1':\n                // Ship to - Deliver to Postal Code with ISO Country Code\n                parsedElementAndCode = this._parseVariableLengthWithISOChars('421', parsed_element_1.DataTitle.shipToPost, 9);\n                break;\n            case '2':\n                // Country of Origin of a Trade Item\n                parsedElementAndCode = this._parseFixedLength('422', parsed_element_1.DataTitle.origin, 3);\n                break;\n            case '3':\n                // Country of Initial Processing\n                // Up to 5 3-digit ISO-countryCodes\n                parsedElementAndCode = this._parseVariableLength('423', parsed_element_1.DataTitle.countryInitialProcess, typesLib.add(3, 12));\n                break;\n            case '4':\n                // Country of Processing\n                parsedElementAndCode = this._parseFixedLength('424', parsed_element_1.DataTitle.countryProcess, 3);\n                break;\n            case '5':\n                // Country of Disassembly\n                parsedElementAndCode = this._parseFixedLength('425', parsed_element_1.DataTitle.countryDisassembly, 3);\n                break;\n            case '6':\n                // Country Covering full Process Chain\n                parsedElementAndCode = this._parseFixedLength('426', parsed_element_1.DataTitle.countryFullProcess, 3);\n                break;\n            case '7':\n                // Country Subdivision of Origin\n                parsedElementAndCode = this._parseVariableLength('427', parsed_element_1.DataTitle.countrySubdivision, 3);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter42);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith7(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // third and fourth number matter:\n                parsedElementAndCode = this._evaluateCodeStartWith70(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '1':\n                parsedElementAndCode = this._evaluateCodeStartWith71(this.codeString.slice(2, 3));\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter7);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith70(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                parsedElementAndCode = this._evaluateCodeStartWith700(fourthNumber);\n                break;\n            // 1 and 2 are not used\n            case '3':\n                // Approval Number of Processor with ISO Country Code\n                // Title and stem for parsing are build from 4th number:\n                parsedElementAndCode = this._parseVariableLengthWithISOChars(`703${fourthNumber}`, `PROCESSOR # ${fourthNumber}`, 27);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter70);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith700(fourthNumber) {\n        let parsedElementAndCode;\n        switch (fourthNumber) {\n            case '1':\n                // NATO Stock Number (NSN)\n                parsedElementAndCode = this._parseVariableLength('7001', parsed_element_1.DataTitle.nsn, 13); // should be 13 digits long\n                break;\n            case '2':\n                // UN/ECE Meat Carcasses and Cuts Classification\n                parsedElementAndCode = this._parseVariableLength('7002', parsed_element_1.DataTitle.meatCut, 30);\n                break;\n            case '3':\n                // Expiration Date and Time\n                parsedElementAndCode = this._parseVariableLength('7003', parsed_element_1.DataTitle.expiryTime, 10); // should be 10 digits long\n                break;\n            case '4':\n                // Active Potency\n                parsedElementAndCode = this._parseVariableLength('7004', parsed_element_1.DataTitle.activePotency, 4);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter700);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith71(thirdNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // National Healthcare Reimbursement Number (NHRN) – Germany PZN\n                parsedElementAndCode = this._parseVariableLength('710', 'NHRN PZN', 20);\n                break;\n            case '1':\n                // National Healthcare Reimbursement Number (NHRN) – France CIP\n                parsedElementAndCode = this._parseVariableLength('711', 'NHRN CIP', 20);\n                break;\n            case '2':\n                // National Healthcare Reimbursement Number (NHRN) – Spain CN\n                parsedElementAndCode = this._parseVariableLength('712', 'NHRN CN', 20);\n                break;\n            case '3':\n                // National Healthcare Reimbursement Number (NHRN) – Brasil DRN\n                parsedElementAndCode = this._parseVariableLength('713', 'NHRN DRN', 20);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter71);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith8(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                parsedElementAndCode = this._evaluateCodeStartWith80(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '1':\n                parsedElementAndCode = this._evaluateCodeStartWith81(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '2':\n                parsedElementAndCode = this._evaluateCodeStartWith82(this.codeString.slice(2, 3));\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter8);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith80(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                parsedElementAndCode = this._evaluateCodeStartWith800(fourthNumber);\n                break;\n            case '1':\n                parsedElementAndCode = this._evaluateCodeStartWith801(fourthNumber);\n                break;\n            case '2':\n                parsedElementAndCode = this._evaluateCodeStartWith802(fourthNumber);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter80);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith800(fourthNumber) {\n        let parsedElementAndCode;\n        switch (fourthNumber) {\n            case '1':\n                // Roll Products (Width, Length, Core Diameter, Direction, Splices)\n                parsedElementAndCode = this._parseVariableLength('8001', 'DIMENSIONS', 14); // should be 14 digits long\n                break;\n            case '2':\n                // Cellular Mobile Telephone Identifier\n                parsedElementAndCode = this._parseVariableLength('8002', 'CMT No', 20);\n                break;\n            case '3':\n                // Global Returnable Asset Identifier (GRAI)\n                parsedElementAndCode = this._parseVariableLength('8003', 'GRAI', typesLib.add(14, 16)); // should contain at least 14 digits\n                break;\n            case '4':\n                // Global Individual Asset Identifier (GIAI)\n                parsedElementAndCode = this._parseVariableLength('8004', 'GIAI', 30);\n                break;\n            case '5':\n                // Price Per Unit of Measure\n                parsedElementAndCode = this._parseVariableLength('8005', 'PRICE PER UNIT', 6); // should be 6 digits long\n                break;\n            case '6':\n                // Identification of the Components of a Trade Item\n                parsedElementAndCode = this._parseVariableLength('8006', 'GCTIN', typesLib.add(typesLib.add(14, 2), 2)); // should be exactly 18 digits long\n                break;\n            case '7':\n                // International Bank Account Number (IBAN)\n                parsedElementAndCode = this._parseVariableLength('8007', 'IBAN', 34);\n                break;\n            case '8':\n                // Date and Time of Production\n                parsedElementAndCode = this._parseVariableLength('8008', 'PROD TIME', typesLib.add(8, 4)); // should be exactly 12 digits long\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter800);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith801(fourthNumber) {\n        let parsedElementAndCode;\n        switch (fourthNumber) {\n            case '0':\n                // Component / Part Identifier (CPID)\n                parsedElementAndCode = this._parseVariableLength('8010', 'CPID', 30);\n                break;\n            case '1':\n                // Component / Part Identifier Serial Number (CPID SERIAL)\n                parsedElementAndCode = this._parseVariableLength('8011', 'CPID SERIAL', 12);\n                break;\n            case '7':\n                // Global Service Relation Number to identify the relationship between an organisation offering services and the provider of services\n                parsedElementAndCode = this._parseVariableLength('8017', 'GSRN - PROVIDER', 18); // should be 18 digits long\n                break;\n            case '8':\n                // Global Service Relation Number to identify the relationship between an organization offering services and the recipient of services\n                parsedElementAndCode = this._parseVariableLength('8018', 'GSRN - RECIPIENT', 18); // should be 18 digits long\n                break;\n            case '9':\n                // Service Relation Instance Number (SRIN)\n                parsedElementAndCode = this._parseVariableLength('8019', 'SRIN', 10);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter801);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith802(fourthNumber) {\n        let parsedElementAndCode;\n        if (typesLib.strictEq(fourthNumber, '0')) {\n            // Payment Slip Reference Number\n            parsedElementAndCode = this._parseVariableLength('8020', 'REF No', 25);\n        }\n        else {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter802);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith81(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                parsedElementAndCode = this._evaluateCodeStartWith810(fourthNumber);\n                break;\n            case '1':\n                parsedElementAndCode = this._evaluateCodeStartWith811(fourthNumber);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter81);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith810(fourthNumber) {\n        let parsedElementAndCode;\n        switch (fourthNumber) {\n            case '0':\n                // GS1-128 Coupon Extended Code\n                parsedElementAndCode = this._parseVariableLength('8100', '-', 6); // should be 6 digits long\n                break;\n            case '1':\n                // GS1-128 Coupon Extended Code\n                parsedElementAndCode = this._parseVariableLength('8101', '-', 10); // should be 10 digits long\n                break;\n            case '2':\n                // GS1-128 Coupon Extended Code\n                parsedElementAndCode = this._parseVariableLength('8102', '-', 2); // should be 2 digits long\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter810);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith811(fourthNumber) {\n        let parsedElementAndCode;\n        if (typesLib.strictEq(fourthNumber, '0')) {\n            // Coupon Code Identification for Use in North America\n            parsedElementAndCode = this._parseVariableLength('8110', '-', 70);\n        }\n        else {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter811);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith82(thirdNumber) {\n        let parsedElementAndCode;\n        if (typesLib.strictEq(thirdNumber, '0')) {\n            // Extended Packaging URL\n            parsedElementAndCode = this._parseVariableLength('8200', 'PRODUCT URL', 70);\n        }\n        else {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter82);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith9(secondNumber) {\n        let parsedElementAndCode;\n        if (typesLib.strictEq(secondNumber, '0')) {\n            // Information Mutually Agreed Between Trading Partners\n            parsedElementAndCode = this._parseVariableLength('90', 'INTERNAL', 30);\n        }\n        else if (typesLib.gte(secondNumber, '1') && typesLib.lte(secondNumber, '9')) {\n            // Company Internal Information\n            parsedElementAndCode = this._parseVariableLength(`9${secondNumber}`, 'INTERNAL', 90);\n        }\n        else {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter9);\n        }\n        return parsedElementAndCode;\n    }\n    /**\n     *\n     * =========== END of identifyAI =======================\n     *\n     */\n    /**\n     * ============ auxiliary functions for identifyAI =============\n     */\n    /**\n     * some data items are followed by an ParsedElementAndCode  even in case of\n     * fixed length, so the codeStringToReturn may have\n     * leading FNCs.\n     *\n     * This function eliminates these leading FNCs.\n     *\n     * @param   {String} stringToClean string which has to be cleaned\n     * @returns {String} the cleaned string\n     */\n    _cleanCodeString(stringToClean) {\n        //\n        let firstChar = stringToClean.slice(0, 1);\n        let currentStringToClean = stringToClean;\n        while (typesLib.strictEq(firstChar, this.fncChar)) {\n            currentStringToClean = currentStringToClean.slice(1, currentStringToClean.length);\n            firstChar = currentStringToClean.slice(0, 1);\n        }\n        return currentStringToClean;\n    }\n    /**\n     * Used for calculating numbers which are given as string\n     * with a given number of fractional decimals.\n     *\n     * To avoid conversion errors binary decimal I _don't_\n     * just divide by 10 numberOfFractionals times.\n     *\n     * Parse a string with given fractional to float\n     * @param {string} stringToParse\n     * @param {number} numberOfFractionals\n     * @returns {number} value\n     */\n    static _parseFloatingPoint(stringToParse, numberOfFractionals) {\n        let auxFloat = typesLib.newDecimal(\"0.0\");\n        try {\n            const offset = typesLib.sub(stringToParse.length, numberOfFractionals);\n            const auxString = `${stringToParse.slice(0, offset)}.${stringToParse.slice(offset, stringToParse.length)}`;\n            auxFloat = parseFloat(auxString);\n        }\n        catch (e) {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidNumber);\n        }\n        return auxFloat;\n    }\n    /**\n     * ======== END of auxiliary function for identifyAI =======\n     */\n    /**\n     *\n     * ======== BEGIN of parsing privates in identifyAI =======\n     *\n     * Some privates to parse the various GS1 formats. They\n     * create a new ParsedElement and set its properties.\n     *\n     * They all modify the variables \"elementToReturn\" and\n     * \"codeStringToReturn\".\n     */\n    /**\n     * dates in GS1-elements have the format \"YYMMDD\".\n     * This private generates a new ParsedElement and tries to fill a\n     * JS-date into the \"data\"-part.\n     * @param {String} ai    the AI to use for the ParsedElement\n     * @param {String} title the title to use for the ParsedElement\n     */\n    _parseDate(ai, title) {\n        const elementParsed = new parsed_element_1.ParsedElement(ai, title, parsed_element_1.ElementTypeEnum.date);\n        const offSet = ai.length;\n        const dateYYMMDD = this.codeString.slice(offSet, typesLib.add(offSet, 6));\n        if (typesLib.strictNe(dateYYMMDD.length, 6)) {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidDateSizeInParse);\n        }\n        elementParsed.data = xtrem_date_time_1.date.parse(dateYYMMDD, undefined, 'YYMMDD');\n        const codeStringToReturn = this.codeString.slice(typesLib.add(offSet, 6), this.codeStringLength);\n        return { element: elementParsed, codeString: codeStringToReturn };\n    }\n    /**\n     * simple: the element has a fixed length AND is not followed by an FNC1.\n     * @param {String} ai     the AI to use\n     * @param {String} title  its title, i.e. its short description\n     * @param {Number} length the fixed length\n     */\n    _parseFixedLength(ai, title, length) {\n        const elementParsed = new parsed_element_1.ParsedElement(ai, title, parsed_element_1.ElementTypeEnum.string);\n        const offSet = ai.length;\n        elementParsed.data = this.codeString.slice(offSet, typesLib.add(length, offSet));\n        const codeStringToReturn = this.codeString.slice(typesLib.add(length, offSet), this.codeStringLength);\n        if (typesLib.strictNe(elementParsed.data.length, length)) {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidFixedSizeInParse);\n        }\n        return { element: elementParsed, codeString: codeStringToReturn };\n    }\n    /**\n     * tries to parse an element of variable length\n     * some fixed length AIs are terminated by FNC1, so this private\n     * is used even for fixed length items\n     * @param {String} ai           the AI to use\n     * @param {String} title        its title, i.e. its short description\n     * @param {number} maxLength    maximum data size allowed or 0\n     * @return parsed element\n     */\n    _parseVariableLength(ai, title, maxLength = 0) {\n        //\n        const elementParsed = new parsed_element_1.ParsedElement(ai, title, parsed_element_1.ElementTypeEnum.string);\n        const offSet = ai.length;\n        const posOfFNC = this.codeString.indexOf(this.fncChar);\n        const codeStringLength = this.codeString.length;\n        let codeStringToReturn = '';\n        if (typesLib.strictEq(posOfFNC, -1)) {\n            // we've got the last element of the barcode\n            elementParsed.data = this.codeString.slice(offSet, codeStringLength);\n        }\n        else {\n            elementParsed.data = this.codeString.slice(offSet, posOfFNC);\n            codeStringToReturn = this.codeString.slice(typesLib.add(posOfFNC, 1), codeStringLength);\n        }\n        if (maxLength && typesLib.gt(elementParsed.data.length, maxLength)) {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidVariableSizeInParse);\n        }\n        return { element: elementParsed, codeString: codeStringToReturn };\n    }\n    /**\n     * the place of the decimal fraction is given by the fourth number, that's\n     * the first after the identifier itself.\n     *\n     * All of theses elements have a length of 6 characters.\n     * @param {String} aiStem       the first digits of the AI, _not_ the fourth digit\n     * @param {Number} currentFourthNumber the 4th number indicating the count of valid fractionals\n     * @param {String} title        the title of the AI\n     * @param {String} unit         often these elements have an implicit unit of measurement\n     */\n    _parseFixedLengthMeasure(aiStem, currentFourthNumber, title, unit) {\n        //\n        const elementParsed = new parsed_element_1.ParsedElement(typesLib.add(aiStem, currentFourthNumber), title, parsed_element_1.ElementTypeEnum.number);\n        const offSet = typesLib.add(aiStem.length, 1);\n        const numberOfDecimals = parseInt(currentFourthNumber, 10);\n        const numberPart = this.codeString.slice(offSet, typesLib.add(offSet, 6));\n        elementParsed.data = ParseBarCode._parseFloatingPoint(numberPart, numberOfDecimals);\n        elementParsed.unit = unit;\n        const codeStringToReturn = this.codeString.slice(typesLib.add(offSet, 6), this.codeString.length);\n        if (typesLib.strictNe(elementParsed.data, 6)) {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidFixedSizeMeasureInParse);\n        }\n        return { element: elementParsed, codeString: codeStringToReturn };\n    }\n    /**\n     * parses data elements of variable length, which additionally have\n     *\n     * - an indicator for the number of valid decimals\n     * - an implicit unit of measurement\n     *\n     * These data elements contain e.g. a weight or length.\n     *\n     */\n    _parseVariableLengthMeasure(aiStem, currentFourthNumber, title, maxLength = 0, unit) {\n        // the place of the decimal fraction is given by the fourth number, that's\n        // the first after the identifier itself.\n        const elementParsed = new parsed_element_1.ParsedElement(typesLib.add(aiStem, currentFourthNumber), title, parsed_element_1.ElementTypeEnum.number);\n        const offSet = typesLib.add(aiStem.length, 1);\n        const posOfFNC = this.codeString.indexOf(this.fncChar);\n        const numberOfDecimals = parseInt(currentFourthNumber, 10);\n        let codeStringToReturn = '';\n        let numberPart = '';\n        if (typesLib.strictEq(posOfFNC, -1)) {\n            numberPart = this.codeString.slice(offSet, this.codeStringLength);\n        }\n        else {\n            numberPart = this.codeString.slice(offSet, posOfFNC);\n            codeStringToReturn = this.codeString.slice(typesLib.add(posOfFNC, 1), this.codeStringLength);\n        }\n        if (maxLength && typesLib.gt(numberPart.length, maxLength)) {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidVariableSizeMeasureInParse);\n        }\n        // adjust decimals according to fourthNumber:\n        elementParsed.data = ParseBarCode._parseFloatingPoint(numberPart, numberOfDecimals);\n        elementParsed.unit = unit;\n        return { element: elementParsed, codeString: codeStringToReturn };\n    }\n    /**\n     * parses data elements of variable length, which additionally have\n     *\n     * - an indicator for the number of valid decimals\n     * - an explicit unit of measurement\n     *\n     * These data element contain amounts to pay or prices.\n     *\n     */\n    _parseVariableLengthWithISONumbers(aiStem, currentFourthNumber, title, maxLength = 0) {\n        // an element of variable length, representing a number, followed by\n        // some ISO-code.\n        const elementParsed = new parsed_element_1.ParsedElement(typesLib.add(aiStem, currentFourthNumber), title, parsed_element_1.ElementTypeEnum.number);\n        const offSet = typesLib.add(aiStem.length, 1);\n        const posOfFNC = this.codeString.indexOf(this.fncChar);\n        const numberOfDecimals = parseInt(currentFourthNumber, 10);\n        let codeStringToReturn = '';\n        let isoPlusNumbers = '';\n        let numberPart = '';\n        if (typesLib.strictEq(posOfFNC, -1)) {\n            isoPlusNumbers = this.codeString.slice(offSet, this.codeStringLength);\n        }\n        else {\n            isoPlusNumbers = this.codeString.slice(offSet, posOfFNC);\n            codeStringToReturn = this.codeString.slice(typesLib.add(posOfFNC, 1), this.codeStringLength);\n        }\n        // cut off ISO-Code\n        numberPart = isoPlusNumbers.slice(3, isoPlusNumbers.length);\n        elementParsed.data = ParseBarCode._parseFloatingPoint(numberPart, numberOfDecimals);\n        elementParsed.unit = isoPlusNumbers.slice(0, 3);\n        if (maxLength && typesLib.gt(isoPlusNumbers.length, maxLength)) {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidVariableSizeWithISONumbersInParse);\n        }\n        return { element: elementParsed, codeString: codeStringToReturn };\n    }\n    /**\n     * parses data elements of variable length, which additionally have\n     *\n     * - an explicit unit of measurement or reference\n     *\n     * These data element contain countries, authorities within countries.\n     *\n     */\n    _parseVariableLengthWithISOChars(aiStem, title, maxLength = 0) {\n        // an element of variable length, representing a sequence of chars, followed by\n        // some ISO-code.\n        const elementParsed = new parsed_element_1.ParsedElement(aiStem, title, parsed_element_1.ElementTypeEnum.string);\n        const offSet = aiStem.length;\n        const posOfFNC = this.codeString.indexOf(this.fncChar);\n        let codeStringToReturn = '';\n        let isoPlusNumbers = '';\n        if (typesLib.strictEq(posOfFNC, -1)) {\n            isoPlusNumbers = this.codeString.slice(offSet, this.codeStringLength);\n        }\n        else {\n            isoPlusNumbers = this.codeString.slice(offSet, posOfFNC);\n            codeStringToReturn = this.codeString.slice(typesLib.add(posOfFNC, 1), this.codeStringLength);\n        }\n        // cut off ISO-Code\n        elementParsed.data = isoPlusNumbers.slice(3, isoPlusNumbers.length);\n        elementParsed.unit = isoPlusNumbers.slice(0, 3);\n        if (maxLength && typesLib.gt(elementParsed.data.length, maxLength)) {\n            throw new xtrem_shared_1.SystemError(ErrorMessages.invalidVariableSizeWithISOCharsInParse);\n        }\n        return { element: elementParsed, codeString: codeStringToReturn };\n    }\n}\nexports.ParseBarCode = ParseBarCode;\n/**\n * Function only for using class\n * @param barcode bar code to translate\n * @returns translated value(s)\n */\nfunction parseBarcode(barcode) {\n    const parseBarCode = new ParseBarCode();\n    return parseBarCode.parseBarcode(barcode);\n}\nexports.parseBarcode = parseBarcode;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/shared-functions/barcode-parser.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/shared-functions/parsed-element.ts":
/*!*********************************************************************!*\
  !*** ../../shared/x3-system/lib/shared-functions/parsed-element.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ParsedElement = exports.UnitOfMeasure = exports.DataTitle = exports.ElementTypeEnum = void 0;\nvar ElementTypeEnum;\n(function (ElementTypeEnum) {\n    ElementTypeEnum[\"string\"] = \"string\";\n    ElementTypeEnum[\"number\"] = \"number\";\n    ElementTypeEnum[\"date\"] = \"date\";\n})(ElementTypeEnum || (exports.ElementTypeEnum = ElementTypeEnum = {}));\nvar DataTitle;\n(function (DataTitle) {\n    // Applicable Amount Payable\n    DataTitle[\"amount\"] = \"AMOUNT\";\n    DataTitle[\"price\"] = \"PRICE\";\n    // Production Date (YYMMDD)\n    DataTitle[\"prodDate\"] = \"PROD DATE\";\n    // Batch or Lot Number\n    DataTitle[\"batchLot\"] = \"BATCH/LOT\";\n    // Due Date (YYMMDD)\n    DataTitle[\"dueDate\"] = \"DUE DATE\";\n    // Packaging Date (YYMMDD)\n    DataTitle[\"packDate\"] = \"PACK DATE\";\n    // Best Before Date (YYMMDD)\n    DataTitle[\"bestBefore\"] = \"BEST BEFORE or BEST BY\";\n    // Expiration Date (YYMMDD)\n    DataTitle[\"expiryDate\"] = \"USE BY OR EXPIRY\";\n    // Sell By Date (YYMMDD)\n    DataTitle[\"sellBy\"] = \"SELL BY\";\n    // SSCC (Serial Shipping Container Code)\n    DataTitle[\"sscc\"] = \"SSCC\";\n    // Global Trade Item Number (GTIN)\n    DataTitle[\"gtin\"] = \"GTIN\";\n    // Global Identification Number for Consignment (GINC)\n    DataTitle[\"ginc\"] = \"GINC\";\n    // Global Shipment Identification Number (GSIN)\n    DataTitle[\"gsin\"] = \"GSIN\";\n    // GTIN of Contained Trade Items\n    DataTitle[\"content\"] = \"CONTENT\";\n    // Variant Number\n    DataTitle[\"variant\"] = \"VARIANT\";\n    // Serial Number\n    DataTitle[\"serial\"] = \"SERIAL\";\n    // Consumer product variant\n    DataTitle[\"cpv\"] = \"CPV\";\n    // Additional Item Identification\n    DataTitle[\"additionalId\"] = \"ADDITIONAL ID\";\n    // Customer Part Number\n    DataTitle[\"customPartNumber\"] = \"CUST. PART NO.\";\n    // Made-to-Order Variation Number\n    DataTitle[\"mtoVariant\"] = \"MTO VARIAN\";\n    // Made-to-Order Variation Number\n    DataTitle[\"pcn\"] = \"PCN\";\n    // Count of Items (Variable Measure Trade Item)\n    DataTitle[\"varCount\"] = \"VAR. COUNT\";\n    // Customer's Purchase Order Number\n    DataTitle[\"orderNumber\"] = \"ORDER NUMBER\";\n    // Routing code\n    DataTitle[\"route\"] = \"ROUTE\";\n    // Ship to - Deliver to Global Location Number\n    DataTitle[\"shipToLoc\"] = \"SHIP TO LOC\";\n    // Bill to - Invoice to Global Location Number\n    DataTitle[\"billTo\"] = \"BILL TO\";\n    // Purchased from Global Location Number\n    DataTitle[\"purchaseFrom\"] = \"PURCHASE FROM\";\n    // Ship for - Deliver for - Forward to Global Location Number\n    DataTitle[\"shipForLoc\"] = \"SHIP FOR LOC\";\n    // Ship to - Deliver to Postal Code Within a Single Postal Authority\n    DataTitle[\"shipToPost\"] = \"SHIP TO POST\";\n    // Country of Origin of a Trade Item\n    DataTitle[\"origin\"] = \"ORIGIN\";\n    // Country of Initial Processing\n    // Up to 5 3-digit ISO-countrycodes\n    DataTitle[\"countryInitialProcess\"] = \"COUNTRY - INITIAL PROCESS.\";\n    // Country of Processing\n    DataTitle[\"countryProcess\"] = \"COUNTRY - PROCESS.\";\n    // Country of disassembly\n    DataTitle[\"countryDisassembly\"] = \"COUNTRY - DISASSEMBLY\";\n    // Country Covering full Process Chain\n    DataTitle[\"countryFullProcess\"] = \"COUNTRY - FULL PROCESS\";\n    // Country subdivision of origin\n    DataTitle[\"countrySubdivision\"] = \"ORIGIN SUBDIVISION\";\n    // NATO Stock Number (NSN)\n    DataTitle[\"nsn\"] = \"NSN\";\n    // UN/ECE Meat Carcasses and Cuts Classification\n    DataTitle[\"meatCut\"] = \"MEAT CUT\";\n    // Expiration Date and Time\n    DataTitle[\"expiryTime\"] = \"EXPIRY TIME\";\n    // Active Potency\n    DataTitle[\"activePotency\"] = \"ACTIVE POTENCY\";\n    // Net weight (Variable Measure Trade Item)\n    DataTitle[\"netWeight\"] = \"NET WEIGHT\";\n    // Net weight (Variable Measure Trade Item)\n    DataTitle[\"grossWeight\"] = \"GROSS WEIGHT\";\n    // Length or first dimension (Variable Measure Trade Item)\n    DataTitle[\"length\"] = \"LENGTH\";\n    // Width, diameter, or second dimension (Variable Measure Trade Item)\n    DataTitle[\"width\"] = \"WIDTH\";\n    // Depth, thickness, height, or third dimension (Variable Measure Trade Item)\n    DataTitle[\"height\"] = \"HEIGHT\";\n    // Area (Variable Measure Trade Item)\n    DataTitle[\"area\"] = \"AREA\";\n    DataTitle[\"netVolume\"] = \"NET VOLUME\";\n    DataTitle[\"volume\"] = \"VOLUME\";\n    DataTitle[\"kgPerSquareMeter\"] = \"KG PER SQUARE METER\";\n})(DataTitle || (exports.DataTitle = DataTitle = {}));\nvar UnitOfMeasure;\n(function (UnitOfMeasure) {\n    UnitOfMeasure[\"EACH\"] = \"EACH\";\n    UnitOfMeasure[\"MILLIMETER\"] = \"MILLIMETER\";\n    UnitOfMeasure[\"CENTIMETER\"] = \"CENTIMETER\";\n    UnitOfMeasure[\"METER\"] = \"METER\";\n    UnitOfMeasure[\"KILOMETER\"] = \"KILOMETER\";\n    UnitOfMeasure[\"INCH\"] = \"INCH\";\n    UnitOfMeasure[\"FOOT\"] = \"FOOT\";\n    UnitOfMeasure[\"YARD\"] = \"YARD\";\n    UnitOfMeasure[\"MILE\"] = \"MILE\";\n    UnitOfMeasure[\"MILLILITER\"] = \"MILLILITER\";\n    UnitOfMeasure[\"LITER\"] = \"LITER\";\n    UnitOfMeasure[\"CUBIC_METER\"] = \"CUBIC_METER\";\n    UnitOfMeasure[\"FLUID_OUNCE\"] = \"FLUID_OUNCE\";\n    UnitOfMeasure[\"CUP\"] = \"CUP\";\n    UnitOfMeasure[\"PINT\"] = \"PINT\";\n    UnitOfMeasure[\"QUART\"] = \"QUART\";\n    UnitOfMeasure[\"GALLON\"] = \"GALLON\";\n    UnitOfMeasure[\"CUBIC_INCH\"] = \"CUBIC_INCH\";\n    UnitOfMeasure[\"CUBIC_FOOT\"] = \"CUBIC_FOOT\";\n    UnitOfMeasure[\"CUBIC_YARD\"] = \"CUBIC_YARD\";\n    UnitOfMeasure[\"GRAM\"] = \"GRAM\";\n    UnitOfMeasure[\"KILOGRAM\"] = \"KILOGRAM\";\n    UnitOfMeasure[\"METRIC_TON\"] = \"METRIC_TON\";\n    UnitOfMeasure[\"OUNCE\"] = \"OUNCE\";\n    UnitOfMeasure[\"POUND\"] = \"POUND\";\n    UnitOfMeasure[\"STONE\"] = \"STONE\";\n    UnitOfMeasure[\"HUNDREDWEIGHT\"] = \"HUNDREDWEIGHT\";\n    UnitOfMeasure[\"SHORT_TON\"] = \"SHORT_TON\";\n    UnitOfMeasure[\"SECOND\"] = \"SECOND\";\n    UnitOfMeasure[\"MINUTE\"] = \"MINUTE\";\n    UnitOfMeasure[\"HOUR\"] = \"HOUR\";\n    UnitOfMeasure[\"DAY\"] = \"DAY\";\n    UnitOfMeasure[\"SQUARE_MILLIMETER\"] = \"SQUARE_MILLIMETER\";\n    UnitOfMeasure[\"SQUARE_CENTIMETER\"] = \"SQUARE_CENTIMETER\";\n    UnitOfMeasure[\"SQUARE_METER\"] = \"SQUARE_METER\";\n    UnitOfMeasure[\"SQUARE_INCH\"] = \"SQUARE_INCH\";\n    UnitOfMeasure[\"SQUARE_FOOT\"] = \"SQUARE_FOOT\";\n    UnitOfMeasure[\"SQUARE_YARD\"] = \"SQUARE_YARD\";\n    UnitOfMeasure[\"TROY_OUNCES\"] = \"TROY_OUNCES\";\n    // Kilograms per square metre, yes, the ISO code for this _is_ \"28\".\n    UnitOfMeasure[\"_28\"] = \"28\";\n})(UnitOfMeasure || (exports.UnitOfMeasure = UnitOfMeasure = {}));\nclass ParsedElement {\n    constructor(ai, elementDataTitle, elementType) {\n        this.ai = ai;\n        this.elementDataTitle = elementDataTitle;\n        this.elementType = elementType;\n        /* defines the object which represents a single element\n         */\n        switch (elementType) {\n            case ElementTypeEnum.string:\n                this._data = '';\n                break;\n            case ElementTypeEnum.number:\n                this._data = 0;\n                break;\n            case ElementTypeEnum.date:\n                this._data = '';\n                break;\n            default:\n                this._data = '';\n                break;\n        }\n        this.unit = undefined; // some elements are accompanied by an unit of\n    }\n    set unit(unit) {\n        this._unit = unit;\n    }\n    get unit() {\n        return this._unit;\n    }\n    set data(data) {\n        this._data = data;\n    }\n    get data() {\n        return this._data;\n    }\n}\nexports.ParsedElement = ParsedElement;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/shared-functions/parsed-element.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/build/lib/menu-items/receipt.js":
/*!******************************************************************!*\
  !*** ../../shared/x3-stock-data/build/lib/menu-items/receipt.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.receipt = void 0;\nexports.receipt = {\n    id: '@sage/x3-stock-data/receipt-root',\n    priority: 100,\n    title: 'Receipt',\n    icon: 'document_right_align',\n};\n//# sourceMappingURL=receipt.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvcmVjZWlwdC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxlQUFlO0FBQ2YsZUFBZTtBQUNmO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL3h0cmVtQXJ0aWZhY3QvLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvcmVjZWlwdC5qcz8wNzc1Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5yZWNlaXB0ID0gdm9pZCAwO1xuZXhwb3J0cy5yZWNlaXB0ID0ge1xuICAgIGlkOiAnQHNhZ2UveDMtc3RvY2stZGF0YS9yZWNlaXB0LXJvb3QnLFxuICAgIHByaW9yaXR5OiAxMDAsXG4gICAgdGl0bGU6ICdSZWNlaXB0JyxcbiAgICBpY29uOiAnZG9jdW1lbnRfcmlnaHRfYWxpZ24nLFxufTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXJlY2VpcHQuanMubWFwIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/build/lib/menu-items/receipt.js\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-date-time":
/*!****************************************!*\
  !*** external "@sage/xtrem-date-time" ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-date-time");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-purchase-receipt.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;