/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/purchase-receipt-details-control.ts":
/*!******************************************************************!*\
  !*** ./lib/client-functions/purchase-receipt-details-control.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.PurchaseReceiptDetailsRecordManager = exports.controlLotReceipt = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst xtrem_ui_1 = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function validate(page) {\n    // (X3-201046, X3-203885) TODO Issue: Have better validation error messages that specifically tell which fields have issues\n    const errors = await page.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    page.$.showToast(`${(0, xtrem_ui_1.localize)('@sage/x3-purchasing/dialog-error-title', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validate = validate;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock-data/StockJournal')\n        .query(xtrem_ui_1.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast((0, xtrem_ui_1.localize)('@sage/x3-purchasing/notification-error-receipt-lot', 'the lot number {{ lot }} already exists for this product', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\nvar YesNoEnum;\n(function (YesNoEnum) {\n    YesNoEnum[YesNoEnum[\"no\"] = 1] = \"no\";\n    YesNoEnum[YesNoEnum[\"yes\"] = 2] = \"yes\";\n})(YesNoEnum || (YesNoEnum = {}));\nclass PurchaseReceiptDetailsRecordManager {\n    constructor(page, cleanupIncompleteSessionLines = false) {\n        this.page = page;\n        this._stockDetails = [];\n        this._receiptUnit = [];\n        this._unitIsSame = true;\n        // An incomplete purchase receipt line can be added to the session when user is transitioning from main page to enter detail page\n        if (cleanupIncompleteSessionLines)\n            this._cleanupSession();\n    }\n    static { this.PURCHASE_RECEIPT_KEY = 'purchaseReceipt'; }\n    get purchaseSession() {\n        if (this._purchaseSession) {\n            return this._purchaseSession;\n        }\n        const storedSession = this.page.$.storage.get(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY);\n        if (storedSession) {\n            const parsedSession = JSON.parse(storedSession);\n            if (this._checkStorage(parsedSession)) {\n                this._purchaseSession = parsedSession;\n            }\n            else {\n                // purchase receipt in the session storage is corrupted/malformed\n                this.clearSession();\n            }\n        }\n        return this._purchaseSession;\n    }\n    set purchaseSession(purchaseSession) {\n        if (!purchaseSession) {\n            return;\n        }\n        if (!this._checkStorage(purchaseSession)) {\n            throw new Error('Invalid Purchase Receipt session');\n        }\n        this.page.$.storage.set(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY, JSON.stringify(purchaseSession));\n        this._purchaseSession = purchaseSession;\n    }\n    _checkStorage(sessionData) {\n        // check if sessionData contains at least one purchase receipt line that has at least one stock detail line\n        if (!sessionData ||\n            !sessionData.purchaseEntryTransaction.code ||\n            !sessionData.purchaseReceipt.receiptDate ||\n            !sessionData.purchaseReceipt.lines || typesLib.strictEq(sessionData.purchaseReceipt.lines.length, 0) ||\n            !sessionData.purchaseReceipt.receiptSite ||\n            !sessionData.purchaseReceipt.supplier) {\n            return false;\n        }\n        return !sessionData.purchaseReceipt.lines.some((line) => {\n            // skip most recent line that is pending to be completed in detail page\n            if (!line.stockDetails) {\n                return false;\n            }\n            // check for each line, the receipt unit & quantity are defined\n            if (!line.receiptUnit || typesLib.strictEq(line.quantityInReceiptUnitReceived, null) || typesLib.strictEq(line.quantityInReceiptUnitReceived, undefined)) {\n                return true;\n            }\n            return line.stockDetails.some((detail) => {\n                // check for each stock detail on this line, the packing unit & quantity are defined\n                return (!detail.packingUnit || typesLib.strictEq(detail.quantityInPackingUnit, null) || typesLib.strictEq(detail.quantityInPackingUnit, undefined));\n            });\n        });\n    }\n    _cleanupSession() {\n        this._purchaseSession = this.purchaseSession; // get the latest from session\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        // remove any incomplete purchase receipt lines (ex. a line without stockDetails)\n        const prevLineCount = this._purchaseSession.purchaseReceipt.lines?.length;\n        this._purchaseSession.purchaseReceipt.lines = this._purchaseSession.purchaseReceipt.lines.filter((line) => {\n            if (!line.receiptUnit || typesLib.strictEq(line.quantityInReceiptUnitReceived, null) || typesLib.strictEq(line.quantityInReceiptUnitReceived, undefined) ||\n                !line.stockDetails) {\n                return false;\n            }\n            return !line.stockDetails.some((detail) => {\n                // check for each stock detail on this line, the packing unit & quantity are defined\n                return (!detail.packingUnit || typesLib.strictEq(detail.quantityInPackingUnit, null) || typesLib.strictEq(detail.quantityInPackingUnit, undefined));\n            });\n        });\n        // if all lines have been removed, clear the session\n        if (typesLib.strictEq(this._purchaseSession.purchaseReceipt.lines?.length, 0)) {\n            this.clearSession();\n        }\n        else if (typesLib.strictNe(prevLineCount, this._purchaseSession.purchaseReceipt.lines.length)) {\n            // otherwise if any line got removed, overwrite the session\n            this.purchaseSession = this._purchaseSession;\n        }\n    }\n    clearSession() {\n        this.page.$.storage.remove(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY);\n        this._purchaseSession = null;\n    }\n    createLine(page, product) {\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        const currentLineNumber = typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1);\n        const currentLine = this._purchaseSession.purchaseReceipt.lines[currentLineNumber];\n        currentLine.stockDetails = this._stockDetails;\n        // If all receipt units are the same, use that unit for the line. If there are multiple receipt units,\n        // use stock unit for the line.\n        if (this._unitIsSame) {\n            currentLine.quantityInReceiptUnitReceived = this._receiptUnit.reduce((totalQty, line) => {\n                return typesLib.add(totalQty, line.quantityInReceiptUnit);\n            }, 0);\n            currentLine.receiptUnit = this._receiptUnit[0].code;\n            currentLine.receiptUnitToStockUnitConversionFactor = Number(page.packingUnitToStockUnitConversionFactor.value);\n        }\n        else {\n            currentLine.quantityInReceiptUnitReceived = this._receiptUnit.reduce((totalQty, line) => {\n                return typesLib.add(totalQty, typesLib.mul(Number(line.quantityInReceiptUnit), Number(line.stockUnitConversionFactor)));\n            }, 0);\n            currentLine.receiptUnit = product.stockUnit.code;\n            currentLine.receiptUnitToStockUnitConversionFactor = Number(page.packingUnitToStockUnitConversionFactor.value);\n        }\n        //Set receipt line number\n        currentLine.lineNumber = typesLib.mul((typesLib.add(currentLineNumber, 1)), 1000);\n        /*  if (\n            currentLine.purchaseOrderNumber &&\n            currentLine.purchaseOrderLineNumber &&\n            currentLine.purchaseOrderLine\n        ) {\n            currentLine._forMutationOnlyDoClosePurchaseOrderLine =\n                page.closePoLine.options.indexOf(page.closePoLine.value) === 0 ? YesNoEnum.yes : YesNoEnum.no;\n        } _forMutationOnlyDoClosePurchaseOrderLine missing */\n        currentLine.balance = (typesLib.strictEq(page.closePoLine.value, ui.localize('@sage/x3-purchasing/Yes', 'Yes')) ? YesNoEnum.yes : YesNoEnum.no).toString();\n        currentLine.warehouse = page.warehouse.value ?? undefined;\n        currentLine.container = page.container?.value?.code;\n        this.purchaseSession = {\n            purchaseEntryTransaction: this._purchaseSession.purchaseEntryTransaction,\n            purchaseReceipt: this._purchaseSession.purchaseReceipt,\n            orderUnitToPurchaseUnitConversionFactor: page.packingUnitToStockUnitConversionFactor.value ?? 0,\n        };\n    }\n    loadStockDetails(page, product) {\n        const quantityReceivedInStockUnit = typesLib.mul((page.quantityToReceive.value ?? 0), (page.packingUnitToStockUnitConversionFactor.value ?? 1));\n        // Saving receipt units is separate array because only stock and packing units are saved at stock details level.\n        this._receiptUnit.push({\n            code: page.receiptUnitCode.value ?? '',\n            quantityInReceiptUnit: page.quantityToReceive.value ?? 0,\n            stockUnitConversionFactor: page.packingUnitToStockUnitConversionFactor.value ?? 1,\n        });\n        // Check if unit is different from previous line\n        if (typesLib.gt(this._receiptUnit.length, 1) && this._unitIsSame) {\n            if (typesLib.strictNe(page.receiptUnitCode.value, this._receiptUnit[typesLib.sub(this._receiptUnit.length, 2)].code)) {\n                this._unitIsSame = false;\n            }\n        }\n        const detailLine = {\n            packingUnit: page.isPackingUnit ? (page.receiptUnitCode.value ?? '') : product.stockUnit.code,\n            quantityInPackingUnit: page.isPackingUnit\n                ? (page.quantityToReceive.value ?? 0)\n                : quantityReceivedInStockUnit,\n            packingUnitToStockUnitConversionFactor: page.isPackingUnit\n                ? (page.packingUnitToStockUnitConversionFactor.value ?? 1)\n                : 1,\n            lot: page.lot.value ?? undefined, // using undefined, omits the property entirely from JSON when stringified\n            sublot: page.sublot.value ?? undefined,\n            supplierLot: page.supplierLot.value ?? undefined,\n            potency: page.potency.value ?? undefined,\n            location: page.location.value?.code,\n            serialNumber: page.serialNumber.value ?? undefined,\n            status: page.status.value ?? undefined, // this is always required\n            majorVersion: page.majorVersion.value?.code,\n            minorVersion: page.minorVersion.value?.minorVersion,\n            licensePlateNumber: page.licensePlateNumber.value?.code,\n            expirationDate: (page.expirationDate.isDisabled ? page.calculatedExpirationDate.value : page.expirationDate.value) ??\n                undefined,\n            useByDate: page.useByDate.value ?? undefined,\n            lotCustomField1: page.lotCustomField1.value ?? undefined,\n            lotCustomField2: page.lotCustomField2.value ?? undefined,\n            lotCustomField3: page.lotCustomField3.value ?? undefined,\n            lotCustomField4: page.lotCustomField4.value ?? undefined,\n            identifier1: page.identifier1.value ?? undefined,\n            identifier2: page.identifier2.value ?? undefined,\n        };\n        this._stockDetails.push(detailLine);\n        // Initialize detail page for next detail line.  Most field values will default to previous detail line values.\n        page.location.isDisabled = false;\n        page.licensePlateNumber.value = { code: '' };\n        page.sublot.value = '';\n        page.serialNumber.value = '';\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        const currLine = this._purchaseSession.purchaseReceipt.lines[typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1)];\n        if (!currLine.purchaseOrder) {\n            // Set remaining quantity to 0 for direct receipts\n            page.quantityToReceive.value = 0;\n        }\n        else {\n            // Calculate remaining quantity for PO receipt lines (not direct receipt)\n            // remainingQuantity and quantityToReceive will always be the same unit and that unit will be the default\n            // for the next detail line.  Value can never be negative\n            page.remainingQuantityInStockUnit.value = typesLib.sub((page.remainingQuantityInStockUnit.value ?? 0), typesLib.mul((page.quantityToReceive.value ?? 0), (page.packingUnitToStockUnitConversionFactor.value ?? 1)));\n            if (typesLib.strictNe(page.packingUnitToStockUnitConversionFactor.value, 0))\n                page.remainingQuantityInPackingUnit.value = typesLib.div(page.remainingQuantityInStockUnit.value, (page.packingUnitToStockUnitConversionFactor.value ?? 1));\n            page.quantityToReceive.value = typesLib.max(0, page.remainingQuantityInPackingUnit.value ?? 0);\n            page.quantityToReceiveNoRounded = page.quantityToReceive.value;\n        }\n    }\n}\nexports.PurchaseReceiptDetailsRecordManager = PurchaseReceiptDetailsRecordManager;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/purchase-receipt-details-control.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-purchase-receipt-select-a-shipment.ts":
/*!****************************************************************!*\
  !*** ./lib/pages/mobile-purchase-receipt-select-a-shipment.ts ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobilePurchaseReceiptSelectAShipment = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst purchase_receipt_details_control_1 = __webpack_require__(/*! ../client-functions/purchase-receipt-details-control */ \"./lib/client-functions/purchase-receipt-details-control.ts\");\nconst QTY_DECIMAL_PLACES = 8;\nconst CONVERSION_RATE_DECIMAL_PLACES = 6;\nlet MobilePurchaseReceiptSelectAShipment = class MobilePurchaseReceiptSelectAShipment extends ui.Page {\n};\nexports.MobilePurchaseReceiptSelectAShipment = MobilePurchaseReceiptSelectAShipment;\n__decorate([\n    ui.decorators.section({\n        isHidden: true,\n    })\n], MobilePurchaseReceiptSelectAShipment.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobilePurchaseReceiptSelectAShipment.prototype, \"mainBlock\", void 0);\nexports.MobilePurchaseReceiptSelectAShipment = MobilePurchaseReceiptSelectAShipment = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_select_a_shipment____title\", \"Purchase receipt\"),\n        module: 'x3-purchasing',\n        isTitleHidden: true,\n        mode: 'default',\n        node: '@sage/x3-purchasing/PurchaseShipmentLine',\n        skipDirtyCheck: true,\n        navigationPanel: {\n            canFilter: false,\n            isHeaderHidden: true,\n            isAutoSelectEnabled: true,\n            listItem: {\n                title: ui.nestedFields.reference({\n                    node: '@sage/x3-master-data/Product',\n                    bind: 'product',\n                    valueField: 'code',\n                }),\n                line2: ui.nestedFields.reference({\n                    node: '@sage/x3-purchasing/PurchaseShipment',\n                    bind: 'purchaseShipment',\n                    valueField: 'id',\n                }),\n                line2Right: ui.nestedFields.text({\n                    bind: 'lineNumber',\n                }),\n                line3: ui.nestedFields.label({\n                    title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_select_a_shipment____navigationPanel__listItem__line3__title\", \"Shipped qty\"),\n                    prefix: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_select_a_shipment____navigationPanel__listItem__line3__prefix\", \"Shipped qty.\"),\n                    isFullWidth: false,\n                    postfix(value, rowData) {\n                        return rowData?.purchaseUnit?.code;\n                    },\n                    isTitleHidden: false,\n                    isTransient: true,\n                    bind: '_id',\n                    map(value, rowData) {\n                        return Number.isInteger(Number(rowData.quantityInPurchaseUnitShipped))\n                            ? rowData.quantityInPurchaseUnitShipped.toString()\n                            : rowData.quantityInPurchaseUnitShipped.toFixed(QTY_DECIMAL_PLACES);\n                    },\n                }),\n                line3Right: ui.nestedFields.label({\n                    title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_select_a_shipment____navigationPanel__listItem__line3Right__title\", \"Expected qty\"),\n                    prefix: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_select_a_shipment____navigationPanel__listItem__line3Right__prefix\", \"Expected qty.\"),\n                    isFullWidth: false,\n                    postfix(value, rowData) {\n                        return rowData?.purchaseUnit?.code;\n                    },\n                    isTitleHidden: false,\n                    isTransient: true,\n                    bind: '_id',\n                    map(value, rowData) {\n                        let quantityInStockUnitReceived = 0;\n                        let quantityInPurchaseUnitExpected = rowData.quantityInPurchaseUnitExpected;\n                        if (this.purchaseSession?.purchaseReceipt?.lines) {\n                            let quantityInStockUnitExpected = Number(rowData.quantityInStockUnitShipped);\n                            this.purchaseSession?.purchaseReceipt?.lines\n                                ?.filter((line) => line.purchaseShipment && typesLib.strictEq(line.purchaseShipment, rowData.purchaseShipment?.id) && typesLib.strictEq(Number(line.purchaseShipmentLine), Number(rowData.lineNumber)))\n                                .map((line) => (quantityInStockUnitReceived = typesLib.add(quantityInStockUnitReceived, typesLib.mul(Number(line.quantityInReceiptUnitReceived), Number(line.receiptUnitToStockUnitConversionFactor)))));\n                            if (typesLib.gt(quantityInStockUnitReceived, 0)) {\n                                quantityInPurchaseUnitExpected = typesLib.max(typesLib.div((typesLib.sub(Number(quantityInStockUnitExpected), Number(quantityInStockUnitReceived))), Number(rowData.product.purchaseUnitToStockUnitConversionFactor)), 0);\n                            }\n                        }\n                        return Number.isInteger(Number(quantityInPurchaseUnitExpected))\n                            ? quantityInPurchaseUnitExpected.toString()\n                            : quantityInPurchaseUnitExpected.toFixed(QTY_DECIMAL_PLACES);\n                    },\n                }),\n                line4: ui.nestedFields.numeric({\n                    bind: 'quantityInPurchaseUnitShipped',\n                    title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_select_a_shipment____navigationPanel__listItem__line4__title\", \"Shipped qty\"),\n                    isHidden: true,\n                }),\n                line4Right: ui.nestedFields.numeric({\n                    bind: 'quantityInPurchaseUnitExpected',\n                    title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_select_a_shipment____navigationPanel__listItem__line4Right__title\", \"Expected qty\"),\n                    isHidden: true,\n                }),\n                line5: ui.nestedFields.reference({\n                    node: '@sage/x3-master-data/UnitOfMeasure',\n                    bind: 'purchaseUnit',\n                    valueField: 'code',\n                    isHidden: true,\n                }),\n                line5Right: ui.nestedFields.numeric({\n                    bind: 'quantityInOrderUnitShipped',\n                    isHidden: true,\n                }),\n                line6: ui.nestedFields.numeric({\n                    bind: 'quantityInStockUnitShipped',\n                    isHidden: true,\n                }),\n                line6Right: ui.nestedFields.numeric({\n                    bind: 'orderUnitToPurchaseUnitConversionFactor',\n                    isHidden: true,\n                }),\n                line7: ui.nestedFields.reference({\n                    node: '@sage/x3-master-data/UnitOfMeasure',\n                    bind: 'stockUnit',\n                    valueField: 'code',\n                    isHidden: true,\n                }),\n                line7Right: ui.nestedFields.reference({\n                    node: '@sage/x3-master-data/UnitOfMeasure',\n                    bind: 'orderUnit',\n                    valueField: 'code',\n                    isHidden: true,\n                }),\n                line8: ui.nestedFields.numeric({\n                    bind: { product: { purchaseUnitToStockUnitConversionFactor: true } },\n                    isReadOnly: true,\n                    isHidden: true,\n                }),\n            },\n            orderBy: {\n                purchaseShipment: { id: 1 },\n                lineNumber: 1,\n            },\n            optionsMenu: [\n                {\n                    title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_select_a_shipment____navigationPanel__optionsMenu__title\", \"\"),\n                    graphQLFilter: (storage, queryParameters) => ({\n                        purchaseOrderNumber: { id: queryParameters?.purchaseOrderId },\n                        purchaseOrderLineNumber: Number(queryParameters?.purchaseOrderLineNumber),\n                        purchaseShipment: {\n                            id: { _in: JSON.parse(queryParameters.shipmentToLoad) },\n                        },\n                    }),\n                },\n            ],\n            onSelect(listItemValue) {\n                const currentLineNumber = typesLib.sub(this.purchaseSession?.purchaseReceipt?.lines.length, 1);\n                const currentLine = this.purchaseSession?.purchaseReceipt?.lines[currentLineNumber];\n                if (currentLine) {\n                    currentLine.purchaseShipment = String(listItemValue.purchaseShipment.id);\n                    currentLine.purchaseShipmentLine = String(listItemValue.lineNumber);\n                }\n                this._purchaseReceiptRecordManager.purchaseSession = this.purchaseSession;\n                this.$.router.goTo('@sage/x3-purchasing/MobilePurchaseReceiptEnterReceiptDetail', {\n                    globalTradeItemNumber: `${this.$.queryParameters.globalTradeItemNumber ?? ''}`,\n                });\n                return true;\n            },\n        },\n        onLoad() {\n            this._purchaseReceiptRecordManager = new purchase_receipt_details_control_1.PurchaseReceiptDetailsRecordManager(this);\n            this.purchaseSession = this._purchaseReceiptRecordManager.purchaseSession;\n            if (!this.purchaseSession) {\n                return;\n            }\n        },\n    })\n], MobilePurchaseReceiptSelectAShipment);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-purchase-receipt-select-a-shipment.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-purchase-receipt-select-a-shipment.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;