/// <reference path="../../../../../shared/x3-project-management-data/api/api.d.ts" />
/// <reference path="../../../../../shared/x3-invoicing-data/api/api.d.ts" />
/// <reference path="../../../../../shared/x3-manufacturing-data/api/api.d.ts" />
/// <reference path="../../../../../shared/x3-finance-data/api/api.d.ts" />
/// <reference path="../../../../../shared/x3-physical-flows-data/api/api.d.ts" />
/// <reference path="../../../../../shared/x3-purchasing-data/api/api.d.ts" />
/// <reference types="@sage/x3-master-data/api" />
import { ProductSite } from '@sage/x3-master-data-api';
import { Product } from '@sage/x3-master-data-api-partial';
import { GraphApi } from '@sage/x3-purchasing-api';
import { Lot } from '@sage/x3-stock-data-api';
import { SupportServiceManagementGs1Page } from '@sage/x3-system/lib/client-functions/support-service-management-gs-1-page';
import * as ui from '@sage/xtrem-ui';
import { PurchaseReceiptSession } from '../client-functions/purchase-receipt-details-control';
export type packingUnit = {
    node: {
        packingUnit: {
            code: string;
            numberOfDecimals: number;
            name: string;
        };
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
        isPackingUnit: boolean;
    };
};
export declare class MobilePurchaseReceiptEnterReceiptDetail extends SupportServiceManagementGs1Page<GraphApi> {
    private _purchaseReceiptRecordManager;
    private _effectiveDate;
    purchaseSession: PurchaseReceiptSession;
    private _isOverReceiptAllowed;
    receiptUnits: packingUnit[];
    productSite: ProductSite | undefined;
    productNode: Product;
    purchaseOrderNumber: string;
    purchaseOrderLineNumber: string | number | boolean;
    isPackingUnit: boolean;
    isExpirationManaged: boolean;
    quantityToReceiveNoRounded: number;
    quantityToReceiveRounded: number;
    remainingQuantityNoRoundedInPackingUnit: number;
    remainingQuantityRoundedInPackingUnit: number;
    isAddQuantity: boolean;
    previousPackingUnitToStockUnitConversionFactor: number;
    remainingQuantityInitialInStockUnit: number;
    remainingQuantityInitialInOrderUnit: number;
    orderUnit: {
        code: string;
    };
    isLocationPreloaded: boolean;
    headerTitleLeft: ui.fields.Text;
    headerTitleRight: ui.fields.Text;
    headerLine2Left: ui.fields.Text;
    headerLine2Right: ui.fields.Text;
    headerLine3Left: ui.fields.Text;
    headerLine3Right: ui.fields.Text;
    product: ui.fields.Text;
    description: ui.fields.Text;
    site: ui.fields.Text;
    supplier: ui.fields.Text;
    addDetails: ui.PageAction;
    addProduct: ui.PageAction;
    sectionHeader: ui.containers.Section;
    blockProduct: ui.containers.Block;
    blockClosePoLine: ui.containers.Block;
    receiptUnit: ui.fields.Select;
    receiptUnitCode: ui.fields.Label;
    previousReceiptUnit: ui.fields.Label;
    quantityToReceive: ui.fields.Numeric;
    remainingQuantityInPackingUnit: ui.fields.Numeric;
    remainingQuantityInStockUnit: ui.fields.Numeric;
    packingUnitToStockUnitConversionFactor: ui.fields.Numeric;
    status: ui.fields.Select;
    container: ui.fields.Reference;
    licensePlateNumber: ui.fields.Reference;
    suggestedLocation: ui.fields.Text;
    location: ui.fields.Reference;
    warehouse: ui.fields.Text;
    serialNumber: ui.fields.Text;
    supplierLot: ui.fields.Text;
    lot: ui.fields.FilterSelect<Lot>;
    svgLot: ui.fields.Text;
    sublot: ui.fields.Text;
    majorVersion: ui.fields.Reference;
    minorVersion: ui.fields.Reference;
    potency: ui.fields.Numeric;
    expirationDate: ui.fields.Date;
    useByDate: ui.fields.Date;
    calculatedExpirationDate: ui.fields.Date;
    lotCustomField1: ui.fields.Text;
    lotCustomField2: ui.fields.Text;
    lotCustomField3: ui.fields.Numeric;
    lotCustomField4: ui.fields.Date;
    identifier1: ui.fields.Text;
    identifier2: ui.fields.Text;
    closePoLine: ui.fields.Select;
    /**
     *
     * Technical composite data methods
     *
     */
    /**
     * Initialize ControlManagerGs1
     * @returns true when ControlManagerGs1 has usable
     */
    private _initControlManagerGs1;
    private _getNextField;
    private _getLotValues;
    private _setLotValues;
    private _initLotValues;
    private _resetValues;
    private _focusToNextField;
    private _validate;
    private _isFieldInvalid;
    private _getMinorVersions;
    private _initDirty;
    private _isEmptyLpnAndContainerValues;
}
//# sourceMappingURL=mobile-purchase-receipt-enter-receipt-detail.d.ts.map