"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transport = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        carrier: {
            code: 'carrier',
        },
        businessPartner: {
            code: 'businessPartner',
        },
        departurePlace: {
            code: 'departurePlace',
        },
        arrivalPlace: {
            code: 'arrivalPlace',
        },
    },
};
let Transport = class Transport extends xtrem_core_1.Node {
};
exports.Transport = Transport;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TRNNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Transport.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Transport.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPTNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], Transport.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Transport.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRNMOD',
        dataType: () => sageX3PurchasingData.enums.transportModeDatatype,
    })
], Transport.prototype, "transportMode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRNUID',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Transport.prototype, "transportIdentification", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DPETPC',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.TransitArea,
    })
], Transport.prototype, "departurePlace", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ARVTPC',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.TransitArea,
    })
], Transport.prototype, "arrivalPlace", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DPEDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Transport.prototype, "departureDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ARVEXPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Transport.prototype, "expectedArrivalDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ARVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Transport.prototype, "arrivalDate", void 0);
exports.Transport = Transport = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'TRANSPORT',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Transport);
//# sourceMappingURL=transport.js.map