"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseReturnLine = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Purchasing = require("..");
const joins = {
    referenceJoins: {
        purchaseReturn: {
            id: 'purchaseReturn',
        },
        company: {
            code: 'company',
        },
        returnSite: {
            code: 'returnSite',
        },
        product: {
            code: 'product',
        },
        returnLineTextRef: {
            code: 'returnLineTextKey',
        },
    },
};
const compositeReferences = {
    returnLineTextRef: {
        returnLineText: 'text',
    },
};
let PurchaseReturnLine = class PurchaseReturnLine extends xtrem_core_1.Node {
};
exports.PurchaseReturnLine = PurchaseReturnLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PNHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseReturn,
    })
], PurchaseReturnLine.prototype, "purchaseReturn", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PNDLIN',
    })
], PurchaseReturnLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], PurchaseReturnLine.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PNHFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseReturnLine.prototype, "returnSite", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RTNDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseReturnLine.prototype, "returnDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PurchaseReturnLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'LINTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReturnLine.prototype, "returnLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], PurchaseReturnLine.prototype, "returnLineTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], PurchaseReturnLine.prototype, "returnLineText", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseReturnLineTaxes,
    })
], PurchaseReturnLine.prototype, "taxes", void 0);
exports.PurchaseReturnLine = PurchaseReturnLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PRETURND',
        keyPropertyNames: ['purchaseReturn', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    purchaseReturn: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['purchaseReturn', 'lineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PurchaseReturnLine);
//# sourceMappingURL=purchase-return-line.js.map