import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3Purchasing from '..';
export declare class PurchaseOrder extends Node {
    readonly id: Promise<string>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly purchaseSite: Reference<sageX3System.nodes.Site>;
    readonly orderType: Promise<sageX3Purchasing.enums.PurchaseOrderType | null>;
    readonly revisionNumber: Promise<integer | null>;
    readonly orderDate: Promise<date | null>;
    readonly internalOrderReference: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly orderFromSupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly orderFromSupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly orderFromSupplierAddressZipCode: Promise<string>;
    readonly orderFromSupplierAddressCity: Promise<string>;
    readonly orderFromSupplierAddressState: Promise<string>;
    readonly orderFromSupplierAddressCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly orderFromSupplierAddressCountryName: Promise<string>;
    readonly shipFromSupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly shipFromSupplierAddressZipCode: Promise<string>;
    readonly shipFromSupplierAddressCity: Promise<string>;
    readonly shipFromSupplierAddressState: Promise<string>;
    readonly shipFromSupplierAddressCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly shipFromSupplierAddressCountryName: Promise<string>;
    readonly invoiceSite: Reference<sageX3System.nodes.Site | null>;
    readonly receiptSite: Reference<sageX3System.nodes.Site | null>;
    readonly expectedReceiptDate: Promise<date | null>;
    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly incotermTown: Promise<string>;
    readonly groupingCode: Promise<string>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly europeanUnionIdentification: Promise<string>;
    readonly buyer: Reference<sageX3System.nodes.User | null>;
    readonly orderFromSupplierLanguage: Reference<sageX3System.nodes.Language>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly currencyRateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly currencyRate: Promise<decimal | null>;
    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
    readonly taxRuleType: Promise<integer | null>;
    readonly numberOfLines: Promise<integer | null>;
    readonly numberOfBudgetOverrunLines: Promise<integer | null>;
    readonly numberOfReceivedLines: Promise<integer | null>;
    readonly numberOfClosedLines: Promise<integer | null>;
    readonly numberOfInvoicedLines: Promise<integer | null>;
    readonly numberOfReceipts: Promise<integer | null>;
    readonly numberOfInvoices: Promise<integer | null>;
    readonly signatureStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
    readonly isClosed: Promise<boolean>;
    readonly receiptStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
    readonly invoicedStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
    readonly isPrinted: Promise<boolean>;
    readonly numberOfCopies: Promise<integer | null>;
    readonly orderHeaderTextKey: Promise<string>;
    readonly orderFooterTextKey: Promise<string>;
    readonly acknowledgmentDate: Promise<date | null>;
    readonly acknowledgmentNumber: Promise<string>;
    readonly acknowledgmentNote: Promise<string>;
    readonly isPrintedAcknowledgmentReminder: Promise<boolean>;
    readonly mustSendDeliveryReminder: Promise<boolean>;
    readonly isIntercompany: Promise<boolean>;
    readonly isIntersite: Promise<boolean>;
    readonly purchaseSiteForIntersite: Reference<sageX3System.nodes.Site | null>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly salesSite: Reference<sageX3System.nodes.Site | null>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly amountOfLinesIncludingTax: Promise<decimal | null>;
    readonly amountOfLinesExcludingTax: Promise<decimal | null>;
    readonly totalQuantityOfLines: Promise<decimal | null>;
    readonly totalWeightOfLines: Promise<decimal | null>;
    readonly totalVolumeOfLines: Promise<decimal | null>;
    readonly totalTaxAmount: Promise<decimal | null>;
    readonly totalAmountExcludingTax: Promise<decimal | null>;
    readonly totalAmountIncludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly expectedTotalAmountExcludingTax: Promise<decimal | null>;
    readonly serviceStartDate: Promise<date | null>;
    readonly serviceEndDate: Promise<date | null>;
    readonly container: Reference<sageX3MasterData.nodes.Container | null>;
    readonly numberOfContainers: Promise<integer | null>;
    readonly maximumAmountExcludingTax: Promise<decimal | null>;
    readonly availableWeightOfContainer: Promise<decimal | null>;
    readonly availableVolumeOfContainer: Promise<decimal | null>;
    readonly purchaseOrderLines: Collection<sageX3Purchasing.nodes.PurchaseOrderLine>;
    readonly orderHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly orderFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly orderFooterText: Promise<TextStream>;
    readonly orderHeaderText: Promise<TextStream>;
    readonly companyNames: Collection<sageX3Purchasing.nodes.PurchaseOrderCompanyNames>;
    readonly dimensions: Collection<sageX3Purchasing.nodes.PurchaseOrderDimensions>;
    readonly discountOrChargeCalculationRules: Collection<sageX3Purchasing.nodes.PurchaseOrderDiscountOrChargeCalculationRules>;
    readonly fromSupplierAddressLines: Collection<sageX3Purchasing.nodes.PurchaseOrderFromSupplierAddressLines>;
    readonly fromSupplierCompanyNames: Collection<sageX3Purchasing.nodes.PurchaseOrderFromSupplierCompanyNames>;
    readonly headerInvoiceLineAllocationElements: Collection<sageX3Purchasing.nodes.PurchaseOrderHeaderInvoiceLineAllocationElements>;
    readonly shipFromSupplierAddressLines: Collection<sageX3Purchasing.nodes.PurchaseOrderShipFromSupplierAddressLines>;
    readonly supplierStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseOrderSupplierStatisticalGroups>;
}
//# sourceMappingURL=purchase-order.d.ts.map