"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseOrderQuantityLine = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Purchasing = require("..");
const joins = {
    referenceJoins: {
        purchaseOrder: {
            id: 'purchaseOrder',
        },
        sequenceNumber: {
            purchaseOrder: 'purchaseOrder',
            lineNumber: 'lineNumber',
            sequenceNumber: 'sequenceNumber',
        },
        company: {
            code: 'company',
        },
        purchaseSite: {
            code: 'purchaseSite',
        },
        orderFromSupplier: {
            code: 'orderFromSupplier',
        },
        billBySupplier: {
            code: 'billBySupplier',
        },
        billBySupplierAddress: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'billBySupplier',
            code: 'billBySupplierAddress',
        },
        product: {
            code: 'product',
        },
        supplierProduct: {
            product: 'product',
            supplier: 'orderFromSupplier',
        },
        purchaseUnit: {
            code: 'purchaseUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        orderUnit: {
            code: 'orderUnit',
        },
        weightUnit: {
            code: 'weightUnit',
        },
        volumeUnit: {
            code: 'volumeUnit',
        },
        shippingSite: {
            code: 'shippingSite',
        },
        receiptSite: {
            code: 'receiptSite',
        },
        receiptAddress: {
            entityType() {
                return 'site';
            },
            site: 'receiptSite',
            code: 'receiptAddress',
        },
        subcontractAddress: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'orderFromSupplier',
            code: 'subcontractAddress',
        },
        currency: {
            code: 'currency',
        },
        costStructure: {
            code: 'costStructure',
        },
        companyCurrency: {
            code: 'companyCurrency',
        },
        releasedProduct: {
            code: 'releasedProduct',
        },
        purchaseReceipt: {
            id: 'purchaseReceipt',
        },
        purchaseReceiptLine: {
            purchaseReceipt: 'purchaseReceipt',
            lineNumber: 'purchaseReceiptLine',
        },
        majorProductVersion: {
            product: 'product',
            code: 'majorProductVersion',
        },
    },
};
let PurchaseOrderQuantityLine = class PurchaseOrderQuantityLine extends xtrem_core_1.Node {
};
exports.PurchaseOrderQuantityLine = PurchaseOrderQuantityLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseOrder,
    })
], PurchaseOrderQuantityLine.prototype, "purchaseOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POPLIN',
    })
], PurchaseOrderQuantityLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POQSEQ',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseOrderLine,
    })
], PurchaseOrderQuantityLine.prototype, "sequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POQLNK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "lineAndSequenceIndex", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], PurchaseOrderQuantityLine.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POHFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseOrderQuantityLine.prototype, "purchaseSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POHTYP',
        dataType: () => sageX3Purchasing.enums.purchaseOrderTypeDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "orderType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderQuantityLine.prototype, "orderDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseOrderQuantityLine.prototype, "orderFromSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseOrderQuantityLine.prototype, "billBySupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseOrderQuantityLine.prototype, "billBySupplierAddress", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINREVNUM',
    })
], PurchaseOrderQuantityLine.prototype, "lineRevisionNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PurchaseOrderQuantityLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREFBPS',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SupplierProduct,
    })
], PurchaseOrderQuantityLine.prototype, "supplierProduct", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PUU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderQuantityLine.prototype, "purchaseUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderQuantityLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderQuantityLine.prototype, "orderUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOMFLG',
    })
], PurchaseOrderQuantityLine.prototype, "isInOrderUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOMPUUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "orderUnitToPurchaseUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LIKQTYCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "linkCoefficientForSubcontract", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYUOM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInOrderUnitOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInPurchaseUnitOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInStockUnitOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYWEU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "weight", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderQuantityLine.prototype, "weightUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYVOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderQuantityLine.prototype, "volumeUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RETQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInPurchaseUnitRequired", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RETQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInStockUnitRequired", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInPurchaseUnitReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInStockUnitReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInPurchaseUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInStockUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RETRCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderQuantityLine.prototype, "requirementDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTRCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderQuantityLine.prototype, "expectedReceiptDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINSTOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseOrderQuantityLine.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRHFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseOrderQuantityLine.prototype, "receiptSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCYADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'site',
            },
            control: {
                entityType: 'site',
            },
        },
        node: () => sageX3MasterData.nodes.SiteAddress,
    })
], PurchaseOrderQuantityLine.prototype, "receiptAddress", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OFS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "reorderLeadTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USEPLC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "locationReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseOrderQuantityLine.prototype, "subcontractAddress", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WIPTYP',
        dataType: () => sageX3ManufacturingData.enums.workOrderTypeDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "workOrderInProgressType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WIPSTA',
        dataType: () => sageX3ManufacturingData.enums.statusInProgressDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "workOrderInProgressStatus", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WIPNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "workInProgressOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINPURTYP',
        dataType: () => sageX3InvoicingData.enums.purchaseTypeDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "purchaseType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASRCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderQuantityLine.prototype, "lastReceiptDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASINVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderQuantityLine.prototype, "lastSalesInvoiceDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVRCPNBR',
    })
], PurchaseOrderQuantityLine.prototype, "numberOfInvoicedReceipts", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINRCPNBR',
    })
], PurchaseOrderQuantityLine.prototype, "numberOfReceipts", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LININVNBR',
    })
], PurchaseOrderQuantityLine.prototype, "numberOfInvoices", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "orderLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCPCLEFLG',
    })
], PurchaseOrderQuantityLine.prototype, "isClosedByReceipt", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINCLEFLG',
    })
], PurchaseOrderQuantityLine.prototype, "isClosed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LININVFLG',
    })
], PurchaseOrderQuantityLine.prototype, "isInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINPRNFLG',
    })
], PurchaseOrderQuantityLine.prototype, "isPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CMMTAX',
        dataType: () => sageX3PurchasingData.enums.commitmentTypeDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "commitmentType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CMMFLG',
    })
], PurchaseOrderQuantityLine.prototype, "commitmentGenerated", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FBUFLG',
    })
], PurchaseOrderQuantityLine.prototype, "isBudgetOverrun", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORI',
        dataType: () => sageX3PurchasingData.enums.requestSourceDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "sourceRequest", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINOCNDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderQuantityLine.prototype, "acknowledgementDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINOCNNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "acknowledgementNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINOCNFLG',
    })
], PurchaseOrderQuantityLine.prototype, "acknowledgementUpdate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NETCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseOrderQuantityLine.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "landedCostCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "fixedLandedCostPerUnitInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STCNUM',
        columnType: 'string',
        node: () => sageX3PurchasingData.nodes.FreightCostStructure,
    })
], PurchaseOrderQuantityLine.prototype, "costStructure", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "purchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "stockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPRCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseOrderQuantityLine.prototype, "companyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "costPriceWithoutLandedCost", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "totalPurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "totalStockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "taxExcludedLineAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINAMTCPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "lineStockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINCSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "linePurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REACSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "actualPurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "lineOrderAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINATIAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "lineAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "distributedInvoicingElement1AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "distributedInvoicingElement2AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "distributedInvoicingElement3AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "distributedInvoicingElement4AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "distributedInvoicingElement5AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "distributedInvoicingElement6AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "distributedInvoicingElement7AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "distributedInvoicingElement8AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "distributedInvoicingElement9AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "calculatedTaxBasis1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "calculatedTaxBasis2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "calculatedBasisForTax3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "calculationBasisForReceiptTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "calculationBasisForIssueTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "calculationBasisForOtherTax1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "calculationBasisForOtherTax2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISBASLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "rebateOnTax1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "tax1BasisAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "tax1amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "tax2amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "tax3amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXRCP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "receiptTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXISS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "issueTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXOTH1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "otherTax1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXOTH2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "otherTax2Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "tax1DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "tax2DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "tax3DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXRCP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "receiptTaxDeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXISS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "issueTaxDeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXOTH1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "otherTax1DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXOTH2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "otherTax2DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PQHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "requestForQuotation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PPDLIN',
    })
], PurchaseOrderQuantityLine.prototype, "requestForQuotationResponseLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CAD',
        dataType: () => sageX3MasterData.enums.timingDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "requestedDeliverySequencing", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'YEA',
    })
], PurchaseOrderQuantityLine.prototype, "requestedDeliveryYear", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MON',
    })
], PurchaseOrderQuantityLine.prototype, "requestedDeliveryMonth", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WEE',
    })
], PurchaseOrderQuantityLine.prototype, "requestedDeliveryWeek", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINSTA',
        dataType: () => sageX3MasterData.enums.lineStatusDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "lineStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINTYP',
        dataType: () => sageX3PurchasingData.enums.orderLineTypeDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMRCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderQuantityLine.prototype, "requestedDeliveryStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMRCPHOU',
    })
], PurchaseOrderQuantityLine.prototype, "requestedDeliveryStartTime", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderQuantityLine.prototype, "requestedDeliveryEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMENDHOU',
    })
], PurchaseOrderQuantityLine.prototype, "requestedDeliveryEndTime", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREFORI',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PurchaseOrderQuantityLine.prototype, "releasedProduct", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYPORI',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "sourceDocumentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUMORI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "sourceDocumentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRLINORI',
    })
], PurchaseOrderQuantityLine.prototype, "sourceDocumentLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRSEQORI',
    })
], PurchaseOrderQuantityLine.prototype, "sourceDocumentSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseReceipt,
    })
], PurchaseOrderQuantityLine.prototype, "purchaseReceipt", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTDLIN',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptLine,
    })
], PurchaseOrderQuantityLine.prototype, "purchaseReceiptLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OCNLIN',
    })
], PurchaseOrderQuantityLine.prototype, "interCompanySalesOrderLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OCNSEQ',
    })
], PurchaseOrderQuantityLine.prototype, "interCompanySalesOrderSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "majorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], PurchaseOrderQuantityLine.prototype, "minorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInStockUnitShippedNotReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "quantityInPurchaseUnitShippedNotReceived", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMKND',
        dataType: () => sageX3Purchasing.enums.purchasingProductTypeDatatype,
    })
], PurchaseOrderQuantityLine.prototype, "productType", void 0);
exports.PurchaseOrderQuantityLine = PurchaseOrderQuantityLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PORDERQ',
        keyPropertyNames: ['purchaseOrder', 'lineNumber', 'sequenceNumber'],
        indexes: [
            {
                orderBy: {
                    purchaseOrder: 1,
                    lineNumber: 1,
                    sequenceNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['lineNumber', 'sequenceNumber'],
        }),
        canRead: true,
        canSearch: true,
    })
], PurchaseOrderQuantityLine);
//# sourceMappingURL=purchase-order-quantity-line.js.map