import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
import * as sageX3Purchasing from '..';
export declare class PurchaseOrderQuantityLine extends Node {
    readonly purchaseOrder: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
    readonly lineNumber: Promise<integer | null>;
    readonly sequenceNumber: Reference<sageX3Purchasing.nodes.PurchaseOrderLine | null>;
    readonly lineAndSequenceIndex: Promise<string>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly purchaseSite: Reference<sageX3System.nodes.Site>;
    readonly orderType: Promise<sageX3Purchasing.enums.PurchaseOrderType | null>;
    readonly orderDate: Promise<date | null>;
    readonly orderFromSupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly lineRevisionNumber: Promise<integer | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly supplierProduct: Reference<sageX3MasterData.nodes.SupplierProduct | null>;
    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly orderUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly isInOrderUnit: Promise<boolean>;
    readonly orderUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
    readonly linkCoefficientForSubcontract: Promise<decimal | null>;
    readonly quantityInOrderUnitOrdered: Promise<decimal | null>;
    readonly quantityInPurchaseUnitOrdered: Promise<decimal | null>;
    readonly quantityInStockUnitOrdered: Promise<decimal | null>;
    readonly weight: Promise<decimal | null>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volume: Promise<decimal | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly quantityInPurchaseUnitRequired: Promise<decimal | null>;
    readonly quantityInStockUnitRequired: Promise<decimal | null>;
    readonly quantityInPurchaseUnitReceived: Promise<decimal | null>;
    readonly quantityInStockUnitReceived: Promise<decimal | null>;
    readonly quantityInPurchaseUnitInvoiced: Promise<decimal | null>;
    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
    readonly requirementDate: Promise<date | null>;
    readonly expectedReceiptDate: Promise<date | null>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly receiptSite: Reference<sageX3System.nodes.Site>;
    readonly receiptAddress: Reference<sageX3MasterData.nodes.SiteAddress | null>;
    readonly reorderLeadTime: Promise<decimal | null>;
    readonly locationReference: Promise<string>;
    readonly subcontractAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly workOrderInProgressType: Promise<sageX3ManufacturingData.enums.WorkOrderType | null>;
    readonly workOrderInProgressStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
    readonly workInProgressOrderNumber: Promise<string>;
    readonly purchaseType: Promise<sageX3InvoicingData.enums.PurchaseType | null>;
    readonly lastReceiptDate: Promise<date | null>;
    readonly lastSalesInvoiceDate: Promise<date | null>;
    readonly numberOfInvoicedReceipts: Promise<integer | null>;
    readonly numberOfReceipts: Promise<integer | null>;
    readonly numberOfInvoices: Promise<integer | null>;
    readonly orderLineTextKey: Promise<string>;
    readonly isClosedByReceipt: Promise<boolean>;
    readonly isClosed: Promise<boolean>;
    readonly isInvoiced: Promise<boolean>;
    readonly isPrinted: Promise<boolean>;
    readonly commitmentType: Promise<sageX3PurchasingData.enums.CommitmentType | null>;
    readonly commitmentGenerated: Promise<integer | null>;
    readonly isBudgetOverrun: Promise<boolean>;
    readonly sourceRequest: Promise<sageX3PurchasingData.enums.RequestSource | null>;
    readonly acknowledgementDate: Promise<date | null>;
    readonly acknowledgementNumber: Promise<string>;
    readonly acknowledgementUpdate: Promise<integer | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly landedCostCoefficient: Promise<decimal | null>;
    readonly fixedLandedCostPerUnitInCompanyCurrency: Promise<decimal | null>;
    readonly costStructure: Reference<sageX3PurchasingData.nodes.FreightCostStructure | null>;
    readonly purchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly stockCostInCompanyCurrency: Promise<decimal | null>;
    readonly companyCurrency: Reference<sageX3MasterData.nodes.Currency>;
    readonly costPriceWithoutLandedCost: Promise<decimal | null>;
    readonly totalPurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly totalStockCostInCompanyCurrency: Promise<decimal | null>;
    readonly taxExcludedLineAmount: Promise<decimal | null>;
    readonly lineStockCostInCompanyCurrency: Promise<decimal | null>;
    readonly linePurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly actualPurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly lineOrderAmountIncludingTax: Promise<decimal | null>;
    readonly lineAmountIncludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement1AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement2AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement3AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement4AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement5AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement6AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement7AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement8AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement9AmountExcludingTax: Promise<decimal | null>;
    readonly calculatedTaxBasis1: Promise<decimal | null>;
    readonly calculatedTaxBasis2: Promise<decimal | null>;
    readonly calculatedBasisForTax3: Promise<decimal | null>;
    readonly calculationBasisForReceiptTax: Promise<decimal | null>;
    readonly calculationBasisForIssueTax: Promise<decimal | null>;
    readonly calculationBasisForOtherTax1: Promise<decimal | null>;
    readonly calculationBasisForOtherTax2: Promise<decimal | null>;
    readonly rebateOnTax1Amount: Promise<decimal | null>;
    readonly tax1BasisAmount: Promise<decimal | null>;
    readonly tax1amount: Promise<decimal | null>;
    readonly tax2amount: Promise<decimal | null>;
    readonly tax3amount: Promise<decimal | null>;
    readonly receiptTaxAmount: Promise<decimal | null>;
    readonly issueTaxAmount: Promise<decimal | null>;
    readonly otherTax1Amount: Promise<decimal | null>;
    readonly otherTax2Amount: Promise<decimal | null>;
    readonly tax1DeductibleAmount: Promise<decimal | null>;
    readonly tax2DeductibleAmount: Promise<decimal | null>;
    readonly tax3DeductibleAmount: Promise<decimal | null>;
    readonly receiptTaxDeductibleAmount: Promise<decimal | null>;
    readonly issueTaxDeductibleAmount: Promise<decimal | null>;
    readonly otherTax1DeductibleAmount: Promise<decimal | null>;
    readonly otherTax2DeductibleAmount: Promise<decimal | null>;
    readonly requestForQuotation: Promise<string>;
    readonly requestForQuotationResponseLineNumber: Promise<integer | null>;
    readonly requestedDeliverySequencing: Promise<sageX3MasterData.enums.Timing | null>;
    readonly requestedDeliveryYear: Promise<integer | null>;
    readonly requestedDeliveryMonth: Promise<integer | null>;
    readonly requestedDeliveryWeek: Promise<integer | null>;
    readonly lineStatus: Promise<sageX3MasterData.enums.LineStatus | null>;
    readonly lineType: Promise<sageX3PurchasingData.enums.OrderLineType | null>;
    readonly requestedDeliveryStartDate: Promise<date | null>;
    readonly requestedDeliveryStartTime: Promise<integer | null>;
    readonly requestedDeliveryEndDate: Promise<date | null>;
    readonly requestedDeliveryEndTime: Promise<integer | null>;
    readonly releasedProduct: Reference<sageX3MasterData.nodes.Product | null>;
    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly sourceDocumentNumber: Promise<string>;
    readonly sourceDocumentLineNumber: Promise<integer | null>;
    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
    readonly purchaseReceipt: Reference<sageX3Purchasing.nodes.PurchaseReceipt | null>;
    readonly purchaseReceiptLine: Reference<sageX3Purchasing.nodes.PurchaseReceiptLine | null>;
    readonly interCompanySalesOrderLineNumber: Promise<integer | null>;
    readonly interCompanySalesOrderSequenceNumber: Promise<integer | null>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Promise<string>;
    readonly quantityInStockUnitShippedNotReceived: Promise<decimal | null>;
    readonly quantityInPurchaseUnitShippedNotReceived: Promise<decimal | null>;
    readonly productType: Promise<sageX3Purchasing.enums.PurchasingProductType | null>;
}
//# sourceMappingURL=purchase-order-quantity-line.d.ts.map