"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseOrderLine = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Purchasing = require("..");
const joins = {
    referenceJoins: {
        purchaseOrder: {
            id: 'purchaseOrder',
        },
        company: {
            code: 'company',
        },
        product: {
            code: 'product',
        },
        priceReason: {
            code: 'priceReason',
        },
        discountOrCharge1Reason: {
            code: 'discountOrCharge1Reason',
        },
        discountOrCharge2Reason: {
            code: 'discountOrCharge2Reason',
        },
        discountOrCharge3Reason: {
            code: 'discountOrCharge3Reason',
        },
        discountOrCharge4Reason: {
            code: 'discountOrCharge4Reason',
        },
        discountOrCharge5Reason: {
            code: 'discountOrCharge5Reason',
        },
        discountOrCharge6Reason: {
            code: 'discountOrCharge6Reason',
        },
        discountOrCharge7Reason: {
            code: 'discountOrCharge7Reason',
        },
        discountOrCharge8Reason: {
            code: 'discountOrCharge8Reason',
        },
        discountOrCharge9Reason: {
            code: 'discountOrCharge9Reason',
        },
        buyer: {
            code: 'buyer',
        },
        receiptSite: {
            code: 'receiptSite',
        },
        receiptAddress: {
            entityType() {
                return 'site';
            },
            site: 'receiptSite',
            code: 'receiptAddress',
        },
        project: {
            id: 'project',
        },
        countryOfOrigin: {
            code: 'countryOfOrigin',
        },
        receiptTax: {
            code: 'receiptTax',
            async legislation() {
                return (await (await (await (await this.purchaseOrder).purchaseSite).legalCompany).legislation)?.code;
            },
        },
        issueTax: {
            code: 'issueTax',
            async legislation() {
                return (await (await (await (await this.purchaseOrder).purchaseSite).legalCompany).legislation)?.code;
            },
        },
        otherTax1: {
            code: 'otherTax1',
            async legislation() {
                return (await (await (await (await this.purchaseOrder).purchaseSite).legalCompany).legislation)?.code;
            },
        },
        otherTax2: {
            code: 'otherTax2',
            async legislation() {
                return (await (await (await (await this.purchaseOrder).purchaseSite).legalCompany).legislation)?.code;
            },
        },
        matchingTolerance: {
            code: 'matchingTolerance',
        },
        purchaseOrderQuantityLine: {
            purchaseOrder: 'purchaseOrder',
            lineNumber: 'lineNumber',
            sequenceNumber: 'sequenceNumber',
        },
        orderLineTextRef: {
            async code() {
                return (await this.purchaseOrderQuantityLine).orderLineTextKey;
            },
        },
    },
};
const compositeReferences = {
    purchaseOrderQuantityLine: {
        acknowledgementDate: 'acknowledgementDate',
        acknowledgementNumber: 'acknowledgementNumber',
        acknowledgementUpdate: 'acknowledgementUpdate',
        actualPurchaseCostInCompanyCurrency: 'actualPurchaseCostInCompanyCurrency',
        billBySupplier: 'billBySupplier',
        billBySupplierAddress: 'billBySupplierAddress',
        calculatedBasisForTax3: 'calculatedBasisForTax3',
        calculatedTaxBasis1: 'calculatedTaxBasis1',
        calculatedTaxBasis2: 'calculatedTaxBasis2',
        calculationBasisForIssueTax: 'calculationBasisForIssueTax',
        calculationBasisForOtherTax1: 'calculationBasisForOtherTax1',
        calculationBasisForOtherTax2: 'calculationBasisForOtherTax2',
        calculationBasisForReceiptTax: 'calculationBasisForReceiptTax',
        commitmentGenerated: 'commitmentGenerated',
        commitmentType: 'commitmentType',
        companyCurrency: 'companyCurrency',
        costPriceWithoutLandedCost: 'costPriceWithoutLandedCost',
        costStructure: 'costStructure',
        currency: 'currency',
        distributedInvoicingElement1AmountExcludingTax: 'distributedInvoicingElement1AmountExcludingTax',
        distributedInvoicingElement2AmountExcludingTax: 'distributedInvoicingElement2AmountExcludingTax',
        distributedInvoicingElement3AmountExcludingTax: 'distributedInvoicingElement3AmountExcludingTax',
        distributedInvoicingElement4AmountExcludingTax: 'distributedInvoicingElement4AmountExcludingTax',
        distributedInvoicingElement5AmountExcludingTax: 'distributedInvoicingElement5AmountExcludingTax',
        distributedInvoicingElement6AmountExcludingTax: 'distributedInvoicingElement6AmountExcludingTax',
        distributedInvoicingElement7AmountExcludingTax: 'distributedInvoicingElement7AmountExcludingTax',
        distributedInvoicingElement8AmountExcludingTax: 'distributedInvoicingElement8AmountExcludingTax',
        distributedInvoicingElement9AmountExcludingTax: 'distributedInvoicingElement9AmountExcludingTax',
        expectedReceiptDate: 'expectedReceiptDate',
        fixedLandedCostPerUnitInCompanyCurrency: 'fixedLandedCostPerUnitInCompanyCurrency',
        interCompanySalesOrderLineNumber: 'interCompanySalesOrderLineNumber',
        interCompanySalesOrderSequenceNumber: 'interCompanySalesOrderSequenceNumber',
        isBudgetOverrun: 'isBudgetOverrun',
        isClosed: 'isClosed',
        isClosedByReceipt: 'isClosedByReceipt',
        isInOrderUnit: 'isInOrderUnit',
        isInvoiced: 'isInvoiced',
        isPrinted: 'isPrinted',
        issueTaxAmount: 'issueTaxAmount',
        issueTaxDeductibleAmount: 'issueTaxDeductibleAmount',
        landedCostCoefficient: 'landedCostCoefficient',
        lastReceiptDate: 'lastReceiptDate',
        lastSalesInvoiceDate: 'lastSalesInvoiceDate',
        lineAmountIncludingTax: 'lineAmountIncludingTax',
        lineAndSequenceIndex: 'lineAndSequenceIndex',
        lineOrderAmountIncludingTax: 'lineOrderAmountIncludingTax',
        linePurchaseCostInCompanyCurrency: 'linePurchaseCostInCompanyCurrency',
        lineStatus: 'lineStatus',
        lineStockCostInCompanyCurrency: 'lineStockCostInCompanyCurrency',
        lineType: 'lineType',
        linkCoefficientForSubcontract: 'linkCoefficientForSubcontract',
        locationReference: 'locationReference',
        majorProductVersion: 'majorProductVersion',
        minorProductVersion: 'minorProductVersion',
        numberOfInvoicedReceipts: 'numberOfInvoicedReceipts',
        numberOfInvoices: 'numberOfInvoices',
        numberOfReceipts: 'numberOfReceipts',
        orderDate: 'orderDate',
        orderFromSupplier: 'orderFromSupplier',
        orderLineTextKey: 'orderLineTextKey',
        orderUnit: 'orderUnit',
        orderUnitToPurchaseUnitConversionFactor: 'orderUnitToPurchaseUnitConversionFactor',
        otherTax1Amount: 'otherTax1Amount',
        otherTax1DeductibleAmount: 'otherTax1DeductibleAmount',
        otherTax2Amount: 'otherTax2Amount',
        otherTax2DeductibleAmount: 'otherTax2DeductibleAmount',
        productType: 'productType',
        purchaseCostInCompanyCurrency: 'purchaseCostInCompanyCurrency',
        purchaseReceipt: 'purchaseReceipt',
        purchaseReceiptLine: 'purchaseReceiptLine',
        purchaseSite: 'purchaseSite',
        purchaseType: 'purchaseType',
        purchaseUnit: 'purchaseUnit',
        quantityInOrderUnitOrdered: 'quantityInOrderUnitOrdered',
        quantityInPurchaseUnitInvoiced: 'quantityInPurchaseUnitInvoiced',
        quantityInPurchaseUnitOrdered: 'quantityInPurchaseUnitOrdered',
        quantityInPurchaseUnitReceived: 'quantityInPurchaseUnitReceived',
        quantityInPurchaseUnitRequired: 'quantityInPurchaseUnitRequired',
        quantityInPurchaseUnitShippedNotReceived: 'quantityInPurchaseUnitShippedNotReceived',
        quantityInStockUnitInvoiced: 'quantityInStockUnitInvoiced',
        quantityInStockUnitOrdered: 'quantityInStockUnitOrdered',
        quantityInStockUnitReceived: 'quantityInStockUnitReceived',
        quantityInStockUnitRequired: 'quantityInStockUnitRequired',
        quantityInStockUnitShippedNotReceived: 'quantityInStockUnitShippedNotReceived',
        rebateOnTax1Amount: 'rebateOnTax1Amount',
        receiptTaxAmount: 'receiptTaxAmount',
        receiptTaxDeductibleAmount: 'receiptTaxDeductibleAmount',
        releasedProduct: 'releasedProduct',
        reorderLeadTime: 'reorderLeadTime',
        requestForQuotation: 'requestForQuotation',
        requestForQuotationResponseLineNumber: 'requestForQuotationResponseLineNumber',
        requestedDeliveryEndDate: 'requestedDeliveryEndDate',
        requestedDeliveryEndTime: 'requestedDeliveryEndTime',
        requestedDeliveryStartDate: 'requestedDeliveryStartDate',
        requestedDeliveryStartTime: 'requestedDeliveryStartTime',
        requirementDate: 'requirementDate',
        shippingSite: 'shippingSite',
        sourceDocumentLineNumber: 'sourceDocumentLineNumber',
        sourceDocumentNumber: 'sourceDocumentNumber',
        sourceDocumentSequenceNumber: 'sourceDocumentSequenceNumber',
        sourceDocumentType: 'sourceDocumentType',
        sourceRequest: 'sourceRequest',
        stockCostInCompanyCurrency: 'stockCostInCompanyCurrency',
        stockUnit: 'stockUnit',
        subcontractAddress: 'subcontractAddress',
        supplierProduct: 'supplierProduct',
        tax1BasisAmount: 'tax1BasisAmount',
        tax1DeductibleAmount: 'tax1DeductibleAmount',
        tax1amount: 'tax1amount',
        tax2DeductibleAmount: 'tax2DeductibleAmount',
        tax2amount: 'tax2amount',
        tax3DeductibleAmount: 'tax3DeductibleAmount',
        tax3amount: 'tax3amount',
        taxExcludedLineAmount: 'taxExcludedLineAmount',
        totalPurchaseCostInCompanyCurrency: 'totalPurchaseCostInCompanyCurrency',
        totalStockCostInCompanyCurrency: 'totalStockCostInCompanyCurrency',
        volume: 'volume',
        volumeUnit: 'volumeUnit',
        weight: 'weight',
        weightUnit: 'weightUnit',
        workInProgressOrderNumber: 'workInProgressOrderNumber',
        workOrderInProgressStatus: 'workOrderInProgressStatus',
        workOrderInProgressType: 'workOrderInProgressType',
    },
    orderLineTextRef: {
        orderLineText: 'text',
    },
};
let PurchaseOrderLine = class PurchaseOrderLine extends xtrem_core_1.Node {
};
exports.PurchaseOrderLine = PurchaseOrderLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseOrder,
    })
], PurchaseOrderLine.prototype, "purchaseOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POPLIN',
    })
], PurchaseOrderLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POPSEQ',
    })
], PurchaseOrderLine.prototype, "sequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], PurchaseOrderLine.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POHTYP',
        dataType: () => sageX3Purchasing.enums.purchaseOrderTypeDatatype,
    })
], PurchaseOrderLine.prototype, "orderType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINREVNUM',
    })
], PurchaseOrderLine.prototype, "revisionNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PurchaseOrderLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderLine.prototype, "productDescriptionInUserLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderLine.prototype, "productDescriptionInSupplierLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GROPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "grossPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIREN',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
    })
], PurchaseOrderLine.prototype, "priceReason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp1ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp2ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp3ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp4ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp5ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge5", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp6ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge6", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp7ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge7", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp8ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge8", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp9ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge9", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN1',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp1ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge1Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN2',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp2ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge2Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN3',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp3ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge3Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN4',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp4ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge4Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN5',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp5ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge5Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN6',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp6ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge6Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN7',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp7ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge7Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN8',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp8ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge8Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN9',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp9ActivityCode],
    })
], PurchaseOrderLine.prototype, "discountOrCharge9Reason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "netPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINBUY',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], PurchaseOrderLine.prototype, "buyer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRHFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseOrderLine.prototype, "receiptSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCYADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'site',
            },
            control: {
                entityType: 'site',
            },
        },
        node: () => sageX3MasterData.nodes.SiteAddress,
    })
], PurchaseOrderLine.prototype, "receiptAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], PurchaseOrderLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECINCRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseOrderLine.prototype, "intrastatIncreaseCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORICRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], PurchaseOrderLine.prototype, "countryOfOrigin", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QUAFLG',
    })
], PurchaseOrderLine.prototype, "hasQualityControlManagement", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAXRCP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "receiptTax", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAXISS',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "issueTax", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAXOTH1',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "otherTax1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAXOTH2',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "otherTax2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MATTOL',
        columnType: 'string',
        node: () => sageX3PurchasingData.nodes.MatchingTolerance,
    })
], PurchaseOrderLine.prototype, "matchingTolerance", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseOrderQuantityLine,
    })
], PurchaseOrderLine.prototype, "purchaseOrderQuantityLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], PurchaseOrderLine.prototype, "orderLineTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINOCNDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderLine.prototype, "acknowledgementDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINOCNNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderLine.prototype, "acknowledgementNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINOCNFLG',
    })
], PurchaseOrderLine.prototype, "acknowledgementUpdate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REACSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "actualPurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseOrderLine.prototype, "billBySupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseOrderLine.prototype, "billBySupplierAddress", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "calculatedBasisForTax3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "calculatedTaxBasis1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "calculatedTaxBasis2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "calculationBasisForIssueTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "calculationBasisForOtherTax1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "calculationBasisForOtherTax2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "calculationBasisForReceiptTax", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CMMFLG',
    })
], PurchaseOrderLine.prototype, "commitmentGenerated", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CMMTAX',
        dataType: () => sageX3PurchasingData.enums.commitmentTypeDatatype,
    })
], PurchaseOrderLine.prototype, "commitmentType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPRCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseOrderLine.prototype, "companyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "costPriceWithoutLandedCost", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STCNUM',
        columnType: 'string',
        node: () => sageX3PurchasingData.nodes.FreightCostStructure,
    })
], PurchaseOrderLine.prototype, "costStructure", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NETCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseOrderLine.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "distributedInvoicingElement1AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "distributedInvoicingElement2AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "distributedInvoicingElement3AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "distributedInvoicingElement4AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "distributedInvoicingElement5AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "distributedInvoicingElement6AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "distributedInvoicingElement7AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "distributedInvoicingElement8AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "distributedInvoicingElement9AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTRCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderLine.prototype, "expectedReceiptDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "fixedLandedCostPerUnitInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OCNLIN',
    })
], PurchaseOrderLine.prototype, "interCompanySalesOrderLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OCNSEQ',
    })
], PurchaseOrderLine.prototype, "interCompanySalesOrderSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FBUFLG',
    })
], PurchaseOrderLine.prototype, "isBudgetOverrun", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINCLEFLG',
    })
], PurchaseOrderLine.prototype, "isClosed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCPCLEFLG',
    })
], PurchaseOrderLine.prototype, "isClosedByReceipt", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOMFLG',
    })
], PurchaseOrderLine.prototype, "isInOrderUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LININVFLG',
    })
], PurchaseOrderLine.prototype, "isInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINPRNFLG',
    })
], PurchaseOrderLine.prototype, "isPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXISS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "issueTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXISS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "issueTaxDeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "landedCostCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASRCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderLine.prototype, "lastReceiptDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASINVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderLine.prototype, "lastSalesInvoiceDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINATIAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "lineAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POQLNK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderLine.prototype, "lineAndSequenceIndex", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "lineOrderAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINCSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "linePurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINSTA',
        dataType: () => sageX3MasterData.enums.lineStatusDatatype,
    })
], PurchaseOrderLine.prototype, "lineStatus", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINAMTCPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "lineStockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINTYP',
        dataType: () => sageX3PurchasingData.enums.orderLineTypeDatatype,
    })
], PurchaseOrderLine.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LIKQTYCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "linkCoefficientForSubcontract", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USEPLC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderLine.prototype, "locationReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], PurchaseOrderLine.prototype, "majorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], PurchaseOrderLine.prototype, "minorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVRCPNBR',
    })
], PurchaseOrderLine.prototype, "numberOfInvoicedReceipts", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LININVNBR',
    })
], PurchaseOrderLine.prototype, "numberOfInvoices", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINRCPNBR',
    })
], PurchaseOrderLine.prototype, "numberOfReceipts", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderLine.prototype, "orderDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseOrderLine.prototype, "orderFromSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], PurchaseOrderLine.prototype, "orderLineText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'LINTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderLine.prototype, "orderLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderLine.prototype, "orderUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOMPUUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "orderUnitToPurchaseUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXOTH1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "otherTax1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXOTH1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "otherTax1DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXOTH2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "otherTax2Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXOTH2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "otherTax2DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMKND',
        dataType: () => sageX3Purchasing.enums.purchasingProductTypeDatatype,
    })
], PurchaseOrderLine.prototype, "productType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "purchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseReceipt,
    })
], PurchaseOrderLine.prototype, "purchaseReceipt", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTDLIN',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptLine,
    })
], PurchaseOrderLine.prototype, "purchaseReceiptLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POHFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseOrderLine.prototype, "purchaseSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINPURTYP',
        dataType: () => sageX3InvoicingData.enums.purchaseTypeDatatype,
    })
], PurchaseOrderLine.prototype, "purchaseType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PUU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderLine.prototype, "purchaseUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYUOM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInOrderUnitOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInPurchaseUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInPurchaseUnitOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInPurchaseUnitReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RETQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInPurchaseUnitRequired", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInPurchaseUnitShippedNotReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInStockUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInStockUnitOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInStockUnitReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RETQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInStockUnitRequired", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "quantityInStockUnitShippedNotReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISBASLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "rebateOnTax1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXRCP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "receiptTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXRCP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseOrderLine.prototype, "receiptTaxDeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREFORI',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PurchaseOrderLine.prototype, "releasedProduct", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OFS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "reorderLeadTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PQHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderLine.prototype, "requestForQuotation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PPDLIN',
    })
], PurchaseOrderLine.prototype, "requestForQuotationResponseLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderLine.prototype, "requestedDeliveryEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMENDHOU',
    })
], PurchaseOrderLine.prototype, "requestedDeliveryEndTime", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMRCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderLine.prototype, "requestedDeliveryStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMRCPHOU',
    })
], PurchaseOrderLine.prototype, "requestedDeliveryStartTime", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RETRCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseOrderLine.prototype, "requirementDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINSTOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseOrderLine.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRLINORI',
    })
], PurchaseOrderLine.prototype, "sourceDocumentLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUMORI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderLine.prototype, "sourceDocumentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRSEQORI',
    })
], PurchaseOrderLine.prototype, "sourceDocumentSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYPORI',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], PurchaseOrderLine.prototype, "sourceDocumentType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORI',
        dataType: () => sageX3PurchasingData.enums.requestSourceDatatype,
    })
], PurchaseOrderLine.prototype, "sourceRequest", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "stockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseOrderLine.prototype, "subcontractAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREFBPS',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SupplierProduct,
    })
], PurchaseOrderLine.prototype, "supplierProduct", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "tax1BasisAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "tax1DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "tax1amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "tax2DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "tax2amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "tax3DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "tax3amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "taxExcludedLineAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "totalPurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "totalStockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYVOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderLine.prototype, "volumeUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYWEU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseOrderLine.prototype, "weight", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseOrderLine.prototype, "weightUnit", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WIPNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseOrderLine.prototype, "workInProgressOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WIPSTA',
        dataType: () => sageX3ManufacturingData.enums.statusInProgressDatatype,
    })
], PurchaseOrderLine.prototype, "workOrderInProgressStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WIPTYP',
        dataType: () => sageX3ManufacturingData.enums.workOrderTypeDatatype,
    })
], PurchaseOrderLine.prototype, "workOrderInProgressType", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseOrderLineProductStatisticalGroups,
    })
], PurchaseOrderLine.prototype, "productStatisticalGroups", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseOrderLineTaxes,
    })
], PurchaseOrderLine.prototype, "taxes", void 0);
exports.PurchaseOrderLine = PurchaseOrderLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PORDERP',
        keyPropertyNames: ['purchaseOrder', 'lineNumber', 'sequenceNumber'],
        indexes: [
            {
                orderBy: {
                    purchaseOrder: 1,
                    lineNumber: 1,
                    sequenceNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['lineNumber', 'sequenceNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PurchaseOrderLine);
//# sourceMappingURL=purchase-order-line.js.map