"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseInvoice = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PhysicalFlowsData = require("@sage/x3-physical-flows-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Purchasing = require("..");
const joins = {
    referenceJoins: {
        id: {
            id: 'id',
        },
        invoiceType: {
            code: 'invoiceType',
            async legislation() {
                return (await (await (await (await this.supplierInvoiceHeader).site).legalCompany).legislation)?.code;
            },
        },
        billBySupplier: {
            code: 'billBySupplier',
        },
        currency: {
            code: 'currency',
        },
        weightUnitForDistributionOnLines: {
            code: 'weightUnitForDistributionOnLines',
        },
        volumeUnitForDistributionOnLines: {
            code: 'volumeUnitForDistributionOnLines',
        },
        billBySupplierLanguage: {
            code: 'billBySupplierLanguage',
        },
        companyLanguage: {
            code: 'companyLanguage',
        },
        company: {
            code: 'company',
        },
        earlyDiscountOrLateCharge: {
            code: 'earlyDiscountOrLateCharge',
            async legislation() {
                return (await (await (await (await this.supplierInvoiceHeader).site).legalCompany).legislation)?.code;
            },
        },
        billToCustomer: {
            code: 'billToCustomer',
        },
        supplierInvoiceHeader: {
            id: 'id',
        },
        invoiceHeaderTextRef: {
            code: 'invoiceHeaderTextKey',
        },
        invoiceFooterTextRef: {
            code: 'invoiceFooterTextKey',
        },
    },
    collectionJoins: {
        purchaseInvoiceLines: {
            purchaseInvoice: 'id',
        },
    },
};
const compositeReferences = {
    supplierInvoiceHeader: {
        accountingDate: 'accountingDate',
        billBySupplierAddress: 'billBySupplierAddress',
        billBySupplierAddressLines: 'billBySupplierAddressLines',
        billBySupplierCity: 'billBySupplierCity',
        billBySupplierCompanyNames: 'billBySupplierCompanyNames',
        billBySupplierCountry: 'billBySupplierCountry',
        billBySupplierCountryName: 'billBySupplierCountryName',
        billBySupplierPostalCode: 'billBySupplierPostalCode',
        billBySupplierState: 'billBySupplierState',
        cashVatTaxRule: 'cashVatTaxRule',
        comments: 'comments',
        control: 'control',
        currencyRates: 'currencyRates',
        debitOrCredit: 'debitOrCredit',
        derCode: 'derCode',
        dimensions: 'dimensions',
        dueDateCalculationStartDate: 'dueDateCalculationStartDate',
        earlyDiscountOrLateChargeBasis: 'earlyDiscountOrLateChargeBasis',
        earlyDiscountOrLateChargeRate: 'earlyDiscountOrLateChargeRate',
        entryType: 'entryType',
        europeanUnionIdentification: 'europeanUnionIdentification',
        field40Reason: 'field40Reason',
        field41Reason: 'field41Reason',
        fiscalYear: 'fiscalYear',
        forwardingAgent: 'forwardingAgent',
        forwardingAgentAddress: 'forwardingAgentAddress',
        incoterm: 'incoterm',
        incotermTown: 'incotermTown',
        internalNumber: 'internalNumber',
        internalReference: 'internalReference',
        intrastatProcessingNumber: 'intrastatProcessingNumber',
        intrastatStatisticalRule: 'intrastatStatisticalRule',
        intrastatTransactionNature: 'intrastatTransactionNature',
        intrastatTransportLocation: 'intrastatTransportLocation',
        intrastatTransportMode: 'intrastatTransportMode',
        isDas2Submitted: 'isDAS2Submitted',
        isEuropeanUnionInvoice: 'isEuropeanUnionInvoice',
        journal: 'journal',
        lastServiceAccountedDate: 'lastServiceAccountedDate',
        matchStatus: 'matchStatus',
        numberOfTaxes: 'numberOfTaxes',
        originalDocumentNumber: 'originalDocumentNumber',
        originalInvoiceNumber: 'originalInvoiceNumber',
        payToBusinessPartner: 'payToBusinessPartner',
        payToBusinessPartnerAddress: 'payToBusinessPartnerAddress',
        payToBusinessPartnerAddressLines: 'payToBusinessPartnerAddressLines',
        payToBusinessPartnerCity: 'payToBusinessPartnerCity',
        payToBusinessPartnerCompanyNames: 'payToBusinessPartnerCompanyNames',
        payToBusinessPartnerCountry: 'payToBusinessPartnerCountry',
        payToBusinessPartnerCountryName: 'payToBusinessPartnerCountryName',
        payToBusinessPartnerPostalCode: 'payToBusinessPartnerPostalCode',
        payToBusinessPartnerState: 'payToBusinessPartnerState',
        paymentApproval: 'paymentApproval',
        paymentTerm: 'paymentTerm',
        period: 'period',
        priceOrAmountType: 'priceOrAmountType',
        project: 'project',
        rateDate: 'rateDate',
        rateType: 'rateType',
        serviceEndDate: 'serviceEndDate',
        serviceStartDate: 'serviceStartDate',
        singleCustomsDocumentBusinessPartnerCode: 'singleCustomsDocumentBusinessPartnerCode',
        singleCustomsDocumentDate: 'singleCustomsDocumentDate',
        singleCustomsDocumentReference: 'singleCustomsDocumentReference',
        site: 'site',
        sourceDocumentDate: 'sourceDocumentDate',
        sourceModule: 'sourceModule',
        status: 'status',
        supplierSourceDocument: 'sourceDocument',
        taxReferenceDate: 'taxReferenceDate',
        taxRule: 'taxRule',
        taxes: 'taxes',
        totalAmountExcludingTax: 'totalAmountExcludingTax',
        totalAmountExcludingTaxInCompanyCurrency: 'totalAmountExcludingTaxInCompanyCurrency',
        totalAmountIncludingTax: 'totalAmountIncludingTax',
        totalAmountIncludingTaxInCompanyCurrency: 'totalAmountIncludingTaxInCompanyCurrency',
        versionControlSystemNumber: 'versionControlSystemNumber',
    },
    invoiceFooterTextRef: {
        invoiceFooterText: 'text',
    },
    invoiceHeaderTextRef: {
        invoiceHeaderText: 'text',
    },
};
let PurchaseInvoice = class PurchaseInvoice extends xtrem_core_1.Node {
};
exports.PurchaseInvoice = PurchaseInvoice;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUM',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeader,
    })
], PurchaseInvoice.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVTYP',
        dataType: () => sageX3InvoicingData.enums.invoiceTypeDatatype,
    })
], PurchaseInvoice.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIVTYP',
        columnType: 'string',
        node: () => sageX3PurchasingData.nodes.PurchaseInvoiceType,
    })
], PurchaseInvoice.prototype, "invoiceType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIHTYP',
        dataType: () => sageX3MasterData.enums.purchaseInvoiceCategoryDatatype,
    })
], PurchaseInvoice.prototype, "purchaseInvoiceCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseInvoice.prototype, "billBySupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseInvoice.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINNBR',
    })
], PurchaseInvoice.prototype, "numberOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYLINNBR',
    })
], PurchaseInvoice.prototype, "numberOfLinesWithDifferentQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRILINNBR',
    })
], PurchaseInvoice.prototype, "numberOfLinesWithDifferentPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseInvoice.prototype, "weightUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseInvoice.prototype, "volumeUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTLINWEU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "totalWeightOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTLINVOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "totalVolumeOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTLINQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "totalQuantityOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTLINAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "amountOfLinesExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCLINAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "calculatedLineAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTTAXAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "totalTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], PurchaseInvoice.prototype, "billBySupplierLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPYLAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], PurchaseInvoice.prototype, "companyLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], PurchaseInvoice.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.EarlyDiscountLateCharge,
    })
], PurchaseInvoice.prototype, "earlyDiscountOrLateCharge", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'TEX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "invoiceHeaderTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'TEX2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "invoiceFooterTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETCPY',
    })
], PurchaseInvoice.prototype, "isIntercompany", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], PurchaseInvoice.prototype, "billToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Purchasing.nodes.PurchaseInvoiceLine,
        isMutable: true,
        dependsOn: ['id'],
    })
], PurchaseInvoice.prototype, "purchaseInvoiceLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeader,
    })
], PurchaseInvoice.prototype, "supplierInvoiceHeader", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], PurchaseInvoice.prototype, "invoiceHeaderTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], PurchaseInvoice.prototype, "invoiceFooterTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseInvoice.prototype, "accountingDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseInvoice.prototype, "billBySupplierAddress", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierAddressLines,
        isMutable: true,
    })
], PurchaseInvoice.prototype, "billBySupplierAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "billBySupplierCity", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierCompanyNames,
        isMutable: true,
    })
], PurchaseInvoice.prototype, "billBySupplierCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], PurchaseInvoice.prototype, "billBySupplierCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "billBySupplierCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "billBySupplierPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "billBySupplierState", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSHVAT',
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], PurchaseInvoice.prototype, "cashVatTaxRule", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderComments,
        isMutable: true,
    })
], PurchaseInvoice.prototype, "comments", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRSAC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "control", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3FinanceData.nodes.SupplierInvoiceHeaderCurrencyRates,
        isMutable: true,
    })
], PurchaseInvoice.prototype, "currencyRates", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNS',
    })
], PurchaseInvoice.prototype, "debitOrCredit", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPADERNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], PurchaseInvoice.prototype, "derCode", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3FinanceData.nodes.SupplierInvoiceHeaderDimensions,
        isMutable: true,
    })
], PurchaseInvoice.prototype, "dimensions", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDUDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseInvoice.prototype, "dueDateCalculationStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASDEP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "earlyDiscountOrLateChargeBasis", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEPRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "earlyDiscountOrLateChargeRate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GTE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.EntryType,
    })
], PurchaseInvoice.prototype, "entryType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseInvoice.prototype, "europeanUnionIdentification", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLD40REN',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], PurchaseInvoice.prototype, "field40Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLD41REN',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], PurchaseInvoice.prototype, "field41Reason", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIY',
    })
], PurchaseInvoice.prototype, "fiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], PurchaseInvoice.prototype, "forwardingAgent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseInvoice.prototype, "forwardingAgentAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECICT',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Incoterm,
    })
], PurchaseInvoice.prototype, "incoterm", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ICTCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "incotermTown", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCNUM',
    })
], PurchaseInvoice.prototype, "internalNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "internalReference", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECNUMDEB',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseInvoice.prototype, "intrastatProcessingNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECSCH',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseInvoice.prototype, "intrastatStatisticalRule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECNAT',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseInvoice.prototype, "intrastatTransactionNature", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECLOC',
        dataType: () => sageX3MasterData.enums.countryLocationDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseInvoice.prototype, "intrastatTransportLocation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECTRN',
        dataType: () => sageX3MasterData.enums.intrastatTransportModeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseInvoice.prototype, "intrastatTransportMode", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], PurchaseInvoice.prototype, "invoiceFooterText", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], PurchaseInvoice.prototype, "invoiceHeaderText", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DAS2',
        serviceOptions: () => [sageX3System.serviceOptions.Fee2ActivityCode],
    })
], PurchaseInvoice.prototype, "isDas2Submitted", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CEEFLG',
    })
], PurchaseInvoice.prototype, "isEuropeanUnionInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'JOU',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Journal,
    })
], PurchaseInvoice.prototype, "journal", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], PurchaseInvoice.prototype, "lastServiceAccountedDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TWMSTA',
        dataType: () => sageX3InvoicingData.enums.matchStatusEnumDatatype,
    })
], PurchaseInvoice.prototype, "matchStatus", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBRTAX',
    })
], PurchaseInvoice.prototype, "numberOfTaxes", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORIDOCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], PurchaseInvoice.prototype, "originalDocumentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "originalInvoiceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRPAY',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], PurchaseInvoice.prototype, "payToBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAPAY',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], PurchaseInvoice.prototype, "payToBusinessPartnerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerAddressLines,
        isMutable: true,
    })
], PurchaseInvoice.prototype, "payToBusinessPartnerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "payToBusinessPartnerCity", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames,
        isMutable: true,
    })
], PurchaseInvoice.prototype, "payToBusinessPartnerCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPYCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], PurchaseInvoice.prototype, "payToBusinessPartnerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "payToBusinessPartnerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "payToBusinessPartnerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPYSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "payToBusinessPartnerState", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAZ',
        dataType: () => sageX3MasterData.enums.paymentApprovalTypeDatatype,
    })
], PurchaseInvoice.prototype, "paymentApproval", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTE',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.PaymentTerm,
    })
], PurchaseInvoice.prototype, "paymentTerm", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PER',
    })
], PurchaseInvoice.prototype, "period", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEPTYP',
        dataType: () => sageX3MasterData.enums.priceAmountTaxTaxDatatype,
    })
], PurchaseInvoice.prototype, "priceOrAmountType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJTH',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], PurchaseInvoice.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseInvoice.prototype, "rateDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CURTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], PurchaseInvoice.prototype, "rateType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], PurchaseInvoice.prototype, "serviceEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDATSVC',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.SvcActivityCode],
    })
], PurchaseInvoice.prototype, "serviceStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SPACUSBPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], PurchaseInvoice.prototype, "singleCustomsDocumentBusinessPartnerCode", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SPACUSDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], PurchaseInvoice.prototype, "singleCustomsDocumentDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPACUS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], PurchaseInvoice.prototype, "singleCustomsDocumentReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseInvoice.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseInvoice.prototype, "sourceDocumentDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIMOD',
        dataType: () => sageX3System.enums.moduleTableDatatype,
    })
], PurchaseInvoice.prototype, "sourceModule", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STA',
        dataType: () => sageX3InvoicingData.enums.purchasingInvoiceStatusDatatype,
    })
], PurchaseInvoice.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRVCR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoice.prototype, "supplierSourceDocument", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VATDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseInvoice.prototype, "taxReferenceDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VAC',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.TaxRule,
    })
], PurchaseInvoice.prototype, "taxRule", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeaderTaxes,
        isMutable: true,
    })
], PurchaseInvoice.prototype, "taxes", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "totalAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOTL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "totalAmountExcludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "totalAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATIL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoice.prototype, "totalAmountIncludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BELVCS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KbeActivityCode],
    })
], PurchaseInvoice.prototype, "versionControlSystemNumber", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseInvoiceHeaderInvoiceLineAllocationElements,
    })
], PurchaseInvoice.prototype, "headerInvoiceLineAllocationElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseInvoiceHeaderInvoiceLineElements,
    })
], PurchaseInvoice.prototype, "headerInvoiceLineElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseInvoiceSupplierStatisticalGroups,
    })
], PurchaseInvoice.prototype, "supplierStatisticalGroups", void 0);
exports.PurchaseInvoice = PurchaseInvoice = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PINVOICEV',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
    })
], PurchaseInvoice);
//# sourceMappingURL=purchase-invoice.js.map