import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, TextStream, Collection } from '@sage/xtrem-core';
import * as sageX3Purchasing from '..';
export declare class PurchaseInvoiceLine extends Node {
    readonly purchaseInvoice: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
    readonly lineNumber: Promise<integer | null>;
    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
    readonly invoiceType: Reference<sageX3PurchasingData.nodes.PurchaseInvoiceType | null>;
    readonly purchaseInvoiceCategory: Promise<sageX3MasterData.enums.PurchaseInvoiceCategory | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly accountingDate: Promise<date | null>;
    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly lineSite: Reference<sageX3System.nodes.Site>;
    readonly sourceLine: Promise<sageX3Purchasing.enums.PurchaseInvoiceSource | null>;
    readonly sourceDocument: Promise<string>;
    readonly sourceDocumentLineNumber: Promise<integer | null>;
    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product | null>;
    readonly productDescriptionInUserLanguage: Promise<string>;
    readonly productDescriptionInSupplierLanguage: Promise<string>;
    readonly invoicingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
    readonly quantityInInvoiceUnitInvoiced: Promise<decimal | null>;
    readonly quantityInPurchaseUnitInvoiced: Promise<decimal | null>;
    readonly sourceQuantity: Promise<decimal | null>;
    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
    readonly weight: Promise<decimal | null>;
    readonly sourceWeight: Promise<decimal | null>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volume: Promise<decimal | null>;
    readonly sourceVolume: Promise<decimal | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly grossPrice: Promise<decimal | null>;
    readonly priceReason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge1: Promise<decimal | null>;
    readonly discountOrCharge2: Promise<decimal | null>;
    readonly discountOrCharge3: Promise<decimal | null>;
    readonly discountOrCharge4: Promise<decimal | null>;
    readonly discountOrCharge5: Promise<decimal | null>;
    readonly discountOrCharge6: Promise<decimal | null>;
    readonly discountOrCharge7: Promise<decimal | null>;
    readonly discountOrCharge8: Promise<decimal | null>;
    readonly discountOrCharge9: Promise<decimal | null>;
    readonly discountOrCharge1Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge2Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge3Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge4Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge5Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge6Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge7Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge8Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge9Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly netPrice: Promise<decimal | null>;
    readonly sourceNetPrice: Promise<decimal | null>;
    readonly purchaseType: Promise<sageX3InvoicingData.enums.PurchaseType | null>;
    readonly distributedInvoicingElement1AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement2AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement3AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement4AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement5AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement6AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement7AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement8AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement9AmountExcludingTax: Promise<decimal | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly purchaseOrder: Reference<sageX3Purchasing.nodes.PurchaseOrder | null>;
    readonly purchaseOrderLine: Reference<sageX3Purchasing.nodes.PurchaseOrderLine | null>;
    readonly purchaseOrderSequenceNumber: Promise<integer | null>;
    readonly purchaseReceipt: Reference<sageX3Purchasing.nodes.PurchaseReceipt | null>;
    readonly purchaseReceiptLine: Reference<sageX3Purchasing.nodes.PurchaseReceiptLine | null>;
    readonly purchaseReturn: Reference<sageX3Purchasing.nodes.PurchaseReturn | null>;
    readonly purchaseReturnLine: Reference<sageX3Purchasing.nodes.PurchaseReturnLine | null>;
    readonly purchaseShipment: Reference<sageX3Purchasing.nodes.PurchaseShipment | null>;
    readonly purchaseShipmentLine: Reference<sageX3Purchasing.nodes.PurchaseShipmentLine | null>;
    readonly sourcePurchaseInvoice: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader | null>;
    readonly sourcePurchaseInvoiceLine: Reference<sageX3Purchasing.nodes.PurchaseInvoiceLine | null>;
    readonly supplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly receiptDate: Promise<date | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly issueRegion: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly receiptRegion: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly lineAmountExcludingTax: Promise<decimal | null>;
    readonly lineAmountIncludingTax: Promise<decimal | null>;
    readonly discountAmount: Promise<decimal | null>;
    readonly distributedInvoicingElementEarlyDiscountAmount1: Promise<decimal | null>;
    readonly distributedInvoicingElementEarlyDiscountAmount2: Promise<decimal | null>;
    readonly distributedInvoicingElementEarlyDiscountAmount3: Promise<decimal | null>;
    readonly distributedInvoicingElementEarlyDiscountAmount4: Promise<decimal | null>;
    readonly distributedInvoicingElementEarlyDiscountAmount5: Promise<decimal | null>;
    readonly distributedInvoicingElementEarlyDiscountAmount6: Promise<decimal | null>;
    readonly distributedInvoicingElementEarlyDiscountAmount7: Promise<decimal | null>;
    readonly distributedInvoicingElementEarlyDiscountAmount8: Promise<decimal | null>;
    readonly distributedInvoicingElementEarlyDiscountAmount9: Promise<decimal | null>;
    readonly quantityUncommitted: Promise<decimal | null>;
    readonly quantityActualCommitted: Promise<decimal | null>;
    readonly nonFinancialUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly calculatedTaxableBase1: Promise<decimal | null>;
    readonly calculatedTaxableBase2: Promise<decimal | null>;
    readonly calculatedTaxableBase3: Promise<decimal | null>;
    readonly calculationBasisForReceiptTax: Promise<decimal | null>;
    readonly calculationBasisForIssueTax: Promise<decimal | null>;
    readonly calculationBasisForOtherTax1: Promise<decimal | null>;
    readonly calculationBasisForOtherTax2: Promise<decimal | null>;
    readonly rebateOnTax1Amount: Promise<decimal | null>;
    readonly taxableBase1Amount: Promise<decimal | null>;
    readonly tax1amount: Promise<decimal | null>;
    readonly tax2amount: Promise<decimal | null>;
    readonly tax3amount: Promise<decimal | null>;
    readonly receiptTaxAmount: Promise<decimal | null>;
    readonly issueTaxAmount: Promise<decimal | null>;
    readonly otherTax1Amount: Promise<decimal | null>;
    readonly otherTax2Amount: Promise<decimal | null>;
    readonly tax1DeductibleAmount: Promise<decimal | null>;
    readonly tax2DeductibleAmount: Promise<decimal | null>;
    readonly tax3DeductibleAmount: Promise<decimal | null>;
    readonly receiptTaxDeductibleAmount: Promise<decimal | null>;
    readonly issueTaxDeductibleAmount: Promise<decimal | null>;
    readonly otherTax1DeductibleAmount: Promise<decimal | null>;
    readonly otherTax2DeductibleAmount: Promise<decimal | null>;
    readonly landedCostCoefficient: Promise<decimal | null>;
    readonly fixedLandedCostPerUnitInCompanyCurrency: Promise<decimal | null>;
    readonly costPriceInCompanyCurrency: Promise<decimal | null>;
    readonly purchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly lineStockCostInCompanyCurrency: Promise<decimal | null>;
    readonly linePurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly costStructure: Promise<string>;
    readonly companyCurrency: Reference<sageX3MasterData.nodes.Currency>;
    readonly totalStockCostInCompanyCurrency: Promise<decimal | null>;
    readonly totalPurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly isPartiallyInvoiced: Promise<boolean>;
    readonly invoiceLineTextKey: Promise<string>;
    readonly isExtractedLineFromIntrastat: Promise<boolean>;
    readonly isIntrastatPhysicalFlow: Promise<boolean>;
    readonly serviceStartDate: Promise<date | null>;
    readonly serviceEndDate: Promise<date | null>;
    readonly servicePeriodNumber: Promise<integer | null>;
    readonly servicePeriodType: Promise<sageX3InvoicingData.enums.PeriodicityType | null>;
    readonly lineType: Promise<sageX3PurchasingData.enums.OrderLineType | null>;
    readonly linkQuantityCoefficientForSubcontract: Promise<decimal | null>;
    readonly calculatedTaxExcludedLineAmount: Promise<decimal | null>;
    readonly vatDeclarationNumber: Promise<string>;
    readonly costUpdatedIfAdditionalInvoice: Promise<boolean>;
    readonly cost: Reference<sageX3Purchasing.nodes.Cost | null>;
    readonly isReconciled: Promise<boolean>;
    readonly productType: Promise<sageX3Purchasing.enums.PurchasingProductType | null>;
    readonly invoiceLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly invoiceLineText: Promise<TextStream>;
    readonly productStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseInvoiceLineProductStatisticalGroups>;
    readonly taxes: Collection<sageX3Purchasing.nodes.PurchaseInvoiceLineTaxes>;
}
//# sourceMappingURL=purchase-invoice-line.d.ts.map