"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQuantityInPurchaseUnitExpected = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
async function getQuantityInPurchaseUnitExpected(purchaseShipmentLine) {
    const quantityInPurchaseUnitShipped = Number(await purchaseShipmentLine.quantityInPurchaseUnitShipped);
    const quantityInPurchaseUnitReceived = Number(await purchaseShipmentLine.quantityInPurchaseUnitReceived);
    const quantityInPurchaseUnitPreReceived = Number(await purchaseShipmentLine.quantityInPurchaseUnitPreReceived);
    return typesLib.max(typesLib.mul((typesLib.sub(quantityInPurchaseUnitShipped, quantityInPurchaseUnitReceived)), Number(typesLib.strictEq(quantityInPurchaseUnitPreReceived, 0))), typesLib.mul((typesLib.sub(quantityInPurchaseUnitPreReceived, quantityInPurchaseUnitReceived)), Number(typesLib.strictNe(quantityInPurchaseUnitPreReceived, 0))));
}
exports.getQuantityInPurchaseUnitExpected = getQuantityInPurchaseUnitExpected;
//# sourceMappingURL=purchase-shipment-line-functions.js.map