"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readParameterValue = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const dialogs_1 = require("@sage/x3-master-data/lib/client-functions/dialogs");
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
async function readParameterValue(parameter, user, stockSite, pageInstance) {
    try {
        let resp;
        const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph
            .node('@sage/x3-system/GeneralParameter')
            .query(ui.queryUtils.edgesSelector({
            _id: true,
            definitionLevel: true,
            folderValue: true,
            valueType: true,
        }, {
            filter: {
                code: parameter,
            },
        }))
            .execute());
        // Call appropriate function depending on parameter level
        if (typesLib.strictEq(response[0].definitionLevel, 'user') && typesLib.strictEq(response[0].folderValue, false)) {
            if (typesLib.strictEq(response[0].valueType, 'alphanumeric')) {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/UserParameterValue')
                    .mutations.readParameterValueString({ value: true }, {
                    parameters: {
                        code: parameter,
                    },
                })
                    .execute();
                return resp.value;
            }
            else if (typesLib.strictEq(response[0].valueType, 'numeric') || typesLib.strictEq(response[0].valueType, 'localMenu')) {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/UserParameterValue')
                    .mutations.readParameterValueInteger({ value: true }, {
                    parameters: {
                        code: parameter,
                    },
                })
                    .execute();
                return resp.value;
            }
            else if (typesLib.strictEq(response[0].valueType, 'date')) {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/UserParameterValue')
                    .mutations.readParameterValueDate({ value: true }, {
                    parameters: {
                        code: parameter,
                    },
                })
                    .execute();
                return resp.value;
            }
        }
        else {
            if (typesLib.strictEq(response[0].valueType, 'alphanumeric')) {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/GeneralParametersData')
                    .mutations.readParameterValueString({ value: true }, {
                    parameters: {
                        company: '',
                        site: stockSite,
                        code: parameter,
                    },
                })
                    .execute();
                return resp.value;
            }
            else if (typesLib.strictEq(response[0].valueType, 'numeric') || typesLib.strictEq(response[0].valueType, 'localMenu')) {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/GeneralParametersData')
                    .mutations.readParameterValueInteger({ value: true }, {
                    parameters: {
                        company: '',
                        site: stockSite,
                        code: parameter,
                    },
                })
                    .execute();
                return resp.value;
            }
            else if (typesLib.strictEq(response[0].valueType, 'date')) {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/GeneralParametersData')
                    .mutations.readParameterValueDate({ value: true }, {
                    parameters: {
                        company: '',
                        site: stockSite,
                        code: parameter,
                    },
                })
                    .execute();
                return resp.value;
            }
            return '';
        }
    }
    catch (e) {
        await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing/utils-error-reading-parameter-value', 'Error reading parameter value: {{ param }}', { param: parameter }));
        return '';
    }
}
exports.readParameterValue = readParameterValue;
//# sourceMappingURL=read-parameter.js.map