declare module '@sage/x3-purchasing-api-partial' {
    import type {
        AutomaticJournal,
        Dimension,
        DimensionType,
        EntryType,
        Journal,
        Package as SageX3FinanceData$Package,
        SupplierInvoiceHeaderCurrencyRates,
        SupplierInvoiceHeaderCurrencyRatesInput,
        SupplierInvoiceHeaderDimensions,
        SupplierInvoiceHeaderDimensionsInput,
    } from '@sage/x3-finance-data-api';
    import type {
        EarlyDiscountLateCharge,
        Package as SageX3InvoicingData$Package,
        PaymentTerm,
        PurchaseInvoicingElement,
        SupplierInvoiceHeader,
        SupplierInvoiceHeaderBillBySupplierAddressLines,
        SupplierInvoiceHeaderBillBySupplierAddressLinesInput,
        SupplierInvoiceHeaderBillBySupplierCompanyNames,
        SupplierInvoiceHeaderBillBySupplierCompanyNamesInput,
        SupplierInvoiceHeaderComments,
        SupplierInvoiceHeaderCommentsInput,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLines,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput,
        SupplierInvoiceHeaderTaxes,
        SupplierInvoiceHeaderTaxesInput,
        Tax,
        TaxRule,
    } from '@sage/x3-invoicing-data-api';
    import type { Package as SageX3ManufacturingData$Package } from '@sage/x3-manufacturing-data-api';
    import type {
        BusinessPartner,
        BusinessPartnerAddress,
        Carrier,
        Container,
        Currency,
        Customer,
        Incoterm,
        Package as SageX3MasterData$Package,
        Product,
        SiteAddress,
        Supplier,
        SupplierAddress,
        SupplierProduct,
        TransitArea,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type {
        IntrastatStatisticalRule,
        IntrastatTransactionNature,
        Package as SageX3PhysicalFlowsData$Package,
    } from '@sage/x3-physical-flows-data-api';
    import type {
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type {
        DeliveryMode,
        FreightCostStructure,
        MatchingTolerance,
        Package as SageX3PurchasingData$Package,
        PurchaseInvoiceType,
        PurchasePriceReason,
    } from '@sage/x3-purchasing-data-api';
    import type {
        MajorVersionStatus,
        Package as SageX3StockData$Package,
        StockJournal,
        StockJournalInput,
        Warehouse,
    } from '@sage/x3-stock-data-api';
    import type { Country, Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type {
        Access,
        Company,
        Language,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        CreateOperation,
        GetDefaultsOperation,
        GetDuplicateOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface PurchaseInvoiceSource$Enum {
        order: 1;
        receipt: 2;
        return: 3;
        invoice: 4;
        miscellaneous: 5;
        shipment: 6;
    }
    export type PurchaseInvoiceSource = keyof PurchaseInvoiceSource$Enum;
    export interface PurchaseOrderType$Enum {
        order: 1;
        contract: 2;
    }
    export type PurchaseOrderType = keyof PurchaseOrderType$Enum;
    export interface PurchasingProductType$Enum {
        standard: 1;
        subcontract: 2;
        service: 3;
    }
    export type PurchasingProductType = keyof PurchasingProductType$Enum;
    export interface Cost extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        isActive: boolean;
    }
    export interface CostInput extends ClientNodeInput {
        code?: string;
        isActive?: boolean | string;
    }
    export interface CostBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        isActive: boolean;
    }
    export interface Cost$Operations {
        query: QueryOperation<Cost>;
        read: ReadOperation<Cost>;
        aggregate: {
            read: AggregateReadOperation<Cost>;
            query: AggregateQueryOperation<Cost>;
        };
        getDefaults: GetDefaultsOperation<Cost>;
    }
    export interface ProductSupplierView extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: string;
        supplier: string;
        product: string;
        description1: string;
        upc: string;
        globalTradeItemNumber: string;
        productStatus: ProductStatus;
        isReceived: boolean;
        isPurchased: boolean;
        isPhantom: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        productCategory: string;
        supplierProduct: string;
        supplierProductDescription: string;
        supplierUpc: string;
    }
    export interface ProductSupplierViewInput extends ClientNodeInput {
        stockSite?: string;
        supplier?: string;
        product?: string;
        description1?: string;
        upc?: string;
        globalTradeItemNumber?: string;
        productStatus?: ProductStatus;
        isReceived?: boolean | string;
        isPurchased?: boolean | string;
        isPhantom?: boolean | string;
        isDeliverable?: boolean | string;
        isSold?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        productCategory?: string;
        supplierProduct?: string;
        supplierProductDescription?: string;
        supplierUpc?: string;
    }
    export interface ProductSupplierViewBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: string;
        supplier: string;
        product: string;
        description1: string;
        upc: string;
        globalTradeItemNumber: string;
        productStatus: ProductStatus;
        isReceived: boolean;
        isPurchased: boolean;
        isPhantom: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        productCategory: string;
        supplierProduct: string;
        supplierProductDescription: string;
        supplierUpc: string;
    }
    export interface ProductSupplierView$Operations {
        query: QueryOperation<ProductSupplierView>;
        read: ReadOperation<ProductSupplierView>;
        aggregate: {
            read: AggregateReadOperation<ProductSupplierView>;
            query: AggregateQueryOperation<ProductSupplierView>;
        };
        getDefaults: GetDefaultsOperation<ProductSupplierView>;
    }
    export interface PurchaseEntryTransaction extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entryTransactionType: PurchaseDocumentType;
        code: string;
        accessCode: Access;
        isActive: boolean;
        identifier1Entry: EntryMode;
        identifier2Entry: EntryMode;
        identifier1Detail: EntryMode;
        identifier2Detail: EntryMode;
        isLotExpirationDateAllowed: boolean;
        isLotPotencyAllowed: boolean;
        isLotCustomField1Allowed: boolean;
        isLotCustomField2Allowed: boolean;
        isLotCustomField3Allowed: boolean;
        isLotCustomField4Allowed: boolean;
        defaultStockMovementGroup: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        stockMovementCode: MiscellaneousTable;
    }
    export interface PurchaseEntryTransactionInput extends ClientNodeInput {
        entryTransactionType?: PurchaseDocumentType;
        code?: string;
        accessCode?: string;
        isActive?: boolean | string;
        identifier1Entry?: EntryMode;
        identifier2Entry?: EntryMode;
        identifier1Detail?: EntryMode;
        identifier2Detail?: EntryMode;
        isLotExpirationDateAllowed?: boolean | string;
        isLotPotencyAllowed?: boolean | string;
        isLotCustomField1Allowed?: boolean | string;
        isLotCustomField2Allowed?: boolean | string;
        isLotCustomField3Allowed?: boolean | string;
        isLotCustomField4Allowed?: boolean | string;
        defaultStockMovementGroup?: string;
        stockAutomaticJournal?: string;
        stockMovementCode?: string;
    }
    export interface PurchaseEntryTransactionBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        entryTransactionType: PurchaseDocumentType;
        code: string;
        accessCode: Access;
        isActive: boolean;
        identifier1Entry: EntryMode;
        identifier2Entry: EntryMode;
        identifier1Detail: EntryMode;
        identifier2Detail: EntryMode;
        isLotExpirationDateAllowed: boolean;
        isLotPotencyAllowed: boolean;
        isLotCustomField1Allowed: boolean;
        isLotCustomField2Allowed: boolean;
        isLotCustomField3Allowed: boolean;
        isLotCustomField4Allowed: boolean;
        defaultStockMovementGroup: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        stockMovementCode: MiscellaneousTable;
    }
    export interface PurchaseEntryTransaction$Lookups {
        accessCode: QueryOperation<Access>;
        defaultStockMovementGroup: QueryOperation<MiscellaneousTable>;
        stockAutomaticJournal: QueryOperation<AutomaticJournal>;
        stockMovementCode: QueryOperation<MiscellaneousTable>;
    }
    export interface PurchaseEntryTransaction$Operations {
        query: QueryOperation<PurchaseEntryTransaction>;
        read: ReadOperation<PurchaseEntryTransaction>;
        aggregate: {
            read: AggregateReadOperation<PurchaseEntryTransaction>;
            query: AggregateQueryOperation<PurchaseEntryTransaction>;
        };
        lookups(dataOrId: string | { data: PurchaseEntryTransactionInput }): PurchaseEntryTransaction$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseEntryTransaction>;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineAllocationElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineAllocationElement: PurchaseInvoicingElement;
        distributionLineTax: Tax;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineAllocationElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        invoiceLineAllocationElement?: integer | string;
        distributionLineTax?: string;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineAllocationElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineAllocationElement: PurchaseInvoicingElement;
        distributionLineTax: Tax;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineAllocationElements$Lookups {
        invoiceLineAllocationElement: QueryOperation<PurchaseInvoicingElement>;
        distributionLineTax: QueryOperation<Tax>;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineAllocationElements$Operations {
        query: QueryOperation<PurchaseInvoiceHeaderInvoiceLineAllocationElements>;
        read: ReadOperation<PurchaseInvoiceHeaderInvoiceLineAllocationElements>;
        aggregate: {
            read: AggregateReadOperation<PurchaseInvoiceHeaderInvoiceLineAllocationElements>;
            query: AggregateQueryOperation<PurchaseInvoiceHeaderInvoiceLineAllocationElements>;
        };
        lookups(
            dataOrId: string | { data: PurchaseInvoiceHeaderInvoiceLineAllocationElementsInput },
        ): PurchaseInvoiceHeaderInvoiceLineAllocationElements$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseInvoiceHeaderInvoiceLineAllocationElements>;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineElement: PurchaseInvoicingElement;
        priceLineTax: Tax;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        invoiceLineElement?: integer | string;
        priceLineTax?: string;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineElement: PurchaseInvoicingElement;
        priceLineTax: Tax;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineElements$Lookups {
        invoiceLineElement: QueryOperation<PurchaseInvoicingElement>;
        priceLineTax: QueryOperation<Tax>;
    }
    export interface PurchaseInvoiceHeaderInvoiceLineElements$Operations {
        query: QueryOperation<PurchaseInvoiceHeaderInvoiceLineElements>;
        read: ReadOperation<PurchaseInvoiceHeaderInvoiceLineElements>;
        aggregate: {
            read: AggregateReadOperation<PurchaseInvoiceHeaderInvoiceLineElements>;
            query: AggregateQueryOperation<PurchaseInvoiceHeaderInvoiceLineElements>;
        };
        lookups(
            dataOrId: string | { data: PurchaseInvoiceHeaderInvoiceLineElementsInput },
        ): PurchaseInvoiceHeaderInvoiceLineElements$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseInvoiceHeaderInvoiceLineElements>;
    }
    export interface PurchaseInvoiceLineProductStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseInvoice: string;
        lineNumber: integer;
        value: MiscellaneousTable;
    }
    export interface PurchaseInvoiceLineProductStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        purchaseInvoice?: string;
        lineNumber?: integer | string;
        value?: string;
    }
    export interface PurchaseInvoiceLineProductStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseInvoice: string;
        lineNumber: integer;
        value: MiscellaneousTable;
    }
    export interface PurchaseInvoiceLineProductStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface PurchaseInvoiceLineProductStatisticalGroups$Operations {
        query: QueryOperation<PurchaseInvoiceLineProductStatisticalGroups>;
        read: ReadOperation<PurchaseInvoiceLineProductStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<PurchaseInvoiceLineProductStatisticalGroups>;
            query: AggregateQueryOperation<PurchaseInvoiceLineProductStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: PurchaseInvoiceLineProductStatisticalGroupsInput },
        ): PurchaseInvoiceLineProductStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseInvoiceLineProductStatisticalGroups>;
    }
    export interface PurchaseInvoiceLineTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseInvoice: string;
        lineNumber: integer;
        tax: Tax;
    }
    export interface PurchaseInvoiceLineTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        purchaseInvoice?: string;
        lineNumber?: integer | string;
        tax?: string;
    }
    export interface PurchaseInvoiceLineTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseInvoice: string;
        lineNumber: integer;
        tax: Tax;
    }
    export interface PurchaseInvoiceLineTaxes$Lookups {
        tax: QueryOperation<Tax>;
    }
    export interface PurchaseInvoiceLineTaxes$Operations {
        query: QueryOperation<PurchaseInvoiceLineTaxes>;
        read: ReadOperation<PurchaseInvoiceLineTaxes>;
        aggregate: {
            read: AggregateReadOperation<PurchaseInvoiceLineTaxes>;
            query: AggregateQueryOperation<PurchaseInvoiceLineTaxes>;
        };
        lookups(dataOrId: string | { data: PurchaseInvoiceLineTaxesInput }): PurchaseInvoiceLineTaxes$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseInvoiceLineTaxes>;
    }
    export interface PurchaseInvoiceLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseInvoice: SupplierInvoiceHeader;
        lineNumber: integer;
        category: InvoiceType;
        invoiceType: PurchaseInvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        company: Company;
        site: Site;
        accountingDate: string;
        billBySupplier: Supplier;
        lineSite: Site;
        sourceLine: PurchaseInvoiceSource;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        invoicingUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        stockUnitToPurchaseUnitConversionFactor: string;
        quantityInInvoiceUnitInvoiced: string;
        quantityInPurchaseUnitInvoiced: string;
        sourceQuantity: string;
        quantityInStockUnitInvoiced: string;
        weight: string;
        sourceWeight: string;
        weightUnit: UnitOfMeasure;
        volume: string;
        sourceVolume: string;
        volumeUnit: UnitOfMeasure;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        sourceNetPrice: string;
        purchaseType: PurchaseType;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        currency: Currency;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLine: PurchaseOrderLine;
        purchaseOrderSequenceNumber: integer;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseReturn: PurchaseReturn;
        purchaseReturnLine: PurchaseReturnLine;
        purchaseShipment: PurchaseShipment;
        purchaseShipmentLine: PurchaseShipmentLine;
        sourcePurchaseInvoice: SupplierInvoiceHeader;
        sourcePurchaseInvoiceLine: PurchaseInvoiceLine;
        supplier: Supplier;
        receiptDate: string;
        project: ProjectLink;
        issueRegion: MiscellaneousTable;
        receiptRegion: MiscellaneousTable;
        lineAmountExcludingTax: string;
        lineAmountIncludingTax: string;
        discountAmount: string;
        distributedInvoicingElementEarlyDiscountAmount1: string;
        distributedInvoicingElementEarlyDiscountAmount2: string;
        distributedInvoicingElementEarlyDiscountAmount3: string;
        distributedInvoicingElementEarlyDiscountAmount4: string;
        distributedInvoicingElementEarlyDiscountAmount5: string;
        distributedInvoicingElementEarlyDiscountAmount6: string;
        distributedInvoicingElementEarlyDiscountAmount7: string;
        distributedInvoicingElementEarlyDiscountAmount8: string;
        distributedInvoicingElementEarlyDiscountAmount9: string;
        quantityUncommitted: string;
        quantityActualCommitted: string;
        nonFinancialUnit: UnitOfMeasure;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        calculatedTaxableBase3: string;
        calculationBasisForReceiptTax: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        rebateOnTax1Amount: string;
        taxableBase1Amount: string;
        tax1amount: string;
        tax2amount: string;
        tax3amount: string;
        receiptTaxAmount: string;
        issueTaxAmount: string;
        otherTax1Amount: string;
        otherTax2Amount: string;
        tax1DeductibleAmount: string;
        tax2DeductibleAmount: string;
        tax3DeductibleAmount: string;
        receiptTaxDeductibleAmount: string;
        issueTaxDeductibleAmount: string;
        otherTax1DeductibleAmount: string;
        otherTax2DeductibleAmount: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        costPriceInCompanyCurrency: string;
        purchaseCostInCompanyCurrency: string;
        lineStockCostInCompanyCurrency: string;
        linePurchaseCostInCompanyCurrency: string;
        costStructure: string;
        companyCurrency: Currency;
        totalStockCostInCompanyCurrency: string;
        totalPurchaseCostInCompanyCurrency: string;
        isPartiallyInvoiced: boolean;
        isExtractedLineFromIntrastat: boolean;
        isIntrastatPhysicalFlow: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        lineType: OrderLineType;
        linkQuantityCoefficientForSubcontract: string;
        calculatedTaxExcludedLineAmount: string;
        vatDeclarationNumber: string;
        costUpdatedIfAdditionalInvoice: boolean;
        cost: Cost;
        isReconciled: boolean;
        productType: PurchasingProductType;
        invoiceLineText: TextStream;
        productStatisticalGroups: ClientCollection<PurchaseInvoiceLineProductStatisticalGroups>;
        taxes: ClientCollection<PurchaseInvoiceLineTaxes>;
    }
    export interface PurchaseInvoiceLineInput extends ClientNodeInput {
        purchaseInvoice?: string;
        lineNumber?: integer | string;
        category?: InvoiceType;
        invoiceType?: string;
        purchaseInvoiceCategory?: PurchaseInvoiceCategory;
        company?: string;
        site?: string;
        accountingDate?: string;
        billBySupplier?: string;
        lineSite?: string;
        sourceLine?: PurchaseInvoiceSource;
        sourceDocument?: string;
        sourceDocumentLineNumber?: integer | string;
        sourceDocumentSequenceNumber?: integer | string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInSupplierLanguage?: string;
        invoicingUnit?: string;
        purchaseUnit?: string;
        stockUnit?: string;
        stockUnitToPurchaseUnitConversionFactor?: decimal | string;
        quantityInInvoiceUnitInvoiced?: decimal | string;
        quantityInPurchaseUnitInvoiced?: decimal | string;
        sourceQuantity?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        weight?: decimal | string;
        sourceWeight?: decimal | string;
        weightUnit?: string;
        volume?: decimal | string;
        sourceVolume?: decimal | string;
        volumeUnit?: string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        netPrice?: decimal | string;
        sourceNetPrice?: decimal | string;
        purchaseType?: PurchaseType;
        distributedInvoicingElement1AmountExcludingTax?: decimal | string;
        distributedInvoicingElement2AmountExcludingTax?: decimal | string;
        distributedInvoicingElement3AmountExcludingTax?: decimal | string;
        distributedInvoicingElement4AmountExcludingTax?: decimal | string;
        distributedInvoicingElement5AmountExcludingTax?: decimal | string;
        distributedInvoicingElement6AmountExcludingTax?: decimal | string;
        distributedInvoicingElement7AmountExcludingTax?: decimal | string;
        distributedInvoicingElement8AmountExcludingTax?: decimal | string;
        distributedInvoicingElement9AmountExcludingTax?: decimal | string;
        currency?: string;
        purchaseOrder?: string;
        purchaseOrderLine?: integer | string;
        purchaseOrderSequenceNumber?: integer | string;
        purchaseReceipt?: string;
        purchaseReceiptLine?: integer | string;
        purchaseReturn?: string;
        purchaseReturnLine?: integer | string;
        purchaseShipment?: string;
        purchaseShipmentLine?: integer | string;
        sourcePurchaseInvoice?: string;
        sourcePurchaseInvoiceLine?: integer | string;
        supplier?: string;
        receiptDate?: string;
        project?: string;
        issueRegion?: string;
        receiptRegion?: string;
        lineAmountExcludingTax?: decimal | string;
        lineAmountIncludingTax?: decimal | string;
        discountAmount?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount1?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount2?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount3?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount4?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount5?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount6?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount7?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount8?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount9?: decimal | string;
        quantityUncommitted?: decimal | string;
        quantityActualCommitted?: decimal | string;
        nonFinancialUnit?: string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        calculatedTaxableBase3?: decimal | string;
        calculationBasisForReceiptTax?: decimal | string;
        calculationBasisForIssueTax?: decimal | string;
        calculationBasisForOtherTax1?: decimal | string;
        calculationBasisForOtherTax2?: decimal | string;
        rebateOnTax1Amount?: decimal | string;
        taxableBase1Amount?: decimal | string;
        tax1amount?: decimal | string;
        tax2amount?: decimal | string;
        tax3amount?: decimal | string;
        receiptTaxAmount?: decimal | string;
        issueTaxAmount?: decimal | string;
        otherTax1Amount?: decimal | string;
        otherTax2Amount?: decimal | string;
        tax1DeductibleAmount?: decimal | string;
        tax2DeductibleAmount?: decimal | string;
        tax3DeductibleAmount?: decimal | string;
        receiptTaxDeductibleAmount?: decimal | string;
        issueTaxDeductibleAmount?: decimal | string;
        otherTax1DeductibleAmount?: decimal | string;
        otherTax2DeductibleAmount?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnitInCompanyCurrency?: decimal | string;
        costPriceInCompanyCurrency?: decimal | string;
        purchaseCostInCompanyCurrency?: decimal | string;
        lineStockCostInCompanyCurrency?: decimal | string;
        linePurchaseCostInCompanyCurrency?: decimal | string;
        costStructure?: string;
        companyCurrency?: string;
        totalStockCostInCompanyCurrency?: decimal | string;
        totalPurchaseCostInCompanyCurrency?: decimal | string;
        isPartiallyInvoiced?: boolean | string;
        isExtractedLineFromIntrastat?: boolean | string;
        isIntrastatPhysicalFlow?: boolean | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        servicePeriodNumber?: integer | string;
        servicePeriodType?: PeriodicityType;
        lineType?: OrderLineType;
        linkQuantityCoefficientForSubcontract?: decimal | string;
        calculatedTaxExcludedLineAmount?: decimal | string;
        vatDeclarationNumber?: string;
        costUpdatedIfAdditionalInvoice?: boolean | string;
        cost?: string;
        isReconciled?: boolean | string;
        productType?: PurchasingProductType;
        invoiceLineText?: TextStream;
        productStatisticalGroups?: Partial<PurchaseInvoiceLineProductStatisticalGroupsInput>[];
        taxes?: Partial<PurchaseInvoiceLineTaxesInput>[];
    }
    export interface PurchaseInvoiceLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseInvoice: SupplierInvoiceHeader;
        lineNumber: integer;
        category: InvoiceType;
        invoiceType: PurchaseInvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        company: Company;
        site: Site;
        accountingDate: string;
        billBySupplier: Supplier;
        lineSite: Site;
        sourceLine: PurchaseInvoiceSource;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        invoicingUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        stockUnitToPurchaseUnitConversionFactor: string;
        quantityInInvoiceUnitInvoiced: string;
        quantityInPurchaseUnitInvoiced: string;
        sourceQuantity: string;
        quantityInStockUnitInvoiced: string;
        weight: string;
        sourceWeight: string;
        weightUnit: UnitOfMeasure;
        volume: string;
        sourceVolume: string;
        volumeUnit: UnitOfMeasure;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        sourceNetPrice: string;
        purchaseType: PurchaseType;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        currency: Currency;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLine: PurchaseOrderLine;
        purchaseOrderSequenceNumber: integer;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseReturn: PurchaseReturn;
        purchaseReturnLine: PurchaseReturnLine;
        purchaseShipment: PurchaseShipment;
        purchaseShipmentLine: PurchaseShipmentLine;
        sourcePurchaseInvoice: SupplierInvoiceHeader;
        sourcePurchaseInvoiceLine: PurchaseInvoiceLine;
        supplier: Supplier;
        receiptDate: string;
        project: ProjectLink;
        issueRegion: MiscellaneousTable;
        receiptRegion: MiscellaneousTable;
        lineAmountExcludingTax: string;
        lineAmountIncludingTax: string;
        discountAmount: string;
        distributedInvoicingElementEarlyDiscountAmount1: string;
        distributedInvoicingElementEarlyDiscountAmount2: string;
        distributedInvoicingElementEarlyDiscountAmount3: string;
        distributedInvoicingElementEarlyDiscountAmount4: string;
        distributedInvoicingElementEarlyDiscountAmount5: string;
        distributedInvoicingElementEarlyDiscountAmount6: string;
        distributedInvoicingElementEarlyDiscountAmount7: string;
        distributedInvoicingElementEarlyDiscountAmount8: string;
        distributedInvoicingElementEarlyDiscountAmount9: string;
        quantityUncommitted: string;
        quantityActualCommitted: string;
        nonFinancialUnit: UnitOfMeasure;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        calculatedTaxableBase3: string;
        calculationBasisForReceiptTax: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        rebateOnTax1Amount: string;
        taxableBase1Amount: string;
        tax1amount: string;
        tax2amount: string;
        tax3amount: string;
        receiptTaxAmount: string;
        issueTaxAmount: string;
        otherTax1Amount: string;
        otherTax2Amount: string;
        tax1DeductibleAmount: string;
        tax2DeductibleAmount: string;
        tax3DeductibleAmount: string;
        receiptTaxDeductibleAmount: string;
        issueTaxDeductibleAmount: string;
        otherTax1DeductibleAmount: string;
        otherTax2DeductibleAmount: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        costPriceInCompanyCurrency: string;
        purchaseCostInCompanyCurrency: string;
        lineStockCostInCompanyCurrency: string;
        linePurchaseCostInCompanyCurrency: string;
        costStructure: string;
        companyCurrency: Currency;
        totalStockCostInCompanyCurrency: string;
        totalPurchaseCostInCompanyCurrency: string;
        isPartiallyInvoiced: boolean;
        isExtractedLineFromIntrastat: boolean;
        isIntrastatPhysicalFlow: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        lineType: OrderLineType;
        linkQuantityCoefficientForSubcontract: string;
        calculatedTaxExcludedLineAmount: string;
        vatDeclarationNumber: string;
        costUpdatedIfAdditionalInvoice: boolean;
        cost: Cost;
        isReconciled: boolean;
        productType: PurchasingProductType;
        invoiceLineText: TextStream;
        productStatisticalGroups: ClientCollection<PurchaseInvoiceLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<PurchaseInvoiceLineTaxesBinding>;
    }
    export interface PurchaseInvoiceLine$Lookups {
        purchaseInvoice: QueryOperation<SupplierInvoiceHeader>;
        invoiceType: QueryOperation<PurchaseInvoiceType>;
        company: QueryOperation<Company>;
        site: QueryOperation<Site>;
        billBySupplier: QueryOperation<Supplier>;
        lineSite: QueryOperation<Site>;
        product: QueryOperation<Product>;
        invoicingUnit: QueryOperation<UnitOfMeasure>;
        purchaseUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        priceReason: QueryOperation<PurchasePriceReason>;
        discountOrCharge1Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge2Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge3Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge4Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge5Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge6Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge7Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge8Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge9Reason: QueryOperation<PurchasePriceReason>;
        currency: QueryOperation<Currency>;
        purchaseOrder: QueryOperation<PurchaseOrder>;
        purchaseOrderLine: QueryOperation<PurchaseOrderLine>;
        purchaseReceipt: QueryOperation<PurchaseReceipt>;
        purchaseReceiptLine: QueryOperation<PurchaseReceiptLine>;
        purchaseReturn: QueryOperation<PurchaseReturn>;
        purchaseReturnLine: QueryOperation<PurchaseReturnLine>;
        purchaseShipment: QueryOperation<PurchaseShipment>;
        purchaseShipmentLine: QueryOperation<PurchaseShipmentLine>;
        sourcePurchaseInvoice: QueryOperation<SupplierInvoiceHeader>;
        sourcePurchaseInvoiceLine: QueryOperation<PurchaseInvoiceLine>;
        supplier: QueryOperation<Supplier>;
        project: QueryOperation<ProjectLink>;
        issueRegion: QueryOperation<MiscellaneousTable>;
        receiptRegion: QueryOperation<MiscellaneousTable>;
        nonFinancialUnit: QueryOperation<UnitOfMeasure>;
        companyCurrency: QueryOperation<Currency>;
        cost: QueryOperation<Cost>;
    }
    export interface PurchaseInvoiceLine$Operations {
        query: QueryOperation<PurchaseInvoiceLine>;
        read: ReadOperation<PurchaseInvoiceLine>;
        aggregate: {
            read: AggregateReadOperation<PurchaseInvoiceLine>;
            query: AggregateQueryOperation<PurchaseInvoiceLine>;
        };
        lookups(dataOrId: string | { data: PurchaseInvoiceLineInput }): PurchaseInvoiceLine$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseInvoiceLine>;
    }
    export interface PurchaseInvoiceSupplierStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface PurchaseInvoiceSupplierStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        value?: string;
    }
    export interface PurchaseInvoiceSupplierStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface PurchaseInvoiceSupplierStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface PurchaseInvoiceSupplierStatisticalGroups$Operations {
        query: QueryOperation<PurchaseInvoiceSupplierStatisticalGroups>;
        read: ReadOperation<PurchaseInvoiceSupplierStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<PurchaseInvoiceSupplierStatisticalGroups>;
            query: AggregateQueryOperation<PurchaseInvoiceSupplierStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: PurchaseInvoiceSupplierStatisticalGroupsInput },
        ): PurchaseInvoiceSupplierStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseInvoiceSupplierStatisticalGroups>;
    }
    export interface PurchaseInvoice extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: SupplierInvoiceHeader;
        category: InvoiceType;
        invoiceType: PurchaseInvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        billBySupplier: Supplier;
        currency: Currency;
        numberOfLines: integer;
        numberOfLinesWithDifferentQuantity: integer;
        numberOfLinesWithDifferentPrice: integer;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalQuantityOfLines: string;
        amountOfLinesExcludingTax: string;
        calculatedLineAmountExcludingTax: string;
        totalTaxAmount: string;
        billBySupplierLanguage: Language;
        companyLanguage: Language;
        company: Company;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        isIntercompany: boolean;
        billToCustomer: Customer;
        purchaseInvoiceLines: ClientCollection<PurchaseInvoiceLine>;
        supplierInvoiceHeader: SupplierInvoiceHeader;
        accountingDate: string;
        billBySupplierAddress: SupplierAddress;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        billBySupplierCity: string;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        billBySupplierPostalCode: string;
        billBySupplierState: string;
        cashVatTaxRule: boolean;
        comments: ClientCollection<SupplierInvoiceHeaderComments>;
        control: string;
        currencyRates: ClientCollection<SupplierInvoiceHeaderCurrencyRates>;
        debitOrCredit: integer;
        derCode: string;
        dimensions: ClientCollection<SupplierInvoiceHeaderDimensions>;
        dueDateCalculationStartDate: string;
        earlyDiscountOrLateChargeBasis: string;
        earlyDiscountOrLateChargeRate: string;
        entryType: EntryType;
        europeanUnionIdentification: string;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        fiscalYear: integer;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        incoterm: Incoterm;
        incotermTown: string;
        internalNumber: integer;
        internalReference: string;
        intrastatProcessingNumber: integer;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        invoiceFooterText: TextStream;
        invoiceHeaderText: TextStream;
        isDas2Submitted: boolean;
        isEuropeanUnionInvoice: boolean;
        journal: Journal;
        lastServiceAccountedDate: string;
        matchStatus: MatchStatusEnum;
        numberOfTaxes: integer;
        originalDocumentNumber: string;
        originalInvoiceNumber: string;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerState: string;
        paymentApproval: PaymentApprovalType;
        paymentTerm: PaymentTerm;
        period: integer;
        priceOrAmountType: PriceAmountTaxTax;
        project: ProjectLink;
        rateDate: string;
        rateType: ExchangeRateType;
        serviceEndDate: string;
        serviceStartDate: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        site: Site;
        sourceDocumentDate: string;
        sourceModule: ModuleTable;
        status: PurchasingInvoiceStatus;
        supplierSourceDocument: string;
        taxReferenceDate: string;
        taxRule: TaxRule;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxes>;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        versionControlSystemNumber: string;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseInvoiceHeaderInvoiceLineAllocationElements>;
        headerInvoiceLineElements: ClientCollection<PurchaseInvoiceHeaderInvoiceLineElements>;
        supplierStatisticalGroups: ClientCollection<PurchaseInvoiceSupplierStatisticalGroups>;
    }
    export interface PurchaseInvoiceInput extends ClientNodeInput {
        id?: string;
        category?: InvoiceType;
        invoiceType?: string;
        purchaseInvoiceCategory?: PurchaseInvoiceCategory;
        billBySupplier?: string;
        currency?: string;
        numberOfLines?: integer | string;
        numberOfLinesWithDifferentQuantity?: integer | string;
        numberOfLinesWithDifferentPrice?: integer | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        totalWeightOfLines?: decimal | string;
        totalVolumeOfLines?: decimal | string;
        totalQuantityOfLines?: decimal | string;
        amountOfLinesExcludingTax?: decimal | string;
        calculatedLineAmountExcludingTax?: decimal | string;
        totalTaxAmount?: decimal | string;
        billBySupplierLanguage?: string;
        companyLanguage?: string;
        company?: string;
        earlyDiscountOrLateCharge?: string;
        isIntercompany?: boolean | string;
        billToCustomer?: string;
        purchaseInvoiceLines?: Partial<PurchaseInvoiceLineInput>[];
        supplierInvoiceHeader?: string;
        accountingDate?: string;
        billBySupplierAddress?: string;
        billBySupplierAddressLines?: Partial<SupplierInvoiceHeaderBillBySupplierAddressLinesInput>[];
        billBySupplierCity?: string;
        billBySupplierCompanyNames?: Partial<SupplierInvoiceHeaderBillBySupplierCompanyNamesInput>[];
        billBySupplierCountry?: string;
        billBySupplierCountryName?: string;
        billBySupplierPostalCode?: string;
        billBySupplierState?: string;
        cashVatTaxRule?: boolean | string;
        comments?: Partial<SupplierInvoiceHeaderCommentsInput>[];
        control?: string;
        currencyRates?: Partial<SupplierInvoiceHeaderCurrencyRatesInput>[];
        debitOrCredit?: integer | string;
        derCode?: string;
        dimensions?: Partial<SupplierInvoiceHeaderDimensionsInput>[];
        dueDateCalculationStartDate?: string;
        earlyDiscountOrLateChargeBasis?: decimal | string;
        earlyDiscountOrLateChargeRate?: decimal | string;
        entryType?: string;
        europeanUnionIdentification?: string;
        field40Reason?: string;
        field41Reason?: string;
        fiscalYear?: integer | string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        incoterm?: string;
        incotermTown?: string;
        internalNumber?: integer | string;
        internalReference?: string;
        intrastatProcessingNumber?: integer | string;
        intrastatStatisticalRule?: string;
        intrastatTransactionNature?: string;
        intrastatTransportLocation?: CountryLocation;
        intrastatTransportMode?: IntrastatTransportMode;
        invoiceFooterText?: TextStream;
        invoiceHeaderText?: TextStream;
        isDas2Submitted?: boolean | string;
        isEuropeanUnionInvoice?: boolean | string;
        journal?: string;
        lastServiceAccountedDate?: string;
        matchStatus?: MatchStatusEnum;
        numberOfTaxes?: integer | string;
        originalDocumentNumber?: string;
        originalInvoiceNumber?: string;
        payToBusinessPartner?: string;
        payToBusinessPartnerAddress?: string;
        payToBusinessPartnerAddressLines?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput>[];
        payToBusinessPartnerCity?: string;
        payToBusinessPartnerCompanyNames?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput>[];
        payToBusinessPartnerCountry?: string;
        payToBusinessPartnerCountryName?: string;
        payToBusinessPartnerPostalCode?: string;
        payToBusinessPartnerState?: string;
        paymentApproval?: PaymentApprovalType;
        paymentTerm?: string;
        period?: integer | string;
        priceOrAmountType?: PriceAmountTaxTax;
        project?: string;
        rateDate?: string;
        rateType?: ExchangeRateType;
        serviceEndDate?: string;
        serviceStartDate?: string;
        singleCustomsDocumentBusinessPartnerCode?: string;
        singleCustomsDocumentDate?: string;
        singleCustomsDocumentReference?: string;
        site?: string;
        sourceDocumentDate?: string;
        sourceModule?: ModuleTable;
        status?: PurchasingInvoiceStatus;
        supplierSourceDocument?: string;
        taxReferenceDate?: string;
        taxRule?: string;
        taxes?: Partial<SupplierInvoiceHeaderTaxesInput>[];
        totalAmountExcludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        versionControlSystemNumber?: string;
        headerInvoiceLineAllocationElements?: Partial<PurchaseInvoiceHeaderInvoiceLineAllocationElementsInput>[];
        headerInvoiceLineElements?: Partial<PurchaseInvoiceHeaderInvoiceLineElementsInput>[];
        supplierStatisticalGroups?: Partial<PurchaseInvoiceSupplierStatisticalGroupsInput>[];
    }
    export interface PurchaseInvoiceBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: SupplierInvoiceHeader;
        category: InvoiceType;
        invoiceType: PurchaseInvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        billBySupplier: Supplier;
        currency: Currency;
        numberOfLines: integer;
        numberOfLinesWithDifferentQuantity: integer;
        numberOfLinesWithDifferentPrice: integer;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalQuantityOfLines: string;
        amountOfLinesExcludingTax: string;
        calculatedLineAmountExcludingTax: string;
        totalTaxAmount: string;
        billBySupplierLanguage: Language;
        companyLanguage: Language;
        company: Company;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        isIntercompany: boolean;
        billToCustomer: Customer;
        purchaseInvoiceLines: ClientCollection<PurchaseInvoiceLine>;
        supplierInvoiceHeader: SupplierInvoiceHeader;
        accountingDate: string;
        billBySupplierAddress: SupplierAddress;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        billBySupplierCity: string;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        billBySupplierPostalCode: string;
        billBySupplierState: string;
        cashVatTaxRule: boolean;
        comments: ClientCollection<SupplierInvoiceHeaderComments>;
        control: string;
        currencyRates: ClientCollection<SupplierInvoiceHeaderCurrencyRates>;
        debitOrCredit: integer;
        derCode: string;
        dimensions: ClientCollection<SupplierInvoiceHeaderDimensions>;
        dueDateCalculationStartDate: string;
        earlyDiscountOrLateChargeBasis: string;
        earlyDiscountOrLateChargeRate: string;
        entryType: EntryType;
        europeanUnionIdentification: string;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        fiscalYear: integer;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        incoterm: Incoterm;
        incotermTown: string;
        internalNumber: integer;
        internalReference: string;
        intrastatProcessingNumber: integer;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        invoiceFooterText: TextStream;
        invoiceHeaderText: TextStream;
        isDas2Submitted: boolean;
        isEuropeanUnionInvoice: boolean;
        journal: Journal;
        lastServiceAccountedDate: string;
        matchStatus: MatchStatusEnum;
        numberOfTaxes: integer;
        originalDocumentNumber: string;
        originalInvoiceNumber: string;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerState: string;
        paymentApproval: PaymentApprovalType;
        paymentTerm: PaymentTerm;
        period: integer;
        priceOrAmountType: PriceAmountTaxTax;
        project: ProjectLink;
        rateDate: string;
        rateType: ExchangeRateType;
        serviceEndDate: string;
        serviceStartDate: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        site: Site;
        sourceDocumentDate: string;
        sourceModule: ModuleTable;
        status: PurchasingInvoiceStatus;
        supplierSourceDocument: string;
        taxReferenceDate: string;
        taxRule: TaxRule;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxes>;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        versionControlSystemNumber: string;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseInvoiceHeaderInvoiceLineAllocationElementsBinding>;
        headerInvoiceLineElements: ClientCollection<PurchaseInvoiceHeaderInvoiceLineElementsBinding>;
        supplierStatisticalGroups: ClientCollection<PurchaseInvoiceSupplierStatisticalGroupsBinding>;
    }
    export interface PurchaseInvoice$Lookups {
        id: QueryOperation<SupplierInvoiceHeader>;
        invoiceType: QueryOperation<PurchaseInvoiceType>;
        billBySupplier: QueryOperation<Supplier>;
        currency: QueryOperation<Currency>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        billBySupplierLanguage: QueryOperation<Language>;
        companyLanguage: QueryOperation<Language>;
        company: QueryOperation<Company>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        billToCustomer: QueryOperation<Customer>;
        supplierInvoiceHeader: QueryOperation<SupplierInvoiceHeader>;
        billBySupplierAddress: QueryOperation<SupplierAddress>;
        billBySupplierCountry: QueryOperation<Country>;
        entryType: QueryOperation<EntryType>;
        field40Reason: QueryOperation<MiscellaneousTable>;
        field41Reason: QueryOperation<MiscellaneousTable>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<SupplierAddress>;
        incoterm: QueryOperation<Incoterm>;
        intrastatStatisticalRule: QueryOperation<IntrastatStatisticalRule>;
        intrastatTransactionNature: QueryOperation<IntrastatTransactionNature>;
        journal: QueryOperation<Journal>;
        payToBusinessPartner: QueryOperation<BusinessPartner>;
        payToBusinessPartnerAddress: QueryOperation<BusinessPartnerAddress>;
        payToBusinessPartnerCountry: QueryOperation<Country>;
        paymentTerm: QueryOperation<PaymentTerm>;
        project: QueryOperation<ProjectLink>;
        singleCustomsDocumentBusinessPartnerCode: QueryOperation<Supplier>;
        site: QueryOperation<Site>;
        taxRule: QueryOperation<TaxRule>;
    }
    export interface PurchaseInvoice$Operations {
        query: QueryOperation<PurchaseInvoice>;
        read: ReadOperation<PurchaseInvoice>;
        aggregate: {
            read: AggregateReadOperation<PurchaseInvoice>;
            query: AggregateQueryOperation<PurchaseInvoice>;
        };
        create: CreateOperation<PurchaseInvoiceInput, PurchaseInvoice>;
        getDuplicate: GetDuplicateOperation<PurchaseInvoice>;
        lookups(dataOrId: string | { data: PurchaseInvoiceInput }): PurchaseInvoice$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseInvoice>;
    }
    export interface PurchaseOrderCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface PurchaseOrderCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface PurchaseOrderCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface PurchaseOrderCompanyNames$Operations {
        query: QueryOperation<PurchaseOrderCompanyNames>;
        read: ReadOperation<PurchaseOrderCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderCompanyNames>;
            query: AggregateQueryOperation<PurchaseOrderCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<PurchaseOrderCompanyNames>;
    }
    export interface PurchaseOrderDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface PurchaseOrderDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        dimensionType?: string;
        dimension?: string;
    }
    export interface PurchaseOrderDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface PurchaseOrderDimensions$Lookups {
        dimensionType: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface PurchaseOrderDimensions$Operations {
        query: QueryOperation<PurchaseOrderDimensions>;
        read: ReadOperation<PurchaseOrderDimensions>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderDimensions>;
            query: AggregateQueryOperation<PurchaseOrderDimensions>;
        };
        lookups(dataOrId: string | { data: PurchaseOrderDimensionsInput }): PurchaseOrderDimensions$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseOrderDimensions>;
    }
    export interface PurchaseOrderDiscountOrChargeCalculationRules extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoiceLineElement: PurchaseInvoicingElement;
        priceLineTax: Tax;
    }
    export interface PurchaseOrderDiscountOrChargeCalculationRulesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        type?: DiscountCalculationRules;
        invoiceLineElement?: integer | string;
        priceLineTax?: string;
    }
    export interface PurchaseOrderDiscountOrChargeCalculationRulesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        type: DiscountCalculationRules;
        invoiceLineElement: PurchaseInvoicingElement;
        priceLineTax: Tax;
    }
    export interface PurchaseOrderDiscountOrChargeCalculationRules$Lookups {
        invoiceLineElement: QueryOperation<PurchaseInvoicingElement>;
        priceLineTax: QueryOperation<Tax>;
    }
    export interface PurchaseOrderDiscountOrChargeCalculationRules$Operations {
        query: QueryOperation<PurchaseOrderDiscountOrChargeCalculationRules>;
        read: ReadOperation<PurchaseOrderDiscountOrChargeCalculationRules>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderDiscountOrChargeCalculationRules>;
            query: AggregateQueryOperation<PurchaseOrderDiscountOrChargeCalculationRules>;
        };
        lookups(
            dataOrId: string | { data: PurchaseOrderDiscountOrChargeCalculationRulesInput },
        ): PurchaseOrderDiscountOrChargeCalculationRules$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseOrderDiscountOrChargeCalculationRules>;
    }
    export interface PurchaseOrderFromSupplierAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface PurchaseOrderFromSupplierAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface PurchaseOrderFromSupplierAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface PurchaseOrderFromSupplierAddressLines$Operations {
        query: QueryOperation<PurchaseOrderFromSupplierAddressLines>;
        read: ReadOperation<PurchaseOrderFromSupplierAddressLines>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderFromSupplierAddressLines>;
            query: AggregateQueryOperation<PurchaseOrderFromSupplierAddressLines>;
        };
        getDefaults: GetDefaultsOperation<PurchaseOrderFromSupplierAddressLines>;
    }
    export interface PurchaseOrderFromSupplierCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface PurchaseOrderFromSupplierCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface PurchaseOrderFromSupplierCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface PurchaseOrderFromSupplierCompanyNames$Operations {
        query: QueryOperation<PurchaseOrderFromSupplierCompanyNames>;
        read: ReadOperation<PurchaseOrderFromSupplierCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderFromSupplierCompanyNames>;
            query: AggregateQueryOperation<PurchaseOrderFromSupplierCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<PurchaseOrderFromSupplierCompanyNames>;
    }
    export interface PurchaseOrderHeaderInvoiceLineAllocationElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineAllocationElement: PurchaseInvoicingElement;
        distributionLineTax: Tax;
    }
    export interface PurchaseOrderHeaderInvoiceLineAllocationElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        invoiceLineAllocationElement?: integer | string;
        distributionLineTax?: string;
    }
    export interface PurchaseOrderHeaderInvoiceLineAllocationElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineAllocationElement: PurchaseInvoicingElement;
        distributionLineTax: Tax;
    }
    export interface PurchaseOrderHeaderInvoiceLineAllocationElements$Lookups {
        invoiceLineAllocationElement: QueryOperation<PurchaseInvoicingElement>;
        distributionLineTax: QueryOperation<Tax>;
    }
    export interface PurchaseOrderHeaderInvoiceLineAllocationElements$Operations {
        query: QueryOperation<PurchaseOrderHeaderInvoiceLineAllocationElements>;
        read: ReadOperation<PurchaseOrderHeaderInvoiceLineAllocationElements>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderHeaderInvoiceLineAllocationElements>;
            query: AggregateQueryOperation<PurchaseOrderHeaderInvoiceLineAllocationElements>;
        };
        lookups(
            dataOrId: string | { data: PurchaseOrderHeaderInvoiceLineAllocationElementsInput },
        ): PurchaseOrderHeaderInvoiceLineAllocationElements$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseOrderHeaderInvoiceLineAllocationElements>;
    }
    export interface PurchaseOrderLineProductStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        value: MiscellaneousTable;
    }
    export interface PurchaseOrderLineProductStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        purchaseOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        value?: string;
    }
    export interface PurchaseOrderLineProductStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        value: MiscellaneousTable;
    }
    export interface PurchaseOrderLineProductStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface PurchaseOrderLineProductStatisticalGroups$Operations {
        query: QueryOperation<PurchaseOrderLineProductStatisticalGroups>;
        read: ReadOperation<PurchaseOrderLineProductStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderLineProductStatisticalGroups>;
            query: AggregateQueryOperation<PurchaseOrderLineProductStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: PurchaseOrderLineProductStatisticalGroupsInput },
        ): PurchaseOrderLineProductStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseOrderLineProductStatisticalGroups>;
    }
    export interface PurchaseOrderLineTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        tax: Tax;
    }
    export interface PurchaseOrderLineTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        purchaseOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        tax?: string;
    }
    export interface PurchaseOrderLineTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        tax: Tax;
    }
    export interface PurchaseOrderLineTaxes$Lookups {
        tax: QueryOperation<Tax>;
    }
    export interface PurchaseOrderLineTaxes$Operations {
        query: QueryOperation<PurchaseOrderLineTaxes>;
        read: ReadOperation<PurchaseOrderLineTaxes>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderLineTaxes>;
            query: AggregateQueryOperation<PurchaseOrderLineTaxes>;
        };
        lookups(dataOrId: string | { data: PurchaseOrderLineTaxesInput }): PurchaseOrderLineTaxes$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseOrderLineTaxes>;
    }
    export interface PurchaseOrderLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseOrder: PurchaseOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        buyer: User;
        receiptSite: Site;
        receiptAddress: SiteAddress;
        project: ProjectLink;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        hasQualityControlManagement: boolean;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        matchingTolerance: MatchingTolerance;
        acknowledgementDate: string;
        acknowledgementNumber: string;
        acknowledgementUpdate: integer;
        actualPurchaseCostInCompanyCurrency: string;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        calculatedBasisForTax3: string;
        calculatedTaxBasis1: string;
        calculatedTaxBasis2: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        calculationBasisForReceiptTax: string;
        commitmentGenerated: integer;
        commitmentType: CommitmentType;
        companyCurrency: Currency;
        costPriceWithoutLandedCost: string;
        costStructure: FreightCostStructure;
        currency: Currency;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        expectedReceiptDate: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        interCompanySalesOrderLineNumber: integer;
        interCompanySalesOrderSequenceNumber: integer;
        isBudgetOverrun: boolean;
        isClosed: boolean;
        isClosedByReceipt: boolean;
        isInOrderUnit: boolean;
        isInvoiced: boolean;
        isPrinted: boolean;
        issueTaxAmount: string;
        issueTaxDeductibleAmount: string;
        landedCostCoefficient: string;
        lastReceiptDate: string;
        lastSalesInvoiceDate: string;
        lineAmountIncludingTax: string;
        lineAndSequenceIndex: string;
        lineOrderAmountIncludingTax: string;
        linePurchaseCostInCompanyCurrency: string;
        lineStatus: LineStatus;
        lineStockCostInCompanyCurrency: string;
        lineType: OrderLineType;
        linkCoefficientForSubcontract: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        numberOfInvoicedReceipts: integer;
        numberOfInvoices: integer;
        numberOfReceipts: integer;
        orderDate: string;
        orderFromSupplier: Supplier;
        orderLineText: TextStream;
        orderUnit: UnitOfMeasure;
        orderUnitToPurchaseUnitConversionFactor: string;
        otherTax1Amount: string;
        otherTax1DeductibleAmount: string;
        otherTax2Amount: string;
        otherTax2DeductibleAmount: string;
        productType: PurchasingProductType;
        purchaseCostInCompanyCurrency: string;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseSite: Site;
        purchaseType: PurchaseType;
        purchaseUnit: UnitOfMeasure;
        quantityInOrderUnitOrdered: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInPurchaseUnitOrdered: string;
        quantityInPurchaseUnitReceived: string;
        quantityInPurchaseUnitRequired: string;
        quantityInPurchaseUnitShippedNotReceived: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitReceived: string;
        quantityInStockUnitRequired: string;
        quantityInStockUnitShippedNotReceived: string;
        rebateOnTax1Amount: string;
        receiptTaxAmount: string;
        receiptTaxDeductibleAmount: string;
        releasedProduct: Product;
        reorderLeadTime: string;
        requestForQuotation: string;
        requestForQuotationResponseLineNumber: integer;
        requestedDeliveryEndDate: string;
        requestedDeliveryEndTime: integer;
        requestedDeliveryStartDate: string;
        requestedDeliveryStartTime: integer;
        requirementDate: string;
        shippingSite: Site;
        sourceDocumentLineNumber: integer;
        sourceDocumentNumber: string;
        sourceDocumentSequenceNumber: integer;
        sourceDocumentType: EntryTypeEnum;
        sourceRequest: RequestSource;
        stockCostInCompanyCurrency: string;
        stockUnit: UnitOfMeasure;
        subcontractAddress: SupplierAddress;
        supplierProduct: SupplierProduct;
        tax1BasisAmount: string;
        tax1DeductibleAmount: string;
        tax1amount: string;
        tax2DeductibleAmount: string;
        tax2amount: string;
        tax3DeductibleAmount: string;
        tax3amount: string;
        taxExcludedLineAmount: string;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        volume: string;
        volumeUnit: UnitOfMeasure;
        weight: string;
        weightUnit: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workOrderInProgressStatus: StatusInProgress;
        workOrderInProgressType: WorkOrderType;
        productStatisticalGroups: ClientCollection<PurchaseOrderLineProductStatisticalGroups>;
        taxes: ClientCollection<PurchaseOrderLineTaxes>;
    }
    export interface PurchaseOrderLineInput extends ClientNodeInput {
        purchaseOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        company?: string;
        orderType?: PurchaseOrderType;
        revisionNumber?: integer | string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInSupplierLanguage?: string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        netPrice?: decimal | string;
        buyer?: string;
        receiptSite?: string;
        receiptAddress?: string;
        project?: string;
        intrastatIncreaseCoefficient?: decimal | string;
        countryOfOrigin?: string;
        hasQualityControlManagement?: boolean | string;
        receiptTax?: string;
        issueTax?: string;
        otherTax1?: string;
        otherTax2?: string;
        matchingTolerance?: string;
        acknowledgementDate?: string;
        acknowledgementNumber?: string;
        acknowledgementUpdate?: integer | string;
        actualPurchaseCostInCompanyCurrency?: decimal | string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        calculatedBasisForTax3?: decimal | string;
        calculatedTaxBasis1?: decimal | string;
        calculatedTaxBasis2?: decimal | string;
        calculationBasisForIssueTax?: decimal | string;
        calculationBasisForOtherTax1?: decimal | string;
        calculationBasisForOtherTax2?: decimal | string;
        calculationBasisForReceiptTax?: decimal | string;
        commitmentGenerated?: integer | string;
        commitmentType?: CommitmentType;
        companyCurrency?: string;
        costPriceWithoutLandedCost?: decimal | string;
        costStructure?: string;
        currency?: string;
        distributedInvoicingElement1AmountExcludingTax?: decimal | string;
        distributedInvoicingElement2AmountExcludingTax?: decimal | string;
        distributedInvoicingElement3AmountExcludingTax?: decimal | string;
        distributedInvoicingElement4AmountExcludingTax?: decimal | string;
        distributedInvoicingElement5AmountExcludingTax?: decimal | string;
        distributedInvoicingElement6AmountExcludingTax?: decimal | string;
        distributedInvoicingElement7AmountExcludingTax?: decimal | string;
        distributedInvoicingElement8AmountExcludingTax?: decimal | string;
        distributedInvoicingElement9AmountExcludingTax?: decimal | string;
        expectedReceiptDate?: string;
        fixedLandedCostPerUnitInCompanyCurrency?: decimal | string;
        interCompanySalesOrderLineNumber?: integer | string;
        interCompanySalesOrderSequenceNumber?: integer | string;
        isBudgetOverrun?: boolean | string;
        isClosed?: boolean | string;
        isClosedByReceipt?: boolean | string;
        isInOrderUnit?: boolean | string;
        isInvoiced?: boolean | string;
        isPrinted?: boolean | string;
        issueTaxAmount?: decimal | string;
        issueTaxDeductibleAmount?: decimal | string;
        landedCostCoefficient?: decimal | string;
        lastReceiptDate?: string;
        lastSalesInvoiceDate?: string;
        lineAmountIncludingTax?: decimal | string;
        lineAndSequenceIndex?: string;
        lineOrderAmountIncludingTax?: decimal | string;
        linePurchaseCostInCompanyCurrency?: decimal | string;
        lineStatus?: LineStatus;
        lineStockCostInCompanyCurrency?: decimal | string;
        lineType?: OrderLineType;
        linkCoefficientForSubcontract?: decimal | string;
        locationReference?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        numberOfInvoicedReceipts?: integer | string;
        numberOfInvoices?: integer | string;
        numberOfReceipts?: integer | string;
        orderDate?: string;
        orderFromSupplier?: string;
        orderLineText?: TextStream;
        orderUnit?: string;
        orderUnitToPurchaseUnitConversionFactor?: decimal | string;
        otherTax1Amount?: decimal | string;
        otherTax1DeductibleAmount?: decimal | string;
        otherTax2Amount?: decimal | string;
        otherTax2DeductibleAmount?: decimal | string;
        productType?: PurchasingProductType;
        purchaseCostInCompanyCurrency?: decimal | string;
        purchaseReceipt?: string;
        purchaseReceiptLine?: integer | string;
        purchaseSite?: string;
        purchaseType?: PurchaseType;
        purchaseUnit?: string;
        quantityInOrderUnitOrdered?: decimal | string;
        quantityInPurchaseUnitInvoiced?: decimal | string;
        quantityInPurchaseUnitOrdered?: decimal | string;
        quantityInPurchaseUnitReceived?: decimal | string;
        quantityInPurchaseUnitRequired?: decimal | string;
        quantityInPurchaseUnitShippedNotReceived?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        quantityInStockUnitOrdered?: decimal | string;
        quantityInStockUnitReceived?: decimal | string;
        quantityInStockUnitRequired?: decimal | string;
        quantityInStockUnitShippedNotReceived?: decimal | string;
        rebateOnTax1Amount?: decimal | string;
        receiptTaxAmount?: decimal | string;
        receiptTaxDeductibleAmount?: decimal | string;
        releasedProduct?: string;
        reorderLeadTime?: decimal | string;
        requestForQuotation?: string;
        requestForQuotationResponseLineNumber?: integer | string;
        requestedDeliveryEndDate?: string;
        requestedDeliveryEndTime?: integer | string;
        requestedDeliveryStartDate?: string;
        requestedDeliveryStartTime?: integer | string;
        requirementDate?: string;
        shippingSite?: string;
        sourceDocumentLineNumber?: integer | string;
        sourceDocumentNumber?: string;
        sourceDocumentSequenceNumber?: integer | string;
        sourceDocumentType?: EntryTypeEnum;
        sourceRequest?: RequestSource;
        stockCostInCompanyCurrency?: decimal | string;
        stockUnit?: string;
        subcontractAddress?: string;
        supplierProduct?: string;
        tax1BasisAmount?: decimal | string;
        tax1DeductibleAmount?: decimal | string;
        tax1amount?: decimal | string;
        tax2DeductibleAmount?: decimal | string;
        tax2amount?: decimal | string;
        tax3DeductibleAmount?: decimal | string;
        tax3amount?: decimal | string;
        taxExcludedLineAmount?: decimal | string;
        totalPurchaseCostInCompanyCurrency?: decimal | string;
        totalStockCostInCompanyCurrency?: decimal | string;
        volume?: decimal | string;
        volumeUnit?: string;
        weight?: decimal | string;
        weightUnit?: string;
        workInProgressOrderNumber?: string;
        workOrderInProgressStatus?: StatusInProgress;
        workOrderInProgressType?: WorkOrderType;
        productStatisticalGroups?: Partial<PurchaseOrderLineProductStatisticalGroupsInput>[];
        taxes?: Partial<PurchaseOrderLineTaxesInput>[];
    }
    export interface PurchaseOrderLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseOrder: PurchaseOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        buyer: User;
        receiptSite: Site;
        receiptAddress: SiteAddress;
        project: ProjectLink;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        hasQualityControlManagement: boolean;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        matchingTolerance: MatchingTolerance;
        acknowledgementDate: string;
        acknowledgementNumber: string;
        acknowledgementUpdate: integer;
        actualPurchaseCostInCompanyCurrency: string;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        calculatedBasisForTax3: string;
        calculatedTaxBasis1: string;
        calculatedTaxBasis2: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        calculationBasisForReceiptTax: string;
        commitmentGenerated: integer;
        commitmentType: CommitmentType;
        companyCurrency: Currency;
        costPriceWithoutLandedCost: string;
        costStructure: FreightCostStructure;
        currency: Currency;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        expectedReceiptDate: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        interCompanySalesOrderLineNumber: integer;
        interCompanySalesOrderSequenceNumber: integer;
        isBudgetOverrun: boolean;
        isClosed: boolean;
        isClosedByReceipt: boolean;
        isInOrderUnit: boolean;
        isInvoiced: boolean;
        isPrinted: boolean;
        issueTaxAmount: string;
        issueTaxDeductibleAmount: string;
        landedCostCoefficient: string;
        lastReceiptDate: string;
        lastSalesInvoiceDate: string;
        lineAmountIncludingTax: string;
        lineAndSequenceIndex: string;
        lineOrderAmountIncludingTax: string;
        linePurchaseCostInCompanyCurrency: string;
        lineStatus: LineStatus;
        lineStockCostInCompanyCurrency: string;
        lineType: OrderLineType;
        linkCoefficientForSubcontract: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        numberOfInvoicedReceipts: integer;
        numberOfInvoices: integer;
        numberOfReceipts: integer;
        orderDate: string;
        orderFromSupplier: Supplier;
        orderLineText: TextStream;
        orderUnit: UnitOfMeasure;
        orderUnitToPurchaseUnitConversionFactor: string;
        otherTax1Amount: string;
        otherTax1DeductibleAmount: string;
        otherTax2Amount: string;
        otherTax2DeductibleAmount: string;
        productType: PurchasingProductType;
        purchaseCostInCompanyCurrency: string;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseSite: Site;
        purchaseType: PurchaseType;
        purchaseUnit: UnitOfMeasure;
        quantityInOrderUnitOrdered: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInPurchaseUnitOrdered: string;
        quantityInPurchaseUnitReceived: string;
        quantityInPurchaseUnitRequired: string;
        quantityInPurchaseUnitShippedNotReceived: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitReceived: string;
        quantityInStockUnitRequired: string;
        quantityInStockUnitShippedNotReceived: string;
        rebateOnTax1Amount: string;
        receiptTaxAmount: string;
        receiptTaxDeductibleAmount: string;
        releasedProduct: Product;
        reorderLeadTime: string;
        requestForQuotation: string;
        requestForQuotationResponseLineNumber: integer;
        requestedDeliveryEndDate: string;
        requestedDeliveryEndTime: integer;
        requestedDeliveryStartDate: string;
        requestedDeliveryStartTime: integer;
        requirementDate: string;
        shippingSite: Site;
        sourceDocumentLineNumber: integer;
        sourceDocumentNumber: string;
        sourceDocumentSequenceNumber: integer;
        sourceDocumentType: EntryTypeEnum;
        sourceRequest: RequestSource;
        stockCostInCompanyCurrency: string;
        stockUnit: UnitOfMeasure;
        subcontractAddress: SupplierAddress;
        supplierProduct: SupplierProduct;
        tax1BasisAmount: string;
        tax1DeductibleAmount: string;
        tax1amount: string;
        tax2DeductibleAmount: string;
        tax2amount: string;
        tax3DeductibleAmount: string;
        tax3amount: string;
        taxExcludedLineAmount: string;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        volume: string;
        volumeUnit: UnitOfMeasure;
        weight: string;
        weightUnit: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workOrderInProgressStatus: StatusInProgress;
        workOrderInProgressType: WorkOrderType;
        productStatisticalGroups: ClientCollection<PurchaseOrderLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<PurchaseOrderLineTaxesBinding>;
    }
    export interface PurchaseOrderLine$Lookups {
        purchaseOrder: QueryOperation<PurchaseOrder>;
        company: QueryOperation<Company>;
        product: QueryOperation<Product>;
        priceReason: QueryOperation<PurchasePriceReason>;
        discountOrCharge1Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge2Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge3Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge4Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge5Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge6Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge7Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge8Reason: QueryOperation<PurchasePriceReason>;
        discountOrCharge9Reason: QueryOperation<PurchasePriceReason>;
        buyer: QueryOperation<User>;
        receiptSite: QueryOperation<Site>;
        receiptAddress: QueryOperation<SiteAddress>;
        project: QueryOperation<ProjectLink>;
        countryOfOrigin: QueryOperation<Country>;
        receiptTax: QueryOperation<Tax>;
        issueTax: QueryOperation<Tax>;
        otherTax1: QueryOperation<Tax>;
        otherTax2: QueryOperation<Tax>;
        matchingTolerance: QueryOperation<MatchingTolerance>;
        billBySupplier: QueryOperation<Supplier>;
        billBySupplierAddress: QueryOperation<SupplierAddress>;
        companyCurrency: QueryOperation<Currency>;
        costStructure: QueryOperation<FreightCostStructure>;
        currency: QueryOperation<Currency>;
        majorProductVersion: QueryOperation<MajorVersionStatus>;
        orderFromSupplier: QueryOperation<Supplier>;
        orderUnit: QueryOperation<UnitOfMeasure>;
        purchaseReceipt: QueryOperation<PurchaseReceipt>;
        purchaseReceiptLine: QueryOperation<PurchaseReceiptLine>;
        purchaseSite: QueryOperation<Site>;
        purchaseUnit: QueryOperation<UnitOfMeasure>;
        releasedProduct: QueryOperation<Product>;
        shippingSite: QueryOperation<Site>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        subcontractAddress: QueryOperation<SupplierAddress>;
        supplierProduct: QueryOperation<SupplierProduct>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        weightUnit: QueryOperation<UnitOfMeasure>;
    }
    export interface PurchaseOrderLine$Operations {
        query: QueryOperation<PurchaseOrderLine>;
        read: ReadOperation<PurchaseOrderLine>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderLine>;
            query: AggregateQueryOperation<PurchaseOrderLine>;
        };
        lookups(dataOrId: string | { data: PurchaseOrderLineInput }): PurchaseOrderLine$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseOrderLine>;
    }
    export interface PurchaseOrderQuantityLinesSupplierView extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        receiptSite: string;
        supplier: string;
        product: string;
        purchaseOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        isClosed: boolean;
        sourceRequest: RequestSource;
        lineType: OrderLineType;
        purchaseUnitToStockUnitConversionFactor: integer;
        workInProgressStatus: StatusInProgress;
        productType: PurchasingProductType;
        description1: string;
        quantityInPurchaseUnitOrdered: string;
        quantityInPurchaseUnitReceived: string;
        purchaseUnit: string;
        upc: string;
        globalTradeItemNumber: string;
        productStatus: ProductStatus;
        isReceived: boolean;
        isManufactured: boolean;
        isPhantom: boolean;
        isIntersite: boolean;
        supplierProduct: string;
        supplierProductDescription: string;
        supplierUpc: string;
    }
    export interface PurchaseOrderQuantityLinesSupplierViewInput extends ClientNodeInput {
        receiptSite?: string;
        supplier?: string;
        product?: string;
        purchaseOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        isClosed?: boolean | string;
        sourceRequest?: RequestSource;
        lineType?: OrderLineType;
        purchaseUnitToStockUnitConversionFactor?: integer | string;
        workInProgressStatus?: StatusInProgress;
        productType?: PurchasingProductType;
        description1?: string;
        quantityInPurchaseUnitOrdered?: decimal | string;
        quantityInPurchaseUnitReceived?: decimal | string;
        purchaseUnit?: string;
        upc?: string;
        globalTradeItemNumber?: string;
        productStatus?: ProductStatus;
        isReceived?: boolean | string;
        isManufactured?: boolean | string;
        isPhantom?: boolean | string;
        isIntersite?: boolean | string;
        supplierProduct?: string;
        supplierProductDescription?: string;
        supplierUpc?: string;
    }
    export interface PurchaseOrderQuantityLinesSupplierViewBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        receiptSite: string;
        supplier: string;
        product: string;
        purchaseOrder: string;
        lineNumber: integer;
        sequenceNumber: integer;
        isClosed: boolean;
        sourceRequest: RequestSource;
        lineType: OrderLineType;
        purchaseUnitToStockUnitConversionFactor: integer;
        workInProgressStatus: StatusInProgress;
        productType: PurchasingProductType;
        description1: string;
        quantityInPurchaseUnitOrdered: string;
        quantityInPurchaseUnitReceived: string;
        purchaseUnit: string;
        upc: string;
        globalTradeItemNumber: string;
        productStatus: ProductStatus;
        isReceived: boolean;
        isManufactured: boolean;
        isPhantom: boolean;
        isIntersite: boolean;
        supplierProduct: string;
        supplierProductDescription: string;
        supplierUpc: string;
    }
    export interface PurchaseOrderQuantityLinesSupplierView$Operations {
        query: QueryOperation<PurchaseOrderQuantityLinesSupplierView>;
        read: ReadOperation<PurchaseOrderQuantityLinesSupplierView>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderQuantityLinesSupplierView>;
            query: AggregateQueryOperation<PurchaseOrderQuantityLinesSupplierView>;
        };
        getDefaults: GetDefaultsOperation<PurchaseOrderQuantityLinesSupplierView>;
    }
    export interface PurchaseOrderShipFromSupplierAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface PurchaseOrderShipFromSupplierAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface PurchaseOrderShipFromSupplierAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface PurchaseOrderShipFromSupplierAddressLines$Operations {
        query: QueryOperation<PurchaseOrderShipFromSupplierAddressLines>;
        read: ReadOperation<PurchaseOrderShipFromSupplierAddressLines>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderShipFromSupplierAddressLines>;
            query: AggregateQueryOperation<PurchaseOrderShipFromSupplierAddressLines>;
        };
        getDefaults: GetDefaultsOperation<PurchaseOrderShipFromSupplierAddressLines>;
    }
    export interface PurchaseOrderSupplierStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface PurchaseOrderSupplierStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        value?: string;
    }
    export interface PurchaseOrderSupplierStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        value: MiscellaneousTable;
    }
    export interface PurchaseOrderSupplierStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface PurchaseOrderSupplierStatisticalGroups$Operations {
        query: QueryOperation<PurchaseOrderSupplierStatisticalGroups>;
        read: ReadOperation<PurchaseOrderSupplierStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrderSupplierStatisticalGroups>;
            query: AggregateQueryOperation<PurchaseOrderSupplierStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: PurchaseOrderSupplierStatisticalGroupsInput },
        ): PurchaseOrderSupplierStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseOrderSupplierStatisticalGroups>;
    }
    export interface PurchaseOrder extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        purchaseSite: Site;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        orderDate: string;
        internalOrderReference: string;
        project: ProjectLink;
        orderFromSupplier: Supplier;
        orderFromSupplierAddress: SupplierAddress;
        orderFromSupplierAddressZipCode: string;
        orderFromSupplierAddressCity: string;
        orderFromSupplierAddressState: string;
        orderFromSupplierAddressCountry: Country;
        orderFromSupplierAddressCountryName: string;
        shipFromSupplierAddress: SupplierAddress;
        shipFromSupplierAddressZipCode: string;
        shipFromSupplierAddressCity: string;
        shipFromSupplierAddressState: string;
        shipFromSupplierAddressCountry: Country;
        shipFromSupplierAddressCountryName: string;
        invoiceSite: Site;
        receiptSite: Site;
        expectedReceiptDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        deliveryMode: DeliveryMode;
        carrier: Carrier;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        incoterm: Incoterm;
        incotermTown: string;
        groupingCode: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        buyer: User;
        orderFromSupplierLanguage: Language;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        currencyRate: string;
        taxRule: TaxRule;
        taxRuleType: integer;
        numberOfLines: integer;
        numberOfBudgetOverrunLines: integer;
        numberOfReceivedLines: integer;
        numberOfClosedLines: integer;
        numberOfInvoicedLines: integer;
        numberOfReceipts: integer;
        numberOfInvoices: integer;
        signatureStatus: NoInPartInFull;
        isClosed: boolean;
        receiptStatus: NoInPartInFull;
        invoicedStatus: NoInPartInFull;
        isPrinted: boolean;
        numberOfCopies: integer;
        acknowledgmentDate: string;
        acknowledgmentNumber: string;
        acknowledgmentNote: string;
        isPrintedAcknowledgmentReminder: boolean;
        mustSendDeliveryReminder: boolean;
        isIntercompany: boolean;
        isIntersite: boolean;
        purchaseSiteForIntersite: Site;
        shippingSite: Site;
        salesSite: Site;
        soldToCustomer: Customer;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        amountOfLinesIncludingTax: string;
        amountOfLinesExcludingTax: string;
        totalQuantityOfLines: string;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalTaxAmount: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        expectedTotalAmountExcludingTax: string;
        serviceStartDate: string;
        serviceEndDate: string;
        container: Container;
        numberOfContainers: integer;
        maximumAmountExcludingTax: string;
        availableWeightOfContainer: string;
        availableVolumeOfContainer: string;
        purchaseOrderLines: ClientCollection<PurchaseOrderLine>;
        orderFooterText: TextStream;
        orderHeaderText: TextStream;
        companyNames: ClientCollection<PurchaseOrderCompanyNames>;
        dimensions: ClientCollection<PurchaseOrderDimensions>;
        discountOrChargeCalculationRules: ClientCollection<PurchaseOrderDiscountOrChargeCalculationRules>;
        fromSupplierAddressLines: ClientCollection<PurchaseOrderFromSupplierAddressLines>;
        fromSupplierCompanyNames: ClientCollection<PurchaseOrderFromSupplierCompanyNames>;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseOrderHeaderInvoiceLineAllocationElements>;
        shipFromSupplierAddressLines: ClientCollection<PurchaseOrderShipFromSupplierAddressLines>;
        supplierStatisticalGroups: ClientCollection<PurchaseOrderSupplierStatisticalGroups>;
    }
    export interface PurchaseOrderInput extends ClientNodeInput {
        id?: string;
        company?: string;
        purchaseSite?: string;
        orderType?: PurchaseOrderType;
        revisionNumber?: integer | string;
        orderDate?: string;
        internalOrderReference?: string;
        project?: string;
        orderFromSupplier?: string;
        orderFromSupplierAddress?: string;
        orderFromSupplierAddressZipCode?: string;
        orderFromSupplierAddressCity?: string;
        orderFromSupplierAddressState?: string;
        orderFromSupplierAddressCountry?: string;
        orderFromSupplierAddressCountryName?: string;
        shipFromSupplierAddress?: string;
        shipFromSupplierAddressZipCode?: string;
        shipFromSupplierAddressCity?: string;
        shipFromSupplierAddressState?: string;
        shipFromSupplierAddressCountry?: string;
        shipFromSupplierAddressCountryName?: string;
        invoiceSite?: string;
        receiptSite?: string;
        expectedReceiptDate?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        deliveryMode?: string;
        carrier?: string;
        payToBusinessPartner?: string;
        payToBusinessPartnerAddress?: string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        incoterm?: string;
        incotermTown?: string;
        groupingCode?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        intrastatTransportLocation?: CountryLocation;
        europeanUnionIdentification?: string;
        buyer?: string;
        orderFromSupplierLanguage?: string;
        currency?: string;
        currencyRateType?: ExchangeRateType;
        currencyRate?: decimal | string;
        taxRule?: string;
        taxRuleType?: integer | string;
        numberOfLines?: integer | string;
        numberOfBudgetOverrunLines?: integer | string;
        numberOfReceivedLines?: integer | string;
        numberOfClosedLines?: integer | string;
        numberOfInvoicedLines?: integer | string;
        numberOfReceipts?: integer | string;
        numberOfInvoices?: integer | string;
        signatureStatus?: NoInPartInFull;
        isClosed?: boolean | string;
        receiptStatus?: NoInPartInFull;
        invoicedStatus?: NoInPartInFull;
        isPrinted?: boolean | string;
        numberOfCopies?: integer | string;
        acknowledgmentDate?: string;
        acknowledgmentNumber?: string;
        acknowledgmentNote?: string;
        isPrintedAcknowledgmentReminder?: boolean | string;
        mustSendDeliveryReminder?: boolean | string;
        isIntercompany?: boolean | string;
        isIntersite?: boolean | string;
        purchaseSiteForIntersite?: string;
        shippingSite?: string;
        salesSite?: string;
        soldToCustomer?: string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        amountOfLinesIncludingTax?: decimal | string;
        amountOfLinesExcludingTax?: decimal | string;
        totalQuantityOfLines?: decimal | string;
        totalWeightOfLines?: decimal | string;
        totalVolumeOfLines?: decimal | string;
        totalTaxAmount?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        expectedTotalAmountExcludingTax?: decimal | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        container?: string;
        numberOfContainers?: integer | string;
        maximumAmountExcludingTax?: decimal | string;
        availableWeightOfContainer?: decimal | string;
        availableVolumeOfContainer?: decimal | string;
        purchaseOrderLines?: Partial<PurchaseOrderLineInput>[];
        orderFooterText?: TextStream;
        orderHeaderText?: TextStream;
        companyNames?: Partial<PurchaseOrderCompanyNamesInput>[];
        dimensions?: Partial<PurchaseOrderDimensionsInput>[];
        discountOrChargeCalculationRules?: Partial<PurchaseOrderDiscountOrChargeCalculationRulesInput>[];
        fromSupplierAddressLines?: Partial<PurchaseOrderFromSupplierAddressLinesInput>[];
        fromSupplierCompanyNames?: Partial<PurchaseOrderFromSupplierCompanyNamesInput>[];
        headerInvoiceLineAllocationElements?: Partial<PurchaseOrderHeaderInvoiceLineAllocationElementsInput>[];
        shipFromSupplierAddressLines?: Partial<PurchaseOrderShipFromSupplierAddressLinesInput>[];
        supplierStatisticalGroups?: Partial<PurchaseOrderSupplierStatisticalGroupsInput>[];
    }
    export interface PurchaseOrderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        purchaseSite: Site;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        orderDate: string;
        internalOrderReference: string;
        project: ProjectLink;
        orderFromSupplier: Supplier;
        orderFromSupplierAddress: SupplierAddress;
        orderFromSupplierAddressZipCode: string;
        orderFromSupplierAddressCity: string;
        orderFromSupplierAddressState: string;
        orderFromSupplierAddressCountry: Country;
        orderFromSupplierAddressCountryName: string;
        shipFromSupplierAddress: SupplierAddress;
        shipFromSupplierAddressZipCode: string;
        shipFromSupplierAddressCity: string;
        shipFromSupplierAddressState: string;
        shipFromSupplierAddressCountry: Country;
        shipFromSupplierAddressCountryName: string;
        invoiceSite: Site;
        receiptSite: Site;
        expectedReceiptDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        deliveryMode: DeliveryMode;
        carrier: Carrier;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        incoterm: Incoterm;
        incotermTown: string;
        groupingCode: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        buyer: User;
        orderFromSupplierLanguage: Language;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        currencyRate: string;
        taxRule: TaxRule;
        taxRuleType: integer;
        numberOfLines: integer;
        numberOfBudgetOverrunLines: integer;
        numberOfReceivedLines: integer;
        numberOfClosedLines: integer;
        numberOfInvoicedLines: integer;
        numberOfReceipts: integer;
        numberOfInvoices: integer;
        signatureStatus: NoInPartInFull;
        isClosed: boolean;
        receiptStatus: NoInPartInFull;
        invoicedStatus: NoInPartInFull;
        isPrinted: boolean;
        numberOfCopies: integer;
        acknowledgmentDate: string;
        acknowledgmentNumber: string;
        acknowledgmentNote: string;
        isPrintedAcknowledgmentReminder: boolean;
        mustSendDeliveryReminder: boolean;
        isIntercompany: boolean;
        isIntersite: boolean;
        purchaseSiteForIntersite: Site;
        shippingSite: Site;
        salesSite: Site;
        soldToCustomer: Customer;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        amountOfLinesIncludingTax: string;
        amountOfLinesExcludingTax: string;
        totalQuantityOfLines: string;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalTaxAmount: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        expectedTotalAmountExcludingTax: string;
        serviceStartDate: string;
        serviceEndDate: string;
        container: Container;
        numberOfContainers: integer;
        maximumAmountExcludingTax: string;
        availableWeightOfContainer: string;
        availableVolumeOfContainer: string;
        purchaseOrderLines: ClientCollection<PurchaseOrderLine>;
        orderFooterText: TextStream;
        orderHeaderText: TextStream;
        companyNames: ClientCollection<PurchaseOrderCompanyNamesBinding>;
        dimensions: ClientCollection<PurchaseOrderDimensionsBinding>;
        discountOrChargeCalculationRules: ClientCollection<PurchaseOrderDiscountOrChargeCalculationRulesBinding>;
        fromSupplierAddressLines: ClientCollection<PurchaseOrderFromSupplierAddressLinesBinding>;
        fromSupplierCompanyNames: ClientCollection<PurchaseOrderFromSupplierCompanyNamesBinding>;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseOrderHeaderInvoiceLineAllocationElementsBinding>;
        shipFromSupplierAddressLines: ClientCollection<PurchaseOrderShipFromSupplierAddressLinesBinding>;
        supplierStatisticalGroups: ClientCollection<PurchaseOrderSupplierStatisticalGroupsBinding>;
    }
    export interface PurchaseOrder$Lookups {
        company: QueryOperation<Company>;
        purchaseSite: QueryOperation<Site>;
        project: QueryOperation<ProjectLink>;
        orderFromSupplier: QueryOperation<Supplier>;
        orderFromSupplierAddress: QueryOperation<SupplierAddress>;
        orderFromSupplierAddressCountry: QueryOperation<Country>;
        shipFromSupplierAddress: QueryOperation<SupplierAddress>;
        shipFromSupplierAddressCountry: QueryOperation<Country>;
        invoiceSite: QueryOperation<Site>;
        receiptSite: QueryOperation<Site>;
        paymentTerm: QueryOperation<PaymentTerm>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        deliveryMode: QueryOperation<DeliveryMode>;
        carrier: QueryOperation<Carrier>;
        payToBusinessPartner: QueryOperation<BusinessPartner>;
        payToBusinessPartnerAddress: QueryOperation<BusinessPartnerAddress>;
        billBySupplier: QueryOperation<Supplier>;
        billBySupplierAddress: QueryOperation<SupplierAddress>;
        incoterm: QueryOperation<Incoterm>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<SupplierAddress>;
        buyer: QueryOperation<User>;
        orderFromSupplierLanguage: QueryOperation<Language>;
        currency: QueryOperation<Currency>;
        taxRule: QueryOperation<TaxRule>;
        purchaseSiteForIntersite: QueryOperation<Site>;
        shippingSite: QueryOperation<Site>;
        salesSite: QueryOperation<Site>;
        soldToCustomer: QueryOperation<Customer>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        container: QueryOperation<Container>;
    }
    export interface PurchaseOrder$Operations {
        query: QueryOperation<PurchaseOrder>;
        read: ReadOperation<PurchaseOrder>;
        aggregate: {
            read: AggregateReadOperation<PurchaseOrder>;
            query: AggregateQueryOperation<PurchaseOrder>;
        };
        lookups(dataOrId: string | { data: PurchaseOrderInput }): PurchaseOrder$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseOrder>;
    }
    export interface PurchaseReceiptAddressLines extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface PurchaseReceiptAddressLinesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        addressLine?: string;
    }
    export interface PurchaseReceiptAddressLinesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        addressLine: string;
    }
    export interface PurchaseReceiptAddressLines$Operations {
        query: QueryOperation<PurchaseReceiptAddressLines>;
        read: ReadOperation<PurchaseReceiptAddressLines>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceiptAddressLines>;
            query: AggregateQueryOperation<PurchaseReceiptAddressLines>;
        };
        getDefaults: GetDefaultsOperation<PurchaseReceiptAddressLines>;
    }
    export interface PurchaseReceiptCompanyNames extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface PurchaseReceiptCompanyNamesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        companyName?: string;
    }
    export interface PurchaseReceiptCompanyNamesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        companyName: string;
    }
    export interface PurchaseReceiptCompanyNames$Operations {
        query: QueryOperation<PurchaseReceiptCompanyNames>;
        read: ReadOperation<PurchaseReceiptCompanyNames>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceiptCompanyNames>;
            query: AggregateQueryOperation<PurchaseReceiptCompanyNames>;
        };
        getDefaults: GetDefaultsOperation<PurchaseReceiptCompanyNames>;
    }
    export interface PurchaseReceiptDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionTypeCode: DimensionType;
        dimension: Dimension;
    }
    export interface PurchaseReceiptDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        dimensionTypeCode?: string;
        dimension?: string;
    }
    export interface PurchaseReceiptDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        dimensionTypeCode: DimensionType;
        dimension: Dimension;
    }
    export interface PurchaseReceiptDimensions$Lookups {
        dimensionTypeCode: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface PurchaseReceiptDimensions$Operations {
        query: QueryOperation<PurchaseReceiptDimensions>;
        read: ReadOperation<PurchaseReceiptDimensions>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceiptDimensions>;
            query: AggregateQueryOperation<PurchaseReceiptDimensions>;
        };
        lookups(dataOrId: string | { data: PurchaseReceiptDimensionsInput }): PurchaseReceiptDimensions$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReceiptDimensions>;
    }
    export interface PurchaseReceiptHeaderInvoiceLineAllocationElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineAllocationElement: PurchaseInvoicingElement;
        distributionLineTax: Tax;
    }
    export interface PurchaseReceiptHeaderInvoiceLineAllocationElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        invoiceLineAllocationElement?: integer | string;
        distributionLineTax?: string;
    }
    export interface PurchaseReceiptHeaderInvoiceLineAllocationElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineAllocationElement: PurchaseInvoicingElement;
        distributionLineTax: Tax;
    }
    export interface PurchaseReceiptHeaderInvoiceLineAllocationElements$Lookups {
        invoiceLineAllocationElement: QueryOperation<PurchaseInvoicingElement>;
        distributionLineTax: QueryOperation<Tax>;
    }
    export interface PurchaseReceiptHeaderInvoiceLineAllocationElements$Operations {
        query: QueryOperation<PurchaseReceiptHeaderInvoiceLineAllocationElements>;
        read: ReadOperation<PurchaseReceiptHeaderInvoiceLineAllocationElements>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceiptHeaderInvoiceLineAllocationElements>;
            query: AggregateQueryOperation<PurchaseReceiptHeaderInvoiceLineAllocationElements>;
        };
        lookups(
            dataOrId: string | { data: PurchaseReceiptHeaderInvoiceLineAllocationElementsInput },
        ): PurchaseReceiptHeaderInvoiceLineAllocationElements$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReceiptHeaderInvoiceLineAllocationElements>;
    }
    export interface PurchaseReceiptHeaderInvoiceLineElements extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineElement: PurchaseInvoicingElement;
        priceLineTax: Tax;
    }
    export interface PurchaseReceiptHeaderInvoiceLineElementsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        invoiceLineElement?: integer | string;
        priceLineTax?: string;
    }
    export interface PurchaseReceiptHeaderInvoiceLineElementsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        invoiceLineElement: PurchaseInvoicingElement;
        priceLineTax: Tax;
    }
    export interface PurchaseReceiptHeaderInvoiceLineElements$Lookups {
        invoiceLineElement: QueryOperation<PurchaseInvoicingElement>;
        priceLineTax: QueryOperation<Tax>;
    }
    export interface PurchaseReceiptHeaderInvoiceLineElements$Operations {
        query: QueryOperation<PurchaseReceiptHeaderInvoiceLineElements>;
        read: ReadOperation<PurchaseReceiptHeaderInvoiceLineElements>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceiptHeaderInvoiceLineElements>;
            query: AggregateQueryOperation<PurchaseReceiptHeaderInvoiceLineElements>;
        };
        lookups(
            dataOrId: string | { data: PurchaseReceiptHeaderInvoiceLineElementsInput },
        ): PurchaseReceiptHeaderInvoiceLineElements$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReceiptHeaderInvoiceLineElements>;
    }
    export interface PurchaseReceiptLineProductStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseReceipt: string;
        lineNumber: integer;
        value: MiscellaneousTable;
    }
    export interface PurchaseReceiptLineProductStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        purchaseReceipt?: string;
        lineNumber?: integer | string;
        value?: string;
    }
    export interface PurchaseReceiptLineProductStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseReceipt: string;
        lineNumber: integer;
        value: MiscellaneousTable;
    }
    export interface PurchaseReceiptLineProductStatisticalGroups$Lookups {
        value: QueryOperation<MiscellaneousTable>;
    }
    export interface PurchaseReceiptLineProductStatisticalGroups$Operations {
        query: QueryOperation<PurchaseReceiptLineProductStatisticalGroups>;
        read: ReadOperation<PurchaseReceiptLineProductStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceiptLineProductStatisticalGroups>;
            query: AggregateQueryOperation<PurchaseReceiptLineProductStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: PurchaseReceiptLineProductStatisticalGroupsInput },
        ): PurchaseReceiptLineProductStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReceiptLineProductStatisticalGroups>;
    }
    export interface PurchaseReceiptLineTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseReceipt: string;
        lineNumber: integer;
        tax: Tax;
    }
    export interface PurchaseReceiptLineTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        purchaseReceipt?: string;
        lineNumber?: integer | string;
        tax?: string;
    }
    export interface PurchaseReceiptLineTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseReceipt: string;
        lineNumber: integer;
        tax: Tax;
    }
    export interface PurchaseReceiptLineTaxes$Lookups {
        tax: QueryOperation<Tax>;
    }
    export interface PurchaseReceiptLineTaxes$Operations {
        query: QueryOperation<PurchaseReceiptLineTaxes>;
        read: ReadOperation<PurchaseReceiptLineTaxes>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceiptLineTaxes>;
            query: AggregateQueryOperation<PurchaseReceiptLineTaxes>;
        };
        lookups(dataOrId: string | { data: PurchaseReceiptLineTaxesInput }): PurchaseReceiptLineTaxes$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReceiptLineTaxes>;
    }
    export interface PurchaseReceiptLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseReceipt: PurchaseReceipt;
        lineNumber: integer;
        company: Company;
        receiptSite: Site;
        receiptDate: string;
        purchaseSite: Site;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLineNumber: integer;
        purchaseOrderLine: PurchaseOrderLine;
        orderType: PurchaseOrderType;
        supplier: Supplier;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        project: ProjectLink;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountCharge1: string;
        discountCharge2: string;
        discountCharge3: string;
        discountCharge4: string;
        discountCharge5: string;
        discountCharge6: string;
        discountCharge7: string;
        discountCharge8: string;
        discountCharge9: string;
        discountCharge1Reason: PurchasePriceReason;
        discountCharge2Reason: PurchasePriceReason;
        discountCharge3Reason: PurchasePriceReason;
        discountCharge4Reason: PurchasePriceReason;
        discountCharge5Reason: PurchasePriceReason;
        discountCharge6Reason: PurchasePriceReason;
        discountCharge7Reason: PurchasePriceReason;
        discountCharge8Reason: PurchasePriceReason;
        discountCharge9Reason: PurchasePriceReason;
        netPrice: string;
        netPriceInPurchaseUnit: string;
        lineAmountExcludingTax: string;
        lineCostPriceInCompanyCurrency: string;
        linePurchaseCostInCompanyCurrency: string;
        lineAmountIncludingTax: string;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        calculatedTaxableBase3: string;
        calculatedTaxableBase4: string;
        calculatedTaxableBase5: string;
        calculatedTaxableBase6: string;
        calculatedTaxableBase7: string;
        rebateOnTax1Amount: string;
        taxableBase1Amount: string;
        tax1Amount: string;
        tax2Amount: string;
        tax3Amount: string;
        receiptTaxAmount: string;
        issueTaxAmount: string;
        otherTax1Amount: string;
        otherTax2Amount: string;
        tax1DeductibleAmount: string;
        tax2DeductibleAmount: string;
        tax3DeductibleAmount: string;
        receiptTaxDeductibleAmount: string;
        issueTaxDeductibleAmount: string;
        otherTax1DeductibleAmount: string;
        otherTax2DeductibleAmount: string;
        netPriceIncludingInvoicingElementInCompanyCurrency: string;
        costPriceInCompanyCurrency: string;
        theoreticalStockCostInCompanyCurrency: string;
        purchaseCostInCompanyCurrency: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        costStructure: string;
        currency: Currency;
        companyCurrency: Currency;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        totalPostedStockCostInCompanyCurrency: string;
        quantityInReceiptUnitReceived: string;
        quantityInPurchaseUnitReceived: string;
        quantityInStockUnitReceived: string;
        weight: string;
        weightUnit: UnitOfMeasure;
        volume: string;
        volumeUnit: UnitOfMeasure;
        receiptUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        receiptUnitToPurchaseUnitConversionFactor: string;
        receiptUnitToStockUnitConversionFactor: string;
        quantityInPurchaseUnitRejected: string;
        quantityInStockUnitRejected: string;
        quantityInPurchaseUnitReturned: string;
        quantityInStockUnitReturned: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        isPrinted: boolean;
        isInvoiced: boolean;
        isExtractedIntrastatLine: boolean;
        isPosted: boolean;
        reversalDate: string;
        qualityControlManagementMode: SubjectToControl;
        isControlledByQuality: boolean;
        purchaseType: PurchaseType;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        shipFromCountry: Country;
        issueState: MiscellaneousTable;
        stockMovementGroup: MiscellaneousTable;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        shippingSite: Site;
        releasedProduct: Product;
        sourceDocumentType: EntryTypeEnum;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        productStockManagement: StockManagement;
        billableIntercompanyStatus: integer;
        lineType: OrderLineType;
        movementCategory: MovementCategory;
        linkCoefficientForSubcontract: string;
        warehouse: Warehouse;
        matchingTolerance: MatchingTolerance;
        postedSubcontractCost: string;
        purchaseShipment: PurchaseShipment;
        purchaseShipmentLine: PurchaseShipmentLine;
        productType: PurchasingProductType;
        stockDetails: ClientCollection<StockJournal>;
        receiptLineText: TextStream;
        productStatisticalGroups: ClientCollection<PurchaseReceiptLineProductStatisticalGroups>;
        taxes: ClientCollection<PurchaseReceiptLineTaxes>;
    }
    export interface PurchaseReceiptLineInput extends ClientNodeInput {
        purchaseReceipt?: string;
        lineNumber?: integer | string;
        company?: string;
        receiptSite?: string;
        receiptDate?: string;
        purchaseSite?: string;
        purchaseOrder?: string;
        purchaseOrderLineNumber?: integer | string;
        purchaseOrderLine?: integer | string;
        orderType?: PurchaseOrderType;
        supplier?: string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        project?: string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInSupplierLanguage?: string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        discountCharge1?: decimal | string;
        discountCharge2?: decimal | string;
        discountCharge3?: decimal | string;
        discountCharge4?: decimal | string;
        discountCharge5?: decimal | string;
        discountCharge6?: decimal | string;
        discountCharge7?: decimal | string;
        discountCharge8?: decimal | string;
        discountCharge9?: decimal | string;
        discountCharge1Reason?: integer | string;
        discountCharge2Reason?: integer | string;
        discountCharge3Reason?: integer | string;
        discountCharge4Reason?: integer | string;
        discountCharge5Reason?: integer | string;
        discountCharge6Reason?: integer | string;
        discountCharge7Reason?: integer | string;
        discountCharge8Reason?: integer | string;
        discountCharge9Reason?: integer | string;
        netPrice?: decimal | string;
        netPriceInPurchaseUnit?: decimal | string;
        lineAmountExcludingTax?: decimal | string;
        lineCostPriceInCompanyCurrency?: decimal | string;
        linePurchaseCostInCompanyCurrency?: decimal | string;
        lineAmountIncludingTax?: decimal | string;
        distributedInvoicingElement1AmountExcludingTax?: decimal | string;
        distributedInvoicingElement2AmountExcludingTax?: decimal | string;
        distributedInvoicingElement3AmountExcludingTax?: decimal | string;
        distributedInvoicingElement4AmountExcludingTax?: decimal | string;
        distributedInvoicingElement5AmountExcludingTax?: decimal | string;
        distributedInvoicingElement6AmountExcludingTax?: decimal | string;
        distributedInvoicingElement7AmountExcludingTax?: decimal | string;
        distributedInvoicingElement8AmountExcludingTax?: decimal | string;
        distributedInvoicingElement9AmountExcludingTax?: decimal | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        calculatedTaxableBase3?: decimal | string;
        calculatedTaxableBase4?: decimal | string;
        calculatedTaxableBase5?: decimal | string;
        calculatedTaxableBase6?: decimal | string;
        calculatedTaxableBase7?: decimal | string;
        rebateOnTax1Amount?: decimal | string;
        taxableBase1Amount?: decimal | string;
        tax1Amount?: decimal | string;
        tax2Amount?: decimal | string;
        tax3Amount?: decimal | string;
        receiptTaxAmount?: decimal | string;
        issueTaxAmount?: decimal | string;
        otherTax1Amount?: decimal | string;
        otherTax2Amount?: decimal | string;
        tax1DeductibleAmount?: decimal | string;
        tax2DeductibleAmount?: decimal | string;
        tax3DeductibleAmount?: decimal | string;
        receiptTaxDeductibleAmount?: decimal | string;
        issueTaxDeductibleAmount?: decimal | string;
        otherTax1DeductibleAmount?: decimal | string;
        otherTax2DeductibleAmount?: decimal | string;
        netPriceIncludingInvoicingElementInCompanyCurrency?: decimal | string;
        costPriceInCompanyCurrency?: decimal | string;
        theoreticalStockCostInCompanyCurrency?: decimal | string;
        purchaseCostInCompanyCurrency?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnitInCompanyCurrency?: decimal | string;
        costStructure?: string;
        currency?: string;
        companyCurrency?: string;
        totalPurchaseCostInCompanyCurrency?: decimal | string;
        totalStockCostInCompanyCurrency?: decimal | string;
        totalPostedStockCostInCompanyCurrency?: decimal | string;
        quantityInReceiptUnitReceived?: decimal | string;
        quantityInPurchaseUnitReceived?: decimal | string;
        quantityInStockUnitReceived?: decimal | string;
        weight?: decimal | string;
        weightUnit?: string;
        volume?: decimal | string;
        volumeUnit?: string;
        receiptUnit?: string;
        purchaseUnit?: string;
        stockUnit?: string;
        receiptUnitToPurchaseUnitConversionFactor?: decimal | string;
        receiptUnitToStockUnitConversionFactor?: decimal | string;
        quantityInPurchaseUnitRejected?: decimal | string;
        quantityInStockUnitRejected?: decimal | string;
        quantityInPurchaseUnitReturned?: decimal | string;
        quantityInStockUnitReturned?: decimal | string;
        quantityInPurchaseUnitInvoiced?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        isPrinted?: boolean | string;
        isInvoiced?: boolean | string;
        isExtractedIntrastatLine?: boolean | string;
        isPosted?: boolean | string;
        reversalDate?: string;
        qualityControlManagementMode?: SubjectToControl;
        isControlledByQuality?: boolean | string;
        purchaseType?: PurchaseType;
        intrastatIncreaseCoefficient?: decimal | string;
        countryOfOrigin?: string;
        shipFromCountry?: string;
        issueState?: string;
        stockMovementGroup?: string;
        receiptTax?: string;
        issueTax?: string;
        otherTax1?: string;
        otherTax2?: string;
        shippingSite?: string;
        releasedProduct?: string;
        sourceDocumentType?: EntryTypeEnum;
        sourceDocument?: string;
        sourceDocumentLineNumber?: integer | string;
        sourceDocumentSequenceNumber?: integer | string;
        productStockManagement?: StockManagement;
        billableIntercompanyStatus?: integer | string;
        lineType?: OrderLineType;
        movementCategory?: MovementCategory;
        linkCoefficientForSubcontract?: decimal | string;
        warehouse?: string;
        matchingTolerance?: string;
        postedSubcontractCost?: decimal | string;
        purchaseShipment?: string;
        purchaseShipmentLine?: integer | string;
        productType?: PurchasingProductType;
        stockDetails?: Partial<StockJournalInput>[];
        receiptLineText?: TextStream;
        balance?: string;
        container?: string;
        productStatisticalGroups?: Partial<PurchaseReceiptLineProductStatisticalGroupsInput>[];
        taxes?: Partial<PurchaseReceiptLineTaxesInput>[];
    }
    export interface PurchaseReceiptLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseReceipt: PurchaseReceipt;
        lineNumber: integer;
        company: Company;
        receiptSite: Site;
        receiptDate: string;
        purchaseSite: Site;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLineNumber: integer;
        purchaseOrderLine: PurchaseOrderLine;
        orderType: PurchaseOrderType;
        supplier: Supplier;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        project: ProjectLink;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountCharge1: string;
        discountCharge2: string;
        discountCharge3: string;
        discountCharge4: string;
        discountCharge5: string;
        discountCharge6: string;
        discountCharge7: string;
        discountCharge8: string;
        discountCharge9: string;
        discountCharge1Reason: PurchasePriceReason;
        discountCharge2Reason: PurchasePriceReason;
        discountCharge3Reason: PurchasePriceReason;
        discountCharge4Reason: PurchasePriceReason;
        discountCharge5Reason: PurchasePriceReason;
        discountCharge6Reason: PurchasePriceReason;
        discountCharge7Reason: PurchasePriceReason;
        discountCharge8Reason: PurchasePriceReason;
        discountCharge9Reason: PurchasePriceReason;
        netPrice: string;
        netPriceInPurchaseUnit: string;
        lineAmountExcludingTax: string;
        lineCostPriceInCompanyCurrency: string;
        linePurchaseCostInCompanyCurrency: string;
        lineAmountIncludingTax: string;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        calculatedTaxableBase3: string;
        calculatedTaxableBase4: string;
        calculatedTaxableBase5: string;
        calculatedTaxableBase6: string;
        calculatedTaxableBase7: string;
        rebateOnTax1Amount: string;
        taxableBase1Amount: string;
        tax1Amount: string;
        tax2Amount: string;
        tax3Amount: string;
        receiptTaxAmount: string;
        issueTaxAmount: string;
        otherTax1Amount: string;
        otherTax2Amount: string;
        tax1DeductibleAmount: string;
        tax2DeductibleAmount: string;
        tax3DeductibleAmount: string;
        receiptTaxDeductibleAmount: string;
        issueTaxDeductibleAmount: string;
        otherTax1DeductibleAmount: string;
        otherTax2DeductibleAmount: string;
        netPriceIncludingInvoicingElementInCompanyCurrency: string;
        costPriceInCompanyCurrency: string;
        theoreticalStockCostInCompanyCurrency: string;
        purchaseCostInCompanyCurrency: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        costStructure: string;
        currency: Currency;
        companyCurrency: Currency;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        totalPostedStockCostInCompanyCurrency: string;
        quantityInReceiptUnitReceived: string;
        quantityInPurchaseUnitReceived: string;
        quantityInStockUnitReceived: string;
        weight: string;
        weightUnit: UnitOfMeasure;
        volume: string;
        volumeUnit: UnitOfMeasure;
        receiptUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        receiptUnitToPurchaseUnitConversionFactor: string;
        receiptUnitToStockUnitConversionFactor: string;
        quantityInPurchaseUnitRejected: string;
        quantityInStockUnitRejected: string;
        quantityInPurchaseUnitReturned: string;
        quantityInStockUnitReturned: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        isPrinted: boolean;
        isInvoiced: boolean;
        isExtractedIntrastatLine: boolean;
        isPosted: boolean;
        reversalDate: string;
        qualityControlManagementMode: SubjectToControl;
        isControlledByQuality: boolean;
        purchaseType: PurchaseType;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        shipFromCountry: Country;
        issueState: MiscellaneousTable;
        stockMovementGroup: MiscellaneousTable;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        shippingSite: Site;
        releasedProduct: Product;
        sourceDocumentType: EntryTypeEnum;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        productStockManagement: StockManagement;
        billableIntercompanyStatus: integer;
        lineType: OrderLineType;
        movementCategory: MovementCategory;
        linkCoefficientForSubcontract: string;
        warehouse: Warehouse;
        matchingTolerance: MatchingTolerance;
        postedSubcontractCost: string;
        purchaseShipment: PurchaseShipment;
        purchaseShipmentLine: PurchaseShipmentLine;
        productType: PurchasingProductType;
        stockDetails: ClientCollection<StockJournal>;
        receiptLineText: TextStream;
        balance: string;
        container: string;
        productStatisticalGroups: ClientCollection<PurchaseReceiptLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<PurchaseReceiptLineTaxesBinding>;
    }
    export interface PurchaseReceiptLine$Lookups {
        purchaseReceipt: QueryOperation<PurchaseReceipt>;
        company: QueryOperation<Company>;
        receiptSite: QueryOperation<Site>;
        purchaseSite: QueryOperation<Site>;
        purchaseOrder: QueryOperation<PurchaseOrder>;
        purchaseOrderLine: QueryOperation<PurchaseOrderLine>;
        supplier: QueryOperation<Supplier>;
        billBySupplier: QueryOperation<Supplier>;
        billBySupplierAddress: QueryOperation<SupplierAddress>;
        project: QueryOperation<ProjectLink>;
        product: QueryOperation<Product>;
        priceReason: QueryOperation<PurchasePriceReason>;
        discountCharge1Reason: QueryOperation<PurchasePriceReason>;
        discountCharge2Reason: QueryOperation<PurchasePriceReason>;
        discountCharge3Reason: QueryOperation<PurchasePriceReason>;
        discountCharge4Reason: QueryOperation<PurchasePriceReason>;
        discountCharge5Reason: QueryOperation<PurchasePriceReason>;
        discountCharge6Reason: QueryOperation<PurchasePriceReason>;
        discountCharge7Reason: QueryOperation<PurchasePriceReason>;
        discountCharge8Reason: QueryOperation<PurchasePriceReason>;
        discountCharge9Reason: QueryOperation<PurchasePriceReason>;
        currency: QueryOperation<Currency>;
        companyCurrency: QueryOperation<Currency>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        receiptUnit: QueryOperation<UnitOfMeasure>;
        purchaseUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        countryOfOrigin: QueryOperation<Country>;
        shipFromCountry: QueryOperation<Country>;
        issueState: QueryOperation<MiscellaneousTable>;
        stockMovementGroup: QueryOperation<MiscellaneousTable>;
        receiptTax: QueryOperation<Tax>;
        issueTax: QueryOperation<Tax>;
        otherTax1: QueryOperation<Tax>;
        otherTax2: QueryOperation<Tax>;
        shippingSite: QueryOperation<Site>;
        releasedProduct: QueryOperation<Product>;
        warehouse: QueryOperation<Warehouse>;
        matchingTolerance: QueryOperation<MatchingTolerance>;
        purchaseShipment: QueryOperation<PurchaseShipment>;
        purchaseShipmentLine: QueryOperation<PurchaseShipmentLine>;
    }
    export interface PurchaseReceiptLine$Operations {
        query: QueryOperation<PurchaseReceiptLine>;
        read: ReadOperation<PurchaseReceiptLine>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceiptLine>;
            query: AggregateQueryOperation<PurchaseReceiptLine>;
        };
        lookups(dataOrId: string | { data: PurchaseReceiptLineInput }): PurchaseReceiptLine$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReceiptLine>;
    }
    export interface PurchaseReceiptStatisticalGroups extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        statisticalGroup: MiscellaneousTable;
    }
    export interface PurchaseReceiptStatisticalGroupsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        id?: string;
        statisticalGroup?: string;
    }
    export interface PurchaseReceiptStatisticalGroupsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        id: string;
        statisticalGroup: MiscellaneousTable;
    }
    export interface PurchaseReceiptStatisticalGroups$Lookups {
        statisticalGroup: QueryOperation<MiscellaneousTable>;
    }
    export interface PurchaseReceiptStatisticalGroups$Operations {
        query: QueryOperation<PurchaseReceiptStatisticalGroups>;
        read: ReadOperation<PurchaseReceiptStatisticalGroups>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceiptStatisticalGroups>;
            query: AggregateQueryOperation<PurchaseReceiptStatisticalGroups>;
        };
        lookups(
            dataOrId: string | { data: PurchaseReceiptStatisticalGroupsInput },
        ): PurchaseReceiptStatisticalGroups$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReceiptStatisticalGroups>;
    }
    export interface PurchaseReceipt extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        receiptSite: Site;
        supplierPackingSlip: string;
        supplierPackingSlipDate: string;
        receiptDate: string;
        supplier: Supplier;
        address: SupplierAddress;
        shipFromAddress: SupplierAddress;
        shipFromZipCode: string;
        shipFromCity: string;
        shipFromState: string;
        shipFromCountry: Country;
        shipFromCountryName: string;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        carrier: Carrier;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        currency: Currency;
        rateType: ExchangeRateType;
        rate: string;
        taxRule: TaxRule;
        taxRuleType: integer;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        deliveryMode: DeliveryMode;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatStatiscalRule: IntrastatStatisticalRule;
        intrastatTransportMode: IntrastatTransportMode;
        incoterm: Incoterm;
        incotermTown: string;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        intrastatProcessingNumber: integer;
        project: ProjectLink;
        groupingCode: string;
        weightUnit: UnitOfMeasure;
        volumeUnit: UnitOfMeasure;
        grossWeight: string;
        netWeight: string;
        volume: string;
        numberOfLines: integer;
        numberOfLinesFullyInvoiced: integer;
        numberOfInvoicedLines: integer;
        numberOfPostedLines: integer;
        isPrinted: boolean;
        invoicedStatus: NoInPartInFull;
        isPosted: boolean;
        reversalDate: string;
        isIntersite: boolean;
        isIntercompany: boolean;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        amountOfLinesExcludingTax: string;
        totalQuantityOfLines: string;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalTaxAmount: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        warehouse: Warehouse;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        departureDate: string;
        arrivalDate: string;
        departureTime: string;
        arrivalTime: string;
        lines: ClientCollection<PurchaseReceiptLine>;
        receiptFooterText: TextStream;
        receiptHeaderText: TextStream;
        addressLines: ClientCollection<PurchaseReceiptAddressLines>;
        companyNames: ClientCollection<PurchaseReceiptCompanyNames>;
        dimensions: ClientCollection<PurchaseReceiptDimensions>;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseReceiptHeaderInvoiceLineAllocationElements>;
        headerInvoiceLineElements: ClientCollection<PurchaseReceiptHeaderInvoiceLineElements>;
        statisticalGroups: ClientCollection<PurchaseReceiptStatisticalGroups>;
    }
    export interface PurchaseReceiptInput extends ClientNodeInput {
        id?: string;
        company?: string;
        receiptSite?: string;
        supplierPackingSlip?: string;
        supplierPackingSlipDate?: string;
        receiptDate?: string;
        supplier?: string;
        address?: string;
        shipFromAddress?: string;
        shipFromZipCode?: string;
        shipFromCity?: string;
        shipFromState?: string;
        shipFromCountry?: string;
        shipFromCountryName?: string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        payToBusinessPartner?: string;
        payToBusinessPartnerAddress?: string;
        carrier?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        rate?: decimal | string;
        taxRule?: string;
        taxRuleType?: integer | string;
        earlyDiscountOrLateCharge?: string;
        deliveryMode?: string;
        intrastatTransactionNature?: string;
        intrastatStatiscalRule?: string;
        intrastatTransportMode?: IntrastatTransportMode;
        incoterm?: string;
        incotermTown?: string;
        intrastatTransportLocation?: CountryLocation;
        europeanUnionIdentification?: string;
        intrastatProcessingNumber?: integer | string;
        project?: string;
        groupingCode?: string;
        weightUnit?: string;
        volumeUnit?: string;
        grossWeight?: decimal | string;
        netWeight?: decimal | string;
        volume?: decimal | string;
        numberOfLines?: integer | string;
        numberOfLinesFullyInvoiced?: integer | string;
        numberOfInvoicedLines?: integer | string;
        numberOfPostedLines?: integer | string;
        isPrinted?: boolean | string;
        invoicedStatus?: NoInPartInFull;
        isPosted?: boolean | string;
        reversalDate?: string;
        isIntersite?: boolean | string;
        isIntercompany?: boolean | string;
        stockMovementCode?: string;
        stockAutomaticJournal?: string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        amountOfLinesExcludingTax?: decimal | string;
        totalQuantityOfLines?: decimal | string;
        totalWeightOfLines?: decimal | string;
        totalVolumeOfLines?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalTaxAmount?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        warehouse?: string;
        vehicleLicensePlate?: string;
        trailerLicensePlate?: string;
        departureDate?: string;
        arrivalDate?: string;
        departureTime?: string;
        arrivalTime?: string;
        lines?: Partial<PurchaseReceiptLineInput>[];
        receiptFooterText?: TextStream;
        receiptHeaderText?: TextStream;
        destination?: string;
        document?: string;
        transaction?: string;
        addressLines?: Partial<PurchaseReceiptAddressLinesInput>[];
        companyNames?: Partial<PurchaseReceiptCompanyNamesInput>[];
        dimensions?: Partial<PurchaseReceiptDimensionsInput>[];
        headerInvoiceLineAllocationElements?: Partial<PurchaseReceiptHeaderInvoiceLineAllocationElementsInput>[];
        headerInvoiceLineElements?: Partial<PurchaseReceiptHeaderInvoiceLineElementsInput>[];
        statisticalGroups?: Partial<PurchaseReceiptStatisticalGroupsInput>[];
    }
    export interface PurchaseReceiptBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        receiptSite: Site;
        supplierPackingSlip: string;
        supplierPackingSlipDate: string;
        receiptDate: string;
        supplier: Supplier;
        address: SupplierAddress;
        shipFromAddress: SupplierAddress;
        shipFromZipCode: string;
        shipFromCity: string;
        shipFromState: string;
        shipFromCountry: Country;
        shipFromCountryName: string;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        carrier: Carrier;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        currency: Currency;
        rateType: ExchangeRateType;
        rate: string;
        taxRule: TaxRule;
        taxRuleType: integer;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        deliveryMode: DeliveryMode;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatStatiscalRule: IntrastatStatisticalRule;
        intrastatTransportMode: IntrastatTransportMode;
        incoterm: Incoterm;
        incotermTown: string;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        intrastatProcessingNumber: integer;
        project: ProjectLink;
        groupingCode: string;
        weightUnit: UnitOfMeasure;
        volumeUnit: UnitOfMeasure;
        grossWeight: string;
        netWeight: string;
        volume: string;
        numberOfLines: integer;
        numberOfLinesFullyInvoiced: integer;
        numberOfInvoicedLines: integer;
        numberOfPostedLines: integer;
        isPrinted: boolean;
        invoicedStatus: NoInPartInFull;
        isPosted: boolean;
        reversalDate: string;
        isIntersite: boolean;
        isIntercompany: boolean;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        amountOfLinesExcludingTax: string;
        totalQuantityOfLines: string;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalTaxAmount: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        warehouse: Warehouse;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        departureDate: string;
        arrivalDate: string;
        departureTime: string;
        arrivalTime: string;
        lines: ClientCollection<PurchaseReceiptLine>;
        receiptFooterText: TextStream;
        receiptHeaderText: TextStream;
        destination: string;
        document: string;
        transaction: string;
        addressLines: ClientCollection<PurchaseReceiptAddressLinesBinding>;
        companyNames: ClientCollection<PurchaseReceiptCompanyNamesBinding>;
        dimensions: ClientCollection<PurchaseReceiptDimensionsBinding>;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseReceiptHeaderInvoiceLineAllocationElementsBinding>;
        headerInvoiceLineElements: ClientCollection<PurchaseReceiptHeaderInvoiceLineElementsBinding>;
        statisticalGroups: ClientCollection<PurchaseReceiptStatisticalGroupsBinding>;
    }
    export interface PurchaseReceipt$Lookups {
        company: QueryOperation<Company>;
        receiptSite: QueryOperation<Site>;
        supplier: QueryOperation<Supplier>;
        address: QueryOperation<SupplierAddress>;
        shipFromAddress: QueryOperation<SupplierAddress>;
        shipFromCountry: QueryOperation<Country>;
        billBySupplier: QueryOperation<Supplier>;
        billBySupplierAddress: QueryOperation<SupplierAddress>;
        payToBusinessPartner: QueryOperation<BusinessPartner>;
        payToBusinessPartnerAddress: QueryOperation<BusinessPartnerAddress>;
        carrier: QueryOperation<Carrier>;
        forwardingAgent: QueryOperation<Carrier>;
        forwardingAgentAddress: QueryOperation<SupplierAddress>;
        currency: QueryOperation<Currency>;
        taxRule: QueryOperation<TaxRule>;
        earlyDiscountOrLateCharge: QueryOperation<EarlyDiscountLateCharge>;
        deliveryMode: QueryOperation<DeliveryMode>;
        intrastatTransactionNature: QueryOperation<IntrastatTransactionNature>;
        intrastatStatiscalRule: QueryOperation<IntrastatStatisticalRule>;
        incoterm: QueryOperation<Incoterm>;
        project: QueryOperation<ProjectLink>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        stockMovementCode: QueryOperation<MiscellaneousTable>;
        stockAutomaticJournal: QueryOperation<AutomaticJournal>;
        weightUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        volumeUnitForDistributionOnLines: QueryOperation<UnitOfMeasure>;
        warehouse: QueryOperation<Warehouse>;
    }
    export interface PurchaseReceipt$Operations {
        query: QueryOperation<PurchaseReceipt>;
        read: ReadOperation<PurchaseReceipt>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReceipt>;
            query: AggregateQueryOperation<PurchaseReceipt>;
        };
        create: CreateOperation<PurchaseReceiptInput, PurchaseReceipt>;
        getDuplicate: GetDuplicateOperation<PurchaseReceipt>;
        lookups(dataOrId: string | { data: PurchaseReceiptInput }): PurchaseReceipt$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReceipt>;
    }
    export interface PurchaseReturnLineTaxes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseReturn: string;
        lineNumber: integer;
        tax: Tax;
    }
    export interface PurchaseReturnLineTaxesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        purchaseReturn?: string;
        lineNumber?: integer | string;
        tax?: string;
    }
    export interface PurchaseReturnLineTaxesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        purchaseReturn: string;
        lineNumber: integer;
        tax: Tax;
    }
    export interface PurchaseReturnLineTaxes$Lookups {
        tax: QueryOperation<Tax>;
    }
    export interface PurchaseReturnLineTaxes$Operations {
        query: QueryOperation<PurchaseReturnLineTaxes>;
        read: ReadOperation<PurchaseReturnLineTaxes>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReturnLineTaxes>;
            query: AggregateQueryOperation<PurchaseReturnLineTaxes>;
        };
        lookups(dataOrId: string | { data: PurchaseReturnLineTaxesInput }): PurchaseReturnLineTaxes$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReturnLineTaxes>;
    }
    export interface PurchaseReturnLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseReturn: PurchaseReturn;
        lineNumber: integer;
        company: Company;
        returnSite: Site;
        returnDate: string;
        product: Product;
        returnLineText: TextStream;
        taxes: ClientCollection<PurchaseReturnLineTaxes>;
    }
    export interface PurchaseReturnLineInput extends ClientNodeInput {
        purchaseReturn?: string;
        lineNumber?: integer | string;
        company?: string;
        returnSite?: string;
        returnDate?: string;
        product?: string;
        returnLineText?: TextStream;
        taxes?: Partial<PurchaseReturnLineTaxesInput>[];
    }
    export interface PurchaseReturnLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseReturn: PurchaseReturn;
        lineNumber: integer;
        company: Company;
        returnSite: Site;
        returnDate: string;
        product: Product;
        returnLineText: TextStream;
        taxes: ClientCollection<PurchaseReturnLineTaxesBinding>;
    }
    export interface PurchaseReturnLine$Lookups {
        purchaseReturn: QueryOperation<PurchaseReturn>;
        company: QueryOperation<Company>;
        returnSite: QueryOperation<Site>;
        product: QueryOperation<Product>;
    }
    export interface PurchaseReturnLine$Operations {
        query: QueryOperation<PurchaseReturnLine>;
        read: ReadOperation<PurchaseReturnLine>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReturnLine>;
            query: AggregateQueryOperation<PurchaseReturnLine>;
        };
        lookups(dataOrId: string | { data: PurchaseReturnLineInput }): PurchaseReturnLine$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReturnLine>;
    }
    export interface PurchaseReturn extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        returnSite: Site;
        returnDate: string;
        supplier: Supplier;
        returnFooterText: TextStream;
        returnHeaderText: TextStream;
    }
    export interface PurchaseReturnInput extends ClientNodeInput {
        id?: string;
        company?: string;
        returnSite?: string;
        returnDate?: string;
        supplier?: string;
        returnFooterText?: TextStream;
        returnHeaderText?: TextStream;
    }
    export interface PurchaseReturnBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        returnSite: Site;
        returnDate: string;
        supplier: Supplier;
        returnFooterText: TextStream;
        returnHeaderText: TextStream;
    }
    export interface PurchaseReturn$Lookups {
        company: QueryOperation<Company>;
        returnSite: QueryOperation<Site>;
        supplier: QueryOperation<Supplier>;
    }
    export interface PurchaseReturn$Operations {
        query: QueryOperation<PurchaseReturn>;
        read: ReadOperation<PurchaseReturn>;
        aggregate: {
            read: AggregateReadOperation<PurchaseReturn>;
            query: AggregateQueryOperation<PurchaseReturn>;
        };
        lookups(dataOrId: string | { data: PurchaseReturnInput }): PurchaseReturn$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseReturn>;
    }
    export interface PurchaseShipmentLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseShipment: PurchaseShipment;
        lineNumber: integer;
        purchaseOrderNumber: PurchaseOrder;
        purchaseOrderLineNumber: integer;
        purchaseOrderSequenceNumber: PurchaseOrderLine;
        product: Product;
        quantityInOrderUnitShipped: string;
        quantityInPurchaseUnitShipped: string;
        quantityInStockUnitShipped: string;
        quantityInPurchaseUnitReceived: string;
        quantityInPurchaseUnitPreReceived: string;
        orderUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        orderUnitToPurchaseUnitConversionFactor: string;
        isClosed: boolean;
        isPreReceived: boolean;
        quantityInPurchaseUnitExpected: string;
    }
    export interface PurchaseShipmentLineInput extends ClientNodeInput {
        purchaseShipment?: string;
        lineNumber?: integer | string;
        purchaseOrderNumber?: string;
        purchaseOrderLineNumber?: integer | string;
        purchaseOrderSequenceNumber?: integer | string;
        product?: string;
        quantityInOrderUnitShipped?: decimal | string;
        quantityInPurchaseUnitShipped?: decimal | string;
        quantityInStockUnitShipped?: decimal | string;
        quantityInPurchaseUnitReceived?: decimal | string;
        quantityInPurchaseUnitPreReceived?: decimal | string;
        orderUnit?: string;
        purchaseUnit?: string;
        stockUnit?: string;
        orderUnitToPurchaseUnitConversionFactor?: decimal | string;
        isClosed?: boolean | string;
        isPreReceived?: boolean | string;
    }
    export interface PurchaseShipmentLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseShipment: PurchaseShipment;
        lineNumber: integer;
        purchaseOrderNumber: PurchaseOrder;
        purchaseOrderLineNumber: integer;
        purchaseOrderSequenceNumber: PurchaseOrderLine;
        product: Product;
        quantityInOrderUnitShipped: string;
        quantityInPurchaseUnitShipped: string;
        quantityInStockUnitShipped: string;
        quantityInPurchaseUnitReceived: string;
        quantityInPurchaseUnitPreReceived: string;
        orderUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        orderUnitToPurchaseUnitConversionFactor: string;
        isClosed: boolean;
        isPreReceived: boolean;
        quantityInPurchaseUnitExpected: string;
    }
    export interface PurchaseShipmentLine$Lookups {
        purchaseShipment: QueryOperation<PurchaseShipment>;
        purchaseOrderNumber: QueryOperation<PurchaseOrder>;
        purchaseOrderSequenceNumber: QueryOperation<PurchaseOrderLine>;
        product: QueryOperation<Product>;
        orderUnit: QueryOperation<UnitOfMeasure>;
        purchaseUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
    }
    export interface PurchaseShipmentLine$Operations {
        query: QueryOperation<PurchaseShipmentLine>;
        read: ReadOperation<PurchaseShipmentLine>;
        aggregate: {
            read: AggregateReadOperation<PurchaseShipmentLine>;
            query: AggregateQueryOperation<PurchaseShipmentLine>;
        };
        lookups(dataOrId: string | { data: PurchaseShipmentLineInput }): PurchaseShipmentLine$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseShipmentLine>;
    }
    export interface PurchaseShipment extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        shipmentId: string;
        shipDate: string;
        businessPartner: BusinessPartner;
        site: Site;
        supplier: Supplier;
        countryOfOrigin: Country;
        destinationCountry: Country;
        transportNumber: Transport;
        shipmentRecordType: ShipmentRecordType;
        expectedArrivalDate: string;
        transitStart: TransitArea;
        transitArrival: TransitArea;
        departureDate: string;
        arrivalDate: string;
        transportMode: TransportMode;
        carrier: Carrier;
        company: Company;
        dateShift: integer;
        shipmentManagement: ShipmentManagement;
        container: Container;
        quantityOfContainers: integer;
        maximumWeight: string;
        weightUnit: UnitOfMeasure;
        maximumVolume: string;
        volumeUnit: UnitOfMeasure;
        shipmentTotalWeight: string;
        shipmentTotalVolume: string;
        availableWeight: string;
        availableVolume: string;
        shipmentStatus: ShipmentStatus;
        isShipped: boolean;
    }
    export interface PurchaseShipmentInput extends ClientNodeInput {
        id?: string;
        shipmentId?: string;
        shipDate?: string;
        businessPartner?: string;
        site?: string;
        supplier?: string;
        countryOfOrigin?: string;
        destinationCountry?: string;
        transportNumber?: string;
        shipmentRecordType?: ShipmentRecordType;
        expectedArrivalDate?: string;
        transitStart?: string;
        transitArrival?: string;
        departureDate?: string;
        arrivalDate?: string;
        transportMode?: TransportMode;
        carrier?: string;
        company?: string;
        dateShift?: integer | string;
        shipmentManagement?: ShipmentManagement;
        container?: string;
        quantityOfContainers?: integer | string;
        maximumWeight?: decimal | string;
        weightUnit?: string;
        maximumVolume?: decimal | string;
        volumeUnit?: string;
        shipmentTotalWeight?: decimal | string;
        shipmentTotalVolume?: decimal | string;
        availableWeight?: decimal | string;
        availableVolume?: decimal | string;
        shipmentStatus?: ShipmentStatus;
        isShipped?: boolean | string;
    }
    export interface PurchaseShipmentBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        shipmentId: string;
        shipDate: string;
        businessPartner: BusinessPartner;
        site: Site;
        supplier: Supplier;
        countryOfOrigin: Country;
        destinationCountry: Country;
        transportNumber: Transport;
        shipmentRecordType: ShipmentRecordType;
        expectedArrivalDate: string;
        transitStart: TransitArea;
        transitArrival: TransitArea;
        departureDate: string;
        arrivalDate: string;
        transportMode: TransportMode;
        carrier: Carrier;
        company: Company;
        dateShift: integer;
        shipmentManagement: ShipmentManagement;
        container: Container;
        quantityOfContainers: integer;
        maximumWeight: string;
        weightUnit: UnitOfMeasure;
        maximumVolume: string;
        volumeUnit: UnitOfMeasure;
        shipmentTotalWeight: string;
        shipmentTotalVolume: string;
        availableWeight: string;
        availableVolume: string;
        shipmentStatus: ShipmentStatus;
        isShipped: boolean;
    }
    export interface PurchaseShipment$Lookups {
        businessPartner: QueryOperation<BusinessPartner>;
        site: QueryOperation<Site>;
        supplier: QueryOperation<Supplier>;
        countryOfOrigin: QueryOperation<Country>;
        destinationCountry: QueryOperation<Country>;
        transportNumber: QueryOperation<Transport>;
        transitStart: QueryOperation<TransitArea>;
        transitArrival: QueryOperation<TransitArea>;
        carrier: QueryOperation<Carrier>;
        company: QueryOperation<Company>;
        container: QueryOperation<Container>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
    }
    export interface PurchaseShipment$Operations {
        query: QueryOperation<PurchaseShipment>;
        read: ReadOperation<PurchaseShipment>;
        aggregate: {
            read: AggregateReadOperation<PurchaseShipment>;
            query: AggregateQueryOperation<PurchaseShipment>;
        };
        lookups(dataOrId: string | { data: PurchaseShipmentInput }): PurchaseShipment$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseShipment>;
    }
    export interface Transport extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        localizedDescription: string;
        carrier: Carrier;
        businessPartner: BusinessPartner;
        transportMode: TransportMode;
        transportIdentification: string;
        departurePlace: TransitArea;
        arrivalPlace: TransitArea;
        departureDate: string;
        expectedArrivalDate: string;
        arrivalDate: string;
    }
    export interface TransportInput extends ClientNodeInput {
        id?: string;
        localizedDescription?: string;
        carrier?: string;
        businessPartner?: string;
        transportMode?: TransportMode;
        transportIdentification?: string;
        departurePlace?: string;
        arrivalPlace?: string;
        departureDate?: string;
        expectedArrivalDate?: string;
        arrivalDate?: string;
    }
    export interface TransportBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        localizedDescription: string;
        carrier: Carrier;
        businessPartner: BusinessPartner;
        transportMode: TransportMode;
        transportIdentification: string;
        departurePlace: TransitArea;
        arrivalPlace: TransitArea;
        departureDate: string;
        expectedArrivalDate: string;
        arrivalDate: string;
    }
    export interface Transport$Lookups {
        carrier: QueryOperation<Carrier>;
        businessPartner: QueryOperation<BusinessPartner>;
        departurePlace: QueryOperation<TransitArea>;
        arrivalPlace: QueryOperation<TransitArea>;
    }
    export interface Transport$Operations {
        query: QueryOperation<Transport>;
        read: ReadOperation<Transport>;
        aggregate: {
            read: AggregateReadOperation<Transport>;
            query: AggregateQueryOperation<Transport>;
        };
        lookups(dataOrId: string | { data: TransportInput }): Transport$Lookups;
        getDefaults: GetDefaultsOperation<Transport>;
    }
    export interface Package {
        '@sage/x3-purchasing/Cost': Cost$Operations;
        '@sage/x3-purchasing/ProductSupplierView': ProductSupplierView$Operations;
        '@sage/x3-purchasing/PurchaseEntryTransaction': PurchaseEntryTransaction$Operations;
        '@sage/x3-purchasing/PurchaseInvoiceHeaderInvoiceLineAllocationElements': PurchaseInvoiceHeaderInvoiceLineAllocationElements$Operations;
        '@sage/x3-purchasing/PurchaseInvoiceHeaderInvoiceLineElements': PurchaseInvoiceHeaderInvoiceLineElements$Operations;
        '@sage/x3-purchasing/PurchaseInvoiceLineProductStatisticalGroups': PurchaseInvoiceLineProductStatisticalGroups$Operations;
        '@sage/x3-purchasing/PurchaseInvoiceLineTaxes': PurchaseInvoiceLineTaxes$Operations;
        '@sage/x3-purchasing/PurchaseInvoiceLine': PurchaseInvoiceLine$Operations;
        '@sage/x3-purchasing/PurchaseInvoiceSupplierStatisticalGroups': PurchaseInvoiceSupplierStatisticalGroups$Operations;
        '@sage/x3-purchasing/PurchaseInvoice': PurchaseInvoice$Operations;
        '@sage/x3-purchasing/PurchaseOrderCompanyNames': PurchaseOrderCompanyNames$Operations;
        '@sage/x3-purchasing/PurchaseOrderDimensions': PurchaseOrderDimensions$Operations;
        '@sage/x3-purchasing/PurchaseOrderDiscountOrChargeCalculationRules': PurchaseOrderDiscountOrChargeCalculationRules$Operations;
        '@sage/x3-purchasing/PurchaseOrderFromSupplierAddressLines': PurchaseOrderFromSupplierAddressLines$Operations;
        '@sage/x3-purchasing/PurchaseOrderFromSupplierCompanyNames': PurchaseOrderFromSupplierCompanyNames$Operations;
        '@sage/x3-purchasing/PurchaseOrderHeaderInvoiceLineAllocationElements': PurchaseOrderHeaderInvoiceLineAllocationElements$Operations;
        '@sage/x3-purchasing/PurchaseOrderLineProductStatisticalGroups': PurchaseOrderLineProductStatisticalGroups$Operations;
        '@sage/x3-purchasing/PurchaseOrderLineTaxes': PurchaseOrderLineTaxes$Operations;
        '@sage/x3-purchasing/PurchaseOrderLine': PurchaseOrderLine$Operations;
        '@sage/x3-purchasing/PurchaseOrderQuantityLinesSupplierView': PurchaseOrderQuantityLinesSupplierView$Operations;
        '@sage/x3-purchasing/PurchaseOrderShipFromSupplierAddressLines': PurchaseOrderShipFromSupplierAddressLines$Operations;
        '@sage/x3-purchasing/PurchaseOrderSupplierStatisticalGroups': PurchaseOrderSupplierStatisticalGroups$Operations;
        '@sage/x3-purchasing/PurchaseOrder': PurchaseOrder$Operations;
        '@sage/x3-purchasing/PurchaseReceiptAddressLines': PurchaseReceiptAddressLines$Operations;
        '@sage/x3-purchasing/PurchaseReceiptCompanyNames': PurchaseReceiptCompanyNames$Operations;
        '@sage/x3-purchasing/PurchaseReceiptDimensions': PurchaseReceiptDimensions$Operations;
        '@sage/x3-purchasing/PurchaseReceiptHeaderInvoiceLineAllocationElements': PurchaseReceiptHeaderInvoiceLineAllocationElements$Operations;
        '@sage/x3-purchasing/PurchaseReceiptHeaderInvoiceLineElements': PurchaseReceiptHeaderInvoiceLineElements$Operations;
        '@sage/x3-purchasing/PurchaseReceiptLineProductStatisticalGroups': PurchaseReceiptLineProductStatisticalGroups$Operations;
        '@sage/x3-purchasing/PurchaseReceiptLineTaxes': PurchaseReceiptLineTaxes$Operations;
        '@sage/x3-purchasing/PurchaseReceiptLine': PurchaseReceiptLine$Operations;
        '@sage/x3-purchasing/PurchaseReceiptStatisticalGroups': PurchaseReceiptStatisticalGroups$Operations;
        '@sage/x3-purchasing/PurchaseReceipt': PurchaseReceipt$Operations;
        '@sage/x3-purchasing/PurchaseReturnLineTaxes': PurchaseReturnLineTaxes$Operations;
        '@sage/x3-purchasing/PurchaseReturnLine': PurchaseReturnLine$Operations;
        '@sage/x3-purchasing/PurchaseReturn': PurchaseReturn$Operations;
        '@sage/x3-purchasing/PurchaseShipmentLine': PurchaseShipmentLine$Operations;
        '@sage/x3-purchasing/PurchaseShipment': PurchaseShipment$Operations;
        '@sage/x3-purchasing/Transport': Transport$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3FinanceData$Package,
            SageX3InvoicingData$Package,
            SageX3ManufacturingData$Package,
            SageX3MasterData$Package,
            SageX3PhysicalFlowsData$Package,
            SageX3ProjectManagementData$Package,
            SageX3PurchasingData$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-purchasing-api' {
    export type * from '@sage/x3-purchasing-api-partial';
}
declare module '@sage/x3-finance-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-physical-flows-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-api';
    export interface GraphApi extends GraphApiExtension {}
}
