import { SalesDeliveryLine } from '@sage/x3-sales-api';
import { GraphApi } from '@sage/x3-stock-api';
import { Dict } from '@sage/xtrem-shared';
import * as ui from '@sage/xtrem-ui';
import {
    IntersiteReceiptDetailsRecordManager,
    IntersiteReceiptSession,
} from '../client-functions/intersite-receipt-details-control';

@ui.decorators.page<MobileIntersiteReceiptSelectFromDelivery>({
    title: 'Intersite receipt',
    subtitle: 'Select a line',
    module: 'x3-purchasing-sales',
    node: '@sage/x3-sales/SalesDelivery',
    mode: 'default',
    isTitleHidden: true,
    isTransient: false,
    navigationPanel: undefined,
    businessActions() {
        return [this.previousButton];
    },
    async onLoad() {
        this.isLocationPreloaded = this.$.queryParameters?.isLocationPreloaded === '1';
        this.siteField.value = String(this.$.storage.get('mobile-selected-stock-site'));
        this.id.value = String(this.$.queryParameters._id);
        this._intersiteReceiptRecordManager = new IntersiteReceiptDetailsRecordManager(this);
        this._intersiteSession = this._intersiteReceiptRecordManager.intersiteSession;
    },
})
export class MobileIntersiteReceiptSelectFromDelivery extends ui.Page<GraphApi> {
    private _intersiteReceiptRecordManager: IntersiteReceiptDetailsRecordManager;
    private _intersiteSession: IntersiteReceiptSession;
    isLocationPreloaded: boolean;

    @ui.decorators.section<MobileIntersiteReceiptSelectFromDelivery>({
        isTitleHidden: true,
        isHidden: false,
    })
    mainSection: ui.containers.Section;

    @ui.decorators.block<MobileIntersiteReceiptSelectFromDelivery>({
        parent() {
            return this.mainSection;
        },
    })
    mainBlock: ui.containers.Block;

    @ui.decorators.textField<MobileIntersiteReceiptSelectFromDelivery>({
        parent() {
            return this.mainBlock;
        },
        isTransient: false,
        isHidden: true,
    })
    id: ui.fields.Text;

    @ui.decorators.labelField<MobileIntersiteReceiptSelectFromDelivery>({
        parent() {
            return this.mainBlock;
        },
        isTransient: true,
        isHidden: true,
    })
    siteField: ui.fields.Label;

    @ui.decorators.textField<MobileIntersiteReceiptSelectFromDelivery>({
        parent() {
            return this.mainBlock;
        },
        isTitleHidden: false,
        isTransient: true,
        isFullWidth: true,
        title: 'Product',
        placeholder: 'Search...',
        onInputValueChange(this, rawData: string) {
            if (rawData) {
                this.salesDeliveryLines.filter = {
                    ...this.salesDeliveryLines.filter,
                    product: { code: { _regex: rawData } },
                };
            } else {
                this.salesDeliveryLines.filter = {
                    salesDelivery: { id: this.id.value as string },
                    receiptStatus: { _ne: 2 },
                    lineNumber: { _in: JSON.parse(this.$.queryParameters.deliveryLines as string) },
                };
            }
            this.product.isDirty = false;
        },
        onChange() {
            this.product.isDirty = false;
        },
    })
    product: ui.fields.Text;

    @ui.decorators.pageAction<MobileIntersiteReceiptSelectFromDelivery>({
        title: 'Previous',
        shortcut: ['f4'],
        buttonType: 'primary',
        isHidden: false,
        async onClick() {
            this._intersiteReceiptRecordManager.intersiteSession = this._intersiteSession;
            this.$.setPageClean();
            this.$.router.goTo('@sage/x3-purchasing-sales/MobileIntersiteReceipt', {
                _id: this.id.value as string,
            });
        },
    })
    previousButton: ui.PageAction;

    @ui.decorators.tableField<MobileIntersiteReceiptSelectFromDelivery, SalesDeliveryLine>({
        parent() {
            return this.mainBlock;
        },
        node: '@sage/x3-sales/SalesDeliveryLine',
        isChangeIndicatorDisabled: true,
        canFilter: false,
        canSelect: false,
        canExport: false,
        canResizeColumns: false,
        canUserHideColumns: false,
        isTitleHidden: false,
        isTransient: false,
        isFullWidth: true,
        isDisabled: false,
        hasSearchBoxMobile: false,
        cardView: true,
        displayMode: ui.fields.TableDisplayMode.compact,
        mobileCard: undefined,
        orderBy: {
            salesDelivery: 1,
            lineNumber: 1,
        },
        filter() {
            return {
                salesDelivery: { id: this.$.queryParameters._id as string },
                receiptStatus: { _ne: 2 },
                lineNumber: { _in: JSON.parse(this.$.queryParameters.deliveryLines as string) },
            };
        },
        columns: [
            ui.nestedFields.reference({
                node: '@sage/x3-master-data/Product',
                bind: 'product',
                valueField: 'code',
                isReadOnly: true,
                canFilter: true,
            }),
            ui.nestedFields.numeric({
                bind: 'quantityInSalesUnitDelivered' as any,
                canFilter: false,
                isReadOnly: true,
                postfix(_value: any, rowData?: any) {
                    return rowData?.salesUnit.code;
                },
                scale(value, rowValue?: Dict<any>) {
                    return rowValue?.salesUnit?.numberOfDecimals ?? 0;
                },
            }),
            ui.nestedFields.reference({
                node: '@sage/x3-master-data/Product',
                bind: 'product',
                valueField: 'localizedDescription1',
                canFilter: true,
                isReadOnly: true,
            }),
            ui.nestedFields.reference({
                node: '@sage/x3-master-data/UnitOfMeasure',
                bind: 'salesUnit',
                valueField: 'code',
                canFilter: false,
                isHidden: true,
                isReadOnly: true,
            }),
            ui.nestedFields.reference({
                node: '@sage/x3-master-data/UnitOfMeasure',
                bind: 'salesUnit',
                valueField: 'numberOfDecimals',
                canFilter: false,
                isHidden: true,
                isReadOnly: true,
            }),
            ui.nestedFields.numeric({
                bind: 'lineNumber',
                canFilter: false,
                isHidden: true,
                isReadOnly: true,
            }),
            ui.nestedFields.numeric({
                bind: 'receiptStatus',
                canFilter: false,
                isHidden: true,
            }),
        ],
        async onRowClick(_recordId: string, rowItem: SalesDeliveryLine) {
            this._intersiteSession?.purchaseReceipt?.lines?.push({
                salesDelivery: String(this.$.queryParameters._id),
                salesDeliveryLine: rowItem.lineNumber,
                product: rowItem.product.code,
                receiptSite: this._intersiteSession.purchaseReceipt.receiptSite,
                receiptDate: this._intersiteSession.purchaseReceipt.receiptDate,
                supplier: this._intersiteSession.purchaseReceipt.supplier,
                stockDetails: [],
            });
            this._intersiteReceiptRecordManager.intersiteSession = this._intersiteSession;
            this.$.router.goTo(`@sage/x3-purchasing-sales/MobileIntersiteReceiptEnterReceiptDetail`, {
                _id: this.id.value as string,
                deliveryLines: this.$.queryParameters.deliveryLines,
                deliveryLineNumber: rowItem.lineNumber,
                isLocationPreloaded: `${this.isLocationPreloaded ? '1' : '0'}`,
            });
            return true;
        },
    })
    salesDeliveryLines: ui.fields.Table<SalesDeliveryLine>;
}
