import {extractEdges} from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';


export async function getSalesDeliveries(pageInstance: ui.Page, purchaseOrderId: string): Promise<any[]> {
    const page = pageInstance as any;
    return extractEdges(
            await page.$.graph
            .node('@sage/x3-sales/SalesDeliveryLine')
            .query(
                ui.queryUtils.edgesSelector(
                    {
                        salesDelivery: {
                            _id: true,
                            id: true,
                            salesSite: {
                                code: true,
                            },
                            isValidated: true,
                        },
                    },
                    {
                        filter: {
                            salesOrderLine: {
                                purchaseOrder: {
                                    id: purchaseOrderId,
                                },
                            },
                        },
                    },
                ),
            )
            .execute(),
        ) as any[];
}

export async function goToPurchaseOrderSelectADelivery(pageInstance: ui.Page) {
    const page = pageInstance as any;
    const purchaseOrderId = page['purchaseOrder']?.value ?? '';
    const supplierCode = page['orderFromSupplier']?.value ?? '';
    const orderFromSupplier = page.$.queryParameters['orderFromSupplier'] ?? '';
    const site = page.$.queryParameters['site'] ?? '';
    const receiptDate = page.$.queryParameters['receiptDate'] ?? '';
    const isIntersite = page.$.queryParameters['isIntersite'] ?? '';
    const shortCompanyName = page.$.queryParameters['shortCompanyName'] ?? '';

    const result =  await getSalesDeliveries(page,purchaseOrderId);
    const _salesDeliveries: any[] = [];
    result.forEach(salesDeliveryLine => {
        if (!_salesDeliveries.find(item => item.id === salesDeliveryLine.salesDelivery.id)) {
            _salesDeliveries.push({
                _id: salesDeliveryLine.salesDelivery._id,
                id: salesDeliveryLine.salesDelivery.id,
                salesSite: {
                    code: salesDeliveryLine.salesDelivery.salesSite.code,
                },
                isValidated: salesDeliveryLine.salesDelivery.isValidated,
            });
        }
    });

    switch ( _salesDeliveries.length ) {
        case 0:
            page.$.removeToasts();
            page.$.showToast(
                `${ui.localize(
                    '@sage/x3-purchasing-sales/notification-error-no-delivery-to-receive',
                    'No delivery to receive',
                )}`,
                { type: 'error', timeout: 30000 },
            );
            break;
        case 1:
            if (_salesDeliveries[0]?.isValidated) {
                page.$.router.goTo('@sage/x3-purchasing-sales/MobileIntersiteReceipt', {
                    salesDeliveryId: _salesDeliveries[0].id,
                    salesSite: _salesDeliveries[0].salesSite.code,
                });
            } else {
                page.$.removeToasts();
                page.$.showToast(
                    `${ui.localize(
                        '@sage/x3-purchasing-sales/notification-error-no-delivery-validated-intersite-receipt-is-not-possible',
                        'No delivery validated, Intersite receipt is not possible',
                    )}`,
                    { type: 'error', timeout: 30000 },
                );
            }
            break;
        default:
            page.$.router.goTo('@sage/x3-purchasing-sales/MobileViewPurchaseOrderSelectADelivery', {
                purchaseOrderId: purchaseOrderId,
                supplierCode: supplierCode,
                orderFromSupplier: orderFromSupplier,
                site: site,
                receiptDate: receiptDate,
                isIntersite: isIntersite,
                shortCompanyName: shortCompanyName,
                salesDeliveries: JSON.stringify(_salesDeliveries),
            });
            break;
     }

}

export async function goToPurchaseOrderToReceiveSelectADelivery(pageInstance: ui.Page) {
    const page = pageInstance as any;
    const purchaseOrderId = page['purchaseOrderId'].value ?? '';
    const productCode = page.$.queryParameters['productCode'] ?? '';
    const upcCode = page.$.queryParameters['upcCode'] ?? '';
    const lineNumber = page.$.queryParameters['lineNumber'] ?? '';
    const receiptDate = page.$.queryParameters['receiptDate'] ?? '';
    const isIntersite = page.$.queryParameters['isIntersite'] ?? '';

    const result =  await getSalesDeliveries(page,purchaseOrderId);
    const _salesDeliveries: any[] = [];
    let _supplierCode: string | undefined;
    let _supplierShortName: string | undefined;
    result.forEach(salesDeliveryLine => {
        if (!_salesDeliveries.find(item => item.id === salesDeliveryLine.salesDelivery.id)) {
            if (!_supplierCode) {
                const _supplier = salesDeliveryLine?.salesOrderLine?.purchaseOrder?.orderFromSupplier?.code;
                _supplierCode = _supplier?.code;
                _supplierShortName = _supplier?.shortCompanyName;
            }
            _salesDeliveries.push({
                _id: salesDeliveryLine.salesDelivery._id,
                id: salesDeliveryLine.salesDelivery.id,
                salesSite: {
                    code: salesDeliveryLine.salesDelivery.salesSite.code,
                },
                isValidated: salesDeliveryLine.salesDelivery.isValidated,
            });
        }
    });

    switch ( _salesDeliveries.length ) {
        case 0:
            page.$.removeToasts();
            page.$.showToast(
                `${ui.localize(
                    '@sage/x3-purchasing-sales/notification-error-no-delivery-to-receive',
                    'No delivery to receive',
                )}`,
                { type: 'error', timeout: 30000 },
            );
            break;
        case 1:
            if (_salesDeliveries[0]?.isValidated) {
                page.$.router.goTo('@sage/x3-purchasing-sales/MobileIntersiteReceipt', {
                    salesDeliveryId: _salesDeliveries[0].id,
                    salesSite: _salesDeliveries[0].salesSite.code,
                });
            } else {
                page.$.removeToasts();
                page.$.showToast(
                    `${ui.localize(
                        '@sage/x3-purchasing-sales/notification-error-no-delivery-validated-intersite-receipt-is-not-possible',
                        'No delivery validated, Intersite receipt is not possible',
                    )}`,
                    { type: 'error', timeout: 30000 },
                );
            }
            break;
        default:
            page.$.router.goTo('@sage/x3-purchasing-sales/MobileViewPurchaseOrderToReceiveSelectADelivery', {
                purchaseOrderId: purchaseOrderId,
                productCode: productCode,
                upcCode: upcCode,
                lineNumber: lineNumber,
                receiptDate: receiptDate,
                isIntersite: isIntersite,
                salesDeliveries: JSON.stringify(_salesDeliveries),
            });
            break;
     }

}