/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/purchase-order-control.ts":
/*!********************************************************!*\
  !*** ./lib/client-functions/purchase-order-control.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.goToPurchaseOrderToReceiveSelectADelivery = exports.goToPurchaseOrderSelectADelivery = exports.getSalesDeliveries = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function getSalesDeliveries(pageInstance, purchaseOrderId) {\n    const page = pageInstance;\n    return (0, xtrem_client_1.extractEdges)(await page.$.graph\n        .node('@sage/x3-sales/SalesDeliveryLine')\n        .query(ui.queryUtils.edgesSelector({\n        salesDelivery: {\n            _id: true,\n            id: true,\n            salesSite: {\n                code: true,\n            },\n            isValidated: true,\n        },\n    }, {\n        filter: {\n            salesOrderLine: {\n                purchaseOrder: {\n                    id: purchaseOrderId,\n                },\n            },\n        },\n    }))\n        .execute());\n}\nexports.getSalesDeliveries = getSalesDeliveries;\nasync function goToPurchaseOrderSelectADelivery(pageInstance) {\n    const page = pageInstance;\n    const purchaseOrderId = page['purchaseOrder']?.value ?? '';\n    const supplierCode = page['orderFromSupplier']?.value ?? '';\n    const orderFromSupplier = page.$.queryParameters['orderFromSupplier'] ?? '';\n    const site = page.$.queryParameters['site'] ?? '';\n    const receiptDate = page.$.queryParameters['receiptDate'] ?? '';\n    const isIntersite = page.$.queryParameters['isIntersite'] ?? '';\n    const shortCompanyName = page.$.queryParameters['shortCompanyName'] ?? '';\n    const result = await getSalesDeliveries(page, purchaseOrderId);\n    const _salesDeliveries = [];\n    result.forEach(salesDeliveryLine => {\n        if (!_salesDeliveries.find(item => typesLib.strictEq(item.id, salesDeliveryLine.salesDelivery.id))) {\n            _salesDeliveries.push({\n                _id: salesDeliveryLine.salesDelivery._id,\n                id: salesDeliveryLine.salesDelivery.id,\n                salesSite: {\n                    code: salesDeliveryLine.salesDelivery.salesSite.code,\n                },\n                isValidated: salesDeliveryLine.salesDelivery.isValidated,\n            });\n        }\n    });\n    switch (_salesDeliveries.length) {\n        case 0:\n            page.$.removeToasts();\n            page.$.showToast(`${ui.localize('@sage/x3-purchasing-sales/notification-error-no-delivery-to-receive', 'No delivery to receive')}`, { type: 'error', timeout: 30000 });\n            break;\n        case 1:\n            if (_salesDeliveries[0]?.isValidated) {\n                page.$.router.goTo('@sage/x3-purchasing-sales/MobileIntersiteReceipt', {\n                    salesDeliveryId: _salesDeliveries[0].id,\n                    salesSite: _salesDeliveries[0].salesSite.code,\n                });\n            }\n            else {\n                page.$.removeToasts();\n                page.$.showToast(`${ui.localize('@sage/x3-purchasing-sales/notification-error-no-delivery-validated-intersite-receipt-is-not-possible', 'No delivery validated, Intersite receipt is not possible')}`, { type: 'error', timeout: 30000 });\n            }\n            break;\n        default:\n            page.$.router.goTo('@sage/x3-purchasing-sales/MobileViewPurchaseOrderSelectADelivery', {\n                purchaseOrderId: purchaseOrderId,\n                supplierCode: supplierCode,\n                orderFromSupplier: orderFromSupplier,\n                site: site,\n                receiptDate: receiptDate,\n                isIntersite: isIntersite,\n                shortCompanyName: shortCompanyName,\n                salesDeliveries: JSON.stringify(_salesDeliveries),\n            });\n            break;\n    }\n}\nexports.goToPurchaseOrderSelectADelivery = goToPurchaseOrderSelectADelivery;\nasync function goToPurchaseOrderToReceiveSelectADelivery(pageInstance) {\n    const page = pageInstance;\n    const purchaseOrderId = page['purchaseOrderId'].value ?? '';\n    const productCode = page.$.queryParameters['productCode'] ?? '';\n    const upcCode = page.$.queryParameters['upcCode'] ?? '';\n    const lineNumber = page.$.queryParameters['lineNumber'] ?? '';\n    const receiptDate = page.$.queryParameters['receiptDate'] ?? '';\n    const isIntersite = page.$.queryParameters['isIntersite'] ?? '';\n    const result = await getSalesDeliveries(page, purchaseOrderId);\n    const _salesDeliveries = [];\n    let _supplierCode;\n    let _supplierShortName;\n    result.forEach(salesDeliveryLine => {\n        if (!_salesDeliveries.find(item => typesLib.strictEq(item.id, salesDeliveryLine.salesDelivery.id))) {\n            if (!_supplierCode) {\n                const _supplier = salesDeliveryLine?.salesOrderLine?.purchaseOrder?.orderFromSupplier?.code;\n                _supplierCode = _supplier?.code;\n                _supplierShortName = _supplier?.shortCompanyName;\n            }\n            _salesDeliveries.push({\n                _id: salesDeliveryLine.salesDelivery._id,\n                id: salesDeliveryLine.salesDelivery.id,\n                salesSite: {\n                    code: salesDeliveryLine.salesDelivery.salesSite.code,\n                },\n                isValidated: salesDeliveryLine.salesDelivery.isValidated,\n            });\n        }\n    });\n    switch (_salesDeliveries.length) {\n        case 0:\n            page.$.removeToasts();\n            page.$.showToast(`${ui.localize('@sage/x3-purchasing-sales/notification-error-no-delivery-to-receive', 'No delivery to receive')}`, { type: 'error', timeout: 30000 });\n            break;\n        case 1:\n            if (_salesDeliveries[0]?.isValidated) {\n                page.$.router.goTo('@sage/x3-purchasing-sales/MobileIntersiteReceipt', {\n                    salesDeliveryId: _salesDeliveries[0].id,\n                    salesSite: _salesDeliveries[0].salesSite.code,\n                });\n            }\n            else {\n                page.$.removeToasts();\n                page.$.showToast(`${ui.localize('@sage/x3-purchasing-sales/notification-error-no-delivery-validated-intersite-receipt-is-not-possible', 'No delivery validated, Intersite receipt is not possible')}`, { type: 'error', timeout: 30000 });\n            }\n            break;\n        default:\n            page.$.router.goTo('@sage/x3-purchasing-sales/MobileViewPurchaseOrderToReceiveSelectADelivery', {\n                purchaseOrderId: purchaseOrderId,\n                productCode: productCode,\n                upcCode: upcCode,\n                lineNumber: lineNumber,\n                receiptDate: receiptDate,\n                isIntersite: isIntersite,\n                salesDeliveries: JSON.stringify(_salesDeliveries),\n            });\n            break;\n    }\n}\nexports.goToPurchaseOrderToReceiveSelectADelivery = goToPurchaseOrderToReceiveSelectADelivery;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/purchase-order-control.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-view-purchase-order-select-a-purchase-order-line.ts":
/*!******************************************************************************!*\
  !*** ./lib/pages/mobile-view-purchase-order-select-a-purchase-order-line.ts ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileViewPurchaseOrderSelectAPurchaseOrderLine = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst purchase_receipt_details_control_1 = __webpack_require__(/*! @sage/x3-purchasing/lib/client-functions/purchase-receipt-details-control */ \"../x3-purchasing/lib/client-functions/purchase-receipt-details-control.ts\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst purchase_order_control_1 = __webpack_require__(/*! ../client-functions/purchase-order-control */ \"./lib/client-functions/purchase-order-control.ts\");\nlet MobileViewPurchaseOrderSelectAPurchaseOrderLine = class MobileViewPurchaseOrderSelectAPurchaseOrderLine extends ui.Page {\n};\nexports.MobileViewPurchaseOrderSelectAPurchaseOrderLine = MobileViewPurchaseOrderSelectAPurchaseOrderLine;\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine.prototype, \"purchaseOrder\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine.prototype, \"orderFromSupplier\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine.prototype, \"receiptDate\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.mainBlock;\n        },\n        canSelect: false,\n        isTransient: true,\n        canUserHideColumns: false,\n        canFilter: false,\n        displayMode: ui.fields.TableDisplayMode.comfortable,\n        onRowClick(_id, rowItem) {\n            this.$.router.goTo(`@sage/x3-purchasing-sales/MobileViewPurchaseOrderPurchaseOrderLineDetail`, {\n                site: this.site.value ?? '',\n                purchaseOrder: this.purchaseOrder.value ?? '',\n                product: rowItem.product,\n                lineNumber: rowItem.lineNumber,\n                expectedReceiptDate: rowItem.expectedReceiptDate,\n                remainingQuantityReceive: rowItem.quantityInStockUnitRemaining,\n            });\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                isReadOnly: true,\n                canFilter: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'quantityInStockUnitRemaining',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lineNumber',\n                prefix: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_view_purchase_order_select_a_purchase_order_line__orderLines____columns__prefix__lineNumber\", \"Line number: \"),\n                isReadOnly: true,\n                canFilter: true,\n            }),\n            ui.nestedFields.date({\n                bind: 'expectedReceiptDate',\n                isReadOnly: true,\n                canFilter: false,\n            }),\n        ],\n        cardView: true,\n        mobileCard: {\n            title: ui.nestedFields.text({\n                bind: 'product',\n                isReadOnly: true,\n            }),\n            titleRight: ui.nestedFields.text({\n                bind: 'quantityInStockUnitRemaining',\n                isReadOnly: true,\n            }),\n            line2: ui.nestedFields.text({\n                bind: 'localizedDescription1',\n                isReadOnly: true,\n            }),\n            line3: ui.nestedFields.text({\n                bind: 'lineNumber',\n                prefix: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_view_purchase_order_select_a_purchase_order_line__orderLines____mobileCard__line3__prefix\", \"Line number: \"),\n                isReadOnly: true,\n            }),\n            // (X3-258981) TODO Issue: This is displayed below line3, rather than on the right of line3\n            line3Right: ui.nestedFields.date({\n                bind: 'expectedReceiptDate',\n                isReadOnly: true,\n            }),\n        },\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine.prototype, \"orderLines\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_view_purchase_order_select_a_purchase_order_line__purchaseReceiptButton____title\", \"Purchase receipt\"),\n        buttonType: 'primary',\n        onClick() {\n            const purchaseReceiptRecordManager = new purchase_receipt_details_control_1.PurchaseReceiptDetailsRecordManager(this, true);\n            if (purchaseReceiptRecordManager.purchaseSession) {\n                this.$.removeToasts();\n                setTimeout(() => this.$.showToast(ui.localize('@sage/x3-purchasing-sales/notification-preloading-verification-purchase-receipt', 'Purchase receipt already in progress.  Starting a new purchase receipt is not allowed.'), { type: 'warning', timeout: 30000 }), 10);\n            }\n            else {\n                this.$.router.goTo('@sage/x3-purchasing/MobilePurchaseReceipt', {\n                    purchaseOrderId: this.purchaseOrder.value ?? '',\n                    supplierCode: this.orderFromSupplier.value ?? '',\n                });\n            }\n        },\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine.prototype, \"purchaseReceiptButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_view_purchase_order_select_a_purchase_order_line__intersiteReceiptButton____title\", \"Intersite receipt\"),\n        buttonType: 'primary',\n        async onClick() {\n            await (0, purchase_order_control_1.goToPurchaseOrderSelectADelivery)(this);\n        },\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine.prototype, \"intersiteReceiptButton\", void 0);\nexports.MobileViewPurchaseOrderSelectAPurchaseOrderLine = MobileViewPurchaseOrderSelectAPurchaseOrderLine = __decorate([\n    ui.decorators.page({\n        module: 'x3-purchasing',\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_view_purchase_order_select_a_purchase_order_line____title\", \"Purchase orders\"),\n        subtitle: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_view_purchase_order_select_a_purchase_order_line____subtitle\", \"Select a line\"),\n        isTitleHidden: true,\n        isTransient: true,\n        skipDirtyCheck: true,\n        headerCard() {\n            return {\n                title: this.purchaseOrder,\n                line2: this.orderFromSupplier,\n            };\n        },\n        async onLoad() {\n            // Requires a selected purchase order number in the query parameters\n            const purchaseOrderParameter = this.$.queryParameters.purchaseOrder;\n            const orderFromSupplierParameter = this.$.queryParameters.orderFromSupplier;\n            const receiptDateParameter = this.$.queryParameters.receiptDate;\n            const isIntersiteParameter = !!this.$.queryParameters.isIntersite;\n            if (!purchaseOrderParameter) {\n                this.$.showToast(ui.localize('@sage/x3-purchasing-sales/purchaseOrder-required', 'Selected purchase order is required'), { type: 'warning' });\n                this.$.router.goTo(`@sage/x3-purchasing-sales/MobileViewPurchaseOrder`);\n                return;\n            }\n            this.site.value = String(this.$.queryParameters.site);\n            this.purchaseOrder.value = String(purchaseOrderParameter);\n            this.orderFromSupplier.value = String(orderFromSupplierParameter);\n            this.receiptDate.value = String(receiptDateParameter);\n            const orderLineFilter = {\n                purchaseOrder: this.purchaseOrder.value,\n                receiptSite: this.site.value,\n                workOrderInProgressStatus: { _lte: 'firm' },\n                sourceRequest: { _ne: 'directOrder' },\n                lineType: {\n                    _in: ['normal', 'parentProductBom'],\n                },\n                lineStatus: { _ne: 'closed' },\n                isClosed: { _eq: false },\n                product: {\n                    productStatus: {\n                        _eq: 'active',\n                    },\n                },\n            };\n            if (typesLib.strictNe(this.receiptDate.value, '')) {\n                orderLineFilter.expectedReceiptDate = {\n                    _lte: this.receiptDate.value,\n                };\n            }\n            try {\n                const response = await this.$.graph\n                    .node('@sage/x3-purchasing/PurchaseOrderLine')\n                    .query(ui.queryUtils.edgesSelector({\n                    purchaseOrder: { id: true },\n                    lineNumber: true,\n                    receiptSite: { code: true },\n                    quantityInPurchaseUnitOrdered: true,\n                    quantityInStockUnitOrdered: true,\n                    quantityInStockUnitReceived: true,\n                    quantityInPurchaseUnitReceived: true,\n                    purchaseUnit: {\n                        code: true,\n                    },\n                    stockUnit: {\n                        code: true,\n                    },\n                    product: {\n                        code: true,\n                        localizedDescription1: true,\n                    },\n                    lineStatus: true,\n                    isClosed: true,\n                    lineType: true,\n                    workOrderInProgressStatus: true,\n                    sourceRequest: true,\n                    expectedReceiptDate: true,\n                }, {\n                    filter: orderLineFilter,\n                    orderBy: {\n                        lineNumber: 1,\n                    },\n                    first: 200,\n                }))\n                    .execute();\n                let idCounter = 0;\n                this.orderLines.value = response.edges.map((currentRecord) => {\n                    var _v;\n                    _v = idCounter, idCounter = typesLib.add(idCounter, 1), _v;\n                    return {\n                        _id: this.orderLines.generateRecordId(),\n                        lineNumber: currentRecord.node.lineNumber,\n                        product: currentRecord.node.product.code,\n                        localizedDescription1: currentRecord.node.product.localizedDescription1,\n                        quantityInStockUnitRemaining: `${typesLib.sub(currentRecord.node.quantityInStockUnitOrdered, currentRecord.node.quantityInStockUnitReceived)} ${currentRecord.node.stockUnit.code}`,\n                        expectedReceiptDate: currentRecord.node.expectedReceiptDate,\n                    };\n                });\n                this.mainBlock.title = typesLib.add(ui.localize('@sage/x3-purchasing-sales/purchase-order-block-title', 'Purchase order lines:'), idCounter);\n                this.purchaseReceiptButton.isHidden = isIntersiteParameter;\n                this.intersiteReceiptButton.isHidden = !isIntersiteParameter;\n            }\n            catch (e) {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-purchasing-sales/dialog-error-title', 'Error'), typesLib.add(ui.localize('@sage/x3-purchasing-sales/dialog-error-set-site', 'Stock site not defined'), String(e)));\n                this.$.loader.isHidden = true;\n                return;\n            }\n        },\n        businessActions() {\n            return [this.purchaseReceiptButton, this.intersiteReceiptButton];\n        },\n    })\n], MobileViewPurchaseOrderSelectAPurchaseOrderLine);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-view-purchase-order-select-a-purchase-order-line.ts\n");

/***/ }),

/***/ "../x3-purchasing/lib/client-functions/purchase-receipt-details-control.ts":
/*!*********************************************************************************!*\
  !*** ../x3-purchasing/lib/client-functions/purchase-receipt-details-control.ts ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.PurchaseReceiptDetailsRecordManager = exports.controlLotReceipt = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst xtrem_ui_1 = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function validate(page) {\n    // (X3-201046, X3-203885) TODO Issue: Have better validation error messages that specifically tell which fields have issues\n    const errors = await page.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    page.$.showToast(`${(0, xtrem_ui_1.localize)('@sage/x3-purchasing/dialog-error-title', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validate = validate;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock-data/StockJournal')\n        .query(xtrem_ui_1.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast((0, xtrem_ui_1.localize)('@sage/x3-purchasing/notification-error-receipt-lot', 'the lot number {{ lot }} already exists for this product', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\nvar YesNoEnum;\n(function (YesNoEnum) {\n    YesNoEnum[YesNoEnum[\"no\"] = 1] = \"no\";\n    YesNoEnum[YesNoEnum[\"yes\"] = 2] = \"yes\";\n})(YesNoEnum || (YesNoEnum = {}));\nclass PurchaseReceiptDetailsRecordManager {\n    constructor(page, cleanupIncompleteSessionLines = false) {\n        this.page = page;\n        this._stockDetails = [];\n        this._receiptUnit = [];\n        this._unitIsSame = true;\n        // An incomplete purchase receipt line can be added to the session when user is transitioning from main page to enter detail page\n        if (cleanupIncompleteSessionLines)\n            this._cleanupSession();\n    }\n    static { this.PURCHASE_RECEIPT_KEY = 'purchaseReceipt'; }\n    get purchaseSession() {\n        if (this._purchaseSession) {\n            return this._purchaseSession;\n        }\n        const storedSession = this.page.$.storage.get(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY);\n        if (storedSession) {\n            const parsedSession = JSON.parse(storedSession);\n            if (this._checkStorage(parsedSession)) {\n                this._purchaseSession = parsedSession;\n            }\n            else {\n                // purchase receipt in the session storage is corrupted/malformed\n                this.clearSession();\n            }\n        }\n        return this._purchaseSession;\n    }\n    set purchaseSession(purchaseSession) {\n        if (!purchaseSession) {\n            return;\n        }\n        if (!this._checkStorage(purchaseSession)) {\n            throw new Error('Invalid Purchase Receipt session');\n        }\n        this.page.$.storage.set(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY, JSON.stringify(purchaseSession));\n        this._purchaseSession = purchaseSession;\n    }\n    _checkStorage(sessionData) {\n        // check if sessionData contains at least one purchase receipt line that has at least one stock detail line\n        if (!sessionData ||\n            !sessionData.purchaseEntryTransaction.code ||\n            !sessionData.purchaseReceipt.receiptDate ||\n            !sessionData.purchaseReceipt.lines || typesLib.strictEq(sessionData.purchaseReceipt.lines.length, 0) ||\n            !sessionData.purchaseReceipt.receiptSite ||\n            !sessionData.purchaseReceipt.supplier) {\n            return false;\n        }\n        return !sessionData.purchaseReceipt.lines.some((line) => {\n            // skip most recent line that is pending to be completed in detail page\n            if (!line.stockDetails) {\n                return false;\n            }\n            // check for each line, the receipt unit & quantity are defined\n            if (!line.receiptUnit || typesLib.strictEq(line.quantityInReceiptUnitReceived, null) || typesLib.strictEq(line.quantityInReceiptUnitReceived, undefined)) {\n                return true;\n            }\n            return line.stockDetails.some((detail) => {\n                // check for each stock detail on this line, the packing unit & quantity are defined\n                return (!detail.packingUnit || typesLib.strictEq(detail.quantityInPackingUnit, null) || typesLib.strictEq(detail.quantityInPackingUnit, undefined));\n            });\n        });\n    }\n    _cleanupSession() {\n        this._purchaseSession = this.purchaseSession; // get the latest from session\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        // remove any incomplete purchase receipt lines (ex. a line without stockDetails)\n        const prevLineCount = this._purchaseSession.purchaseReceipt.lines?.length;\n        this._purchaseSession.purchaseReceipt.lines = this._purchaseSession.purchaseReceipt.lines.filter((line) => {\n            if (!line.receiptUnit || typesLib.strictEq(line.quantityInReceiptUnitReceived, null) || typesLib.strictEq(line.quantityInReceiptUnitReceived, undefined) ||\n                !line.stockDetails) {\n                return false;\n            }\n            return !line.stockDetails.some((detail) => {\n                // check for each stock detail on this line, the packing unit & quantity are defined\n                return (!detail.packingUnit || typesLib.strictEq(detail.quantityInPackingUnit, null) || typesLib.strictEq(detail.quantityInPackingUnit, undefined));\n            });\n        });\n        // if all lines have been removed, clear the session\n        if (typesLib.strictEq(this._purchaseSession.purchaseReceipt.lines?.length, 0)) {\n            this.clearSession();\n        }\n        else if (typesLib.strictNe(prevLineCount, this._purchaseSession.purchaseReceipt.lines.length)) {\n            // otherwise if any line got removed, overwrite the session\n            this.purchaseSession = this._purchaseSession;\n        }\n    }\n    clearSession() {\n        this.page.$.storage.remove(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY);\n        this._purchaseSession = null;\n    }\n    createLine(page, product) {\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        const currentLineNumber = typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1);\n        const currentLine = this._purchaseSession.purchaseReceipt.lines[currentLineNumber];\n        currentLine.stockDetails = this._stockDetails;\n        // If all receipt units are the same, use that unit for the line. If there are multiple receipt units,\n        // use stock unit for the line.\n        if (this._unitIsSame) {\n            currentLine.quantityInReceiptUnitReceived = this._receiptUnit.reduce((totalQty, line) => {\n                return typesLib.add(totalQty, line.quantityInReceiptUnit);\n            }, 0);\n            currentLine.receiptUnit = this._receiptUnit[0].code;\n            currentLine.receiptUnitToStockUnitConversionFactor = Number(page.packingUnitToStockUnitConversionFactor.value);\n        }\n        else {\n            currentLine.quantityInReceiptUnitReceived = this._receiptUnit.reduce((totalQty, line) => {\n                return typesLib.add(totalQty, typesLib.mul(Number(line.quantityInReceiptUnit), Number(line.stockUnitConversionFactor)));\n            }, 0);\n            currentLine.receiptUnit = product.stockUnit.code;\n            currentLine.receiptUnitToStockUnitConversionFactor = Number(page.packingUnitToStockUnitConversionFactor.value);\n        }\n        //Set receipt line number\n        currentLine.lineNumber = typesLib.mul((typesLib.add(currentLineNumber, 1)), 1000);\n        /*  if (\n            currentLine.purchaseOrderNumber &&\n            currentLine.purchaseOrderLineNumber &&\n            currentLine.purchaseOrderLine\n        ) {\n            currentLine._forMutationOnlyDoClosePurchaseOrderLine =\n                page.closePoLine.options.indexOf(page.closePoLine.value) === 0 ? YesNoEnum.yes : YesNoEnum.no;\n        } _forMutationOnlyDoClosePurchaseOrderLine missing */\n        currentLine.balance = (typesLib.strictEq(page.closePoLine.value, ui.localize('@sage/x3-purchasing/Yes', 'Yes')) ? YesNoEnum.yes : YesNoEnum.no).toString();\n        currentLine.warehouse = page.warehouse.value ?? undefined;\n        currentLine.container = page.container?.value?.code;\n        this.purchaseSession = {\n            purchaseEntryTransaction: this._purchaseSession.purchaseEntryTransaction,\n            purchaseReceipt: this._purchaseSession.purchaseReceipt,\n            orderUnitToPurchaseUnitConversionFactor: page.packingUnitToStockUnitConversionFactor.value ?? 0,\n        };\n    }\n    loadStockDetails(page, product) {\n        const quantityReceivedInStockUnit = typesLib.mul((page.quantityToReceive.value ?? 0), (page.packingUnitToStockUnitConversionFactor.value ?? 1));\n        // Saving receipt units is separate array because only stock and packing units are saved at stock details level.\n        this._receiptUnit.push({\n            code: page.receiptUnitCode.value ?? '',\n            quantityInReceiptUnit: page.quantityToReceive.value ?? 0,\n            stockUnitConversionFactor: page.packingUnitToStockUnitConversionFactor.value ?? 1,\n        });\n        // Check if unit is different from previous line\n        if (typesLib.gt(this._receiptUnit.length, 1) && this._unitIsSame) {\n            if (typesLib.strictNe(page.receiptUnitCode.value, this._receiptUnit[typesLib.sub(this._receiptUnit.length, 2)].code)) {\n                this._unitIsSame = false;\n            }\n        }\n        const detailLine = {\n            packingUnit: page.isPackingUnit ? (page.receiptUnitCode.value ?? '') : product.stockUnit.code,\n            quantityInPackingUnit: page.isPackingUnit\n                ? (page.quantityToReceive.value ?? 0)\n                : quantityReceivedInStockUnit,\n            packingUnitToStockUnitConversionFactor: page.isPackingUnit\n                ? (page.packingUnitToStockUnitConversionFactor.value ?? 1)\n                : 1,\n            lot: page.lot.value ?? undefined, // using undefined, omits the property entirely from JSON when stringified\n            sublot: page.sublot.value ?? undefined,\n            supplierLot: page.supplierLot.value ?? undefined,\n            potency: page.potency.value ?? undefined,\n            location: page.location.value?.code,\n            serialNumber: page.serialNumber.value ?? undefined,\n            status: page.status.value ?? undefined, // this is always required\n            majorVersion: page.majorVersion.value?.code,\n            minorVersion: page.minorVersion.value?.minorVersion,\n            licensePlateNumber: page.licensePlateNumber.value?.code,\n            expirationDate: (page.expirationDate.isDisabled ? page.calculatedExpirationDate.value : page.expirationDate.value) ??\n                undefined,\n            useByDate: page.useByDate.value ?? undefined,\n            lotCustomField1: page.lotCustomField1.value ?? undefined,\n            lotCustomField2: page.lotCustomField2.value ?? undefined,\n            lotCustomField3: page.lotCustomField3.value ?? undefined,\n            lotCustomField4: page.lotCustomField4.value ?? undefined,\n            identifier1: page.identifier1.value ?? undefined,\n            identifier2: page.identifier2.value ?? undefined,\n        };\n        this._stockDetails.push(detailLine);\n        // Initialize detail page for next detail line.  Most field values will default to previous detail line values.\n        page.location.isDisabled = false;\n        page.licensePlateNumber.value = { code: '' };\n        page.sublot.value = '';\n        page.serialNumber.value = '';\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        const currLine = this._purchaseSession.purchaseReceipt.lines[typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1)];\n        if (!currLine.purchaseOrder) {\n            // Set remaining quantity to 0 for direct receipts\n            page.quantityToReceive.value = 0;\n        }\n        else {\n            // Calculate remaining quantity for PO receipt lines (not direct receipt)\n            // remainingQuantity and quantityToReceive will always be the same unit and that unit will be the default\n            // for the next detail line.  Value can never be negative\n            page.remainingQuantityInStockUnit.value = typesLib.sub((page.remainingQuantityInStockUnit.value ?? 0), typesLib.mul((page.quantityToReceive.value ?? 0), (page.packingUnitToStockUnitConversionFactor.value ?? 1)));\n            if (typesLib.strictNe(page.packingUnitToStockUnitConversionFactor.value, 0))\n                page.remainingQuantityInPackingUnit.value = typesLib.div(page.remainingQuantityInStockUnit.value, (page.packingUnitToStockUnitConversionFactor.value ?? 1));\n            page.quantityToReceive.value = typesLib.max(0, page.remainingQuantityInPackingUnit.value ?? 0);\n            page.quantityToReceiveNoRounded = page.quantityToReceive.value;\n        }\n    }\n}\nexports.PurchaseReceiptDetailsRecordManager = PurchaseReceiptDetailsRecordManager;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4veDMtcHVyY2hhc2luZy9saWIvY2xpZW50LWZ1bmN0aW9ucy9wdXJjaGFzZS1yZWNlaXB0LWRldGFpbHMtY29udHJvbC50cyIsIm1hcHBpbmdzIjoiOzs7O0FBT0EsMkZBQWtEO0FBRWxELHVFQUFxQztBQUNyQywrRUFBNEQ7QUFPckQsS0FBSyxVQUFVLFFBQVEsQ0FBQyxJQUFVO0lBQ3JDLDJIQUEySDtJQUMzSCxNQUFNLE1BQU0sR0FBRyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQzVDLHNCQUFJLE1BQU0sQ0FBQyxNQUFNLEVBQUssQ0FBQyxHQUFFLENBQUM7UUFDdEIsT0FBTyxJQUFJLENBQUM7SUFDaEIsQ0FBQztJQUVELElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLEdBQUcsdUJBQVEsRUFBQyx3Q0FBd0MsRUFBRSxPQUFPLENBQUMsS0FBSyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRTtRQUM3RixJQUFJLEVBQUUsT0FBTztRQUNiLE9BQU8sRUFBRSxLQUFLO0tBQ2pCLENBQUMsQ0FBQztJQUVILE9BQU8sS0FBSyxDQUFDO0FBQ2pCLENBQUM7QUFiRCw0QkFhQztBQUNNLEtBQUssVUFBVSxpQkFBaUIsQ0FDbkMsWUFBa0IsRUFDbEIsR0FBVyxFQUNYLE9BQWUsRUFDZixTQUFpQixFQUNqQixJQUFZO0lBRVosSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDLE9BQU8sSUFBSSxDQUFDLFNBQVM7UUFBRSxNQUFNLElBQUksS0FBSyxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDekUsSUFBSSxrQkFBa0IsR0FBRztRQUNyQixTQUFTLEVBQUUsSUFBSTtRQUNmLFlBQVksRUFBRSxTQUFTO1FBQ3ZCLE9BQU8sRUFBRSxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUU7UUFDMUIsU0FBUyxFQUFFLElBQUk7UUFDZixHQUFHLEVBQUUsR0FBRztLQUNYLENBQUM7SUFFRixNQUFNLFFBQVEsR0FBRywrQkFBWSxFQUN6QixNQUFNLFlBQVksQ0FBQyxDQUFDLENBQUMsS0FBSztTQUNyQixJQUFJLENBQUMsa0NBQWtDLENBQUM7U0FDeEMsS0FBSyxDQUNGLHFCQUFVLENBQUMsYUFBYSxDQUNwQjtRQUNJLEdBQUcsRUFBRSxJQUFJO1FBQ1QsTUFBTSxFQUFFLElBQUk7S0FDZixFQUNEO1FBQ0ksTUFBTSxFQUFFLGtCQUFrQjtLQUM3QixDQUNKLENBQ0o7U0FDQSxPQUFPLEVBQUUsQ0FDakIsQ0FBQztJQUVGLGdCQUFJLFFBQVEsQ0FBQyxNQUFNLEVBQUcsQ0FBQyxHQUFFLENBQUM7UUFDdEIsWUFBWSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQ3BCLHVCQUFRLEVBQ0osb0RBQW9ELEVBQ3BELDBEQUEwRCxFQUMxRCxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FDZixFQUNELEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxDQUNwQixDQUFDO1FBQ0YsT0FBTyxLQUFLLENBQUM7SUFDakIsQ0FBQztJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2hCLENBQUM7QUE3Q0QsOENBNkNDO0FBRUQsSUFBSyxTQUdKO0FBSEQsV0FBSyxTQUFTO0lBQ1YscUNBQU07SUFDTix1Q0FBTztBQUNYLENBQUMsRUFISSxTQUFTLEtBQVQsU0FBUyxRQUdiO0FBU0QsTUFBYSxtQ0FBbUM7SUFDNUMsWUFDWSxJQUFvQixFQUM1Qiw2QkFBNkIsR0FBRyxLQUFLO1FBRDdCLFNBQUksR0FBSixJQUFJLENBQWdCO1FBV3hCLGtCQUFhLEdBQWlDLEVBQUUsQ0FBQztRQUNqRCxpQkFBWSxHQUFrQixFQUFFLENBQUM7UUFDakMsZ0JBQVcsR0FBWSxJQUFJLENBQUM7UUFWaEMsaUlBQWlJO1FBQ2pJLElBQUksNkJBQTZCO1lBQUUsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO0lBQzlELENBQUM7YUFFdUIseUJBQW9CLEdBQVcsaUJBQWlCLENBQUM7SUFRekUsSUFBVyxlQUFlO1FBQ3RCLElBQUksSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUM7WUFDeEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDakMsQ0FBQztRQUVELE1BQU0sYUFBYSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQ3pDLG1DQUFtQyxDQUFDLG9CQUFvQixDQUNqRCxDQUFDO1FBQ1osSUFBSSxhQUFhLEVBQUUsQ0FBQztZQUNoQixNQUFNLGFBQWEsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBMkIsQ0FBQztZQUMxRSxJQUFJLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLEVBQUUsQ0FBQztnQkFDcEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLGFBQWEsQ0FBQztZQUMxQyxDQUFDO2lCQUFNLENBQUM7Z0JBQ0osaUVBQWlFO2dCQUNqRSxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDeEIsQ0FBQztRQUNMLENBQUM7UUFDRCxPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUNqQyxDQUFDO0lBRUQsSUFBVyxlQUFlLENBQUMsZUFBdUM7UUFDOUQsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO1lBQ25CLE9BQU87UUFDWCxDQUFDO1FBRUQsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsZUFBZSxDQUFDLEVBQUUsQ0FBQztZQUN2QyxNQUFNLElBQUksS0FBSyxDQUFDLGtDQUFrQyxDQUFDLENBQUM7UUFDeEQsQ0FBQztRQUVELElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQ25CLG1DQUFtQyxDQUFDLG9CQUFvQixFQUN4RCxJQUFJLENBQUMsU0FBUyxDQUFDLGVBQWUsQ0FBQyxDQUNsQyxDQUFDO1FBQ0YsSUFBSSxDQUFDLGdCQUFnQixHQUFHLGVBQWUsQ0FBQztJQUM1QyxDQUFDO0lBRU8sYUFBYSxDQUFDLFdBQW1DO1FBQ3JELDJHQUEyRztRQUMzRyxJQUNJLENBQUMsV0FBVztZQUNaLENBQUMsV0FBVyxDQUFDLHdCQUF3QixDQUFDLElBQUk7WUFDMUMsQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLFdBQVc7WUFDeEMsQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEtBQUssc0JBQ2xDLFdBQVcsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBSyxDQUFDO1lBQzlDLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxXQUFXO1lBQ3hDLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxRQUFRLEVBQ3ZDLENBQUM7WUFDQyxPQUFPLEtBQUssQ0FBQztRQUNqQixDQUFDO1FBRUQsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLElBQThCLEVBQUUsRUFBRTtZQUM5RSx1RUFBdUU7WUFDdkUsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztnQkFDckIsT0FBTyxLQUFLLENBQUM7WUFDakIsQ0FBQztZQUVELCtEQUErRDtZQUMvRCxJQUNJLENBQUMsSUFBSSxDQUFDLFdBQVcsc0JBQ2pCLElBQUksQ0FBQyw2QkFBNkIsRUFBSyxJQUFJLHVCQUMzQyxJQUFJLENBQUMsNkJBQTZCLEVBQUssU0FBUyxHQUNsRCxDQUFDO2dCQUNDLE9BQU8sSUFBSSxDQUFDO1lBQ2hCLENBQUM7WUFFRCxPQUFPLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBeUIsRUFBRSxFQUFFO2dCQUN4RCxvRkFBb0Y7Z0JBQ3BGLE9BQU8sQ0FDSCxDQUFDLE1BQU0sQ0FBQyxXQUFXLHNCQUNuQixNQUFNLENBQUMscUJBQXFCLEVBQUssSUFBSSx1QkFDckMsTUFBTSxDQUFDLHFCQUFxQixFQUFLLFNBQVMsRUFDN0MsQ0FBQztZQUNOLENBQUMsQ0FBQyxDQUFDO1FBQ1AsQ0FBQyxDQUFDLENBQUM7SUFDUCxDQUFDO0lBRU8sZUFBZTtRQUNuQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDLDhCQUE4QjtRQUM1RSxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxLQUFLO1lBQUUsT0FBTztRQUVuRixpRkFBaUY7UUFDakYsTUFBTSxhQUFhLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDO1FBQzFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FDNUYsQ0FBQyxJQUE4QixFQUFFLEVBQUU7WUFDL0IsSUFDSSxDQUFDLElBQUksQ0FBQyxXQUFXLHNCQUNqQixJQUFJLENBQUMsNkJBQTZCLEVBQUssSUFBSSx1QkFDM0MsSUFBSSxDQUFDLDZCQUE2QixFQUFLLFNBQVM7Z0JBQ2hELENBQUMsSUFBSSxDQUFDLFlBQVksRUFDcEIsQ0FBQztnQkFDQyxPQUFPLEtBQUssQ0FBQztZQUNqQixDQUFDO1lBRUQsT0FBTyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBeUIsRUFBRSxFQUFFO2dCQUN6RCxvRkFBb0Y7Z0JBQ3BGLE9BQU8sQ0FDSCxDQUFDLE1BQU0sQ0FBQyxXQUFXLHNCQUNuQixNQUFNLENBQUMscUJBQXFCLEVBQUssSUFBSSx1QkFDckMsTUFBTSxDQUFDLHFCQUFxQixFQUFLLFNBQVMsRUFDN0MsQ0FBQztZQUNOLENBQUMsQ0FBQyxDQUFDO1FBQ1AsQ0FBQyxDQUNKLENBQUM7UUFFRixvREFBb0Q7UUFDcEQsc0JBQUksSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFLLENBQUMsR0FBRSxDQUFDO1lBQzVELElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztRQUN4QixDQUFDO2FBQU0sc0JBQUksYUFBYSxFQUFLLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRSxDQUFDO1lBQzlFLDJEQUEyRDtZQUMzRCxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxDQUFDO0lBQ0wsQ0FBQztJQUVNLFlBQVk7UUFDZixJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLG1DQUFtQyxDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDckYsSUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQztJQUNqQyxDQUFDO0lBRU0sVUFBVSxDQUNiLElBVUMsRUFDRCxPQUtDO1FBRUQsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSztZQUFFLE9BQU87UUFDbkYsTUFBTSxpQkFBaUIsZ0JBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFHLENBQUMsRUFBQztRQUNqRixNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ25GLFdBQVcsQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUU5QyxzR0FBc0c7UUFDdEcsK0JBQStCO1FBQy9CLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ25CLFdBQVcsQ0FBQyw2QkFBNkIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBVSxDQUFDLFFBQVEsRUFBRSxJQUFJLEVBQUUsRUFBRTtnQkFDN0Ysb0JBQU8sUUFBUSxFQUFHLElBQUksQ0FBQyxxQkFBcUIsRUFBQztZQUNqRCxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7WUFDTixXQUFXLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1lBQ3BELFdBQVcsQ0FBQyxzQ0FBc0MsR0FBRyxNQUFNLENBQ3ZELElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxLQUFLLENBQ3BELENBQUM7UUFDTixDQUFDO2FBQU0sQ0FBQztZQUNKLFdBQVcsQ0FBQyw2QkFBNkIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBVSxDQUFDLFFBQVEsRUFBRSxJQUFJLEVBQUUsRUFBRTtnQkFDN0Ysb0JBQU8sUUFBUSxlQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUMsRUFBRyxNQUFNLENBQUMsSUFBSSxDQUFDLHlCQUF5QixDQUFDLEdBQUM7WUFDbEcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1lBQ04sV0FBVyxDQUFDLFdBQVcsR0FBRyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQztZQUNqRCxXQUFXLENBQUMsc0NBQXNDLEdBQUcsTUFBTSxDQUN2RCxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxDQUNwRCxDQUFDO1FBQ04sQ0FBQztRQUVELHlCQUF5QjtRQUN6QixXQUFXLENBQUMsVUFBVSxnQkFBRyxjQUFDLGlCQUFpQixFQUFHLENBQUMsRUFBQyxFQUFHLElBQUksRUFBQztRQUV4RDs7Ozs7Ozs2REFPcUQ7UUFDckQsV0FBVyxDQUFDLE9BQU8sR0FBRyxDQUNsQixzQkFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUssRUFBRSxDQUFDLFFBQVEsQ0FBQyx5QkFBeUIsRUFBRSxLQUFLLENBQUMsRUFBQyxDQUFDLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FDMUcsQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUNiLFdBQVcsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLElBQUksU0FBUyxDQUFDO1FBQzFELFdBQVcsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDO1FBQ3BELElBQUksQ0FBQyxlQUFlLEdBQUc7WUFDbkIsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHdCQUF3QjtZQUN4RSxlQUFlLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWU7WUFDdEQsdUNBQXVDLEVBQUUsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssSUFBSSxDQUFDO1NBQ2xHLENBQUM7SUFDTixDQUFDO0lBRU0sZ0JBQWdCLENBQ25CLElBNkJDLEVBQ0QsT0FLQztRQUVELE1BQU0sMkJBQTJCLGdCQUM3QixDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDLEVBQUcsQ0FBQyxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxJQUFJLENBQUMsQ0FBQyxFQUFDO1FBRW5HLGdIQUFnSDtRQUNoSCxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztZQUNuQixJQUFJLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLElBQUksRUFBRTtZQUN0QyxxQkFBcUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxJQUFJLENBQUM7WUFDeEQseUJBQXlCLEVBQUUsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssSUFBSSxDQUFDO1NBQ3BGLENBQUMsQ0FBQztRQUVILGdEQUFnRDtRQUNoRCxJQUFJLGdCQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFBRyxDQUFDLEtBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ25ELHNCQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFLLElBQUksQ0FBQyxZQUFZLGNBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUcsQ0FBQyxFQUFDLENBQUMsSUFBSSxHQUFFLENBQUM7Z0JBQ3RGLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO1lBQzdCLENBQUM7UUFDTCxDQUFDO1FBRUQsTUFBTSxVQUFVLEdBQStCO1lBQzNDLFdBQVcsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUk7WUFDN0YscUJBQXFCLEVBQUUsSUFBSSxDQUFDLGFBQWE7Z0JBQ3JDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDO2dCQUNyQyxDQUFDLENBQUMsMkJBQTJCO1lBQ2pDLHNDQUFzQyxFQUFFLElBQUksQ0FBQyxhQUFhO2dCQUN0RCxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxJQUFJLENBQUMsQ0FBQztnQkFDMUQsQ0FBQyxDQUFDLENBQUM7WUFDUCxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLElBQUksU0FBUyxFQUFFLDBFQUEwRTtZQUM1RyxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLElBQUksU0FBUztZQUN0QyxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLElBQUksU0FBUztZQUNoRCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLElBQUksU0FBUztZQUN4QyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsSUFBSTtZQUNuQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLElBQUksU0FBUztZQUNsRCxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLElBQUksU0FBUyxFQUFFLDBCQUEwQjtZQUNsRSxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsSUFBSTtZQUMzQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsWUFBWTtZQUNuRCxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxFQUFFLElBQUk7WUFDdkQsY0FBYyxFQUNWLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDO2dCQUNsRyxTQUFTO1lBQ2IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDNUMsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDeEQsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDeEQsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDeEQsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDeEQsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDaEQsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxJQUFJLFNBQVM7U0FDbkQsQ0FBQztRQUVGLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBRXBDLCtHQUErRztRQUMvRyxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7UUFDakMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssR0FBRyxFQUFFLElBQUksRUFBRSxFQUFFLEVBQUUsQ0FBQztRQUM3QyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUM7UUFDdkIsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEdBQUcsRUFBRSxDQUFDO1FBRTdCLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZUFBZSxDQUFDLEtBQUs7WUFBRSxPQUFPO1FBRW5GLE1BQU0sUUFBUSxHQUNWLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxjQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBRyxDQUFDLEVBQUMsQ0FBQztRQUV4RyxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQzFCLGtEQUFrRDtZQUNsRCxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNyQyxDQUFDO2FBQU0sQ0FBQztZQUNKLHlFQUF5RTtZQUN6RSx5R0FBeUc7WUFDekcseURBQXlEO1lBRXpELElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxLQUFLLGdCQUNuQyxDQUFDLElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDLGVBQzlDLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssSUFBSSxDQUFDLENBQUMsRUFBRyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDLEdBQUM7WUFDbkcsc0JBQUksSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssRUFBSyxDQUFDO2dCQUN2RCxJQUFJLENBQUMsOEJBQThCLENBQUMsS0FBSyxnQkFDckMsSUFBSSxDQUFDLDRCQUE0QixDQUFDLEtBQUssRUFBRyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDLEVBQUM7WUFDM0csSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssR0FBRyxTQUFLLEdBQUcsQ0FBQyxDQUFDLEVBQUUsSUFBSSxDQUFDLDhCQUE4QixDQUFDLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQztZQUMzRixJQUFJLENBQUMsMEJBQTBCLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQztRQUNuRSxDQUFDO0lBQ0wsQ0FBQzs7QUE3VEwsa0ZBOFRDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi94My1wdXJjaGFzaW5nL2xpYi9jbGllbnQtZnVuY3Rpb25zL3B1cmNoYXNlLXJlY2VpcHQtZGV0YWlscy1jb250cm9sLnRzPzM3ODUiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgICBHcmFwaEFwaSxcbiAgICBQdXJjaGFzZUVudHJ5VHJhbnNhY3Rpb25JbnB1dCxcbiAgICBQdXJjaGFzZVJlY2VpcHRJbnB1dCxcbiAgICBQdXJjaGFzZVJlY2VpcHRMaW5lSW5wdXQsXG59IGZyb20gJ0BzYWdlL3gzLXB1cmNoYXNpbmctYXBpJztcbmltcG9ydCB7IFN0b2NrSm91cm5hbElucHV0LCBTdG9ja01hbmFnZW1lbnRSdWxlcyB9IGZyb20gJ0BzYWdlL3gzLXN0b2NrLWRhdGEtYXBpJztcbmltcG9ydCB7IGV4dHJhY3RFZGdlcyB9IGZyb20gJ0BzYWdlL3h0cmVtLWNsaWVudCc7XG5pbXBvcnQgeyBkZWNpbWFsIH0gZnJvbSAnQHNhZ2UveHRyZW0tc2hhcmVkJztcbmltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcbmltcG9ydCB7IFBhZ2UsIGxvY2FsaXplLCBxdWVyeVV0aWxzIH0gZnJvbSAnQHNhZ2UveHRyZW0tdWknO1xuaW50ZXJmYWNlIHJlY2VpcHRVbml0IHtcbiAgICBjb2RlOiBzdHJpbmc7XG4gICAgcXVhbnRpdHlJblJlY2VpcHRVbml0OiBudW1iZXI7XG4gICAgc3RvY2tVbml0Q29udmVyc2lvbkZhY3RvcjogbnVtYmVyO1xufVxuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gdmFsaWRhdGUocGFnZTogUGFnZSk6IFByb21pc2U8Ym9vbGVhbj4ge1xuICAgIC8vIChYMy0yMDEwNDYsIFgzLTIwMzg4NSkgVE9ETyBJc3N1ZTogSGF2ZSBiZXR0ZXIgdmFsaWRhdGlvbiBlcnJvciBtZXNzYWdlcyB0aGF0IHNwZWNpZmljYWxseSB0ZWxsIHdoaWNoIGZpZWxkcyBoYXZlIGlzc3Vlc1xuICAgIGNvbnN0IGVycm9ycyA9IGF3YWl0IHBhZ2UuJC5wYWdlLnZhbGlkYXRlKCk7XG4gICAgaWYgKGVycm9ycy5sZW5ndGggPT09IDApIHtcbiAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgfVxuXG4gICAgcGFnZS4kLnNob3dUb2FzdChgJHtsb2NhbGl6ZSgnQHNhZ2UveDMtcHVyY2hhc2luZy9kaWFsb2ctZXJyb3ItdGl0bGUnLCAnRXJyb3InKX06ICR7ZXJyb3JzWzBdfWAsIHtcbiAgICAgICAgdHlwZTogJ2Vycm9yJyxcbiAgICAgICAgdGltZW91dDogMzAwMDAsXG4gICAgfSk7XG5cbiAgICByZXR1cm4gZmFsc2U7XG59XG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gY29udHJvbExvdFJlY2VpcHQoXG4gICAgcGFnZUluc3RhbmNlOiBQYWdlLFxuICAgIGxvdDogc3RyaW5nLFxuICAgIHByb2R1Y3Q6IHN0cmluZyxcbiAgICBlbnRyeVR5cGU6IHN0cmluZyxcbiAgICBzaXRlOiBzdHJpbmcsXG4pOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgICBpZiAoIWxvdCB8fCAhcHJvZHVjdCB8fCAhZW50cnlUeXBlKSB0aHJvdyBuZXcgRXJyb3IoJ0ludmFsaWQgYXJndW1lbnRzJyk7XG4gICAgbGV0IHN0b2NrSm91cm5hbEZpbHRlciA9IHtcbiAgICAgICAgc3RvY2tTaXRlOiBzaXRlLFxuICAgICAgICBkb2N1bWVudFR5cGU6IGVudHJ5VHlwZSxcbiAgICAgICAgcHJvZHVjdDogeyBjb2RlOiBwcm9kdWN0IH0sXG4gICAgICAgIGlzVXBkYXRlZDogdHJ1ZSxcbiAgICAgICAgbG90OiBsb3QsXG4gICAgfTtcblxuICAgIGNvbnN0IHJlc3BvbnNlID0gZXh0cmFjdEVkZ2VzKFxuICAgICAgICBhd2FpdCBwYWdlSW5zdGFuY2UuJC5ncmFwaFxuICAgICAgICAgICAgLm5vZGUoJ0BzYWdlL3gzLXN0b2NrLWRhdGEvU3RvY2tKb3VybmFsJylcbiAgICAgICAgICAgIC5xdWVyeShcbiAgICAgICAgICAgICAgICBxdWVyeVV0aWxzLmVkZ2VzU2VsZWN0b3IoXG4gICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvdDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHN1YmxvdDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgZmlsdGVyOiBzdG9ja0pvdXJuYWxGaWx0ZXIsXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgIClcbiAgICAgICAgICAgIC5leGVjdXRlKCksXG4gICAgKTtcblxuICAgIGlmIChyZXNwb25zZS5sZW5ndGggPiAwKSB7XG4gICAgICAgIHBhZ2VJbnN0YW5jZS4kLnNob3dUb2FzdChcbiAgICAgICAgICAgIGxvY2FsaXplKFxuICAgICAgICAgICAgICAgICdAc2FnZS94My1wdXJjaGFzaW5nL25vdGlmaWNhdGlvbi1lcnJvci1yZWNlaXB0LWxvdCcsXG4gICAgICAgICAgICAgICAgJ3RoZSBsb3QgbnVtYmVyIHt7IGxvdCB9fSBhbHJlYWR5IGV4aXN0cyBmb3IgdGhpcyBwcm9kdWN0JyxcbiAgICAgICAgICAgICAgICB7IGxvdDogbG90IH0sXG4gICAgICAgICAgICApLFxuICAgICAgICAgICAgeyB0eXBlOiAnZXJyb3InIH0sXG4gICAgICAgICk7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gICAgcmV0dXJuIHRydWU7XG59XG5cbmVudW0gWWVzTm9FbnVtIHtcbiAgICBubyA9IDEsXG4gICAgeWVzID0gMixcbn1cblxuZXhwb3J0IHR5cGUgUHVyY2hhc2VSZWNlaXB0U2Vzc2lvbiA9IHtcbiAgICBwdXJjaGFzZVJlY2VpcHQ6IFB1cmNoYXNlUmVjZWlwdElucHV0O1xuICAgIHB1cmNoYXNlRW50cnlUcmFuc2FjdGlvbjogUHVyY2hhc2VFbnRyeVRyYW5zYWN0aW9uSW5wdXQ7XG4gICAgcHVyY2hhc2VTdG9ja01hbmFnZW1lbnRSdWxlcz86IFN0b2NrTWFuYWdlbWVudFJ1bGVzO1xuICAgIG9yZGVyVW5pdFRvUHVyY2hhc2VVbml0Q29udmVyc2lvbkZhY3RvcjogbnVtYmVyO1xufSB8IG51bGw7XG5cbmV4cG9ydCBjbGFzcyBQdXJjaGFzZVJlY2VpcHREZXRhaWxzUmVjb3JkTWFuYWdlciB7XG4gICAgY29uc3RydWN0b3IoXG4gICAgICAgIHByaXZhdGUgcGFnZTogUGFnZTxHcmFwaEFwaT4sXG4gICAgICAgIGNsZWFudXBJbmNvbXBsZXRlU2Vzc2lvbkxpbmVzID0gZmFsc2UsXG4gICAgKSB7XG4gICAgICAgIC8vIEFuIGluY29tcGxldGUgcHVyY2hhc2UgcmVjZWlwdCBsaW5lIGNhbiBiZSBhZGRlZCB0byB0aGUgc2Vzc2lvbiB3aGVuIHVzZXIgaXMgdHJhbnNpdGlvbmluZyBmcm9tIG1haW4gcGFnZSB0byBlbnRlciBkZXRhaWwgcGFnZVxuICAgICAgICBpZiAoY2xlYW51cEluY29tcGxldGVTZXNzaW9uTGluZXMpIHRoaXMuX2NsZWFudXBTZXNzaW9uKCk7XG4gICAgfVxuXG4gICAgcHJpdmF0ZSBzdGF0aWMgcmVhZG9ubHkgUFVSQ0hBU0VfUkVDRUlQVF9LRVk6IHN0cmluZyA9ICdwdXJjaGFzZVJlY2VpcHQnO1xuXG4gICAgcHJpdmF0ZSBfcHVyY2hhc2VTZXNzaW9uOiBQdXJjaGFzZVJlY2VpcHRTZXNzaW9uO1xuXG4gICAgcHJpdmF0ZSBfc3RvY2tEZXRhaWxzOiBQYXJ0aWFsPFN0b2NrSm91cm5hbElucHV0PltdID0gW107XG4gICAgcHJpdmF0ZSBfcmVjZWlwdFVuaXQ6IHJlY2VpcHRVbml0W10gPSBbXTtcbiAgICBwcml2YXRlIF91bml0SXNTYW1lOiBib29sZWFuID0gdHJ1ZTtcblxuICAgIHB1YmxpYyBnZXQgcHVyY2hhc2VTZXNzaW9uKCk6IFB1cmNoYXNlUmVjZWlwdFNlc3Npb24ge1xuICAgICAgICBpZiAodGhpcy5fcHVyY2hhc2VTZXNzaW9uKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5fcHVyY2hhc2VTZXNzaW9uO1xuICAgICAgICB9XG5cbiAgICAgICAgY29uc3Qgc3RvcmVkU2Vzc2lvbiA9IHRoaXMucGFnZS4kLnN0b3JhZ2UuZ2V0KFxuICAgICAgICAgICAgUHVyY2hhc2VSZWNlaXB0RGV0YWlsc1JlY29yZE1hbmFnZXIuUFVSQ0hBU0VfUkVDRUlQVF9LRVksXG4gICAgICAgICkgYXMgc3RyaW5nO1xuICAgICAgICBpZiAoc3RvcmVkU2Vzc2lvbikge1xuICAgICAgICAgICAgY29uc3QgcGFyc2VkU2Vzc2lvbiA9IEpTT04ucGFyc2Uoc3RvcmVkU2Vzc2lvbikgYXMgUHVyY2hhc2VSZWNlaXB0U2Vzc2lvbjtcbiAgICAgICAgICAgIGlmICh0aGlzLl9jaGVja1N0b3JhZ2UocGFyc2VkU2Vzc2lvbikpIHtcbiAgICAgICAgICAgICAgICB0aGlzLl9wdXJjaGFzZVNlc3Npb24gPSBwYXJzZWRTZXNzaW9uO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAvLyBwdXJjaGFzZSByZWNlaXB0IGluIHRoZSBzZXNzaW9uIHN0b3JhZ2UgaXMgY29ycnVwdGVkL21hbGZvcm1lZFxuICAgICAgICAgICAgICAgIHRoaXMuY2xlYXJTZXNzaW9uKCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHRoaXMuX3B1cmNoYXNlU2Vzc2lvbjtcbiAgICB9XG5cbiAgICBwdWJsaWMgc2V0IHB1cmNoYXNlU2Vzc2lvbihwdXJjaGFzZVNlc3Npb246IFB1cmNoYXNlUmVjZWlwdFNlc3Npb24pIHtcbiAgICAgICAgaWYgKCFwdXJjaGFzZVNlc3Npb24pIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICghdGhpcy5fY2hlY2tTdG9yYWdlKHB1cmNoYXNlU2Vzc2lvbikpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcignSW52YWxpZCBQdXJjaGFzZSBSZWNlaXB0IHNlc3Npb24nKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMucGFnZS4kLnN0b3JhZ2Uuc2V0KFxuICAgICAgICAgICAgUHVyY2hhc2VSZWNlaXB0RGV0YWlsc1JlY29yZE1hbmFnZXIuUFVSQ0hBU0VfUkVDRUlQVF9LRVksXG4gICAgICAgICAgICBKU09OLnN0cmluZ2lmeShwdXJjaGFzZVNlc3Npb24pLFxuICAgICAgICApO1xuICAgICAgICB0aGlzLl9wdXJjaGFzZVNlc3Npb24gPSBwdXJjaGFzZVNlc3Npb247XG4gICAgfVxuXG4gICAgcHJpdmF0ZSBfY2hlY2tTdG9yYWdlKHNlc3Npb25EYXRhOiBQdXJjaGFzZVJlY2VpcHRTZXNzaW9uKTogYm9vbGVhbiB7XG4gICAgICAgIC8vIGNoZWNrIGlmIHNlc3Npb25EYXRhIGNvbnRhaW5zIGF0IGxlYXN0IG9uZSBwdXJjaGFzZSByZWNlaXB0IGxpbmUgdGhhdCBoYXMgYXQgbGVhc3Qgb25lIHN0b2NrIGRldGFpbCBsaW5lXG4gICAgICAgIGlmIChcbiAgICAgICAgICAgICFzZXNzaW9uRGF0YSB8fFxuICAgICAgICAgICAgIXNlc3Npb25EYXRhLnB1cmNoYXNlRW50cnlUcmFuc2FjdGlvbi5jb2RlIHx8XG4gICAgICAgICAgICAhc2Vzc2lvbkRhdGEucHVyY2hhc2VSZWNlaXB0LnJlY2VpcHREYXRlIHx8XG4gICAgICAgICAgICAhc2Vzc2lvbkRhdGEucHVyY2hhc2VSZWNlaXB0LmxpbmVzIHx8XG4gICAgICAgICAgICBzZXNzaW9uRGF0YS5wdXJjaGFzZVJlY2VpcHQubGluZXMubGVuZ3RoID09PSAwIHx8XG4gICAgICAgICAgICAhc2Vzc2lvbkRhdGEucHVyY2hhc2VSZWNlaXB0LnJlY2VpcHRTaXRlIHx8XG4gICAgICAgICAgICAhc2Vzc2lvbkRhdGEucHVyY2hhc2VSZWNlaXB0LnN1cHBsaWVyXG4gICAgICAgICkge1xuICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuICFzZXNzaW9uRGF0YS5wdXJjaGFzZVJlY2VpcHQubGluZXMuc29tZSgobGluZTogUHVyY2hhc2VSZWNlaXB0TGluZUlucHV0KSA9PiB7XG4gICAgICAgICAgICAvLyBza2lwIG1vc3QgcmVjZW50IGxpbmUgdGhhdCBpcyBwZW5kaW5nIHRvIGJlIGNvbXBsZXRlZCBpbiBkZXRhaWwgcGFnZVxuICAgICAgICAgICAgaWYgKCFsaW5lLnN0b2NrRGV0YWlscykge1xuICAgICAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgLy8gY2hlY2sgZm9yIGVhY2ggbGluZSwgdGhlIHJlY2VpcHQgdW5pdCAmIHF1YW50aXR5IGFyZSBkZWZpbmVkXG4gICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgIWxpbmUucmVjZWlwdFVuaXQgfHxcbiAgICAgICAgICAgICAgICBsaW5lLnF1YW50aXR5SW5SZWNlaXB0VW5pdFJlY2VpdmVkID09PSBudWxsIHx8XG4gICAgICAgICAgICAgICAgbGluZS5xdWFudGl0eUluUmVjZWlwdFVuaXRSZWNlaXZlZCA9PT0gdW5kZWZpbmVkXG4gICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgcmV0dXJuIGxpbmUuc3RvY2tEZXRhaWxzLnNvbWUoKGRldGFpbDogU3RvY2tKb3VybmFsSW5wdXQpID0+IHtcbiAgICAgICAgICAgICAgICAvLyBjaGVjayBmb3IgZWFjaCBzdG9jayBkZXRhaWwgb24gdGhpcyBsaW5lLCB0aGUgcGFja2luZyB1bml0ICYgcXVhbnRpdHkgYXJlIGRlZmluZWRcbiAgICAgICAgICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgICAgICAgICAhZGV0YWlsLnBhY2tpbmdVbml0IHx8XG4gICAgICAgICAgICAgICAgICAgIGRldGFpbC5xdWFudGl0eUluUGFja2luZ1VuaXQgPT09IG51bGwgfHxcbiAgICAgICAgICAgICAgICAgICAgZGV0YWlsLnF1YW50aXR5SW5QYWNraW5nVW5pdCA9PT0gdW5kZWZpbmVkXG4gICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9XG5cbiAgICBwcml2YXRlIF9jbGVhbnVwU2Vzc2lvbigpIHtcbiAgICAgICAgdGhpcy5fcHVyY2hhc2VTZXNzaW9uID0gdGhpcy5wdXJjaGFzZVNlc3Npb247IC8vIGdldCB0aGUgbGF0ZXN0IGZyb20gc2Vzc2lvblxuICAgICAgICBpZiAoIXRoaXMuX3B1cmNoYXNlU2Vzc2lvbiB8fCAhdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcykgcmV0dXJuO1xuXG4gICAgICAgIC8vIHJlbW92ZSBhbnkgaW5jb21wbGV0ZSBwdXJjaGFzZSByZWNlaXB0IGxpbmVzIChleC4gYSBsaW5lIHdpdGhvdXQgc3RvY2tEZXRhaWxzKVxuICAgICAgICBjb25zdCBwcmV2TGluZUNvdW50ID0gdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcz8ubGVuZ3RoO1xuICAgICAgICB0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VSZWNlaXB0LmxpbmVzID0gdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcy5maWx0ZXIoXG4gICAgICAgICAgICAobGluZTogUHVyY2hhc2VSZWNlaXB0TGluZUlucHV0KSA9PiB7XG4gICAgICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgICAgICAhbGluZS5yZWNlaXB0VW5pdCB8fFxuICAgICAgICAgICAgICAgICAgICBsaW5lLnF1YW50aXR5SW5SZWNlaXB0VW5pdFJlY2VpdmVkID09PSBudWxsIHx8XG4gICAgICAgICAgICAgICAgICAgIGxpbmUucXVhbnRpdHlJblJlY2VpcHRVbml0UmVjZWl2ZWQgPT09IHVuZGVmaW5lZCB8fFxuICAgICAgICAgICAgICAgICAgICAhbGluZS5zdG9ja0RldGFpbHNcbiAgICAgICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIHJldHVybiAhbGluZS5zdG9ja0RldGFpbHMuc29tZSgoZGV0YWlsOiBTdG9ja0pvdXJuYWxJbnB1dCkgPT4ge1xuICAgICAgICAgICAgICAgICAgICAvLyBjaGVjayBmb3IgZWFjaCBzdG9jayBkZXRhaWwgb24gdGhpcyBsaW5lLCB0aGUgcGFja2luZyB1bml0ICYgcXVhbnRpdHkgYXJlIGRlZmluZWRcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgICAgICAgICAgICAgICFkZXRhaWwucGFja2luZ1VuaXQgfHxcbiAgICAgICAgICAgICAgICAgICAgICAgIGRldGFpbC5xdWFudGl0eUluUGFja2luZ1VuaXQgPT09IG51bGwgfHxcbiAgICAgICAgICAgICAgICAgICAgICAgIGRldGFpbC5xdWFudGl0eUluUGFja2luZ1VuaXQgPT09IHVuZGVmaW5lZFxuICAgICAgICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgKTtcblxuICAgICAgICAvLyBpZiBhbGwgbGluZXMgaGF2ZSBiZWVuIHJlbW92ZWQsIGNsZWFyIHRoZSBzZXNzaW9uXG4gICAgICAgIGlmICh0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VSZWNlaXB0LmxpbmVzPy5sZW5ndGggPT09IDApIHtcbiAgICAgICAgICAgIHRoaXMuY2xlYXJTZXNzaW9uKCk7XG4gICAgICAgIH0gZWxzZSBpZiAocHJldkxpbmVDb3VudCAhPT0gdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcy5sZW5ndGgpIHtcbiAgICAgICAgICAgIC8vIG90aGVyd2lzZSBpZiBhbnkgbGluZSBnb3QgcmVtb3ZlZCwgb3ZlcndyaXRlIHRoZSBzZXNzaW9uXG4gICAgICAgICAgICB0aGlzLnB1cmNoYXNlU2Vzc2lvbiA9IHRoaXMuX3B1cmNoYXNlU2Vzc2lvbjtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIHB1YmxpYyBjbGVhclNlc3Npb24oKTogdm9pZCB7XG4gICAgICAgIHRoaXMucGFnZS4kLnN0b3JhZ2UucmVtb3ZlKFB1cmNoYXNlUmVjZWlwdERldGFpbHNSZWNvcmRNYW5hZ2VyLlBVUkNIQVNFX1JFQ0VJUFRfS0VZKTtcbiAgICAgICAgdGhpcy5fcHVyY2hhc2VTZXNzaW9uID0gbnVsbDtcbiAgICB9XG5cbiAgICBwdWJsaWMgY3JlYXRlTGluZShcbiAgICAgICAgcGFnZToge1xuICAgICAgICAgICAgY2xvc2VQb0xpbmU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGw7IG9wdGlvbnM/OiBzdHJpbmdbXSB9O1xuICAgICAgICAgICAgZGVzY3JpcHRpb246IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHNpdGU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHN1cHBsaWVyOiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBwdXJjaGFzZU9yZGVyTnVtYmVyOiBzdHJpbmc7XG4gICAgICAgICAgICBwdXJjaGFzZU9yZGVyTGluZU51bWJlcjogc3RyaW5nIHwgbnVtYmVyIHwgYm9vbGVhbjtcbiAgICAgICAgICAgIHdhcmVob3VzZTogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgY29udGFpbmVyOiB7IHZhbHVlOiB7IGNvZGU/OiBzdHJpbmcgfSB8IG51bGwgfTtcbiAgICAgICAgICAgIHBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yOiB7IHZhbHVlOiBudW1iZXIgfCBudWxsIH07XG4gICAgICAgIH0sXG4gICAgICAgIHByb2R1Y3Q6IHtcbiAgICAgICAgICAgIHN0b2NrVW5pdDoge1xuICAgICAgICAgICAgICAgIGNvZGU6IHN0cmluZztcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgICBjb2RlOiBzdHJpbmc7ICAgICAgICAgICBcbiAgICAgICAgfVxuICAgICkge1xuICAgICAgICBpZiAoIXRoaXMuX3B1cmNoYXNlU2Vzc2lvbiB8fCAhdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcykgcmV0dXJuO1xuICAgICAgICBjb25zdCBjdXJyZW50TGluZU51bWJlciA9IHRoaXMuX3B1cmNoYXNlU2Vzc2lvbi5wdXJjaGFzZVJlY2VpcHQubGluZXMubGVuZ3RoIC0gMTtcbiAgICAgICAgY29uc3QgY3VycmVudExpbmUgPSB0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VSZWNlaXB0LmxpbmVzW2N1cnJlbnRMaW5lTnVtYmVyXTtcbiAgICAgICAgY3VycmVudExpbmUuc3RvY2tEZXRhaWxzID0gdGhpcy5fc3RvY2tEZXRhaWxzO1xuXG4gICAgICAgIC8vIElmIGFsbCByZWNlaXB0IHVuaXRzIGFyZSB0aGUgc2FtZSwgdXNlIHRoYXQgdW5pdCBmb3IgdGhlIGxpbmUuIElmIHRoZXJlIGFyZSBtdWx0aXBsZSByZWNlaXB0IHVuaXRzLFxuICAgICAgICAvLyB1c2Ugc3RvY2sgdW5pdCBmb3IgdGhlIGxpbmUuXG4gICAgICAgIGlmICh0aGlzLl91bml0SXNTYW1lKSB7XG4gICAgICAgICAgICBjdXJyZW50TGluZS5xdWFudGl0eUluUmVjZWlwdFVuaXRSZWNlaXZlZCA9IHRoaXMuX3JlY2VpcHRVbml0LnJlZHVjZTxkZWNpbWFsPigodG90YWxRdHksIGxpbmUpID0+IHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdG90YWxRdHkgKyBsaW5lLnF1YW50aXR5SW5SZWNlaXB0VW5pdDtcbiAgICAgICAgICAgIH0sIDApO1xuICAgICAgICAgICAgY3VycmVudExpbmUucmVjZWlwdFVuaXQgPSB0aGlzLl9yZWNlaXB0VW5pdFswXS5jb2RlO1xuICAgICAgICAgICAgY3VycmVudExpbmUucmVjZWlwdFVuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IgPSBOdW1iZXIoXG4gICAgICAgICAgICAgICAgcGFnZS5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSxcbiAgICAgICAgICAgICk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBjdXJyZW50TGluZS5xdWFudGl0eUluUmVjZWlwdFVuaXRSZWNlaXZlZCA9IHRoaXMuX3JlY2VpcHRVbml0LnJlZHVjZTxkZWNpbWFsPigodG90YWxRdHksIGxpbmUpID0+IHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdG90YWxRdHkgKyBOdW1iZXIobGluZS5xdWFudGl0eUluUmVjZWlwdFVuaXQpICogTnVtYmVyKGxpbmUuc3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvcik7XG4gICAgICAgICAgICB9LCAwKTtcbiAgICAgICAgICAgIGN1cnJlbnRMaW5lLnJlY2VpcHRVbml0ID0gcHJvZHVjdC5zdG9ja1VuaXQuY29kZTtcbiAgICAgICAgICAgIGN1cnJlbnRMaW5lLnJlY2VpcHRVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yID0gTnVtYmVyKFxuICAgICAgICAgICAgICAgIHBhZ2UucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWUsXG4gICAgICAgICAgICApO1xuICAgICAgICB9XG5cbiAgICAgICAgLy9TZXQgcmVjZWlwdCBsaW5lIG51bWJlclxuICAgICAgICBjdXJyZW50TGluZS5saW5lTnVtYmVyID0gKGN1cnJlbnRMaW5lTnVtYmVyICsgMSkgKiAxMDAwO1xuXG4gICAgICAgIC8qICBpZiAoXG4gICAgICAgICAgICBjdXJyZW50TGluZS5wdXJjaGFzZU9yZGVyTnVtYmVyICYmXG4gICAgICAgICAgICBjdXJyZW50TGluZS5wdXJjaGFzZU9yZGVyTGluZU51bWJlciAmJlxuICAgICAgICAgICAgY3VycmVudExpbmUucHVyY2hhc2VPcmRlckxpbmVcbiAgICAgICAgKSB7XG4gICAgICAgICAgICBjdXJyZW50TGluZS5fZm9yTXV0YXRpb25Pbmx5RG9DbG9zZVB1cmNoYXNlT3JkZXJMaW5lID1cbiAgICAgICAgICAgICAgICBwYWdlLmNsb3NlUG9MaW5lLm9wdGlvbnMuaW5kZXhPZihwYWdlLmNsb3NlUG9MaW5lLnZhbHVlKSA9PT0gMCA/IFllc05vRW51bS55ZXMgOiBZZXNOb0VudW0ubm87XG4gICAgICAgIH0gX2Zvck11dGF0aW9uT25seURvQ2xvc2VQdXJjaGFzZU9yZGVyTGluZSBtaXNzaW5nICovXG4gICAgICAgIGN1cnJlbnRMaW5lLmJhbGFuY2UgPSAoXG4gICAgICAgICAgICBwYWdlLmNsb3NlUG9MaW5lLnZhbHVlID09PSB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtcHVyY2hhc2luZy9ZZXMnLCAnWWVzJykgPyBZZXNOb0VudW0ueWVzIDogWWVzTm9FbnVtLm5vXG4gICAgICAgICkudG9TdHJpbmcoKTtcbiAgICAgICAgY3VycmVudExpbmUud2FyZWhvdXNlID0gcGFnZS53YXJlaG91c2UudmFsdWUgPz8gdW5kZWZpbmVkO1xuICAgICAgICBjdXJyZW50TGluZS5jb250YWluZXIgPSBwYWdlLmNvbnRhaW5lcj8udmFsdWU/LmNvZGU7XG4gICAgICAgIHRoaXMucHVyY2hhc2VTZXNzaW9uID0ge1xuICAgICAgICAgICAgcHVyY2hhc2VFbnRyeVRyYW5zYWN0aW9uOiB0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VFbnRyeVRyYW5zYWN0aW9uLFxuICAgICAgICAgICAgcHVyY2hhc2VSZWNlaXB0OiB0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VSZWNlaXB0LFxuICAgICAgICAgICAgb3JkZXJVbml0VG9QdXJjaGFzZVVuaXRDb252ZXJzaW9uRmFjdG9yOiBwYWdlLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLnZhbHVlID8/IDAsXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHVibGljIGxvYWRTdG9ja0RldGFpbHMoXG4gICAgICAgIHBhZ2U6IHtcbiAgICAgICAgICAgIHJlY2VpcHRVbml0OiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICByZWNlaXB0VW5pdENvZGU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHF1YW50aXR5VG9SZWNlaXZlOiB7IHZhbHVlOiBudW1iZXIgfCBudWxsIH07XG4gICAgICAgICAgICBxdWFudGl0eVRvUmVjZWl2ZU5vUm91bmRlZDogbnVtYmVyO1xuICAgICAgICAgICAgaXNQYWNraW5nVW5pdDogYm9vbGVhbjtcbiAgICAgICAgICAgIHJlbWFpbmluZ1F1YW50aXR5SW5QYWNraW5nVW5pdDogeyB2YWx1ZTogbnVtYmVyIHwgbnVsbCB9O1xuICAgICAgICAgICAgcmVtYWluaW5nUXVhbnRpdHlJblN0b2NrVW5pdDogeyB2YWx1ZTogbnVtYmVyIHwgbnVsbCB9O1xuICAgICAgICAgICAgcGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I6IHsgdmFsdWU6IG51bWJlciB8IG51bGwgfTtcbiAgICAgICAgICAgIHdhcmVob3VzZTogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgc3RhdHVzOiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBsaWNlbnNlUGxhdGVOdW1iZXI6IHsgdmFsdWU6IHsgY29kZT86IHN0cmluZyB9IHwgbnVsbCB9O1xuICAgICAgICAgICAgbG9jYXRpb246IHsgdmFsdWU6IHsgY29kZT86IHN0cmluZyB9IHwgbnVsbDsgaXNEaXNhYmxlZD86IGJvb2xlYW4gfTtcbiAgICAgICAgICAgIHN1cHBsaWVyTG90OiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBsb3Q6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHN1YmxvdDogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgcG90ZW5jeTogeyB2YWx1ZTogbnVtYmVyIHwgbnVsbCB9O1xuICAgICAgICAgICAgZXhwaXJhdGlvbkRhdGU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGw7IGlzRGlzYWJsZWQ/OiBib29sZWFuIH07XG4gICAgICAgICAgICBjYWxjdWxhdGVkRXhwaXJhdGlvbkRhdGU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHVzZUJ5RGF0ZTogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgc2VyaWFsTnVtYmVyOiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBtYWpvclZlcnNpb246IHsgdmFsdWU6IHsgY29kZT86IHN0cmluZyB9IHwgbnVsbCB9O1xuICAgICAgICAgICAgbWlub3JWZXJzaW9uOiB7IHZhbHVlOiB7IG1pbm9yVmVyc2lvbj86IHN0cmluZyB9IHwgbnVsbCB9O1xuICAgICAgICAgICAgbG90Q3VzdG9tRmllbGQxOiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBsb3RDdXN0b21GaWVsZDI6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIGxvdEN1c3RvbUZpZWxkMzogeyB2YWx1ZTogbnVtYmVyIHwgbnVsbCB9O1xuICAgICAgICAgICAgbG90Q3VzdG9tRmllbGQ0OiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBpZGVudGlmaWVyMTogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgaWRlbnRpZmllcjI6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgfSxcbiAgICAgICAgcHJvZHVjdDoge1xuICAgICAgICAgICAgc3RvY2tVbml0OiB7XG4gICAgICAgICAgICAgICAgY29kZTogc3RyaW5nO1xuICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIGNvZGU6IHN0cmluZztcbiAgICAgICAgfVxuICAgICkge1xuICAgICAgICBjb25zdCBxdWFudGl0eVJlY2VpdmVkSW5TdG9ja1VuaXQgPVxuICAgICAgICAgICAgKHBhZ2UucXVhbnRpdHlUb1JlY2VpdmUudmFsdWUgPz8gMCkgKiAocGFnZS5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSA/PyAxKTtcblxuICAgICAgICAvLyBTYXZpbmcgcmVjZWlwdCB1bml0cyBpcyBzZXBhcmF0ZSBhcnJheSBiZWNhdXNlIG9ubHkgc3RvY2sgYW5kIHBhY2tpbmcgdW5pdHMgYXJlIHNhdmVkIGF0IHN0b2NrIGRldGFpbHMgbGV2ZWwuXG4gICAgICAgIHRoaXMuX3JlY2VpcHRVbml0LnB1c2goe1xuICAgICAgICAgICAgY29kZTogcGFnZS5yZWNlaXB0VW5pdENvZGUudmFsdWUgPz8gJycsXG4gICAgICAgICAgICBxdWFudGl0eUluUmVjZWlwdFVuaXQ6IHBhZ2UucXVhbnRpdHlUb1JlY2VpdmUudmFsdWUgPz8gMCxcbiAgICAgICAgICAgIHN0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I6IHBhZ2UucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWUgPz8gMSxcbiAgICAgICAgfSk7XG5cbiAgICAgICAgLy8gQ2hlY2sgaWYgdW5pdCBpcyBkaWZmZXJlbnQgZnJvbSBwcmV2aW91cyBsaW5lXG4gICAgICAgIGlmICh0aGlzLl9yZWNlaXB0VW5pdC5sZW5ndGggPiAxICYmIHRoaXMuX3VuaXRJc1NhbWUpIHtcbiAgICAgICAgICAgIGlmIChwYWdlLnJlY2VpcHRVbml0Q29kZS52YWx1ZSAhPT0gdGhpcy5fcmVjZWlwdFVuaXRbdGhpcy5fcmVjZWlwdFVuaXQubGVuZ3RoIC0gMl0uY29kZSkge1xuICAgICAgICAgICAgICAgIHRoaXMuX3VuaXRJc1NhbWUgPSBmYWxzZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IGRldGFpbExpbmU6IFBhcnRpYWw8U3RvY2tKb3VybmFsSW5wdXQ+ID0ge1xuICAgICAgICAgICAgcGFja2luZ1VuaXQ6IHBhZ2UuaXNQYWNraW5nVW5pdCA/IChwYWdlLnJlY2VpcHRVbml0Q29kZS52YWx1ZSA/PyAnJykgOiBwcm9kdWN0LnN0b2NrVW5pdC5jb2RlLFxuICAgICAgICAgICAgcXVhbnRpdHlJblBhY2tpbmdVbml0OiBwYWdlLmlzUGFja2luZ1VuaXRcbiAgICAgICAgICAgICAgICA/IChwYWdlLnF1YW50aXR5VG9SZWNlaXZlLnZhbHVlID8/IDApXG4gICAgICAgICAgICAgICAgOiBxdWFudGl0eVJlY2VpdmVkSW5TdG9ja1VuaXQsXG4gICAgICAgICAgICBwYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3RvcjogcGFnZS5pc1BhY2tpbmdVbml0XG4gICAgICAgICAgICAgICAgPyAocGFnZS5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSA/PyAxKVxuICAgICAgICAgICAgICAgIDogMSxcbiAgICAgICAgICAgIGxvdDogcGFnZS5sb3QudmFsdWUgPz8gdW5kZWZpbmVkLCAvLyB1c2luZyB1bmRlZmluZWQsIG9taXRzIHRoZSBwcm9wZXJ0eSBlbnRpcmVseSBmcm9tIEpTT04gd2hlbiBzdHJpbmdpZmllZFxuICAgICAgICAgICAgc3VibG90OiBwYWdlLnN1YmxvdC52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBzdXBwbGllckxvdDogcGFnZS5zdXBwbGllckxvdC52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBwb3RlbmN5OiBwYWdlLnBvdGVuY3kudmFsdWUgPz8gdW5kZWZpbmVkLFxuICAgICAgICAgICAgbG9jYXRpb246IHBhZ2UubG9jYXRpb24udmFsdWU/LmNvZGUsXG4gICAgICAgICAgICBzZXJpYWxOdW1iZXI6IHBhZ2Uuc2VyaWFsTnVtYmVyLnZhbHVlID8/IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIHN0YXR1czogcGFnZS5zdGF0dXMudmFsdWUgPz8gdW5kZWZpbmVkLCAvLyB0aGlzIGlzIGFsd2F5cyByZXF1aXJlZFxuICAgICAgICAgICAgbWFqb3JWZXJzaW9uOiBwYWdlLm1ham9yVmVyc2lvbi52YWx1ZT8uY29kZSxcbiAgICAgICAgICAgIG1pbm9yVmVyc2lvbjogcGFnZS5taW5vclZlcnNpb24udmFsdWU/Lm1pbm9yVmVyc2lvbixcbiAgICAgICAgICAgIGxpY2Vuc2VQbGF0ZU51bWJlcjogcGFnZS5saWNlbnNlUGxhdGVOdW1iZXIudmFsdWU/LmNvZGUsXG4gICAgICAgICAgICBleHBpcmF0aW9uRGF0ZTpcbiAgICAgICAgICAgICAgICAocGFnZS5leHBpcmF0aW9uRGF0ZS5pc0Rpc2FibGVkID8gcGFnZS5jYWxjdWxhdGVkRXhwaXJhdGlvbkRhdGUudmFsdWUgOiBwYWdlLmV4cGlyYXRpb25EYXRlLnZhbHVlKSA/P1xuICAgICAgICAgICAgICAgIHVuZGVmaW5lZCxcbiAgICAgICAgICAgIHVzZUJ5RGF0ZTogcGFnZS51c2VCeURhdGUudmFsdWUgPz8gdW5kZWZpbmVkLFxuICAgICAgICAgICAgbG90Q3VzdG9tRmllbGQxOiBwYWdlLmxvdEN1c3RvbUZpZWxkMS52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBsb3RDdXN0b21GaWVsZDI6IHBhZ2UubG90Q3VzdG9tRmllbGQyLnZhbHVlID8/IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIGxvdEN1c3RvbUZpZWxkMzogcGFnZS5sb3RDdXN0b21GaWVsZDMudmFsdWUgPz8gdW5kZWZpbmVkLFxuICAgICAgICAgICAgbG90Q3VzdG9tRmllbGQ0OiBwYWdlLmxvdEN1c3RvbUZpZWxkNC52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBpZGVudGlmaWVyMTogcGFnZS5pZGVudGlmaWVyMS52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBpZGVudGlmaWVyMjogcGFnZS5pZGVudGlmaWVyMi52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgIH07XG5cbiAgICAgICAgdGhpcy5fc3RvY2tEZXRhaWxzLnB1c2goZGV0YWlsTGluZSk7XG5cbiAgICAgICAgLy8gSW5pdGlhbGl6ZSBkZXRhaWwgcGFnZSBmb3IgbmV4dCBkZXRhaWwgbGluZS4gIE1vc3QgZmllbGQgdmFsdWVzIHdpbGwgZGVmYXVsdCB0byBwcmV2aW91cyBkZXRhaWwgbGluZSB2YWx1ZXMuXG4gICAgICAgIHBhZ2UubG9jYXRpb24uaXNEaXNhYmxlZCA9IGZhbHNlO1xuICAgICAgICBwYWdlLmxpY2Vuc2VQbGF0ZU51bWJlci52YWx1ZSA9IHsgY29kZTogJycgfTtcbiAgICAgICAgcGFnZS5zdWJsb3QudmFsdWUgPSAnJztcbiAgICAgICAgcGFnZS5zZXJpYWxOdW1iZXIudmFsdWUgPSAnJztcblxuICAgICAgICBpZiAoIXRoaXMuX3B1cmNoYXNlU2Vzc2lvbiB8fCAhdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcykgcmV0dXJuO1xuXG4gICAgICAgIGNvbnN0IGN1cnJMaW5lID1cbiAgICAgICAgICAgIHRoaXMuX3B1cmNoYXNlU2Vzc2lvbi5wdXJjaGFzZVJlY2VpcHQubGluZXNbdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcy5sZW5ndGggLSAxXTtcblxuICAgICAgICBpZiAoIWN1cnJMaW5lLnB1cmNoYXNlT3JkZXIpIHtcbiAgICAgICAgICAgIC8vIFNldCByZW1haW5pbmcgcXVhbnRpdHkgdG8gMCBmb3IgZGlyZWN0IHJlY2VpcHRzXG4gICAgICAgICAgICBwYWdlLnF1YW50aXR5VG9SZWNlaXZlLnZhbHVlID0gMDtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIC8vIENhbGN1bGF0ZSByZW1haW5pbmcgcXVhbnRpdHkgZm9yIFBPIHJlY2VpcHQgbGluZXMgKG5vdCBkaXJlY3QgcmVjZWlwdClcbiAgICAgICAgICAgIC8vIHJlbWFpbmluZ1F1YW50aXR5IGFuZCBxdWFudGl0eVRvUmVjZWl2ZSB3aWxsIGFsd2F5cyBiZSB0aGUgc2FtZSB1bml0IGFuZCB0aGF0IHVuaXQgd2lsbCBiZSB0aGUgZGVmYXVsdFxuICAgICAgICAgICAgLy8gZm9yIHRoZSBuZXh0IGRldGFpbCBsaW5lLiAgVmFsdWUgY2FuIG5ldmVyIGJlIG5lZ2F0aXZlXG5cbiAgICAgICAgICAgIHBhZ2UucmVtYWluaW5nUXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSA9XG4gICAgICAgICAgICAgICAgKHBhZ2UucmVtYWluaW5nUXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSA/PyAwKSAtXG4gICAgICAgICAgICAgICAgKHBhZ2UucXVhbnRpdHlUb1JlY2VpdmUudmFsdWUgPz8gMCkgKiAocGFnZS5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSA/PyAxKTtcbiAgICAgICAgICAgIGlmIChwYWdlLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLnZhbHVlICE9PSAwKVxuICAgICAgICAgICAgICAgIHBhZ2UucmVtYWluaW5nUXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlID1cbiAgICAgICAgICAgICAgICAgICAgcGFnZS5yZW1haW5pbmdRdWFudGl0eUluU3RvY2tVbml0LnZhbHVlIC8gKHBhZ2UucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWUgPz8gMSk7XG4gICAgICAgICAgICBwYWdlLnF1YW50aXR5VG9SZWNlaXZlLnZhbHVlID0gTWF0aC5tYXgoMCwgcGFnZS5yZW1haW5pbmdRdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgPz8gMCk7XG4gICAgICAgICAgICBwYWdlLnF1YW50aXR5VG9SZWNlaXZlTm9Sb3VuZGVkID0gcGFnZS5xdWFudGl0eVRvUmVjZWl2ZS52YWx1ZTtcbiAgICAgICAgfVxuICAgIH1cbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../x3-purchasing/lib/client-functions/purchase-receipt-details-control.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-view-purchase-order-select-a-purchase-order-line.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;