"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findDefaultLocation = exports.findStockManagementRules = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const ui = require("@sage/xtrem-ui");
async function _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance) {
    try {
        //read the stock management rules
        const stockManagementRules = await pageInstance.$.graph
            .node('@sage/x3-stock-data/StockManagementRules')
            .query(ui.queryUtils.edgesSelector({
            productCategory: { code: true },
            stockSite: { code: true },
            transactionType: true,
            stockMovementCode: { code: true },
            defaultStatus: true,
            locationNumber: true,
            locationNumber2: true,
            locationNumber3: true,
            authorizedStatus: true,
            authorizedSubstatus: true,
            hasAnalysisRequest: true,
            lotEntry: true,
            lotByDefault: true,
            outputLot: true,
            isExclusiveEntryVersion: true,
            activeVersion: true,
            licensePlateNumberEntry: true,
            versionStopped: true,
            prototypeVersion: true,
        }, {
            filter: {
                productCategory: { code: productCategory },
                stockSite: { code: stockSite },
                transactionType: transactionType,
                stockMovementCode: { code: stockMovementCode },
            },
        }))
            .execute();
        if (typesLib.gt(stockManagementRules.edges.length, 0))
            return stockManagementRules.edges[0].node;
        else
            return null;
    }
    catch (e) { }
}
async function findStockManagementRules(stockSite, productCategory, transactionType, //TRSTYP, menu 704
stockMovementCode, //TRSCOD
pageInstance) {
    // for the stock site, the product category and the movement code
    let stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance);
    if (stockManagementRules)
        return stockManagementRules;
    // for stock site and product category
    stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, undefined, pageInstance);
    if (stockManagementRules)
        return stockManagementRules;
    // for product category and movement code
    stockManagementRules = await _readStockManagementRules(undefined, productCategory, transactionType, stockMovementCode, pageInstance);
    if (stockManagementRules)
        return stockManagementRules;
    // for product category
    stockManagementRules = await _readStockManagementRules(undefined, productCategory, transactionType, undefined, pageInstance);
    if (stockManagementRules)
        return stockManagementRules;
    // general rules
    stockManagementRules = await _readStockManagementRules(undefined, undefined, transactionType, undefined, pageInstance);
    if (stockManagementRules)
        return stockManagementRules;
    throw new Error(ui.localize('@sage/x3-purchasing-sales/stock_management_rules__notification__no_management_rules_error', `Could not retrieve the management rules for your product category {{ productCategory }} and for the site {{ siteCode }}`, { productCategory: productCategory, siteCode: stockSite }));
}
exports.findStockManagementRules = findStockManagementRules;
async function _readProductCategorySite(stockSite, productCategory, pageInstance) {
    try {
        //read the product category site
        const productCategorySite = await pageInstance.$.graph
            .node('@sage/x3-master-data/productCategory')
            .read({
            stockSite: { code: true },
            code: true,
            defaultLocations: {
                query: {
                    edges: {
                        node: {
                            defaultLocation: { code: true },
                            locationNumber: true,
                            defaultLocationType: true,
                        },
                    },
                },
            },
        }, 
        // TODO: find a better way if possible
        `${stockSite}|${productCategory}`)
            .execute();
        return productCategorySite ?? null;
    }
    catch (e) {
        return null;
    }
}
async function findDefaultLocation(productSite, stockManagementRules, pageInstance) {
    // find the default location for the product site
    const defaultLocation = productSite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));
    if (defaultLocation &&
        defaultLocation.node.defaultLocation &&
        !defaultLocation.node.defaultLocation.match(/[* ! # ?]/))
        return defaultLocation.node.defaultLocation;
    // find the default location for the product category site
    const ProductCategorySite = await _readProductCategorySite(productSite.stockSite.code, productSite.product.productCategory.code, pageInstance);
    if (ProductCategorySite) {
        const defaultLocationCateg = ProductCategorySite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));
        if (defaultLocationCateg &&
            defaultLocationCateg.node.defaultLocation &&
            !defaultLocationCateg.node.defaultLocation.match(/[* ! # ?]/))
            return defaultLocationCateg.node.defaultLocation;
    }
    return null;
}
exports.findDefaultLocation = findDefaultLocation;
//# sourceMappingURL=stock-management-rules.js.map