/// <reference types="@sage/x3-master-data/api" />
import { ProductSite } from '@sage/x3-master-data-api';
import { GraphApi } from '@sage/x3-purchasing-api';
import * as ui from '@sage/xtrem-ui';
import { IntersiteReceiptSession } from '../client-functions/intersite-receipt-details-control';
interface PageWithStorageAndSite {
    site: {
        value: string;
    };
    intersiteSession: IntersiteReceiptSession;
}
interface PageWithProductSite {
    productSite: ProductSite;
}
interface PageWithHeaderFields {
    product: {
        value: string;
    };
    description: {
        value: string;
    };
    salesDeliveryLineNumber: string | number | boolean;
    salesDeliveryId: string;
    supplier: {
        value: string;
    };
    headerTitleLeft: {
        value: string;
    };
    headerTitleRight: {
        value: string;
        prefix?: string;
    };
    headerLine2Left: {
        value: string;
    };
    headerLine2Right: {
        value: string;
        prefix?: string;
    };
    headerLine3Left: {
        value: string;
    };
    headerLine3Right: {
        value: string;
        prefix?: string;
    };
}
interface PageWithVersionFields {
    majorVersion: {
        isHidden: boolean;
        value: string;
    };
    minorVersion: {
        isHidden: boolean;
        value: string;
    };
}
interface PageWithLotFields {
    lot: {
        isHidden: boolean;
        value: string;
    };
    supplierLot: {
        isHidden: boolean;
        value: string;
    };
    sublot: {
        isHidden: boolean;
        value: string;
    };
    lotCustomField1: {
        isHidden: boolean;
        value: string;
    };
    lotCustomField2: {
        isHidden: boolean;
        value: string;
    };
    lotCustomField3: {
        isHidden: boolean;
        value: string;
    };
    lotCustomField4: {
        isHidden: boolean;
        value: string;
    };
    lotSequenceNumber: {
        value: string;
    };
}
interface PageWithPackUnitFields {
    receiptUnit: {
        options?: string[];
        isReadOnly: boolean;
        isDisabled: boolean;
        value: string;
    };
    receiptUnitCode: {
        value: string;
    };
    previousReceiptUnit: {
        value: string;
    };
    receiptUnits: Array<{
        node: {
            packingUnit: {
                code: string;
                numberOfDecimals: number;
            };
            packingUnitToStockUnitConversionFactor: string;
            isPackingFactorEntryAllowed: boolean;
        };
    }>;
    packingUnitToStockUnitConversionFactor: {
        value: number;
        isDisabled: boolean;
    };
    salesUnitToStockUnitConversionFactor: string;
    previousSalesUnitToStockUnitConversionFactor: string;
}
interface PageWithPurchaseReceiptMiscProperties {
    status: {
        value: string;
        options?: string[];
    };
    serialNumber: {
        isHidden: boolean;
        value: string;
    };
    licensePlateNumber: {
        isHidden: boolean;
    };
    location: {
        isHidden: boolean;
        isMandatory: boolean;
        value: {
            code: string;
            type: string;
            stockSite: {
                code: string;
            };
            warehouse: {
                code: string;
            };
        };
    };
    suggestedLocation: {
        isHidden: boolean;
        value: string;
    };
    expirationDate: {
        isHidden: boolean;
        value: string;
    };
    useByDate: {
        isHidden: boolean;
        value: string;
    };
    remainingQuantity: {
        value: number;
        isHidden: boolean;
    };
    quantityToReceive: {
        value: number;
        scale?: number;
    };
    lot: {
        isHidden: boolean;
        value: string;
    };
    isExpirationManaged: boolean;
    identifier1: {
        isHidden: boolean;
        isDisabled: boolean;
    };
    identifier2: {
        isHidden: boolean;
        isDisabled: boolean;
    };
    container: {
        value: {
            code?: string;
        };
        isHidden: boolean;
    };
    quantityToReceiveNoRounded: number;
    quantityToReceiveRounded: number;
    remainingQuantityNoRounded: number;
    remainingQuantityRounded: number;
    remainingQuantityInitial: number;
    isLocationPreloaded: boolean;
}
interface PageWithStockJournals {
    stockJournalNodeResponses: StockJournalNodeResponse[];
    currStockJournal: number;
}
export type IntersiteReceiptsDetailPage = ui.Page<GraphApi> & PageWithStorageAndSite & PageWithHeaderFields & PageWithVersionFields & PageWithLotFields & PageWithPackUnitFields & PageWithPurchaseReceiptMiscProperties & PageWithProductSite & PageWithStockJournals;
type SalesDeliveryNodeResponse = {
    salesDelivery: {
        id: string;
        salesSite: {
            code: string;
        };
        receivingSite: {
            code: string;
        };
    };
    stockUnit: {
        code: string;
        numberOfDecimals: number;
    };
    salesUnit: {
        code: string;
        numberOfDecimals: number;
    };
    product: {
        code: string;
    };
    salesOrderLine: {
        purchaseOrder: {
            orderFromSupplier: {
                code: {
                    code: string;
                };
            };
        };
    };
    quantityInStockUnitReceived: string;
    quantityInSalesUnitDelivered: string;
    salesUnitToStockUnitConversionFactor: string;
    majorProductVersion: {
        code: string;
    };
    minorProductVersion: string;
};
export type StockJournalNodeResponse = {
    stockSite: {
        code: string;
    };
    documentId: string;
    documentLine: number;
    sequence: number;
    product: {
        code: string;
    };
    quantityInStockUnit: number;
    isUpdated: boolean;
    lot: string;
    sublot: string;
    supplierLot: string;
    lotCustomField1: string;
    lotCustomField2: string;
    lotCustomField3: string;
    lotCustomField4: string;
    majorVersion: string;
    minorVersion: string;
    identifier1: string;
    identifier2: string;
    expirationDate: string;
    useByDate: string;
    status: string;
    serialNumber: string;
    startingSerialNumber: string;
    endingSerialNumber: string;
};
export declare class IntersiteReceiptDetailsInitializer {
    private static readonly QTY_DECIMAL_PLACES;
    private static readonly CONVERSION_RATE_DECIMAL_PLACES;
    static initializePage(page: IntersiteReceiptsDetailPage): Promise<boolean>;
    static _getSalesDeveryLine(page: ui.Page): Promise<SalesDeliveryNodeResponse | null>;
    static _getProductSite(page: IntersiteReceiptsDetailPage, productCode: string, salesSite: string): Promise<ProductSite | undefined>;
    static _getStatuses(page: IntersiteReceiptsDetailPage): Promise<string[]>;
    static _getStockJournals(page: IntersiteReceiptsDetailPage, product: string, salesSite: string): Promise<void>;
    static initHeader(page: PageWithHeaderFields, productSiteNode: ProductSite, salesDeliveryLine: SalesDeliveryNodeResponse): void;
}
export {};
//# sourceMappingURL=intersite-receipt-details-initializer.d.ts.map