import { GraphApi, PurchaseEntryTransactionInput, PurchaseReceiptInput } from '@sage/x3-purchasing-api';
import { StockManagementRules } from '@sage/x3-stock-data-api';
import { Page } from '@sage/xtrem-ui';
export declare function validate(page: Page): Promise<boolean>;
export declare function controlLotReceipt(pageInstance: Page, lot: string, product: string, entryType: string, site: string): Promise<boolean>;
export type IntersiteReceiptSession = {
    purchaseReceipt: PurchaseReceiptInput;
    purchaseEntryTransaction: PurchaseEntryTransactionInput;
    purchaseStockManagementRules?: StockManagementRules;
    salesUnitToStockUnitConversionFactor: number;
} | undefined;
export declare class IntersiteReceiptDetailsRecordManager {
    private page;
    constructor(page: Page<GraphApi>, cleanupIncompleteSessionLines?: boolean);
    private static readonly INTERSITE_RECEIPT_KEY;
    private _intersiteSession;
    get intersiteSession(): IntersiteReceiptSession;
    set intersiteSession(intersiteSession: IntersiteReceiptSession);
    private _checkStorage;
    private _cleanupSession;
    clearSession(): void;
}
//# sourceMappingURL=intersite-receipt-details-control.d.ts.map