"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShipmentLogisticalTracking = void 0;
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3PurchasingData = require("..");
const joins = {
    referenceJoins: {
        trackingStep: {
            glossaryId() {
                return 108;
            },
            code: 'trackingStep',
        },
        trackingDependency: {
            glossaryId() {
                return 108;
            },
            code: 'trackingDependency',
        },
    },
};
let ShipmentLogisticalTracking = class ShipmentLogisticalTracking extends xtrem_core_1.Node {
};
exports.ShipmentLogisticalTracking = ShipmentLogisticalTracking;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'VCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ShipmentLogisticalTracking.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYP',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], ShipmentLogisticalTracking.prototype, "entryType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STLIN',
    })
], ShipmentLogisticalTracking.prototype, "trackingSequence", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRKNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ShipmentLogisticalTracking.prototype, "trackingNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRKCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 108,
            },
            control: {
                glossaryId: 108,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ShipmentLogisticalTracking.prototype, "trackingStep", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRKPLNDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ShipmentLogisticalTracking.prototype, "trackingDueDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRKENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ShipmentLogisticalTracking.prototype, "trackingEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRKMDY',
    })
], ShipmentLogisticalTracking.prototype, "isMandatory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRKDEPCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 108,
            },
            control: {
                glossaryId: 108,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ShipmentLogisticalTracking.prototype, "trackingDependency", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRKDEPLIN',
    })
], ShipmentLogisticalTracking.prototype, "trackingUser", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRKCMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ShipmentLogisticalTracking.prototype, "trackingLineComments", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRKLIGSTAT',
        dataType: () => sageX3PurchasingData.enums.trackingStepStatusDatatype,
    })
], ShipmentLogisticalTracking.prototype, "trackingStepStatus", void 0);
exports.ShipmentLogisticalTracking = ShipmentLogisticalTracking = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SHIPTRACK',
        keyPropertyNames: ['id', 'entryType', 'trackingSequence'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                    entryType: 1,
                    trackingSequence: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['entryType', 'trackingSequence'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ShipmentLogisticalTracking);
//# sourceMappingURL=shipment-logistical-tracking.js.map