"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShipmentDocuments = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3PurchasingData = require("..");
const joins = {
    referenceJoins: {
        shipmentDocumentType: {
            glossaryId() {
                return 107;
            },
            code: 'shipmentDocumentType',
        },
        shipmentDocumentBusinessPartner: {
            code: 'shipmentDocumentBusinessPartner',
        },
        shipmentDocumentFileType: {
            glossaryId() {
                return 902;
            },
            code: 'shipmentDocumentFileType',
        },
    },
};
let ShipmentDocuments = class ShipmentDocuments extends xtrem_core_1.Node {
};
exports.ShipmentDocuments = ShipmentDocuments;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'VCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ShipmentDocuments.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYP',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], ShipmentDocuments.prototype, "entryType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDLIN',
    })
], ShipmentDocuments.prototype, "shipmentDocumentLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDTYPE',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 107,
            },
            control: {
                glossaryId: 107,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ShipmentDocuments.prototype, "shipmentDocumentType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDORI',
        dataType: () => sageX3PurchasingData.enums.documentOriginDatatype,
    })
], ShipmentDocuments.prototype, "shipmentDocumentOrigin", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDDATE',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ShipmentDocuments.prototype, "shipmentDocumentDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SDREF1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ShipmentDocuments.prototype, "shipmentDocumentReference1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SDREF2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ShipmentDocuments.prototype, "shipmentDocumentReference2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDBP',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], ShipmentDocuments.prototype, "shipmentDocumentBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDNTYP',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 902,
            },
            control: {
                glossaryId: 902,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ShipmentDocuments.prototype, "shipmentDocumentFileType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SDFILNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ShipmentDocuments.prototype, "shipmentDocumentFileName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SDCMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ShipmentDocuments.prototype, "shipmentDocumentComments", void 0);
exports.ShipmentDocuments = ShipmentDocuments = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SHIPDOC',
        keyPropertyNames: ['id', 'entryType', 'shipmentDocumentLine'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                    entryType: 1,
                    shipmentDocumentLine: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['entryType', 'shipmentDocumentLine'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ShipmentDocuments);
//# sourceMappingURL=shipment-documents.js.map