declare module '@sage/x3-purchasing-data-api-partial' {
    import type {
        EarlyDiscountLateCharge,
        InvoicingTerm,
        Package as SageX3InvoicingData$Package,
        PaymentTerm,
        ProductCategoryTaxLevels,
        ProductCategoryTaxLevelsBinding,
        ProductCategoryTaxLevelsInput,
        ProductTaxLevels,
        ProductTaxLevelsBinding,
        ProductTaxLevelsInput,
        SupplierInvoiceHeaderBillBySupplierAddressLines,
        SupplierInvoiceHeaderBillBySupplierAddressLinesBinding,
        SupplierInvoiceHeaderBillBySupplierAddressLinesInput,
        SupplierInvoiceHeaderBillBySupplierCompanyNames,
        SupplierInvoiceHeaderBillBySupplierCompanyNamesBinding,
        SupplierInvoiceHeaderBillBySupplierCompanyNamesInput,
        SupplierInvoiceHeaderComments,
        SupplierInvoiceHeaderCommentsBinding,
        SupplierInvoiceHeaderCommentsInput,
        SupplierInvoiceHeaderInput,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLines,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesBinding,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesBinding,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput,
        SupplierInvoiceHeaderTaxes,
        SupplierInvoiceHeaderTaxesBinding,
        SupplierInvoiceHeaderTaxesInput,
        TaxRule,
    } from '@sage/x3-invoicing-data-api';
    import type {
        Address,
        BomCodes,
        BusinessPartner,
        BusinessPartnerAddress,
        BusinessPartnerCompanyNames,
        BusinessPartnerCompanyNamesInput,
        Carrier,
        Container,
        Currency,
        Customer,
        CustomerAddress,
        CustomerProduct,
        CustomerProductInput,
        Incoterm,
        Package as SageX3MasterData$Package,
        Product,
        ProductCategory,
        ProductCategoryInput,
        ProductCategoryStatisticalGroups,
        ProductCategoryStatisticalGroupsBinding,
        ProductCategoryStatisticalGroupsInput,
        ProductInput,
        ProductPackingUnits,
        ProductPackingUnitsBinding,
        ProductPackingUnitsInput,
        ProductSite,
        ProductStatisticalGroups,
        ProductStatisticalGroupsBinding,
        ProductStatisticalGroupsInput,
        ShipToCustomerAddressCompanyNames,
        ShipToCustomerAddressCompanyNamesBinding,
        ShipToCustomerAddressCompanyNamesInput,
        ShipToCustomerAddressInput,
        ShipToCustomerAddressSalesReps,
        ShipToCustomerAddressSalesRepsBinding,
        ShipToCustomerAddressSalesRepsInput,
        Supplier,
        SupplierAddress,
        SupplierAddressInput,
        SupplierCategory,
        SupplierContact,
        SupplierContactInput,
        SupplierProduct,
        SupplierProductInput,
        TechnicalSheet,
        TransitArea,
        UnavailablePeriods,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type {
        CostType,
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type {
        Package as SageX3StockData$Package,
        ProductCategoryDefaultLocations,
        ProductCategoryDefaultLocationsBinding,
        ProductCategoryDefaultLocationsInput,
        ProductCategoryOverheads,
        ProductCategoryOverheadsBinding,
        ProductCategoryOverheadsInput,
        ProductCategoryPackingUnits,
        ProductCategoryPackingUnitsBinding,
        ProductCategoryPackingUnitsInput,
        StockManagementRules,
        StockManagementRulesInput,
    } from '@sage/x3-stock-data-api';
    import type { Country, Package as SageX3Structure$Package, SiteGroupings } from '@sage/x3-structure-api';
    import type {
        Access,
        Company,
        GenericPrintReport,
        Language,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface Action543$Enum {
        takeIntoAccount: 1;
        cancel: 2;
    }
    export type Action543 = keyof Action543$Enum;
    export interface Action$Enum {
        none: 1;
        signature: 2;
        refusal: 3;
        totalRefusal: 4;
    }
    export type Action = keyof Action$Enum;
    export interface Allocation545$Enum {
        quantityProRata: 1;
        amountProRata: 2;
        weightProRata: 3;
        volumeProRata: 4;
    }
    export type Allocation545 = keyof Allocation545$Enum;
    export interface AllocationEnum$Enum {
        no: 1;
        quantityProRata: 2;
        amountProRata: 3;
        weightProRata: 4;
        volumeProRata: 5;
    }
    export type AllocationEnum = keyof AllocationEnum$Enum;
    export interface AmountType2504$Enum {
        adjusted: 1;
        calculated: 2;
    }
    export type AmountType2504 = keyof AmountType2504$Enum;
    export interface BidType$Enum {
        mixed: 1;
        hierarchy: 2;
        parallel: 3;
    }
    export type BidType = keyof BidType$Enum;
    export interface Bid$Enum {
        bidEnd: 1;
        hierarchy: 2;
        parallel: 3;
    }
    export type Bid = keyof Bid$Enum;
    export interface CalculationBase$Enum {
        none: 1;
        excludeTaxAmount: 2;
        includeTaxAmount: 3;
        action: 4;
    }
    export type CalculationBase = keyof CalculationBase$Enum;
    export interface CalculationOfTaxes$Enum {
        lineOnly: 1;
        taxBasis: 2;
    }
    export type CalculationOfTaxes = keyof CalculationOfTaxes$Enum;
    export interface Choice$Enum {
        no: 1;
        yes: 2;
        all: 3;
    }
    export type Choice = keyof Choice$Enum;
    export interface CloseOrderLine$Enum {
        ifEqualOrGreaterThan: 1;
        perRequest: 2;
        never: 3;
        byTolerance: 4;
        byToleranceAndOnRequest: 5;
    }
    export type CloseOrderLine = keyof CloseOrderLine$Enum;
    export interface ClosedNotClosedAll$Enum {
        open: 1;
        closed: 2;
        all: 3;
    }
    export type ClosedNotClosedAll = keyof ClosedNotClosedAll$Enum;
    export interface CommitmentDate$Enum {
        orderDate: 1;
        requestedDeliveryDate: 2;
    }
    export type CommitmentDate = keyof CommitmentDate$Enum;
    export interface CommitmentType$Enum {
        taxExclAmount: 1;
        taxExclAmountNonDeductibleVat: 2;
    }
    export type CommitmentType = keyof CommitmentType$Enum;
    export interface Conflict$Enum {
        no: 1;
        warning: 2;
        hold: 3;
    }
    export type Conflict = keyof Conflict$Enum;
    export interface ContractProductSelection$Enum {
        next: 1;
        previous: 2;
        first: 3;
        last: 4;
        addLine: 5;
        cancelLine: 6;
    }
    export type ContractProductSelection = keyof ContractProductSelection$Enum;
    export interface ControlOfInvoicesToBeReceived$Enum {
        blockingByPeriod: 1;
        blockingByFiscalYear: 2;
        nonBlocking: 3;
    }
    export type ControlOfInvoicesToBeReceived = keyof ControlOfInvoicesToBeReceived$Enum;
    export interface ControlType549$Enum {
        notBlocking: 1;
        blocking: 2;
    }
    export type ControlType549 = keyof ControlType549$Enum;
    export interface Control$Enum {
        control: 1;
        noControl: 2;
    }
    export type Control = keyof Control$Enum;
    export interface CostLoadingOrderRcpt$Enum {
        basedOnCalculation: 1;
        basedOnProRata: 2;
    }
    export type CostLoadingOrderRcpt = keyof CostLoadingOrderRcpt$Enum;
    export interface CrystalReportsPurchasing$Enum {
        upTo: 1;
        startingFrom: 2;
        from: 3;
        to: 4;
        price: 5;
        quantity: 6;
        purchaseOrder: 7;
        supplier: 8;
        receivingSite9: 9;
        addressCode10: 10;
        supplierReference: 11;
        description: 12;
        receiptDate: 13;
        orderedQuantity: 14;
        shipmentMode: 15;
        paymentTerm: 16;
        netPrice: 17;
        taxExcludedAmount: 18;
        consumptionPoint: 19;
        returnNote: 20;
        authorizationNumber: 21;
        returnedQuantity: 22;
        supplierLot: 23;
        serialNumber: 24;
        pendingCreditMemo: 25;
        blanketOrder: 26;
        validityDate: 27;
        validityEnd: 28;
        currency: 29;
        payment: 30;
        supplierProduct: 31;
        receivingSite: 32;
        addressCode: 33;
        purQuantity: 34;
        site: 35;
        address: 36;
        productTaxExcluded: 37;
        totalTaxExcluded: 38;
        totalTax: 39;
        netToPay: 40;
        vatBasis: 41;
        rate: 42;
        taxAmount: 43;
        totalTaxInc: 44;
        toDateTheFollowingCallsForTendersAboutWhichYouHaveBeenConsulted: 45;
        didNotLeadToAnyCommercialPropositionOnYourBehalf: 46;
        weHopeWeWillBeReceivingYourOfferAsSoonAsPossible: 47;
        purchasingDepartment: 48;
        theFollowingItemsThoughTheyShouldHaveArrivedAtTheMentionedDatesHaveNotBeenDeliveredYet: 49;
        weHopeThatYouWillSendUsTheseItemsAsSoonAsPossible: 50;
        callForTender: 51;
        leadTime: 52;
        responseEndDate: 53;
        deliveryCallOff: 54;
        requestForProposalReminder: 55;
        receipt: 56;
        expectedQuantity: 57;
        reminder: 58;
        startingSerialNumber: 59;
        qty: 60;
    }
    export type CrystalReportsPurchasing = keyof CrystalReportsPurchasing$Enum;
    export interface CurrencyRateSearchDate$Enum {
        orderDate: 1;
        receiptDate: 2;
        invoiceDate: 3;
    }
    export type CurrencyRateSearchDate = keyof CurrencyRateSearchDate$Enum;
    export interface CustomerProductReferencing$Enum {
        mandatory: 1;
        optional: 2;
        useless: 3;
    }
    export type CustomerProductReferencing = keyof CustomerProductReferencing$Enum;
    export interface DocumentOrigin$Enum {
        notApplicable: 1;
        air: 2;
        sea: 3;
        road: 4;
        rail: 5;
    }
    export type DocumentOrigin = keyof DocumentOrigin$Enum;
    export interface DocumentTypeForSeqNumber$Enum {
        rfq: 1;
        purchaseRequest: 2;
        standardOrder: 3;
        subcontractedOrder: 4;
        contract: 5;
        receipt: 6;
        return: 7;
        invoice: 8;
        additionalInvoice: 9;
        creditNote: 10;
        creditNoteOnReturn: 11;
        priceRecord: 12;
        intersiteReceipt: 13;
        intersiteReturn: 14;
        subcontractOrder: 15;
        container: 16;
        transport: 17;
        shipment: 18;
    }
    export type DocumentTypeForSeqNumber = keyof DocumentTypeForSeqNumber$Enum;
    export interface DueDateCalculationBase$Enum {
        receiptDate: 1;
        invoiceDate: 2;
    }
    export type DueDateCalculationBase = keyof DueDateCalculationBase$Enum;
    export interface EoEstimatedCostCalc$Enum {
        no: 1;
        inEoCreation: 2;
        inEoCreationAndModification: 3;
    }
    export type EoEstimatedCostCalc = keyof EoEstimatedCostCalc$Enum;
    export interface EoManagementMode$Enum {
        noModification: 1;
        materialModification: 2;
        serviceModification: 3;
        materialAndServiceModification: 4;
    }
    export type EoManagementMode = keyof EoManagementMode$Enum;
    export interface EomupdSelection$Enum {
        noUpdate: 1;
        service: 2;
        bom: 3;
        serviceAndBom: 4;
    }
    export type EomupdSelection = keyof EomupdSelection$Enum;
    export interface GapCalculationSource$Enum {
        standardData: 1;
        osData: 2;
    }
    export type GapCalculationSource = keyof GapCalculationSource$Enum;
    export interface GenerationType$Enum {
        actual: 1;
        simulation: 2;
    }
    export type GenerationType = keyof GenerationType$Enum;
    export interface InterSiteRequirements$Enum {
        byDefaultOnContracts1: 1;
        byDefaultOnContracts: 2;
    }
    export type InterSiteRequirements = keyof InterSiteRequirements$Enum;
    export interface InvoiceCurrencyRateDate$Enum {
        accountingDate: 1;
        supplierDate: 2;
    }
    export type InvoiceCurrencyRateDate = keyof InvoiceCurrencyRateDate$Enum;
    export interface InvoiceDecommitmentDate$Enum {
        commitmentDate: 1;
        invoiceDate: 2;
    }
    export type InvoiceDecommitmentDate = keyof InvoiceDecommitmentDate$Enum;
    export interface InvoicePriceAdjustment586$Enum {
        withoutLandedCosts: 1;
        withLandedCosts: 2;
    }
    export type InvoicePriceAdjustment586 = keyof InvoicePriceAdjustment586$Enum;
    export interface InvoicePriceAdjustment$Enum {
        withoutApproximationCoefficient: 1;
        withApproximationCoefficient: 2;
    }
    export type InvoicePriceAdjustment = keyof InvoicePriceAdjustment$Enum;
    export interface InvoiceableQuantity$Enum {
        qtyA: 1;
        qtyAQ: 2;
        qtyAQR: 3;
    }
    export type InvoiceableQuantity = keyof InvoiceableQuantity$Enum;
    export interface InvoicingElementImport$Enum {
        selfBalancing: 1;
        control: 2;
    }
    export type InvoicingElementImport = keyof InvoicingElementImport$Enum;
    export interface JournalType$Enum {
        purchaseRequest: 1;
        order: 2;
        contract: 3;
        all: 4;
    }
    export type JournalType = keyof JournalType$Enum;
    export interface MinimumReceiptDate$Enum {
        orderDate: 1;
        orderDateLeadTime: 2;
    }
    export type MinimumReceiptDate = keyof MinimumReceiptDate$Enum;
    export interface MovementCategory$Enum {
        standard: 1;
        forSubcontracting: 2;
    }
    export type MovementCategory = keyof MovementCategory$Enum;
    export interface NoneCloseCancellation$Enum {
        none: 1;
        close: 2;
        cancel: 3;
    }
    export type NoneCloseCancellation = keyof NoneCloseCancellation$Enum;
    export interface OrderLineType$Enum {
        normal: 1;
        parentProductBom: 2;
        subcontractService: 3;
        suppliedMaterial: 4;
    }
    export type OrderLineType = keyof OrderLineType$Enum;
    export interface OrderTransferOnInvoice$Enum {
        first: 1;
        all: 2;
    }
    export type OrderTransferOnInvoice = keyof OrderTransferOnInvoice$Enum;
    export interface OrderType529$Enum {
        std: 1;
        ctr: 2;
        sC: 3;
    }
    export type OrderType529 = keyof OrderType529$Enum;
    export interface OrderedQuantityControl$Enum {
        blocking: 1;
        warning: 2;
        noControl: 3;
    }
    export type OrderedQuantityControl = keyof OrderedQuantityControl$Enum;
    export interface PrecommitmentUpdate$Enum {
        uponFirstSignature: 1;
        uponLastSignature: 2;
        uponCreation: 3;
    }
    export type PrecommitmentUpdate = keyof PrecommitmentUpdate$Enum;
    export interface ProcessType526$Enum {
        signature: 1;
        cancellation: 2;
    }
    export type ProcessType526 = keyof ProcessType526$Enum;
    export interface ProductReferenceEntryFormat$Enum {
        ofProduct: 1;
        ofSupplier: 2;
    }
    export type ProductReferenceEntryFormat = keyof ProductReferenceEntryFormat$Enum;
    export interface ProductSupplierReferencing$Enum {
        mandatory: 1;
        optional: 2;
        notUsed: 3;
    }
    export type ProductSupplierReferencing = keyof ProductSupplierReferencing$Enum;
    export interface ProductsToBeProcessed$Enum {
        productsManagedInStock: 1;
        productsNotManaged: 2;
        allProducts: 3;
    }
    export type ProductsToBeProcessed = keyof ProductsToBeProcessed$Enum;
    export interface ProvisionalCostType2505$Enum {
        theoretical: 1;
        release: 2;
        provisional: 3;
    }
    export type ProvisionalCostType2505 = keyof ProvisionalCostType2505$Enum;
    export interface PurchaseDocumentType$Enum {
        rfq: 1;
        purchaseRequest: 2;
        standardOrder: 3;
        subcontractOrder: 4;
        openOrder: 5;
        receipt: 6;
        return: 7;
        invoiceCreditNote: 8;
        subcontractOrderEo: 9;
    }
    export type PurchaseDocumentType = keyof PurchaseDocumentType$Enum;
    export interface PurchaseInvoice3WayMatch$Enum {
        noRestriction: 1;
        loadFromPoIfNoReceiptExists: 2;
        loadFromReceiptOnly: 3;
    }
    export type PurchaseInvoice3WayMatch = keyof PurchaseInvoice3WayMatch$Enum;
    export interface PurchasePriceReasonEnum$Enum {
        standardCost: 1;
        manual: 2;
        newCost: 3;
    }
    export type PurchasePriceReasonEnum = keyof PurchasePriceReasonEnum$Enum;
    export interface PurchaseRequestLineValue$Enum {
        standardCost: 1;
        priceSearch: 2;
    }
    export type PurchaseRequestLineValue = keyof PurchaseRequestLineValue$Enum;
    export interface PurchaseSortOrder2502$Enum {
        siteJournalNumber: 1;
        siteDate: 2;
        siteSupplier: 3;
        journalNumber: 4;
        date: 5;
        supplier: 6;
    }
    export type PurchaseSortOrder2502 = keyof PurchaseSortOrder2502$Enum;
    export interface PurchaseSortOrder$Enum {
        journalNumber: 1;
        date: 2;
        supplier: 3;
    }
    export type PurchaseSortOrder = keyof PurchaseSortOrder$Enum;
    export interface PurchaseType507$Enum {
        commercial: 1;
        general: 2;
    }
    export type PurchaseType507 = keyof PurchaseType507$Enum;
    export interface QuantityEntryMode541$Enum {
        enteredWithUnit: 1;
        enteredWithoutUnit: 2;
    }
    export type QuantityEntryMode541 = keyof QuantityEntryMode541$Enum;
    export interface QuantityEntryMode$Enum {
        enteredWithUnit: 1;
        enteredWithoutUnit: 2;
        displayed: 3;
        hidden: 4;
    }
    export type QuantityEntryMode = keyof QuantityEntryMode$Enum;
    export interface QuantityStatus$Enum {
        suspendedDetail: 1;
        details: 2;
    }
    export type QuantityStatus = keyof QuantityStatus$Enum;
    export interface ReInstatementOnOrder$Enum {
        no: 1;
        yesSameLlne: 2;
        yesOtherLine: 3;
        yesOtherOrder: 4;
    }
    export type ReInstatementOnOrder = keyof ReInstatementOnOrder$Enum;
    export interface ReceiptOnOrderLine$Enum {
        ifRemainingQuantity: 1;
        completelyReceived: 2;
    }
    export type ReceiptOnOrderLine = keyof ReceiptOnOrderLine$Enum;
    export interface ReceiptQuantityConversion$Enum {
        quantityRecalculationInChange: 1;
        noQuantityRecalculation: 2;
        recalculationExceptPacPur: 3;
    }
    export type ReceiptQuantityConversion = keyof ReceiptQuantityConversion$Enum;
    export interface RequestSource$Enum {
        purchases: 1;
        directOrder: 2;
        receivedDirectOrder: 3;
        transfer: 4;
        production: 5;
    }
    export type RequestSource = keyof RequestSource$Enum;
    export interface RequirementsSelection$Enum {
        withoutDirectOrder: 1;
        withDirectOrder: 2;
        directOrderOnly: 3;
    }
    export type RequirementsSelection = keyof RequirementsSelection$Enum;
    export interface ReturnReason$Enum {
        notConforming: 1;
        damaged: 2;
        notOrdered: 3;
        other: 4;
    }
    export type ReturnReason = keyof ReturnReason$Enum;
    export interface RevisionParamMenu$Enum {
        notManaged: 1;
        managedOnDemand: 2;
        managedAutomatically: 3;
    }
    export type RevisionParamMenu = keyof RevisionParamMenu$Enum;
    export interface RoundingType$Enum {
        roundingToTheNearestNumber: 1;
        roundingDownToTheNextDecimal: 2;
        roundingDownToTheNextInteger: 3;
        roundingUpToTheNextDecimal: 4;
        roundingUpToTheNextInteger: 5;
    }
    export type RoundingType = keyof RoundingType$Enum;
    export interface SelectionOfRequirements$Enum {
        onStartDate: 1;
        onEndDate: 2;
    }
    export type SelectionOfRequirements = keyof SelectionOfRequirements$Enum;
    export interface ShipmentManagement$Enum {
        orderLine: 1;
        multipleContainers: 2;
        singleContainer: 3;
    }
    export type ShipmentManagement = keyof ShipmentManagement$Enum;
    export interface ShipmentRecordType$Enum {
        shipment: 1;
        preReceivedOrder: 2;
    }
    export type ShipmentRecordType = keyof ShipmentRecordType$Enum;
    export interface ShipmentStatus$Enum {
        created: 1;
        shipped: 2;
        preReceived: 3;
        received: 4;
        closed: 5;
    }
    export type ShipmentStatus = keyof ShipmentStatus$Enum;
    export interface Signature531$Enum {
        no: 1;
        yesOptional: 2;
        yesMandatory: 3;
    }
    export type Signature531 = keyof Signature531$Enum;
    export interface SignatureRuleType$Enum {
        purchaseRequest: 1;
        order: 2;
        contract: 3;
    }
    export type SignatureRuleType = keyof SignatureRuleType$Enum;
    export interface SortOrder2409$Enum {
        partNumber: 1;
        date: 2;
        requestFrom: 3;
    }
    export type SortOrder2409 = keyof SortOrder2409$Enum;
    export interface SortOrder2410$Enum {
        sitePartNumber: 1;
        siteDate: 2;
        siteRequestFrom: 3;
        partNumber: 4;
        date: 5;
        requestFrom: 6;
    }
    export type SortOrder2410 = keyof SortOrder2410$Enum;
    export interface StartEndOfLine$Enum {
        startOfLine: 1;
        endOfLine: 2;
        accordingToReferenceProduct: 3;
    }
    export type StartEndOfLine = keyof StartEndOfLine$Enum;
    export interface Status$Enum {
        created: 1;
        inProgress: 2;
        arrived: 3;
    }
    export type Status = keyof Status$Enum;
    export interface SubContractRequirements$Enum {
        subcontractedProduct: 1;
        service: 2;
    }
    export type SubContractRequirements = keyof SubContractRequirements$Enum;
    export interface SubcontractCostType$Enum {
        theoreticalForecast: 1;
        launchForecast: 2;
        manufacturingForecast: 3;
        actualCostPrice: 4;
        actualCostPriceForPlannedQuantity: 5;
        manufacturingForecastForAchievedQuantity: 6;
    }
    export type SubcontractCostType = keyof SubcontractCostType$Enum;
    export interface SubstituteSigners$Enum {
        signer: 1;
        substitute: 2;
    }
    export type SubstituteSigners = keyof SubstituteSigners$Enum;
    export interface SuggestionConsumption$Enum {
        automatic: 1;
        manual: 2;
    }
    export type SuggestionConsumption = keyof SuggestionConsumption$Enum;
    export interface SupplierGradingScale$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
    }
    export type SupplierGradingScale = keyof SupplierGradingScale$Enum;
    export interface SupplierInformationType$Enum {
        lastCallForTenders: 1;
        lastPurchaseRequest: 2;
        lastOrder: 3;
        lastReceipt: 4;
        lastReturn: 5;
        lastInvoice: 6;
        lastCreditMemo: 7;
        lastPayment: 8;
    }
    export type SupplierInformationType = keyof SupplierInformationType$Enum;
    export interface SupplierInvoice$Enum {
        all: 1;
        open: 2;
        withPayments: 3;
    }
    export type SupplierInvoice = keyof SupplierInvoice$Enum;
    export interface SupplierMovementType$Enum {
        callForTenders: 1;
        purchaseRequest: 2;
        order: 3;
        receipt: 4;
        return: 5;
        invoice: 6;
        payment: 7;
    }
    export type SupplierMovementType = keyof SupplierMovementType$Enum;
    export interface SupplierSelectionCriterion$Enum {
        primeSupplier: 1;
        bestPrice: 2;
        bestLeadTime: 3;
    }
    export type SupplierSelectionCriterion = keyof SupplierSelectionCriterion$Enum;
    export interface SupplierSource$Enum {
        orderSupplier: 1;
        invoiceSupplier: 2;
    }
    export type SupplierSource = keyof SupplierSource$Enum;
    export interface SupplierType$Enum {
        normal: 1;
        prospect: 2;
        miscellaneous: 3;
    }
    export type SupplierType = keyof SupplierType$Enum;
    export interface TaxCodeControl$Enum {
        none: 1;
        notBlocking: 2;
        blocking: 3;
    }
    export type TaxCodeControl = keyof TaxCodeControl$Enum;
    export interface TaxRule538$Enum {
        productRate: 1;
        fixedRate: 2;
    }
    export type TaxRule538 = keyof TaxRule538$Enum;
    export interface TrackingOfTheSupplierText$Enum {
        headerText: 1;
        footerText: 2;
    }
    export type TrackingOfTheSupplierText = keyof TrackingOfTheSupplierText$Enum;
    export interface TrackingStepStatus$Enum {
        toDo: 1;
        inProgress: 2;
        completed: 3;
    }
    export type TrackingStepStatus = keyof TrackingStepStatus$Enum;
    export interface TransferOfOrderToInvoice$Enum {
        amountProRata: 1;
        quantityProRata: 2;
        weightProRata: 3;
        volumeProRata: 4;
        firstDocument: 5;
        allDocuments: 6;
    }
    export type TransferOfOrderToInvoice = keyof TransferOfOrderToInvoice$Enum;
    export interface TransportMode$Enum {
        air: 1;
        sea: 2;
        road: 3;
        rail: 4;
        multimodal: 5;
        notDefined: 6;
    }
    export type TransportMode = keyof TransportMode$Enum;
    export interface TransportSelection$Enum {
        fromDepartureDate: 1;
        fromPlannedArrivalDate: 2;
    }
    export type TransportSelection = keyof TransportSelection$Enum;
    export interface TypeOfDocument544$Enum {
        order: 1;
        receipt: 2;
    }
    export type TypeOfDocument544 = keyof TypeOfDocument544$Enum;
    export interface UsePReqLineText$Enum {
        no: 1;
        onOrderLine: 2;
    }
    export type UsePReqLineText = keyof UsePReqLineText$Enum;
    export interface UserForQuotation$Enum {
        requester: 1;
        buyer: 2;
    }
    export type UserForQuotation = keyof UserForQuotation$Enum;
    export interface VarianceCalculationSource2403$Enum {
        standard: 1;
        order: 2;
    }
    export type VarianceCalculationSource2403 = keyof VarianceCalculationSource2403$Enum;
    export interface DeliveryMode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface DeliveryModeInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface DeliveryModeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface DeliveryMode$Operations {
        query: QueryOperation<DeliveryMode>;
        read: ReadOperation<DeliveryMode>;
        aggregate: {
            read: AggregateReadOperation<DeliveryMode>;
            query: AggregateQueryOperation<DeliveryMode>;
        };
        getDefaults: GetDefaultsOperation<DeliveryMode>;
    }
    export interface FreightContainer extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        containerIdentification: string;
        site: Site;
        supplier: Supplier;
        freightContainer: Container;
        isFull: boolean;
        totalWeightOfLines: string;
        weightUnit: UnitOfMeasure;
        totalVolumeOfLines: string;
        volumeUnit: UnitOfMeasure;
        amountOfLinesExcludingTax: string;
        currency: Currency;
        sealNumber1: string;
        sealNumber2: string;
        sealNumber3: string;
        purchaseShipment: string;
        totalWeightOfFreightContainer: string;
        availableWeight: string;
        availableVolume: string;
    }
    export interface FreightContainerInput extends ClientNodeInput {
        id?: string;
        containerIdentification?: string;
        site?: string;
        supplier?: string;
        freightContainer?: string;
        isFull?: boolean | string;
        totalWeightOfLines?: decimal | string;
        weightUnit?: string;
        totalVolumeOfLines?: decimal | string;
        volumeUnit?: string;
        amountOfLinesExcludingTax?: decimal | string;
        currency?: string;
        sealNumber1?: string;
        sealNumber2?: string;
        sealNumber3?: string;
        purchaseShipment?: string;
        totalWeightOfFreightContainer?: decimal | string;
        availableWeight?: decimal | string;
        availableVolume?: decimal | string;
    }
    export interface FreightContainerBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        containerIdentification: string;
        site: Site;
        supplier: Supplier;
        freightContainer: Container;
        isFull: boolean;
        totalWeightOfLines: string;
        weightUnit: UnitOfMeasure;
        totalVolumeOfLines: string;
        volumeUnit: UnitOfMeasure;
        amountOfLinesExcludingTax: string;
        currency: Currency;
        sealNumber1: string;
        sealNumber2: string;
        sealNumber3: string;
        purchaseShipment: string;
        totalWeightOfFreightContainer: string;
        availableWeight: string;
        availableVolume: string;
    }
    export interface FreightContainer$Lookups {
        site: QueryOperation<Site>;
        supplier: QueryOperation<Supplier>;
        freightContainer: QueryOperation<Container>;
        weightUnit: QueryOperation<UnitOfMeasure>;
        volumeUnit: QueryOperation<UnitOfMeasure>;
        currency: QueryOperation<Currency>;
    }
    export interface FreightContainer$Operations {
        query: QueryOperation<FreightContainer>;
        read: ReadOperation<FreightContainer>;
        aggregate: {
            read: AggregateReadOperation<FreightContainer>;
            query: AggregateQueryOperation<FreightContainer>;
        };
        lookups(dataOrId: string | { data: FreightContainerInput }): FreightContainer$Lookups;
        getDefaults: GetDefaultsOperation<FreightContainer>;
    }
    export interface FreightCostStructure extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        isActive: boolean;
    }
    export interface FreightCostStructureInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        isActive?: boolean | string;
    }
    export interface FreightCostStructureBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        isActive: boolean;
    }
    export interface FreightCostStructure$Operations {
        query: QueryOperation<FreightCostStructure>;
        read: ReadOperation<FreightCostStructure>;
        aggregate: {
            read: AggregateReadOperation<FreightCostStructure>;
            query: AggregateQueryOperation<FreightCostStructure>;
        };
        getDefaults: GetDefaultsOperation<FreightCostStructure>;
    }
    export interface MatchingTolerance extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
    }
    export interface MatchingToleranceInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
    }
    export interface MatchingToleranceBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
    }
    export interface MatchingTolerance$Operations {
        query: QueryOperation<MatchingTolerance>;
        read: ReadOperation<MatchingTolerance>;
        aggregate: {
            read: AggregateReadOperation<MatchingTolerance>;
            query: AggregateQueryOperation<MatchingTolerance>;
        };
        getDefaults: GetDefaultsOperation<MatchingTolerance>;
    }
    export interface PurchaseInvoiceType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        invoiceCategory: InvoiceType;
    }
    export interface PurchaseInvoiceTypeInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        purchaseInvoiceCategory?: PurchaseInvoiceCategory;
        invoiceCategory?: InvoiceType;
    }
    export interface PurchaseInvoiceTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        invoiceCategory: InvoiceType;
    }
    export interface PurchaseInvoiceType$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface PurchaseInvoiceType$Operations {
        query: QueryOperation<PurchaseInvoiceType>;
        read: ReadOperation<PurchaseInvoiceType>;
        aggregate: {
            read: AggregateReadOperation<PurchaseInvoiceType>;
            query: AggregateQueryOperation<PurchaseInvoiceType>;
        };
        lookups(dataOrId: string | { data: PurchaseInvoiceTypeInput }): PurchaseInvoiceType$Lookups;
        getDefaults: GetDefaultsOperation<PurchaseInvoiceType>;
    }
    export interface PurchasePriceReason extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        localizedDescription: string;
    }
    export interface PurchasePriceReasonInput extends ClientNodeInput {
        code?: integer | string;
        localizedDescription?: string;
    }
    export interface PurchasePriceReasonBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        localizedDescription: string;
    }
    export interface PurchasePriceReason$Operations {
        query: QueryOperation<PurchasePriceReason>;
        read: ReadOperation<PurchasePriceReason>;
        aggregate: {
            read: AggregateReadOperation<PurchasePriceReason>;
            query: AggregateQueryOperation<PurchasePriceReason>;
        };
        getDefaults: GetDefaultsOperation<PurchasePriceReason>;
    }
    export interface ShipmentDocuments extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        entryType: EntryTypeEnum;
        shipmentDocumentLine: integer;
        shipmentDocumentType: MiscellaneousTable;
        shipmentDocumentOrigin: DocumentOrigin;
        shipmentDocumentDate: string;
        shipmentDocumentReference1: string;
        shipmentDocumentReference2: string;
        shipmentDocumentBusinessPartner: BusinessPartner;
        shipmentDocumentFileType: MiscellaneousTable;
        shipmentDocumentFileName: string;
        shipmentDocumentComments: string;
    }
    export interface ShipmentDocumentsInput extends ClientNodeInput {
        id?: string;
        entryType?: EntryTypeEnum;
        shipmentDocumentLine?: integer | string;
        shipmentDocumentType?: string;
        shipmentDocumentOrigin?: DocumentOrigin;
        shipmentDocumentDate?: string;
        shipmentDocumentReference1?: string;
        shipmentDocumentReference2?: string;
        shipmentDocumentBusinessPartner?: string;
        shipmentDocumentFileType?: string;
        shipmentDocumentFileName?: string;
        shipmentDocumentComments?: string;
    }
    export interface ShipmentDocumentsBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        entryType: EntryTypeEnum;
        shipmentDocumentLine: integer;
        shipmentDocumentType: MiscellaneousTable;
        shipmentDocumentOrigin: DocumentOrigin;
        shipmentDocumentDate: string;
        shipmentDocumentReference1: string;
        shipmentDocumentReference2: string;
        shipmentDocumentBusinessPartner: BusinessPartner;
        shipmentDocumentFileType: MiscellaneousTable;
        shipmentDocumentFileName: string;
        shipmentDocumentComments: string;
    }
    export interface ShipmentDocuments$Lookups {
        shipmentDocumentType: QueryOperation<MiscellaneousTable>;
        shipmentDocumentBusinessPartner: QueryOperation<BusinessPartner>;
        shipmentDocumentFileType: QueryOperation<MiscellaneousTable>;
    }
    export interface ShipmentDocuments$Operations {
        query: QueryOperation<ShipmentDocuments>;
        read: ReadOperation<ShipmentDocuments>;
        aggregate: {
            read: AggregateReadOperation<ShipmentDocuments>;
            query: AggregateQueryOperation<ShipmentDocuments>;
        };
        lookups(dataOrId: string | { data: ShipmentDocumentsInput }): ShipmentDocuments$Lookups;
        getDefaults: GetDefaultsOperation<ShipmentDocuments>;
    }
    export interface ShipmentLogisticalTracking extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        entryType: EntryTypeEnum;
        trackingSequence: integer;
        trackingNumber: string;
        trackingStep: MiscellaneousTable;
        trackingDueDate: string;
        trackingEndDate: string;
        isMandatory: boolean;
        trackingDependency: MiscellaneousTable;
        trackingUser: integer;
        trackingLineComments: string;
        trackingStepStatus: TrackingStepStatus;
    }
    export interface ShipmentLogisticalTrackingInput extends ClientNodeInput {
        id?: string;
        entryType?: EntryTypeEnum;
        trackingSequence?: integer | string;
        trackingNumber?: string;
        trackingStep?: string;
        trackingDueDate?: string;
        trackingEndDate?: string;
        isMandatory?: boolean | string;
        trackingDependency?: string;
        trackingUser?: integer | string;
        trackingLineComments?: string;
        trackingStepStatus?: TrackingStepStatus;
    }
    export interface ShipmentLogisticalTrackingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        entryType: EntryTypeEnum;
        trackingSequence: integer;
        trackingNumber: string;
        trackingStep: MiscellaneousTable;
        trackingDueDate: string;
        trackingEndDate: string;
        isMandatory: boolean;
        trackingDependency: MiscellaneousTable;
        trackingUser: integer;
        trackingLineComments: string;
        trackingStepStatus: TrackingStepStatus;
    }
    export interface ShipmentLogisticalTracking$Lookups {
        trackingStep: QueryOperation<MiscellaneousTable>;
        trackingDependency: QueryOperation<MiscellaneousTable>;
    }
    export interface ShipmentLogisticalTracking$Operations {
        query: QueryOperation<ShipmentLogisticalTracking>;
        read: ReadOperation<ShipmentLogisticalTracking>;
        aggregate: {
            read: AggregateReadOperation<ShipmentLogisticalTracking>;
            query: AggregateQueryOperation<ShipmentLogisticalTracking>;
        };
        lookups(dataOrId: string | { data: ShipmentLogisticalTrackingInput }): ShipmentLogisticalTracking$Lookups;
        getDefaults: GetDefaultsOperation<ShipmentLogisticalTracking>;
    }
    export interface TransportLeadTime extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        placeStart: TransitArea;
        placeArrival: TransitArea;
        transportMode: TransportMode;
        carrier: Carrier;
        releaseTime: integer;
    }
    export interface TransportLeadTimeInput extends ClientNodeInput {
        placeStart?: string;
        placeArrival?: string;
        transportMode?: TransportMode;
        carrier?: string;
        releaseTime?: integer | string;
    }
    export interface TransportLeadTimeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        placeStart: TransitArea;
        placeArrival: TransitArea;
        transportMode: TransportMode;
        carrier: Carrier;
        releaseTime: integer;
    }
    export interface TransportLeadTime$Lookups {
        placeStart: QueryOperation<TransitArea>;
        placeArrival: QueryOperation<TransitArea>;
        carrier: QueryOperation<Carrier>;
    }
    export interface TransportLeadTime$Operations {
        query: QueryOperation<TransportLeadTime>;
        read: ReadOperation<TransportLeadTime>;
        aggregate: {
            read: AggregateReadOperation<TransportLeadTime>;
            query: AggregateQueryOperation<TransportLeadTime>;
        };
        lookups(dataOrId: string | { data: TransportLeadTimeInput }): TransportLeadTime$Lookups;
        getDefaults: GetDefaultsOperation<TransportLeadTime>;
    }
    export interface ProductCategoryExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroups>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocations>;
        overheads: ClientCollection<ProductCategoryOverheads>;
        packingUnits: ClientCollection<ProductCategoryPackingUnits>;
        invoicingTerm: InvoicingTerm;
        taxLevels: ClientCollection<ProductCategoryTaxLevels>;
        costStructure: FreightCostStructure;
        matchingTolerance: MatchingTolerance;
    }
    export interface ProductCategoryInputExtension {
        stockSite?: string;
        code?: string;
        description?: string;
        localizedDescription?: string;
        shortDescription?: string;
        localizedShortDescription?: string;
        isSold?: boolean | string;
        productSequenceNumber?: string;
        creationMethod?: ProductCreationMode;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticUnit?: string;
        euUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        euUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseConversionFactorEntryAllowed?: boolean | string;
        isSalesConversionFactorEntryAllowed?: boolean | string;
        weightUnit?: string;
        stockUnitWeight?: decimal | string;
        volumeUnit?: string;
        stockUnitVolume?: decimal | string;
        labelFormatForStockUnit?: string;
        stockManagementMode?: StockManagement;
        managementMode?: StandardProductCode;
        isNegativeStockAuthorized?: boolean | string;
        lotSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        serialSequenceNumber?: string;
        valuationMethod?: string;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        userAccessCode?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        buyer?: string;
        planner?: string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        salesPriceOrigin?: PriceOrigin;
        percentagePricePurchaseApplied?: decimal | string;
        configuratorProductLine?: string;
        isLocationManaged?: boolean | string;
        salesOrderAllocationRule?: string;
        workOrderAllocationRule?: string;
        shipmentAllocationRule?: string;
        materialConsumptionAllocationRule?: string;
        transferAllocationRule?: string;
        subcontractReplenishmentAllocationRule?: string;
        subcontractConsumptionAllocationRule?: string;
        afterSalesAllocationRule?: string;
        isStatusAAuthorizedInGlobalAllocation?: boolean | string;
        isStatusQAuthorizedInGlobalAllocation?: boolean | string;
        isStatusRAuthorizedInGlobalAllocation?: boolean | string;
        abcClass?: ProductAbcClass;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        shrinkagePercent?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningRequestHorizon?: integer | string;
        planningRequestHorizonTimeUnit?: LeadTimeUnit;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        stockCoverageInWeeks?: integer | string;
        safetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        isReleasedIfShortage?: boolean | string;
        automaticClosingPercentage?: decimal | string;
        salesDeliveryTolerance?: decimal | string;
        salesMinimumQuantity?: decimal | string;
        salesMaximumQuantity?: decimal | string;
        isLoanAuthorized?: boolean | string;
        isBackToBackOrderManaged?: boolean | string;
        directBackToBackOrderQuantity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTool?: boolean | string;
        isDeliverable?: boolean | string;
        isIntermediary?: boolean | string;
        isMaintenance?: boolean | string;
        packagingCapacity?: decimal | string;
        assignmentRules?: string;
        isStockDetailedInPacking?: boolean | string;
        technicalSheet?: string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        afterSalesWarehouse?: string;
        canBeCapitalized?: boolean | string;
        isPackingManaged?: boolean | string;
        sageSalesTax?: string;
        saftProductType?: SafTProductType;
        freightClass?: string;
        freightCommodityCode?: string;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        inventoryProductType?: ProductType;
        containerManagement?: boolean | string;
        statisticalGroups?: Partial<ProductCategoryStatisticalGroupsInput>[];
        costType?: string;
        lotManagementMode?: LotManagementMode;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        materialCostGroup?: MaterialCostGroup;
        reorderingManagementMode?: ReorderingManagementMode;
        stockVersionMode?: StockVersionMode;
        stockManagementRules?: Partial<StockManagementRulesInput>[];
        defaultLocations?: Partial<ProductCategoryDefaultLocationsInput>[];
        overheads?: Partial<ProductCategoryOverheadsInput>[];
        packingUnits?: Partial<ProductCategoryPackingUnitsInput>[];
        invoicingTerm?: string;
        taxLevels?: Partial<ProductCategoryTaxLevelsInput>[];
        costStructure?: string;
        matchingTolerance?: string;
    }
    export interface ProductCategoryBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroupsBinding>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocationsBinding>;
        overheads: ClientCollection<ProductCategoryOverheadsBinding>;
        packingUnits: ClientCollection<ProductCategoryPackingUnitsBinding>;
        invoicingTerm: InvoicingTerm;
        taxLevels: ClientCollection<ProductCategoryTaxLevelsBinding>;
        costStructure: FreightCostStructure;
        matchingTolerance: MatchingTolerance;
    }
    export interface ProductCategoryExtension$Lookups {
        costStructure: QueryOperation<FreightCostStructure>;
        matchingTolerance: QueryOperation<MatchingTolerance>;
    }
    export interface ProductCategoryExtension$Operations {
        lookups(dataOrId: string | { data: ProductCategoryInput }): ProductCategoryExtension$Lookups;
    }
    export interface ProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnits>;
        statisticalGroups: ClientCollection<ProductStatisticalGroups>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
        taxLevels: ClientCollection<ProductTaxLevels>;
        costStructure: FreightCostStructure;
        matchingTolerance: MatchingTolerance;
    }
    export interface ProductInputExtension {
        code?: string;
        company?: string;
        productCategory?: string;
        searchKey?: string;
        description1?: string;
        description2?: string;
        description3?: string;
        localizedDescription1?: string;
        localizedDescription2?: string;
        localizedDescription3?: string;
        managementMode?: StandardProductCode;
        standard?: string;
        upc?: string;
        productStatus?: ProductStatus;
        isPrototype?: boolean | string;
        defaultPotencyInPercentage?: decimal | string;
        defaultPotencyInInternationalUnit?: decimal | string;
        serviceLifeStartDate?: string;
        serviceLifeEndDate?: string;
        storageSheet?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticalUnit?: string;
        eeUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseFactorEntryAllowed?: boolean | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        isSalesFactorEntryAllowed?: boolean | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        eeUnitToStockUnitConversionFactor?: decimal | string;
        weightUnit?: string;
        productWeight?: decimal | string;
        volumeUnit?: string;
        productVolume?: decimal | string;
        lotSequenceNumber?: string;
        serialSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        expirationLeadTime?: integer | string;
        checkLeadTime?: integer | string;
        isNegativeStockAuthorized?: boolean | string;
        costGroup?: string;
        userAccessCode?: string;
        alternateProduct?: string;
        isIntrastatDeclarationSubmitted?: boolean | string;
        intrastatCommodity?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        buyer?: string;
        planner?: string;
        reorderLeadTime?: integer | string;
        purchaseBasePrice?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        exemptionFlag?: string;
        taxFlagStatusLocal?: string;
        configuratorProductLine?: string;
        configuratorNumericField1?: decimal | string;
        configuratorNumericField2?: decimal | string;
        configuratorNumericField3?: decimal | string;
        configuratorNumericField4?: decimal | string;
        configuratorNumericField5?: decimal | string;
        configuratorNumericField6?: decimal | string;
        configuratorAlphaField1?: string;
        configuratorAlphaField2?: string;
        configuratorAlphaField3?: string;
        configuratorAlphaField4?: string;
        configuratorAlphaField5?: string;
        configuratorAlphaField6?: string;
        configurationJournal?: string;
        configuratorBusinessPartner?: string;
        configuratorBusinessPartnerReference?: string;
        configuratorReferenceProduct?: string;
        configuratorPurgeDate?: string;
        isInstalledBaseCreated?: boolean | string;
        voucherCategory?: string;
        tokensToBeCredited?: integer | string;
        creditUnit?: string;
        labelFormatForStockUnit?: string;
        bomCodeForAfterSales?: integer | string;
        productTypeForAfterSales?: TypeOfProduct;
        isAfterSalesProductIssuedByDefault?: boolean | string;
        daysUnit?: string;
        hourUnit?: string;
        minuteUnit?: string;
        productDensity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTools?: boolean | string;
        isDeliverable?: boolean | string;
        isSold?: boolean | string;
        isIntermediary?: boolean | string;
        isCapitalized?: boolean | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        intrastatFederalStateOrRegion?: string;
        plmProductReference?: string;
        plmLinkedDocuments?: string;
        plmProductHistory?: string;
        sageSalesTax?: string;
        allergens?: string;
        allergenChangeDate?: string;
        allergenBomCode?: integer | string;
        saftProductType?: SafTProductType;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        productType?: ProductType;
        globalTradeItemNumber?: string;
        supplierProduct?: Partial<SupplierProductInput>[];
        customerProduct?: Partial<CustomerProductInput>[];
        manufacturingText?: TextStream;
        picture?: BinaryStream;
        purchasingText?: TextStream;
        packingUnits?: Partial<ProductPackingUnitsInput>[];
        statisticalGroups?: Partial<ProductStatisticalGroupsInput>[];
        costType?: string;
        stockManagementMode?: StockManagement;
        lotManagementMode?: LotManagementMode;
        materialCostGroup?: MaterialCostGroup;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        expirationTimeUnit?: ExpirationLeadTimeUnits;
        recontrolTimeUnit?: ExpirationLeadTimeUnits;
        stockVersionMode?: StockVersionMode;
        taxLevels?: Partial<ProductTaxLevelsInput>[];
        costStructure?: string;
        matchingTolerance?: string;
    }
    export interface ProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnitsBinding>;
        statisticalGroups: ClientCollection<ProductStatisticalGroupsBinding>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
        taxLevels: ClientCollection<ProductTaxLevelsBinding>;
        costStructure: FreightCostStructure;
        matchingTolerance: MatchingTolerance;
    }
    export interface ProductExtension$Lookups {
        costStructure: QueryOperation<FreightCostStructure>;
        matchingTolerance: QueryOperation<MatchingTolerance>;
    }
    export interface ProductExtension$Operations {
        lookups(dataOrId: string | { data: ProductInput }): ProductExtension$Lookups;
    }
    export interface ShipToCustomerAddressExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        customer: Customer;
        shipToAddress: CustomerAddress;
        company: Company;
        isActive: boolean;
        shippingSite: Site;
        receiptSite: Site;
        language: Language;
        carrier: Carrier;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        deliveryLeadTime: integer;
        isMondayWorkday: boolean;
        isTuesdayWorkday: boolean;
        isWednesdayWorkday: boolean;
        isThursdayWorkday: boolean;
        isFridayWorkday: boolean;
        isSaturdayWorkday: boolean;
        isSundayWorkday: boolean;
        unavailablePeriod: UnavailablePeriods;
        intrastatIncreaseCoefficient: string;
        europeanUnionVatNumber: string;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: Address;
        geographicCode: string;
        insideCityLimits: string;
        taxExemptionNumber: string;
        exemptionFlag: string;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        entityUse: MiscellaneousTable;
        deliveryHeaderText: TextStream;
        pickingHeaderText: TextStream;
        companyNames: ClientCollection<ShipToCustomerAddressCompanyNames>;
        salesReps: ClientCollection<ShipToCustomerAddressSalesReps>;
        taxRule: TaxRule;
        deliveryMode: DeliveryMode;
    }
    export interface ShipToCustomerAddressInputExtension {
        customer?: string;
        shipToAddress?: string;
        company?: string;
        isActive?: boolean | string;
        shippingSite?: string;
        receiptSite?: string;
        language?: string;
        carrier?: string;
        incoterm?: string;
        intrastatTransportLocation?: CountryLocation;
        deliveryLeadTime?: integer | string;
        isMondayWorkday?: boolean | string;
        isTuesdayWorkday?: boolean | string;
        isWednesdayWorkday?: boolean | string;
        isThursdayWorkday?: boolean | string;
        isFridayWorkday?: boolean | string;
        isSaturdayWorkday?: boolean | string;
        isSundayWorkday?: boolean | string;
        unavailablePeriod?: string;
        intrastatIncreaseCoefficient?: decimal | string;
        europeanUnionVatNumber?: string;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        geographicCode?: string;
        insideCityLimits?: string;
        taxExemptionNumber?: string;
        exemptionFlag?: string;
        mustPrintPickTicket?: boolean | string;
        mustPrintPackingSlip?: boolean | string;
        entityUse?: string;
        deliveryHeaderText?: TextStream;
        pickingHeaderText?: TextStream;
        companyNames?: Partial<ShipToCustomerAddressCompanyNamesInput>[];
        salesReps?: Partial<ShipToCustomerAddressSalesRepsInput>[];
        taxRule?: string;
        deliveryMode?: string;
    }
    export interface ShipToCustomerAddressBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        customer: Customer;
        shipToAddress: CustomerAddress;
        company: Company;
        isActive: boolean;
        shippingSite: Site;
        receiptSite: Site;
        language: Language;
        carrier: Carrier;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        deliveryLeadTime: integer;
        isMondayWorkday: boolean;
        isTuesdayWorkday: boolean;
        isWednesdayWorkday: boolean;
        isThursdayWorkday: boolean;
        isFridayWorkday: boolean;
        isSaturdayWorkday: boolean;
        isSundayWorkday: boolean;
        unavailablePeriod: UnavailablePeriods;
        intrastatIncreaseCoefficient: string;
        europeanUnionVatNumber: string;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: Address;
        geographicCode: string;
        insideCityLimits: string;
        taxExemptionNumber: string;
        exemptionFlag: string;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        entityUse: MiscellaneousTable;
        deliveryHeaderText: TextStream;
        pickingHeaderText: TextStream;
        companyNames: ClientCollection<ShipToCustomerAddressCompanyNamesBinding>;
        salesReps: ClientCollection<ShipToCustomerAddressSalesRepsBinding>;
        taxRule: TaxRule;
        deliveryMode: DeliveryMode;
    }
    export interface ShipToCustomerAddressExtension$Lookups {
        deliveryMode: QueryOperation<DeliveryMode>;
    }
    export interface ShipToCustomerAddressExtension$Operations {
        lookups(dataOrId: string | { data: ShipToCustomerAddressInput }): ShipToCustomerAddressExtension$Lookups;
    }
    export interface SupplierExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        category: SupplierCategory;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        groupSupplier: Supplier;
        riskSupplier: Supplier;
        ourCustomerNumberForSupplier: string;
        carrier: Carrier;
        defaultContact: SupplierContact;
        location: string;
        supplierABCClass: ProductAbcClass;
        rateType: ExchangeRateType;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        addressByDefault: SupplierAddress;
        isMultiLineOrder: boolean;
        leadTimeRankingCoefficient: string;
        priceRankingCoefficient: string;
        qualityRankingCoefficient: string;
        quantityRankingCoefficient: string;
        freeRankingCoefficient: string;
        leadTimeRanking: string;
        priceRanking: string;
        qualityRanking: string;
        quantityRanking: string;
        freeRanking: string;
        totalRanking: string;
        creditControl: WorkInProgressControl;
        intrastatIncreaseCoefficient: string;
        mustRemindDelivery: boolean;
        mustRemindAcknowledgment: boolean;
        isDas2Submitted: boolean;
        isActive: boolean;
        isPaymentHeld: boolean;
        mustPrintOrderForm: boolean;
        mustPrintReceiptNote: boolean;
        mustPrintReturnSlip: boolean;
        ourCustomerNameForSupplier: string;
        is281Submitted: boolean;
        amountType: PriceAmountTaxTax;
        isCashVat: boolean;
        cashVatDeadline: string;
        selfBillingCode: string;
        rexNumber: string;
        hasNoWhiteListVerification: boolean;
        isElectronicInvoicingAllowed: boolean;
        contact: SupplierContact;
        startDateForElectronicInvoice: string;
        addresses: ClientCollection<SupplierAddress>;
        contacts: ClientCollection<SupplierContact>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        purchaseOrderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        returnOrderText: TextStream;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        taxRule: TaxRule;
        supplierType: SupplierType;
        dueDateOrigin: DueDateCalculationBase;
        currencyRateDetermination: CurrencyRateSearchDate;
        disputeStatus: Conflict;
    }
    export interface SupplierInputExtension {
        code?: string;
        category?: string;
        payToBusinessPartner?: string;
        payToBusinessPartnerAddress?: string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        groupSupplier?: string;
        riskSupplier?: string;
        ourCustomerNumberForSupplier?: string;
        carrier?: string;
        defaultContact?: string;
        location?: string;
        supplierABCClass?: ProductAbcClass;
        rateType?: ExchangeRateType;
        incoterm?: string;
        intrastatTransportLocation?: CountryLocation;
        addressByDefault?: string;
        isMultiLineOrder?: boolean | string;
        leadTimeRankingCoefficient?: decimal | string;
        priceRankingCoefficient?: decimal | string;
        qualityRankingCoefficient?: decimal | string;
        quantityRankingCoefficient?: decimal | string;
        freeRankingCoefficient?: decimal | string;
        leadTimeRanking?: decimal | string;
        priceRanking?: decimal | string;
        qualityRanking?: decimal | string;
        quantityRanking?: decimal | string;
        freeRanking?: decimal | string;
        totalRanking?: decimal | string;
        creditControl?: WorkInProgressControl;
        intrastatIncreaseCoefficient?: decimal | string;
        mustRemindDelivery?: boolean | string;
        mustRemindAcknowledgment?: boolean | string;
        isDas2Submitted?: boolean | string;
        isActive?: boolean | string;
        isPaymentHeld?: boolean | string;
        mustPrintOrderForm?: boolean | string;
        mustPrintReceiptNote?: boolean | string;
        mustPrintReturnSlip?: boolean | string;
        ourCustomerNameForSupplier?: string;
        is281Submitted?: boolean | string;
        amountType?: PriceAmountTaxTax;
        isCashVat?: boolean | string;
        cashVatDeadline?: string;
        selfBillingCode?: string;
        rexNumber?: string;
        hasNoWhiteListVerification?: boolean | string;
        isElectronicInvoicingAllowed?: boolean | string;
        contact?: string;
        startDateForElectronicInvoice?: string;
        addresses?: Partial<SupplierAddressInput>[];
        contacts?: Partial<SupplierContactInput>[];
        acronym?: string;
        businessPartnerSite?: string;
        cfonbPaymentMethod?: string;
        companyName1?: string;
        companyName2?: string;
        companyNames?: Partial<BusinessPartnerCompanyNamesInput>[];
        consolidationCode?: string;
        consolidationGroup?: string;
        consolidationPartner?: string;
        country?: string;
        customerOrSupplierOriginCategory?: string;
        documentType?: DocumentType;
        economicOperatorRegistrationAndIdNumber?: string;
        europeanUnionVatNumber?: string;
        fiscalCode?: string;
        isCashExcluded?: boolean | string;
        isIntersite?: boolean | string;
        isMailingProhibited?: boolean | string;
        isPhysicalPerson?: boolean | string;
        isPublicSector?: boolean | string;
        isServiceCaller?: boolean | string;
        isServiceSupplier?: boolean | string;
        italianTaxNumber?: string;
        language?: string;
        nonResidentAccount?: string;
        purchaseOrderText?: TextStream;
        registrationNumber?: string;
        relatedCompany?: RelatedCompanySettings;
        reportAccessCode?: string;
        returnOrderText?: TextStream;
        shortCompanyName?: string;
        siteIdentificationNumber?: string;
        standardIndustrialClassificationCode?: string;
        vatNumber?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        taxRule?: string;
        supplierType?: SupplierType;
        dueDateOrigin?: DueDateCalculationBase;
        currencyRateDetermination?: CurrencyRateSearchDate;
        disputeStatus?: Conflict;
    }
    export interface SupplierBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: BusinessPartner;
        category: SupplierCategory;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        groupSupplier: Supplier;
        riskSupplier: Supplier;
        ourCustomerNumberForSupplier: string;
        carrier: Carrier;
        defaultContact: SupplierContact;
        location: string;
        supplierABCClass: ProductAbcClass;
        rateType: ExchangeRateType;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        addressByDefault: SupplierAddress;
        isMultiLineOrder: boolean;
        leadTimeRankingCoefficient: string;
        priceRankingCoefficient: string;
        qualityRankingCoefficient: string;
        quantityRankingCoefficient: string;
        freeRankingCoefficient: string;
        leadTimeRanking: string;
        priceRanking: string;
        qualityRanking: string;
        quantityRanking: string;
        freeRanking: string;
        totalRanking: string;
        creditControl: WorkInProgressControl;
        intrastatIncreaseCoefficient: string;
        mustRemindDelivery: boolean;
        mustRemindAcknowledgment: boolean;
        isDas2Submitted: boolean;
        isActive: boolean;
        isPaymentHeld: boolean;
        mustPrintOrderForm: boolean;
        mustPrintReceiptNote: boolean;
        mustPrintReturnSlip: boolean;
        ourCustomerNameForSupplier: string;
        is281Submitted: boolean;
        amountType: PriceAmountTaxTax;
        isCashVat: boolean;
        cashVatDeadline: string;
        selfBillingCode: string;
        rexNumber: string;
        hasNoWhiteListVerification: boolean;
        isElectronicInvoicingAllowed: boolean;
        contact: SupplierContact;
        startDateForElectronicInvoice: string;
        addresses: ClientCollection<SupplierAddress>;
        contacts: ClientCollection<SupplierContact>;
        acronym: string;
        businessPartnerSite: Site;
        cfonbPaymentMethod: MiscellaneousTable;
        companyName1: string;
        companyName2: string;
        companyNames: ClientCollection<BusinessPartnerCompanyNames>;
        consolidationCode: string;
        consolidationGroup: SiteGroupings;
        consolidationPartner: BusinessPartner;
        country: Country;
        customerOrSupplierOriginCategory: string;
        documentType: DocumentType;
        economicOperatorRegistrationAndIdNumber: string;
        europeanUnionVatNumber: string;
        fiscalCode: string;
        isCashExcluded: boolean;
        isIntersite: boolean;
        isMailingProhibited: boolean;
        isPhysicalPerson: boolean;
        isPublicSector: boolean;
        isServiceCaller: boolean;
        isServiceSupplier: boolean;
        italianTaxNumber: string;
        language: Language;
        nonResidentAccount: BusinessPartnerAddress;
        purchaseOrderText: TextStream;
        registrationNumber: string;
        relatedCompany: RelatedCompanySettings;
        reportAccessCode: Access;
        returnOrderText: TextStream;
        shortCompanyName: string;
        siteIdentificationNumber: string;
        standardIndustrialClassificationCode: string;
        vatNumber: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        taxRule: TaxRule;
        supplierType: SupplierType;
        dueDateOrigin: DueDateCalculationBase;
        currencyRateDetermination: CurrencyRateSearchDate;
        disputeStatus: Conflict;
    }
    export interface SupplierInvoiceHeaderExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        sourceModule: ModuleTable;
        billBySupplier: Supplier;
        control: string;
        company: Company;
        site: Site;
        accountingDate: string;
        internalNumber: integer;
        internalReference: string;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        isDAS2Submitted: boolean;
        payToBusinessPartner: BusinessPartner;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        isEuropeanUnionInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: PurchasingInvoiceStatus;
        paymentApproval: PaymentApprovalType;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billBySupplierAddress: SupplierAddress;
        billBySupplierPostalCode: string;
        billBySupplierCity: string;
        billBySupplierState: string;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerState: string;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        incoterm: Incoterm;
        incotermTown: string;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        unblockUser: User;
        unblockDate: string;
        unblockAmount: string;
        matchStatus: MatchStatusEnum;
        earlyDiscountOrLateChargeBasis: string;
        priceOrAmountType: PriceAmountTaxTax;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        derCode: string;
        versionControlSystemNumber: string;
        priceOrAmountTaxType: PriceAmountTaxTax;
        recurringNumber: string;
        importTaxAmountNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        inPaymentSlipWithReferenceLine: string;
        bankId: string;
        project: ProjectLink;
        numberOfInvoiceCopies: integer;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        comments: ClientCollection<SupplierInvoiceHeaderComments>;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxes>;
        invoiceType: PurchaseInvoiceType;
    }
    export interface SupplierInvoiceHeaderInputExtension {
        id?: string;
        category?: InvoiceType;
        purchaseInvoiceCategory?: PurchaseInvoiceCategory;
        sourceModule?: ModuleTable;
        billBySupplier?: string;
        control?: string;
        company?: string;
        site?: string;
        accountingDate?: string;
        internalNumber?: integer | string;
        internalReference?: string;
        sourceDocumentDate?: string;
        sourceDocument?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        rateDate?: string;
        isDAS2Submitted?: boolean | string;
        payToBusinessPartner?: string;
        dueDateCalculationStartDate?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        earlyDiscountOrLateChargeRate?: decimal | string;
        taxRule?: string;
        isEuropeanUnionInvoice?: boolean | string;
        intrastatProcessingNumber?: integer | string;
        status?: PurchasingInvoiceStatus;
        paymentApproval?: PaymentApprovalType;
        originalInvoiceNumber?: string;
        debitOrCredit?: integer | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        taxReferenceDate?: string;
        numberOfTaxes?: integer | string;
        billBySupplierAddress?: string;
        billBySupplierPostalCode?: string;
        billBySupplierCity?: string;
        billBySupplierState?: string;
        billBySupplierCountry?: string;
        billBySupplierCountryName?: string;
        payToBusinessPartnerAddress?: string;
        payToBusinessPartnerPostalCode?: string;
        payToBusinessPartnerCity?: string;
        payToBusinessPartnerState?: string;
        payToBusinessPartnerCountry?: string;
        payToBusinessPartnerCountryName?: string;
        incoterm?: string;
        incotermTown?: string;
        intrastatTransportLocation?: CountryLocation;
        europeanUnionIdentification?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        fiscalYear?: integer | string;
        period?: integer | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        lastServiceAccountedDate?: string;
        unblockUser?: string;
        unblockDate?: string;
        unblockAmount?: decimal | string;
        matchStatus?: MatchStatusEnum;
        earlyDiscountOrLateChargeBasis?: decimal | string;
        priceOrAmountType?: PriceAmountTaxTax;
        singleCustomsDocumentDate?: string;
        singleCustomsDocumentReference?: string;
        singleCustomsDocumentBusinessPartnerCode?: string;
        derCode?: string;
        versionControlSystemNumber?: string;
        priceOrAmountTaxType?: PriceAmountTaxTax;
        recurringNumber?: string;
        importTaxAmountNumber?: string;
        recurringInvoicingDate?: string;
        numberOfCompanies?: integer | string;
        cashVatTaxRule?: boolean | string;
        field40Reason?: string;
        field41Reason?: string;
        originalDocumentNumber?: string;
        inPaymentSlipWithReferenceLine?: string;
        bankId?: string;
        project?: string;
        numberOfInvoiceCopies?: integer | string;
        billBySupplierAddressLines?: Partial<SupplierInvoiceHeaderBillBySupplierAddressLinesInput>[];
        billBySupplierCompanyNames?: Partial<SupplierInvoiceHeaderBillBySupplierCompanyNamesInput>[];
        comments?: Partial<SupplierInvoiceHeaderCommentsInput>[];
        payToBusinessPartnerAddressLines?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput>[];
        payToBusinessPartnerCompanyNames?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput>[];
        taxes?: Partial<SupplierInvoiceHeaderTaxesInput>[];
        invoiceType?: string;
    }
    export interface SupplierInvoiceHeaderBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        sourceModule: ModuleTable;
        billBySupplier: Supplier;
        control: string;
        company: Company;
        site: Site;
        accountingDate: string;
        internalNumber: integer;
        internalReference: string;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        isDAS2Submitted: boolean;
        payToBusinessPartner: BusinessPartner;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        isEuropeanUnionInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: PurchasingInvoiceStatus;
        paymentApproval: PaymentApprovalType;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billBySupplierAddress: SupplierAddress;
        billBySupplierPostalCode: string;
        billBySupplierCity: string;
        billBySupplierState: string;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerState: string;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        incoterm: Incoterm;
        incotermTown: string;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        unblockUser: User;
        unblockDate: string;
        unblockAmount: string;
        matchStatus: MatchStatusEnum;
        earlyDiscountOrLateChargeBasis: string;
        priceOrAmountType: PriceAmountTaxTax;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        derCode: string;
        versionControlSystemNumber: string;
        priceOrAmountTaxType: PriceAmountTaxTax;
        recurringNumber: string;
        importTaxAmountNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        inPaymentSlipWithReferenceLine: string;
        bankId: string;
        project: ProjectLink;
        numberOfInvoiceCopies: integer;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLinesBinding>;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNamesBinding>;
        comments: ClientCollection<SupplierInvoiceHeaderCommentsBinding>;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesBinding>;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesBinding>;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxesBinding>;
        invoiceType: PurchaseInvoiceType;
    }
    export interface SupplierInvoiceHeaderExtension$Lookups {
        invoiceType: QueryOperation<PurchaseInvoiceType>;
    }
    export interface SupplierInvoiceHeaderExtension$Operations {
        lookups(dataOrId: string | { data: SupplierInvoiceHeaderInput }): SupplierInvoiceHeaderExtension$Lookups;
    }
    export interface SupplierProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        supplier: BusinessPartner;
        priority: integer;
        supplierProduct: string;
        supplierProductDescription: string;
        supplierUpc: string;
        purchaseUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        packingUnit: UnitOfMeasure;
        packingUnitToPurchaseUnitConversionFactor: string;
        euStatisticsIncrease: string;
        minimumPurchaseQuantity: string;
        landingCostCoefficient: string;
        fixedCostPerUnit: string;
        qualityRank: integer;
        qualityControlManagementMode: SubjectToControl;
        isBackToBackOrder: boolean;
        configurationJournal: string;
        subcontractLeadTime: integer;
        qualityControlFrequency: integer;
        qualityControlNumberEntries: integer;
        qualityProcessIdFrequency: integer;
        qualityProcessIdEntries: integer;
        isVersionPreloaded: boolean;
        text1004082: boolean;
        text1004085: boolean;
        purchasingText: TextStream;
        costStructure: FreightCostStructure;
        blockingManagementMode: Conflict;
        matchingTolerance: MatchingTolerance;
    }
    export interface SupplierProductInputExtension {
        product?: string;
        supplier?: string;
        priority?: integer | string;
        supplierProduct?: string;
        supplierProductDescription?: string;
        supplierUpc?: string;
        purchaseUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        packingUnit?: string;
        packingUnitToPurchaseUnitConversionFactor?: decimal | string;
        euStatisticsIncrease?: decimal | string;
        minimumPurchaseQuantity?: decimal | string;
        landingCostCoefficient?: decimal | string;
        fixedCostPerUnit?: decimal | string;
        qualityRank?: integer | string;
        qualityControlManagementMode?: SubjectToControl;
        isBackToBackOrder?: boolean | string;
        configurationJournal?: string;
        subcontractLeadTime?: integer | string;
        qualityControlFrequency?: integer | string;
        qualityControlNumberEntries?: integer | string;
        qualityProcessIdFrequency?: integer | string;
        qualityProcessIdEntries?: integer | string;
        isVersionPreloaded?: boolean | string;
        text1004082?: boolean | string;
        text1004085?: boolean | string;
        purchasingText?: TextStream;
        costStructure?: string;
        blockingManagementMode?: Conflict;
        matchingTolerance?: string;
    }
    export interface SupplierProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        supplier: BusinessPartner;
        priority: integer;
        supplierProduct: string;
        supplierProductDescription: string;
        supplierUpc: string;
        purchaseUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        packingUnit: UnitOfMeasure;
        packingUnitToPurchaseUnitConversionFactor: string;
        euStatisticsIncrease: string;
        minimumPurchaseQuantity: string;
        landingCostCoefficient: string;
        fixedCostPerUnit: string;
        qualityRank: integer;
        qualityControlManagementMode: SubjectToControl;
        isBackToBackOrder: boolean;
        configurationJournal: string;
        subcontractLeadTime: integer;
        qualityControlFrequency: integer;
        qualityControlNumberEntries: integer;
        qualityProcessIdFrequency: integer;
        qualityProcessIdEntries: integer;
        isVersionPreloaded: boolean;
        text1004082: boolean;
        text1004085: boolean;
        purchasingText: TextStream;
        costStructure: FreightCostStructure;
        blockingManagementMode: Conflict;
        matchingTolerance: MatchingTolerance;
    }
    export interface SupplierProductExtension$Lookups {
        costStructure: QueryOperation<FreightCostStructure>;
        matchingTolerance: QueryOperation<MatchingTolerance>;
    }
    export interface SupplierProductExtension$Operations {
        lookups(dataOrId: string | { data: SupplierProductInput }): SupplierProductExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-purchasing-data/DeliveryMode': DeliveryMode$Operations;
        '@sage/x3-purchasing-data/FreightContainer': FreightContainer$Operations;
        '@sage/x3-purchasing-data/FreightCostStructure': FreightCostStructure$Operations;
        '@sage/x3-purchasing-data/MatchingTolerance': MatchingTolerance$Operations;
        '@sage/x3-purchasing-data/PurchaseInvoiceType': PurchaseInvoiceType$Operations;
        '@sage/x3-purchasing-data/PurchasePriceReason': PurchasePriceReason$Operations;
        '@sage/x3-purchasing-data/ShipmentDocuments': ShipmentDocuments$Operations;
        '@sage/x3-purchasing-data/ShipmentLogisticalTracking': ShipmentLogisticalTracking$Operations;
        '@sage/x3-purchasing-data/TransportLeadTime': TransportLeadTime$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3InvoicingData$Package,
            SageX3MasterData$Package,
            SageX3ProjectManagementData$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-purchasing-data-api' {
    export type * from '@sage/x3-purchasing-data-api-partial';
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type {
        ProductBindingExtension,
        ProductCategoryBindingExtension,
        ProductCategoryExtension,
        ProductCategoryExtension$Lookups,
        ProductCategoryExtension$Operations,
        ProductCategoryInputExtension,
        ProductExtension,
        ProductExtension$Lookups,
        ProductExtension$Operations,
        ProductInputExtension,
        ShipToCustomerAddressBindingExtension,
        ShipToCustomerAddressExtension,
        ShipToCustomerAddressExtension$Lookups,
        ShipToCustomerAddressExtension$Operations,
        ShipToCustomerAddressInputExtension,
        SupplierBindingExtension,
        SupplierExtension,
        SupplierInputExtension,
        SupplierProductBindingExtension,
        SupplierProductExtension,
        SupplierProductExtension$Lookups,
        SupplierProductExtension$Operations,
        SupplierProductInputExtension,
    } from '@sage/x3-purchasing-data-api';
    export interface ProductCategory extends ProductCategoryExtension {}
    export interface ProductCategoryBinding extends ProductCategoryBindingExtension {}
    export interface ProductCategoryInput extends ProductCategoryInputExtension {}
    export interface ProductCategory$Lookups extends ProductCategoryExtension$Lookups {}
    export interface ProductCategory$Operations extends ProductCategoryExtension$Operations {}
    export interface Product extends ProductExtension {}
    export interface ProductBinding extends ProductBindingExtension {}
    export interface ProductInput extends ProductInputExtension {}
    export interface Product$Lookups extends ProductExtension$Lookups {}
    export interface Product$Operations extends ProductExtension$Operations {}
    export interface ShipToCustomerAddress extends ShipToCustomerAddressExtension {}
    export interface ShipToCustomerAddressBinding extends ShipToCustomerAddressBindingExtension {}
    export interface ShipToCustomerAddressInput extends ShipToCustomerAddressInputExtension {}
    export interface ShipToCustomerAddress$Lookups extends ShipToCustomerAddressExtension$Lookups {}
    export interface ShipToCustomerAddress$Operations extends ShipToCustomerAddressExtension$Operations {}
    export interface Supplier extends SupplierExtension {}
    export interface SupplierBinding extends SupplierBindingExtension {}
    export interface SupplierInput extends SupplierInputExtension {}
    export interface SupplierProduct extends SupplierProductExtension {}
    export interface SupplierProductBinding extends SupplierProductBindingExtension {}
    export interface SupplierProductInput extends SupplierProductInputExtension {}
    export interface SupplierProduct$Lookups extends SupplierProductExtension$Lookups {}
    export interface SupplierProduct$Operations extends SupplierProductExtension$Operations {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type {
        SupplierInvoiceHeaderBindingExtension,
        SupplierInvoiceHeaderExtension,
        SupplierInvoiceHeaderExtension$Lookups,
        SupplierInvoiceHeaderExtension$Operations,
        SupplierInvoiceHeaderInputExtension,
    } from '@sage/x3-purchasing-data-api';
    export interface SupplierInvoiceHeader extends SupplierInvoiceHeaderExtension {}
    export interface SupplierInvoiceHeaderBinding extends SupplierInvoiceHeaderBindingExtension {}
    export interface SupplierInvoiceHeaderInput extends SupplierInvoiceHeaderInputExtension {}
    export interface SupplierInvoiceHeader$Lookups extends SupplierInvoiceHeaderExtension$Lookups {}
    export interface SupplierInvoiceHeader$Operations extends SupplierInvoiceHeaderExtension$Operations {}
}
