"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeEntryLine = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        employee: {
            employee: 'employee',
        },
        taskLink: {
            id: 'taskLink',
        },
        budgetLink: {
            id: 'budgetLink',
        },
        project: {
            id: 'project',
        },
        task: {
            project: 'project',
            code: 'task',
        },
        operation: {
            project: 'project',
            task: 'task',
            number: 'operation',
            firstOperationSplit: 'firstOperationSplit',
        },
        assignmentLine: {
            project: 'project',
            task: 'task',
            operation: 'operation',
            firstOperationSplit: 'firstOperationSplit',
            lineNumber: 'assignmentLine',
        },
        budget: {
            project: 'project',
            code: 'budget',
        },
        financialSite: {
            code: 'financialSite',
        },
        currency: {
            code: 'currency',
        },
        projectCostType: {
            code: 'projectCostType',
        },
        employeeCostType: {
            code: 'employeeCostType',
        },
        unit: {
            code: 'unit',
        },
        timeCategory: {
            code: 'timeCategory',
        },
        validatedBy: {
            code: 'validatedBy',
        },
        controlledBy: {
            code: 'controlledBy',
        },
        approvedBy: {
            code: 'approvedBy',
        },
        entryType: {
            code: 'entryType',
            async legislation() {
                return (await (await (await this.financialSite)?.legalCompany)?.legislation)?.code;
            },
        },
        rejectedBy: {
            code: 'rejectedBy',
        },
        journal: {
            code: 'journal',
            async legislation() {
                return (await (await (await this.financialSite)?.legalCompany)?.legislation)?.code;
            },
        },
        postedBy: {
            code: 'postedBy',
        },
        longDescriptionRef: {
            code() {
                return 'PJMTIMEMP';
            },
            identifier1() {
                return 'PTEDESTEX';
            },
            async identifier2() {
                return typesLib.add(typesLib.add((await this.employee), '~'), (await this.lineNumber));
            },
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
        longCommentRef: {
            code() {
                return 'PJMTIMEMP';
            },
            identifier1() {
                return 'PTECOMTEX';
            },
            async identifier2() {
                return typesLib.add(typesLib.add((await this.employee), '~'), (await this.lineNumber));
            },
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'PJMTIMEMP';
            },
            columnName() {
                return 'PTEDESAXX';
            },
            key1: ['employee', 'lineNumber'],
        },
    },
};
const compositeReferences = {
    longCommentRef: {
        longComment: 'text',
    },
    longDescriptionRef: {
        longDescription: 'text',
    },
};
let TimeEntryLine = class TimeEntryLine extends xtrem_core_1.Node {
    static computeProjectEmployeeCostType(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'TimeEntryLine', 'computeProjectEmployeeCostType', parameters);
    }
    static computeProjectEmployeeLaborRate(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'TimeEntryLine', 'computeProjectEmployeeLaborRate', parameters);
    }
    static computeUnitOfMeasure(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'TimeEntryLine', 'computeUnitOfMeasure', parameters);
    }
};
exports.TimeEntryLine = TimeEntryLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLB',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
    })
], TimeEntryLine.prototype, "employee", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTESEQ',
    })
], TimeEntryLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTEDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], TimeEntryLine.prototype, "date", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIMTASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], TimeEntryLine.prototype, "taskLink", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIMPBUCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], TimeEntryLine.prototype, "budgetLink", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], TimeEntryLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
    })
], TimeEntryLine.prototype, "task", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPENUM',
        columnType: 'integer',
        node: () => sageX3ProjectManagement.nodes.Operation,
    })
], TimeEntryLine.prototype, "operation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESPLNUM',
    })
], TimeEntryLine.prototype, "firstOperationSplit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POANUM',
        columnType: 'integer',
        node: () => sageX3ProjectManagement.nodes.OperationAssignment,
    })
], TimeEntryLine.prototype, "assignmentLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Budget,
    })
], TimeEntryLine.prototype, "budget", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], TimeEntryLine.prototype, "financialSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], TimeEntryLine.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHGTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], TimeEntryLine.prototype, "rateType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJMPCC',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.CostType,
    })
], TimeEntryLine.prototype, "projectCostType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLBPCC',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.CostType,
    })
], TimeEntryLine.prototype, "employeeCostType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJMCST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TimeEntryLine.prototype, "projectLaborRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLBCST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TimeEntryLine.prototype, "employeeLaborRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTEQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TimeEntryLine.prototype, "timeSpent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTEUOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], TimeEntryLine.prototype, "unit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTETYP',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TimeCategory,
    })
], TimeEntryLine.prototype, "timeCategory", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTETYPRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TimeEntryLine.prototype, "rateMultiplier", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PTEDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], TimeEntryLine.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTEVAL',
    })
], TimeEntryLine.prototype, "isValidated", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTESTA',
        dataType: () => sageX3ProjectManagementData.enums.timeEntryStatusDatatype,
    })
], TimeEntryLine.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTEORI',
        dataType: () => sageX3ProjectManagementData.enums.timeEntryOriginDatatype,
    })
], TimeEntryLine.prototype, "origin", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VALUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], TimeEntryLine.prototype, "validatedBy", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CTRLUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], TimeEntryLine.prototype, "controlledBy", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'APPRUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], TimeEntryLine.prototype, "approvedBy", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GTE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.EntryType,
    })
], TimeEntryLine.prototype, "entryType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REJUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], TimeEntryLine.prototype, "rejectedBy", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'JOU',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Journal,
    })
], TimeEntryLine.prototype, "journal", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POSTUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], TimeEntryLine.prototype, "postedBy", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'JOUNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], TimeEntryLine.prototype, "journalNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BILLABLE',
    })
], TimeEntryLine.prototype, "isBillable", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BILFRO',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], TimeEntryLine.prototype, "billableFrom", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BILQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TimeEntryLine.prototype, "billedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMTIMEMP',
                identifier1: 'PTEDESTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'PJMTIMEMP',
                identifier1: 'PTEDESTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], TimeEntryLine.prototype, "longDescriptionRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMTIMEMP',
                identifier1: 'PTECOMTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'PJMTIMEMP',
                identifier1: 'PTECOMTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], TimeEntryLine.prototype, "longCommentRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], TimeEntryLine.prototype, "longComment", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], TimeEntryLine.prototype, "longDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isNullable: true,
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
        computeValue() {
            return sageX3ProjectManagement.functions.getConnectedEmployee(this);
        },
    })
], TimeEntryLine.prototype, "connectedEmployee", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isNullable: true,
        node: () => sageX3ProjectManagement.nodes.TimeCategory,
        computeValue() {
            return sageX3ProjectManagement.functions.getDefaultTimeCategory(this);
        },
        dependsOn: ['connectedEmployee'],
    })
], TimeEntryLine.prototype, "defaultTimeCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isNullable: true,
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
        computeValue() {
            return sageX3ProjectManagement.functions.getDefaultUnit(this);
        },
        dependsOn: ['connectedEmployee'],
    })
], TimeEntryLine.prototype, "defaultUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageX3ProjectManagement.functions.getIsNegativeTimeSpentAllowed(this);
        },
        dependsOn: ['connectedEmployee'],
    })
], TimeEntryLine.prototype, "isNegativeTimeSpentAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageX3ProjectManagement.functions.getIsTimeEntryAdministrator(this);
        },
        dependsOn: ['connectedEmployee'],
    })
], TimeEntryLine.prototype, "isTimeEntryAdministrator", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageX3ProjectManagement.functions.getIsTimeEntryEmployee(this);
        },
        dependsOn: ['connectedEmployee'],
    })
], TimeEntryLine.prototype, "isTimeEntryEmployee", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageX3ProjectManagement.functions.getIsValidatedDefault(this);
        },
    })
], TimeEntryLine.prototype, "isValidatedDefault", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3ProjectManagement.nodes.TimeEntryLineCurrencyRates,
    })
], TimeEntryLine.prototype, "currencyRates", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3ProjectManagement.nodes.TimeEntryLineDimensions,
    })
], TimeEntryLine.prototype, "dimensions", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ComputeProjectEmployeeCostType */
        isPublished: true,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    project: {
                        isMandatory: true,
                        type: 'string',
                    },
                    task: {
                        isMandatory: true,
                        type: 'string',
                    },
                    operation: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    employee: {
                        isMandatory: true,
                        type: 'string',
                    },
                    timeCategory: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                employeeCostType: {
                    isMandatory: true,
                    type: 'string',
                },
                projectCostType: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], TimeEntryLine, "computeProjectEmployeeCostType", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ComputeProjectEmployeeLaborRate */
        isPublished: true,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    employee: {
                        isMandatory: true,
                        type: 'string',
                    },
                    date: {
                        isMandatory: true,
                        type: 'date',
                    },
                    unit: {
                        isMandatory: true,
                        type: 'string',
                    },
                    currency: {
                        isMandatory: true,
                        type: 'string',
                    },
                    rateType: {
                        isMandatory: true,
                        type: 'enum',
                        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
                    },
                    projectCostType: {
                        isMandatory: true,
                        type: 'string',
                    },
                    employeeCostType: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                projectLaborRate: {
                    isMandatory: true,
                    type: 'decimal',
                },
                employeeLaborRate: {
                    isMandatory: true,
                    type: 'decimal',
                },
                message: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], TimeEntryLine, "computeProjectEmployeeLaborRate", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ComputeUnitOfMeasure */
        isPublished: true,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    project: {
                        isMandatory: true,
                        type: 'string',
                    },
                    task: {
                        isMandatory: true,
                        type: 'string',
                    },
                    operation: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    employee: {
                        isMandatory: true,
                        type: 'string',
                    },
                    timeCategory: {
                        isMandatory: true,
                        type: 'string',
                    },
                    costType: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                unit: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], TimeEntryLine, "computeUnitOfMeasure", null);
exports.TimeEntryLine = TimeEntryLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMTIMEMP',
        keyPropertyNames: ['employee', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    employee: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
        canUpdate: true,
        canDelete: true,
        canDeleteMany: true,
    })
], TimeEntryLine);
//# sourceMappingURL=time-entry-line.js.map