"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeEntryLineCurrencyRates = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'LED'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            employee: 'employee',
            lineNumber: 'lineNumber',
        },
        chartOfAccounts: {
            code: 'chartOfAccounts',
        },
        account: {
            chartOfAccounts: 'chartOfAccounts',
            code: 'account',
        },
        ledgerCurrency: {
            code: 'ledgerCurrency',
        },
    },
};
let TimeEntryLineCurrencyRates = class TimeEntryLineCurrencyRates extends xtrem_core_1.Node {
};
exports.TimeEntryLineCurrencyRates = TimeEntryLineCurrencyRates;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], TimeEntryLineCurrencyRates.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CLB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], TimeEntryLineCurrencyRates.prototype, "employee", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTESEQ',
    })
], TimeEntryLineCurrencyRates.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TimeEntryLine,
    })
], TimeEntryLineCurrencyRates.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COA',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.ChartOfAccounts,
    })
], TimeEntryLineCurrencyRates.prototype, "chartOfAccounts", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACC',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Account,
    })
], TimeEntryLineCurrencyRates.prototype, "account", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATMLT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TimeEntryLineCurrencyRates.prototype, "multiplyingRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATDIV',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TimeEntryLineCurrencyRates.prototype, "dividingRate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LEDTYP',
        dataType: () => sageX3MasterData.enums.generalLedgerTypesDatatype,
    })
], TimeEntryLineCurrencyRates.prototype, "ledgerType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CURLED',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], TimeEntryLineCurrencyRates.prototype, "ledgerCurrency", void 0);
exports.TimeEntryLineCurrencyRates = TimeEntryLineCurrencyRates = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMTIMEMP',
        keyPropertyNames: ['denormalizedIndex', 'employee', 'lineNumber'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], TimeEntryLineCurrencyRates);
//# sourceMappingURL=time-entry-line-currency-rates.js.map