import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class Task extends Node {
    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
    readonly code: Promise<string>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly parent: Reference<sageX3ProjectManagement.nodes.Task | null>;
    readonly sortKey: Promise<integer | null>;
    readonly taskType: Promise<sageX3ProjectManagementData.enums.OpeProvTask | null>;
    readonly startDate: Promise<date | null>;
    readonly endDate: Promise<date | null>;
    readonly duration: Promise<integer | null>;
    readonly launchingDate: Promise<date | null>;
    readonly planningDate: Promise<date | null>;
    readonly beginningDate: Promise<date | null>;
    readonly closingDate: Promise<date | null>;
    readonly suspensionDate: Promise<date | null>;
    readonly isToLaunch: Promise<boolean>;
    readonly status: Promise<sageX3ProjectManagementData.enums.ProjectTaskStatus | null>;
    readonly category: Reference<sageX3ProjectManagement.nodes.TaskCategory>;
    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
    readonly keyConcatenation: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly responsiblePerson: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
    readonly sequenceNumber: Promise<string>;
    readonly estimatedProgress: Promise<decimal | null>;
    readonly progressRange: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly progressDate: Promise<date | null>;
    readonly progressMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
    readonly dueDate: Promise<date | null>;
    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
    readonly source: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly operations: Collection<sageX3ProjectManagement.nodes.Operation>;
    readonly products: Collection<sageX3ProjectManagement.nodes.TaskProduct>;
    readonly precedenceLinks: Collection<sageX3ProjectManagement.nodes.TaskPrecedenceLink>;
    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly pjmProject: Reference<sageX3ProjectManagement.nodes.PjmProject>;
    readonly isActive: Promise<boolean>;
    readonly isBudgetCreatedAutomatically: Promise<boolean>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly longComment: Promise<TextStream>;
    readonly longDescription: Promise<TextStream>;
    readonly type: Promise<sageX3MasterData.enums.ProjectAllocationType>;
}
//# sourceMappingURL=task.d.ts.map