"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskProduct = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        task: {
            project: 'project',
            code: 'task',
        },
        site: {
            code: 'site',
        },
        shippingSite: {
            code: 'shippingSite',
        },
        unit: {
            code: 'unit',
        },
        product: {
            code: 'product',
        },
        majorVersion: {
            product: 'product',
            code: 'majorVersion',
        },
        minorVersion: {
            product: 'product',
            majorVersion: 'majorVersion',
            minorVersion: 'minorVersion',
            type() {
                return 'stock';
            },
        },
        bomCode: {
            bomType() {
                return 'manufacturing';
            },
            code: 'bomCode',
        },
        currency: {
            code: 'currency',
        },
        longCommentRef: {
            code() {
                return 'PJMTSKITM';
            },
            identifier1() {
                return 'ITTDESTEX';
            },
            identifier2: 'keyConcatenation',
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
        longDescriptionRef: {
            code() {
                return 'PJMTSKITM';
            },
            identifier1() {
                return 'ITTCOMTEX';
            },
            identifier2: 'keyConcatenation',
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'PJMTSKITM';
            },
            columnName() {
                return 'ITMDES1';
            },
            key1: ['project', 'task', 'lineNumber'],
        },
    },
};
const compositeReferences = {
    longCommentRef: {
        longComment: 'text',
    },
    longDescriptionRef: {
        longDescription: 'text',
    },
};
let TaskProduct = class TaskProduct extends xtrem_core_1.Node {
};
exports.TaskProduct = TaskProduct;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], TaskProduct.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
    })
], TaskProduct.prototype, "task", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITTSEQ',
    })
], TaskProduct.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        isNotEmpty: true,
        columnName: 'KEYCONCAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], TaskProduct.prototype, "keyConcatenation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], TaskProduct.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], TaskProduct.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], TaskProduct.prototype, "unit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TaskProduct.prototype, "requiredQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REQDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], TaskProduct.prototype, "requirementDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], TaskProduct.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ITMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], TaskProduct.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], TaskProduct.prototype, "majorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMIN',
        columnType: 'string',
        filters: {
            lookup: {
                type: 'stock',
            },
            control: {
                type: 'stock',
            },
        },
        node: () => sageX3MasterData.nodes.ProductVersion,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], TaskProduct.prototype, "minorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMALT',
        columnType: 'integer',
        filters: {
            lookup: {
                bomType: 'manufacturing',
            },
            control: {
                bomType: 'manufacturing',
            },
        },
        node: () => sageX3MasterData.nodes.BomCodes,
    })
], TaskProduct.prototype, "bomCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMPLANNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], TaskProduct.prototype, "planNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMPLANVER',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], TaskProduct.prototype, "planVersion", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SALITM',
    })
], TaskProduct.prototype, "isSold", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSMTYP',
        dataType: () => sageX3ProjectManagementData.enums.consumptionModeDatatype,
    })
], TaskProduct.prototype, "consumptionMode", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TaskProduct.prototype, "allocatedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TaskProduct.prototype, "shortageQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLQTYMAN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TaskProduct.prototype, "manualAllocation", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ALLSTA',
        dataType: () => sageX3MasterData.enums.allocationStatusDatatype,
    })
], TaskProduct.prototype, "allocationStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ALLTYP',
        dataType: () => sageX3MasterData.enums.allocationTypeDatatype,
    })
], TaskProduct.prototype, "allocationType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ODLQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TaskProduct.prototype, "inProcessQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TaskProduct.prototype, "deliveredQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVSTA',
        dataType: () => sageX3ProjectManagementData.enums.deliveryStatusDatatype,
    })
], TaskProduct.prototype, "deliveryStatus", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOQQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TaskProduct.prototype, "orderedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WIPNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], TaskProduct.prototype, "workInProgressOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FRCDLTALLFLG',
    })
], TaskProduct.prototype, "closeWip", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDLVFLG',
    })
], TaskProduct.prototype, "isDeliverable", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BUDVLTCOD',
        dataType: () => sageX3ProjectManagementData.enums.budgetMethodDatatype,
    })
], TaskProduct.prototype, "primaryBudgetingMethod", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BUDVLT2',
        dataType: () => sageX3ProjectManagementData.enums.budgetMethodDatatype,
    })
], TaskProduct.prototype, "secondaryBudgetingMethod", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MANUALBUD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TaskProduct.prototype, "manualBudgetAmount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], TaskProduct.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPLDREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], TaskProduct.prototype, "saleableProductLine", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOMGTCOD',
        dataType: () => sageX3MasterData.enums.stockManagementDatatype,
    })
], TaskProduct.prototype, "stockManagement", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMTSKITM',
                identifier1: 'ITTDESTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'PJMTSKITM',
                identifier1: 'ITTDESTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], TaskProduct.prototype, "longCommentRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMTSKITM',
                identifier1: 'ITTCOMTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'PJMTSKITM',
                identifier1: 'ITTCOMTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], TaskProduct.prototype, "longDescriptionRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], TaskProduct.prototype, "longComment", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], TaskProduct.prototype, "longDescription", void 0);
exports.TaskProduct = TaskProduct = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMTSKITM',
        keyPropertyNames: ['project', 'task', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    task: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], TaskProduct);
//# sourceMappingURL=task-product.js.map