"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskPrecedenceLink = void 0;
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        task: {
            project: 'project',
            code: 'task',
        },
        linkedTask: {
            id: 'linkedTask',
        },
    },
};
let TaskPrecedenceLink = class TaskPrecedenceLink extends xtrem_core_1.Node {
};
exports.TaskPrecedenceLink = TaskPrecedenceLink;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], TaskPrecedenceLink.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
    })
], TaskPrecedenceLink.prototype, "task", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SEQNUM',
    })
], TaskPrecedenceLink.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIMOPPTASLNK',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], TaskPrecedenceLink.prototype, "linkedTask", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASLNKTYP',
        dataType: () => sageX3ProjectManagementData.enums.tasksLinkTypeDatatype,
    })
], TaskPrecedenceLink.prototype, "linkType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASLNKCSTR',
        dataType: () => sageX3ProjectManagementData.enums.constraintTypeDatatype,
    })
], TaskPrecedenceLink.prototype, "constraintType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASLNKLAG',
    })
], TaskPrecedenceLink.prototype, "lagDays", void 0);
exports.TaskPrecedenceLink = TaskPrecedenceLink = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMTSKLNK',
        keyPropertyNames: ['project', 'task', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    task: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], TaskPrecedenceLink);
//# sourceMappingURL=task-precedence-link.js.map