"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaleableProduct = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        budget: {
            project: 'project',
            code: 'budget',
        },
        task: {
            project: 'project',
            code: 'task',
        },
        product: {
            code: 'product',
        },
        majorVersion: {
            product: 'product',
            code: 'majorVersion',
        },
        plannedUnit: {
            code: 'plannedUnit',
        },
        salesUnit: {
            code: 'salesUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        currency: {
            code: 'currency',
        },
        sourceOperation: {
            project: 'project',
            task: 'task',
            number: 'sourceOperation',
            firstOperationSplit() {
                return 1;
            },
        },
        sourceProductLine: {
            project: 'project',
            task: 'task',
            lineNumber: 'sourceProductLine',
        },
        sourceBudgetLine: {
            project: 'project',
            budget: 'budget',
            lineNumber: 'sourceBudgetLine',
        },
    },
};
let SaleableProduct = class SaleableProduct extends xtrem_core_1.Node {
};
exports.SaleableProduct = SaleableProduct;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], SaleableProduct.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Budget,
    })
], SaleableProduct.prototype, "budget", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
    })
], SaleableProduct.prototype, "task", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SEQNUM',
    })
], SaleableProduct.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], SaleableProduct.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ITMDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SaleableProduct.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SaleableProduct.prototype, "majorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SaleableProduct.prototype, "minorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SaleableProduct.prototype, "plannedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTUOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SaleableProduct.prototype, "plannedUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SaleableProduct.prototype, "quantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SaleableProduct.prototype, "salesUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SaleableProduct.prototype, "quantityInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SaleableProduct.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], SaleableProduct.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SaleableProduct.prototype, "basePrice", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORI',
        dataType: () => sageX3ProjectManagementData.enums.saleablePrdLineOriginDatatype,
    })
], SaleableProduct.prototype, "origin", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SALAUTGRPLVL',
        dataType: () => sageX3ProjectManagementData.enums.soldProductsLinePrdGrpLvlDatatype,
    })
], SaleableProduct.prototype, "initialGrouping", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRODGRPLVL',
        dataType: () => sageX3ProjectManagementData.enums.soldProductsLinePrdGrpLvlDatatype,
    })
], SaleableProduct.prototype, "productGroupingLevel", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPENUM',
        columnType: 'integer',
        filters: {
            lookup: {
                firstOperationSplit: 1,
            },
            control: {
                firstOperationSplit: 1,
            },
        },
        node: () => sageX3ProjectManagement.nodes.Operation,
    })
], SaleableProduct.prototype, "sourceOperation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITTSEQ',
        columnType: 'integer',
        node: () => sageX3ProjectManagement.nodes.TaskProduct,
    })
], SaleableProduct.prototype, "sourceProductLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBSEQ',
        columnType: 'integer',
        node: () => sageX3ProjectManagement.nodes.BudgetLine,
    })
], SaleableProduct.prototype, "sourceBudgetLine", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'LINORIID',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SaleableProduct.prototype, "lineOrigin", void 0);
exports.SaleableProduct = SaleableProduct = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMSALITMD',
        keyPropertyNames: ['project', 'budget', 'task', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    budget: 1,
                    task: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['budget', 'task'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SaleableProduct);
//# sourceMappingURL=saleable-product.js.map