"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Project = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        category: {
            glossaryId() {
                return 434;
            },
            code: 'category',
        },
        salesRepresentative: {
            code: 'salesRepresentative',
        },
        customer: {
            code: 'customer',
        },
        contact: {
            code: 'contact',
        },
        currency: {
            code: 'currency',
        },
        site: {
            code: 'site',
        },
        projectLink: {
            id: 'id',
        },
        pjmProject: {
            project: 'id',
        },
        longCommentRef: {
            code() {
                return 'OPPORPJM';
            },
            identifier1() {
                return 'OPPCOMTEX';
            },
            identifier2: 'id',
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
        longDescriptionRef: {
            code() {
                return 'OPPORPJM';
            },
            identifier1() {
                return 'OPPDESTEX';
            },
            identifier2: 'id',
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
    },
    collectionJoins: {
        employees: {
            project: 'id',
        },
        tasks: {
            project: 'id',
        },
        budgets: {
            project: 'id',
        },
    },
};
const compositeReferences = {
    pjmProject: {
        accountingCode: 'accountingCode',
        billingMode: 'billingMode',
        closingDate: 'closingDate',
        deliveryDate: 'deliveryDate',
        dimensions: 'dimensions',
        dueDate: 'dueDate',
        duration: 'duration',
        endDate: 'endDate',
        estimatedProgressPercentage: 'estimatedProgressPercentage',
        estimatedRevenueAtCompletion: 'estimatedRevenueAtCompletion',
        isBudgetCreatedAutomatically: 'isBudgetCreatedAutomatically',
        isIndirectCostCalculated: 'isIndirectCostCalculated',
        isIntermediateLevelBudgetingAllowed: 'isIntermediateLevelBudgetingAllowed',
        isInternal: 'isInternal',
        isProvisional: 'isProvisional',
        isTemplate: 'isTemplate',
        launchingDate: 'launchingDate',
        operatingSite: 'operatingSite',
        overviewCurrency: 'overviewCurrency',
        progressEstimationDate: 'progressEstimationDate',
        progressEstimationMethod: 'progressEstimationMethod',
        progressRange: 'progressRange',
        projectStatus: 'projectStatus',
        responsiblePerson: 'responsiblePerson',
        revenueEstimationDate: 'revenueEstimationDate',
        revenueEstimationMethod: 'revenueEstimationMethod',
        revenueRecognitionExtractionMethod: 'revenueRecognitionExtractionMethod',
        revenueRecognitionRule: 'revenueRecognitionRule',
        source: 'source',
        startDate: 'startDate',
        suspensionDate: 'suspensionDate',
    },
    projectLink: {
        isActive: 'isActive',
        localizedDescription: 'localizedDescription',
        localizedShortDescription: 'localizedShortDescription',
        type: 'type',
    },
    longCommentRef: {
        longComment: 'text',
    },
    longDescriptionRef: {
        longDescription: 'text',
    },
};
let Project = class Project extends xtrem_core_1.Node {
};
exports.Project = Project;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'OPPNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Project.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPTYP',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 434,
            },
            control: {
                glossaryId: 434,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], Project.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPEXTNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Project.prototype, "externalIdentifier", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPCLO',
    })
], Project.prototype, "isClosed", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPREP',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
    })
], Project.prototype, "salesRepresentative", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHGTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], Project.prototype, "rateType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPCMP',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], Project.prototype, "customer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPMCN',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ContactRelationship,
    })
], Project.prototype, "contact", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], Project.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SALFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], Project.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPCMGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Project.prototype, "marketingCampaign", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPOPGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Project.prototype, "marketingOperation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPOPGTYP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Project.prototype, "marketingOperationType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPORI',
        dataType: () => sageX3MasterData.enums.projectOriginsDatatype,
    })
], Project.prototype, "origin", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPORIVCR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Project.prototype, "originalDocument", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPORIVCRL',
    })
], Project.prototype, "originalDocumentLine", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CREHOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Project.prototype, "creationTime", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPORITYP',
        dataType: () => sageX3MasterData.enums.originTypeDatatype,
    })
], Project.prototype, "originalMethod", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPDATOPN',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "openingDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.ProjectAssignment,
        isMutable: true,
        dependsOn: ['id'],
    })
], Project.prototype, "employees", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], Project.prototype, "projectLink", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.PjmProject,
    })
], Project.prototype, "pjmProject", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.Task,
        dependsOn: ['id'],
    })
], Project.prototype, "tasks", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.Budget,
        dependsOn: ['id'],
    })
], Project.prototype, "budgets", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'OPPORPJM',
                identifier1: 'OPPCOMTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'OPPORPJM',
                identifier1: 'OPPCOMTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], Project.prototype, "longCommentRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'OPPORPJM',
                identifier1: 'OPPDESTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'OPPORPJM',
                identifier1: 'OPPDESTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], Project.prototype, "longDescriptionRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCCOD',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.AccountingCode,
    })
], Project.prototype, "accountingCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PROBIL',
        dataType: () => sageX3ProjectManagementData.enums.billingModeDatatype,
    })
], Project.prototype, "billingMode", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDATS',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "closingDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDATLV',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "deliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.PjmProjectDimensions,
        isMutable: true,
    })
], Project.prototype, "dimensions", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DUEDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "dueDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDUR',
    })
], Project.prototype, "duration", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Project.prototype, "estimatedProgressPercentage", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EREVCOM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Project.prototype, "estimatedRevenueAtCompletion", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMSTA',
    })
], Project.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASBUDAUT',
    })
], Project.prototype, "isBudgetCreatedAutomatically", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPPROACTIV',
    })
], Project.prototype, "isIndirectCostCalculated", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPIMPT',
    })
], Project.prototype, "isIntermediateLevelBudgetingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPINT',
    })
], Project.prototype, "isInternal", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPFRT',
    })
], Project.prototype, "isProvisional", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPMOD',
    })
], Project.prototype, "isTemplate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDATLA',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "launchingDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Project.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMDESAX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Project.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], Project.prototype, "longComment", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], Project.prototype, "longDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPEDEFFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], Project.prototype, "operatingSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUROPP',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], Project.prototype, "overviewCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "progressEstimationDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCCPLMET',
        dataType: () => sageX3ProjectManagementData.enums.estimationMethodUsedDatatype,
    })
], Project.prototype, "progressEstimationMethod", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLADI',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], Project.prototype, "progressRange", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPSTATE',
        dataType: () => sageX3ProjectManagementData.enums.projectStatusDatatype,
    })
], Project.prototype, "projectStatus", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RPBAUS',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
    })
], Project.prototype, "responsiblePerson", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EREVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "revenueEstimationDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EREVMET',
        dataType: () => sageX3ProjectManagementData.enums.estimationMethodUsedDatatype,
    })
], Project.prototype, "revenueEstimationMethod", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RRCCFINSYN',
        dataType: () => sageX3ProjectManagementData.enums.calculationMethodUsedDatatype,
    })
], Project.prototype, "revenueRecognitionExtractionMethod", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RRCC',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.RevenueRecognitionRules,
        serviceOptions: () => [sageX3System.serviceOptions.RevrcActivityCode],
    })
], Project.prototype, "revenueRecognitionRule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIOPP',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], Project.prototype, "source", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDATTH',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Project.prototype, "suspensionDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMTYP',
        dataType: () => sageX3MasterData.enums.projectAllocationTypeDatatype,
    })
], Project.prototype, "type", void 0);
exports.Project = Project = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'OPPOR',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        getFilters() {
            return [{ type: { _in: ['project', 'mixedProject'] } }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
        canUpdate: true,
        canDelete: true,
        canDeleteMany: true,
    })
], Project);
//# sourceMappingURL=project.js.map