import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, Collection, decimal, TextStream } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class Project extends Node {
    readonly id: Promise<string>;
    readonly category: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly externalIdentifier: Promise<string>;
    readonly isClosed: Promise<boolean>;
    readonly salesRepresentative: Reference<sageX3MasterData.nodes.SalesRep | null>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType>;
    readonly customer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly contact: Reference<sageX3MasterData.nodes.ContactRelationship | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly site: Reference<sageX3System.nodes.Site | null>;
    readonly marketingCampaign: Promise<string>;
    readonly marketingOperation: Promise<string>;
    readonly marketingOperationType: Promise<string>;
    readonly origin: Promise<sageX3MasterData.enums.ProjectOrigins | null>;
    readonly originalDocument: Promise<string>;
    readonly originalDocumentLine: Promise<integer | null>;
    readonly creationTime: Promise<string>;
    readonly originalMethod: Promise<sageX3MasterData.enums.OriginType | null>;
    readonly openingDate: Promise<date>;
    readonly employees: Collection<sageX3ProjectManagement.nodes.ProjectAssignment>;
    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
    readonly pjmProject: Reference<sageX3ProjectManagement.nodes.PjmProject>;
    readonly tasks: Collection<sageX3ProjectManagement.nodes.Task>;
    readonly budgets: Collection<sageX3ProjectManagement.nodes.Budget>;
    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
    readonly closingDate: Promise<date | null>;
    readonly deliveryDate: Promise<date | null>;
    readonly dimensions: Collection<sageX3ProjectManagement.nodes.PjmProjectDimensions>;
    readonly dueDate: Promise<date | null>;
    readonly duration: Promise<integer | null>;
    readonly endDate: Promise<date | null>;
    readonly estimatedProgressPercentage: Promise<decimal | null>;
    readonly estimatedRevenueAtCompletion: Promise<decimal | null>;
    readonly isActive: Promise<boolean>;
    readonly isBudgetCreatedAutomatically: Promise<boolean>;
    readonly isIndirectCostCalculated: Promise<boolean>;
    readonly isIntermediateLevelBudgetingAllowed: Promise<boolean>;
    readonly isInternal: Promise<boolean>;
    readonly isProvisional: Promise<boolean>;
    readonly isTemplate: Promise<boolean>;
    readonly launchingDate: Promise<date | null>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly longComment: Promise<TextStream>;
    readonly longDescription: Promise<TextStream>;
    readonly operatingSite: Reference<sageX3System.nodes.Site>;
    readonly overviewCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
    readonly progressEstimationDate: Promise<date | null>;
    readonly progressEstimationMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
    readonly progressRange: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly projectStatus: Promise<sageX3ProjectManagementData.enums.ProjectStatus | null>;
    readonly responsiblePerson: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
    readonly revenueEstimationDate: Promise<date | null>;
    readonly revenueEstimationMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
    readonly revenueRecognitionExtractionMethod: Promise<sageX3ProjectManagementData.enums.CalculationMethodUsed>;
    readonly revenueRecognitionRule: Reference<sageX3FinanceData.nodes.RevenueRecognitionRules | null>;
    readonly source: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly startDate: Promise<date | null>;
    readonly suspensionDate: Promise<date | null>;
    readonly type: Promise<sageX3MasterData.enums.ProjectAllocationType>;
}
//# sourceMappingURL=project.d.ts.map