"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectUser = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        employee: {
            code: 'employee',
        },
        role: {
            glossaryId() {
                return 639;
            },
            code: 'role',
        },
        currency: {
            code: 'currency',
        },
        costType: {
            code: 'costType',
        },
        weeklyStructure: {
            code: 'weeklyStructure',
        },
        site: {
            code: 'site',
        },
        timeCategory: {
            code: 'timeCategory',
        },
    },
    collectionJoins: {
        lines: {
            employee: 'employee',
        },
    },
};
let ProjectUser = class ProjectUser extends xtrem_core_1.Node {
};
exports.ProjectUser = ProjectUser;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAUS',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], ProjectUser.prototype, "employee", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAUSROL',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 639,
            },
            control: {
                glossaryId: 639,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ProjectUser.prototype, "role", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAUSTT',
    })
], ProjectUser.prototype, "isTimeEntryEmployee", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAUSPA',
    })
], ProjectUser.prototype, "isTimeEntryAdministrator", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAUSCST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectUser.prototype, "hourlyRate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAUSCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], ProjectUser.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCCCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.CostType,
    })
], ProjectUser.prototype, "costType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAREC',
    })
], ProjectUser.prototype, "isActiveEmployeeOnProjects", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TWD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.WeeklyStructure,
    })
], ProjectUser.prototype, "weeklyStructure", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCYDEF',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], ProjectUser.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTETYP',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TimeCategory,
    })
], ProjectUser.prototype, "timeCategory", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.ProjectUserCapacityVariation,
        dependsOn: ['employee'],
    })
], ProjectUser.prototype, "lines", void 0);
exports.ProjectUser = ProjectUser = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMAUS',
        keyPropertyNames: ['employee'],
        indexes: [
            {
                orderBy: {
                    employee: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ProjectUser);
//# sourceMappingURL=project-user.js.map