"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectUserCapacityVariation = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        employee: {
            employee: 'employee',
        },
        reason: {
            glossaryId() {
                return 641;
            },
            code: 'reason',
        },
        weeklyStructure: {
            code: 'weeklyStructure',
        },
    },
};
let ProjectUserCapacityVariation = class ProjectUserCapacityVariation extends xtrem_core_1.Node {
};
exports.ProjectUserCapacityVariation = ProjectUserCapacityVariation;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAUS',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
    })
], ProjectUserCapacityVariation.prototype, "employee", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAUSSEQ',
    })
], ProjectUserCapacityVariation.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectUserCapacityVariation.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectUserCapacityVariation.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CODVAR',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 641,
            },
            control: {
                glossaryId: 641,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ProjectUserCapacityVariation.prototype, "reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VARTWD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.WeeklyStructure,
    })
], ProjectUserCapacityVariation.prototype, "weeklyStructure", void 0);
exports.ProjectUserCapacityVariation = ProjectUserCapacityVariation = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMAUSCAVA',
        keyPropertyNames: ['employee', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    employee: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ProjectUserCapacityVariation);
//# sourceMappingURL=project-user-capacity-variation.js.map