"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectAssignment = void 0;
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        employee: {
            employee: 'employee',
        },
        role: {
            glossaryId() {
                return 639;
            },
            code: 'role',
        },
    },
};
let ProjectAssignment = class ProjectAssignment extends xtrem_core_1.Node {
};
exports.ProjectAssignment = ProjectAssignment;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], ProjectAssignment.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PAFCLB',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
    })
], ProjectAssignment.prototype, "employee", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAFROL',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 639,
            },
            control: {
                glossaryId: 639,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ProjectAssignment.prototype, "role", void 0);
exports.ProjectAssignment = ProjectAssignment = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMAFF',
        keyPropertyNames: ['project', 'employee'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    employee: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ProjectAssignment);
//# sourceMappingURL=project-assignment.js.map