"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PjmProject = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        overviewCurrency: {
            code: 'overviewCurrency',
        },
        operatingSite: {
            code: 'operatingSite',
        },
        responsiblePerson: {
            employee: 'responsiblePerson',
        },
        revenueRecognitionRule: {
            company: 'project.site.company.code',
            code: 'revenueRecognitionRule',
        },
        accountingCode: {
            type() {
                return 'project';
            },
            accountingCode: 'accountingCode',
        },
        progressRange: {
            glossaryId() {
                return 385;
            },
            code: 'progressRange',
        },
        source: {
            id: 'source',
        },
    },
};
let PjmProject = class PjmProject extends xtrem_core_1.Node {
};
exports.PjmProject = PjmProject;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], PjmProject.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPINT',
    })
], PjmProject.prototype, "isInternal", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPFRT',
    })
], PjmProject.prototype, "isProvisional", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPSTATE',
        dataType: () => sageX3ProjectManagementData.enums.projectStatusDatatype,
    })
], PjmProject.prototype, "projectStatus", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDATTH',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PjmProject.prototype, "suspensionDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDATLV',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PjmProject.prototype, "deliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDATS',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PjmProject.prototype, "closingDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDATLA',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PjmProject.prototype, "launchingDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPPROACTIV',
    })
], PjmProject.prototype, "isIndirectCostCalculated", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUROPP',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PjmProject.prototype, "overviewCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPIMPT',
    })
], PjmProject.prototype, "isIntermediateLevelBudgetingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPEDEFFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PjmProject.prototype, "operatingSite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPMOD',
    })
], PjmProject.prototype, "isTemplate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASBUDAUT',
    })
], PjmProject.prototype, "isBudgetCreatedAutomatically", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PjmProject.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PjmProject.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DUEDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PjmProject.prototype, "dueDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPDUR',
    })
], PjmProject.prototype, "duration", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RPBAUS',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
    })
], PjmProject.prototype, "responsiblePerson", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RRCC',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.RevenueRecognitionRules,
        serviceOptions: () => [sageX3System.serviceOptions.RevrcActivityCode],
    })
], PjmProject.prototype, "revenueRecognitionRule", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EREVCOM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PjmProject.prototype, "estimatedRevenueAtCompletion", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EREVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PjmProject.prototype, "revenueEstimationDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EREVMET',
        dataType: () => sageX3ProjectManagementData.enums.estimationMethodUsedDatatype,
    })
], PjmProject.prototype, "revenueEstimationMethod", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RRCCFINSYN',
        dataType: () => sageX3ProjectManagementData.enums.calculationMethodUsedDatatype,
    })
], PjmProject.prototype, "revenueRecognitionExtractionMethod", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCCOD',
        columnType: 'string',
        filters: {
            lookup: {
                type: 'project',
            },
            control: {
                type: 'project',
            },
        },
        node: () => sageX3FinanceData.nodes.AccountingCode,
    })
], PjmProject.prototype, "accountingCode", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PjmProject.prototype, "estimatedProgressPercentage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLADI',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 385,
            },
            control: {
                glossaryId: 385,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], PjmProject.prototype, "progressRange", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PjmProject.prototype, "progressEstimationDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCCPLMET',
        dataType: () => sageX3ProjectManagementData.enums.estimationMethodUsedDatatype,
    })
], PjmProject.prototype, "progressEstimationMethod", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PROBIL',
        dataType: () => sageX3ProjectManagementData.enums.billingModeDatatype,
    })
], PjmProject.prototype, "billingMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIOPP',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], PjmProject.prototype, "source", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3ProjectManagement.nodes.PjmProjectDimensions,
    })
], PjmProject.prototype, "dimensions", void 0);
exports.PjmProject = PjmProject = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'OPPORPJM',
        keyPropertyNames: ['project'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        canRead: true,
        canSearch: true,
    })
], PjmProject);
//# sourceMappingURL=pjm-project.js.map