"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Operation = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        task: {
            project: 'project',
            code: 'task',
        },
        site: {
            code: 'site',
        },
        workCenterLaborResource1: {
            code: 'workCenterLaborResource1',
            manufacturingSite: 'site',
        },
        workCenterLaborResource2: {
            code: 'workCenterLaborResource2',
            manufacturingSite: 'site',
        },
        currency: {
            code: 'currency',
        },
        unit: {
            code: 'unit',
        },
        timeCategory: {
            code: 'timeCategory',
        },
        longDescriptionRef: {
            code() {
                return 'PJMTSKOPE';
            },
            identifier1() {
                return 'OPEDESTEX';
            },
            async identifier2() {
                return (typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add((await this.project), '~'), (await (await this.task).code)), '~'), (await this.number)), '~'), (await this.firstOperationSplit)));
            },
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
        longCommentRef: {
            code() {
                return 'PJMTSKOPE';
            },
            identifier1() {
                return 'OPECOMTEX';
            },
            async identifier2() {
                return (typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add((await this.project), '~'), (await (await this.task).code)), '~'), (await this.number)), '~'), (await this.firstOperationSplit)));
            },
            identifier3() {
                return null;
            },
            identifier4() {
                return null;
            },
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'PJMTSKOPE';
            },
            columnName() {
                return 'ROODESAXX';
            },
            key1: ['project', 'task', 'number', 'firstOperationSplit'],
        },
    },
    collectionJoins: {
        assignments: {
            project: 'project',
            task: 'task',
            operation: 'number',
            firstOperationSplit: 'firstOperationSplit',
        },
        precedenceLinks: {
            project: 'project',
            task: 'task',
            operation: 'number',
            firstOperationSplit: 'firstOperationSplit',
        },
    },
};
const compositeReferences = {
    longCommentRef: {
        longComment: 'text',
    },
    longDescriptionRef: {
        longDescription: 'text',
    },
};
let Operation = class Operation extends xtrem_core_1.Node {
};
exports.Operation = Operation;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], Operation.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
    })
], Operation.prototype, "task", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPENUM',
    })
], Operation.prototype, "number", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESPLNUM',
    })
], Operation.prototype, "firstOperationSplit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], Operation.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXTWST',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], Operation.prototype, "workCenterLaborResource1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTLAB',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], Operation.prototype, "workCenterLaborResource2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], Operation.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPESTA',
        dataType: () => sageX3ManufacturingData.enums.operationStatusDatatype,
    })
], Operation.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESTR',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Operation.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPEEND',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Operation.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPEDUR',
    })
], Operation.prototype, "duration", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ROODESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Operation.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPEUOM2',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], Operation.prototype, "unit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTWSTNBR',
    })
], Operation.prototype, "numberOfResource1", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTLABNBR',
    })
], Operation.prototype, "numberOfResource2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Operation.prototype, "plannedLoad", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CSMQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Operation.prototype, "consumedLoad", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RMNQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Operation.prototype, "remainingLoad", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPECST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Operation.prototype, "hourlyRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPECST2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Operation.prototype, "laborRate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESTARTDT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Operation.prototype, "actualStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPEENDDT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Operation.prototype, "actualEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPEDATS',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Operation.prototype, "closingDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPEDATH',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Operation.prototype, "suspensionDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTETYP',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TimeCategory,
    })
], Operation.prototype, "timeCategory", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPLDREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Operation.prototype, "saleableProductLine", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.OperationAssignment,
        isMutable: true,
        dependsOn: ['project', 'task', 'number', 'firstOperationSplit'],
    })
], Operation.prototype, "assignments", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.OperationPrecedenceLink,
        isMutable: true,
        dependsOn: ['project', 'task', 'number', 'firstOperationSplit'],
    })
], Operation.prototype, "precedenceLinks", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMTSKOPE',
                identifier1: 'OPEDESTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'PJMTSKOPE',
                identifier1: 'OPEDESTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], Operation.prototype, "longDescriptionRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMTSKOPE',
                identifier1: 'OPECOMTEX',
                identifier3: null,
                identifier4: null,
            },
            control: {
                code: 'PJMTSKOPE',
                identifier1: 'OPECOMTEX',
                identifier3: null,
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], Operation.prototype, "longCommentRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], Operation.prototype, "longComment", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], Operation.prototype, "longDescription", void 0);
exports.Operation = Operation = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMTSKOPE',
        keyPropertyNames: ['project', 'task', 'number', 'firstOperationSplit'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    task: 1,
                    number: 1,
                    firstOperationSplit: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['firstOperationSplit'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Operation);
//# sourceMappingURL=operation.js.map